"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from .dictionarymetadata import DictionaryMetadata, DictionaryMetadataTypedDict
from .pronunciationoverride import PronunciationOverride, PronunciationOverrideTypedDict
from .voicedisplayinfo import VoiceDisplayInfo, VoiceDisplayInfoTypedDict
from syllable_sdk.types import BaseModel
from typing import Dict, List, Optional
from typing_extensions import NotRequired, TypedDict


class PronunciationOverridesDictionaryTypedDict(TypedDict):
    r"""Container for all TTS pronunciation overrides belonging to the sub-organisation.

    Stored in the `config_values` table via ConfigDao. The Syllable API persists uploaded CSV
    pronunciation rules, and Bubblegum's PronunciationOverridesPlugin reads them to apply text
    replacements before TTS processing.

    Example:
    dao = ConfigDao(db_session)
    await dao.register_model('tts.pronunciations', PronunciationOverridesDictionary)

    pod = PronunciationOverridesDictionary(
    pronunciations=[...],
    metadata=DictionaryMetadata(entries=10, hash='sha256:...'),
    )
    result = await dao.upsert('pronunciations_v1', pod)

    record = await dao.get('pronunciations_v1', PronunciationOverridesDictionary)
    if record:
    pronunciations = record.value.pronunciations
    """

    pronunciations: List[PronunciationOverrideTypedDict]
    metadata: DictionaryMetadataTypedDict
    r"""Audit metadata associated with a dictionary."""
    type: NotRequired[str]
    voices: NotRequired[Dict[str, VoiceDisplayInfoTypedDict]]


class PronunciationOverridesDictionary(BaseModel):
    r"""Container for all TTS pronunciation overrides belonging to the sub-organisation.

    Stored in the `config_values` table via ConfigDao. The Syllable API persists uploaded CSV
    pronunciation rules, and Bubblegum's PronunciationOverridesPlugin reads them to apply text
    replacements before TTS processing.

    Example:
    dao = ConfigDao(db_session)
    await dao.register_model('tts.pronunciations', PronunciationOverridesDictionary)

    pod = PronunciationOverridesDictionary(
    pronunciations=[...],
    metadata=DictionaryMetadata(entries=10, hash='sha256:...'),
    )
    result = await dao.upsert('pronunciations_v1', pod)

    record = await dao.get('pronunciations_v1', PronunciationOverridesDictionary)
    if record:
    pronunciations = record.value.pronunciations
    """

    pronunciations: List[PronunciationOverride]

    metadata: DictionaryMetadata
    r"""Audit metadata associated with a dictionary."""

    type: Optional[str] = "pronunciations_v1"

    voices: Optional[Dict[str, VoiceDisplayInfo]] = None
