"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from pydantic import model_serializer
from syllable_sdk.types import (
    BaseModel,
    Nullable,
    OptionalNullable,
    UNSET,
    UNSET_SENTINEL,
)
from syllable_sdk.utils import FieldMetadata, PathParamMetadata, QueryParamMetadata
from typing_extensions import Annotated, NotRequired, TypedDict


class RolesDeleteRequestTypedDict(TypedDict):
    role_id: int
    r"""The ID of the role to delete"""
    reason: str
    r"""The reason for deleting the role"""
    new_role_id: NotRequired[Nullable[int]]
    r"""Users with the deleted role will be reassigned to the new role, if a new role ID is provided"""


class RolesDeleteRequest(BaseModel):
    role_id: Annotated[
        int, FieldMetadata(path=PathParamMetadata(style="simple", explode=False))
    ]
    r"""The ID of the role to delete"""

    reason: Annotated[
        str, FieldMetadata(query=QueryParamMetadata(style="form", explode=True))
    ]
    r"""The reason for deleting the role"""

    new_role_id: Annotated[
        OptionalNullable[int],
        FieldMetadata(query=QueryParamMetadata(style="form", explode=True)),
    ] = UNSET
    r"""Users with the deleted role will be reassigned to the new role, if a new role ID is provided"""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = ["new_role_id"]
        nullable_fields = ["new_role_id"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m
