"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from .toolauthtype import ToolAuthType
from datetime import datetime
from pydantic import model_serializer
from syllable_sdk.types import (
    BaseModel,
    Nullable,
    OptionalNullable,
    UNSET,
    UNSET_SENTINEL,
)
from typing import List
from typing_extensions import NotRequired, TypedDict


class ServiceResponseTypedDict(TypedDict):
    r"""Response model for service operations. A service is a collection of tools."""

    id: int
    r"""The internal ID of the service"""
    name: str
    r"""The name of the service"""
    description: str
    r"""The description of the service"""
    last_updated: datetime
    r"""The timestamp of the most recent update to the service"""
    last_updated_by: str
    r"""The email of the user who last updated the service"""
    tools: List[str]
    r"""Names of tools that belong to the service"""
    auth_type: NotRequired[Nullable[ToolAuthType]]
    r"""The type of authentication to use for the service's tools"""
    auth_value_keys: NotRequired[Nullable[List[str]]]
    r"""Auth value keys (values omitted for security)"""
    last_updated_comments: NotRequired[Nullable[str]]
    r"""Free text providing comment about what was updated"""


class ServiceResponse(BaseModel):
    r"""Response model for service operations. A service is a collection of tools."""

    id: int
    r"""The internal ID of the service"""

    name: str
    r"""The name of the service"""

    description: str
    r"""The description of the service"""

    last_updated: datetime
    r"""The timestamp of the most recent update to the service"""

    last_updated_by: str
    r"""The email of the user who last updated the service"""

    tools: List[str]
    r"""Names of tools that belong to the service"""

    auth_type: OptionalNullable[ToolAuthType] = UNSET
    r"""The type of authentication to use for the service's tools"""

    auth_value_keys: OptionalNullable[List[str]] = UNSET
    r"""Auth value keys (values omitted for security)"""

    last_updated_comments: OptionalNullable[str] = UNSET
    r"""Free text providing comment about what was updated"""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = ["auth_type", "auth_value_keys", "last_updated_comments"]
        nullable_fields = ["auth_type", "auth_value_keys", "last_updated_comments"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m
