"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
import pydantic
from pydantic import model_serializer
from syllable_sdk.types import (
    BaseModel,
    Nullable,
    OptionalNullable,
    UNSET,
    UNSET_SENTINEL,
)
from typing import Optional
from typing_extensions import Annotated, NotRequired, TypedDict


class TestMessageTypedDict(TypedDict):
    r"""Message sent in a test chat with an agent."""

    __test__ = False  # pyright: ignore[reportGeneralTypeIssues]

    service_name: str
    r"""Name of the service producing the message"""
    source: str
    r"""Name of the source of the message - identifies the user, like an email or username."""
    test_id: str
    r"""Channel-manager-side ID of the session (see Session.channel_manager_sid)"""
    agent_id: str
    r"""ID of the agent with which the chat is taking place"""
    text: NotRequired[Nullable[str]]
    r"""The text of the message"""
    org_name: NotRequired[Nullable[str]]
    r"""Unused: Name of the organization associated with the agent"""
    override_timestamp: NotRequired[Nullable[str]]
    r"""Override for the timestamp of the message"""
    session_start: NotRequired[bool]
    r"""Whether this message is the start of a new session"""


class TestMessage(BaseModel):
    r"""Message sent in a test chat with an agent."""

    __test__ = False

    service_name: str
    r"""Name of the service producing the message"""

    source: str
    r"""Name of the source of the message - identifies the user, like an email or username."""

    test_id: str
    r"""Channel-manager-side ID of the session (see Session.channel_manager_sid)"""

    agent_id: str
    r"""ID of the agent with which the chat is taking place"""

    text: OptionalNullable[str] = UNSET
    r"""The text of the message"""

    org_name: Annotated[
        OptionalNullable[str],
        pydantic.Field(
            deprecated="warning: ** DEPRECATED ** - This will be removed in a future release, please migrate away from it as soon as possible."
        ),
    ] = UNSET
    r"""Unused: Name of the organization associated with the agent"""

    override_timestamp: OptionalNullable[str] = UNSET
    r"""Override for the timestamp of the message"""

    session_start: Optional[bool] = False
    r"""Whether this message is the start of a new session"""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = ["text", "org_name", "override_timestamp", "session_start"]
        nullable_fields = ["text", "org_name", "override_timestamp"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m
