"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from .toolparametertransformcondition import (
    ToolParameterTransformCondition,
    ToolParameterTransformConditionTypedDict,
)
from enum import Enum
import pydantic
from pydantic import model_serializer
from syllable_sdk.types import (
    BaseModel,
    Nullable,
    OptionalNullable,
    UNSET,
    UNSET_SENTINEL,
)
from typing import Any, Optional
from typing_extensions import Annotated, NotRequired, TypedDict


class Action(str, Enum):
    r"""The action to perform on the tool parameter value: `default` means only set the value (using the `format` field) if the parameter doesn't exist or is empty, `override` means always set the value,\" and `remove` means \"remove the parameter value.\" """

    DEFAULT = "default"
    OVERRIDE = "override"
    REMOVE = "remove"


class ToolParameterTransformTypedDict(TypedDict):
    r"""A transform to be applied to the value of a tool parameter.

    Either `value` or `format` must be set:
    - `value` is any arbitrary value: string, list or dictionary.
    - `format` is a string composed of other parameters or context variables.
    """

    action: NotRequired[Action]
    r"""The action to perform on the tool parameter value: `default` means only set the value (using the `format` field) if the parameter doesn't exist or is empty, `override` means always set the value,\" and `remove` means \"remove the parameter value.\" """
    when: NotRequired[Nullable[ToolParameterTransformConditionTypedDict]]
    r"""Only apply the transform if the condition is met."""
    value: NotRequired[Nullable[Any]]
    r"""The default value to use for the parameter."""
    format_: NotRequired[Nullable[str]]
    r"""The string value to use for the parameter. The value will be evaluated with the Python `str.format` method, for example, `Hello, {name}!`"""


class ToolParameterTransform(BaseModel):
    r"""A transform to be applied to the value of a tool parameter.

    Either `value` or `format` must be set:
    - `value` is any arbitrary value: string, list or dictionary.
    - `format` is a string composed of other parameters or context variables.
    """

    action: Optional[Action] = Action.DEFAULT
    r"""The action to perform on the tool parameter value: `default` means only set the value (using the `format` field) if the parameter doesn't exist or is empty, `override` means always set the value,\" and `remove` means \"remove the parameter value.\" """

    when: OptionalNullable[ToolParameterTransformCondition] = UNSET
    r"""Only apply the transform if the condition is met."""

    value: OptionalNullable[Any] = UNSET
    r"""The default value to use for the parameter."""

    format_: Annotated[OptionalNullable[str], pydantic.Field(alias="format")] = UNSET
    r"""The string value to use for the parameter. The value will be evaluated with the Python `str.format` method, for example, `Hello, {name}!`"""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = ["action", "when", "value", "format"]
        nullable_fields = ["when", "value", "format"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m
