"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
import pydantic
from pydantic import model_serializer
from pydantic.functional_validators import AfterValidator
from syllable_sdk.types import BaseModel, Nullable, OptionalNullable, UNSET_SENTINEL
from syllable_sdk.utils import validate_const
from typing import Literal
from typing_extensions import Annotated, TypedDict


class ToolParameterTransformConditionTypedDict(TypedDict):
    r"""A condition to be met for a transform to be applied to the value of a tool parameter."""

    key: str
    r"""The name of the parameter to check."""
    value: str
    r"""The value to check against the parameter."""
    operator: Nullable[Literal["eq"]]
    r"""The operator to use for the comparison. Currently only supports \"eq\" """


class ToolParameterTransformCondition(BaseModel):
    r"""A condition to be met for a transform to be applied to the value of a tool parameter."""

    key: str
    r"""The name of the parameter to check."""

    value: str
    r"""The value to check against the parameter."""

    OPERATOR: Annotated[
        Annotated[
            OptionalNullable[Literal["eq"]], AfterValidator(validate_const("eq"))
        ],
        pydantic.Field(alias="operator"),
    ] = "eq"
    r"""The operator to use for the comparison. Currently only supports \"eq\" """

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = ["operator"]
        nullable_fields = ["operator"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m
