"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from .twiliochannelconfigupdate import (
    TwilioChannelConfigUpdate,
    TwilioChannelConfigUpdateTypedDict,
)
from pydantic import model_serializer
from syllable_sdk.types import (
    BaseModel,
    Nullable,
    OptionalNullable,
    UNSET,
    UNSET_SENTINEL,
)
from typing_extensions import NotRequired, TypedDict


class TwilioChannelUpdateRequestTypedDict(TypedDict):
    r"""Request model for updating a Twilio channel."""

    id: int
    r"""The internal ID of the channel"""
    name: NotRequired[Nullable[str]]
    r"""The name of the channel"""
    config: NotRequired[Nullable[TwilioChannelConfigUpdateTypedDict]]
    r"""The configuration of the channel"""


class TwilioChannelUpdateRequest(BaseModel):
    r"""Request model for updating a Twilio channel."""

    id: int
    r"""The internal ID of the channel"""

    name: OptionalNullable[str] = UNSET
    r"""The name of the channel"""

    config: OptionalNullable[TwilioChannelConfigUpdate] = UNSET
    r"""The configuration of the channel"""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = ["name", "config"]
        nullable_fields = ["name", "config"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m
