# Generated by Django 5.2.6 on 2025-09-23 11:53

import django.db.models.deletion
from django.conf import settings
from django.db import migrations, models


def create_legal_consents_for_existing_users(apps, schema_editor):
    """Create LegalConsent objects for all existing users."""
    User = apps.get_model(settings.AUTH_USER_MODEL)
    LegalConsent = apps.get_model("legal_consent", "LegalConsent")

    for user in User.objects.all():
        LegalConsent.objects.create(user=user)


def reverse_create_legal_consents(apps, schema_editor):
    """Remove all LegalConsent objects."""
    LegalConsent = apps.get_model("legal_consent", "LegalConsent")
    LegalConsent.objects.all().delete()


class Migration(migrations.Migration):
    initial = True

    dependencies = [
        migrations.swappable_dependency(settings.AUTH_USER_MODEL),
    ]

    operations = [
        migrations.CreateModel(
            name="LegalConsent",
            fields=[
                (
                    "id",
                    models.BigAutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                (
                    "version",
                    models.IntegerField(
                        blank=True,
                        help_text="Version of the consented legal documents",
                        null=True,
                    ),
                ),
                (
                    "accepted_at",
                    models.DateTimeField(
                        blank=True, help_text="Date of the consent", null=True
                    ),
                ),
                (
                    "user",
                    models.OneToOneField(
                        help_text="User who provided legal consent",
                        on_delete=django.db.models.deletion.CASCADE,
                        to=settings.AUTH_USER_MODEL,
                    ),
                ),
            ],
            options={
                "verbose_name": "Legal Consent",
                "verbose_name_plural": "Legal Consents",
            },
        ),
    ]
