# ----------------------------------------------------------------------------
#
#  Welcome to Baml! To use this generated code, please run the following:
#
#  $ pip install baml
#
# ----------------------------------------------------------------------------

# This file was generated by BAML: please do not edit it. Instead, edit the
# BAML files and re-generate this code using: baml-cli generate
# baml-cli is available with the baml package.

import typing
import typing_extensions
import baml_py

from . import stream_types, types, type_builder
from .parser import LlmResponseParser, LlmStreamParser
from .runtime import DoNotUseDirectlyCallManager, BamlCallOptions
from .globals import DO_NOT_USE_DIRECTLY_UNLESS_YOU_KNOW_WHAT_YOURE_DOING_RUNTIME as __runtime__


class BamlAsyncClient:
    __options: DoNotUseDirectlyCallManager
    __stream_client: "BamlStreamClient"
    __http_request: "BamlHttpRequestClient"
    __http_stream_request: "BamlHttpStreamRequestClient"
    __llm_response_parser: LlmResponseParser
    __llm_stream_parser: LlmStreamParser

    def __init__(self, options: DoNotUseDirectlyCallManager):
        self.__options = options
        self.__stream_client = BamlStreamClient(options)
        self.__http_request = BamlHttpRequestClient(options)
        self.__http_stream_request = BamlHttpStreamRequestClient(options)
        self.__llm_response_parser = LlmResponseParser(options)
        self.__llm_stream_parser = LlmStreamParser(options)

    def with_options(self,
        tb: typing.Optional[type_builder.TypeBuilder] = None,
        client_registry: typing.Optional[baml_py.baml_py.ClientRegistry] = None,
        collector: typing.Optional[typing.Union[baml_py.baml_py.Collector, typing.List[baml_py.baml_py.Collector]]] = None,
        env: typing.Optional[typing.Dict[str, typing.Optional[str]]] = None,
        on_tick: typing.Optional[typing.Callable[[str, baml_py.baml_py.FunctionLog], None]] = None,
    ) -> "BamlAsyncClient":
        options: BamlCallOptions = {}
        if tb is not None:
            options["tb"] = tb
        if client_registry is not None:
            options["client_registry"] = client_registry
        if collector is not None:
            options["collector"] = collector
        if env is not None:
            options["env"] = env
        if on_tick is not None:
            options["on_tick"] = on_tick
        return BamlAsyncClient(self.__options.merge_options(options))

    @property
    def stream(self):
      return self.__stream_client

    @property
    def request(self):
      return self.__http_request

    @property
    def stream_request(self):
      return self.__http_stream_request

    @property
    def parse(self):
      return self.__llm_response_parser

    @property
    def parse_stream(self):
      return self.__llm_stream_parser
    
    async def AnthropicClaudeCodeManager(self, tool_results: str,system_info: types.SystemInfo_CrossIndexing,
        baml_options: BamlCallOptions = {},
    ) -> types.CodeManagerResponse:
        # Check if on_tick is provided
        if 'on_tick' in baml_options:
            # Use streaming internally when on_tick is provided
            stream = self.stream.AnthropicClaudeCodeManager(tool_results=tool_results,system_info=system_info,
                baml_options=baml_options)
            return await stream.get_final_response()
        else:
            # Original non-streaming code
            result = await self.__options.merge_options(baml_options).call_function_async(function_name="AnthropicClaudeCodeManager", args={
                "tool_results": tool_results,"system_info": system_info,
            })
            return typing.cast(types.CodeManagerResponse, result.cast_to(types, types, stream_types, False, __runtime__))
    async def AnthropicClaudeConnectionMatching(self, incoming_connections: str,outgoing_connections: str,
        baml_options: BamlCallOptions = {},
    ) -> types.ConnectionMatchingResponse:
        # Check if on_tick is provided
        if 'on_tick' in baml_options:
            # Use streaming internally when on_tick is provided
            stream = self.stream.AnthropicClaudeConnectionMatching(incoming_connections=incoming_connections,outgoing_connections=outgoing_connections,
                baml_options=baml_options)
            return await stream.get_final_response()
        else:
            # Original non-streaming code
            result = await self.__options.merge_options(baml_options).call_function_async(function_name="AnthropicClaudeConnectionMatching", args={
                "incoming_connections": incoming_connections,"outgoing_connections": outgoing_connections,
            })
            return typing.cast(types.ConnectionMatchingResponse, result.cast_to(types, types, stream_types, False, __runtime__))
    async def AnthropicClaudeConnectionSplitting(self, memory_context: str,
        baml_options: BamlCallOptions = {},
    ) -> types.ConnectionSplittingResponse:
        # Check if on_tick is provided
        if 'on_tick' in baml_options:
            # Use streaming internally when on_tick is provided
            stream = self.stream.AnthropicClaudeConnectionSplitting(memory_context=memory_context,
                baml_options=baml_options)
            return await stream.get_final_response()
        else:
            # Original non-streaming code
            result = await self.__options.merge_options(baml_options).call_function_async(function_name="AnthropicClaudeConnectionSplitting", args={
                "memory_context": memory_context,
            })
            return typing.cast(types.ConnectionSplittingResponse, result.cast_to(types, types, stream_types, False, __runtime__))
    async def AnthropicClaudeImplementationDiscovery(self, analysis_query: str,memory_context: str,system_info: types.SystemInfo_CrossIndexing,
        baml_options: BamlCallOptions = {},
    ) -> types.CrossIndexingResponse:
        # Check if on_tick is provided
        if 'on_tick' in baml_options:
            # Use streaming internally when on_tick is provided
            stream = self.stream.AnthropicClaudeImplementationDiscovery(analysis_query=analysis_query,memory_context=memory_context,system_info=system_info,
                baml_options=baml_options)
            return await stream.get_final_response()
        else:
            # Original non-streaming code
            result = await self.__options.merge_options(baml_options).call_function_async(function_name="AnthropicClaudeImplementationDiscovery", args={
                "analysis_query": analysis_query,"memory_context": memory_context,"system_info": system_info,
            })
            return typing.cast(types.CrossIndexingResponse, result.cast_to(types, types, stream_types, False, __runtime__))
    async def AnthropicClaudeImportDiscovery(self, analysis_query: str,memory_context: str,system_info: types.SystemInfo_CrossIndexing,
        baml_options: BamlCallOptions = {},
    ) -> types.CrossIndexingResponse:
        # Check if on_tick is provided
        if 'on_tick' in baml_options:
            # Use streaming internally when on_tick is provided
            stream = self.stream.AnthropicClaudeImportDiscovery(analysis_query=analysis_query,memory_context=memory_context,system_info=system_info,
                baml_options=baml_options)
            return await stream.get_final_response()
        else:
            # Original non-streaming code
            result = await self.__options.merge_options(baml_options).call_function_async(function_name="AnthropicClaudeImportDiscovery", args={
                "analysis_query": analysis_query,"memory_context": memory_context,"system_info": system_info,
            })
            return typing.cast(types.CrossIndexingResponse, result.cast_to(types, types, stream_types, False, __runtime__))
    async def AnthropicClaudePackageDiscovery(self, analysis_query: str,memory_context: str,system_info: types.SystemInfo_CrossIndexing,
        baml_options: BamlCallOptions = {},
    ) -> types.CrossIndexingResponse:
        # Check if on_tick is provided
        if 'on_tick' in baml_options:
            # Use streaming internally when on_tick is provided
            stream = self.stream.AnthropicClaudePackageDiscovery(analysis_query=analysis_query,memory_context=memory_context,system_info=system_info,
                baml_options=baml_options)
            return await stream.get_final_response()
        else:
            # Original non-streaming code
            result = await self.__options.merge_options(baml_options).call_function_async(function_name="AnthropicClaudePackageDiscovery", args={
                "analysis_query": analysis_query,"memory_context": memory_context,"system_info": system_info,
            })
            return typing.cast(types.CrossIndexingResponse, result.cast_to(types, types, stream_types, False, __runtime__))
    async def AnthropicClaudeRoadmapAgent(self, params: types.RoadmapAgentParams,
        baml_options: BamlCallOptions = {},
    ) -> types.RoadmapResponse:
        # Check if on_tick is provided
        if 'on_tick' in baml_options:
            # Use streaming internally when on_tick is provided
            stream = self.stream.AnthropicClaudeRoadmapAgent(params=params,
                baml_options=baml_options)
            return await stream.get_final_response()
        else:
            # Original non-streaming code
            result = await self.__options.merge_options(baml_options).call_function_async(function_name="AnthropicClaudeRoadmapAgent", args={
                "params": params,
            })
            return typing.cast(types.RoadmapResponse, result.cast_to(types, types, stream_types, False, __runtime__))
    async def AnthropicClaudeTaskFilter(self, task_list: str,
        baml_options: BamlCallOptions = {},
    ) -> types.TaskFilterResponse:
        # Check if on_tick is provided
        if 'on_tick' in baml_options:
            # Use streaming internally when on_tick is provided
            stream = self.stream.AnthropicClaudeTaskFilter(task_list=task_list,
                baml_options=baml_options)
            return await stream.get_final_response()
        else:
            # Original non-streaming code
            result = await self.__options.merge_options(baml_options).call_function_async(function_name="AnthropicClaudeTaskFilter", args={
                "task_list": task_list,
            })
            return typing.cast(types.TaskFilterResponse, result.cast_to(types, types, stream_types, False, __runtime__))
    async def AnthropicClaudeTechnologyCorrection(self, unmatched_names: str,acceptable_enums: str,
        baml_options: BamlCallOptions = {},
    ) -> types.TechnologyCorrectionResponse:
        # Check if on_tick is provided
        if 'on_tick' in baml_options:
            # Use streaming internally when on_tick is provided
            stream = self.stream.AnthropicClaudeTechnologyCorrection(unmatched_names=unmatched_names,acceptable_enums=acceptable_enums,
                baml_options=baml_options)
            return await stream.get_final_response()
        else:
            # Original non-streaming code
            result = await self.__options.merge_options(baml_options).call_function_async(function_name="AnthropicClaudeTechnologyCorrection", args={
                "unmatched_names": unmatched_names,"acceptable_enums": acceptable_enums,
            })
            return typing.cast(types.TechnologyCorrectionResponse, result.cast_to(types, types, stream_types, False, __runtime__))
    async def AwsBedrockCodeManager(self, tool_results: str,system_info: types.SystemInfo_CrossIndexing,
        baml_options: BamlCallOptions = {},
    ) -> types.CodeManagerResponse:
        # Check if on_tick is provided
        if 'on_tick' in baml_options:
            # Use streaming internally when on_tick is provided
            stream = self.stream.AwsBedrockCodeManager(tool_results=tool_results,system_info=system_info,
                baml_options=baml_options)
            return await stream.get_final_response()
        else:
            # Original non-streaming code
            result = await self.__options.merge_options(baml_options).call_function_async(function_name="AwsBedrockCodeManager", args={
                "tool_results": tool_results,"system_info": system_info,
            })
            return typing.cast(types.CodeManagerResponse, result.cast_to(types, types, stream_types, False, __runtime__))
    async def AwsBedrockConnectionMatching(self, incoming_connections: str,outgoing_connections: str,
        baml_options: BamlCallOptions = {},
    ) -> types.ConnectionMatchingResponse:
        # Check if on_tick is provided
        if 'on_tick' in baml_options:
            # Use streaming internally when on_tick is provided
            stream = self.stream.AwsBedrockConnectionMatching(incoming_connections=incoming_connections,outgoing_connections=outgoing_connections,
                baml_options=baml_options)
            return await stream.get_final_response()
        else:
            # Original non-streaming code
            result = await self.__options.merge_options(baml_options).call_function_async(function_name="AwsBedrockConnectionMatching", args={
                "incoming_connections": incoming_connections,"outgoing_connections": outgoing_connections,
            })
            return typing.cast(types.ConnectionMatchingResponse, result.cast_to(types, types, stream_types, False, __runtime__))
    async def AwsBedrockConnectionSplitting(self, memory_context: str,
        baml_options: BamlCallOptions = {},
    ) -> types.ConnectionSplittingResponse:
        # Check if on_tick is provided
        if 'on_tick' in baml_options:
            # Use streaming internally when on_tick is provided
            stream = self.stream.AwsBedrockConnectionSplitting(memory_context=memory_context,
                baml_options=baml_options)
            return await stream.get_final_response()
        else:
            # Original non-streaming code
            result = await self.__options.merge_options(baml_options).call_function_async(function_name="AwsBedrockConnectionSplitting", args={
                "memory_context": memory_context,
            })
            return typing.cast(types.ConnectionSplittingResponse, result.cast_to(types, types, stream_types, False, __runtime__))
    async def AwsBedrockImplementationDiscovery(self, analysis_query: str,memory_context: str,system_info: types.SystemInfo_CrossIndexing,
        baml_options: BamlCallOptions = {},
    ) -> types.CrossIndexingResponse:
        # Check if on_tick is provided
        if 'on_tick' in baml_options:
            # Use streaming internally when on_tick is provided
            stream = self.stream.AwsBedrockImplementationDiscovery(analysis_query=analysis_query,memory_context=memory_context,system_info=system_info,
                baml_options=baml_options)
            return await stream.get_final_response()
        else:
            # Original non-streaming code
            result = await self.__options.merge_options(baml_options).call_function_async(function_name="AwsBedrockImplementationDiscovery", args={
                "analysis_query": analysis_query,"memory_context": memory_context,"system_info": system_info,
            })
            return typing.cast(types.CrossIndexingResponse, result.cast_to(types, types, stream_types, False, __runtime__))
    async def AwsBedrockImportDiscovery(self, analysis_query: str,memory_context: str,system_info: types.SystemInfo_CrossIndexing,
        baml_options: BamlCallOptions = {},
    ) -> types.CrossIndexingResponse:
        # Check if on_tick is provided
        if 'on_tick' in baml_options:
            # Use streaming internally when on_tick is provided
            stream = self.stream.AwsBedrockImportDiscovery(analysis_query=analysis_query,memory_context=memory_context,system_info=system_info,
                baml_options=baml_options)
            return await stream.get_final_response()
        else:
            # Original non-streaming code
            result = await self.__options.merge_options(baml_options).call_function_async(function_name="AwsBedrockImportDiscovery", args={
                "analysis_query": analysis_query,"memory_context": memory_context,"system_info": system_info,
            })
            return typing.cast(types.CrossIndexingResponse, result.cast_to(types, types, stream_types, False, __runtime__))
    async def AwsBedrockPackageDiscovery(self, analysis_query: str,memory_context: str,system_info: types.SystemInfo_CrossIndexing,
        baml_options: BamlCallOptions = {},
    ) -> types.CrossIndexingResponse:
        # Check if on_tick is provided
        if 'on_tick' in baml_options:
            # Use streaming internally when on_tick is provided
            stream = self.stream.AwsBedrockPackageDiscovery(analysis_query=analysis_query,memory_context=memory_context,system_info=system_info,
                baml_options=baml_options)
            return await stream.get_final_response()
        else:
            # Original non-streaming code
            result = await self.__options.merge_options(baml_options).call_function_async(function_name="AwsBedrockPackageDiscovery", args={
                "analysis_query": analysis_query,"memory_context": memory_context,"system_info": system_info,
            })
            return typing.cast(types.CrossIndexingResponse, result.cast_to(types, types, stream_types, False, __runtime__))
    async def AwsBedrockRoadmapAgent(self, params: types.RoadmapAgentParams,
        baml_options: BamlCallOptions = {},
    ) -> types.RoadmapResponse:
        # Check if on_tick is provided
        if 'on_tick' in baml_options:
            # Use streaming internally when on_tick is provided
            stream = self.stream.AwsBedrockRoadmapAgent(params=params,
                baml_options=baml_options)
            return await stream.get_final_response()
        else:
            # Original non-streaming code
            result = await self.__options.merge_options(baml_options).call_function_async(function_name="AwsBedrockRoadmapAgent", args={
                "params": params,
            })
            return typing.cast(types.RoadmapResponse, result.cast_to(types, types, stream_types, False, __runtime__))
    async def AwsBedrockTaskFilter(self, task_list: str,
        baml_options: BamlCallOptions = {},
    ) -> types.TaskFilterResponse:
        # Check if on_tick is provided
        if 'on_tick' in baml_options:
            # Use streaming internally when on_tick is provided
            stream = self.stream.AwsBedrockTaskFilter(task_list=task_list,
                baml_options=baml_options)
            return await stream.get_final_response()
        else:
            # Original non-streaming code
            result = await self.__options.merge_options(baml_options).call_function_async(function_name="AwsBedrockTaskFilter", args={
                "task_list": task_list,
            })
            return typing.cast(types.TaskFilterResponse, result.cast_to(types, types, stream_types, False, __runtime__))
    async def AwsBedrockTechnologyCorrection(self, unmatched_names: str,acceptable_enums: str,
        baml_options: BamlCallOptions = {},
    ) -> types.TechnologyCorrectionResponse:
        # Check if on_tick is provided
        if 'on_tick' in baml_options:
            # Use streaming internally when on_tick is provided
            stream = self.stream.AwsBedrockTechnologyCorrection(unmatched_names=unmatched_names,acceptable_enums=acceptable_enums,
                baml_options=baml_options)
            return await stream.get_final_response()
        else:
            # Original non-streaming code
            result = await self.__options.merge_options(baml_options).call_function_async(function_name="AwsBedrockTechnologyCorrection", args={
                "unmatched_names": unmatched_names,"acceptable_enums": acceptable_enums,
            })
            return typing.cast(types.TechnologyCorrectionResponse, result.cast_to(types, types, stream_types, False, __runtime__))
    async def AzureAIFoundryCodeManager(self, tool_results: str,system_info: types.SystemInfo_CrossIndexing,
        baml_options: BamlCallOptions = {},
    ) -> types.CodeManagerResponse:
        # Check if on_tick is provided
        if 'on_tick' in baml_options:
            # Use streaming internally when on_tick is provided
            stream = self.stream.AzureAIFoundryCodeManager(tool_results=tool_results,system_info=system_info,
                baml_options=baml_options)
            return await stream.get_final_response()
        else:
            # Original non-streaming code
            result = await self.__options.merge_options(baml_options).call_function_async(function_name="AzureAIFoundryCodeManager", args={
                "tool_results": tool_results,"system_info": system_info,
            })
            return typing.cast(types.CodeManagerResponse, result.cast_to(types, types, stream_types, False, __runtime__))
    async def AzureAIFoundryConnectionMatching(self, incoming_connections: str,outgoing_connections: str,
        baml_options: BamlCallOptions = {},
    ) -> types.ConnectionMatchingResponse:
        # Check if on_tick is provided
        if 'on_tick' in baml_options:
            # Use streaming internally when on_tick is provided
            stream = self.stream.AzureAIFoundryConnectionMatching(incoming_connections=incoming_connections,outgoing_connections=outgoing_connections,
                baml_options=baml_options)
            return await stream.get_final_response()
        else:
            # Original non-streaming code
            result = await self.__options.merge_options(baml_options).call_function_async(function_name="AzureAIFoundryConnectionMatching", args={
                "incoming_connections": incoming_connections,"outgoing_connections": outgoing_connections,
            })
            return typing.cast(types.ConnectionMatchingResponse, result.cast_to(types, types, stream_types, False, __runtime__))
    async def AzureAIFoundryConnectionSplitting(self, memory_context: str,
        baml_options: BamlCallOptions = {},
    ) -> types.ConnectionSplittingResponse:
        # Check if on_tick is provided
        if 'on_tick' in baml_options:
            # Use streaming internally when on_tick is provided
            stream = self.stream.AzureAIFoundryConnectionSplitting(memory_context=memory_context,
                baml_options=baml_options)
            return await stream.get_final_response()
        else:
            # Original non-streaming code
            result = await self.__options.merge_options(baml_options).call_function_async(function_name="AzureAIFoundryConnectionSplitting", args={
                "memory_context": memory_context,
            })
            return typing.cast(types.ConnectionSplittingResponse, result.cast_to(types, types, stream_types, False, __runtime__))
    async def AzureAIFoundryImplementationDiscovery(self, analysis_query: str,memory_context: str,system_info: types.SystemInfo_CrossIndexing,
        baml_options: BamlCallOptions = {},
    ) -> types.CrossIndexingResponse:
        # Check if on_tick is provided
        if 'on_tick' in baml_options:
            # Use streaming internally when on_tick is provided
            stream = self.stream.AzureAIFoundryImplementationDiscovery(analysis_query=analysis_query,memory_context=memory_context,system_info=system_info,
                baml_options=baml_options)
            return await stream.get_final_response()
        else:
            # Original non-streaming code
            result = await self.__options.merge_options(baml_options).call_function_async(function_name="AzureAIFoundryImplementationDiscovery", args={
                "analysis_query": analysis_query,"memory_context": memory_context,"system_info": system_info,
            })
            return typing.cast(types.CrossIndexingResponse, result.cast_to(types, types, stream_types, False, __runtime__))
    async def AzureAIFoundryImportDiscovery(self, analysis_query: str,memory_context: str,system_info: types.SystemInfo_CrossIndexing,
        baml_options: BamlCallOptions = {},
    ) -> types.CrossIndexingResponse:
        # Check if on_tick is provided
        if 'on_tick' in baml_options:
            # Use streaming internally when on_tick is provided
            stream = self.stream.AzureAIFoundryImportDiscovery(analysis_query=analysis_query,memory_context=memory_context,system_info=system_info,
                baml_options=baml_options)
            return await stream.get_final_response()
        else:
            # Original non-streaming code
            result = await self.__options.merge_options(baml_options).call_function_async(function_name="AzureAIFoundryImportDiscovery", args={
                "analysis_query": analysis_query,"memory_context": memory_context,"system_info": system_info,
            })
            return typing.cast(types.CrossIndexingResponse, result.cast_to(types, types, stream_types, False, __runtime__))
    async def AzureAIFoundryPackageDiscovery(self, analysis_query: str,memory_context: str,system_info: types.SystemInfo_CrossIndexing,
        baml_options: BamlCallOptions = {},
    ) -> types.CrossIndexingResponse:
        # Check if on_tick is provided
        if 'on_tick' in baml_options:
            # Use streaming internally when on_tick is provided
            stream = self.stream.AzureAIFoundryPackageDiscovery(analysis_query=analysis_query,memory_context=memory_context,system_info=system_info,
                baml_options=baml_options)
            return await stream.get_final_response()
        else:
            # Original non-streaming code
            result = await self.__options.merge_options(baml_options).call_function_async(function_name="AzureAIFoundryPackageDiscovery", args={
                "analysis_query": analysis_query,"memory_context": memory_context,"system_info": system_info,
            })
            return typing.cast(types.CrossIndexingResponse, result.cast_to(types, types, stream_types, False, __runtime__))
    async def AzureAIFoundryRoadmapAgent(self, params: types.RoadmapAgentParams,
        baml_options: BamlCallOptions = {},
    ) -> types.RoadmapResponse:
        # Check if on_tick is provided
        if 'on_tick' in baml_options:
            # Use streaming internally when on_tick is provided
            stream = self.stream.AzureAIFoundryRoadmapAgent(params=params,
                baml_options=baml_options)
            return await stream.get_final_response()
        else:
            # Original non-streaming code
            result = await self.__options.merge_options(baml_options).call_function_async(function_name="AzureAIFoundryRoadmapAgent", args={
                "params": params,
            })
            return typing.cast(types.RoadmapResponse, result.cast_to(types, types, stream_types, False, __runtime__))
    async def AzureAIFoundryTaskFilter(self, task_list: str,
        baml_options: BamlCallOptions = {},
    ) -> types.TaskFilterResponse:
        # Check if on_tick is provided
        if 'on_tick' in baml_options:
            # Use streaming internally when on_tick is provided
            stream = self.stream.AzureAIFoundryTaskFilter(task_list=task_list,
                baml_options=baml_options)
            return await stream.get_final_response()
        else:
            # Original non-streaming code
            result = await self.__options.merge_options(baml_options).call_function_async(function_name="AzureAIFoundryTaskFilter", args={
                "task_list": task_list,
            })
            return typing.cast(types.TaskFilterResponse, result.cast_to(types, types, stream_types, False, __runtime__))
    async def AzureAIFoundryTechnologyCorrection(self, unmatched_names: str,acceptable_enums: str,
        baml_options: BamlCallOptions = {},
    ) -> types.TechnologyCorrectionResponse:
        # Check if on_tick is provided
        if 'on_tick' in baml_options:
            # Use streaming internally when on_tick is provided
            stream = self.stream.AzureAIFoundryTechnologyCorrection(unmatched_names=unmatched_names,acceptable_enums=acceptable_enums,
                baml_options=baml_options)
            return await stream.get_final_response()
        else:
            # Original non-streaming code
            result = await self.__options.merge_options(baml_options).call_function_async(function_name="AzureAIFoundryTechnologyCorrection", args={
                "unmatched_names": unmatched_names,"acceptable_enums": acceptable_enums,
            })
            return typing.cast(types.TechnologyCorrectionResponse, result.cast_to(types, types, stream_types, False, __runtime__))
    async def AzureOpenAICodeManager(self, tool_results: str,system_info: types.SystemInfo_CrossIndexing,
        baml_options: BamlCallOptions = {},
    ) -> types.CodeManagerResponse:
        # Check if on_tick is provided
        if 'on_tick' in baml_options:
            # Use streaming internally when on_tick is provided
            stream = self.stream.AzureOpenAICodeManager(tool_results=tool_results,system_info=system_info,
                baml_options=baml_options)
            return await stream.get_final_response()
        else:
            # Original non-streaming code
            result = await self.__options.merge_options(baml_options).call_function_async(function_name="AzureOpenAICodeManager", args={
                "tool_results": tool_results,"system_info": system_info,
            })
            return typing.cast(types.CodeManagerResponse, result.cast_to(types, types, stream_types, False, __runtime__))
    async def AzureOpenAIConnectionMatching(self, incoming_connections: str,outgoing_connections: str,
        baml_options: BamlCallOptions = {},
    ) -> types.ConnectionMatchingResponse:
        # Check if on_tick is provided
        if 'on_tick' in baml_options:
            # Use streaming internally when on_tick is provided
            stream = self.stream.AzureOpenAIConnectionMatching(incoming_connections=incoming_connections,outgoing_connections=outgoing_connections,
                baml_options=baml_options)
            return await stream.get_final_response()
        else:
            # Original non-streaming code
            result = await self.__options.merge_options(baml_options).call_function_async(function_name="AzureOpenAIConnectionMatching", args={
                "incoming_connections": incoming_connections,"outgoing_connections": outgoing_connections,
            })
            return typing.cast(types.ConnectionMatchingResponse, result.cast_to(types, types, stream_types, False, __runtime__))
    async def AzureOpenAIConnectionSplitting(self, memory_context: str,
        baml_options: BamlCallOptions = {},
    ) -> types.ConnectionSplittingResponse:
        # Check if on_tick is provided
        if 'on_tick' in baml_options:
            # Use streaming internally when on_tick is provided
            stream = self.stream.AzureOpenAIConnectionSplitting(memory_context=memory_context,
                baml_options=baml_options)
            return await stream.get_final_response()
        else:
            # Original non-streaming code
            result = await self.__options.merge_options(baml_options).call_function_async(function_name="AzureOpenAIConnectionSplitting", args={
                "memory_context": memory_context,
            })
            return typing.cast(types.ConnectionSplittingResponse, result.cast_to(types, types, stream_types, False, __runtime__))
    async def AzureOpenAIImplementationDiscovery(self, analysis_query: str,memory_context: str,system_info: types.SystemInfo_CrossIndexing,
        baml_options: BamlCallOptions = {},
    ) -> types.CrossIndexingResponse:
        # Check if on_tick is provided
        if 'on_tick' in baml_options:
            # Use streaming internally when on_tick is provided
            stream = self.stream.AzureOpenAIImplementationDiscovery(analysis_query=analysis_query,memory_context=memory_context,system_info=system_info,
                baml_options=baml_options)
            return await stream.get_final_response()
        else:
            # Original non-streaming code
            result = await self.__options.merge_options(baml_options).call_function_async(function_name="AzureOpenAIImplementationDiscovery", args={
                "analysis_query": analysis_query,"memory_context": memory_context,"system_info": system_info,
            })
            return typing.cast(types.CrossIndexingResponse, result.cast_to(types, types, stream_types, False, __runtime__))
    async def AzureOpenAIImportDiscovery(self, analysis_query: str,memory_context: str,system_info: types.SystemInfo_CrossIndexing,
        baml_options: BamlCallOptions = {},
    ) -> types.CrossIndexingResponse:
        # Check if on_tick is provided
        if 'on_tick' in baml_options:
            # Use streaming internally when on_tick is provided
            stream = self.stream.AzureOpenAIImportDiscovery(analysis_query=analysis_query,memory_context=memory_context,system_info=system_info,
                baml_options=baml_options)
            return await stream.get_final_response()
        else:
            # Original non-streaming code
            result = await self.__options.merge_options(baml_options).call_function_async(function_name="AzureOpenAIImportDiscovery", args={
                "analysis_query": analysis_query,"memory_context": memory_context,"system_info": system_info,
            })
            return typing.cast(types.CrossIndexingResponse, result.cast_to(types, types, stream_types, False, __runtime__))
    async def AzureOpenAIPackageDiscovery(self, analysis_query: str,memory_context: str,system_info: types.SystemInfo_CrossIndexing,
        baml_options: BamlCallOptions = {},
    ) -> types.CrossIndexingResponse:
        # Check if on_tick is provided
        if 'on_tick' in baml_options:
            # Use streaming internally when on_tick is provided
            stream = self.stream.AzureOpenAIPackageDiscovery(analysis_query=analysis_query,memory_context=memory_context,system_info=system_info,
                baml_options=baml_options)
            return await stream.get_final_response()
        else:
            # Original non-streaming code
            result = await self.__options.merge_options(baml_options).call_function_async(function_name="AzureOpenAIPackageDiscovery", args={
                "analysis_query": analysis_query,"memory_context": memory_context,"system_info": system_info,
            })
            return typing.cast(types.CrossIndexingResponse, result.cast_to(types, types, stream_types, False, __runtime__))
    async def AzureOpenAIRoadmapAgent(self, params: types.RoadmapAgentParams,
        baml_options: BamlCallOptions = {},
    ) -> types.RoadmapResponse:
        # Check if on_tick is provided
        if 'on_tick' in baml_options:
            # Use streaming internally when on_tick is provided
            stream = self.stream.AzureOpenAIRoadmapAgent(params=params,
                baml_options=baml_options)
            return await stream.get_final_response()
        else:
            # Original non-streaming code
            result = await self.__options.merge_options(baml_options).call_function_async(function_name="AzureOpenAIRoadmapAgent", args={
                "params": params,
            })
            return typing.cast(types.RoadmapResponse, result.cast_to(types, types, stream_types, False, __runtime__))
    async def AzureOpenAITaskFilter(self, task_list: str,
        baml_options: BamlCallOptions = {},
    ) -> types.TaskFilterResponse:
        # Check if on_tick is provided
        if 'on_tick' in baml_options:
            # Use streaming internally when on_tick is provided
            stream = self.stream.AzureOpenAITaskFilter(task_list=task_list,
                baml_options=baml_options)
            return await stream.get_final_response()
        else:
            # Original non-streaming code
            result = await self.__options.merge_options(baml_options).call_function_async(function_name="AzureOpenAITaskFilter", args={
                "task_list": task_list,
            })
            return typing.cast(types.TaskFilterResponse, result.cast_to(types, types, stream_types, False, __runtime__))
    async def AzureOpenAITechnologyCorrection(self, unmatched_names: str,acceptable_enums: str,
        baml_options: BamlCallOptions = {},
    ) -> types.TechnologyCorrectionResponse:
        # Check if on_tick is provided
        if 'on_tick' in baml_options:
            # Use streaming internally when on_tick is provided
            stream = self.stream.AzureOpenAITechnologyCorrection(unmatched_names=unmatched_names,acceptable_enums=acceptable_enums,
                baml_options=baml_options)
            return await stream.get_final_response()
        else:
            # Original non-streaming code
            result = await self.__options.merge_options(baml_options).call_function_async(function_name="AzureOpenAITechnologyCorrection", args={
                "unmatched_names": unmatched_names,"acceptable_enums": acceptable_enums,
            })
            return typing.cast(types.TechnologyCorrectionResponse, result.cast_to(types, types, stream_types, False, __runtime__))
    async def GCPVertexAICodeManager(self, tool_results: str,system_info: types.SystemInfo_CrossIndexing,
        baml_options: BamlCallOptions = {},
    ) -> types.CodeManagerResponse:
        # Check if on_tick is provided
        if 'on_tick' in baml_options:
            # Use streaming internally when on_tick is provided
            stream = self.stream.GCPVertexAICodeManager(tool_results=tool_results,system_info=system_info,
                baml_options=baml_options)
            return await stream.get_final_response()
        else:
            # Original non-streaming code
            result = await self.__options.merge_options(baml_options).call_function_async(function_name="GCPVertexAICodeManager", args={
                "tool_results": tool_results,"system_info": system_info,
            })
            return typing.cast(types.CodeManagerResponse, result.cast_to(types, types, stream_types, False, __runtime__))
    async def GCPVertexAIConnectionMatching(self, incoming_connections: str,outgoing_connections: str,
        baml_options: BamlCallOptions = {},
    ) -> types.ConnectionMatchingResponse:
        # Check if on_tick is provided
        if 'on_tick' in baml_options:
            # Use streaming internally when on_tick is provided
            stream = self.stream.GCPVertexAIConnectionMatching(incoming_connections=incoming_connections,outgoing_connections=outgoing_connections,
                baml_options=baml_options)
            return await stream.get_final_response()
        else:
            # Original non-streaming code
            result = await self.__options.merge_options(baml_options).call_function_async(function_name="GCPVertexAIConnectionMatching", args={
                "incoming_connections": incoming_connections,"outgoing_connections": outgoing_connections,
            })
            return typing.cast(types.ConnectionMatchingResponse, result.cast_to(types, types, stream_types, False, __runtime__))
    async def GCPVertexAIConnectionSplitting(self, memory_context: str,
        baml_options: BamlCallOptions = {},
    ) -> types.ConnectionSplittingResponse:
        # Check if on_tick is provided
        if 'on_tick' in baml_options:
            # Use streaming internally when on_tick is provided
            stream = self.stream.GCPVertexAIConnectionSplitting(memory_context=memory_context,
                baml_options=baml_options)
            return await stream.get_final_response()
        else:
            # Original non-streaming code
            result = await self.__options.merge_options(baml_options).call_function_async(function_name="GCPVertexAIConnectionSplitting", args={
                "memory_context": memory_context,
            })
            return typing.cast(types.ConnectionSplittingResponse, result.cast_to(types, types, stream_types, False, __runtime__))
    async def GCPVertexAIImplementationDiscovery(self, analysis_query: str,memory_context: str,system_info: types.SystemInfo_CrossIndexing,
        baml_options: BamlCallOptions = {},
    ) -> types.CrossIndexingResponse:
        # Check if on_tick is provided
        if 'on_tick' in baml_options:
            # Use streaming internally when on_tick is provided
            stream = self.stream.GCPVertexAIImplementationDiscovery(analysis_query=analysis_query,memory_context=memory_context,system_info=system_info,
                baml_options=baml_options)
            return await stream.get_final_response()
        else:
            # Original non-streaming code
            result = await self.__options.merge_options(baml_options).call_function_async(function_name="GCPVertexAIImplementationDiscovery", args={
                "analysis_query": analysis_query,"memory_context": memory_context,"system_info": system_info,
            })
            return typing.cast(types.CrossIndexingResponse, result.cast_to(types, types, stream_types, False, __runtime__))
    async def GCPVertexAIImportDiscovery(self, analysis_query: str,memory_context: str,system_info: types.SystemInfo_CrossIndexing,
        baml_options: BamlCallOptions = {},
    ) -> types.CrossIndexingResponse:
        # Check if on_tick is provided
        if 'on_tick' in baml_options:
            # Use streaming internally when on_tick is provided
            stream = self.stream.GCPVertexAIImportDiscovery(analysis_query=analysis_query,memory_context=memory_context,system_info=system_info,
                baml_options=baml_options)
            return await stream.get_final_response()
        else:
            # Original non-streaming code
            result = await self.__options.merge_options(baml_options).call_function_async(function_name="GCPVertexAIImportDiscovery", args={
                "analysis_query": analysis_query,"memory_context": memory_context,"system_info": system_info,
            })
            return typing.cast(types.CrossIndexingResponse, result.cast_to(types, types, stream_types, False, __runtime__))
    async def GCPVertexAIPackageDiscovery(self, analysis_query: str,memory_context: str,system_info: types.SystemInfo_CrossIndexing,
        baml_options: BamlCallOptions = {},
    ) -> types.CrossIndexingResponse:
        # Check if on_tick is provided
        if 'on_tick' in baml_options:
            # Use streaming internally when on_tick is provided
            stream = self.stream.GCPVertexAIPackageDiscovery(analysis_query=analysis_query,memory_context=memory_context,system_info=system_info,
                baml_options=baml_options)
            return await stream.get_final_response()
        else:
            # Original non-streaming code
            result = await self.__options.merge_options(baml_options).call_function_async(function_name="GCPVertexAIPackageDiscovery", args={
                "analysis_query": analysis_query,"memory_context": memory_context,"system_info": system_info,
            })
            return typing.cast(types.CrossIndexingResponse, result.cast_to(types, types, stream_types, False, __runtime__))
    async def GCPVertexAIRoadmapAgent(self, params: types.RoadmapAgentParams,
        baml_options: BamlCallOptions = {},
    ) -> types.RoadmapResponse:
        # Check if on_tick is provided
        if 'on_tick' in baml_options:
            # Use streaming internally when on_tick is provided
            stream = self.stream.GCPVertexAIRoadmapAgent(params=params,
                baml_options=baml_options)
            return await stream.get_final_response()
        else:
            # Original non-streaming code
            result = await self.__options.merge_options(baml_options).call_function_async(function_name="GCPVertexAIRoadmapAgent", args={
                "params": params,
            })
            return typing.cast(types.RoadmapResponse, result.cast_to(types, types, stream_types, False, __runtime__))
    async def GCPVertexAITaskFilter(self, task_list: str,
        baml_options: BamlCallOptions = {},
    ) -> types.TaskFilterResponse:
        # Check if on_tick is provided
        if 'on_tick' in baml_options:
            # Use streaming internally when on_tick is provided
            stream = self.stream.GCPVertexAITaskFilter(task_list=task_list,
                baml_options=baml_options)
            return await stream.get_final_response()
        else:
            # Original non-streaming code
            result = await self.__options.merge_options(baml_options).call_function_async(function_name="GCPVertexAITaskFilter", args={
                "task_list": task_list,
            })
            return typing.cast(types.TaskFilterResponse, result.cast_to(types, types, stream_types, False, __runtime__))
    async def GCPVertexAITechnologyCorrection(self, unmatched_names: str,acceptable_enums: str,
        baml_options: BamlCallOptions = {},
    ) -> types.TechnologyCorrectionResponse:
        # Check if on_tick is provided
        if 'on_tick' in baml_options:
            # Use streaming internally when on_tick is provided
            stream = self.stream.GCPVertexAITechnologyCorrection(unmatched_names=unmatched_names,acceptable_enums=acceptable_enums,
                baml_options=baml_options)
            return await stream.get_final_response()
        else:
            # Original non-streaming code
            result = await self.__options.merge_options(baml_options).call_function_async(function_name="GCPVertexAITechnologyCorrection", args={
                "unmatched_names": unmatched_names,"acceptable_enums": acceptable_enums,
            })
            return typing.cast(types.TechnologyCorrectionResponse, result.cast_to(types, types, stream_types, False, __runtime__))
    async def GoogleGeminiCodeManager(self, tool_results: str,system_info: types.SystemInfo_CrossIndexing,
        baml_options: BamlCallOptions = {},
    ) -> types.CodeManagerResponse:
        # Check if on_tick is provided
        if 'on_tick' in baml_options:
            # Use streaming internally when on_tick is provided
            stream = self.stream.GoogleGeminiCodeManager(tool_results=tool_results,system_info=system_info,
                baml_options=baml_options)
            return await stream.get_final_response()
        else:
            # Original non-streaming code
            result = await self.__options.merge_options(baml_options).call_function_async(function_name="GoogleGeminiCodeManager", args={
                "tool_results": tool_results,"system_info": system_info,
            })
            return typing.cast(types.CodeManagerResponse, result.cast_to(types, types, stream_types, False, __runtime__))
    async def GoogleGeminiConnectionMatching(self, incoming_connections: str,outgoing_connections: str,
        baml_options: BamlCallOptions = {},
    ) -> types.ConnectionMatchingResponse:
        # Check if on_tick is provided
        if 'on_tick' in baml_options:
            # Use streaming internally when on_tick is provided
            stream = self.stream.GoogleGeminiConnectionMatching(incoming_connections=incoming_connections,outgoing_connections=outgoing_connections,
                baml_options=baml_options)
            return await stream.get_final_response()
        else:
            # Original non-streaming code
            result = await self.__options.merge_options(baml_options).call_function_async(function_name="GoogleGeminiConnectionMatching", args={
                "incoming_connections": incoming_connections,"outgoing_connections": outgoing_connections,
            })
            return typing.cast(types.ConnectionMatchingResponse, result.cast_to(types, types, stream_types, False, __runtime__))
    async def GoogleGeminiConnectionSplitting(self, memory_context: str,
        baml_options: BamlCallOptions = {},
    ) -> types.ConnectionSplittingResponse:
        # Check if on_tick is provided
        if 'on_tick' in baml_options:
            # Use streaming internally when on_tick is provided
            stream = self.stream.GoogleGeminiConnectionSplitting(memory_context=memory_context,
                baml_options=baml_options)
            return await stream.get_final_response()
        else:
            # Original non-streaming code
            result = await self.__options.merge_options(baml_options).call_function_async(function_name="GoogleGeminiConnectionSplitting", args={
                "memory_context": memory_context,
            })
            return typing.cast(types.ConnectionSplittingResponse, result.cast_to(types, types, stream_types, False, __runtime__))
    async def GoogleGeminiImplementationDiscovery(self, analysis_query: str,memory_context: str,system_info: types.SystemInfo_CrossIndexing,
        baml_options: BamlCallOptions = {},
    ) -> types.CrossIndexingResponse:
        # Check if on_tick is provided
        if 'on_tick' in baml_options:
            # Use streaming internally when on_tick is provided
            stream = self.stream.GoogleGeminiImplementationDiscovery(analysis_query=analysis_query,memory_context=memory_context,system_info=system_info,
                baml_options=baml_options)
            return await stream.get_final_response()
        else:
            # Original non-streaming code
            result = await self.__options.merge_options(baml_options).call_function_async(function_name="GoogleGeminiImplementationDiscovery", args={
                "analysis_query": analysis_query,"memory_context": memory_context,"system_info": system_info,
            })
            return typing.cast(types.CrossIndexingResponse, result.cast_to(types, types, stream_types, False, __runtime__))
    async def GoogleGeminiImportDiscovery(self, analysis_query: str,memory_context: str,system_info: types.SystemInfo_CrossIndexing,
        baml_options: BamlCallOptions = {},
    ) -> types.CrossIndexingResponse:
        # Check if on_tick is provided
        if 'on_tick' in baml_options:
            # Use streaming internally when on_tick is provided
            stream = self.stream.GoogleGeminiImportDiscovery(analysis_query=analysis_query,memory_context=memory_context,system_info=system_info,
                baml_options=baml_options)
            return await stream.get_final_response()
        else:
            # Original non-streaming code
            result = await self.__options.merge_options(baml_options).call_function_async(function_name="GoogleGeminiImportDiscovery", args={
                "analysis_query": analysis_query,"memory_context": memory_context,"system_info": system_info,
            })
            return typing.cast(types.CrossIndexingResponse, result.cast_to(types, types, stream_types, False, __runtime__))
    async def GoogleGeminiPackageDiscovery(self, analysis_query: str,memory_context: str,system_info: types.SystemInfo_CrossIndexing,
        baml_options: BamlCallOptions = {},
    ) -> types.CrossIndexingResponse:
        # Check if on_tick is provided
        if 'on_tick' in baml_options:
            # Use streaming internally when on_tick is provided
            stream = self.stream.GoogleGeminiPackageDiscovery(analysis_query=analysis_query,memory_context=memory_context,system_info=system_info,
                baml_options=baml_options)
            return await stream.get_final_response()
        else:
            # Original non-streaming code
            result = await self.__options.merge_options(baml_options).call_function_async(function_name="GoogleGeminiPackageDiscovery", args={
                "analysis_query": analysis_query,"memory_context": memory_context,"system_info": system_info,
            })
            return typing.cast(types.CrossIndexingResponse, result.cast_to(types, types, stream_types, False, __runtime__))
    async def GoogleGeminiRoadmapAgent(self, params: types.RoadmapAgentParams,
        baml_options: BamlCallOptions = {},
    ) -> types.RoadmapResponse:
        # Check if on_tick is provided
        if 'on_tick' in baml_options:
            # Use streaming internally when on_tick is provided
            stream = self.stream.GoogleGeminiRoadmapAgent(params=params,
                baml_options=baml_options)
            return await stream.get_final_response()
        else:
            # Original non-streaming code
            result = await self.__options.merge_options(baml_options).call_function_async(function_name="GoogleGeminiRoadmapAgent", args={
                "params": params,
            })
            return typing.cast(types.RoadmapResponse, result.cast_to(types, types, stream_types, False, __runtime__))
    async def GoogleGeminiTaskFilter(self, task_list: str,
        baml_options: BamlCallOptions = {},
    ) -> types.TaskFilterResponse:
        # Check if on_tick is provided
        if 'on_tick' in baml_options:
            # Use streaming internally when on_tick is provided
            stream = self.stream.GoogleGeminiTaskFilter(task_list=task_list,
                baml_options=baml_options)
            return await stream.get_final_response()
        else:
            # Original non-streaming code
            result = await self.__options.merge_options(baml_options).call_function_async(function_name="GoogleGeminiTaskFilter", args={
                "task_list": task_list,
            })
            return typing.cast(types.TaskFilterResponse, result.cast_to(types, types, stream_types, False, __runtime__))
    async def GoogleGeminiTechnologyCorrection(self, unmatched_names: str,acceptable_enums: str,
        baml_options: BamlCallOptions = {},
    ) -> types.TechnologyCorrectionResponse:
        # Check if on_tick is provided
        if 'on_tick' in baml_options:
            # Use streaming internally when on_tick is provided
            stream = self.stream.GoogleGeminiTechnologyCorrection(unmatched_names=unmatched_names,acceptable_enums=acceptable_enums,
                baml_options=baml_options)
            return await stream.get_final_response()
        else:
            # Original non-streaming code
            result = await self.__options.merge_options(baml_options).call_function_async(function_name="GoogleGeminiTechnologyCorrection", args={
                "unmatched_names": unmatched_names,"acceptable_enums": acceptable_enums,
            })
            return typing.cast(types.TechnologyCorrectionResponse, result.cast_to(types, types, stream_types, False, __runtime__))
    async def OpenAIChatGPTCodeManager(self, tool_results: str,system_info: types.SystemInfo_CrossIndexing,
        baml_options: BamlCallOptions = {},
    ) -> types.CodeManagerResponse:
        # Check if on_tick is provided
        if 'on_tick' in baml_options:
            # Use streaming internally when on_tick is provided
            stream = self.stream.OpenAIChatGPTCodeManager(tool_results=tool_results,system_info=system_info,
                baml_options=baml_options)
            return await stream.get_final_response()
        else:
            # Original non-streaming code
            result = await self.__options.merge_options(baml_options).call_function_async(function_name="OpenAIChatGPTCodeManager", args={
                "tool_results": tool_results,"system_info": system_info,
            })
            return typing.cast(types.CodeManagerResponse, result.cast_to(types, types, stream_types, False, __runtime__))
    async def OpenAIChatGPTConnectionMatching(self, incoming_connections: str,outgoing_connections: str,
        baml_options: BamlCallOptions = {},
    ) -> types.ConnectionMatchingResponse:
        # Check if on_tick is provided
        if 'on_tick' in baml_options:
            # Use streaming internally when on_tick is provided
            stream = self.stream.OpenAIChatGPTConnectionMatching(incoming_connections=incoming_connections,outgoing_connections=outgoing_connections,
                baml_options=baml_options)
            return await stream.get_final_response()
        else:
            # Original non-streaming code
            result = await self.__options.merge_options(baml_options).call_function_async(function_name="OpenAIChatGPTConnectionMatching", args={
                "incoming_connections": incoming_connections,"outgoing_connections": outgoing_connections,
            })
            return typing.cast(types.ConnectionMatchingResponse, result.cast_to(types, types, stream_types, False, __runtime__))
    async def OpenAIChatGPTConnectionSplitting(self, memory_context: str,
        baml_options: BamlCallOptions = {},
    ) -> types.ConnectionSplittingResponse:
        # Check if on_tick is provided
        if 'on_tick' in baml_options:
            # Use streaming internally when on_tick is provided
            stream = self.stream.OpenAIChatGPTConnectionSplitting(memory_context=memory_context,
                baml_options=baml_options)
            return await stream.get_final_response()
        else:
            # Original non-streaming code
            result = await self.__options.merge_options(baml_options).call_function_async(function_name="OpenAIChatGPTConnectionSplitting", args={
                "memory_context": memory_context,
            })
            return typing.cast(types.ConnectionSplittingResponse, result.cast_to(types, types, stream_types, False, __runtime__))
    async def OpenAIChatGPTImplementationDiscovery(self, analysis_query: str,memory_context: str,system_info: types.SystemInfo_CrossIndexing,
        baml_options: BamlCallOptions = {},
    ) -> types.CrossIndexingResponse:
        # Check if on_tick is provided
        if 'on_tick' in baml_options:
            # Use streaming internally when on_tick is provided
            stream = self.stream.OpenAIChatGPTImplementationDiscovery(analysis_query=analysis_query,memory_context=memory_context,system_info=system_info,
                baml_options=baml_options)
            return await stream.get_final_response()
        else:
            # Original non-streaming code
            result = await self.__options.merge_options(baml_options).call_function_async(function_name="OpenAIChatGPTImplementationDiscovery", args={
                "analysis_query": analysis_query,"memory_context": memory_context,"system_info": system_info,
            })
            return typing.cast(types.CrossIndexingResponse, result.cast_to(types, types, stream_types, False, __runtime__))
    async def OpenAIChatGPTImportDiscovery(self, analysis_query: str,memory_context: str,system_info: types.SystemInfo_CrossIndexing,
        baml_options: BamlCallOptions = {},
    ) -> types.CrossIndexingResponse:
        # Check if on_tick is provided
        if 'on_tick' in baml_options:
            # Use streaming internally when on_tick is provided
            stream = self.stream.OpenAIChatGPTImportDiscovery(analysis_query=analysis_query,memory_context=memory_context,system_info=system_info,
                baml_options=baml_options)
            return await stream.get_final_response()
        else:
            # Original non-streaming code
            result = await self.__options.merge_options(baml_options).call_function_async(function_name="OpenAIChatGPTImportDiscovery", args={
                "analysis_query": analysis_query,"memory_context": memory_context,"system_info": system_info,
            })
            return typing.cast(types.CrossIndexingResponse, result.cast_to(types, types, stream_types, False, __runtime__))
    async def OpenAIChatGPTPackageDiscovery(self, analysis_query: str,memory_context: str,system_info: types.SystemInfo_CrossIndexing,
        baml_options: BamlCallOptions = {},
    ) -> types.CrossIndexingResponse:
        # Check if on_tick is provided
        if 'on_tick' in baml_options:
            # Use streaming internally when on_tick is provided
            stream = self.stream.OpenAIChatGPTPackageDiscovery(analysis_query=analysis_query,memory_context=memory_context,system_info=system_info,
                baml_options=baml_options)
            return await stream.get_final_response()
        else:
            # Original non-streaming code
            result = await self.__options.merge_options(baml_options).call_function_async(function_name="OpenAIChatGPTPackageDiscovery", args={
                "analysis_query": analysis_query,"memory_context": memory_context,"system_info": system_info,
            })
            return typing.cast(types.CrossIndexingResponse, result.cast_to(types, types, stream_types, False, __runtime__))
    async def OpenAIChatGPTRoadmapAgent(self, params: types.RoadmapAgentParams,
        baml_options: BamlCallOptions = {},
    ) -> types.RoadmapResponse:
        # Check if on_tick is provided
        if 'on_tick' in baml_options:
            # Use streaming internally when on_tick is provided
            stream = self.stream.OpenAIChatGPTRoadmapAgent(params=params,
                baml_options=baml_options)
            return await stream.get_final_response()
        else:
            # Original non-streaming code
            result = await self.__options.merge_options(baml_options).call_function_async(function_name="OpenAIChatGPTRoadmapAgent", args={
                "params": params,
            })
            return typing.cast(types.RoadmapResponse, result.cast_to(types, types, stream_types, False, __runtime__))
    async def OpenAIChatGPTTaskFilter(self, task_list: str,
        baml_options: BamlCallOptions = {},
    ) -> types.TaskFilterResponse:
        # Check if on_tick is provided
        if 'on_tick' in baml_options:
            # Use streaming internally when on_tick is provided
            stream = self.stream.OpenAIChatGPTTaskFilter(task_list=task_list,
                baml_options=baml_options)
            return await stream.get_final_response()
        else:
            # Original non-streaming code
            result = await self.__options.merge_options(baml_options).call_function_async(function_name="OpenAIChatGPTTaskFilter", args={
                "task_list": task_list,
            })
            return typing.cast(types.TaskFilterResponse, result.cast_to(types, types, stream_types, False, __runtime__))
    async def OpenAIChatGPTTechnologyCorrection(self, unmatched_names: str,acceptable_enums: str,
        baml_options: BamlCallOptions = {},
    ) -> types.TechnologyCorrectionResponse:
        # Check if on_tick is provided
        if 'on_tick' in baml_options:
            # Use streaming internally when on_tick is provided
            stream = self.stream.OpenAIChatGPTTechnologyCorrection(unmatched_names=unmatched_names,acceptable_enums=acceptable_enums,
                baml_options=baml_options)
            return await stream.get_final_response()
        else:
            # Original non-streaming code
            result = await self.__options.merge_options(baml_options).call_function_async(function_name="OpenAIChatGPTTechnologyCorrection", args={
                "unmatched_names": unmatched_names,"acceptable_enums": acceptable_enums,
            })
            return typing.cast(types.TechnologyCorrectionResponse, result.cast_to(types, types, stream_types, False, __runtime__))
    async def OpenRouterCodeManager(self, tool_results: str,system_info: types.SystemInfo_CrossIndexing,
        baml_options: BamlCallOptions = {},
    ) -> types.CodeManagerResponse:
        # Check if on_tick is provided
        if 'on_tick' in baml_options:
            # Use streaming internally when on_tick is provided
            stream = self.stream.OpenRouterCodeManager(tool_results=tool_results,system_info=system_info,
                baml_options=baml_options)
            return await stream.get_final_response()
        else:
            # Original non-streaming code
            result = await self.__options.merge_options(baml_options).call_function_async(function_name="OpenRouterCodeManager", args={
                "tool_results": tool_results,"system_info": system_info,
            })
            return typing.cast(types.CodeManagerResponse, result.cast_to(types, types, stream_types, False, __runtime__))
    async def OpenRouterConnectionMatching(self, incoming_connections: str,outgoing_connections: str,
        baml_options: BamlCallOptions = {},
    ) -> types.ConnectionMatchingResponse:
        # Check if on_tick is provided
        if 'on_tick' in baml_options:
            # Use streaming internally when on_tick is provided
            stream = self.stream.OpenRouterConnectionMatching(incoming_connections=incoming_connections,outgoing_connections=outgoing_connections,
                baml_options=baml_options)
            return await stream.get_final_response()
        else:
            # Original non-streaming code
            result = await self.__options.merge_options(baml_options).call_function_async(function_name="OpenRouterConnectionMatching", args={
                "incoming_connections": incoming_connections,"outgoing_connections": outgoing_connections,
            })
            return typing.cast(types.ConnectionMatchingResponse, result.cast_to(types, types, stream_types, False, __runtime__))
    async def OpenRouterConnectionSplitting(self, memory_context: str,
        baml_options: BamlCallOptions = {},
    ) -> types.ConnectionSplittingResponse:
        # Check if on_tick is provided
        if 'on_tick' in baml_options:
            # Use streaming internally when on_tick is provided
            stream = self.stream.OpenRouterConnectionSplitting(memory_context=memory_context,
                baml_options=baml_options)
            return await stream.get_final_response()
        else:
            # Original non-streaming code
            result = await self.__options.merge_options(baml_options).call_function_async(function_name="OpenRouterConnectionSplitting", args={
                "memory_context": memory_context,
            })
            return typing.cast(types.ConnectionSplittingResponse, result.cast_to(types, types, stream_types, False, __runtime__))
    async def OpenRouterImplementationDiscovery(self, analysis_query: str,memory_context: str,system_info: types.SystemInfo_CrossIndexing,
        baml_options: BamlCallOptions = {},
    ) -> types.CrossIndexingResponse:
        # Check if on_tick is provided
        if 'on_tick' in baml_options:
            # Use streaming internally when on_tick is provided
            stream = self.stream.OpenRouterImplementationDiscovery(analysis_query=analysis_query,memory_context=memory_context,system_info=system_info,
                baml_options=baml_options)
            return await stream.get_final_response()
        else:
            # Original non-streaming code
            result = await self.__options.merge_options(baml_options).call_function_async(function_name="OpenRouterImplementationDiscovery", args={
                "analysis_query": analysis_query,"memory_context": memory_context,"system_info": system_info,
            })
            return typing.cast(types.CrossIndexingResponse, result.cast_to(types, types, stream_types, False, __runtime__))
    async def OpenRouterImportDiscovery(self, analysis_query: str,memory_context: str,system_info: types.SystemInfo_CrossIndexing,
        baml_options: BamlCallOptions = {},
    ) -> types.CrossIndexingResponse:
        # Check if on_tick is provided
        if 'on_tick' in baml_options:
            # Use streaming internally when on_tick is provided
            stream = self.stream.OpenRouterImportDiscovery(analysis_query=analysis_query,memory_context=memory_context,system_info=system_info,
                baml_options=baml_options)
            return await stream.get_final_response()
        else:
            # Original non-streaming code
            result = await self.__options.merge_options(baml_options).call_function_async(function_name="OpenRouterImportDiscovery", args={
                "analysis_query": analysis_query,"memory_context": memory_context,"system_info": system_info,
            })
            return typing.cast(types.CrossIndexingResponse, result.cast_to(types, types, stream_types, False, __runtime__))
    async def OpenRouterPackageDiscovery(self, analysis_query: str,memory_context: str,system_info: types.SystemInfo_CrossIndexing,
        baml_options: BamlCallOptions = {},
    ) -> types.CrossIndexingResponse:
        # Check if on_tick is provided
        if 'on_tick' in baml_options:
            # Use streaming internally when on_tick is provided
            stream = self.stream.OpenRouterPackageDiscovery(analysis_query=analysis_query,memory_context=memory_context,system_info=system_info,
                baml_options=baml_options)
            return await stream.get_final_response()
        else:
            # Original non-streaming code
            result = await self.__options.merge_options(baml_options).call_function_async(function_name="OpenRouterPackageDiscovery", args={
                "analysis_query": analysis_query,"memory_context": memory_context,"system_info": system_info,
            })
            return typing.cast(types.CrossIndexingResponse, result.cast_to(types, types, stream_types, False, __runtime__))
    async def OpenRouterRoadmapAgent(self, params: types.RoadmapAgentParams,
        baml_options: BamlCallOptions = {},
    ) -> types.RoadmapResponse:
        # Check if on_tick is provided
        if 'on_tick' in baml_options:
            # Use streaming internally when on_tick is provided
            stream = self.stream.OpenRouterRoadmapAgent(params=params,
                baml_options=baml_options)
            return await stream.get_final_response()
        else:
            # Original non-streaming code
            result = await self.__options.merge_options(baml_options).call_function_async(function_name="OpenRouterRoadmapAgent", args={
                "params": params,
            })
            return typing.cast(types.RoadmapResponse, result.cast_to(types, types, stream_types, False, __runtime__))
    async def OpenRouterTaskFilter(self, task_list: str,
        baml_options: BamlCallOptions = {},
    ) -> types.TaskFilterResponse:
        # Check if on_tick is provided
        if 'on_tick' in baml_options:
            # Use streaming internally when on_tick is provided
            stream = self.stream.OpenRouterTaskFilter(task_list=task_list,
                baml_options=baml_options)
            return await stream.get_final_response()
        else:
            # Original non-streaming code
            result = await self.__options.merge_options(baml_options).call_function_async(function_name="OpenRouterTaskFilter", args={
                "task_list": task_list,
            })
            return typing.cast(types.TaskFilterResponse, result.cast_to(types, types, stream_types, False, __runtime__))
    async def OpenRouterTechnologyCorrection(self, unmatched_names: str,acceptable_enums: str,
        baml_options: BamlCallOptions = {},
    ) -> types.TechnologyCorrectionResponse:
        # Check if on_tick is provided
        if 'on_tick' in baml_options:
            # Use streaming internally when on_tick is provided
            stream = self.stream.OpenRouterTechnologyCorrection(unmatched_names=unmatched_names,acceptable_enums=acceptable_enums,
                baml_options=baml_options)
            return await stream.get_final_response()
        else:
            # Original non-streaming code
            result = await self.__options.merge_options(baml_options).call_function_async(function_name="OpenRouterTechnologyCorrection", args={
                "unmatched_names": unmatched_names,"acceptable_enums": acceptable_enums,
            })
            return typing.cast(types.TechnologyCorrectionResponse, result.cast_to(types, types, stream_types, False, __runtime__))
    


class BamlStreamClient:
    __options: DoNotUseDirectlyCallManager

    def __init__(self, options: DoNotUseDirectlyCallManager):
        self.__options = options

    def AnthropicClaudeCodeManager(self, tool_results: str,system_info: types.SystemInfo_CrossIndexing,
        baml_options: BamlCallOptions = {},
    ) -> baml_py.BamlStream[stream_types.CodeManagerResponse, types.CodeManagerResponse]:
        ctx, result = self.__options.merge_options(baml_options).create_async_stream(function_name="AnthropicClaudeCodeManager", args={
            "tool_results": tool_results,"system_info": system_info,
        })
        return baml_py.BamlStream[stream_types.CodeManagerResponse, types.CodeManagerResponse](
          result,
          lambda x: typing.cast(stream_types.CodeManagerResponse, x.cast_to(types, types, stream_types, True, __runtime__)),
          lambda x: typing.cast(types.CodeManagerResponse, x.cast_to(types, types, stream_types, False, __runtime__)),
          ctx,
        )
    def AnthropicClaudeConnectionMatching(self, incoming_connections: str,outgoing_connections: str,
        baml_options: BamlCallOptions = {},
    ) -> baml_py.BamlStream[stream_types.ConnectionMatchingResponse, types.ConnectionMatchingResponse]:
        ctx, result = self.__options.merge_options(baml_options).create_async_stream(function_name="AnthropicClaudeConnectionMatching", args={
            "incoming_connections": incoming_connections,"outgoing_connections": outgoing_connections,
        })
        return baml_py.BamlStream[stream_types.ConnectionMatchingResponse, types.ConnectionMatchingResponse](
          result,
          lambda x: typing.cast(stream_types.ConnectionMatchingResponse, x.cast_to(types, types, stream_types, True, __runtime__)),
          lambda x: typing.cast(types.ConnectionMatchingResponse, x.cast_to(types, types, stream_types, False, __runtime__)),
          ctx,
        )
    def AnthropicClaudeConnectionSplitting(self, memory_context: str,
        baml_options: BamlCallOptions = {},
    ) -> baml_py.BamlStream[stream_types.ConnectionSplittingResponse, types.ConnectionSplittingResponse]:
        ctx, result = self.__options.merge_options(baml_options).create_async_stream(function_name="AnthropicClaudeConnectionSplitting", args={
            "memory_context": memory_context,
        })
        return baml_py.BamlStream[stream_types.ConnectionSplittingResponse, types.ConnectionSplittingResponse](
          result,
          lambda x: typing.cast(stream_types.ConnectionSplittingResponse, x.cast_to(types, types, stream_types, True, __runtime__)),
          lambda x: typing.cast(types.ConnectionSplittingResponse, x.cast_to(types, types, stream_types, False, __runtime__)),
          ctx,
        )
    def AnthropicClaudeImplementationDiscovery(self, analysis_query: str,memory_context: str,system_info: types.SystemInfo_CrossIndexing,
        baml_options: BamlCallOptions = {},
    ) -> baml_py.BamlStream[stream_types.CrossIndexingResponse, types.CrossIndexingResponse]:
        ctx, result = self.__options.merge_options(baml_options).create_async_stream(function_name="AnthropicClaudeImplementationDiscovery", args={
            "analysis_query": analysis_query,"memory_context": memory_context,"system_info": system_info,
        })
        return baml_py.BamlStream[stream_types.CrossIndexingResponse, types.CrossIndexingResponse](
          result,
          lambda x: typing.cast(stream_types.CrossIndexingResponse, x.cast_to(types, types, stream_types, True, __runtime__)),
          lambda x: typing.cast(types.CrossIndexingResponse, x.cast_to(types, types, stream_types, False, __runtime__)),
          ctx,
        )
    def AnthropicClaudeImportDiscovery(self, analysis_query: str,memory_context: str,system_info: types.SystemInfo_CrossIndexing,
        baml_options: BamlCallOptions = {},
    ) -> baml_py.BamlStream[stream_types.CrossIndexingResponse, types.CrossIndexingResponse]:
        ctx, result = self.__options.merge_options(baml_options).create_async_stream(function_name="AnthropicClaudeImportDiscovery", args={
            "analysis_query": analysis_query,"memory_context": memory_context,"system_info": system_info,
        })
        return baml_py.BamlStream[stream_types.CrossIndexingResponse, types.CrossIndexingResponse](
          result,
          lambda x: typing.cast(stream_types.CrossIndexingResponse, x.cast_to(types, types, stream_types, True, __runtime__)),
          lambda x: typing.cast(types.CrossIndexingResponse, x.cast_to(types, types, stream_types, False, __runtime__)),
          ctx,
        )
    def AnthropicClaudePackageDiscovery(self, analysis_query: str,memory_context: str,system_info: types.SystemInfo_CrossIndexing,
        baml_options: BamlCallOptions = {},
    ) -> baml_py.BamlStream[stream_types.CrossIndexingResponse, types.CrossIndexingResponse]:
        ctx, result = self.__options.merge_options(baml_options).create_async_stream(function_name="AnthropicClaudePackageDiscovery", args={
            "analysis_query": analysis_query,"memory_context": memory_context,"system_info": system_info,
        })
        return baml_py.BamlStream[stream_types.CrossIndexingResponse, types.CrossIndexingResponse](
          result,
          lambda x: typing.cast(stream_types.CrossIndexingResponse, x.cast_to(types, types, stream_types, True, __runtime__)),
          lambda x: typing.cast(types.CrossIndexingResponse, x.cast_to(types, types, stream_types, False, __runtime__)),
          ctx,
        )
    def AnthropicClaudeRoadmapAgent(self, params: types.RoadmapAgentParams,
        baml_options: BamlCallOptions = {},
    ) -> baml_py.BamlStream[stream_types.RoadmapResponse, types.RoadmapResponse]:
        ctx, result = self.__options.merge_options(baml_options).create_async_stream(function_name="AnthropicClaudeRoadmapAgent", args={
            "params": params,
        })
        return baml_py.BamlStream[stream_types.RoadmapResponse, types.RoadmapResponse](
          result,
          lambda x: typing.cast(stream_types.RoadmapResponse, x.cast_to(types, types, stream_types, True, __runtime__)),
          lambda x: typing.cast(types.RoadmapResponse, x.cast_to(types, types, stream_types, False, __runtime__)),
          ctx,
        )
    def AnthropicClaudeTaskFilter(self, task_list: str,
        baml_options: BamlCallOptions = {},
    ) -> baml_py.BamlStream[stream_types.TaskFilterResponse, types.TaskFilterResponse]:
        ctx, result = self.__options.merge_options(baml_options).create_async_stream(function_name="AnthropicClaudeTaskFilter", args={
            "task_list": task_list,
        })
        return baml_py.BamlStream[stream_types.TaskFilterResponse, types.TaskFilterResponse](
          result,
          lambda x: typing.cast(stream_types.TaskFilterResponse, x.cast_to(types, types, stream_types, True, __runtime__)),
          lambda x: typing.cast(types.TaskFilterResponse, x.cast_to(types, types, stream_types, False, __runtime__)),
          ctx,
        )
    def AnthropicClaudeTechnologyCorrection(self, unmatched_names: str,acceptable_enums: str,
        baml_options: BamlCallOptions = {},
    ) -> baml_py.BamlStream[stream_types.TechnologyCorrectionResponse, types.TechnologyCorrectionResponse]:
        ctx, result = self.__options.merge_options(baml_options).create_async_stream(function_name="AnthropicClaudeTechnologyCorrection", args={
            "unmatched_names": unmatched_names,"acceptable_enums": acceptable_enums,
        })
        return baml_py.BamlStream[stream_types.TechnologyCorrectionResponse, types.TechnologyCorrectionResponse](
          result,
          lambda x: typing.cast(stream_types.TechnologyCorrectionResponse, x.cast_to(types, types, stream_types, True, __runtime__)),
          lambda x: typing.cast(types.TechnologyCorrectionResponse, x.cast_to(types, types, stream_types, False, __runtime__)),
          ctx,
        )
    def AwsBedrockCodeManager(self, tool_results: str,system_info: types.SystemInfo_CrossIndexing,
        baml_options: BamlCallOptions = {},
    ) -> baml_py.BamlStream[stream_types.CodeManagerResponse, types.CodeManagerResponse]:
        ctx, result = self.__options.merge_options(baml_options).create_async_stream(function_name="AwsBedrockCodeManager", args={
            "tool_results": tool_results,"system_info": system_info,
        })
        return baml_py.BamlStream[stream_types.CodeManagerResponse, types.CodeManagerResponse](
          result,
          lambda x: typing.cast(stream_types.CodeManagerResponse, x.cast_to(types, types, stream_types, True, __runtime__)),
          lambda x: typing.cast(types.CodeManagerResponse, x.cast_to(types, types, stream_types, False, __runtime__)),
          ctx,
        )
    def AwsBedrockConnectionMatching(self, incoming_connections: str,outgoing_connections: str,
        baml_options: BamlCallOptions = {},
    ) -> baml_py.BamlStream[stream_types.ConnectionMatchingResponse, types.ConnectionMatchingResponse]:
        ctx, result = self.__options.merge_options(baml_options).create_async_stream(function_name="AwsBedrockConnectionMatching", args={
            "incoming_connections": incoming_connections,"outgoing_connections": outgoing_connections,
        })
        return baml_py.BamlStream[stream_types.ConnectionMatchingResponse, types.ConnectionMatchingResponse](
          result,
          lambda x: typing.cast(stream_types.ConnectionMatchingResponse, x.cast_to(types, types, stream_types, True, __runtime__)),
          lambda x: typing.cast(types.ConnectionMatchingResponse, x.cast_to(types, types, stream_types, False, __runtime__)),
          ctx,
        )
    def AwsBedrockConnectionSplitting(self, memory_context: str,
        baml_options: BamlCallOptions = {},
    ) -> baml_py.BamlStream[stream_types.ConnectionSplittingResponse, types.ConnectionSplittingResponse]:
        ctx, result = self.__options.merge_options(baml_options).create_async_stream(function_name="AwsBedrockConnectionSplitting", args={
            "memory_context": memory_context,
        })
        return baml_py.BamlStream[stream_types.ConnectionSplittingResponse, types.ConnectionSplittingResponse](
          result,
          lambda x: typing.cast(stream_types.ConnectionSplittingResponse, x.cast_to(types, types, stream_types, True, __runtime__)),
          lambda x: typing.cast(types.ConnectionSplittingResponse, x.cast_to(types, types, stream_types, False, __runtime__)),
          ctx,
        )
    def AwsBedrockImplementationDiscovery(self, analysis_query: str,memory_context: str,system_info: types.SystemInfo_CrossIndexing,
        baml_options: BamlCallOptions = {},
    ) -> baml_py.BamlStream[stream_types.CrossIndexingResponse, types.CrossIndexingResponse]:
        ctx, result = self.__options.merge_options(baml_options).create_async_stream(function_name="AwsBedrockImplementationDiscovery", args={
            "analysis_query": analysis_query,"memory_context": memory_context,"system_info": system_info,
        })
        return baml_py.BamlStream[stream_types.CrossIndexingResponse, types.CrossIndexingResponse](
          result,
          lambda x: typing.cast(stream_types.CrossIndexingResponse, x.cast_to(types, types, stream_types, True, __runtime__)),
          lambda x: typing.cast(types.CrossIndexingResponse, x.cast_to(types, types, stream_types, False, __runtime__)),
          ctx,
        )
    def AwsBedrockImportDiscovery(self, analysis_query: str,memory_context: str,system_info: types.SystemInfo_CrossIndexing,
        baml_options: BamlCallOptions = {},
    ) -> baml_py.BamlStream[stream_types.CrossIndexingResponse, types.CrossIndexingResponse]:
        ctx, result = self.__options.merge_options(baml_options).create_async_stream(function_name="AwsBedrockImportDiscovery", args={
            "analysis_query": analysis_query,"memory_context": memory_context,"system_info": system_info,
        })
        return baml_py.BamlStream[stream_types.CrossIndexingResponse, types.CrossIndexingResponse](
          result,
          lambda x: typing.cast(stream_types.CrossIndexingResponse, x.cast_to(types, types, stream_types, True, __runtime__)),
          lambda x: typing.cast(types.CrossIndexingResponse, x.cast_to(types, types, stream_types, False, __runtime__)),
          ctx,
        )
    def AwsBedrockPackageDiscovery(self, analysis_query: str,memory_context: str,system_info: types.SystemInfo_CrossIndexing,
        baml_options: BamlCallOptions = {},
    ) -> baml_py.BamlStream[stream_types.CrossIndexingResponse, types.CrossIndexingResponse]:
        ctx, result = self.__options.merge_options(baml_options).create_async_stream(function_name="AwsBedrockPackageDiscovery", args={
            "analysis_query": analysis_query,"memory_context": memory_context,"system_info": system_info,
        })
        return baml_py.BamlStream[stream_types.CrossIndexingResponse, types.CrossIndexingResponse](
          result,
          lambda x: typing.cast(stream_types.CrossIndexingResponse, x.cast_to(types, types, stream_types, True, __runtime__)),
          lambda x: typing.cast(types.CrossIndexingResponse, x.cast_to(types, types, stream_types, False, __runtime__)),
          ctx,
        )
    def AwsBedrockRoadmapAgent(self, params: types.RoadmapAgentParams,
        baml_options: BamlCallOptions = {},
    ) -> baml_py.BamlStream[stream_types.RoadmapResponse, types.RoadmapResponse]:
        ctx, result = self.__options.merge_options(baml_options).create_async_stream(function_name="AwsBedrockRoadmapAgent", args={
            "params": params,
        })
        return baml_py.BamlStream[stream_types.RoadmapResponse, types.RoadmapResponse](
          result,
          lambda x: typing.cast(stream_types.RoadmapResponse, x.cast_to(types, types, stream_types, True, __runtime__)),
          lambda x: typing.cast(types.RoadmapResponse, x.cast_to(types, types, stream_types, False, __runtime__)),
          ctx,
        )
    def AwsBedrockTaskFilter(self, task_list: str,
        baml_options: BamlCallOptions = {},
    ) -> baml_py.BamlStream[stream_types.TaskFilterResponse, types.TaskFilterResponse]:
        ctx, result = self.__options.merge_options(baml_options).create_async_stream(function_name="AwsBedrockTaskFilter", args={
            "task_list": task_list,
        })
        return baml_py.BamlStream[stream_types.TaskFilterResponse, types.TaskFilterResponse](
          result,
          lambda x: typing.cast(stream_types.TaskFilterResponse, x.cast_to(types, types, stream_types, True, __runtime__)),
          lambda x: typing.cast(types.TaskFilterResponse, x.cast_to(types, types, stream_types, False, __runtime__)),
          ctx,
        )
    def AwsBedrockTechnologyCorrection(self, unmatched_names: str,acceptable_enums: str,
        baml_options: BamlCallOptions = {},
    ) -> baml_py.BamlStream[stream_types.TechnologyCorrectionResponse, types.TechnologyCorrectionResponse]:
        ctx, result = self.__options.merge_options(baml_options).create_async_stream(function_name="AwsBedrockTechnologyCorrection", args={
            "unmatched_names": unmatched_names,"acceptable_enums": acceptable_enums,
        })
        return baml_py.BamlStream[stream_types.TechnologyCorrectionResponse, types.TechnologyCorrectionResponse](
          result,
          lambda x: typing.cast(stream_types.TechnologyCorrectionResponse, x.cast_to(types, types, stream_types, True, __runtime__)),
          lambda x: typing.cast(types.TechnologyCorrectionResponse, x.cast_to(types, types, stream_types, False, __runtime__)),
          ctx,
        )
    def AzureAIFoundryCodeManager(self, tool_results: str,system_info: types.SystemInfo_CrossIndexing,
        baml_options: BamlCallOptions = {},
    ) -> baml_py.BamlStream[stream_types.CodeManagerResponse, types.CodeManagerResponse]:
        ctx, result = self.__options.merge_options(baml_options).create_async_stream(function_name="AzureAIFoundryCodeManager", args={
            "tool_results": tool_results,"system_info": system_info,
        })
        return baml_py.BamlStream[stream_types.CodeManagerResponse, types.CodeManagerResponse](
          result,
          lambda x: typing.cast(stream_types.CodeManagerResponse, x.cast_to(types, types, stream_types, True, __runtime__)),
          lambda x: typing.cast(types.CodeManagerResponse, x.cast_to(types, types, stream_types, False, __runtime__)),
          ctx,
        )
    def AzureAIFoundryConnectionMatching(self, incoming_connections: str,outgoing_connections: str,
        baml_options: BamlCallOptions = {},
    ) -> baml_py.BamlStream[stream_types.ConnectionMatchingResponse, types.ConnectionMatchingResponse]:
        ctx, result = self.__options.merge_options(baml_options).create_async_stream(function_name="AzureAIFoundryConnectionMatching", args={
            "incoming_connections": incoming_connections,"outgoing_connections": outgoing_connections,
        })
        return baml_py.BamlStream[stream_types.ConnectionMatchingResponse, types.ConnectionMatchingResponse](
          result,
          lambda x: typing.cast(stream_types.ConnectionMatchingResponse, x.cast_to(types, types, stream_types, True, __runtime__)),
          lambda x: typing.cast(types.ConnectionMatchingResponse, x.cast_to(types, types, stream_types, False, __runtime__)),
          ctx,
        )
    def AzureAIFoundryConnectionSplitting(self, memory_context: str,
        baml_options: BamlCallOptions = {},
    ) -> baml_py.BamlStream[stream_types.ConnectionSplittingResponse, types.ConnectionSplittingResponse]:
        ctx, result = self.__options.merge_options(baml_options).create_async_stream(function_name="AzureAIFoundryConnectionSplitting", args={
            "memory_context": memory_context,
        })
        return baml_py.BamlStream[stream_types.ConnectionSplittingResponse, types.ConnectionSplittingResponse](
          result,
          lambda x: typing.cast(stream_types.ConnectionSplittingResponse, x.cast_to(types, types, stream_types, True, __runtime__)),
          lambda x: typing.cast(types.ConnectionSplittingResponse, x.cast_to(types, types, stream_types, False, __runtime__)),
          ctx,
        )
    def AzureAIFoundryImplementationDiscovery(self, analysis_query: str,memory_context: str,system_info: types.SystemInfo_CrossIndexing,
        baml_options: BamlCallOptions = {},
    ) -> baml_py.BamlStream[stream_types.CrossIndexingResponse, types.CrossIndexingResponse]:
        ctx, result = self.__options.merge_options(baml_options).create_async_stream(function_name="AzureAIFoundryImplementationDiscovery", args={
            "analysis_query": analysis_query,"memory_context": memory_context,"system_info": system_info,
        })
        return baml_py.BamlStream[stream_types.CrossIndexingResponse, types.CrossIndexingResponse](
          result,
          lambda x: typing.cast(stream_types.CrossIndexingResponse, x.cast_to(types, types, stream_types, True, __runtime__)),
          lambda x: typing.cast(types.CrossIndexingResponse, x.cast_to(types, types, stream_types, False, __runtime__)),
          ctx,
        )
    def AzureAIFoundryImportDiscovery(self, analysis_query: str,memory_context: str,system_info: types.SystemInfo_CrossIndexing,
        baml_options: BamlCallOptions = {},
    ) -> baml_py.BamlStream[stream_types.CrossIndexingResponse, types.CrossIndexingResponse]:
        ctx, result = self.__options.merge_options(baml_options).create_async_stream(function_name="AzureAIFoundryImportDiscovery", args={
            "analysis_query": analysis_query,"memory_context": memory_context,"system_info": system_info,
        })
        return baml_py.BamlStream[stream_types.CrossIndexingResponse, types.CrossIndexingResponse](
          result,
          lambda x: typing.cast(stream_types.CrossIndexingResponse, x.cast_to(types, types, stream_types, True, __runtime__)),
          lambda x: typing.cast(types.CrossIndexingResponse, x.cast_to(types, types, stream_types, False, __runtime__)),
          ctx,
        )
    def AzureAIFoundryPackageDiscovery(self, analysis_query: str,memory_context: str,system_info: types.SystemInfo_CrossIndexing,
        baml_options: BamlCallOptions = {},
    ) -> baml_py.BamlStream[stream_types.CrossIndexingResponse, types.CrossIndexingResponse]:
        ctx, result = self.__options.merge_options(baml_options).create_async_stream(function_name="AzureAIFoundryPackageDiscovery", args={
            "analysis_query": analysis_query,"memory_context": memory_context,"system_info": system_info,
        })
        return baml_py.BamlStream[stream_types.CrossIndexingResponse, types.CrossIndexingResponse](
          result,
          lambda x: typing.cast(stream_types.CrossIndexingResponse, x.cast_to(types, types, stream_types, True, __runtime__)),
          lambda x: typing.cast(types.CrossIndexingResponse, x.cast_to(types, types, stream_types, False, __runtime__)),
          ctx,
        )
    def AzureAIFoundryRoadmapAgent(self, params: types.RoadmapAgentParams,
        baml_options: BamlCallOptions = {},
    ) -> baml_py.BamlStream[stream_types.RoadmapResponse, types.RoadmapResponse]:
        ctx, result = self.__options.merge_options(baml_options).create_async_stream(function_name="AzureAIFoundryRoadmapAgent", args={
            "params": params,
        })
        return baml_py.BamlStream[stream_types.RoadmapResponse, types.RoadmapResponse](
          result,
          lambda x: typing.cast(stream_types.RoadmapResponse, x.cast_to(types, types, stream_types, True, __runtime__)),
          lambda x: typing.cast(types.RoadmapResponse, x.cast_to(types, types, stream_types, False, __runtime__)),
          ctx,
        )
    def AzureAIFoundryTaskFilter(self, task_list: str,
        baml_options: BamlCallOptions = {},
    ) -> baml_py.BamlStream[stream_types.TaskFilterResponse, types.TaskFilterResponse]:
        ctx, result = self.__options.merge_options(baml_options).create_async_stream(function_name="AzureAIFoundryTaskFilter", args={
            "task_list": task_list,
        })
        return baml_py.BamlStream[stream_types.TaskFilterResponse, types.TaskFilterResponse](
          result,
          lambda x: typing.cast(stream_types.TaskFilterResponse, x.cast_to(types, types, stream_types, True, __runtime__)),
          lambda x: typing.cast(types.TaskFilterResponse, x.cast_to(types, types, stream_types, False, __runtime__)),
          ctx,
        )
    def AzureAIFoundryTechnologyCorrection(self, unmatched_names: str,acceptable_enums: str,
        baml_options: BamlCallOptions = {},
    ) -> baml_py.BamlStream[stream_types.TechnologyCorrectionResponse, types.TechnologyCorrectionResponse]:
        ctx, result = self.__options.merge_options(baml_options).create_async_stream(function_name="AzureAIFoundryTechnologyCorrection", args={
            "unmatched_names": unmatched_names,"acceptable_enums": acceptable_enums,
        })
        return baml_py.BamlStream[stream_types.TechnologyCorrectionResponse, types.TechnologyCorrectionResponse](
          result,
          lambda x: typing.cast(stream_types.TechnologyCorrectionResponse, x.cast_to(types, types, stream_types, True, __runtime__)),
          lambda x: typing.cast(types.TechnologyCorrectionResponse, x.cast_to(types, types, stream_types, False, __runtime__)),
          ctx,
        )
    def AzureOpenAICodeManager(self, tool_results: str,system_info: types.SystemInfo_CrossIndexing,
        baml_options: BamlCallOptions = {},
    ) -> baml_py.BamlStream[stream_types.CodeManagerResponse, types.CodeManagerResponse]:
        ctx, result = self.__options.merge_options(baml_options).create_async_stream(function_name="AzureOpenAICodeManager", args={
            "tool_results": tool_results,"system_info": system_info,
        })
        return baml_py.BamlStream[stream_types.CodeManagerResponse, types.CodeManagerResponse](
          result,
          lambda x: typing.cast(stream_types.CodeManagerResponse, x.cast_to(types, types, stream_types, True, __runtime__)),
          lambda x: typing.cast(types.CodeManagerResponse, x.cast_to(types, types, stream_types, False, __runtime__)),
          ctx,
        )
    def AzureOpenAIConnectionMatching(self, incoming_connections: str,outgoing_connections: str,
        baml_options: BamlCallOptions = {},
    ) -> baml_py.BamlStream[stream_types.ConnectionMatchingResponse, types.ConnectionMatchingResponse]:
        ctx, result = self.__options.merge_options(baml_options).create_async_stream(function_name="AzureOpenAIConnectionMatching", args={
            "incoming_connections": incoming_connections,"outgoing_connections": outgoing_connections,
        })
        return baml_py.BamlStream[stream_types.ConnectionMatchingResponse, types.ConnectionMatchingResponse](
          result,
          lambda x: typing.cast(stream_types.ConnectionMatchingResponse, x.cast_to(types, types, stream_types, True, __runtime__)),
          lambda x: typing.cast(types.ConnectionMatchingResponse, x.cast_to(types, types, stream_types, False, __runtime__)),
          ctx,
        )
    def AzureOpenAIConnectionSplitting(self, memory_context: str,
        baml_options: BamlCallOptions = {},
    ) -> baml_py.BamlStream[stream_types.ConnectionSplittingResponse, types.ConnectionSplittingResponse]:
        ctx, result = self.__options.merge_options(baml_options).create_async_stream(function_name="AzureOpenAIConnectionSplitting", args={
            "memory_context": memory_context,
        })
        return baml_py.BamlStream[stream_types.ConnectionSplittingResponse, types.ConnectionSplittingResponse](
          result,
          lambda x: typing.cast(stream_types.ConnectionSplittingResponse, x.cast_to(types, types, stream_types, True, __runtime__)),
          lambda x: typing.cast(types.ConnectionSplittingResponse, x.cast_to(types, types, stream_types, False, __runtime__)),
          ctx,
        )
    def AzureOpenAIImplementationDiscovery(self, analysis_query: str,memory_context: str,system_info: types.SystemInfo_CrossIndexing,
        baml_options: BamlCallOptions = {},
    ) -> baml_py.BamlStream[stream_types.CrossIndexingResponse, types.CrossIndexingResponse]:
        ctx, result = self.__options.merge_options(baml_options).create_async_stream(function_name="AzureOpenAIImplementationDiscovery", args={
            "analysis_query": analysis_query,"memory_context": memory_context,"system_info": system_info,
        })
        return baml_py.BamlStream[stream_types.CrossIndexingResponse, types.CrossIndexingResponse](
          result,
          lambda x: typing.cast(stream_types.CrossIndexingResponse, x.cast_to(types, types, stream_types, True, __runtime__)),
          lambda x: typing.cast(types.CrossIndexingResponse, x.cast_to(types, types, stream_types, False, __runtime__)),
          ctx,
        )
    def AzureOpenAIImportDiscovery(self, analysis_query: str,memory_context: str,system_info: types.SystemInfo_CrossIndexing,
        baml_options: BamlCallOptions = {},
    ) -> baml_py.BamlStream[stream_types.CrossIndexingResponse, types.CrossIndexingResponse]:
        ctx, result = self.__options.merge_options(baml_options).create_async_stream(function_name="AzureOpenAIImportDiscovery", args={
            "analysis_query": analysis_query,"memory_context": memory_context,"system_info": system_info,
        })
        return baml_py.BamlStream[stream_types.CrossIndexingResponse, types.CrossIndexingResponse](
          result,
          lambda x: typing.cast(stream_types.CrossIndexingResponse, x.cast_to(types, types, stream_types, True, __runtime__)),
          lambda x: typing.cast(types.CrossIndexingResponse, x.cast_to(types, types, stream_types, False, __runtime__)),
          ctx,
        )
    def AzureOpenAIPackageDiscovery(self, analysis_query: str,memory_context: str,system_info: types.SystemInfo_CrossIndexing,
        baml_options: BamlCallOptions = {},
    ) -> baml_py.BamlStream[stream_types.CrossIndexingResponse, types.CrossIndexingResponse]:
        ctx, result = self.__options.merge_options(baml_options).create_async_stream(function_name="AzureOpenAIPackageDiscovery", args={
            "analysis_query": analysis_query,"memory_context": memory_context,"system_info": system_info,
        })
        return baml_py.BamlStream[stream_types.CrossIndexingResponse, types.CrossIndexingResponse](
          result,
          lambda x: typing.cast(stream_types.CrossIndexingResponse, x.cast_to(types, types, stream_types, True, __runtime__)),
          lambda x: typing.cast(types.CrossIndexingResponse, x.cast_to(types, types, stream_types, False, __runtime__)),
          ctx,
        )
    def AzureOpenAIRoadmapAgent(self, params: types.RoadmapAgentParams,
        baml_options: BamlCallOptions = {},
    ) -> baml_py.BamlStream[stream_types.RoadmapResponse, types.RoadmapResponse]:
        ctx, result = self.__options.merge_options(baml_options).create_async_stream(function_name="AzureOpenAIRoadmapAgent", args={
            "params": params,
        })
        return baml_py.BamlStream[stream_types.RoadmapResponse, types.RoadmapResponse](
          result,
          lambda x: typing.cast(stream_types.RoadmapResponse, x.cast_to(types, types, stream_types, True, __runtime__)),
          lambda x: typing.cast(types.RoadmapResponse, x.cast_to(types, types, stream_types, False, __runtime__)),
          ctx,
        )
    def AzureOpenAITaskFilter(self, task_list: str,
        baml_options: BamlCallOptions = {},
    ) -> baml_py.BamlStream[stream_types.TaskFilterResponse, types.TaskFilterResponse]:
        ctx, result = self.__options.merge_options(baml_options).create_async_stream(function_name="AzureOpenAITaskFilter", args={
            "task_list": task_list,
        })
        return baml_py.BamlStream[stream_types.TaskFilterResponse, types.TaskFilterResponse](
          result,
          lambda x: typing.cast(stream_types.TaskFilterResponse, x.cast_to(types, types, stream_types, True, __runtime__)),
          lambda x: typing.cast(types.TaskFilterResponse, x.cast_to(types, types, stream_types, False, __runtime__)),
          ctx,
        )
    def AzureOpenAITechnologyCorrection(self, unmatched_names: str,acceptable_enums: str,
        baml_options: BamlCallOptions = {},
    ) -> baml_py.BamlStream[stream_types.TechnologyCorrectionResponse, types.TechnologyCorrectionResponse]:
        ctx, result = self.__options.merge_options(baml_options).create_async_stream(function_name="AzureOpenAITechnologyCorrection", args={
            "unmatched_names": unmatched_names,"acceptable_enums": acceptable_enums,
        })
        return baml_py.BamlStream[stream_types.TechnologyCorrectionResponse, types.TechnologyCorrectionResponse](
          result,
          lambda x: typing.cast(stream_types.TechnologyCorrectionResponse, x.cast_to(types, types, stream_types, True, __runtime__)),
          lambda x: typing.cast(types.TechnologyCorrectionResponse, x.cast_to(types, types, stream_types, False, __runtime__)),
          ctx,
        )
    def GCPVertexAICodeManager(self, tool_results: str,system_info: types.SystemInfo_CrossIndexing,
        baml_options: BamlCallOptions = {},
    ) -> baml_py.BamlStream[stream_types.CodeManagerResponse, types.CodeManagerResponse]:
        ctx, result = self.__options.merge_options(baml_options).create_async_stream(function_name="GCPVertexAICodeManager", args={
            "tool_results": tool_results,"system_info": system_info,
        })
        return baml_py.BamlStream[stream_types.CodeManagerResponse, types.CodeManagerResponse](
          result,
          lambda x: typing.cast(stream_types.CodeManagerResponse, x.cast_to(types, types, stream_types, True, __runtime__)),
          lambda x: typing.cast(types.CodeManagerResponse, x.cast_to(types, types, stream_types, False, __runtime__)),
          ctx,
        )
    def GCPVertexAIConnectionMatching(self, incoming_connections: str,outgoing_connections: str,
        baml_options: BamlCallOptions = {},
    ) -> baml_py.BamlStream[stream_types.ConnectionMatchingResponse, types.ConnectionMatchingResponse]:
        ctx, result = self.__options.merge_options(baml_options).create_async_stream(function_name="GCPVertexAIConnectionMatching", args={
            "incoming_connections": incoming_connections,"outgoing_connections": outgoing_connections,
        })
        return baml_py.BamlStream[stream_types.ConnectionMatchingResponse, types.ConnectionMatchingResponse](
          result,
          lambda x: typing.cast(stream_types.ConnectionMatchingResponse, x.cast_to(types, types, stream_types, True, __runtime__)),
          lambda x: typing.cast(types.ConnectionMatchingResponse, x.cast_to(types, types, stream_types, False, __runtime__)),
          ctx,
        )
    def GCPVertexAIConnectionSplitting(self, memory_context: str,
        baml_options: BamlCallOptions = {},
    ) -> baml_py.BamlStream[stream_types.ConnectionSplittingResponse, types.ConnectionSplittingResponse]:
        ctx, result = self.__options.merge_options(baml_options).create_async_stream(function_name="GCPVertexAIConnectionSplitting", args={
            "memory_context": memory_context,
        })
        return baml_py.BamlStream[stream_types.ConnectionSplittingResponse, types.ConnectionSplittingResponse](
          result,
          lambda x: typing.cast(stream_types.ConnectionSplittingResponse, x.cast_to(types, types, stream_types, True, __runtime__)),
          lambda x: typing.cast(types.ConnectionSplittingResponse, x.cast_to(types, types, stream_types, False, __runtime__)),
          ctx,
        )
    def GCPVertexAIImplementationDiscovery(self, analysis_query: str,memory_context: str,system_info: types.SystemInfo_CrossIndexing,
        baml_options: BamlCallOptions = {},
    ) -> baml_py.BamlStream[stream_types.CrossIndexingResponse, types.CrossIndexingResponse]:
        ctx, result = self.__options.merge_options(baml_options).create_async_stream(function_name="GCPVertexAIImplementationDiscovery", args={
            "analysis_query": analysis_query,"memory_context": memory_context,"system_info": system_info,
        })
        return baml_py.BamlStream[stream_types.CrossIndexingResponse, types.CrossIndexingResponse](
          result,
          lambda x: typing.cast(stream_types.CrossIndexingResponse, x.cast_to(types, types, stream_types, True, __runtime__)),
          lambda x: typing.cast(types.CrossIndexingResponse, x.cast_to(types, types, stream_types, False, __runtime__)),
          ctx,
        )
    def GCPVertexAIImportDiscovery(self, analysis_query: str,memory_context: str,system_info: types.SystemInfo_CrossIndexing,
        baml_options: BamlCallOptions = {},
    ) -> baml_py.BamlStream[stream_types.CrossIndexingResponse, types.CrossIndexingResponse]:
        ctx, result = self.__options.merge_options(baml_options).create_async_stream(function_name="GCPVertexAIImportDiscovery", args={
            "analysis_query": analysis_query,"memory_context": memory_context,"system_info": system_info,
        })
        return baml_py.BamlStream[stream_types.CrossIndexingResponse, types.CrossIndexingResponse](
          result,
          lambda x: typing.cast(stream_types.CrossIndexingResponse, x.cast_to(types, types, stream_types, True, __runtime__)),
          lambda x: typing.cast(types.CrossIndexingResponse, x.cast_to(types, types, stream_types, False, __runtime__)),
          ctx,
        )
    def GCPVertexAIPackageDiscovery(self, analysis_query: str,memory_context: str,system_info: types.SystemInfo_CrossIndexing,
        baml_options: BamlCallOptions = {},
    ) -> baml_py.BamlStream[stream_types.CrossIndexingResponse, types.CrossIndexingResponse]:
        ctx, result = self.__options.merge_options(baml_options).create_async_stream(function_name="GCPVertexAIPackageDiscovery", args={
            "analysis_query": analysis_query,"memory_context": memory_context,"system_info": system_info,
        })
        return baml_py.BamlStream[stream_types.CrossIndexingResponse, types.CrossIndexingResponse](
          result,
          lambda x: typing.cast(stream_types.CrossIndexingResponse, x.cast_to(types, types, stream_types, True, __runtime__)),
          lambda x: typing.cast(types.CrossIndexingResponse, x.cast_to(types, types, stream_types, False, __runtime__)),
          ctx,
        )
    def GCPVertexAIRoadmapAgent(self, params: types.RoadmapAgentParams,
        baml_options: BamlCallOptions = {},
    ) -> baml_py.BamlStream[stream_types.RoadmapResponse, types.RoadmapResponse]:
        ctx, result = self.__options.merge_options(baml_options).create_async_stream(function_name="GCPVertexAIRoadmapAgent", args={
            "params": params,
        })
        return baml_py.BamlStream[stream_types.RoadmapResponse, types.RoadmapResponse](
          result,
          lambda x: typing.cast(stream_types.RoadmapResponse, x.cast_to(types, types, stream_types, True, __runtime__)),
          lambda x: typing.cast(types.RoadmapResponse, x.cast_to(types, types, stream_types, False, __runtime__)),
          ctx,
        )
    def GCPVertexAITaskFilter(self, task_list: str,
        baml_options: BamlCallOptions = {},
    ) -> baml_py.BamlStream[stream_types.TaskFilterResponse, types.TaskFilterResponse]:
        ctx, result = self.__options.merge_options(baml_options).create_async_stream(function_name="GCPVertexAITaskFilter", args={
            "task_list": task_list,
        })
        return baml_py.BamlStream[stream_types.TaskFilterResponse, types.TaskFilterResponse](
          result,
          lambda x: typing.cast(stream_types.TaskFilterResponse, x.cast_to(types, types, stream_types, True, __runtime__)),
          lambda x: typing.cast(types.TaskFilterResponse, x.cast_to(types, types, stream_types, False, __runtime__)),
          ctx,
        )
    def GCPVertexAITechnologyCorrection(self, unmatched_names: str,acceptable_enums: str,
        baml_options: BamlCallOptions = {},
    ) -> baml_py.BamlStream[stream_types.TechnologyCorrectionResponse, types.TechnologyCorrectionResponse]:
        ctx, result = self.__options.merge_options(baml_options).create_async_stream(function_name="GCPVertexAITechnologyCorrection", args={
            "unmatched_names": unmatched_names,"acceptable_enums": acceptable_enums,
        })
        return baml_py.BamlStream[stream_types.TechnologyCorrectionResponse, types.TechnologyCorrectionResponse](
          result,
          lambda x: typing.cast(stream_types.TechnologyCorrectionResponse, x.cast_to(types, types, stream_types, True, __runtime__)),
          lambda x: typing.cast(types.TechnologyCorrectionResponse, x.cast_to(types, types, stream_types, False, __runtime__)),
          ctx,
        )
    def GoogleGeminiCodeManager(self, tool_results: str,system_info: types.SystemInfo_CrossIndexing,
        baml_options: BamlCallOptions = {},
    ) -> baml_py.BamlStream[stream_types.CodeManagerResponse, types.CodeManagerResponse]:
        ctx, result = self.__options.merge_options(baml_options).create_async_stream(function_name="GoogleGeminiCodeManager", args={
            "tool_results": tool_results,"system_info": system_info,
        })
        return baml_py.BamlStream[stream_types.CodeManagerResponse, types.CodeManagerResponse](
          result,
          lambda x: typing.cast(stream_types.CodeManagerResponse, x.cast_to(types, types, stream_types, True, __runtime__)),
          lambda x: typing.cast(types.CodeManagerResponse, x.cast_to(types, types, stream_types, False, __runtime__)),
          ctx,
        )
    def GoogleGeminiConnectionMatching(self, incoming_connections: str,outgoing_connections: str,
        baml_options: BamlCallOptions = {},
    ) -> baml_py.BamlStream[stream_types.ConnectionMatchingResponse, types.ConnectionMatchingResponse]:
        ctx, result = self.__options.merge_options(baml_options).create_async_stream(function_name="GoogleGeminiConnectionMatching", args={
            "incoming_connections": incoming_connections,"outgoing_connections": outgoing_connections,
        })
        return baml_py.BamlStream[stream_types.ConnectionMatchingResponse, types.ConnectionMatchingResponse](
          result,
          lambda x: typing.cast(stream_types.ConnectionMatchingResponse, x.cast_to(types, types, stream_types, True, __runtime__)),
          lambda x: typing.cast(types.ConnectionMatchingResponse, x.cast_to(types, types, stream_types, False, __runtime__)),
          ctx,
        )
    def GoogleGeminiConnectionSplitting(self, memory_context: str,
        baml_options: BamlCallOptions = {},
    ) -> baml_py.BamlStream[stream_types.ConnectionSplittingResponse, types.ConnectionSplittingResponse]:
        ctx, result = self.__options.merge_options(baml_options).create_async_stream(function_name="GoogleGeminiConnectionSplitting", args={
            "memory_context": memory_context,
        })
        return baml_py.BamlStream[stream_types.ConnectionSplittingResponse, types.ConnectionSplittingResponse](
          result,
          lambda x: typing.cast(stream_types.ConnectionSplittingResponse, x.cast_to(types, types, stream_types, True, __runtime__)),
          lambda x: typing.cast(types.ConnectionSplittingResponse, x.cast_to(types, types, stream_types, False, __runtime__)),
          ctx,
        )
    def GoogleGeminiImplementationDiscovery(self, analysis_query: str,memory_context: str,system_info: types.SystemInfo_CrossIndexing,
        baml_options: BamlCallOptions = {},
    ) -> baml_py.BamlStream[stream_types.CrossIndexingResponse, types.CrossIndexingResponse]:
        ctx, result = self.__options.merge_options(baml_options).create_async_stream(function_name="GoogleGeminiImplementationDiscovery", args={
            "analysis_query": analysis_query,"memory_context": memory_context,"system_info": system_info,
        })
        return baml_py.BamlStream[stream_types.CrossIndexingResponse, types.CrossIndexingResponse](
          result,
          lambda x: typing.cast(stream_types.CrossIndexingResponse, x.cast_to(types, types, stream_types, True, __runtime__)),
          lambda x: typing.cast(types.CrossIndexingResponse, x.cast_to(types, types, stream_types, False, __runtime__)),
          ctx,
        )
    def GoogleGeminiImportDiscovery(self, analysis_query: str,memory_context: str,system_info: types.SystemInfo_CrossIndexing,
        baml_options: BamlCallOptions = {},
    ) -> baml_py.BamlStream[stream_types.CrossIndexingResponse, types.CrossIndexingResponse]:
        ctx, result = self.__options.merge_options(baml_options).create_async_stream(function_name="GoogleGeminiImportDiscovery", args={
            "analysis_query": analysis_query,"memory_context": memory_context,"system_info": system_info,
        })
        return baml_py.BamlStream[stream_types.CrossIndexingResponse, types.CrossIndexingResponse](
          result,
          lambda x: typing.cast(stream_types.CrossIndexingResponse, x.cast_to(types, types, stream_types, True, __runtime__)),
          lambda x: typing.cast(types.CrossIndexingResponse, x.cast_to(types, types, stream_types, False, __runtime__)),
          ctx,
        )
    def GoogleGeminiPackageDiscovery(self, analysis_query: str,memory_context: str,system_info: types.SystemInfo_CrossIndexing,
        baml_options: BamlCallOptions = {},
    ) -> baml_py.BamlStream[stream_types.CrossIndexingResponse, types.CrossIndexingResponse]:
        ctx, result = self.__options.merge_options(baml_options).create_async_stream(function_name="GoogleGeminiPackageDiscovery", args={
            "analysis_query": analysis_query,"memory_context": memory_context,"system_info": system_info,
        })
        return baml_py.BamlStream[stream_types.CrossIndexingResponse, types.CrossIndexingResponse](
          result,
          lambda x: typing.cast(stream_types.CrossIndexingResponse, x.cast_to(types, types, stream_types, True, __runtime__)),
          lambda x: typing.cast(types.CrossIndexingResponse, x.cast_to(types, types, stream_types, False, __runtime__)),
          ctx,
        )
    def GoogleGeminiRoadmapAgent(self, params: types.RoadmapAgentParams,
        baml_options: BamlCallOptions = {},
    ) -> baml_py.BamlStream[stream_types.RoadmapResponse, types.RoadmapResponse]:
        ctx, result = self.__options.merge_options(baml_options).create_async_stream(function_name="GoogleGeminiRoadmapAgent", args={
            "params": params,
        })
        return baml_py.BamlStream[stream_types.RoadmapResponse, types.RoadmapResponse](
          result,
          lambda x: typing.cast(stream_types.RoadmapResponse, x.cast_to(types, types, stream_types, True, __runtime__)),
          lambda x: typing.cast(types.RoadmapResponse, x.cast_to(types, types, stream_types, False, __runtime__)),
          ctx,
        )
    def GoogleGeminiTaskFilter(self, task_list: str,
        baml_options: BamlCallOptions = {},
    ) -> baml_py.BamlStream[stream_types.TaskFilterResponse, types.TaskFilterResponse]:
        ctx, result = self.__options.merge_options(baml_options).create_async_stream(function_name="GoogleGeminiTaskFilter", args={
            "task_list": task_list,
        })
        return baml_py.BamlStream[stream_types.TaskFilterResponse, types.TaskFilterResponse](
          result,
          lambda x: typing.cast(stream_types.TaskFilterResponse, x.cast_to(types, types, stream_types, True, __runtime__)),
          lambda x: typing.cast(types.TaskFilterResponse, x.cast_to(types, types, stream_types, False, __runtime__)),
          ctx,
        )
    def GoogleGeminiTechnologyCorrection(self, unmatched_names: str,acceptable_enums: str,
        baml_options: BamlCallOptions = {},
    ) -> baml_py.BamlStream[stream_types.TechnologyCorrectionResponse, types.TechnologyCorrectionResponse]:
        ctx, result = self.__options.merge_options(baml_options).create_async_stream(function_name="GoogleGeminiTechnologyCorrection", args={
            "unmatched_names": unmatched_names,"acceptable_enums": acceptable_enums,
        })
        return baml_py.BamlStream[stream_types.TechnologyCorrectionResponse, types.TechnologyCorrectionResponse](
          result,
          lambda x: typing.cast(stream_types.TechnologyCorrectionResponse, x.cast_to(types, types, stream_types, True, __runtime__)),
          lambda x: typing.cast(types.TechnologyCorrectionResponse, x.cast_to(types, types, stream_types, False, __runtime__)),
          ctx,
        )
    def OpenAIChatGPTCodeManager(self, tool_results: str,system_info: types.SystemInfo_CrossIndexing,
        baml_options: BamlCallOptions = {},
    ) -> baml_py.BamlStream[stream_types.CodeManagerResponse, types.CodeManagerResponse]:
        ctx, result = self.__options.merge_options(baml_options).create_async_stream(function_name="OpenAIChatGPTCodeManager", args={
            "tool_results": tool_results,"system_info": system_info,
        })
        return baml_py.BamlStream[stream_types.CodeManagerResponse, types.CodeManagerResponse](
          result,
          lambda x: typing.cast(stream_types.CodeManagerResponse, x.cast_to(types, types, stream_types, True, __runtime__)),
          lambda x: typing.cast(types.CodeManagerResponse, x.cast_to(types, types, stream_types, False, __runtime__)),
          ctx,
        )
    def OpenAIChatGPTConnectionMatching(self, incoming_connections: str,outgoing_connections: str,
        baml_options: BamlCallOptions = {},
    ) -> baml_py.BamlStream[stream_types.ConnectionMatchingResponse, types.ConnectionMatchingResponse]:
        ctx, result = self.__options.merge_options(baml_options).create_async_stream(function_name="OpenAIChatGPTConnectionMatching", args={
            "incoming_connections": incoming_connections,"outgoing_connections": outgoing_connections,
        })
        return baml_py.BamlStream[stream_types.ConnectionMatchingResponse, types.ConnectionMatchingResponse](
          result,
          lambda x: typing.cast(stream_types.ConnectionMatchingResponse, x.cast_to(types, types, stream_types, True, __runtime__)),
          lambda x: typing.cast(types.ConnectionMatchingResponse, x.cast_to(types, types, stream_types, False, __runtime__)),
          ctx,
        )
    def OpenAIChatGPTConnectionSplitting(self, memory_context: str,
        baml_options: BamlCallOptions = {},
    ) -> baml_py.BamlStream[stream_types.ConnectionSplittingResponse, types.ConnectionSplittingResponse]:
        ctx, result = self.__options.merge_options(baml_options).create_async_stream(function_name="OpenAIChatGPTConnectionSplitting", args={
            "memory_context": memory_context,
        })
        return baml_py.BamlStream[stream_types.ConnectionSplittingResponse, types.ConnectionSplittingResponse](
          result,
          lambda x: typing.cast(stream_types.ConnectionSplittingResponse, x.cast_to(types, types, stream_types, True, __runtime__)),
          lambda x: typing.cast(types.ConnectionSplittingResponse, x.cast_to(types, types, stream_types, False, __runtime__)),
          ctx,
        )
    def OpenAIChatGPTImplementationDiscovery(self, analysis_query: str,memory_context: str,system_info: types.SystemInfo_CrossIndexing,
        baml_options: BamlCallOptions = {},
    ) -> baml_py.BamlStream[stream_types.CrossIndexingResponse, types.CrossIndexingResponse]:
        ctx, result = self.__options.merge_options(baml_options).create_async_stream(function_name="OpenAIChatGPTImplementationDiscovery", args={
            "analysis_query": analysis_query,"memory_context": memory_context,"system_info": system_info,
        })
        return baml_py.BamlStream[stream_types.CrossIndexingResponse, types.CrossIndexingResponse](
          result,
          lambda x: typing.cast(stream_types.CrossIndexingResponse, x.cast_to(types, types, stream_types, True, __runtime__)),
          lambda x: typing.cast(types.CrossIndexingResponse, x.cast_to(types, types, stream_types, False, __runtime__)),
          ctx,
        )
    def OpenAIChatGPTImportDiscovery(self, analysis_query: str,memory_context: str,system_info: types.SystemInfo_CrossIndexing,
        baml_options: BamlCallOptions = {},
    ) -> baml_py.BamlStream[stream_types.CrossIndexingResponse, types.CrossIndexingResponse]:
        ctx, result = self.__options.merge_options(baml_options).create_async_stream(function_name="OpenAIChatGPTImportDiscovery", args={
            "analysis_query": analysis_query,"memory_context": memory_context,"system_info": system_info,
        })
        return baml_py.BamlStream[stream_types.CrossIndexingResponse, types.CrossIndexingResponse](
          result,
          lambda x: typing.cast(stream_types.CrossIndexingResponse, x.cast_to(types, types, stream_types, True, __runtime__)),
          lambda x: typing.cast(types.CrossIndexingResponse, x.cast_to(types, types, stream_types, False, __runtime__)),
          ctx,
        )
    def OpenAIChatGPTPackageDiscovery(self, analysis_query: str,memory_context: str,system_info: types.SystemInfo_CrossIndexing,
        baml_options: BamlCallOptions = {},
    ) -> baml_py.BamlStream[stream_types.CrossIndexingResponse, types.CrossIndexingResponse]:
        ctx, result = self.__options.merge_options(baml_options).create_async_stream(function_name="OpenAIChatGPTPackageDiscovery", args={
            "analysis_query": analysis_query,"memory_context": memory_context,"system_info": system_info,
        })
        return baml_py.BamlStream[stream_types.CrossIndexingResponse, types.CrossIndexingResponse](
          result,
          lambda x: typing.cast(stream_types.CrossIndexingResponse, x.cast_to(types, types, stream_types, True, __runtime__)),
          lambda x: typing.cast(types.CrossIndexingResponse, x.cast_to(types, types, stream_types, False, __runtime__)),
          ctx,
        )
    def OpenAIChatGPTRoadmapAgent(self, params: types.RoadmapAgentParams,
        baml_options: BamlCallOptions = {},
    ) -> baml_py.BamlStream[stream_types.RoadmapResponse, types.RoadmapResponse]:
        ctx, result = self.__options.merge_options(baml_options).create_async_stream(function_name="OpenAIChatGPTRoadmapAgent", args={
            "params": params,
        })
        return baml_py.BamlStream[stream_types.RoadmapResponse, types.RoadmapResponse](
          result,
          lambda x: typing.cast(stream_types.RoadmapResponse, x.cast_to(types, types, stream_types, True, __runtime__)),
          lambda x: typing.cast(types.RoadmapResponse, x.cast_to(types, types, stream_types, False, __runtime__)),
          ctx,
        )
    def OpenAIChatGPTTaskFilter(self, task_list: str,
        baml_options: BamlCallOptions = {},
    ) -> baml_py.BamlStream[stream_types.TaskFilterResponse, types.TaskFilterResponse]:
        ctx, result = self.__options.merge_options(baml_options).create_async_stream(function_name="OpenAIChatGPTTaskFilter", args={
            "task_list": task_list,
        })
        return baml_py.BamlStream[stream_types.TaskFilterResponse, types.TaskFilterResponse](
          result,
          lambda x: typing.cast(stream_types.TaskFilterResponse, x.cast_to(types, types, stream_types, True, __runtime__)),
          lambda x: typing.cast(types.TaskFilterResponse, x.cast_to(types, types, stream_types, False, __runtime__)),
          ctx,
        )
    def OpenAIChatGPTTechnologyCorrection(self, unmatched_names: str,acceptable_enums: str,
        baml_options: BamlCallOptions = {},
    ) -> baml_py.BamlStream[stream_types.TechnologyCorrectionResponse, types.TechnologyCorrectionResponse]:
        ctx, result = self.__options.merge_options(baml_options).create_async_stream(function_name="OpenAIChatGPTTechnologyCorrection", args={
            "unmatched_names": unmatched_names,"acceptable_enums": acceptable_enums,
        })
        return baml_py.BamlStream[stream_types.TechnologyCorrectionResponse, types.TechnologyCorrectionResponse](
          result,
          lambda x: typing.cast(stream_types.TechnologyCorrectionResponse, x.cast_to(types, types, stream_types, True, __runtime__)),
          lambda x: typing.cast(types.TechnologyCorrectionResponse, x.cast_to(types, types, stream_types, False, __runtime__)),
          ctx,
        )
    def OpenRouterCodeManager(self, tool_results: str,system_info: types.SystemInfo_CrossIndexing,
        baml_options: BamlCallOptions = {},
    ) -> baml_py.BamlStream[stream_types.CodeManagerResponse, types.CodeManagerResponse]:
        ctx, result = self.__options.merge_options(baml_options).create_async_stream(function_name="OpenRouterCodeManager", args={
            "tool_results": tool_results,"system_info": system_info,
        })
        return baml_py.BamlStream[stream_types.CodeManagerResponse, types.CodeManagerResponse](
          result,
          lambda x: typing.cast(stream_types.CodeManagerResponse, x.cast_to(types, types, stream_types, True, __runtime__)),
          lambda x: typing.cast(types.CodeManagerResponse, x.cast_to(types, types, stream_types, False, __runtime__)),
          ctx,
        )
    def OpenRouterConnectionMatching(self, incoming_connections: str,outgoing_connections: str,
        baml_options: BamlCallOptions = {},
    ) -> baml_py.BamlStream[stream_types.ConnectionMatchingResponse, types.ConnectionMatchingResponse]:
        ctx, result = self.__options.merge_options(baml_options).create_async_stream(function_name="OpenRouterConnectionMatching", args={
            "incoming_connections": incoming_connections,"outgoing_connections": outgoing_connections,
        })
        return baml_py.BamlStream[stream_types.ConnectionMatchingResponse, types.ConnectionMatchingResponse](
          result,
          lambda x: typing.cast(stream_types.ConnectionMatchingResponse, x.cast_to(types, types, stream_types, True, __runtime__)),
          lambda x: typing.cast(types.ConnectionMatchingResponse, x.cast_to(types, types, stream_types, False, __runtime__)),
          ctx,
        )
    def OpenRouterConnectionSplitting(self, memory_context: str,
        baml_options: BamlCallOptions = {},
    ) -> baml_py.BamlStream[stream_types.ConnectionSplittingResponse, types.ConnectionSplittingResponse]:
        ctx, result = self.__options.merge_options(baml_options).create_async_stream(function_name="OpenRouterConnectionSplitting", args={
            "memory_context": memory_context,
        })
        return baml_py.BamlStream[stream_types.ConnectionSplittingResponse, types.ConnectionSplittingResponse](
          result,
          lambda x: typing.cast(stream_types.ConnectionSplittingResponse, x.cast_to(types, types, stream_types, True, __runtime__)),
          lambda x: typing.cast(types.ConnectionSplittingResponse, x.cast_to(types, types, stream_types, False, __runtime__)),
          ctx,
        )
    def OpenRouterImplementationDiscovery(self, analysis_query: str,memory_context: str,system_info: types.SystemInfo_CrossIndexing,
        baml_options: BamlCallOptions = {},
    ) -> baml_py.BamlStream[stream_types.CrossIndexingResponse, types.CrossIndexingResponse]:
        ctx, result = self.__options.merge_options(baml_options).create_async_stream(function_name="OpenRouterImplementationDiscovery", args={
            "analysis_query": analysis_query,"memory_context": memory_context,"system_info": system_info,
        })
        return baml_py.BamlStream[stream_types.CrossIndexingResponse, types.CrossIndexingResponse](
          result,
          lambda x: typing.cast(stream_types.CrossIndexingResponse, x.cast_to(types, types, stream_types, True, __runtime__)),
          lambda x: typing.cast(types.CrossIndexingResponse, x.cast_to(types, types, stream_types, False, __runtime__)),
          ctx,
        )
    def OpenRouterImportDiscovery(self, analysis_query: str,memory_context: str,system_info: types.SystemInfo_CrossIndexing,
        baml_options: BamlCallOptions = {},
    ) -> baml_py.BamlStream[stream_types.CrossIndexingResponse, types.CrossIndexingResponse]:
        ctx, result = self.__options.merge_options(baml_options).create_async_stream(function_name="OpenRouterImportDiscovery", args={
            "analysis_query": analysis_query,"memory_context": memory_context,"system_info": system_info,
        })
        return baml_py.BamlStream[stream_types.CrossIndexingResponse, types.CrossIndexingResponse](
          result,
          lambda x: typing.cast(stream_types.CrossIndexingResponse, x.cast_to(types, types, stream_types, True, __runtime__)),
          lambda x: typing.cast(types.CrossIndexingResponse, x.cast_to(types, types, stream_types, False, __runtime__)),
          ctx,
        )
    def OpenRouterPackageDiscovery(self, analysis_query: str,memory_context: str,system_info: types.SystemInfo_CrossIndexing,
        baml_options: BamlCallOptions = {},
    ) -> baml_py.BamlStream[stream_types.CrossIndexingResponse, types.CrossIndexingResponse]:
        ctx, result = self.__options.merge_options(baml_options).create_async_stream(function_name="OpenRouterPackageDiscovery", args={
            "analysis_query": analysis_query,"memory_context": memory_context,"system_info": system_info,
        })
        return baml_py.BamlStream[stream_types.CrossIndexingResponse, types.CrossIndexingResponse](
          result,
          lambda x: typing.cast(stream_types.CrossIndexingResponse, x.cast_to(types, types, stream_types, True, __runtime__)),
          lambda x: typing.cast(types.CrossIndexingResponse, x.cast_to(types, types, stream_types, False, __runtime__)),
          ctx,
        )
    def OpenRouterRoadmapAgent(self, params: types.RoadmapAgentParams,
        baml_options: BamlCallOptions = {},
    ) -> baml_py.BamlStream[stream_types.RoadmapResponse, types.RoadmapResponse]:
        ctx, result = self.__options.merge_options(baml_options).create_async_stream(function_name="OpenRouterRoadmapAgent", args={
            "params": params,
        })
        return baml_py.BamlStream[stream_types.RoadmapResponse, types.RoadmapResponse](
          result,
          lambda x: typing.cast(stream_types.RoadmapResponse, x.cast_to(types, types, stream_types, True, __runtime__)),
          lambda x: typing.cast(types.RoadmapResponse, x.cast_to(types, types, stream_types, False, __runtime__)),
          ctx,
        )
    def OpenRouterTaskFilter(self, task_list: str,
        baml_options: BamlCallOptions = {},
    ) -> baml_py.BamlStream[stream_types.TaskFilterResponse, types.TaskFilterResponse]:
        ctx, result = self.__options.merge_options(baml_options).create_async_stream(function_name="OpenRouterTaskFilter", args={
            "task_list": task_list,
        })
        return baml_py.BamlStream[stream_types.TaskFilterResponse, types.TaskFilterResponse](
          result,
          lambda x: typing.cast(stream_types.TaskFilterResponse, x.cast_to(types, types, stream_types, True, __runtime__)),
          lambda x: typing.cast(types.TaskFilterResponse, x.cast_to(types, types, stream_types, False, __runtime__)),
          ctx,
        )
    def OpenRouterTechnologyCorrection(self, unmatched_names: str,acceptable_enums: str,
        baml_options: BamlCallOptions = {},
    ) -> baml_py.BamlStream[stream_types.TechnologyCorrectionResponse, types.TechnologyCorrectionResponse]:
        ctx, result = self.__options.merge_options(baml_options).create_async_stream(function_name="OpenRouterTechnologyCorrection", args={
            "unmatched_names": unmatched_names,"acceptable_enums": acceptable_enums,
        })
        return baml_py.BamlStream[stream_types.TechnologyCorrectionResponse, types.TechnologyCorrectionResponse](
          result,
          lambda x: typing.cast(stream_types.TechnologyCorrectionResponse, x.cast_to(types, types, stream_types, True, __runtime__)),
          lambda x: typing.cast(types.TechnologyCorrectionResponse, x.cast_to(types, types, stream_types, False, __runtime__)),
          ctx,
        )
    

class BamlHttpRequestClient:
    __options: DoNotUseDirectlyCallManager

    def __init__(self, options: DoNotUseDirectlyCallManager):
        self.__options = options

    async def AnthropicClaudeCodeManager(self, tool_results: str,system_info: types.SystemInfo_CrossIndexing,
        baml_options: BamlCallOptions = {},
    ) -> baml_py.baml_py.HTTPRequest:
        result = await self.__options.merge_options(baml_options).create_http_request_async(function_name="AnthropicClaudeCodeManager", args={
            "tool_results": tool_results,"system_info": system_info,
        }, mode="request")
        return result
    async def AnthropicClaudeConnectionMatching(self, incoming_connections: str,outgoing_connections: str,
        baml_options: BamlCallOptions = {},
    ) -> baml_py.baml_py.HTTPRequest:
        result = await self.__options.merge_options(baml_options).create_http_request_async(function_name="AnthropicClaudeConnectionMatching", args={
            "incoming_connections": incoming_connections,"outgoing_connections": outgoing_connections,
        }, mode="request")
        return result
    async def AnthropicClaudeConnectionSplitting(self, memory_context: str,
        baml_options: BamlCallOptions = {},
    ) -> baml_py.baml_py.HTTPRequest:
        result = await self.__options.merge_options(baml_options).create_http_request_async(function_name="AnthropicClaudeConnectionSplitting", args={
            "memory_context": memory_context,
        }, mode="request")
        return result
    async def AnthropicClaudeImplementationDiscovery(self, analysis_query: str,memory_context: str,system_info: types.SystemInfo_CrossIndexing,
        baml_options: BamlCallOptions = {},
    ) -> baml_py.baml_py.HTTPRequest:
        result = await self.__options.merge_options(baml_options).create_http_request_async(function_name="AnthropicClaudeImplementationDiscovery", args={
            "analysis_query": analysis_query,"memory_context": memory_context,"system_info": system_info,
        }, mode="request")
        return result
    async def AnthropicClaudeImportDiscovery(self, analysis_query: str,memory_context: str,system_info: types.SystemInfo_CrossIndexing,
        baml_options: BamlCallOptions = {},
    ) -> baml_py.baml_py.HTTPRequest:
        result = await self.__options.merge_options(baml_options).create_http_request_async(function_name="AnthropicClaudeImportDiscovery", args={
            "analysis_query": analysis_query,"memory_context": memory_context,"system_info": system_info,
        }, mode="request")
        return result
    async def AnthropicClaudePackageDiscovery(self, analysis_query: str,memory_context: str,system_info: types.SystemInfo_CrossIndexing,
        baml_options: BamlCallOptions = {},
    ) -> baml_py.baml_py.HTTPRequest:
        result = await self.__options.merge_options(baml_options).create_http_request_async(function_name="AnthropicClaudePackageDiscovery", args={
            "analysis_query": analysis_query,"memory_context": memory_context,"system_info": system_info,
        }, mode="request")
        return result
    async def AnthropicClaudeRoadmapAgent(self, params: types.RoadmapAgentParams,
        baml_options: BamlCallOptions = {},
    ) -> baml_py.baml_py.HTTPRequest:
        result = await self.__options.merge_options(baml_options).create_http_request_async(function_name="AnthropicClaudeRoadmapAgent", args={
            "params": params,
        }, mode="request")
        return result
    async def AnthropicClaudeTaskFilter(self, task_list: str,
        baml_options: BamlCallOptions = {},
    ) -> baml_py.baml_py.HTTPRequest:
        result = await self.__options.merge_options(baml_options).create_http_request_async(function_name="AnthropicClaudeTaskFilter", args={
            "task_list": task_list,
        }, mode="request")
        return result
    async def AnthropicClaudeTechnologyCorrection(self, unmatched_names: str,acceptable_enums: str,
        baml_options: BamlCallOptions = {},
    ) -> baml_py.baml_py.HTTPRequest:
        result = await self.__options.merge_options(baml_options).create_http_request_async(function_name="AnthropicClaudeTechnologyCorrection", args={
            "unmatched_names": unmatched_names,"acceptable_enums": acceptable_enums,
        }, mode="request")
        return result
    async def AwsBedrockCodeManager(self, tool_results: str,system_info: types.SystemInfo_CrossIndexing,
        baml_options: BamlCallOptions = {},
    ) -> baml_py.baml_py.HTTPRequest:
        result = await self.__options.merge_options(baml_options).create_http_request_async(function_name="AwsBedrockCodeManager", args={
            "tool_results": tool_results,"system_info": system_info,
        }, mode="request")
        return result
    async def AwsBedrockConnectionMatching(self, incoming_connections: str,outgoing_connections: str,
        baml_options: BamlCallOptions = {},
    ) -> baml_py.baml_py.HTTPRequest:
        result = await self.__options.merge_options(baml_options).create_http_request_async(function_name="AwsBedrockConnectionMatching", args={
            "incoming_connections": incoming_connections,"outgoing_connections": outgoing_connections,
        }, mode="request")
        return result
    async def AwsBedrockConnectionSplitting(self, memory_context: str,
        baml_options: BamlCallOptions = {},
    ) -> baml_py.baml_py.HTTPRequest:
        result = await self.__options.merge_options(baml_options).create_http_request_async(function_name="AwsBedrockConnectionSplitting", args={
            "memory_context": memory_context,
        }, mode="request")
        return result
    async def AwsBedrockImplementationDiscovery(self, analysis_query: str,memory_context: str,system_info: types.SystemInfo_CrossIndexing,
        baml_options: BamlCallOptions = {},
    ) -> baml_py.baml_py.HTTPRequest:
        result = await self.__options.merge_options(baml_options).create_http_request_async(function_name="AwsBedrockImplementationDiscovery", args={
            "analysis_query": analysis_query,"memory_context": memory_context,"system_info": system_info,
        }, mode="request")
        return result
    async def AwsBedrockImportDiscovery(self, analysis_query: str,memory_context: str,system_info: types.SystemInfo_CrossIndexing,
        baml_options: BamlCallOptions = {},
    ) -> baml_py.baml_py.HTTPRequest:
        result = await self.__options.merge_options(baml_options).create_http_request_async(function_name="AwsBedrockImportDiscovery", args={
            "analysis_query": analysis_query,"memory_context": memory_context,"system_info": system_info,
        }, mode="request")
        return result
    async def AwsBedrockPackageDiscovery(self, analysis_query: str,memory_context: str,system_info: types.SystemInfo_CrossIndexing,
        baml_options: BamlCallOptions = {},
    ) -> baml_py.baml_py.HTTPRequest:
        result = await self.__options.merge_options(baml_options).create_http_request_async(function_name="AwsBedrockPackageDiscovery", args={
            "analysis_query": analysis_query,"memory_context": memory_context,"system_info": system_info,
        }, mode="request")
        return result
    async def AwsBedrockRoadmapAgent(self, params: types.RoadmapAgentParams,
        baml_options: BamlCallOptions = {},
    ) -> baml_py.baml_py.HTTPRequest:
        result = await self.__options.merge_options(baml_options).create_http_request_async(function_name="AwsBedrockRoadmapAgent", args={
            "params": params,
        }, mode="request")
        return result
    async def AwsBedrockTaskFilter(self, task_list: str,
        baml_options: BamlCallOptions = {},
    ) -> baml_py.baml_py.HTTPRequest:
        result = await self.__options.merge_options(baml_options).create_http_request_async(function_name="AwsBedrockTaskFilter", args={
            "task_list": task_list,
        }, mode="request")
        return result
    async def AwsBedrockTechnologyCorrection(self, unmatched_names: str,acceptable_enums: str,
        baml_options: BamlCallOptions = {},
    ) -> baml_py.baml_py.HTTPRequest:
        result = await self.__options.merge_options(baml_options).create_http_request_async(function_name="AwsBedrockTechnologyCorrection", args={
            "unmatched_names": unmatched_names,"acceptable_enums": acceptable_enums,
        }, mode="request")
        return result
    async def AzureAIFoundryCodeManager(self, tool_results: str,system_info: types.SystemInfo_CrossIndexing,
        baml_options: BamlCallOptions = {},
    ) -> baml_py.baml_py.HTTPRequest:
        result = await self.__options.merge_options(baml_options).create_http_request_async(function_name="AzureAIFoundryCodeManager", args={
            "tool_results": tool_results,"system_info": system_info,
        }, mode="request")
        return result
    async def AzureAIFoundryConnectionMatching(self, incoming_connections: str,outgoing_connections: str,
        baml_options: BamlCallOptions = {},
    ) -> baml_py.baml_py.HTTPRequest:
        result = await self.__options.merge_options(baml_options).create_http_request_async(function_name="AzureAIFoundryConnectionMatching", args={
            "incoming_connections": incoming_connections,"outgoing_connections": outgoing_connections,
        }, mode="request")
        return result
    async def AzureAIFoundryConnectionSplitting(self, memory_context: str,
        baml_options: BamlCallOptions = {},
    ) -> baml_py.baml_py.HTTPRequest:
        result = await self.__options.merge_options(baml_options).create_http_request_async(function_name="AzureAIFoundryConnectionSplitting", args={
            "memory_context": memory_context,
        }, mode="request")
        return result
    async def AzureAIFoundryImplementationDiscovery(self, analysis_query: str,memory_context: str,system_info: types.SystemInfo_CrossIndexing,
        baml_options: BamlCallOptions = {},
    ) -> baml_py.baml_py.HTTPRequest:
        result = await self.__options.merge_options(baml_options).create_http_request_async(function_name="AzureAIFoundryImplementationDiscovery", args={
            "analysis_query": analysis_query,"memory_context": memory_context,"system_info": system_info,
        }, mode="request")
        return result
    async def AzureAIFoundryImportDiscovery(self, analysis_query: str,memory_context: str,system_info: types.SystemInfo_CrossIndexing,
        baml_options: BamlCallOptions = {},
    ) -> baml_py.baml_py.HTTPRequest:
        result = await self.__options.merge_options(baml_options).create_http_request_async(function_name="AzureAIFoundryImportDiscovery", args={
            "analysis_query": analysis_query,"memory_context": memory_context,"system_info": system_info,
        }, mode="request")
        return result
    async def AzureAIFoundryPackageDiscovery(self, analysis_query: str,memory_context: str,system_info: types.SystemInfo_CrossIndexing,
        baml_options: BamlCallOptions = {},
    ) -> baml_py.baml_py.HTTPRequest:
        result = await self.__options.merge_options(baml_options).create_http_request_async(function_name="AzureAIFoundryPackageDiscovery", args={
            "analysis_query": analysis_query,"memory_context": memory_context,"system_info": system_info,
        }, mode="request")
        return result
    async def AzureAIFoundryRoadmapAgent(self, params: types.RoadmapAgentParams,
        baml_options: BamlCallOptions = {},
    ) -> baml_py.baml_py.HTTPRequest:
        result = await self.__options.merge_options(baml_options).create_http_request_async(function_name="AzureAIFoundryRoadmapAgent", args={
            "params": params,
        }, mode="request")
        return result
    async def AzureAIFoundryTaskFilter(self, task_list: str,
        baml_options: BamlCallOptions = {},
    ) -> baml_py.baml_py.HTTPRequest:
        result = await self.__options.merge_options(baml_options).create_http_request_async(function_name="AzureAIFoundryTaskFilter", args={
            "task_list": task_list,
        }, mode="request")
        return result
    async def AzureAIFoundryTechnologyCorrection(self, unmatched_names: str,acceptable_enums: str,
        baml_options: BamlCallOptions = {},
    ) -> baml_py.baml_py.HTTPRequest:
        result = await self.__options.merge_options(baml_options).create_http_request_async(function_name="AzureAIFoundryTechnologyCorrection", args={
            "unmatched_names": unmatched_names,"acceptable_enums": acceptable_enums,
        }, mode="request")
        return result
    async def AzureOpenAICodeManager(self, tool_results: str,system_info: types.SystemInfo_CrossIndexing,
        baml_options: BamlCallOptions = {},
    ) -> baml_py.baml_py.HTTPRequest:
        result = await self.__options.merge_options(baml_options).create_http_request_async(function_name="AzureOpenAICodeManager", args={
            "tool_results": tool_results,"system_info": system_info,
        }, mode="request")
        return result
    async def AzureOpenAIConnectionMatching(self, incoming_connections: str,outgoing_connections: str,
        baml_options: BamlCallOptions = {},
    ) -> baml_py.baml_py.HTTPRequest:
        result = await self.__options.merge_options(baml_options).create_http_request_async(function_name="AzureOpenAIConnectionMatching", args={
            "incoming_connections": incoming_connections,"outgoing_connections": outgoing_connections,
        }, mode="request")
        return result
    async def AzureOpenAIConnectionSplitting(self, memory_context: str,
        baml_options: BamlCallOptions = {},
    ) -> baml_py.baml_py.HTTPRequest:
        result = await self.__options.merge_options(baml_options).create_http_request_async(function_name="AzureOpenAIConnectionSplitting", args={
            "memory_context": memory_context,
        }, mode="request")
        return result
    async def AzureOpenAIImplementationDiscovery(self, analysis_query: str,memory_context: str,system_info: types.SystemInfo_CrossIndexing,
        baml_options: BamlCallOptions = {},
    ) -> baml_py.baml_py.HTTPRequest:
        result = await self.__options.merge_options(baml_options).create_http_request_async(function_name="AzureOpenAIImplementationDiscovery", args={
            "analysis_query": analysis_query,"memory_context": memory_context,"system_info": system_info,
        }, mode="request")
        return result
    async def AzureOpenAIImportDiscovery(self, analysis_query: str,memory_context: str,system_info: types.SystemInfo_CrossIndexing,
        baml_options: BamlCallOptions = {},
    ) -> baml_py.baml_py.HTTPRequest:
        result = await self.__options.merge_options(baml_options).create_http_request_async(function_name="AzureOpenAIImportDiscovery", args={
            "analysis_query": analysis_query,"memory_context": memory_context,"system_info": system_info,
        }, mode="request")
        return result
    async def AzureOpenAIPackageDiscovery(self, analysis_query: str,memory_context: str,system_info: types.SystemInfo_CrossIndexing,
        baml_options: BamlCallOptions = {},
    ) -> baml_py.baml_py.HTTPRequest:
        result = await self.__options.merge_options(baml_options).create_http_request_async(function_name="AzureOpenAIPackageDiscovery", args={
            "analysis_query": analysis_query,"memory_context": memory_context,"system_info": system_info,
        }, mode="request")
        return result
    async def AzureOpenAIRoadmapAgent(self, params: types.RoadmapAgentParams,
        baml_options: BamlCallOptions = {},
    ) -> baml_py.baml_py.HTTPRequest:
        result = await self.__options.merge_options(baml_options).create_http_request_async(function_name="AzureOpenAIRoadmapAgent", args={
            "params": params,
        }, mode="request")
        return result
    async def AzureOpenAITaskFilter(self, task_list: str,
        baml_options: BamlCallOptions = {},
    ) -> baml_py.baml_py.HTTPRequest:
        result = await self.__options.merge_options(baml_options).create_http_request_async(function_name="AzureOpenAITaskFilter", args={
            "task_list": task_list,
        }, mode="request")
        return result
    async def AzureOpenAITechnologyCorrection(self, unmatched_names: str,acceptable_enums: str,
        baml_options: BamlCallOptions = {},
    ) -> baml_py.baml_py.HTTPRequest:
        result = await self.__options.merge_options(baml_options).create_http_request_async(function_name="AzureOpenAITechnologyCorrection", args={
            "unmatched_names": unmatched_names,"acceptable_enums": acceptable_enums,
        }, mode="request")
        return result
    async def GCPVertexAICodeManager(self, tool_results: str,system_info: types.SystemInfo_CrossIndexing,
        baml_options: BamlCallOptions = {},
    ) -> baml_py.baml_py.HTTPRequest:
        result = await self.__options.merge_options(baml_options).create_http_request_async(function_name="GCPVertexAICodeManager", args={
            "tool_results": tool_results,"system_info": system_info,
        }, mode="request")
        return result
    async def GCPVertexAIConnectionMatching(self, incoming_connections: str,outgoing_connections: str,
        baml_options: BamlCallOptions = {},
    ) -> baml_py.baml_py.HTTPRequest:
        result = await self.__options.merge_options(baml_options).create_http_request_async(function_name="GCPVertexAIConnectionMatching", args={
            "incoming_connections": incoming_connections,"outgoing_connections": outgoing_connections,
        }, mode="request")
        return result
    async def GCPVertexAIConnectionSplitting(self, memory_context: str,
        baml_options: BamlCallOptions = {},
    ) -> baml_py.baml_py.HTTPRequest:
        result = await self.__options.merge_options(baml_options).create_http_request_async(function_name="GCPVertexAIConnectionSplitting", args={
            "memory_context": memory_context,
        }, mode="request")
        return result
    async def GCPVertexAIImplementationDiscovery(self, analysis_query: str,memory_context: str,system_info: types.SystemInfo_CrossIndexing,
        baml_options: BamlCallOptions = {},
    ) -> baml_py.baml_py.HTTPRequest:
        result = await self.__options.merge_options(baml_options).create_http_request_async(function_name="GCPVertexAIImplementationDiscovery", args={
            "analysis_query": analysis_query,"memory_context": memory_context,"system_info": system_info,
        }, mode="request")
        return result
    async def GCPVertexAIImportDiscovery(self, analysis_query: str,memory_context: str,system_info: types.SystemInfo_CrossIndexing,
        baml_options: BamlCallOptions = {},
    ) -> baml_py.baml_py.HTTPRequest:
        result = await self.__options.merge_options(baml_options).create_http_request_async(function_name="GCPVertexAIImportDiscovery", args={
            "analysis_query": analysis_query,"memory_context": memory_context,"system_info": system_info,
        }, mode="request")
        return result
    async def GCPVertexAIPackageDiscovery(self, analysis_query: str,memory_context: str,system_info: types.SystemInfo_CrossIndexing,
        baml_options: BamlCallOptions = {},
    ) -> baml_py.baml_py.HTTPRequest:
        result = await self.__options.merge_options(baml_options).create_http_request_async(function_name="GCPVertexAIPackageDiscovery", args={
            "analysis_query": analysis_query,"memory_context": memory_context,"system_info": system_info,
        }, mode="request")
        return result
    async def GCPVertexAIRoadmapAgent(self, params: types.RoadmapAgentParams,
        baml_options: BamlCallOptions = {},
    ) -> baml_py.baml_py.HTTPRequest:
        result = await self.__options.merge_options(baml_options).create_http_request_async(function_name="GCPVertexAIRoadmapAgent", args={
            "params": params,
        }, mode="request")
        return result
    async def GCPVertexAITaskFilter(self, task_list: str,
        baml_options: BamlCallOptions = {},
    ) -> baml_py.baml_py.HTTPRequest:
        result = await self.__options.merge_options(baml_options).create_http_request_async(function_name="GCPVertexAITaskFilter", args={
            "task_list": task_list,
        }, mode="request")
        return result
    async def GCPVertexAITechnologyCorrection(self, unmatched_names: str,acceptable_enums: str,
        baml_options: BamlCallOptions = {},
    ) -> baml_py.baml_py.HTTPRequest:
        result = await self.__options.merge_options(baml_options).create_http_request_async(function_name="GCPVertexAITechnologyCorrection", args={
            "unmatched_names": unmatched_names,"acceptable_enums": acceptable_enums,
        }, mode="request")
        return result
    async def GoogleGeminiCodeManager(self, tool_results: str,system_info: types.SystemInfo_CrossIndexing,
        baml_options: BamlCallOptions = {},
    ) -> baml_py.baml_py.HTTPRequest:
        result = await self.__options.merge_options(baml_options).create_http_request_async(function_name="GoogleGeminiCodeManager", args={
            "tool_results": tool_results,"system_info": system_info,
        }, mode="request")
        return result
    async def GoogleGeminiConnectionMatching(self, incoming_connections: str,outgoing_connections: str,
        baml_options: BamlCallOptions = {},
    ) -> baml_py.baml_py.HTTPRequest:
        result = await self.__options.merge_options(baml_options).create_http_request_async(function_name="GoogleGeminiConnectionMatching", args={
            "incoming_connections": incoming_connections,"outgoing_connections": outgoing_connections,
        }, mode="request")
        return result
    async def GoogleGeminiConnectionSplitting(self, memory_context: str,
        baml_options: BamlCallOptions = {},
    ) -> baml_py.baml_py.HTTPRequest:
        result = await self.__options.merge_options(baml_options).create_http_request_async(function_name="GoogleGeminiConnectionSplitting", args={
            "memory_context": memory_context,
        }, mode="request")
        return result
    async def GoogleGeminiImplementationDiscovery(self, analysis_query: str,memory_context: str,system_info: types.SystemInfo_CrossIndexing,
        baml_options: BamlCallOptions = {},
    ) -> baml_py.baml_py.HTTPRequest:
        result = await self.__options.merge_options(baml_options).create_http_request_async(function_name="GoogleGeminiImplementationDiscovery", args={
            "analysis_query": analysis_query,"memory_context": memory_context,"system_info": system_info,
        }, mode="request")
        return result
    async def GoogleGeminiImportDiscovery(self, analysis_query: str,memory_context: str,system_info: types.SystemInfo_CrossIndexing,
        baml_options: BamlCallOptions = {},
    ) -> baml_py.baml_py.HTTPRequest:
        result = await self.__options.merge_options(baml_options).create_http_request_async(function_name="GoogleGeminiImportDiscovery", args={
            "analysis_query": analysis_query,"memory_context": memory_context,"system_info": system_info,
        }, mode="request")
        return result
    async def GoogleGeminiPackageDiscovery(self, analysis_query: str,memory_context: str,system_info: types.SystemInfo_CrossIndexing,
        baml_options: BamlCallOptions = {},
    ) -> baml_py.baml_py.HTTPRequest:
        result = await self.__options.merge_options(baml_options).create_http_request_async(function_name="GoogleGeminiPackageDiscovery", args={
            "analysis_query": analysis_query,"memory_context": memory_context,"system_info": system_info,
        }, mode="request")
        return result
    async def GoogleGeminiRoadmapAgent(self, params: types.RoadmapAgentParams,
        baml_options: BamlCallOptions = {},
    ) -> baml_py.baml_py.HTTPRequest:
        result = await self.__options.merge_options(baml_options).create_http_request_async(function_name="GoogleGeminiRoadmapAgent", args={
            "params": params,
        }, mode="request")
        return result
    async def GoogleGeminiTaskFilter(self, task_list: str,
        baml_options: BamlCallOptions = {},
    ) -> baml_py.baml_py.HTTPRequest:
        result = await self.__options.merge_options(baml_options).create_http_request_async(function_name="GoogleGeminiTaskFilter", args={
            "task_list": task_list,
        }, mode="request")
        return result
    async def GoogleGeminiTechnologyCorrection(self, unmatched_names: str,acceptable_enums: str,
        baml_options: BamlCallOptions = {},
    ) -> baml_py.baml_py.HTTPRequest:
        result = await self.__options.merge_options(baml_options).create_http_request_async(function_name="GoogleGeminiTechnologyCorrection", args={
            "unmatched_names": unmatched_names,"acceptable_enums": acceptable_enums,
        }, mode="request")
        return result
    async def OpenAIChatGPTCodeManager(self, tool_results: str,system_info: types.SystemInfo_CrossIndexing,
        baml_options: BamlCallOptions = {},
    ) -> baml_py.baml_py.HTTPRequest:
        result = await self.__options.merge_options(baml_options).create_http_request_async(function_name="OpenAIChatGPTCodeManager", args={
            "tool_results": tool_results,"system_info": system_info,
        }, mode="request")
        return result
    async def OpenAIChatGPTConnectionMatching(self, incoming_connections: str,outgoing_connections: str,
        baml_options: BamlCallOptions = {},
    ) -> baml_py.baml_py.HTTPRequest:
        result = await self.__options.merge_options(baml_options).create_http_request_async(function_name="OpenAIChatGPTConnectionMatching", args={
            "incoming_connections": incoming_connections,"outgoing_connections": outgoing_connections,
        }, mode="request")
        return result
    async def OpenAIChatGPTConnectionSplitting(self, memory_context: str,
        baml_options: BamlCallOptions = {},
    ) -> baml_py.baml_py.HTTPRequest:
        result = await self.__options.merge_options(baml_options).create_http_request_async(function_name="OpenAIChatGPTConnectionSplitting", args={
            "memory_context": memory_context,
        }, mode="request")
        return result
    async def OpenAIChatGPTImplementationDiscovery(self, analysis_query: str,memory_context: str,system_info: types.SystemInfo_CrossIndexing,
        baml_options: BamlCallOptions = {},
    ) -> baml_py.baml_py.HTTPRequest:
        result = await self.__options.merge_options(baml_options).create_http_request_async(function_name="OpenAIChatGPTImplementationDiscovery", args={
            "analysis_query": analysis_query,"memory_context": memory_context,"system_info": system_info,
        }, mode="request")
        return result
    async def OpenAIChatGPTImportDiscovery(self, analysis_query: str,memory_context: str,system_info: types.SystemInfo_CrossIndexing,
        baml_options: BamlCallOptions = {},
    ) -> baml_py.baml_py.HTTPRequest:
        result = await self.__options.merge_options(baml_options).create_http_request_async(function_name="OpenAIChatGPTImportDiscovery", args={
            "analysis_query": analysis_query,"memory_context": memory_context,"system_info": system_info,
        }, mode="request")
        return result
    async def OpenAIChatGPTPackageDiscovery(self, analysis_query: str,memory_context: str,system_info: types.SystemInfo_CrossIndexing,
        baml_options: BamlCallOptions = {},
    ) -> baml_py.baml_py.HTTPRequest:
        result = await self.__options.merge_options(baml_options).create_http_request_async(function_name="OpenAIChatGPTPackageDiscovery", args={
            "analysis_query": analysis_query,"memory_context": memory_context,"system_info": system_info,
        }, mode="request")
        return result
    async def OpenAIChatGPTRoadmapAgent(self, params: types.RoadmapAgentParams,
        baml_options: BamlCallOptions = {},
    ) -> baml_py.baml_py.HTTPRequest:
        result = await self.__options.merge_options(baml_options).create_http_request_async(function_name="OpenAIChatGPTRoadmapAgent", args={
            "params": params,
        }, mode="request")
        return result
    async def OpenAIChatGPTTaskFilter(self, task_list: str,
        baml_options: BamlCallOptions = {},
    ) -> baml_py.baml_py.HTTPRequest:
        result = await self.__options.merge_options(baml_options).create_http_request_async(function_name="OpenAIChatGPTTaskFilter", args={
            "task_list": task_list,
        }, mode="request")
        return result
    async def OpenAIChatGPTTechnologyCorrection(self, unmatched_names: str,acceptable_enums: str,
        baml_options: BamlCallOptions = {},
    ) -> baml_py.baml_py.HTTPRequest:
        result = await self.__options.merge_options(baml_options).create_http_request_async(function_name="OpenAIChatGPTTechnologyCorrection", args={
            "unmatched_names": unmatched_names,"acceptable_enums": acceptable_enums,
        }, mode="request")
        return result
    async def OpenRouterCodeManager(self, tool_results: str,system_info: types.SystemInfo_CrossIndexing,
        baml_options: BamlCallOptions = {},
    ) -> baml_py.baml_py.HTTPRequest:
        result = await self.__options.merge_options(baml_options).create_http_request_async(function_name="OpenRouterCodeManager", args={
            "tool_results": tool_results,"system_info": system_info,
        }, mode="request")
        return result
    async def OpenRouterConnectionMatching(self, incoming_connections: str,outgoing_connections: str,
        baml_options: BamlCallOptions = {},
    ) -> baml_py.baml_py.HTTPRequest:
        result = await self.__options.merge_options(baml_options).create_http_request_async(function_name="OpenRouterConnectionMatching", args={
            "incoming_connections": incoming_connections,"outgoing_connections": outgoing_connections,
        }, mode="request")
        return result
    async def OpenRouterConnectionSplitting(self, memory_context: str,
        baml_options: BamlCallOptions = {},
    ) -> baml_py.baml_py.HTTPRequest:
        result = await self.__options.merge_options(baml_options).create_http_request_async(function_name="OpenRouterConnectionSplitting", args={
            "memory_context": memory_context,
        }, mode="request")
        return result
    async def OpenRouterImplementationDiscovery(self, analysis_query: str,memory_context: str,system_info: types.SystemInfo_CrossIndexing,
        baml_options: BamlCallOptions = {},
    ) -> baml_py.baml_py.HTTPRequest:
        result = await self.__options.merge_options(baml_options).create_http_request_async(function_name="OpenRouterImplementationDiscovery", args={
            "analysis_query": analysis_query,"memory_context": memory_context,"system_info": system_info,
        }, mode="request")
        return result
    async def OpenRouterImportDiscovery(self, analysis_query: str,memory_context: str,system_info: types.SystemInfo_CrossIndexing,
        baml_options: BamlCallOptions = {},
    ) -> baml_py.baml_py.HTTPRequest:
        result = await self.__options.merge_options(baml_options).create_http_request_async(function_name="OpenRouterImportDiscovery", args={
            "analysis_query": analysis_query,"memory_context": memory_context,"system_info": system_info,
        }, mode="request")
        return result
    async def OpenRouterPackageDiscovery(self, analysis_query: str,memory_context: str,system_info: types.SystemInfo_CrossIndexing,
        baml_options: BamlCallOptions = {},
    ) -> baml_py.baml_py.HTTPRequest:
        result = await self.__options.merge_options(baml_options).create_http_request_async(function_name="OpenRouterPackageDiscovery", args={
            "analysis_query": analysis_query,"memory_context": memory_context,"system_info": system_info,
        }, mode="request")
        return result
    async def OpenRouterRoadmapAgent(self, params: types.RoadmapAgentParams,
        baml_options: BamlCallOptions = {},
    ) -> baml_py.baml_py.HTTPRequest:
        result = await self.__options.merge_options(baml_options).create_http_request_async(function_name="OpenRouterRoadmapAgent", args={
            "params": params,
        }, mode="request")
        return result
    async def OpenRouterTaskFilter(self, task_list: str,
        baml_options: BamlCallOptions = {},
    ) -> baml_py.baml_py.HTTPRequest:
        result = await self.__options.merge_options(baml_options).create_http_request_async(function_name="OpenRouterTaskFilter", args={
            "task_list": task_list,
        }, mode="request")
        return result
    async def OpenRouterTechnologyCorrection(self, unmatched_names: str,acceptable_enums: str,
        baml_options: BamlCallOptions = {},
    ) -> baml_py.baml_py.HTTPRequest:
        result = await self.__options.merge_options(baml_options).create_http_request_async(function_name="OpenRouterTechnologyCorrection", args={
            "unmatched_names": unmatched_names,"acceptable_enums": acceptable_enums,
        }, mode="request")
        return result
    

class BamlHttpStreamRequestClient:
    __options: DoNotUseDirectlyCallManager

    def __init__(self, options: DoNotUseDirectlyCallManager):
        self.__options = options

    async def AnthropicClaudeCodeManager(self, tool_results: str,system_info: types.SystemInfo_CrossIndexing,
        baml_options: BamlCallOptions = {},
    ) -> baml_py.baml_py.HTTPRequest:
        result = await self.__options.merge_options(baml_options).create_http_request_async(function_name="AnthropicClaudeCodeManager", args={
            "tool_results": tool_results,"system_info": system_info,
        }, mode="stream")
        return result
    async def AnthropicClaudeConnectionMatching(self, incoming_connections: str,outgoing_connections: str,
        baml_options: BamlCallOptions = {},
    ) -> baml_py.baml_py.HTTPRequest:
        result = await self.__options.merge_options(baml_options).create_http_request_async(function_name="AnthropicClaudeConnectionMatching", args={
            "incoming_connections": incoming_connections,"outgoing_connections": outgoing_connections,
        }, mode="stream")
        return result
    async def AnthropicClaudeConnectionSplitting(self, memory_context: str,
        baml_options: BamlCallOptions = {},
    ) -> baml_py.baml_py.HTTPRequest:
        result = await self.__options.merge_options(baml_options).create_http_request_async(function_name="AnthropicClaudeConnectionSplitting", args={
            "memory_context": memory_context,
        }, mode="stream")
        return result
    async def AnthropicClaudeImplementationDiscovery(self, analysis_query: str,memory_context: str,system_info: types.SystemInfo_CrossIndexing,
        baml_options: BamlCallOptions = {},
    ) -> baml_py.baml_py.HTTPRequest:
        result = await self.__options.merge_options(baml_options).create_http_request_async(function_name="AnthropicClaudeImplementationDiscovery", args={
            "analysis_query": analysis_query,"memory_context": memory_context,"system_info": system_info,
        }, mode="stream")
        return result
    async def AnthropicClaudeImportDiscovery(self, analysis_query: str,memory_context: str,system_info: types.SystemInfo_CrossIndexing,
        baml_options: BamlCallOptions = {},
    ) -> baml_py.baml_py.HTTPRequest:
        result = await self.__options.merge_options(baml_options).create_http_request_async(function_name="AnthropicClaudeImportDiscovery", args={
            "analysis_query": analysis_query,"memory_context": memory_context,"system_info": system_info,
        }, mode="stream")
        return result
    async def AnthropicClaudePackageDiscovery(self, analysis_query: str,memory_context: str,system_info: types.SystemInfo_CrossIndexing,
        baml_options: BamlCallOptions = {},
    ) -> baml_py.baml_py.HTTPRequest:
        result = await self.__options.merge_options(baml_options).create_http_request_async(function_name="AnthropicClaudePackageDiscovery", args={
            "analysis_query": analysis_query,"memory_context": memory_context,"system_info": system_info,
        }, mode="stream")
        return result
    async def AnthropicClaudeRoadmapAgent(self, params: types.RoadmapAgentParams,
        baml_options: BamlCallOptions = {},
    ) -> baml_py.baml_py.HTTPRequest:
        result = await self.__options.merge_options(baml_options).create_http_request_async(function_name="AnthropicClaudeRoadmapAgent", args={
            "params": params,
        }, mode="stream")
        return result
    async def AnthropicClaudeTaskFilter(self, task_list: str,
        baml_options: BamlCallOptions = {},
    ) -> baml_py.baml_py.HTTPRequest:
        result = await self.__options.merge_options(baml_options).create_http_request_async(function_name="AnthropicClaudeTaskFilter", args={
            "task_list": task_list,
        }, mode="stream")
        return result
    async def AnthropicClaudeTechnologyCorrection(self, unmatched_names: str,acceptable_enums: str,
        baml_options: BamlCallOptions = {},
    ) -> baml_py.baml_py.HTTPRequest:
        result = await self.__options.merge_options(baml_options).create_http_request_async(function_name="AnthropicClaudeTechnologyCorrection", args={
            "unmatched_names": unmatched_names,"acceptable_enums": acceptable_enums,
        }, mode="stream")
        return result
    async def AwsBedrockCodeManager(self, tool_results: str,system_info: types.SystemInfo_CrossIndexing,
        baml_options: BamlCallOptions = {},
    ) -> baml_py.baml_py.HTTPRequest:
        result = await self.__options.merge_options(baml_options).create_http_request_async(function_name="AwsBedrockCodeManager", args={
            "tool_results": tool_results,"system_info": system_info,
        }, mode="stream")
        return result
    async def AwsBedrockConnectionMatching(self, incoming_connections: str,outgoing_connections: str,
        baml_options: BamlCallOptions = {},
    ) -> baml_py.baml_py.HTTPRequest:
        result = await self.__options.merge_options(baml_options).create_http_request_async(function_name="AwsBedrockConnectionMatching", args={
            "incoming_connections": incoming_connections,"outgoing_connections": outgoing_connections,
        }, mode="stream")
        return result
    async def AwsBedrockConnectionSplitting(self, memory_context: str,
        baml_options: BamlCallOptions = {},
    ) -> baml_py.baml_py.HTTPRequest:
        result = await self.__options.merge_options(baml_options).create_http_request_async(function_name="AwsBedrockConnectionSplitting", args={
            "memory_context": memory_context,
        }, mode="stream")
        return result
    async def AwsBedrockImplementationDiscovery(self, analysis_query: str,memory_context: str,system_info: types.SystemInfo_CrossIndexing,
        baml_options: BamlCallOptions = {},
    ) -> baml_py.baml_py.HTTPRequest:
        result = await self.__options.merge_options(baml_options).create_http_request_async(function_name="AwsBedrockImplementationDiscovery", args={
            "analysis_query": analysis_query,"memory_context": memory_context,"system_info": system_info,
        }, mode="stream")
        return result
    async def AwsBedrockImportDiscovery(self, analysis_query: str,memory_context: str,system_info: types.SystemInfo_CrossIndexing,
        baml_options: BamlCallOptions = {},
    ) -> baml_py.baml_py.HTTPRequest:
        result = await self.__options.merge_options(baml_options).create_http_request_async(function_name="AwsBedrockImportDiscovery", args={
            "analysis_query": analysis_query,"memory_context": memory_context,"system_info": system_info,
        }, mode="stream")
        return result
    async def AwsBedrockPackageDiscovery(self, analysis_query: str,memory_context: str,system_info: types.SystemInfo_CrossIndexing,
        baml_options: BamlCallOptions = {},
    ) -> baml_py.baml_py.HTTPRequest:
        result = await self.__options.merge_options(baml_options).create_http_request_async(function_name="AwsBedrockPackageDiscovery", args={
            "analysis_query": analysis_query,"memory_context": memory_context,"system_info": system_info,
        }, mode="stream")
        return result
    async def AwsBedrockRoadmapAgent(self, params: types.RoadmapAgentParams,
        baml_options: BamlCallOptions = {},
    ) -> baml_py.baml_py.HTTPRequest:
        result = await self.__options.merge_options(baml_options).create_http_request_async(function_name="AwsBedrockRoadmapAgent", args={
            "params": params,
        }, mode="stream")
        return result
    async def AwsBedrockTaskFilter(self, task_list: str,
        baml_options: BamlCallOptions = {},
    ) -> baml_py.baml_py.HTTPRequest:
        result = await self.__options.merge_options(baml_options).create_http_request_async(function_name="AwsBedrockTaskFilter", args={
            "task_list": task_list,
        }, mode="stream")
        return result
    async def AwsBedrockTechnologyCorrection(self, unmatched_names: str,acceptable_enums: str,
        baml_options: BamlCallOptions = {},
    ) -> baml_py.baml_py.HTTPRequest:
        result = await self.__options.merge_options(baml_options).create_http_request_async(function_name="AwsBedrockTechnologyCorrection", args={
            "unmatched_names": unmatched_names,"acceptable_enums": acceptable_enums,
        }, mode="stream")
        return result
    async def AzureAIFoundryCodeManager(self, tool_results: str,system_info: types.SystemInfo_CrossIndexing,
        baml_options: BamlCallOptions = {},
    ) -> baml_py.baml_py.HTTPRequest:
        result = await self.__options.merge_options(baml_options).create_http_request_async(function_name="AzureAIFoundryCodeManager", args={
            "tool_results": tool_results,"system_info": system_info,
        }, mode="stream")
        return result
    async def AzureAIFoundryConnectionMatching(self, incoming_connections: str,outgoing_connections: str,
        baml_options: BamlCallOptions = {},
    ) -> baml_py.baml_py.HTTPRequest:
        result = await self.__options.merge_options(baml_options).create_http_request_async(function_name="AzureAIFoundryConnectionMatching", args={
            "incoming_connections": incoming_connections,"outgoing_connections": outgoing_connections,
        }, mode="stream")
        return result
    async def AzureAIFoundryConnectionSplitting(self, memory_context: str,
        baml_options: BamlCallOptions = {},
    ) -> baml_py.baml_py.HTTPRequest:
        result = await self.__options.merge_options(baml_options).create_http_request_async(function_name="AzureAIFoundryConnectionSplitting", args={
            "memory_context": memory_context,
        }, mode="stream")
        return result
    async def AzureAIFoundryImplementationDiscovery(self, analysis_query: str,memory_context: str,system_info: types.SystemInfo_CrossIndexing,
        baml_options: BamlCallOptions = {},
    ) -> baml_py.baml_py.HTTPRequest:
        result = await self.__options.merge_options(baml_options).create_http_request_async(function_name="AzureAIFoundryImplementationDiscovery", args={
            "analysis_query": analysis_query,"memory_context": memory_context,"system_info": system_info,
        }, mode="stream")
        return result
    async def AzureAIFoundryImportDiscovery(self, analysis_query: str,memory_context: str,system_info: types.SystemInfo_CrossIndexing,
        baml_options: BamlCallOptions = {},
    ) -> baml_py.baml_py.HTTPRequest:
        result = await self.__options.merge_options(baml_options).create_http_request_async(function_name="AzureAIFoundryImportDiscovery", args={
            "analysis_query": analysis_query,"memory_context": memory_context,"system_info": system_info,
        }, mode="stream")
        return result
    async def AzureAIFoundryPackageDiscovery(self, analysis_query: str,memory_context: str,system_info: types.SystemInfo_CrossIndexing,
        baml_options: BamlCallOptions = {},
    ) -> baml_py.baml_py.HTTPRequest:
        result = await self.__options.merge_options(baml_options).create_http_request_async(function_name="AzureAIFoundryPackageDiscovery", args={
            "analysis_query": analysis_query,"memory_context": memory_context,"system_info": system_info,
        }, mode="stream")
        return result
    async def AzureAIFoundryRoadmapAgent(self, params: types.RoadmapAgentParams,
        baml_options: BamlCallOptions = {},
    ) -> baml_py.baml_py.HTTPRequest:
        result = await self.__options.merge_options(baml_options).create_http_request_async(function_name="AzureAIFoundryRoadmapAgent", args={
            "params": params,
        }, mode="stream")
        return result
    async def AzureAIFoundryTaskFilter(self, task_list: str,
        baml_options: BamlCallOptions = {},
    ) -> baml_py.baml_py.HTTPRequest:
        result = await self.__options.merge_options(baml_options).create_http_request_async(function_name="AzureAIFoundryTaskFilter", args={
            "task_list": task_list,
        }, mode="stream")
        return result
    async def AzureAIFoundryTechnologyCorrection(self, unmatched_names: str,acceptable_enums: str,
        baml_options: BamlCallOptions = {},
    ) -> baml_py.baml_py.HTTPRequest:
        result = await self.__options.merge_options(baml_options).create_http_request_async(function_name="AzureAIFoundryTechnologyCorrection", args={
            "unmatched_names": unmatched_names,"acceptable_enums": acceptable_enums,
        }, mode="stream")
        return result
    async def AzureOpenAICodeManager(self, tool_results: str,system_info: types.SystemInfo_CrossIndexing,
        baml_options: BamlCallOptions = {},
    ) -> baml_py.baml_py.HTTPRequest:
        result = await self.__options.merge_options(baml_options).create_http_request_async(function_name="AzureOpenAICodeManager", args={
            "tool_results": tool_results,"system_info": system_info,
        }, mode="stream")
        return result
    async def AzureOpenAIConnectionMatching(self, incoming_connections: str,outgoing_connections: str,
        baml_options: BamlCallOptions = {},
    ) -> baml_py.baml_py.HTTPRequest:
        result = await self.__options.merge_options(baml_options).create_http_request_async(function_name="AzureOpenAIConnectionMatching", args={
            "incoming_connections": incoming_connections,"outgoing_connections": outgoing_connections,
        }, mode="stream")
        return result
    async def AzureOpenAIConnectionSplitting(self, memory_context: str,
        baml_options: BamlCallOptions = {},
    ) -> baml_py.baml_py.HTTPRequest:
        result = await self.__options.merge_options(baml_options).create_http_request_async(function_name="AzureOpenAIConnectionSplitting", args={
            "memory_context": memory_context,
        }, mode="stream")
        return result
    async def AzureOpenAIImplementationDiscovery(self, analysis_query: str,memory_context: str,system_info: types.SystemInfo_CrossIndexing,
        baml_options: BamlCallOptions = {},
    ) -> baml_py.baml_py.HTTPRequest:
        result = await self.__options.merge_options(baml_options).create_http_request_async(function_name="AzureOpenAIImplementationDiscovery", args={
            "analysis_query": analysis_query,"memory_context": memory_context,"system_info": system_info,
        }, mode="stream")
        return result
    async def AzureOpenAIImportDiscovery(self, analysis_query: str,memory_context: str,system_info: types.SystemInfo_CrossIndexing,
        baml_options: BamlCallOptions = {},
    ) -> baml_py.baml_py.HTTPRequest:
        result = await self.__options.merge_options(baml_options).create_http_request_async(function_name="AzureOpenAIImportDiscovery", args={
            "analysis_query": analysis_query,"memory_context": memory_context,"system_info": system_info,
        }, mode="stream")
        return result
    async def AzureOpenAIPackageDiscovery(self, analysis_query: str,memory_context: str,system_info: types.SystemInfo_CrossIndexing,
        baml_options: BamlCallOptions = {},
    ) -> baml_py.baml_py.HTTPRequest:
        result = await self.__options.merge_options(baml_options).create_http_request_async(function_name="AzureOpenAIPackageDiscovery", args={
            "analysis_query": analysis_query,"memory_context": memory_context,"system_info": system_info,
        }, mode="stream")
        return result
    async def AzureOpenAIRoadmapAgent(self, params: types.RoadmapAgentParams,
        baml_options: BamlCallOptions = {},
    ) -> baml_py.baml_py.HTTPRequest:
        result = await self.__options.merge_options(baml_options).create_http_request_async(function_name="AzureOpenAIRoadmapAgent", args={
            "params": params,
        }, mode="stream")
        return result
    async def AzureOpenAITaskFilter(self, task_list: str,
        baml_options: BamlCallOptions = {},
    ) -> baml_py.baml_py.HTTPRequest:
        result = await self.__options.merge_options(baml_options).create_http_request_async(function_name="AzureOpenAITaskFilter", args={
            "task_list": task_list,
        }, mode="stream")
        return result
    async def AzureOpenAITechnologyCorrection(self, unmatched_names: str,acceptable_enums: str,
        baml_options: BamlCallOptions = {},
    ) -> baml_py.baml_py.HTTPRequest:
        result = await self.__options.merge_options(baml_options).create_http_request_async(function_name="AzureOpenAITechnologyCorrection", args={
            "unmatched_names": unmatched_names,"acceptable_enums": acceptable_enums,
        }, mode="stream")
        return result
    async def GCPVertexAICodeManager(self, tool_results: str,system_info: types.SystemInfo_CrossIndexing,
        baml_options: BamlCallOptions = {},
    ) -> baml_py.baml_py.HTTPRequest:
        result = await self.__options.merge_options(baml_options).create_http_request_async(function_name="GCPVertexAICodeManager", args={
            "tool_results": tool_results,"system_info": system_info,
        }, mode="stream")
        return result
    async def GCPVertexAIConnectionMatching(self, incoming_connections: str,outgoing_connections: str,
        baml_options: BamlCallOptions = {},
    ) -> baml_py.baml_py.HTTPRequest:
        result = await self.__options.merge_options(baml_options).create_http_request_async(function_name="GCPVertexAIConnectionMatching", args={
            "incoming_connections": incoming_connections,"outgoing_connections": outgoing_connections,
        }, mode="stream")
        return result
    async def GCPVertexAIConnectionSplitting(self, memory_context: str,
        baml_options: BamlCallOptions = {},
    ) -> baml_py.baml_py.HTTPRequest:
        result = await self.__options.merge_options(baml_options).create_http_request_async(function_name="GCPVertexAIConnectionSplitting", args={
            "memory_context": memory_context,
        }, mode="stream")
        return result
    async def GCPVertexAIImplementationDiscovery(self, analysis_query: str,memory_context: str,system_info: types.SystemInfo_CrossIndexing,
        baml_options: BamlCallOptions = {},
    ) -> baml_py.baml_py.HTTPRequest:
        result = await self.__options.merge_options(baml_options).create_http_request_async(function_name="GCPVertexAIImplementationDiscovery", args={
            "analysis_query": analysis_query,"memory_context": memory_context,"system_info": system_info,
        }, mode="stream")
        return result
    async def GCPVertexAIImportDiscovery(self, analysis_query: str,memory_context: str,system_info: types.SystemInfo_CrossIndexing,
        baml_options: BamlCallOptions = {},
    ) -> baml_py.baml_py.HTTPRequest:
        result = await self.__options.merge_options(baml_options).create_http_request_async(function_name="GCPVertexAIImportDiscovery", args={
            "analysis_query": analysis_query,"memory_context": memory_context,"system_info": system_info,
        }, mode="stream")
        return result
    async def GCPVertexAIPackageDiscovery(self, analysis_query: str,memory_context: str,system_info: types.SystemInfo_CrossIndexing,
        baml_options: BamlCallOptions = {},
    ) -> baml_py.baml_py.HTTPRequest:
        result = await self.__options.merge_options(baml_options).create_http_request_async(function_name="GCPVertexAIPackageDiscovery", args={
            "analysis_query": analysis_query,"memory_context": memory_context,"system_info": system_info,
        }, mode="stream")
        return result
    async def GCPVertexAIRoadmapAgent(self, params: types.RoadmapAgentParams,
        baml_options: BamlCallOptions = {},
    ) -> baml_py.baml_py.HTTPRequest:
        result = await self.__options.merge_options(baml_options).create_http_request_async(function_name="GCPVertexAIRoadmapAgent", args={
            "params": params,
        }, mode="stream")
        return result
    async def GCPVertexAITaskFilter(self, task_list: str,
        baml_options: BamlCallOptions = {},
    ) -> baml_py.baml_py.HTTPRequest:
        result = await self.__options.merge_options(baml_options).create_http_request_async(function_name="GCPVertexAITaskFilter", args={
            "task_list": task_list,
        }, mode="stream")
        return result
    async def GCPVertexAITechnologyCorrection(self, unmatched_names: str,acceptable_enums: str,
        baml_options: BamlCallOptions = {},
    ) -> baml_py.baml_py.HTTPRequest:
        result = await self.__options.merge_options(baml_options).create_http_request_async(function_name="GCPVertexAITechnologyCorrection", args={
            "unmatched_names": unmatched_names,"acceptable_enums": acceptable_enums,
        }, mode="stream")
        return result
    async def GoogleGeminiCodeManager(self, tool_results: str,system_info: types.SystemInfo_CrossIndexing,
        baml_options: BamlCallOptions = {},
    ) -> baml_py.baml_py.HTTPRequest:
        result = await self.__options.merge_options(baml_options).create_http_request_async(function_name="GoogleGeminiCodeManager", args={
            "tool_results": tool_results,"system_info": system_info,
        }, mode="stream")
        return result
    async def GoogleGeminiConnectionMatching(self, incoming_connections: str,outgoing_connections: str,
        baml_options: BamlCallOptions = {},
    ) -> baml_py.baml_py.HTTPRequest:
        result = await self.__options.merge_options(baml_options).create_http_request_async(function_name="GoogleGeminiConnectionMatching", args={
            "incoming_connections": incoming_connections,"outgoing_connections": outgoing_connections,
        }, mode="stream")
        return result
    async def GoogleGeminiConnectionSplitting(self, memory_context: str,
        baml_options: BamlCallOptions = {},
    ) -> baml_py.baml_py.HTTPRequest:
        result = await self.__options.merge_options(baml_options).create_http_request_async(function_name="GoogleGeminiConnectionSplitting", args={
            "memory_context": memory_context,
        }, mode="stream")
        return result
    async def GoogleGeminiImplementationDiscovery(self, analysis_query: str,memory_context: str,system_info: types.SystemInfo_CrossIndexing,
        baml_options: BamlCallOptions = {},
    ) -> baml_py.baml_py.HTTPRequest:
        result = await self.__options.merge_options(baml_options).create_http_request_async(function_name="GoogleGeminiImplementationDiscovery", args={
            "analysis_query": analysis_query,"memory_context": memory_context,"system_info": system_info,
        }, mode="stream")
        return result
    async def GoogleGeminiImportDiscovery(self, analysis_query: str,memory_context: str,system_info: types.SystemInfo_CrossIndexing,
        baml_options: BamlCallOptions = {},
    ) -> baml_py.baml_py.HTTPRequest:
        result = await self.__options.merge_options(baml_options).create_http_request_async(function_name="GoogleGeminiImportDiscovery", args={
            "analysis_query": analysis_query,"memory_context": memory_context,"system_info": system_info,
        }, mode="stream")
        return result
    async def GoogleGeminiPackageDiscovery(self, analysis_query: str,memory_context: str,system_info: types.SystemInfo_CrossIndexing,
        baml_options: BamlCallOptions = {},
    ) -> baml_py.baml_py.HTTPRequest:
        result = await self.__options.merge_options(baml_options).create_http_request_async(function_name="GoogleGeminiPackageDiscovery", args={
            "analysis_query": analysis_query,"memory_context": memory_context,"system_info": system_info,
        }, mode="stream")
        return result
    async def GoogleGeminiRoadmapAgent(self, params: types.RoadmapAgentParams,
        baml_options: BamlCallOptions = {},
    ) -> baml_py.baml_py.HTTPRequest:
        result = await self.__options.merge_options(baml_options).create_http_request_async(function_name="GoogleGeminiRoadmapAgent", args={
            "params": params,
        }, mode="stream")
        return result
    async def GoogleGeminiTaskFilter(self, task_list: str,
        baml_options: BamlCallOptions = {},
    ) -> baml_py.baml_py.HTTPRequest:
        result = await self.__options.merge_options(baml_options).create_http_request_async(function_name="GoogleGeminiTaskFilter", args={
            "task_list": task_list,
        }, mode="stream")
        return result
    async def GoogleGeminiTechnologyCorrection(self, unmatched_names: str,acceptable_enums: str,
        baml_options: BamlCallOptions = {},
    ) -> baml_py.baml_py.HTTPRequest:
        result = await self.__options.merge_options(baml_options).create_http_request_async(function_name="GoogleGeminiTechnologyCorrection", args={
            "unmatched_names": unmatched_names,"acceptable_enums": acceptable_enums,
        }, mode="stream")
        return result
    async def OpenAIChatGPTCodeManager(self, tool_results: str,system_info: types.SystemInfo_CrossIndexing,
        baml_options: BamlCallOptions = {},
    ) -> baml_py.baml_py.HTTPRequest:
        result = await self.__options.merge_options(baml_options).create_http_request_async(function_name="OpenAIChatGPTCodeManager", args={
            "tool_results": tool_results,"system_info": system_info,
        }, mode="stream")
        return result
    async def OpenAIChatGPTConnectionMatching(self, incoming_connections: str,outgoing_connections: str,
        baml_options: BamlCallOptions = {},
    ) -> baml_py.baml_py.HTTPRequest:
        result = await self.__options.merge_options(baml_options).create_http_request_async(function_name="OpenAIChatGPTConnectionMatching", args={
            "incoming_connections": incoming_connections,"outgoing_connections": outgoing_connections,
        }, mode="stream")
        return result
    async def OpenAIChatGPTConnectionSplitting(self, memory_context: str,
        baml_options: BamlCallOptions = {},
    ) -> baml_py.baml_py.HTTPRequest:
        result = await self.__options.merge_options(baml_options).create_http_request_async(function_name="OpenAIChatGPTConnectionSplitting", args={
            "memory_context": memory_context,
        }, mode="stream")
        return result
    async def OpenAIChatGPTImplementationDiscovery(self, analysis_query: str,memory_context: str,system_info: types.SystemInfo_CrossIndexing,
        baml_options: BamlCallOptions = {},
    ) -> baml_py.baml_py.HTTPRequest:
        result = await self.__options.merge_options(baml_options).create_http_request_async(function_name="OpenAIChatGPTImplementationDiscovery", args={
            "analysis_query": analysis_query,"memory_context": memory_context,"system_info": system_info,
        }, mode="stream")
        return result
    async def OpenAIChatGPTImportDiscovery(self, analysis_query: str,memory_context: str,system_info: types.SystemInfo_CrossIndexing,
        baml_options: BamlCallOptions = {},
    ) -> baml_py.baml_py.HTTPRequest:
        result = await self.__options.merge_options(baml_options).create_http_request_async(function_name="OpenAIChatGPTImportDiscovery", args={
            "analysis_query": analysis_query,"memory_context": memory_context,"system_info": system_info,
        }, mode="stream")
        return result
    async def OpenAIChatGPTPackageDiscovery(self, analysis_query: str,memory_context: str,system_info: types.SystemInfo_CrossIndexing,
        baml_options: BamlCallOptions = {},
    ) -> baml_py.baml_py.HTTPRequest:
        result = await self.__options.merge_options(baml_options).create_http_request_async(function_name="OpenAIChatGPTPackageDiscovery", args={
            "analysis_query": analysis_query,"memory_context": memory_context,"system_info": system_info,
        }, mode="stream")
        return result
    async def OpenAIChatGPTRoadmapAgent(self, params: types.RoadmapAgentParams,
        baml_options: BamlCallOptions = {},
    ) -> baml_py.baml_py.HTTPRequest:
        result = await self.__options.merge_options(baml_options).create_http_request_async(function_name="OpenAIChatGPTRoadmapAgent", args={
            "params": params,
        }, mode="stream")
        return result
    async def OpenAIChatGPTTaskFilter(self, task_list: str,
        baml_options: BamlCallOptions = {},
    ) -> baml_py.baml_py.HTTPRequest:
        result = await self.__options.merge_options(baml_options).create_http_request_async(function_name="OpenAIChatGPTTaskFilter", args={
            "task_list": task_list,
        }, mode="stream")
        return result
    async def OpenAIChatGPTTechnologyCorrection(self, unmatched_names: str,acceptable_enums: str,
        baml_options: BamlCallOptions = {},
    ) -> baml_py.baml_py.HTTPRequest:
        result = await self.__options.merge_options(baml_options).create_http_request_async(function_name="OpenAIChatGPTTechnologyCorrection", args={
            "unmatched_names": unmatched_names,"acceptable_enums": acceptable_enums,
        }, mode="stream")
        return result
    async def OpenRouterCodeManager(self, tool_results: str,system_info: types.SystemInfo_CrossIndexing,
        baml_options: BamlCallOptions = {},
    ) -> baml_py.baml_py.HTTPRequest:
        result = await self.__options.merge_options(baml_options).create_http_request_async(function_name="OpenRouterCodeManager", args={
            "tool_results": tool_results,"system_info": system_info,
        }, mode="stream")
        return result
    async def OpenRouterConnectionMatching(self, incoming_connections: str,outgoing_connections: str,
        baml_options: BamlCallOptions = {},
    ) -> baml_py.baml_py.HTTPRequest:
        result = await self.__options.merge_options(baml_options).create_http_request_async(function_name="OpenRouterConnectionMatching", args={
            "incoming_connections": incoming_connections,"outgoing_connections": outgoing_connections,
        }, mode="stream")
        return result
    async def OpenRouterConnectionSplitting(self, memory_context: str,
        baml_options: BamlCallOptions = {},
    ) -> baml_py.baml_py.HTTPRequest:
        result = await self.__options.merge_options(baml_options).create_http_request_async(function_name="OpenRouterConnectionSplitting", args={
            "memory_context": memory_context,
        }, mode="stream")
        return result
    async def OpenRouterImplementationDiscovery(self, analysis_query: str,memory_context: str,system_info: types.SystemInfo_CrossIndexing,
        baml_options: BamlCallOptions = {},
    ) -> baml_py.baml_py.HTTPRequest:
        result = await self.__options.merge_options(baml_options).create_http_request_async(function_name="OpenRouterImplementationDiscovery", args={
            "analysis_query": analysis_query,"memory_context": memory_context,"system_info": system_info,
        }, mode="stream")
        return result
    async def OpenRouterImportDiscovery(self, analysis_query: str,memory_context: str,system_info: types.SystemInfo_CrossIndexing,
        baml_options: BamlCallOptions = {},
    ) -> baml_py.baml_py.HTTPRequest:
        result = await self.__options.merge_options(baml_options).create_http_request_async(function_name="OpenRouterImportDiscovery", args={
            "analysis_query": analysis_query,"memory_context": memory_context,"system_info": system_info,
        }, mode="stream")
        return result
    async def OpenRouterPackageDiscovery(self, analysis_query: str,memory_context: str,system_info: types.SystemInfo_CrossIndexing,
        baml_options: BamlCallOptions = {},
    ) -> baml_py.baml_py.HTTPRequest:
        result = await self.__options.merge_options(baml_options).create_http_request_async(function_name="OpenRouterPackageDiscovery", args={
            "analysis_query": analysis_query,"memory_context": memory_context,"system_info": system_info,
        }, mode="stream")
        return result
    async def OpenRouterRoadmapAgent(self, params: types.RoadmapAgentParams,
        baml_options: BamlCallOptions = {},
    ) -> baml_py.baml_py.HTTPRequest:
        result = await self.__options.merge_options(baml_options).create_http_request_async(function_name="OpenRouterRoadmapAgent", args={
            "params": params,
        }, mode="stream")
        return result
    async def OpenRouterTaskFilter(self, task_list: str,
        baml_options: BamlCallOptions = {},
    ) -> baml_py.baml_py.HTTPRequest:
        result = await self.__options.merge_options(baml_options).create_http_request_async(function_name="OpenRouterTaskFilter", args={
            "task_list": task_list,
        }, mode="stream")
        return result
    async def OpenRouterTechnologyCorrection(self, unmatched_names: str,acceptable_enums: str,
        baml_options: BamlCallOptions = {},
    ) -> baml_py.baml_py.HTTPRequest:
        result = await self.__options.merge_options(baml_options).create_http_request_async(function_name="OpenRouterTechnologyCorrection", args={
            "unmatched_names": unmatched_names,"acceptable_enums": acceptable_enums,
        }, mode="stream")
        return result
    

b = BamlAsyncClient(DoNotUseDirectlyCallManager({}))