# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from . import _utilities

__all__ = [
    'GetServerResult',
    'AwaitableGetServerResult',
    'get_server',
    'get_server_output',
]

@pulumi.output_type
class GetServerResult:
    """
    A collection of values returned by getServer.
    """
    def __init__(__self__, backup_window=None, backups=None, datacenter=None, delete_protection=None, firewall_ids=None, id=None, image=None, ipv4_address=None, ipv6_address=None, ipv6_network=None, iso=None, labels=None, location=None, name=None, placement_group_id=None, primary_disk_size=None, rebuild_protection=None, rescue=None, selector=None, server_type=None, status=None, with_selector=None, with_statuses=None):
        if backup_window and not isinstance(backup_window, str):
            raise TypeError("Expected argument 'backup_window' to be a str")
        pulumi.set(__self__, "backup_window", backup_window)
        if backups and not isinstance(backups, bool):
            raise TypeError("Expected argument 'backups' to be a bool")
        pulumi.set(__self__, "backups", backups)
        if datacenter and not isinstance(datacenter, str):
            raise TypeError("Expected argument 'datacenter' to be a str")
        pulumi.set(__self__, "datacenter", datacenter)
        if delete_protection and not isinstance(delete_protection, bool):
            raise TypeError("Expected argument 'delete_protection' to be a bool")
        pulumi.set(__self__, "delete_protection", delete_protection)
        if firewall_ids and not isinstance(firewall_ids, list):
            raise TypeError("Expected argument 'firewall_ids' to be a list")
        pulumi.set(__self__, "firewall_ids", firewall_ids)
        if id and not isinstance(id, int):
            raise TypeError("Expected argument 'id' to be a int")
        pulumi.set(__self__, "id", id)
        if image and not isinstance(image, str):
            raise TypeError("Expected argument 'image' to be a str")
        pulumi.set(__self__, "image", image)
        if ipv4_address and not isinstance(ipv4_address, str):
            raise TypeError("Expected argument 'ipv4_address' to be a str")
        pulumi.set(__self__, "ipv4_address", ipv4_address)
        if ipv6_address and not isinstance(ipv6_address, str):
            raise TypeError("Expected argument 'ipv6_address' to be a str")
        pulumi.set(__self__, "ipv6_address", ipv6_address)
        if ipv6_network and not isinstance(ipv6_network, str):
            raise TypeError("Expected argument 'ipv6_network' to be a str")
        pulumi.set(__self__, "ipv6_network", ipv6_network)
        if iso and not isinstance(iso, str):
            raise TypeError("Expected argument 'iso' to be a str")
        pulumi.set(__self__, "iso", iso)
        if labels and not isinstance(labels, dict):
            raise TypeError("Expected argument 'labels' to be a dict")
        pulumi.set(__self__, "labels", labels)
        if location and not isinstance(location, str):
            raise TypeError("Expected argument 'location' to be a str")
        pulumi.set(__self__, "location", location)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if placement_group_id and not isinstance(placement_group_id, int):
            raise TypeError("Expected argument 'placement_group_id' to be a int")
        pulumi.set(__self__, "placement_group_id", placement_group_id)
        if primary_disk_size and not isinstance(primary_disk_size, int):
            raise TypeError("Expected argument 'primary_disk_size' to be a int")
        pulumi.set(__self__, "primary_disk_size", primary_disk_size)
        if rebuild_protection and not isinstance(rebuild_protection, bool):
            raise TypeError("Expected argument 'rebuild_protection' to be a bool")
        pulumi.set(__self__, "rebuild_protection", rebuild_protection)
        if rescue and not isinstance(rescue, str):
            raise TypeError("Expected argument 'rescue' to be a str")
        pulumi.set(__self__, "rescue", rescue)
        if selector and not isinstance(selector, str):
            raise TypeError("Expected argument 'selector' to be a str")
        pulumi.set(__self__, "selector", selector)
        if server_type and not isinstance(server_type, str):
            raise TypeError("Expected argument 'server_type' to be a str")
        pulumi.set(__self__, "server_type", server_type)
        if status and not isinstance(status, str):
            raise TypeError("Expected argument 'status' to be a str")
        pulumi.set(__self__, "status", status)
        if with_selector and not isinstance(with_selector, str):
            raise TypeError("Expected argument 'with_selector' to be a str")
        pulumi.set(__self__, "with_selector", with_selector)
        if with_statuses and not isinstance(with_statuses, list):
            raise TypeError("Expected argument 'with_statuses' to be a list")
        pulumi.set(__self__, "with_statuses", with_statuses)

    @property
    @pulumi.getter(name="backupWindow")
    def backup_window(self) -> str:
        """
        (string) The backup window of the server, if enabled.
        """
        return pulumi.get(self, "backup_window")

    @property
    @pulumi.getter
    def backups(self) -> bool:
        """
        (bool) Whether backups are enabled.
        """
        return pulumi.get(self, "backups")

    @property
    @pulumi.getter
    def datacenter(self) -> str:
        """
        (string) The datacenter name.
        """
        return pulumi.get(self, "datacenter")

    @property
    @pulumi.getter(name="deleteProtection")
    def delete_protection(self) -> bool:
        """
        (bool) Whether delete protection is enabled.
        """
        return pulumi.get(self, "delete_protection")

    @property
    @pulumi.getter(name="firewallIds")
    def firewall_ids(self) -> Sequence[int]:
        """
        (Optional, list) Firewall IDs the server is attached to.
        """
        return pulumi.get(self, "firewall_ids")

    @property
    @pulumi.getter
    def id(self) -> int:
        """
        (int) Unique ID of the server.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def image(self) -> str:
        """
        (string) Name or ID of the image the server was created from.
        """
        return pulumi.get(self, "image")

    @property
    @pulumi.getter(name="ipv4Address")
    def ipv4_address(self) -> str:
        """
        (string) The IPv4 address.
        """
        return pulumi.get(self, "ipv4_address")

    @property
    @pulumi.getter(name="ipv6Address")
    def ipv6_address(self) -> str:
        """
        (string) The first IPv6 address of the assigned network.
        """
        return pulumi.get(self, "ipv6_address")

    @property
    @pulumi.getter(name="ipv6Network")
    def ipv6_network(self) -> str:
        """
        (string) The IPv6 network.
        """
        return pulumi.get(self, "ipv6_network")

    @property
    @pulumi.getter
    def iso(self) -> str:
        """
        (string) ID or Name of the mounted ISO image. Architecture of ISO must equal the server (type) architecture.
        """
        return pulumi.get(self, "iso")

    @property
    @pulumi.getter
    def labels(self) -> Mapping[str, Any]:
        """
        (map) User-defined labels (key-value pairs)
        """
        return pulumi.get(self, "labels")

    @property
    @pulumi.getter
    def location(self) -> str:
        """
        (string) The location name.
        """
        return pulumi.get(self, "location")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        (string) Name of the server.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="placementGroupId")
    def placement_group_id(self) -> Optional[int]:
        """
        (Optional, string) Placement Group ID the server is assigned to.
        """
        return pulumi.get(self, "placement_group_id")

    @property
    @pulumi.getter(name="primaryDiskSize")
    def primary_disk_size(self) -> int:
        """
        (int) The size of the primary disk in GB.
        """
        return pulumi.get(self, "primary_disk_size")

    @property
    @pulumi.getter(name="rebuildProtection")
    def rebuild_protection(self) -> bool:
        """
        (bool) Whether rebuild protection is enabled.
        """
        return pulumi.get(self, "rebuild_protection")

    @property
    @pulumi.getter
    def rescue(self) -> str:
        return pulumi.get(self, "rescue")

    @property
    @pulumi.getter
    def selector(self) -> Optional[str]:
        warnings.warn("""Please use the with_selector property instead.""", DeprecationWarning)
        pulumi.log.warn("""selector is deprecated: Please use the with_selector property instead.""")

        return pulumi.get(self, "selector")

    @property
    @pulumi.getter(name="serverType")
    def server_type(self) -> str:
        """
        (string) Name of the server type.
        """
        return pulumi.get(self, "server_type")

    @property
    @pulumi.getter
    def status(self) -> str:
        """
        (string) The status of the server.
        """
        return pulumi.get(self, "status")

    @property
    @pulumi.getter(name="withSelector")
    def with_selector(self) -> Optional[str]:
        return pulumi.get(self, "with_selector")

    @property
    @pulumi.getter(name="withStatuses")
    def with_statuses(self) -> Optional[Sequence[str]]:
        return pulumi.get(self, "with_statuses")


class AwaitableGetServerResult(GetServerResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetServerResult(
            backup_window=self.backup_window,
            backups=self.backups,
            datacenter=self.datacenter,
            delete_protection=self.delete_protection,
            firewall_ids=self.firewall_ids,
            id=self.id,
            image=self.image,
            ipv4_address=self.ipv4_address,
            ipv6_address=self.ipv6_address,
            ipv6_network=self.ipv6_network,
            iso=self.iso,
            labels=self.labels,
            location=self.location,
            name=self.name,
            placement_group_id=self.placement_group_id,
            primary_disk_size=self.primary_disk_size,
            rebuild_protection=self.rebuild_protection,
            rescue=self.rescue,
            selector=self.selector,
            server_type=self.server_type,
            status=self.status,
            with_selector=self.with_selector,
            with_statuses=self.with_statuses)


def get_server(id: Optional[int] = None,
               name: Optional[str] = None,
               placement_group_id: Optional[int] = None,
               selector: Optional[str] = None,
               with_selector: Optional[str] = None,
               with_statuses: Optional[Sequence[str]] = None,
               opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetServerResult:
    """
    ## Example Usage

    ```python
    import pulumi
    import pulumi_hcloud as hcloud

    s1 = hcloud.get_server(name="my-server")
    s2 = hcloud.get_server(id=123)
    s3 = hcloud.get_server(with_selector="key=value")
    ```


    :param int id: ID of the server.
    :param str name: Name of the server.
    :param int placement_group_id: (Optional, string) Placement Group ID the server is assigned to.
    :param str with_selector: Label Selector. For more information about possible values, visit the [Hetzner Cloud Documentation](https://docs.hetzner.cloud/#overview-label-selector).
    :param Sequence[str] with_statuses: List only servers with the specified status, could contain `initializing`, `starting`, `running`, `stopping`, `off`, `deleting`, `rebuilding`, `migrating`, `unknown`.
    """
    __args__ = dict()
    __args__['id'] = id
    __args__['name'] = name
    __args__['placementGroupId'] = placement_group_id
    __args__['selector'] = selector
    __args__['withSelector'] = with_selector
    __args__['withStatuses'] = with_statuses
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('hcloud:index/getServer:getServer', __args__, opts=opts, typ=GetServerResult).value

    return AwaitableGetServerResult(
        backup_window=pulumi.get(__ret__, 'backup_window'),
        backups=pulumi.get(__ret__, 'backups'),
        datacenter=pulumi.get(__ret__, 'datacenter'),
        delete_protection=pulumi.get(__ret__, 'delete_protection'),
        firewall_ids=pulumi.get(__ret__, 'firewall_ids'),
        id=pulumi.get(__ret__, 'id'),
        image=pulumi.get(__ret__, 'image'),
        ipv4_address=pulumi.get(__ret__, 'ipv4_address'),
        ipv6_address=pulumi.get(__ret__, 'ipv6_address'),
        ipv6_network=pulumi.get(__ret__, 'ipv6_network'),
        iso=pulumi.get(__ret__, 'iso'),
        labels=pulumi.get(__ret__, 'labels'),
        location=pulumi.get(__ret__, 'location'),
        name=pulumi.get(__ret__, 'name'),
        placement_group_id=pulumi.get(__ret__, 'placement_group_id'),
        primary_disk_size=pulumi.get(__ret__, 'primary_disk_size'),
        rebuild_protection=pulumi.get(__ret__, 'rebuild_protection'),
        rescue=pulumi.get(__ret__, 'rescue'),
        selector=pulumi.get(__ret__, 'selector'),
        server_type=pulumi.get(__ret__, 'server_type'),
        status=pulumi.get(__ret__, 'status'),
        with_selector=pulumi.get(__ret__, 'with_selector'),
        with_statuses=pulumi.get(__ret__, 'with_statuses'))


@_utilities.lift_output_func(get_server)
def get_server_output(id: Optional[pulumi.Input[Optional[int]]] = None,
                      name: Optional[pulumi.Input[Optional[str]]] = None,
                      placement_group_id: Optional[pulumi.Input[Optional[int]]] = None,
                      selector: Optional[pulumi.Input[Optional[str]]] = None,
                      with_selector: Optional[pulumi.Input[Optional[str]]] = None,
                      with_statuses: Optional[pulumi.Input[Optional[Sequence[str]]]] = None,
                      opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetServerResult]:
    """
    ## Example Usage

    ```python
    import pulumi
    import pulumi_hcloud as hcloud

    s1 = hcloud.get_server(name="my-server")
    s2 = hcloud.get_server(id=123)
    s3 = hcloud.get_server(with_selector="key=value")
    ```


    :param int id: ID of the server.
    :param str name: Name of the server.
    :param int placement_group_id: (Optional, string) Placement Group ID the server is assigned to.
    :param str with_selector: Label Selector. For more information about possible values, visit the [Hetzner Cloud Documentation](https://docs.hetzner.cloud/#overview-label-selector).
    :param Sequence[str] with_statuses: List only servers with the specified status, could contain `initializing`, `starting`, `running`, `stopping`, `off`, `deleting`, `rebuilding`, `migrating`, `unknown`.
    """
    ...
