# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from . import _utilities
from . import outputs

__all__ = [
    'FirewallApplyTo',
    'FirewallRule',
    'LoadBalancerAlgorithm',
    'LoadBalancerServiceHealthCheck',
    'LoadBalancerServiceHealthCheckHttp',
    'LoadBalancerServiceHttp',
    'LoadBalancerTarget',
    'ServerNetwork',
    'ServerPublicNet',
    'GetCertificatesCertificateResult',
    'GetDatacentersDatacenterResult',
    'GetFirewallApplyToResult',
    'GetFirewallRuleResult',
    'GetFirewallsFirewallResult',
    'GetFirewallsFirewallApplyToResult',
    'GetFirewallsFirewallRuleResult',
    'GetFloatingIpsFloatingIpResult',
    'GetImagesImageResult',
    'GetLoadBalancerAlgorithmResult',
    'GetLoadBalancerServiceResult',
    'GetLoadBalancerServiceHealthCheckResult',
    'GetLoadBalancerServiceHealthCheckHttpResult',
    'GetLoadBalancerServiceHttpResult',
    'GetLoadBalancerTargetResult',
    'GetLoadBalancersLoadBalancerResult',
    'GetLoadBalancersLoadBalancerAlgorithmResult',
    'GetLoadBalancersLoadBalancerServiceResult',
    'GetLoadBalancersLoadBalancerServiceHealthCheckResult',
    'GetLoadBalancersLoadBalancerServiceHealthCheckHttpResult',
    'GetLoadBalancersLoadBalancerServiceHttpResult',
    'GetLoadBalancersLoadBalancerTargetResult',
    'GetLocationsLocationResult',
    'GetNetworksNetworkResult',
    'GetPlacementGroupsPlacementGroupResult',
    'GetPrimaryIpsPrimaryIpResult',
    'GetServerTypesServerTypeResult',
    'GetServersServerResult',
    'GetSshKeysSshKeyResult',
    'GetVolumesVolumeResult',
]

@pulumi.output_type
class FirewallApplyTo(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "labelSelector":
            suggest = "label_selector"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in FirewallApplyTo. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        FirewallApplyTo.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        FirewallApplyTo.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 label_selector: Optional[str] = None,
                 server: Optional[int] = None):
        """
        :param str label_selector: Label Selector to select servers the firewall should be applied to (only one
               of `server` and `label_selector`can be applied in one block)
        :param int server: ID of the server you want to apply the firewall to (only one of `server`
               and `label_selector`can be applied in one block)
        """
        if label_selector is not None:
            pulumi.set(__self__, "label_selector", label_selector)
        if server is not None:
            pulumi.set(__self__, "server", server)

    @property
    @pulumi.getter(name="labelSelector")
    def label_selector(self) -> Optional[str]:
        """
        Label Selector to select servers the firewall should be applied to (only one
        of `server` and `label_selector`can be applied in one block)
        """
        return pulumi.get(self, "label_selector")

    @property
    @pulumi.getter
    def server(self) -> Optional[int]:
        """
        ID of the server you want to apply the firewall to (only one of `server`
        and `label_selector`can be applied in one block)
        """
        return pulumi.get(self, "server")


@pulumi.output_type
class FirewallRule(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "destinationIps":
            suggest = "destination_ips"
        elif key == "sourceIps":
            suggest = "source_ips"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in FirewallRule. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        FirewallRule.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        FirewallRule.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 direction: str,
                 protocol: str,
                 description: Optional[str] = None,
                 destination_ips: Optional[Sequence[str]] = None,
                 port: Optional[str] = None,
                 source_ips: Optional[Sequence[str]] = None):
        """
        :param str direction: Direction of the Firewall Rule. `in`
        :param str protocol: Protocol of the Firewall Rule. `tcp`, `icmp`, `udp`, `gre`, `esp`
        :param str description: Description of the firewall rule
        :param Sequence[str] destination_ips: List of IPs or CIDRs that are allowed within this Firewall Rule (when `direction`
               is `out`)
        :param str port: Port of the Firewall Rule. Required when `protocol` is `tcp` or `udp`. You can use `any`
               to allow all ports for the specific protocol. Port ranges are also possible: `80-85` allows all ports between 80 and 85.
        :param Sequence[str] source_ips: List of IPs or CIDRs that are allowed within this Firewall Rule (when `direction`
               is `in`)
        """
        pulumi.set(__self__, "direction", direction)
        pulumi.set(__self__, "protocol", protocol)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if destination_ips is not None:
            pulumi.set(__self__, "destination_ips", destination_ips)
        if port is not None:
            pulumi.set(__self__, "port", port)
        if source_ips is not None:
            pulumi.set(__self__, "source_ips", source_ips)

    @property
    @pulumi.getter
    def direction(self) -> str:
        """
        Direction of the Firewall Rule. `in`
        """
        return pulumi.get(self, "direction")

    @property
    @pulumi.getter
    def protocol(self) -> str:
        """
        Protocol of the Firewall Rule. `tcp`, `icmp`, `udp`, `gre`, `esp`
        """
        return pulumi.get(self, "protocol")

    @property
    @pulumi.getter
    def description(self) -> Optional[str]:
        """
        Description of the firewall rule
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="destinationIps")
    def destination_ips(self) -> Optional[Sequence[str]]:
        """
        List of IPs or CIDRs that are allowed within this Firewall Rule (when `direction`
        is `out`)
        """
        return pulumi.get(self, "destination_ips")

    @property
    @pulumi.getter
    def port(self) -> Optional[str]:
        """
        Port of the Firewall Rule. Required when `protocol` is `tcp` or `udp`. You can use `any`
        to allow all ports for the specific protocol. Port ranges are also possible: `80-85` allows all ports between 80 and 85.
        """
        return pulumi.get(self, "port")

    @property
    @pulumi.getter(name="sourceIps")
    def source_ips(self) -> Optional[Sequence[str]]:
        """
        List of IPs or CIDRs that are allowed within this Firewall Rule (when `direction`
        is `in`)
        """
        return pulumi.get(self, "source_ips")


@pulumi.output_type
class LoadBalancerAlgorithm(dict):
    def __init__(__self__, *,
                 type: Optional[str] = None):
        """
        :param str type: Type of the Load Balancer Algorithm. `round_robin` or `least_connections`
        """
        if type is not None:
            pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter
    def type(self) -> Optional[str]:
        """
        Type of the Load Balancer Algorithm. `round_robin` or `least_connections`
        """
        return pulumi.get(self, "type")


@pulumi.output_type
class LoadBalancerServiceHealthCheck(dict):
    def __init__(__self__, *,
                 interval: int,
                 port: int,
                 protocol: str,
                 timeout: int,
                 http: Optional['outputs.LoadBalancerServiceHealthCheckHttp'] = None,
                 retries: Optional[int] = None):
        """
        :param int interval: Interval how often the health check will be performed, in seconds.
        :param int port: Port the health check tries to connect to, required if protocol is `tcp`. Can be everything between `1` and `65535`. Must be unique per Load Balancer.
        :param str protocol: Protocol the health check uses. `http` or `tcp`
        :param int timeout: Timeout when a health check try will be canceled if there is no response, in seconds.
        :param 'LoadBalancerServiceHealthCheckHttpArgs' http: HTTP configuration. Required if `protocol` is `http`.
        :param int retries: Number of tries a health check will be performed until a target will be listed as `unhealthy`.
        """
        pulumi.set(__self__, "interval", interval)
        pulumi.set(__self__, "port", port)
        pulumi.set(__self__, "protocol", protocol)
        pulumi.set(__self__, "timeout", timeout)
        if http is not None:
            pulumi.set(__self__, "http", http)
        if retries is not None:
            pulumi.set(__self__, "retries", retries)

    @property
    @pulumi.getter
    def interval(self) -> int:
        """
        Interval how often the health check will be performed, in seconds.
        """
        return pulumi.get(self, "interval")

    @property
    @pulumi.getter
    def port(self) -> int:
        """
        Port the health check tries to connect to, required if protocol is `tcp`. Can be everything between `1` and `65535`. Must be unique per Load Balancer.
        """
        return pulumi.get(self, "port")

    @property
    @pulumi.getter
    def protocol(self) -> str:
        """
        Protocol the health check uses. `http` or `tcp`
        """
        return pulumi.get(self, "protocol")

    @property
    @pulumi.getter
    def timeout(self) -> int:
        """
        Timeout when a health check try will be canceled if there is no response, in seconds.
        """
        return pulumi.get(self, "timeout")

    @property
    @pulumi.getter
    def http(self) -> Optional['outputs.LoadBalancerServiceHealthCheckHttp']:
        """
        HTTP configuration. Required if `protocol` is `http`.
        """
        return pulumi.get(self, "http")

    @property
    @pulumi.getter
    def retries(self) -> Optional[int]:
        """
        Number of tries a health check will be performed until a target will be listed as `unhealthy`.
        """
        return pulumi.get(self, "retries")


@pulumi.output_type
class LoadBalancerServiceHealthCheckHttp(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "statusCodes":
            suggest = "status_codes"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in LoadBalancerServiceHealthCheckHttp. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        LoadBalancerServiceHealthCheckHttp.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        LoadBalancerServiceHealthCheckHttp.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 domain: Optional[str] = None,
                 path: Optional[str] = None,
                 response: Optional[str] = None,
                 status_codes: Optional[Sequence[str]] = None,
                 tls: Optional[bool] = None):
        """
        :param str domain: Domain we try to access when performing the Health Check.
        :param str path: Path we try to access when performing the Health Check.
        :param str response: Response we expect to be included in the Target response when a Health Check was performed.
        :param Sequence[str] status_codes: We expect that the target answers with these status codes. If not the target is marked as `unhealthy`.
        :param bool tls: Enable TLS certificate checking.
        """
        if domain is not None:
            pulumi.set(__self__, "domain", domain)
        if path is not None:
            pulumi.set(__self__, "path", path)
        if response is not None:
            pulumi.set(__self__, "response", response)
        if status_codes is not None:
            pulumi.set(__self__, "status_codes", status_codes)
        if tls is not None:
            pulumi.set(__self__, "tls", tls)

    @property
    @pulumi.getter
    def domain(self) -> Optional[str]:
        """
        Domain we try to access when performing the Health Check.
        """
        return pulumi.get(self, "domain")

    @property
    @pulumi.getter
    def path(self) -> Optional[str]:
        """
        Path we try to access when performing the Health Check.
        """
        return pulumi.get(self, "path")

    @property
    @pulumi.getter
    def response(self) -> Optional[str]:
        """
        Response we expect to be included in the Target response when a Health Check was performed.
        """
        return pulumi.get(self, "response")

    @property
    @pulumi.getter(name="statusCodes")
    def status_codes(self) -> Optional[Sequence[str]]:
        """
        We expect that the target answers with these status codes. If not the target is marked as `unhealthy`.
        """
        return pulumi.get(self, "status_codes")

    @property
    @pulumi.getter
    def tls(self) -> Optional[bool]:
        """
        Enable TLS certificate checking.
        """
        return pulumi.get(self, "tls")


@pulumi.output_type
class LoadBalancerServiceHttp(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "cookieLifetime":
            suggest = "cookie_lifetime"
        elif key == "cookieName":
            suggest = "cookie_name"
        elif key == "redirectHttp":
            suggest = "redirect_http"
        elif key == "stickySessions":
            suggest = "sticky_sessions"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in LoadBalancerServiceHttp. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        LoadBalancerServiceHttp.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        LoadBalancerServiceHttp.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 certificates: Optional[Sequence[int]] = None,
                 cookie_lifetime: Optional[int] = None,
                 cookie_name: Optional[str] = None,
                 redirect_http: Optional[bool] = None,
                 sticky_sessions: Optional[bool] = None):
        """
        :param Sequence[int] certificates: List of IDs from certificates which the Load Balancer has.
        :param int cookie_lifetime: Lifetime of the cookie for sticky session (in seconds). Default: `300`
        :param str cookie_name: Name of the cookie for sticky session. Default: `HCLBSTICKY`
        :param bool redirect_http: Redirect HTTP to HTTPS traffic. Only supported for services with `protocol` `https` using the default HTTP port `80`.
        :param bool sticky_sessions: Enable sticky sessions
        """
        if certificates is not None:
            pulumi.set(__self__, "certificates", certificates)
        if cookie_lifetime is not None:
            pulumi.set(__self__, "cookie_lifetime", cookie_lifetime)
        if cookie_name is not None:
            pulumi.set(__self__, "cookie_name", cookie_name)
        if redirect_http is not None:
            pulumi.set(__self__, "redirect_http", redirect_http)
        if sticky_sessions is not None:
            pulumi.set(__self__, "sticky_sessions", sticky_sessions)

    @property
    @pulumi.getter
    def certificates(self) -> Optional[Sequence[int]]:
        """
        List of IDs from certificates which the Load Balancer has.
        """
        return pulumi.get(self, "certificates")

    @property
    @pulumi.getter(name="cookieLifetime")
    def cookie_lifetime(self) -> Optional[int]:
        """
        Lifetime of the cookie for sticky session (in seconds). Default: `300`
        """
        return pulumi.get(self, "cookie_lifetime")

    @property
    @pulumi.getter(name="cookieName")
    def cookie_name(self) -> Optional[str]:
        """
        Name of the cookie for sticky session. Default: `HCLBSTICKY`
        """
        return pulumi.get(self, "cookie_name")

    @property
    @pulumi.getter(name="redirectHttp")
    def redirect_http(self) -> Optional[bool]:
        """
        Redirect HTTP to HTTPS traffic. Only supported for services with `protocol` `https` using the default HTTP port `80`.
        """
        return pulumi.get(self, "redirect_http")

    @property
    @pulumi.getter(name="stickySessions")
    def sticky_sessions(self) -> Optional[bool]:
        """
        Enable sticky sessions
        """
        return pulumi.get(self, "sticky_sessions")


@pulumi.output_type
class LoadBalancerTarget(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "serverId":
            suggest = "server_id"
        elif key == "usePrivateIp":
            suggest = "use_private_ip"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in LoadBalancerTarget. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        LoadBalancerTarget.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        LoadBalancerTarget.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 type: str,
                 server_id: Optional[int] = None,
                 use_private_ip: Optional[bool] = None):
        """
        :param str type: (string) Type of the Load Balancer Algorithm. `round_robin` or `least_connections`
        """
        pulumi.set(__self__, "type", type)
        if server_id is not None:
            pulumi.set(__self__, "server_id", server_id)
        if use_private_ip is not None:
            pulumi.set(__self__, "use_private_ip", use_private_ip)

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        (string) Type of the Load Balancer Algorithm. `round_robin` or `least_connections`
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter(name="serverId")
    def server_id(self) -> Optional[int]:
        return pulumi.get(self, "server_id")

    @property
    @pulumi.getter(name="usePrivateIp")
    def use_private_ip(self) -> Optional[bool]:
        warnings.warn("""Does not work. Use the LoadBalancerTarget resource instead.""", DeprecationWarning)
        pulumi.log.warn("""use_private_ip is deprecated: Does not work. Use the LoadBalancerTarget resource instead.""")

        return pulumi.get(self, "use_private_ip")


@pulumi.output_type
class ServerNetwork(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "networkId":
            suggest = "network_id"
        elif key == "aliasIps":
            suggest = "alias_ips"
        elif key == "macAddress":
            suggest = "mac_address"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ServerNetwork. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ServerNetwork.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ServerNetwork.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 network_id: int,
                 alias_ips: Optional[Sequence[str]] = None,
                 ip: Optional[str] = None,
                 mac_address: Optional[str] = None):
        """
        :param int network_id: ID of the network
        :param str ip: Specify the IP the server should get in the network
        :param str mac_address: (Optional, string) The MAC address the private interface of the server has
        """
        pulumi.set(__self__, "network_id", network_id)
        if alias_ips is not None:
            pulumi.set(__self__, "alias_ips", alias_ips)
        if ip is not None:
            pulumi.set(__self__, "ip", ip)
        if mac_address is not None:
            pulumi.set(__self__, "mac_address", mac_address)

    @property
    @pulumi.getter(name="networkId")
    def network_id(self) -> int:
        """
        ID of the network
        """
        return pulumi.get(self, "network_id")

    @property
    @pulumi.getter(name="aliasIps")
    def alias_ips(self) -> Optional[Sequence[str]]:
        return pulumi.get(self, "alias_ips")

    @property
    @pulumi.getter
    def ip(self) -> Optional[str]:
        """
        Specify the IP the server should get in the network
        """
        return pulumi.get(self, "ip")

    @property
    @pulumi.getter(name="macAddress")
    def mac_address(self) -> Optional[str]:
        """
        (Optional, string) The MAC address the private interface of the server has
        """
        return pulumi.get(self, "mac_address")


@pulumi.output_type
class ServerPublicNet(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "ipv4Enabled":
            suggest = "ipv4_enabled"
        elif key == "ipv6Enabled":
            suggest = "ipv6_enabled"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ServerPublicNet. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ServerPublicNet.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ServerPublicNet.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 ipv4: Optional[int] = None,
                 ipv4_enabled: Optional[bool] = None,
                 ipv6: Optional[int] = None,
                 ipv6_enabled: Optional[bool] = None):
        if ipv4 is not None:
            pulumi.set(__self__, "ipv4", ipv4)
        if ipv4_enabled is not None:
            pulumi.set(__self__, "ipv4_enabled", ipv4_enabled)
        if ipv6 is not None:
            pulumi.set(__self__, "ipv6", ipv6)
        if ipv6_enabled is not None:
            pulumi.set(__self__, "ipv6_enabled", ipv6_enabled)

    @property
    @pulumi.getter
    def ipv4(self) -> Optional[int]:
        return pulumi.get(self, "ipv4")

    @property
    @pulumi.getter(name="ipv4Enabled")
    def ipv4_enabled(self) -> Optional[bool]:
        return pulumi.get(self, "ipv4_enabled")

    @property
    @pulumi.getter
    def ipv6(self) -> Optional[int]:
        return pulumi.get(self, "ipv6")

    @property
    @pulumi.getter(name="ipv6Enabled")
    def ipv6_enabled(self) -> Optional[bool]:
        return pulumi.get(self, "ipv6_enabled")


@pulumi.output_type
class GetCertificatesCertificateResult(dict):
    def __init__(__self__, *,
                 certificate: str,
                 created: str,
                 domain_names: Sequence[str],
                 fingerprint: str,
                 id: int,
                 labels: Mapping[str, Any],
                 not_valid_after: str,
                 not_valid_before: str,
                 type: str,
                 name: Optional[str] = None):
        pulumi.set(__self__, "certificate", certificate)
        pulumi.set(__self__, "created", created)
        pulumi.set(__self__, "domain_names", domain_names)
        pulumi.set(__self__, "fingerprint", fingerprint)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "labels", labels)
        pulumi.set(__self__, "not_valid_after", not_valid_after)
        pulumi.set(__self__, "not_valid_before", not_valid_before)
        pulumi.set(__self__, "type", type)
        if name is not None:
            pulumi.set(__self__, "name", name)

    @property
    @pulumi.getter
    def certificate(self) -> str:
        return pulumi.get(self, "certificate")

    @property
    @pulumi.getter
    def created(self) -> str:
        return pulumi.get(self, "created")

    @property
    @pulumi.getter(name="domainNames")
    def domain_names(self) -> Sequence[str]:
        return pulumi.get(self, "domain_names")

    @property
    @pulumi.getter
    def fingerprint(self) -> str:
        return pulumi.get(self, "fingerprint")

    @property
    @pulumi.getter
    def id(self) -> int:
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def labels(self) -> Mapping[str, Any]:
        return pulumi.get(self, "labels")

    @property
    @pulumi.getter(name="notValidAfter")
    def not_valid_after(self) -> str:
        return pulumi.get(self, "not_valid_after")

    @property
    @pulumi.getter(name="notValidBefore")
    def not_valid_before(self) -> str:
        return pulumi.get(self, "not_valid_before")

    @property
    @pulumi.getter
    def type(self) -> str:
        return pulumi.get(self, "type")

    @property
    @pulumi.getter
    def name(self) -> Optional[str]:
        return pulumi.get(self, "name")


@pulumi.output_type
class GetDatacentersDatacenterResult(dict):
    def __init__(__self__, *,
                 available_server_type_ids: Sequence[int],
                 description: str,
                 id: int,
                 location: Mapping[str, str],
                 name: str,
                 supported_server_type_ids: Sequence[int]):
        pulumi.set(__self__, "available_server_type_ids", available_server_type_ids)
        pulumi.set(__self__, "description", description)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "location", location)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "supported_server_type_ids", supported_server_type_ids)

    @property
    @pulumi.getter(name="availableServerTypeIds")
    def available_server_type_ids(self) -> Sequence[int]:
        return pulumi.get(self, "available_server_type_ids")

    @property
    @pulumi.getter
    def description(self) -> str:
        return pulumi.get(self, "description")

    @property
    @pulumi.getter
    def id(self) -> int:
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def location(self) -> Mapping[str, str]:
        return pulumi.get(self, "location")

    @property
    @pulumi.getter
    def name(self) -> str:
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="supportedServerTypeIds")
    def supported_server_type_ids(self) -> Sequence[int]:
        return pulumi.get(self, "supported_server_type_ids")


@pulumi.output_type
class GetFirewallApplyToResult(dict):
    def __init__(__self__, *,
                 label_selector: str,
                 server: int):
        """
        :param str label_selector: (string) Label Selector to select servers the firewall is applied to. Empty if a server is directly
               referenced
        :param int server: (int) ID of a server where the firewall is applied to. `0` if applied to a label_selector
        """
        pulumi.set(__self__, "label_selector", label_selector)
        pulumi.set(__self__, "server", server)

    @property
    @pulumi.getter(name="labelSelector")
    def label_selector(self) -> str:
        """
        (string) Label Selector to select servers the firewall is applied to. Empty if a server is directly
        referenced
        """
        return pulumi.get(self, "label_selector")

    @property
    @pulumi.getter
    def server(self) -> int:
        """
        (int) ID of a server where the firewall is applied to. `0` if applied to a label_selector
        """
        return pulumi.get(self, "server")


@pulumi.output_type
class GetFirewallRuleResult(dict):
    def __init__(__self__, *,
                 direction: str,
                 description: Optional[str] = None,
                 destination_ips: Optional[Sequence[str]] = None,
                 port: Optional[str] = None,
                 protocol: Optional[str] = None,
                 source_ips: Optional[Sequence[str]] = None):
        """
        :param str direction: (Required, string) Direction of the Firewall Rule. `in`, `out`
        :param str description: (Optional, string) Description of the firewall rule
        :param Sequence[str] destination_ips: (Required, List) List of CIDRs that are allowed within this Firewall Rule (when `direction` is `out`)
        :param str port: (Required, string) Port of the Firewall Rule. Required when `protocol` is `tcp` or `udp`
        :param str protocol: (Required, string) Protocol of the Firewall Rule. `tcp`, `icmp`, `udp`, `gre`, `esp`
        :param Sequence[str] source_ips: (Required, List) List of CIDRs that are allowed within this Firewall Rule (when `direction` is `in`)
        """
        pulumi.set(__self__, "direction", direction)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if destination_ips is not None:
            pulumi.set(__self__, "destination_ips", destination_ips)
        if port is not None:
            pulumi.set(__self__, "port", port)
        if protocol is not None:
            pulumi.set(__self__, "protocol", protocol)
        if source_ips is not None:
            pulumi.set(__self__, "source_ips", source_ips)

    @property
    @pulumi.getter
    def direction(self) -> str:
        """
        (Required, string) Direction of the Firewall Rule. `in`, `out`
        """
        return pulumi.get(self, "direction")

    @property
    @pulumi.getter
    def description(self) -> Optional[str]:
        """
        (Optional, string) Description of the firewall rule
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="destinationIps")
    def destination_ips(self) -> Optional[Sequence[str]]:
        """
        (Required, List) List of CIDRs that are allowed within this Firewall Rule (when `direction` is `out`)
        """
        return pulumi.get(self, "destination_ips")

    @property
    @pulumi.getter
    def port(self) -> Optional[str]:
        """
        (Required, string) Port of the Firewall Rule. Required when `protocol` is `tcp` or `udp`
        """
        return pulumi.get(self, "port")

    @property
    @pulumi.getter
    def protocol(self) -> Optional[str]:
        """
        (Required, string) Protocol of the Firewall Rule. `tcp`, `icmp`, `udp`, `gre`, `esp`
        """
        return pulumi.get(self, "protocol")

    @property
    @pulumi.getter(name="sourceIps")
    def source_ips(self) -> Optional[Sequence[str]]:
        """
        (Required, List) List of CIDRs that are allowed within this Firewall Rule (when `direction` is `in`)
        """
        return pulumi.get(self, "source_ips")


@pulumi.output_type
class GetFirewallsFirewallResult(dict):
    def __init__(__self__, *,
                 name: str,
                 apply_tos: Optional[Sequence['outputs.GetFirewallsFirewallApplyToResult']] = None,
                 id: Optional[int] = None,
                 labels: Optional[Mapping[str, Any]] = None,
                 rules: Optional[Sequence['outputs.GetFirewallsFirewallRuleResult']] = None):
        pulumi.set(__self__, "name", name)
        if apply_tos is not None:
            pulumi.set(__self__, "apply_tos", apply_tos)
        if id is not None:
            pulumi.set(__self__, "id", id)
        if labels is not None:
            pulumi.set(__self__, "labels", labels)
        if rules is not None:
            pulumi.set(__self__, "rules", rules)

    @property
    @pulumi.getter
    def name(self) -> str:
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="applyTos")
    def apply_tos(self) -> Optional[Sequence['outputs.GetFirewallsFirewallApplyToResult']]:
        return pulumi.get(self, "apply_tos")

    @property
    @pulumi.getter
    def id(self) -> Optional[int]:
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def labels(self) -> Optional[Mapping[str, Any]]:
        return pulumi.get(self, "labels")

    @property
    @pulumi.getter
    def rules(self) -> Optional[Sequence['outputs.GetFirewallsFirewallRuleResult']]:
        return pulumi.get(self, "rules")


@pulumi.output_type
class GetFirewallsFirewallApplyToResult(dict):
    def __init__(__self__, *,
                 label_selector: str,
                 server: int):
        pulumi.set(__self__, "label_selector", label_selector)
        pulumi.set(__self__, "server", server)

    @property
    @pulumi.getter(name="labelSelector")
    def label_selector(self) -> str:
        return pulumi.get(self, "label_selector")

    @property
    @pulumi.getter
    def server(self) -> int:
        return pulumi.get(self, "server")


@pulumi.output_type
class GetFirewallsFirewallRuleResult(dict):
    def __init__(__self__, *,
                 direction: str,
                 description: Optional[str] = None,
                 destination_ips: Optional[Sequence[str]] = None,
                 port: Optional[str] = None,
                 protocol: Optional[str] = None,
                 source_ips: Optional[Sequence[str]] = None):
        pulumi.set(__self__, "direction", direction)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if destination_ips is not None:
            pulumi.set(__self__, "destination_ips", destination_ips)
        if port is not None:
            pulumi.set(__self__, "port", port)
        if protocol is not None:
            pulumi.set(__self__, "protocol", protocol)
        if source_ips is not None:
            pulumi.set(__self__, "source_ips", source_ips)

    @property
    @pulumi.getter
    def direction(self) -> str:
        return pulumi.get(self, "direction")

    @property
    @pulumi.getter
    def description(self) -> Optional[str]:
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="destinationIps")
    def destination_ips(self) -> Optional[Sequence[str]]:
        return pulumi.get(self, "destination_ips")

    @property
    @pulumi.getter
    def port(self) -> Optional[str]:
        return pulumi.get(self, "port")

    @property
    @pulumi.getter
    def protocol(self) -> Optional[str]:
        return pulumi.get(self, "protocol")

    @property
    @pulumi.getter(name="sourceIps")
    def source_ips(self) -> Optional[Sequence[str]]:
        return pulumi.get(self, "source_ips")


@pulumi.output_type
class GetFloatingIpsFloatingIpResult(dict):
    def __init__(__self__, *,
                 delete_protection: bool,
                 description: str,
                 home_location: str,
                 id: int,
                 ip_address: str,
                 ip_network: str,
                 labels: Mapping[str, Any],
                 server_id: int,
                 type: str,
                 name: Optional[str] = None):
        pulumi.set(__self__, "delete_protection", delete_protection)
        pulumi.set(__self__, "description", description)
        pulumi.set(__self__, "home_location", home_location)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "ip_address", ip_address)
        pulumi.set(__self__, "ip_network", ip_network)
        pulumi.set(__self__, "labels", labels)
        pulumi.set(__self__, "server_id", server_id)
        pulumi.set(__self__, "type", type)
        if name is not None:
            pulumi.set(__self__, "name", name)

    @property
    @pulumi.getter(name="deleteProtection")
    def delete_protection(self) -> bool:
        return pulumi.get(self, "delete_protection")

    @property
    @pulumi.getter
    def description(self) -> str:
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="homeLocation")
    def home_location(self) -> str:
        return pulumi.get(self, "home_location")

    @property
    @pulumi.getter
    def id(self) -> int:
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="ipAddress")
    def ip_address(self) -> str:
        return pulumi.get(self, "ip_address")

    @property
    @pulumi.getter(name="ipNetwork")
    def ip_network(self) -> str:
        return pulumi.get(self, "ip_network")

    @property
    @pulumi.getter
    def labels(self) -> Mapping[str, Any]:
        return pulumi.get(self, "labels")

    @property
    @pulumi.getter(name="serverId")
    def server_id(self) -> int:
        return pulumi.get(self, "server_id")

    @property
    @pulumi.getter
    def type(self) -> str:
        return pulumi.get(self, "type")

    @property
    @pulumi.getter
    def name(self) -> Optional[str]:
        return pulumi.get(self, "name")


@pulumi.output_type
class GetImagesImageResult(dict):
    def __init__(__self__, *,
                 architecture: str,
                 created: str,
                 deprecated: str,
                 description: str,
                 id: int,
                 labels: Mapping[str, Any],
                 name: str,
                 os_flavor: str,
                 os_version: str,
                 rapid_deploy: bool,
                 type: str,
                 selector: Optional[str] = None):
        pulumi.set(__self__, "architecture", architecture)
        pulumi.set(__self__, "created", created)
        pulumi.set(__self__, "deprecated", deprecated)
        pulumi.set(__self__, "description", description)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "labels", labels)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "os_flavor", os_flavor)
        pulumi.set(__self__, "os_version", os_version)
        pulumi.set(__self__, "rapid_deploy", rapid_deploy)
        pulumi.set(__self__, "type", type)
        if selector is not None:
            pulumi.set(__self__, "selector", selector)

    @property
    @pulumi.getter
    def architecture(self) -> str:
        return pulumi.get(self, "architecture")

    @property
    @pulumi.getter
    def created(self) -> str:
        return pulumi.get(self, "created")

    @property
    @pulumi.getter
    def deprecated(self) -> str:
        return pulumi.get(self, "deprecated")

    @property
    @pulumi.getter
    def description(self) -> str:
        return pulumi.get(self, "description")

    @property
    @pulumi.getter
    def id(self) -> int:
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def labels(self) -> Mapping[str, Any]:
        return pulumi.get(self, "labels")

    @property
    @pulumi.getter
    def name(self) -> str:
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="osFlavor")
    def os_flavor(self) -> str:
        return pulumi.get(self, "os_flavor")

    @property
    @pulumi.getter(name="osVersion")
    def os_version(self) -> str:
        return pulumi.get(self, "os_version")

    @property
    @pulumi.getter(name="rapidDeploy")
    def rapid_deploy(self) -> bool:
        return pulumi.get(self, "rapid_deploy")

    @property
    @pulumi.getter
    def type(self) -> str:
        return pulumi.get(self, "type")

    @property
    @pulumi.getter
    def selector(self) -> Optional[str]:
        warnings.warn("""Please use the with_selector property instead.""", DeprecationWarning)
        pulumi.log.warn("""selector is deprecated: Please use the with_selector property instead.""")

        return pulumi.get(self, "selector")


@pulumi.output_type
class GetLoadBalancerAlgorithmResult(dict):
    def __init__(__self__, *,
                 type: str):
        """
        :param str type: (string) Type of the target. `server` or `label_selector`
        """
        pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        (string) Type of the target. `server` or `label_selector`
        """
        return pulumi.get(self, "type")


@pulumi.output_type
class GetLoadBalancerServiceResult(dict):
    def __init__(__self__, *,
                 destination_port: int,
                 health_checks: Sequence['outputs.GetLoadBalancerServiceHealthCheckResult'],
                 https: Sequence['outputs.GetLoadBalancerServiceHttpResult'],
                 listen_port: int,
                 protocol: str,
                 proxyprotocol: bool):
        """
        :param int destination_port: (int) Port the service connects to the targets on. Can be everything between `1` and `65535`.
        :param Sequence['GetLoadBalancerServiceHealthCheckArgs'] health_checks: (list) List of http configurations when `protocol` is `http` or `https`.
        :param Sequence['GetLoadBalancerServiceHttpArgs'] https: (list) List of http configurations when `protocol` is `http` or `https`.
        :param int listen_port: (int) Port the service listen on`. Can be everything between `1` and `65535`. Must be unique per Load Balancer.
        :param str protocol: (string) Protocol the health check uses. `http`, `https` or `tcp`
        :param bool proxyprotocol: (bool) Enable proxyprotocol.
        """
        pulumi.set(__self__, "destination_port", destination_port)
        pulumi.set(__self__, "health_checks", health_checks)
        pulumi.set(__self__, "https", https)
        pulumi.set(__self__, "listen_port", listen_port)
        pulumi.set(__self__, "protocol", protocol)
        pulumi.set(__self__, "proxyprotocol", proxyprotocol)

    @property
    @pulumi.getter(name="destinationPort")
    def destination_port(self) -> int:
        """
        (int) Port the service connects to the targets on. Can be everything between `1` and `65535`.
        """
        return pulumi.get(self, "destination_port")

    @property
    @pulumi.getter(name="healthChecks")
    def health_checks(self) -> Sequence['outputs.GetLoadBalancerServiceHealthCheckResult']:
        """
        (list) List of http configurations when `protocol` is `http` or `https`.
        """
        return pulumi.get(self, "health_checks")

    @property
    @pulumi.getter
    def https(self) -> Sequence['outputs.GetLoadBalancerServiceHttpResult']:
        """
        (list) List of http configurations when `protocol` is `http` or `https`.
        """
        return pulumi.get(self, "https")

    @property
    @pulumi.getter(name="listenPort")
    def listen_port(self) -> int:
        """
        (int) Port the service listen on`. Can be everything between `1` and `65535`. Must be unique per Load Balancer.
        """
        return pulumi.get(self, "listen_port")

    @property
    @pulumi.getter
    def protocol(self) -> str:
        """
        (string) Protocol the health check uses. `http`, `https` or `tcp`
        """
        return pulumi.get(self, "protocol")

    @property
    @pulumi.getter
    def proxyprotocol(self) -> bool:
        """
        (bool) Enable proxyprotocol.
        """
        return pulumi.get(self, "proxyprotocol")


@pulumi.output_type
class GetLoadBalancerServiceHealthCheckResult(dict):
    def __init__(__self__, *,
                 https: Sequence['outputs.GetLoadBalancerServiceHealthCheckHttpResult'],
                 interval: int,
                 port: int,
                 protocol: str,
                 retries: int,
                 timeout: int):
        """
        :param Sequence['GetLoadBalancerServiceHealthCheckHttpArgs'] https: (list) List of http configurations when `protocol` is `http` or `https`.
        :param int interval: (int) Interval how often the health check will be performed, in seconds.
        :param int port: (int) Port the health check tries to connect to. Can be everything between `1` and `65535`.
        :param str protocol: (string) Protocol the health check uses. `http`, `https` or `tcp`
        :param int retries: (int) Number of tries a health check will be performed until a target will be listed as `unhealthy`.
        :param int timeout: (int) Timeout when a health check try will be canceled if there is no response, in seconds.
        """
        pulumi.set(__self__, "https", https)
        pulumi.set(__self__, "interval", interval)
        pulumi.set(__self__, "port", port)
        pulumi.set(__self__, "protocol", protocol)
        pulumi.set(__self__, "retries", retries)
        pulumi.set(__self__, "timeout", timeout)

    @property
    @pulumi.getter
    def https(self) -> Sequence['outputs.GetLoadBalancerServiceHealthCheckHttpResult']:
        """
        (list) List of http configurations when `protocol` is `http` or `https`.
        """
        return pulumi.get(self, "https")

    @property
    @pulumi.getter
    def interval(self) -> int:
        """
        (int) Interval how often the health check will be performed, in seconds.
        """
        return pulumi.get(self, "interval")

    @property
    @pulumi.getter
    def port(self) -> int:
        """
        (int) Port the health check tries to connect to. Can be everything between `1` and `65535`.
        """
        return pulumi.get(self, "port")

    @property
    @pulumi.getter
    def protocol(self) -> str:
        """
        (string) Protocol the health check uses. `http`, `https` or `tcp`
        """
        return pulumi.get(self, "protocol")

    @property
    @pulumi.getter
    def retries(self) -> int:
        """
        (int) Number of tries a health check will be performed until a target will be listed as `unhealthy`.
        """
        return pulumi.get(self, "retries")

    @property
    @pulumi.getter
    def timeout(self) -> int:
        """
        (int) Timeout when a health check try will be canceled if there is no response, in seconds.
        """
        return pulumi.get(self, "timeout")


@pulumi.output_type
class GetLoadBalancerServiceHealthCheckHttpResult(dict):
    def __init__(__self__, *,
                 domain: str,
                 path: str,
                 response: str,
                 status_codes: Sequence[int],
                 tls: bool):
        """
        :param str domain: string) Domain we try to access when performing the Health Check.
        :param str path: (string) Path we try to access when performing the Health Check.
        :param str response: (string) Response we expect to be included in the Target response when a Health Check was performed.
        :param Sequence[int] status_codes: (list[int]) We expect that the target answers with these status codes. If not the target is marked as `unhealthy`.
        :param bool tls: (bool) Enable TLS certificate checking.
        """
        pulumi.set(__self__, "domain", domain)
        pulumi.set(__self__, "path", path)
        pulumi.set(__self__, "response", response)
        pulumi.set(__self__, "status_codes", status_codes)
        pulumi.set(__self__, "tls", tls)

    @property
    @pulumi.getter
    def domain(self) -> str:
        """
        string) Domain we try to access when performing the Health Check.
        """
        return pulumi.get(self, "domain")

    @property
    @pulumi.getter
    def path(self) -> str:
        """
        (string) Path we try to access when performing the Health Check.
        """
        return pulumi.get(self, "path")

    @property
    @pulumi.getter
    def response(self) -> str:
        """
        (string) Response we expect to be included in the Target response when a Health Check was performed.
        """
        return pulumi.get(self, "response")

    @property
    @pulumi.getter(name="statusCodes")
    def status_codes(self) -> Sequence[int]:
        """
        (list[int]) We expect that the target answers with these status codes. If not the target is marked as `unhealthy`.
        """
        return pulumi.get(self, "status_codes")

    @property
    @pulumi.getter
    def tls(self) -> bool:
        """
        (bool) Enable TLS certificate checking.
        """
        return pulumi.get(self, "tls")


@pulumi.output_type
class GetLoadBalancerServiceHttpResult(dict):
    def __init__(__self__, *,
                 certificates: Sequence[str],
                 cookie_lifetime: int,
                 cookie_name: str,
                 redirect_http: bool,
                 sticky_sessions: bool):
        """
        :param Sequence[str] certificates: (list[int]) List of IDs from certificates which the Load Balancer has.
        :param int cookie_lifetime: (int) Lifetime of the cookie for sticky session (in seconds).
        :param str cookie_name: (string) Name of the cookie for sticky session.
        :param bool redirect_http: (string) Determine if all requests from port 80 should be redirected to port 443.
        :param bool sticky_sessions: (string) Determine if sticky sessions are enabled or not.
        """
        pulumi.set(__self__, "certificates", certificates)
        pulumi.set(__self__, "cookie_lifetime", cookie_lifetime)
        pulumi.set(__self__, "cookie_name", cookie_name)
        pulumi.set(__self__, "redirect_http", redirect_http)
        pulumi.set(__self__, "sticky_sessions", sticky_sessions)

    @property
    @pulumi.getter
    def certificates(self) -> Sequence[str]:
        """
        (list[int]) List of IDs from certificates which the Load Balancer has.
        """
        return pulumi.get(self, "certificates")

    @property
    @pulumi.getter(name="cookieLifetime")
    def cookie_lifetime(self) -> int:
        """
        (int) Lifetime of the cookie for sticky session (in seconds).
        """
        return pulumi.get(self, "cookie_lifetime")

    @property
    @pulumi.getter(name="cookieName")
    def cookie_name(self) -> str:
        """
        (string) Name of the cookie for sticky session.
        """
        return pulumi.get(self, "cookie_name")

    @property
    @pulumi.getter(name="redirectHttp")
    def redirect_http(self) -> bool:
        """
        (string) Determine if all requests from port 80 should be redirected to port 443.
        """
        return pulumi.get(self, "redirect_http")

    @property
    @pulumi.getter(name="stickySessions")
    def sticky_sessions(self) -> bool:
        """
        (string) Determine if sticky sessions are enabled or not.
        """
        return pulumi.get(self, "sticky_sessions")


@pulumi.output_type
class GetLoadBalancerTargetResult(dict):
    def __init__(__self__, *,
                 label_selector: str,
                 server_id: int,
                 type: str):
        """
        :param str label_selector: (string) Label Selector to add a group of resources based on the label.
        :param int server_id: (int) ID of the server which should be a target for this Load Balancer.
        :param str type: (string) Type of the target. `server` or `label_selector`
        """
        pulumi.set(__self__, "label_selector", label_selector)
        pulumi.set(__self__, "server_id", server_id)
        pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter(name="labelSelector")
    def label_selector(self) -> str:
        """
        (string) Label Selector to add a group of resources based on the label.
        """
        return pulumi.get(self, "label_selector")

    @property
    @pulumi.getter(name="serverId")
    def server_id(self) -> int:
        """
        (int) ID of the server which should be a target for this Load Balancer.
        """
        return pulumi.get(self, "server_id")

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        (string) Type of the target. `server` or `label_selector`
        """
        return pulumi.get(self, "type")


@pulumi.output_type
class GetLoadBalancersLoadBalancerResult(dict):
    def __init__(__self__, *,
                 algorithms: Sequence['outputs.GetLoadBalancersLoadBalancerAlgorithmResult'],
                 delete_protection: bool,
                 id: int,
                 ipv4: str,
                 ipv6: str,
                 labels: Mapping[str, Any],
                 load_balancer_type: str,
                 location: str,
                 network_id: int,
                 network_ip: str,
                 network_zone: str,
                 services: Sequence['outputs.GetLoadBalancersLoadBalancerServiceResult'],
                 targets: Sequence['outputs.GetLoadBalancersLoadBalancerTargetResult'],
                 name: Optional[str] = None):
        pulumi.set(__self__, "algorithms", algorithms)
        pulumi.set(__self__, "delete_protection", delete_protection)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "ipv4", ipv4)
        pulumi.set(__self__, "ipv6", ipv6)
        pulumi.set(__self__, "labels", labels)
        pulumi.set(__self__, "load_balancer_type", load_balancer_type)
        pulumi.set(__self__, "location", location)
        pulumi.set(__self__, "network_id", network_id)
        pulumi.set(__self__, "network_ip", network_ip)
        pulumi.set(__self__, "network_zone", network_zone)
        pulumi.set(__self__, "services", services)
        pulumi.set(__self__, "targets", targets)
        if name is not None:
            pulumi.set(__self__, "name", name)

    @property
    @pulumi.getter
    def algorithms(self) -> Sequence['outputs.GetLoadBalancersLoadBalancerAlgorithmResult']:
        return pulumi.get(self, "algorithms")

    @property
    @pulumi.getter(name="deleteProtection")
    def delete_protection(self) -> bool:
        return pulumi.get(self, "delete_protection")

    @property
    @pulumi.getter
    def id(self) -> int:
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def ipv4(self) -> str:
        return pulumi.get(self, "ipv4")

    @property
    @pulumi.getter
    def ipv6(self) -> str:
        return pulumi.get(self, "ipv6")

    @property
    @pulumi.getter
    def labels(self) -> Mapping[str, Any]:
        return pulumi.get(self, "labels")

    @property
    @pulumi.getter(name="loadBalancerType")
    def load_balancer_type(self) -> str:
        return pulumi.get(self, "load_balancer_type")

    @property
    @pulumi.getter
    def location(self) -> str:
        return pulumi.get(self, "location")

    @property
    @pulumi.getter(name="networkId")
    def network_id(self) -> int:
        return pulumi.get(self, "network_id")

    @property
    @pulumi.getter(name="networkIp")
    def network_ip(self) -> str:
        return pulumi.get(self, "network_ip")

    @property
    @pulumi.getter(name="networkZone")
    def network_zone(self) -> str:
        return pulumi.get(self, "network_zone")

    @property
    @pulumi.getter
    def services(self) -> Sequence['outputs.GetLoadBalancersLoadBalancerServiceResult']:
        return pulumi.get(self, "services")

    @property
    @pulumi.getter
    def targets(self) -> Sequence['outputs.GetLoadBalancersLoadBalancerTargetResult']:
        return pulumi.get(self, "targets")

    @property
    @pulumi.getter
    def name(self) -> Optional[str]:
        return pulumi.get(self, "name")


@pulumi.output_type
class GetLoadBalancersLoadBalancerAlgorithmResult(dict):
    def __init__(__self__, *,
                 type: str):
        pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter
    def type(self) -> str:
        return pulumi.get(self, "type")


@pulumi.output_type
class GetLoadBalancersLoadBalancerServiceResult(dict):
    def __init__(__self__, *,
                 destination_port: int,
                 health_checks: Sequence['outputs.GetLoadBalancersLoadBalancerServiceHealthCheckResult'],
                 https: Sequence['outputs.GetLoadBalancersLoadBalancerServiceHttpResult'],
                 listen_port: int,
                 protocol: str,
                 proxyprotocol: bool):
        pulumi.set(__self__, "destination_port", destination_port)
        pulumi.set(__self__, "health_checks", health_checks)
        pulumi.set(__self__, "https", https)
        pulumi.set(__self__, "listen_port", listen_port)
        pulumi.set(__self__, "protocol", protocol)
        pulumi.set(__self__, "proxyprotocol", proxyprotocol)

    @property
    @pulumi.getter(name="destinationPort")
    def destination_port(self) -> int:
        return pulumi.get(self, "destination_port")

    @property
    @pulumi.getter(name="healthChecks")
    def health_checks(self) -> Sequence['outputs.GetLoadBalancersLoadBalancerServiceHealthCheckResult']:
        return pulumi.get(self, "health_checks")

    @property
    @pulumi.getter
    def https(self) -> Sequence['outputs.GetLoadBalancersLoadBalancerServiceHttpResult']:
        return pulumi.get(self, "https")

    @property
    @pulumi.getter(name="listenPort")
    def listen_port(self) -> int:
        return pulumi.get(self, "listen_port")

    @property
    @pulumi.getter
    def protocol(self) -> str:
        return pulumi.get(self, "protocol")

    @property
    @pulumi.getter
    def proxyprotocol(self) -> bool:
        return pulumi.get(self, "proxyprotocol")


@pulumi.output_type
class GetLoadBalancersLoadBalancerServiceHealthCheckResult(dict):
    def __init__(__self__, *,
                 https: Sequence['outputs.GetLoadBalancersLoadBalancerServiceHealthCheckHttpResult'],
                 interval: int,
                 port: int,
                 protocol: str,
                 retries: int,
                 timeout: int):
        pulumi.set(__self__, "https", https)
        pulumi.set(__self__, "interval", interval)
        pulumi.set(__self__, "port", port)
        pulumi.set(__self__, "protocol", protocol)
        pulumi.set(__self__, "retries", retries)
        pulumi.set(__self__, "timeout", timeout)

    @property
    @pulumi.getter
    def https(self) -> Sequence['outputs.GetLoadBalancersLoadBalancerServiceHealthCheckHttpResult']:
        return pulumi.get(self, "https")

    @property
    @pulumi.getter
    def interval(self) -> int:
        return pulumi.get(self, "interval")

    @property
    @pulumi.getter
    def port(self) -> int:
        return pulumi.get(self, "port")

    @property
    @pulumi.getter
    def protocol(self) -> str:
        return pulumi.get(self, "protocol")

    @property
    @pulumi.getter
    def retries(self) -> int:
        return pulumi.get(self, "retries")

    @property
    @pulumi.getter
    def timeout(self) -> int:
        return pulumi.get(self, "timeout")


@pulumi.output_type
class GetLoadBalancersLoadBalancerServiceHealthCheckHttpResult(dict):
    def __init__(__self__, *,
                 domain: str,
                 path: str,
                 response: str,
                 status_codes: Sequence[int],
                 tls: bool):
        pulumi.set(__self__, "domain", domain)
        pulumi.set(__self__, "path", path)
        pulumi.set(__self__, "response", response)
        pulumi.set(__self__, "status_codes", status_codes)
        pulumi.set(__self__, "tls", tls)

    @property
    @pulumi.getter
    def domain(self) -> str:
        return pulumi.get(self, "domain")

    @property
    @pulumi.getter
    def path(self) -> str:
        return pulumi.get(self, "path")

    @property
    @pulumi.getter
    def response(self) -> str:
        return pulumi.get(self, "response")

    @property
    @pulumi.getter(name="statusCodes")
    def status_codes(self) -> Sequence[int]:
        return pulumi.get(self, "status_codes")

    @property
    @pulumi.getter
    def tls(self) -> bool:
        return pulumi.get(self, "tls")


@pulumi.output_type
class GetLoadBalancersLoadBalancerServiceHttpResult(dict):
    def __init__(__self__, *,
                 certificates: Sequence[str],
                 cookie_lifetime: int,
                 cookie_name: str,
                 redirect_http: bool,
                 sticky_sessions: bool):
        pulumi.set(__self__, "certificates", certificates)
        pulumi.set(__self__, "cookie_lifetime", cookie_lifetime)
        pulumi.set(__self__, "cookie_name", cookie_name)
        pulumi.set(__self__, "redirect_http", redirect_http)
        pulumi.set(__self__, "sticky_sessions", sticky_sessions)

    @property
    @pulumi.getter
    def certificates(self) -> Sequence[str]:
        return pulumi.get(self, "certificates")

    @property
    @pulumi.getter(name="cookieLifetime")
    def cookie_lifetime(self) -> int:
        return pulumi.get(self, "cookie_lifetime")

    @property
    @pulumi.getter(name="cookieName")
    def cookie_name(self) -> str:
        return pulumi.get(self, "cookie_name")

    @property
    @pulumi.getter(name="redirectHttp")
    def redirect_http(self) -> bool:
        return pulumi.get(self, "redirect_http")

    @property
    @pulumi.getter(name="stickySessions")
    def sticky_sessions(self) -> bool:
        return pulumi.get(self, "sticky_sessions")


@pulumi.output_type
class GetLoadBalancersLoadBalancerTargetResult(dict):
    def __init__(__self__, *,
                 label_selector: str,
                 server_id: int,
                 type: str):
        pulumi.set(__self__, "label_selector", label_selector)
        pulumi.set(__self__, "server_id", server_id)
        pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter(name="labelSelector")
    def label_selector(self) -> str:
        return pulumi.get(self, "label_selector")

    @property
    @pulumi.getter(name="serverId")
    def server_id(self) -> int:
        return pulumi.get(self, "server_id")

    @property
    @pulumi.getter
    def type(self) -> str:
        return pulumi.get(self, "type")


@pulumi.output_type
class GetLocationsLocationResult(dict):
    def __init__(__self__, *,
                 city: str,
                 country: str,
                 description: str,
                 id: int,
                 latitude: float,
                 longitude: float,
                 name: str,
                 network_zone: str):
        pulumi.set(__self__, "city", city)
        pulumi.set(__self__, "country", country)
        pulumi.set(__self__, "description", description)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "latitude", latitude)
        pulumi.set(__self__, "longitude", longitude)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "network_zone", network_zone)

    @property
    @pulumi.getter
    def city(self) -> str:
        return pulumi.get(self, "city")

    @property
    @pulumi.getter
    def country(self) -> str:
        return pulumi.get(self, "country")

    @property
    @pulumi.getter
    def description(self) -> str:
        return pulumi.get(self, "description")

    @property
    @pulumi.getter
    def id(self) -> int:
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def latitude(self) -> float:
        return pulumi.get(self, "latitude")

    @property
    @pulumi.getter
    def longitude(self) -> float:
        return pulumi.get(self, "longitude")

    @property
    @pulumi.getter
    def name(self) -> str:
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="networkZone")
    def network_zone(self) -> str:
        return pulumi.get(self, "network_zone")


@pulumi.output_type
class GetNetworksNetworkResult(dict):
    def __init__(__self__, *,
                 delete_protection: bool,
                 expose_routes_to_vswitch: bool,
                 id: int,
                 ip_range: str,
                 labels: Mapping[str, Any],
                 name: str):
        """
        :param bool expose_routes_to_vswitch: Indicates if the routes from this network should be exposed to the vSwitch connection. The exposing only takes effect if a vSwitch connection is active.
        """
        pulumi.set(__self__, "delete_protection", delete_protection)
        pulumi.set(__self__, "expose_routes_to_vswitch", expose_routes_to_vswitch)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "ip_range", ip_range)
        pulumi.set(__self__, "labels", labels)
        pulumi.set(__self__, "name", name)

    @property
    @pulumi.getter(name="deleteProtection")
    def delete_protection(self) -> bool:
        return pulumi.get(self, "delete_protection")

    @property
    @pulumi.getter(name="exposeRoutesToVswitch")
    def expose_routes_to_vswitch(self) -> bool:
        """
        Indicates if the routes from this network should be exposed to the vSwitch connection. The exposing only takes effect if a vSwitch connection is active.
        """
        return pulumi.get(self, "expose_routes_to_vswitch")

    @property
    @pulumi.getter
    def id(self) -> int:
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="ipRange")
    def ip_range(self) -> str:
        return pulumi.get(self, "ip_range")

    @property
    @pulumi.getter
    def labels(self) -> Mapping[str, Any]:
        return pulumi.get(self, "labels")

    @property
    @pulumi.getter
    def name(self) -> str:
        return pulumi.get(self, "name")


@pulumi.output_type
class GetPlacementGroupsPlacementGroupResult(dict):
    def __init__(__self__, *,
                 id: int,
                 labels: Mapping[str, Any],
                 name: str,
                 servers: Sequence[int],
                 type: str):
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "labels", labels)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "servers", servers)
        pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter
    def id(self) -> int:
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def labels(self) -> Mapping[str, Any]:
        return pulumi.get(self, "labels")

    @property
    @pulumi.getter
    def name(self) -> str:
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def servers(self) -> Sequence[int]:
        return pulumi.get(self, "servers")

    @property
    @pulumi.getter
    def type(self) -> str:
        return pulumi.get(self, "type")


@pulumi.output_type
class GetPrimaryIpsPrimaryIpResult(dict):
    def __init__(__self__, *,
                 assignee_id: int,
                 assignee_type: str,
                 auto_delete: bool,
                 datacenter: str,
                 delete_protection: bool,
                 id: int,
                 ip_address: str,
                 ip_network: str,
                 labels: Mapping[str, Any],
                 type: str,
                 name: Optional[str] = None):
        pulumi.set(__self__, "assignee_id", assignee_id)
        pulumi.set(__self__, "assignee_type", assignee_type)
        pulumi.set(__self__, "auto_delete", auto_delete)
        pulumi.set(__self__, "datacenter", datacenter)
        pulumi.set(__self__, "delete_protection", delete_protection)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "ip_address", ip_address)
        pulumi.set(__self__, "ip_network", ip_network)
        pulumi.set(__self__, "labels", labels)
        pulumi.set(__self__, "type", type)
        if name is not None:
            pulumi.set(__self__, "name", name)

    @property
    @pulumi.getter(name="assigneeId")
    def assignee_id(self) -> int:
        return pulumi.get(self, "assignee_id")

    @property
    @pulumi.getter(name="assigneeType")
    def assignee_type(self) -> str:
        return pulumi.get(self, "assignee_type")

    @property
    @pulumi.getter(name="autoDelete")
    def auto_delete(self) -> bool:
        return pulumi.get(self, "auto_delete")

    @property
    @pulumi.getter
    def datacenter(self) -> str:
        return pulumi.get(self, "datacenter")

    @property
    @pulumi.getter(name="deleteProtection")
    def delete_protection(self) -> bool:
        return pulumi.get(self, "delete_protection")

    @property
    @pulumi.getter
    def id(self) -> int:
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="ipAddress")
    def ip_address(self) -> str:
        return pulumi.get(self, "ip_address")

    @property
    @pulumi.getter(name="ipNetwork")
    def ip_network(self) -> str:
        return pulumi.get(self, "ip_network")

    @property
    @pulumi.getter
    def labels(self) -> Mapping[str, Any]:
        return pulumi.get(self, "labels")

    @property
    @pulumi.getter
    def type(self) -> str:
        return pulumi.get(self, "type")

    @property
    @pulumi.getter
    def name(self) -> Optional[str]:
        return pulumi.get(self, "name")


@pulumi.output_type
class GetServerTypesServerTypeResult(dict):
    def __init__(__self__, *,
                 architecture: str,
                 cores: int,
                 cpu_type: str,
                 deprecation_announced: str,
                 description: str,
                 disk: int,
                 id: int,
                 included_traffic: int,
                 is_deprecated: bool,
                 memory: int,
                 name: str,
                 storage_type: str,
                 unavailable_after: str):
        pulumi.set(__self__, "architecture", architecture)
        pulumi.set(__self__, "cores", cores)
        pulumi.set(__self__, "cpu_type", cpu_type)
        pulumi.set(__self__, "deprecation_announced", deprecation_announced)
        pulumi.set(__self__, "description", description)
        pulumi.set(__self__, "disk", disk)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "included_traffic", included_traffic)
        pulumi.set(__self__, "is_deprecated", is_deprecated)
        pulumi.set(__self__, "memory", memory)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "storage_type", storage_type)
        pulumi.set(__self__, "unavailable_after", unavailable_after)

    @property
    @pulumi.getter
    def architecture(self) -> str:
        return pulumi.get(self, "architecture")

    @property
    @pulumi.getter
    def cores(self) -> int:
        return pulumi.get(self, "cores")

    @property
    @pulumi.getter(name="cpuType")
    def cpu_type(self) -> str:
        return pulumi.get(self, "cpu_type")

    @property
    @pulumi.getter(name="deprecationAnnounced")
    def deprecation_announced(self) -> str:
        return pulumi.get(self, "deprecation_announced")

    @property
    @pulumi.getter
    def description(self) -> str:
        return pulumi.get(self, "description")

    @property
    @pulumi.getter
    def disk(self) -> int:
        return pulumi.get(self, "disk")

    @property
    @pulumi.getter
    def id(self) -> int:
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="includedTraffic")
    def included_traffic(self) -> int:
        return pulumi.get(self, "included_traffic")

    @property
    @pulumi.getter(name="isDeprecated")
    def is_deprecated(self) -> bool:
        return pulumi.get(self, "is_deprecated")

    @property
    @pulumi.getter
    def memory(self) -> int:
        return pulumi.get(self, "memory")

    @property
    @pulumi.getter
    def name(self) -> str:
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="storageType")
    def storage_type(self) -> str:
        return pulumi.get(self, "storage_type")

    @property
    @pulumi.getter(name="unavailableAfter")
    def unavailable_after(self) -> str:
        return pulumi.get(self, "unavailable_after")


@pulumi.output_type
class GetServersServerResult(dict):
    def __init__(__self__, *,
                 backup_window: str,
                 backups: bool,
                 datacenter: str,
                 delete_protection: bool,
                 firewall_ids: Sequence[int],
                 id: int,
                 image: str,
                 ipv4_address: str,
                 ipv6_address: str,
                 ipv6_network: str,
                 iso: str,
                 labels: Mapping[str, Any],
                 location: str,
                 name: str,
                 primary_disk_size: int,
                 rebuild_protection: bool,
                 rescue: str,
                 server_type: str,
                 status: str,
                 placement_group_id: Optional[int] = None):
        pulumi.set(__self__, "backup_window", backup_window)
        pulumi.set(__self__, "backups", backups)
        pulumi.set(__self__, "datacenter", datacenter)
        pulumi.set(__self__, "delete_protection", delete_protection)
        pulumi.set(__self__, "firewall_ids", firewall_ids)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "image", image)
        pulumi.set(__self__, "ipv4_address", ipv4_address)
        pulumi.set(__self__, "ipv6_address", ipv6_address)
        pulumi.set(__self__, "ipv6_network", ipv6_network)
        pulumi.set(__self__, "iso", iso)
        pulumi.set(__self__, "labels", labels)
        pulumi.set(__self__, "location", location)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "primary_disk_size", primary_disk_size)
        pulumi.set(__self__, "rebuild_protection", rebuild_protection)
        pulumi.set(__self__, "rescue", rescue)
        pulumi.set(__self__, "server_type", server_type)
        pulumi.set(__self__, "status", status)
        if placement_group_id is not None:
            pulumi.set(__self__, "placement_group_id", placement_group_id)

    @property
    @pulumi.getter(name="backupWindow")
    def backup_window(self) -> str:
        return pulumi.get(self, "backup_window")

    @property
    @pulumi.getter
    def backups(self) -> bool:
        return pulumi.get(self, "backups")

    @property
    @pulumi.getter
    def datacenter(self) -> str:
        return pulumi.get(self, "datacenter")

    @property
    @pulumi.getter(name="deleteProtection")
    def delete_protection(self) -> bool:
        return pulumi.get(self, "delete_protection")

    @property
    @pulumi.getter(name="firewallIds")
    def firewall_ids(self) -> Sequence[int]:
        return pulumi.get(self, "firewall_ids")

    @property
    @pulumi.getter
    def id(self) -> int:
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def image(self) -> str:
        return pulumi.get(self, "image")

    @property
    @pulumi.getter(name="ipv4Address")
    def ipv4_address(self) -> str:
        return pulumi.get(self, "ipv4_address")

    @property
    @pulumi.getter(name="ipv6Address")
    def ipv6_address(self) -> str:
        return pulumi.get(self, "ipv6_address")

    @property
    @pulumi.getter(name="ipv6Network")
    def ipv6_network(self) -> str:
        return pulumi.get(self, "ipv6_network")

    @property
    @pulumi.getter
    def iso(self) -> str:
        return pulumi.get(self, "iso")

    @property
    @pulumi.getter
    def labels(self) -> Mapping[str, Any]:
        return pulumi.get(self, "labels")

    @property
    @pulumi.getter
    def location(self) -> str:
        return pulumi.get(self, "location")

    @property
    @pulumi.getter
    def name(self) -> str:
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="primaryDiskSize")
    def primary_disk_size(self) -> int:
        return pulumi.get(self, "primary_disk_size")

    @property
    @pulumi.getter(name="rebuildProtection")
    def rebuild_protection(self) -> bool:
        return pulumi.get(self, "rebuild_protection")

    @property
    @pulumi.getter
    def rescue(self) -> str:
        return pulumi.get(self, "rescue")

    @property
    @pulumi.getter(name="serverType")
    def server_type(self) -> str:
        return pulumi.get(self, "server_type")

    @property
    @pulumi.getter
    def status(self) -> str:
        return pulumi.get(self, "status")

    @property
    @pulumi.getter(name="placementGroupId")
    def placement_group_id(self) -> Optional[int]:
        return pulumi.get(self, "placement_group_id")


@pulumi.output_type
class GetSshKeysSshKeyResult(dict):
    def __init__(__self__, *,
                 fingerprint: str,
                 id: int,
                 labels: Mapping[str, str],
                 name: str,
                 public_key: str):
        """
        :param str fingerprint: Fingerprint of the SSH key.
        :param int id: ID of the SSH key.
        :param Mapping[str, str] labels: User-defined [labels](https://docs.hetzner.cloud/#labels) (key-value pairs) for the resource.
        :param str name: Name of the SSH key.
        :param str public_key: Public key of the SSH key pair.
        """
        pulumi.set(__self__, "fingerprint", fingerprint)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "labels", labels)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "public_key", public_key)

    @property
    @pulumi.getter
    def fingerprint(self) -> str:
        """
        Fingerprint of the SSH key.
        """
        return pulumi.get(self, "fingerprint")

    @property
    @pulumi.getter
    def id(self) -> int:
        """
        ID of the SSH key.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def labels(self) -> Mapping[str, str]:
        """
        User-defined [labels](https://docs.hetzner.cloud/#labels) (key-value pairs) for the resource.
        """
        return pulumi.get(self, "labels")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        Name of the SSH key.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="publicKey")
    def public_key(self) -> str:
        """
        Public key of the SSH key pair.
        """
        return pulumi.get(self, "public_key")


@pulumi.output_type
class GetVolumesVolumeResult(dict):
    def __init__(__self__, *,
                 delete_protection: bool,
                 id: int,
                 labels: Mapping[str, Any],
                 linux_device: str,
                 name: str,
                 size: int,
                 location: Optional[str] = None,
                 server_id: Optional[int] = None):
        pulumi.set(__self__, "delete_protection", delete_protection)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "labels", labels)
        pulumi.set(__self__, "linux_device", linux_device)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "size", size)
        if location is not None:
            pulumi.set(__self__, "location", location)
        if server_id is not None:
            pulumi.set(__self__, "server_id", server_id)

    @property
    @pulumi.getter(name="deleteProtection")
    def delete_protection(self) -> bool:
        return pulumi.get(self, "delete_protection")

    @property
    @pulumi.getter
    def id(self) -> int:
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def labels(self) -> Mapping[str, Any]:
        return pulumi.get(self, "labels")

    @property
    @pulumi.getter(name="linuxDevice")
    def linux_device(self) -> str:
        return pulumi.get(self, "linux_device")

    @property
    @pulumi.getter
    def name(self) -> str:
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def size(self) -> int:
        return pulumi.get(self, "size")

    @property
    @pulumi.getter
    def location(self) -> Optional[str]:
        return pulumi.get(self, "location")

    @property
    @pulumi.getter(name="serverId")
    def server_id(self) -> Optional[int]:
        return pulumi.get(self, "server_id")


