import { RemovalPolicy, TagManager } from "aws-cdk-lib";
import * as ssm from "aws-cdk-lib/aws-ssm";
import { IStringParameter } from "aws-cdk-lib/aws-ssm";
import { Construct } from "constructs";
import { ParameterBase, ParameterOptions } from "./parameter-base";
/**
 * Properties needed to create a String SSM parameter.
 */
export interface StringParameterProps extends ParameterOptions {
    /**
     * The name of the parameter.
     *
     * It may not be a
     *
     * @default - a name will be generated by CloudFormation
     * @stability stable
     */
    readonly parameterName: string;
    /**
     * The region to create the parameter in. See AWS.SSM.region for more information.
     */
    readonly region: string;
    /**
     * The value of the parameter.
     *
     * It may not reference another parameter and ``{{}}`` cannot be used in the value.
     */
    readonly stringValue: string;
    /**
     * The data type of the parameter, such as `text` or `aws:ec2:image`.
     *
     * @default - undefined
     */
    readonly dataType?: ssm.ParameterDataType;
    /**
     * Whether to retain or delete the parameter on CloudFormation delete event.
     *
     * @default - DESTROY
     */
    readonly removalPolicy?: RemovalPolicy;
}
export interface StringParameterAttributes extends ssm.StringParameterAttributes {
    /**
     * The region to retrieve the parameter from. See AWS.SSM.region for more information.
     */
    readonly region: string;
}
export declare class StringParameter extends ParameterBase implements ssm.IStringParameter {
    /**
     * Imports an external string parameter with name and optional version.
     */
    static fromStringParameterAttributes(scope: Construct, id: string, attrs: StringParameterAttributes): ssm.IStringParameter;
    /**
     * Imports an external string parameter by name and region.
     */
    static fromStringParameterName(scope: Construct, id: string, region: string, parameterName: string): IStringParameter;
    /**
     * Reads the value of an SSM parameter during synthesis through an
     * environmental context provider.
     *
     * Requires that the stack this scope is defined in will have explicit
     * account information. Otherwise, it will fail during synthesis.
     */
    static valueFromLookup(scope: Construct, region: string, parameterName: string): string;
    readonly parameterArn: string;
    readonly parameterName: string;
    readonly parameterType: string;
    readonly stringValue: string;
    readonly tags: TagManager;
    constructor(scope: Construct, id: string, props: StringParameterProps);
}
