"""An example custom dataset."""

from euroeval import TEXT_CLASSIFICATION, DatasetConfig
from euroeval.languages import DANISH
from euroeval.tasks import LA

COOL_CONFIG = DatasetConfig(
    name="cool",
    source=dict(train="cool_train.csv", val="cool_val.csv", test="cool_test.csv"),
    task=TEXT_CLASSIFICATION,
    languages=[DANISH],
    _labels=["cool", "not_cool"],
)

SCALA_DA_WITH_MANY_FEWSHOTS_CONFIG = DatasetConfig(
    name="scala-da-many-shot",
    source="EuroEval/scala-da",
    task=LA,
    languages=[DANISH],
    _num_few_shot_examples=30,  # Default is 12
)
