# 🇺🇦 Ukrainian

This is an overview of all the datasets used in the Ukrainian part of EuroEval. The
datasets are grouped by their task - see the [task overview](/tasks) for more
information about what these constitute.

## Sentiment Classification

### Cross-Domain UK Reviews

The dataset can be found [here](https://huggingface.co/datasets/vkovenko/cross_domain_uk_reviews).
The data is scrapped from [Tripadvisor](https://www.tripadvisor.com/) and [Rozetka](https://rozetka.com.ua/).

The [original dataset](https://huggingface.co/datasets/vkovenko/cross_domain_uk_reviews/blob/main/processed_data.csv)
contains 611,863 samples. We use 1,024 / 256 / 2,048 samples for our training,
validation and test splits, respectively.

Here are a few examples from the training split:

```json
{
    "text": "як і всі Mc Donalds, якість дуже низька, але рахунок високий за те, що ви їсте. . шкода, але не доходить до достатності",
    "label": "negative"
}
```

```json
{
    "text": "Посудомийною машиною користуюсь давно, роботою цілком заоволена. Працює дуже тихо і прекрасно справляється з забрудненим посудом. Вміщає в себе 12 комплектів посуду.",
    "label": "positive"
}
```

```json
{
    "text": "Зупинилися в готелі в липні 2021 року з сім'єю ( 4 людини ) , номер був обраний за категоріями люкс . У номері просторо і чисто . При бронюванні вони попросили викласти диван , що і було зроблено . У ванній кімнаті були всі витратні матеріали та рушники , в достатній кількості . У номері є невеликий холодильник , сейф . Але розчарований СНІДАНОК . Оголошений сніданок шведський стіл був , але це було повне розчарування . Вибачте , але можна зробити більш різноманітним і корисним , без майонезу на овочах ? ? . мухи літали і було неприємно перебувати в приміщенні .",
    "label": "neutral"
}
```

When evaluating generative models, we use the following setup (see the
[methodology](/methodology) for more information on how these are used):

- Number of few-shot examples: 12
- Prefix prompt:

  ```text
  Нижче наведені документи і їх настрій, який може бути 'позитивний', 'нейтральний' або 'негативний'.
  ```

- Base prompt template:

  ```text
  Документ: {text}
  Настрій: {label}
  ```

- Instruction-tuned prompt template:

  ```text
  Документ: {text}

  Класифікуйте настрій у документі. Відповідайте 'позитивний', 'нейтральний', або 'негативний', і нічого більше.
  ```

- Label mapping:
  - `positive` ➡️ `позитивний`
  - `neutral` ➡️ `нейтральний`
  - `negative` ➡️ `негативний`

You can evaluate this dataset directly as follows:

```bash
euroeval --model <model-id> --dataset cross-domain-uk-reviews
```

## Named Entity Recognition

### NER-uk

The dataset can be found [here](https://github.com/lang-uk/ner-uk).
The dataset primarily consists of text from the
[Open Corpus of Ukrainian Texts](https://github.com/brown-uk/corpus).

The original dataset consists of 10,833 / 668 / 1,307 samples for the
training, validation, and test splits, respectively. We use 1,024 / 256 / 2,048
samples for our training, validation and test splits, respectively. The train and
validation splits are subsets of the original splits, while the test split is
created using additional samples from the train split.

Here are a few examples from the training split:

```json
{
  "tokens": ["Хоча", "непросто", "про", "неї", "розповісти", "»", ".", "Ведмідь", "замовк", ",", "подивився", "на", "друзів", ",", "які", "уважно", "його", "слухали", ",", "і", "запитав", ":"],
  "labels": ["O", "O", "O", "O", "O", "O", "O", "B-PER", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O"]
}
```

```json
{
  "tokens": ["Експериментальний", "матеріал", "було", "оброблено", "статистично", ".", "Метою", "запропонованої", "статті", "є", "аналіз", "структурно-змістових", "особливостей", "перетворень", "у", "районній", "пресі", "Тернопільщини", "означеного", "періоду", "."],
  "labels": ["O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "B-LOC", "O", "O", "O"]
}
```

```json
{
  "tokens": ["Як", "відомо", ",", "рішення", "«", "Про", "вихід", "зі", "складу", "засновників", "редакції", "газети", "«", "Житомирщина", "»", "з", "ініціативи", "голови", "обласної", "ради", "було", "прийнято", "на", "другій", "сесії", "обласної", "ради", "24", "грудня", "минулого", "року", "—", "саме", "того", "дня", ",", "коли", "Верховна", "Рада", "ухвалила", "в", "остаточній", "редакції", "Закон", "про", "реформування", "преси", "."],
  "labels": ["O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "B-ORG", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "O", "B-ORG", "I-ORG", "O", "O", "O", "O", "O", "O", "O", "O", "O"]
}
```

When evaluating generative models, we use the following setup (see the
[methodology](/methodology) for more information on how these are used):

- Number of few-shot examples: 8
- Prefix prompt:

  ```text
  Нижче наведені речення та JSON-словники з іменованими сутностями, які присутні у даному реченні.
  ```

- Base prompt template:

  ```text
  Речення: {text}
  Іменовані сутності: {label}
  ```

- Instruction-tuned prompt template:

  ```text
  Речення: {text}

  Ідентифікуйте іменовані сутності у реченні. Ви повинні вивести це як JSON-словник з ключами 'особа', 'місце', 'організація' та 'різне'. Значення мають бути списками іменованих сутностей цього типу, точно такими, як вони з'являються у реченні.
  ```

- Label mapping:
  - `B-PER` ➡️ `особа`
  - `I-PER` ➡️ `особа`
  - `B-LOC` ➡️ `місце`
  - `I-LOC` ➡️ `місце`
  - `B-ORG` ➡️ `організація`
  - `I-ORG` ➡️ `організація`
  - `B-MISC` ➡️ `різне`
  - `I-MISC` ➡️ `різне`

You can evaluate this dataset directly as follows:

```bash
euroeval --model <model-id> --dataset ner-uk
```

## Linguistic Acceptability

### ScaLA-uk

This dataset was published in [this paper](https://aclanthology.org/2023.nodalida-1.20/)
and was automatically created from the [Ukrainian Universal Dependencies
treebank](https://github.com/UniversalDependencies/UD_Ukrainian-ParlaMint) by assuming that
the documents in the treebank are correct, and corrupting the samples to create
grammatically incorrect samples. The corruptions were done by either removing a word
from a sentence, or by swapping two neighbouring words in a sentence. To ensure that
this does indeed break the grammaticality of the sentence, a set of rules were used on
the part-of-speech tags of the words in the sentence.

The original full dataset consists of 1,024 / 256 / 2,048 samples for training,
validation and testing, respectively (so 3,328 samples used in total). These splits are
used as-is in the framework.

Here are a few examples from the training split:

```json
{
  "text": "Під патронатом Президента України в цьому році проведено ІІ Всеукраїнські літні спортивні ігри, які стали важливим етапом у підготовці до кваліфікаційних змагань по відбору до Літньої олімпіади в Афінах, сприяли зміцненню фізкультурно-спортивного руху, охопивши всі верстви населення.",
  "label": "correct"
}
```

```json
{
  "text": "І прошу, давайте подякуємо за допомогу нашим білоруським сусідам.",
  "label": "correct"
}
```

```json
{
  "text": "Шановні колеги, тепер переходимо до наступного.",
  "label": "incorrect"
}
```

When evaluating generative models, we use the following setup (see the
[methodology](/methodology) for more information on how these are used):

- Number of few-shot examples: 12
- Prefix prompt:

  ```text
  Нижче наведені речення і їхня граматична правильність.
  ```

- Base prompt template:

  ```text
  Речення: {text}
  Граматично правильно: {label}
  ```

- Instruction-tuned prompt template:

  ```text
  Речення: {text}

  Визначте, чи речення граматично правильне чи ні. Відповідайте 'так', якщо речення правильне, і 'ні', якщо ні. Відповідайте лише цим словом, і нічим більше.
  ```

- Label mapping:
  - `correct` ➡️ `так`
  - `incorrect` ➡️ `ні`

You can evaluate this dataset directly as follows:

```bash
euroeval --model <model-id> --dataset scala-uk
```

## Reading Comprehension

### MultiWikiQA-uk

This dataset was published in [this paper](https://doi.org/10.48550/arXiv.2509.04111)
and contains Wikipedia articles with LLM-generated questions and answers in 300+
languages.

The original full dataset consists of 5,000 samples in a single split. We use a 1,024 /
256 / 2,048 split for training, validation and testing, respectively, sampled randomly.

Here are a few examples from the training split:

```json
{
  "context": "Thalassema thalassema\xa0— вид ехіур родини Thalassematidae.\n\nПоширення \nВид поширений у припливній зоні вздовж європейського узбережжя Атлантичного океану та Середземного моря.\n\nОпис \nЧерв'як завдовжки 2-7\xa0см. На передньому кінці тіла розташований червоний м'язистий хоботок, який може розтягуватись на 10-20\xa0см у довжину. Рот знаходиться біля основи хоботка. Забарвлення тіла може бути різноманітним\xa0— синє, сіре, жовте, помаранчеве, рожеве. На передньому кінці тіла дві черевці щетинки, на задньому кінці вони відсутні.\n\nСпосіб життя \nМешкає у піску та мулі припливної зони. Живиться детритом та мікроорганізмами. Активний вночі.\n\nРозмноження \nСтатевий диморфізм відсутній. Запліднення зовнішнє. Плаваюча личинка трохофора живе деякий час як зоопланктон, потім осідає на дно і перетворюється на черв'яка.\n\nПосилання \n Lexikon der Biologie: Thalassema\n Saskiya Richards: A spoon worm (Thalassema thalassema)  MarLIN, The Marine Life Information Network, 2009.\n\nЕхіури\nКільчасті черви Атлантичного океану\nФауна Середземного моря\nТварини, описані 1774",
  "question": "Яка кількість черевних щетинок розташована на передній частині тіла Thalassema thalassema?",
  "answers": {
    "answer_start": [466],
    "text": ["дві"]
    }
}
```

```json
{
  "context": "Сезон 2007–08 в Серії A\xa0— футбольне змагання у найвищому дивізіоні чемпіонату Італії, що проходило між 26 серпня 2007 та 18 травня 2008 року. Став 76-м турніром з моменту заснування Серії A. Участь у змаганні брали 20 команд, у тому числі 3 команди, які попереднього сезону підвищилися у класі з Серії B. За результатами сезону 17 команд продовжили виступи в елітному дивізіоні, а три найгірших клуби вибули до Серії B.\n\nПереможцем турніру став міланський «Інтернаціонале», який здобув свій третій поспіль та 16-й в історії чемпіонський титул. Майбутні чемпіони захопили одноосібне лідерство у 6 турі турніру, після чого вже не залишали першого рядка турнірної таблиці. Хоча посеред змагання відрив основного переслідувача, «Роми», від лідера сягав 11 очок, перед останнім туром команди розділяв лише один заліковий пункт. «Інтер» забезпечив перемогу в сезоні, здолавши в цьому останньому турі одного з аутсайдерів сезону, «Парму», з рахунком 2:0.\n\nКоманди \n\nУчасть у турнірі Серії A сезону 2007–08 брали 20 команд:\n\nТурнірна таблиця\n\nРезультати\n\nБомбардири \nЗа результатами сезону таблицю найкращих бомбардирів Серії А очолила пара нападників туринського «Ювентуса»\xa0— Алессандро Дель П'єро та Давід Трезеге, які забили відповідно 21 та 20 голів в матчах турніру.\n\nПовний перелік гравців, що забили принаймні 10 голів в рамках Серії A сезону 2007—08:\n\n 21 гол\n  Алессандро Дель П'єро («Ювентус»)\n 20 голів\n  Давід Трезеге («Ювентус»)\n 19 голів\n  Марко Боррієлло («Дженоа»)\n 17 голів\n  Антоніо Ді Натале («Удінезе»)\n  Златан Ібрагімович («Інтернаціонале»)\n  Адріан Муту («Фіорентина»)\n 15 голів\n  Амаурі («Палермо»)\n  Кака («Мілан»)\n 14 голів\n  Горан Пандев («Лаціо»)\n  Томмазо Роккі («Лаціо»)\n  Франческо Тотті («Рома»)\n 13 голів\n  Хуліо Рікардо Крус («Інтернаціонале»)\n  Массімо Маккароне («Сієна»)\n 12 голів\n  Нікола Аморузо («Реджина»)\n  Клаудіо Белуччі («Сампдорія»)\n  Крістіано Доні («Аталанта»)\n  Фабіо Квальярелла («Удінезе»)\n 11 голів\n  Філіппо Індзагі («Мілан»)\n 10 голів\n  Роберт Аквафреска («Кальярі»)\n  Антоніо Кассано («Сампдорія»)\n  Франческо Тавано («Ліворно»)\n\nАльберто Джилардіно, Давід Трезеге і Нікола Аморузо забили по сто м'ячів у матчах Серії «А». По завершенні сезону, до десятки найвлучніших голеадорів ліги входять: Сільвіо Піола (275), Гуннар Нордаль (225), Джузеппе Меацца (216), Жозе Алтафіні (216), Роберто Баджо (205), Курт Хамрін (190), Джузеппе Сіньйорі (188), Габрієль Батістута (184), Джамп'єро Боніперті (178), Амедео Амадеї (174).\n\nПосилання \n Серія A 2007–08 на RSSSF  \n\n2007-2008\n2007 у футболі\n2008 у футболі\n2007 в італійському спорті\n2008 в італійському спорті", "question": "Яка кількість голів була забита Алессандро Дель П'єро протягом сезону Серії А 2007–2008 років?",
  "answers": {
    "answer_start": [1353],
    "text": ['21 гол']
    }
}
```

```json
{
  "context": "Тім Смолдерс (,  26 серпня 1980, Гел)\xa0— бельгійський футболіст, що грав на позиції півзахисника. По завершенні ігрової кар'єри\xa0— тренер.\n\nІгрова кар'єра \nУ дорослому футболі дебютував 1998 року виступами за команду «Брюгге», в якій провів шість сезонів, взявши участь у 63 матчах чемпіонату. За цей час виборов титул чемпіона Бельгії.\n\nЗгодом з 2004 по 2015 рік грав у складі нідерландського «Росендала», а також на батьківщині за «Шарлеруа», «Гент» та «Серкль».\n\nПротягом 2015—2018 років грав за нижчоліговий «Звевезеле».\n\nКар'єра тренера\nПерший досвід тренерської роботи отримав ще граючи на полі як помічник головного тренера «Серкля» у 2014—2015 роках.\n\nЗгодом входив до тренерських штабів юнацької збірної Бельгії (U-19) та молодіжної команди «Брюгге».\n\n2021 року очолив футбольну академію «Брюгге».\n\nТитули і досягнення\n Чемпіон Бельгії (1):\n«Брюгге»: 2002-2003\n Володар Кубка Бельгії (2):\n«Брюгге»: 2002, 2004\n Володар Суперкубка Бельгії (3):\n«Брюгге»: 1998, 2002, 2003\n\nПосилання \n\nбельгійські футболісти\nбельгійські футбольні тренери\nФутболісти «Брюгге»\nФутболісти «Росендала»\nФутболісти «Шарлеруа»\nФутболісти «Гента»\nФутболісти «Серкля»\nТренери ФК «Серкль»\nТренери юнацької збірної Бельгії з футболу\nТренери ФК «Брюгге»\nбельгійські футбольні легіонери\nФутбольні легіонери в Нідерландах",
  "question": "Де Смолдерс вперше спробував себе в ролі тренера?",
  "answers": {
    "answer_start": [629],
    "text": ["«Серкля»"]
    }
}
```

When evaluating generative models, we use the following setup (see the
[methodology](/methodology) for more information on how these are used):

- Number of few-shot examples: 4
- Prefix prompt:

  ```text
  Нижче наведені тексти з відповідними питаннями та відповідями.
  ```

- Base prompt template:

  ```text
  Текст: {text}
  Питання: {question}
  Відповідь максимум 3 словами:
  ```

- Instruction-tuned prompt template:

  ```text
  Текст: {text}

  Відповідь на наступне питання про вищезазначений текст максимум 3 словами.

  Питання: {question}
  ```

You can evaluate this dataset directly as follows:

```bash
euroeval --model <model-id> --dataset multi-wiki-qa-uk
```

## Knowledge

### Global-MMLU-uk

Global-MMLU is a machine translated version of the English [MMLU
dataset](https://openreview.net/forum?id=d7KBjmI3GmQ) and features questions within 57
different topics, such as elementary mathematics, US history and law. The translation to
Ukrainian was done by the [Cohere Labs Community](https://cohere.com/research).

The original full dataset consists of 285 / 14,042 samples for
validation and testing, respectively. We use a 1,024 / 256 / 2,048 split for training,
validation and testing, respectively (so 3,328 samples used in total).
The validation set is sampled from the dev set, and the new train and test
sets are sampled from the test set.

Here are a few examples from the training split:

```json
{
  "text": "Після того, як призначену одиницю продукту крові було отримано з банку крові та вилучено з холодильника, протягом якого періоду часу слід розпочати переливання, перш ніж він почне псуватися (за медичними даними 2020 року)?\nВаріанти:\na. 30 хвилин.\nb. 90 хвилин.\nc. 4 години.\nd. 12 годин.",
  "label": "a",
}
```

```json
{
  "text": "У якому з цих двох сценаріїв головний герой (який використовує I/me/my) робить щось явно морально неправильне відповідно до звичайних моральних стандартів у США станом на 2020 рік? Сценарій 1 | Я взяв 1 мільйон доларів у друзів. Сценарій 2 | Я подав на роботі свій табель із зазначенням точного робочого часу.\nВаріанти:\na. Неправильно, Неправильно\nb. Помилка, не помилка\nc. Не неправильно, неправильно\nd. Не помилився, не помилився",
  "label": "b",
}
```

```json
{
  "text": "Яку з наведених нижче процедур бухгалтер найменше виконає під час перевірки фінансової звітності неемітента?\nВаріанти:\na. Запитувати керівництво про дії, прийняті на засіданнях ради директорів.\nb. Вивчіть взаємозв’язки елементів фінансової звітності, які, як очікується, мають відповідати передбачуваним моделям.\nc. Визначте заходи внутрішнього контролю, які можуть запобігти або виявити суттєві викривлення.\nd. Порівняйте фінансові звіти з очікуваними результатами в бюджетах і прогнозах.",
  "label": "c",
}
```

When evaluating generative models, we use the following setup (see the
[methodology](/methodology) for more information on how these are used):

- Number of few-shot examples: 5
- Prefix prompt:

  ```text
  Нижче наведено питання з кількома варіантами відповідей (з відповідями).
  ```

- Base prompt template:

  ```text
  Питання: {text}
  Варіанти:
  a. {option_a}
  b. {option_b}
  c. {option_c}
  d. {option_d}
  Відповідь: {label}
  ```

- Instruction-tuned prompt template:

  ```text
  Питання: {text}

  Дайте відповідь на наведене вище питання, використовуючи 'a', 'b', 'c' або 'd', і нічого іншого.
  ```

You can evaluate this dataset directly as follows:

```bash
euroeval --model <model-id> --dataset global-mmlu-uk
```

## Common-sense Reasoning

### Winogrande-uk

This dataset was published in [this paper](https://doi.org/10.48550/arXiv.2506.19468)
and is a translated and filtered version of the English [Winogrande
dataset](https://doi.org/10.1145/3474381).

The original full dataset consists of 47 / 1,210 samples for training and testing, and
we use 128 of the test samples for validation, resulting in a 47 / 128 / 1,085 split for
training, validation and testing, respectively.

Here are a few examples from the training split:

```json
{
  "text": "Я не міг контролювати вологу так, як контролював дощ, тому що _ надходила звідусіль. До кого відноситься пропуск _?\nВаріанти:\na. волога\nb. дощ",
  "label": "a"
}
```

```json
{
  "text": "Джессіка вважала, що "Sandstorm" - найкраща пісня, яка коли-небудь була написана, але Патриція ненавиділа її. _ купила квиток на джазовий концерт. До кого відноситься пропуск _?\nВаріанти:\na. Джессіка\nb. Патриція",
  "label": "b"
}
```

```json
{
  "text": "Впоратися з надзвичайними ситуаціями Кевіну ніколи не було дуже важко, але Нельсону було важко, тому що _ не міг залишатися спокійним під тиском. До кого відноситься пропуск _?\nВаріанти:\na. Кевін\nb. Нельсон",
  "label": "b"
}
```

When evaluating generative models, we use the following setup (see the
[methodology](/methodology) for more information on how these are used):

- Number of few-shot examples: 5
- Prefix prompt:

  ```text
  Нижче наведено питання з кількома варіантами відповідей (з відповідями).
  ```

- Base prompt template:

  ```text
  Питання: {text}
  Варіанти:
  a. {option_a}
  b. {option_b}
  Відповідь: {label}
  ```

- Instruction-tuned prompt template:

  ```text
  Питання: {text}
  Варіанти:
  a. {option_a}
  b. {option_b}

  Дайте відповідь на наведене вище питання, використовуючи 'a' або 'b', і нічого іншого.
  ```

You can evaluate this dataset directly as follows:

```bash
euroeval --model <model-id> --dataset winogrande-uk
```

## Summarisation

### LR-Sum-uk

This dataset was published in [this paper](https://aclanthology.org/2023.findings-acl.427/).
The source data is public domain newswire collected from Voice of America websites,
and the summaries are human-written.

The original dataset contains 5,784 / 722 / 723 samples for the training, validation, and
and test splits, respectively. We use 1,024 / 256 / 2,048 samples for our training,
validation and test splits, respectively. The train and validation splits are subsets
of the original splits. For the test split, we use all available test samples and
supplement with additional samples from the training set to reach 2,048 samples in
total.

Here are a few examples from the training split:

```json
{
  "text": "У Єгипті склав присягу тимчасовий президент\n\nГолова Вищого конституційного суду Єгипту Адлі Мансур у четвер склав присягу як тимчасовий президент країни через день після усунення від влади військовими першого демократично обраного президента Єгипту Мухамеда Мурсі. Церемонія приведення до присяги 68-річного Мансура проходила в будівлі Конституційного суду і транслювалася по державному телебаченню в прямому ефірі. За рішенням військових, Мансур виконуватиме обов'язки тимчасового лідера Єгипту до обрання нового президента. При цьому дата виборів поки що не встановлена. Масові протести в Єгипті спалахнули у неділю і завершилися в середу затриманням Мурсі під військовою вартою. За повідомленням державних медіа, видано ордери на арешт 300 членів руху «Брати-мусульмани». Головнокомандувач збройних сил Єгипту Абдуль Фатах ас-Сісі виступив з промовою, в якій зазначив, що, у відповідь на заклики єгипетського народу, армія призупинила дію Конституції країни, яку було ухвалено несповна шість місяців тому. Сісі накреслив план дій стосовно майбутнього уряду, що включає приведення до присяги тимчасового президента, призначення комісії для розгляду Конституції і комітету з національного примирення та проведння нових президентських та парламентських виборів. Він зазначив, що план дій узгодили представники різних політичних сил Єгипту. Як Сісі, так і Мурсі закликали єгиптян до спокою. Мурсі назвав заходи військових «державним переворот» і закликав єгипетський народ дати відповідь на цей «переворот».",
  "target_text": "Адлі Мансур виконуватиме обов'язки глави держави до нових виборів, дата яких поки що не визначена."
}
```

```json
{
  "text": "Проросійські сепаратисти погодилися продовжити переговори\n\nПроросійські сепаратисти погодилися взяти участь у подальших мирних переговорах у п’ятницю, щоб вирішити конфлікт у східних регіонах України. Про це в четвер повідомило інформаційне агентство «Інтерфакс». «Є домовленість провести черговий раунд консультацій 27 червня в Донецьку», – цитує «Інтерфакс» заяву одного з лідерів самопроголошеної «Донецької народної республіки» Андрія Пургина. Раніше, виступаючи у французькому Страсбурзі, президент України Петро Порошенко заявив, що тільки що почув про готовність сепаратистів до нових переговорів з «контактною групою», куди входить колишній президент країни Леонід Кучма, посол Росії в Києві і високопоставлений представник ОБСЄ. Проте українські ЗМІ цитують заяву Порошенко, з якої випливає, що Київ не має наміру продовжувати режим припинення вогню, якщо його не задовольнять результати п’ятничних переговорів. «Це дуже важливий день: якщо наші умови щодо мирного плану не будуть прийняті, то ми приймемо дуже важливе рішення», – наводить слова президента онлайн-видання «Українська правда». Порошенко, який у четвер виступав у Раді Європи, а в п’ятницю має підписати історичну угоду про вільну торгівлю з Євросоюзом, запропонував сепаратистам амністію і безпечний виїзд з країни, якщо вони складуть зброю і припинять бойові дії. Він також пропонує розширити права російськомовного населення східних регіонів, а наступного тижня планує представити план децентралізації, покликаний надати регіонам більше контролю над своїми внутрішніми справами, в тому числі фінансовими. Тим часом канцлер Німеччини Анґела Меркель вдруге за два дні поспілкувалася з російським президентом Володимиром Путіним, щоб обговорити способи розв’язання кризи в Східній Україні. Як повідомляють у Кремлі, телефонна розмова відбулася «з ініціативи німецької сторони» і бла присвячена таким питанням, як контроль за «додержанням конфліктуючими сторонами режиму припинення вогню», налагодження регулярної роботи контактної групи і звільнення «насильно утримуваних осіб». Представник уряду Німеччини підтвердив, що бесіда відбулася, а її метою було знайти спосіб продовжити оголошений українською владою режим припинення вогню, термін якого закінчується в 10 годині ранку в п’ятницю.",
  "target_text": "Черговий раунд переговорів з лідерами сепаратистів пройде 27 червня в Донецьку."
}
```

```json
{
  "text": "В УПЦ (МП) проукраїнський розвиток на порядку денному – експерт \n\nМитрополит Володимир вів політику неузгоджену з пріоритетами патріарха Російської православної церкви Кирила. Він мав стиль керівництва, який дозволяв в Україні будувати зовсім іншу реальність, відмінну від церковного устрою, що панував у Москві, нагадує у коментарі Радіо Свобода релігієзнавець . Тим часом в УПЦ (МП) сподіваються, що прейдешній предстоятель церкви продовжить справу об’єднання українського православ’я, каже прес-секретар митрополита Володимира . «Ми поховаємо Блаженнішого, а потім священний Синод визначить дату, коли відбудеться собор єпископів Української православної церкви, який обере нового предстоятеля. Ми молимося, щоб Господь давав їм мудрість, і щоб церковний корабель так само як він йшов за Блаженнішого (це була ціла епоха – з 1992 року до 2014), продовжував свій шлях. І не тільки зберігав єдність, як це робив Блаженнішийй, а й була відновлена єдність українського православ’я», – зауважує у коментарі Радіо Свобода Коваленко. Утім, нині немає беззаперечної кандидатури на митрополичу кафедру, зауважує Андрій Юраш. За його словами, нині можливими залишаються три моделі обрання нового митрополита Київського. Не виключено, що Архієрейський собор обере кандидата, який представлятиме традиційну промосковську централізаційну позицію. «Багато підстав щодо перспективності саме такої кандидатури став останній Синод УПЦ, на якому було прийнято кілька показових постанов – рішення про усунення від активного церковного спілкування персоналій, які явно були проукраїнськи налаштовані: юриста Київської митрополії пана Волинця, позбавлення права керувати нагородним відділом митрополита Олександра Драбинка і позбавлення керівництва Ужгородською академією архімандрита Віктора Бедя», – каже релігієзнавець. Водночас, є ймовірність і того, що наступником митрополита Володимира стане поки що неусвідомлений у середовищі єпископату лідер, який об’єднає навколо себе більшість, що буде зорієнтована на діалог з УПЦ Київського патріархату та на створення нової церковної структури, що зможе об’єднати усі києвоцентричні сили українського православ’я, вважає Андрій Юраш. Позиція Архієрейського не тотожна позиції Синоду – релігієзнавець За словами експерта, очолити УПЦ (МП( може й людина, яка намагатиметься зберігати статус-кво. Тобто спробує продовжити на певний період стиль керівництва митрополита Володимира, який дозволяв співіснувати різним ідентичностям та ідеологічним виявам. Найближчим часом відбуватимуться відкриті та приховані переговори, які викристалізують групи ієрархів, що лобіюватимуть своїх кандидатів, зауважує Андрій Юраш. Але, переконує він, позиція Архієрейського собору не може бути тотожною позиції Синоду. «У Синоді 7 з 9 постійних членів – це представники найконсервативнішої і найстаршої генерації ієрархів, чия свідомість, ментальність, ідеологія сформувалися багато десятирічь тому, коли альтернативи московському центру не було. Натомість є абсолютна більшість ієрархів, які отримали світоглядні орієнтири в останні два десятиліття, в умовах незалежної України, які звикли до того, що у суспільстві існує плюралізм, що є незалежна Українська держава», – зазначає Юраш. Андрій Юраш запевняє, що модель проукраїнського розвитку поставлять на порядок денний, але водночас він висловлює сумнів, що така модель переможе. Експерт нагадує, що місцеблюстителем УПЦ (МП) є митрополит Ануфрій призначений саме Синодом. Відтак найбільш ймовірним та прийнятним для більшості ієрархів експерт вважає обрання митрополитом київським перехідної особи, яка би нічого радикально не змінювала.",
  "target_text": "Священний Синод визначить дату, коли відбудеться собор єпископів Української православної церкви."
}
```

When evaluating generative models, we use the following setup (see the
[methodology](/methodology) for more information on how these are used):

- Number of few-shot examples: 1
- Prefix prompt:

  ```text
  Нижче наведено документи з супровідними резюме.
  ```

- Base prompt template:

  ```text
  Документ: {text}
  Резюме: {target_text}
  ```

- Instruction-tuned prompt template:

  ```text
  Документ: {text}

  Напишіть резюме наведеного вище документа.
  ```

You can evaluate this dataset directly as follows:

```bash
euroeval --model <model-id> --dataset lr-sum-uk
```
