#!/usr/bin/env python

import os.path
import sys

from setuptools import setup

sys.path.insert(0, os.path.join(os.path.dirname(__file__), 'src'))

setup(
    version='0.1.1',
    url='https://github.com/nathforge/swanson',
    name='swanson',
    description='Django BDD test runner',
    long_description=open(os.path.join(os.path.dirname(__file__), 'README.rst')).read(),
    author='Nathan Reynolds',
    author_email='email@nreynolds.co.uk',
    packages=['swanson'],
    package_dir={'': 'src'},
    test_suite='tests',
    install_requires=[
        'gherkin-parser',
        'pydentifier',
        'six'
    ],
    tests_require=[
        'django'
    ],
    classifiers=[
        'Development Status :: 4 - Beta',
        'Intended Audience :: Developers',
        'Topic :: Software Development',
        'License :: OSI Approved :: MIT License',
        'Programming Language :: Python :: 2',
        'Programming Language :: Python :: 2.7',
        'Programming Language :: Python :: 3',
        'Programming Language :: Python :: 3.4',
    ]
)
