You have been tasked with reviewing a Python CLI for YouTrack. This CLI is written with the rich library, which has documentation [here](https://rich.readthedocs.io/en/stable/introduction.html).

The documentation for this CLI is [here](https://yt-cli.readthedocs.io/en/latest/).

Think hard and perform a comprehensive code review of this YouTrack Python CLI project, focusing on:

1. **Code Structure & Organization**
   - Project layout and module organization
   - Separation of concerns
   - Code readability and maintainability

2. **YouTrack API Usage**
   - Proper API endpoint usage according to YouTrack REST API docs
   - Error handling for API calls
   - Authentication and connection management
   - Custom field handling

3. **Rich Library Implementation**
   - Effective use of Rich components (tables, progress bars, console output)
   - Consistent styling and theming
   - Performance considerations for large outputs

4. **CLI Ergonomics & User Experience**
   - Command structure and argument parsing
   - Help text and documentation
   - Error messages and user feedback
   - Configuration management

5. **Testing with pytest**
   - Test coverage analysis
   - Test structure and organization
   - Mocking of YouTrack API calls
   - Integration vs unit test balance

6. **Code Quality**
   - Type hints usage
   - Error handling patterns
   - Logging implementation
   - Security considerations (API tokens, etc.)

7. **Documentation**
   - Code comments and docstrings
   - README and setup instructions
   - CLI help and usage examples

For each area, provide:
- Current state assessment
- Specific issues or concerns found
- Actionable recommendations for improvement
- Code examples where helpful
- Priority level (High/Medium/Low) for each recommendation

Please examine all Python files, configuration files, tests, and documentation in the project. Write your findings to the file scratch/review-{{date}}.md
