# Generated by Django 5.1.7 on 2025-03-18 20:45

from django.db import migrations, models


class Migration(migrations.Migration):

    dependencies = [
        ('sender_net', '0002_newslettercampaign_newsletterrecipient'),
    ]

    operations = [
        migrations.AlterModelOptions(
            name='newslettercampaign',
            options={'verbose_name': 'Newsletter Campaign', 'verbose_name_plural': 'Newsletter Campaigns'},
        ),
        migrations.AlterModelOptions(
            name='newsletterrecipient',
            options={'ordering': ['-created_at'], 'verbose_name': 'Newsletter Recipient', 'verbose_name_plural': 'Newsletter Recipients'},
        ),
        migrations.AlterModelOptions(
            name='sendernetsettings',
            options={'verbose_name': 'Sender.net Configuration', 'verbose_name_plural': 'Sender.net Configurations'},
        ),
        migrations.AddField(
            model_name='newslettercampaign',
            name='api_response',
            field=models.TextField(blank=True, help_text='Raw response from Sender.net API', verbose_name='API Response'),
        ),
        migrations.AddField(
            model_name='newslettercampaign',
            name='api_status',
            field=models.CharField(choices=[('draft', 'Draft'), ('pending', 'Pending'), ('published', 'Published'), ('error', 'Error')], default='draft', max_length=20, verbose_name='API Status'),
        ),
        migrations.AddField(
            model_name='newslettercampaign',
            name='sender_id',
            field=models.CharField(blank=True, help_text='Automatically set when campaign is created in Sender.net', max_length=255, verbose_name='Sender.net ID'),
        ),
        migrations.AlterField(
            model_name='newslettercampaign',
            name='body',
            field=models.TextField(default='<mjml><mj-body><mj-text>Your content here</mj-text></mj-body></mjml>', help_text='MJML email content (use MJML syntax)', verbose_name='MJML Content'),
        ),
        migrations.AlterField(
            model_name='newslettercampaign',
            name='list_id',
            field=models.CharField(blank=True, help_text='Override default list ID from settings', max_length=255, verbose_name='List ID'),
        ),
        migrations.AlterField(
            model_name='newslettercampaign',
            name='subject',
            field=models.CharField(help_text='Email subject line', max_length=255),
        ),
        migrations.AlterField(
            model_name='newsletterrecipient',
            name='created_at',
            field=models.DateTimeField(auto_now_add=True, verbose_name='Subscription Date'),
        ),
        migrations.AlterField(
            model_name='newsletterrecipient',
            name='email',
            field=models.EmailField(max_length=254, unique=True, verbose_name='Email Address'),
        ),
        migrations.AlterField(
            model_name='newsletterrecipient',
            name='first_name',
            field=models.CharField(blank=True, max_length=255, verbose_name='First Name'),
        ),
        migrations.AlterField(
            model_name='newsletterrecipient',
            name='last_name',
            field=models.CharField(blank=True, max_length=255, verbose_name='Last Name'),
        ),
        migrations.AlterField(
            model_name='sendernetsettings',
            name='api_key',
            field=models.CharField(help_text='Sender.net API key (get from Sender.net dashboard)', max_length=255, verbose_name='API Key'),
        ),
        migrations.AlterField(
            model_name='sendernetsettings',
            name='default_from_email',
            field=models.EmailField(help_text='Default sender email address', max_length=254, verbose_name='Default From Email'),
        ),
        migrations.AlterField(
            model_name='sendernetsettings',
            name='default_from_name',
            field=models.CharField(help_text='Default sender display name', max_length=255, verbose_name='Default From Name'),
        ),
        migrations.AlterField(
            model_name='sendernetsettings',
            name='default_list_id',
            field=models.CharField(help_text='Default contact list ID for new campaigns', max_length=255, verbose_name='Default List ID'),
        ),
        migrations.AddIndex(
            model_name='newsletterrecipient',
            index=models.Index(fields=['email'], name='sender_net__email_edb1b1_idx'),
        ),
        migrations.AddIndex(
            model_name='newsletterrecipient',
            index=models.Index(fields=['created_at'], name='sender_net__created_f66f6b_idx'),
        ),
    ]
