# Generated by Django 5.1.7 on 2025-03-18 21:24

from django.db import migrations, models


class Migration(migrations.Migration):

    dependencies = [
        ('sender_net', '0003_alter_newslettercampaign_options_and_more'),
    ]

    operations = [
        migrations.AlterModelOptions(
            name='newslettercampaign',
            options={'ordering': ['-first_published_at'], 'verbose_name': 'Newsletter Campaign', 'verbose_name_plural': 'Newsletter Campaigns'},
        ),
        migrations.RemoveField(
            model_name='newslettercampaign',
            name='list_id',
        ),
        migrations.RemoveField(
            model_name='sendernetsettings',
            name='default_list_id',
        ),
        migrations.AddField(
            model_name='newslettercampaign',
            name='group_id',
            field=models.CharField(blank=True, help_text='Override default group ID from settings', max_length=255, verbose_name='Group ID'),
        ),
        migrations.AddField(
            model_name='newslettercampaign',
            name='preheader_text',
            field=models.CharField(blank=True, help_text='Preview text displayed in email clients', max_length=150, verbose_name='Preheader Text'),
        ),
        migrations.AddField(
            model_name='newsletterrecipient',
            name='groups',
            field=models.JSONField(default=list, help_text='Array of group IDs this recipient belongs to', verbose_name='Sender.net Groups'),
        ),
        migrations.AddField(
            model_name='sendernetsettings',
            name='default_group_id',
            field=models.CharField(default='', help_text='Default group ID for new campaigns (Sender.net group ID)', max_length=255, verbose_name='Default Group ID'),
        ),
        migrations.AddField(
            model_name='sendernetsettings',
            name='reply_to_email',
            field=models.EmailField(default='noreply@example.com', help_text='Email for reply-to header', max_length=254, verbose_name='Reply-to Email'),
        ),
        migrations.AlterField(
            model_name='newslettercampaign',
            name='api_status',
            field=models.CharField(choices=[('draft', 'Draft'), ('scheduled', 'Scheduled'), ('sent', 'Sent'), ('error', 'Error')], default='draft', max_length=20, verbose_name='API Status'),
        ),
        migrations.AlterField(
            model_name='newslettercampaign',
            name='body',
            field=models.TextField(default='<mjml><mj-body><mj-text>Your content here</mj-text></mj-body></mjml>', help_text='HTML/MJML email content', verbose_name='Email Content'),
        ),
        migrations.AlterField(
            model_name='newslettercampaign',
            name='sender_id',
            field=models.CharField(blank=True, help_text='Automatically set when campaign is created in Sender.net', max_length=255, verbose_name='Sender.net Campaign ID'),
        ),
        migrations.AddIndex(
            model_name='newsletterrecipient',
            index=models.Index(fields=['groups'], name='sender_net__groups_2f799d_idx'),
        ),
    ]
