from crowdkit.aggregation.base_aggregator import BaseAggregator
from pandas.core.frame import DataFrame
from pandas.core.series import Series
from typing import Callable


class ClosestToAverage(BaseAggregator):
    """Majority Vote - chooses the correct label for which more performers voted
    Attributes:
        outputs_ (DataFrame): Tasks' most likely true labels
            A pandas.Series indexed by `task` such that `labels.loc[task]`
            is the tasks's most likely true label.

        scores_ (DataFrame): Tasks' true label probability distributions
            A pandas.DataFrame indexed by `task` such that `result.loc[task, label]`
            is the probability of `task`'s true label to be equal to `label`. Each
            probability is between 0 and 1, all task's probabilities should sum up to 1"""

    def __init__(self, distance: Callable[..., ..., float]) -> None:
        """Method generated by attrs for class ClosestToAverage."""
        ...

    def fit(self, data: DataFrame, skills: Series = None, true_embeddings: DataFrame = None) -> 'ClosestToAverage':
        """Args:
            data (DataFrame): Performers' outputs with their embeddings
                A pandas.DataFrame containing `task`, `performer`, `output` and `embedding` columns.
            skills (Series): Performers' skills
                A pandas.Series index by performers and holding corresponding performer's skill
            true_embeddings (DataFrame): Tasks' embeddings
                A pandas.DataFrame indexed by `task` with a single column `embedding`.
        Returns:
            ClosestToAverage: self"""
        ...

    def fit_predict(self, data: DataFrame, skills: Series = None) -> DataFrame:
        """Args:
            data (DataFrame): Performers' outputs with their embeddings
                A pandas.DataFrame containing `task`, `performer`, `output` and `embedding` columns.
            skills (Series): Performers' skills
                A pandas.Series index by performers and holding corresponding performer's skill
        Returns:
            DataFrame: Tasks' most likely true labels
                A pandas.Series indexed by `task` such that `labels.loc[task]`
                is the tasks's most likely true label."""
        ...

    def fit_predict_scores(self, data: DataFrame, skills: Series = None) -> DataFrame:
        """Args:
            data (DataFrame): Performers' outputs with their embeddings
                A pandas.DataFrame containing `task`, `performer`, `output` and `embedding` columns.
            skills (Series): Performers' skills
                A pandas.Series index by performers and holding corresponding performer's skill
        Returns:
            DataFrame: Tasks' true label probability distributions
                A pandas.DataFrame indexed by `task` such that `result.loc[task, label]`
                is the probability of `task`'s true label to be equal to `label`. Each
                probability is between 0 and 1, all task's probabilities should sum up to 1"""
        ...

    outputs_: DataFrame
    scores_: DataFrame
    distance: Callable
