from crowdkit.aggregation.base_aggregator import BaseAggregator
from pandas.core.frame import DataFrame
from pandas.core.series import Series
from typing import Optional
class DawidSkene(BaseAggregator):
    """Dawid-Skene aggregation model
    A. Philip Dawid and Allan M. Skene. 1979.
    Maximum Likelihood Estimation of Observer Error-Rates Using the EM Algorithm.
    Journal of the Royal Statistical Society. Series C (Applied Statistics), Vol. 28, 1 (1979), 20–28.

    https://doi.org/10.2307/2346806
    Attributes:
        probas_ (typing.Union[pandas.core.frame.DataFrame, NoneType]): Tasks' true label probability distributions
            A pandas.DataFrame indexed by `task` such that `result.loc[task, label]`
            is the probability of `task`'s true label to be equal to `label`. Each
            probability is between 0 and 1, all task's probabilities should sum up to 1

        priors_ (typing.Union[pandas.core.series.Series, NoneType]): A prior label distribution
            A pandas.Series indexed by labels and holding corresponding label's
            probability of occurrence. Each probability is between 0 and 1,
            all probabilities should sum up to 1

        labels_ (typing.Union[pandas.core.frame.DataFrame, NoneType]): Tasks' most likely true labels
            A pandas.Series indexed by `task` such that `labels.loc[task]`
            is the tasks's most likely true label.

        errors_ (typing.Union[pandas.core.frame.DataFrame, NoneType]): Performers' error matrices
            A pandas.DataFrame indexed by `performer` and `label` with a column for every
            label_id found in `data` such that `result.loc[performer, observed_label, true_label]`
            is the probability of `performer` producing an `observed_label` given that a task's
            true label is `true_label`"""

    def __init__(self, n_iter: int) -> None:
        """Method generated by attrs for class DawidSkene."""
        ...

    @staticmethod
    def _e_step(data: DataFrame, priors: Series, errors: DataFrame) -> DataFrame:
        """Perform E-step of Dawid-Skene algorithm.

        Given performer's answers, labels' prior probabilities and performer's performer's
        errors probabilities matrix estimates tasks' true labels probabilities.
        Args:
            data (DataFrame): Performers' labeling results
                A pandas.DataFrame containing `task`, `performer` and `label` columns.
            priors (Series): A prior label distribution
                A pandas.Series indexed by labels and holding corresponding label's
                probability of occurrence. Each probability is between 0 and 1,
                all probabilities should sum up to 1

            errors (DataFrame): Performers' error matrices
                A pandas.DataFrame indexed by `performer` and `label` with a column for every
                label_id found in `data` such that `result.loc[performer, observed_label, true_label]`
                is the probability of `performer` producing an `observed_label` given that a task's
                true label is `true_label`

        Returns:
            DataFrame: Tasks' true label probability distributions
                A pandas.DataFrame indexed by `task` such that `result.loc[task, label]`
                is the probability of `task`'s true label to be equal to `label`. Each
                probability is between 0 and 1, all task's probabilities should sum up to 1"""
        ...

    @staticmethod
    def _m_step(data: DataFrame, probas: DataFrame) -> DataFrame:
        """Perform M-step of Dawid-Skene algorithm.

        Given performers' answers and tasks' true labels probabilities estimates
        performer's errors probabilities matrix.
        Args:
            data (DataFrame): Performers' labeling results
                A pandas.DataFrame containing `task`, `performer` and `label` columns.
            probas (DataFrame): Tasks' true label probability distributions
                A pandas.DataFrame indexed by `task` such that `result.loc[task, label]`
                is the probability of `task`'s true label to be equal to `label`. Each
                probability is between 0 and 1, all task's probabilities should sum up to 1

        Returns:
            DataFrame: Performers' error matrices
                A pandas.DataFrame indexed by `performer` and `label` with a column for every
                label_id found in `data` such that `result.loc[performer, observed_label, true_label]`
                is the probability of `performer` producing an `observed_label` given that a task's
                true label is `true_label`"""
        ...

    def fit(self, data: DataFrame) -> 'DawidSkene':
        """Args:
            data (DataFrame): Performers' labeling results
                A pandas.DataFrame containing `task`, `performer` and `label` columns.
        Returns:
            DawidSkene: self"""
        ...

    def fit_predict(self, data: DataFrame) -> DataFrame:
        """Args:
            data (DataFrame): Performers' labeling results
                A pandas.DataFrame containing `task`, `performer` and `label` columns.
        Returns:
            DataFrame: Tasks' most likely true labels
                A pandas.Series indexed by `task` such that `labels.loc[task]`
                is the tasks's most likely true label."""
        ...

    def fit_predict_proba(self, data: DataFrame) -> DataFrame:
        """Args:
            data (DataFrame): Performers' labeling results
                A pandas.DataFrame containing `task`, `performer` and `label` columns.
        Returns:
            DataFrame: Tasks' true label probability distributions
                A pandas.DataFrame indexed by `task` such that `result.loc[task, label]`
                is the probability of `task`'s true label to be equal to `label`. Each
                probability is between 0 and 1, all task's probabilities should sum up to 1"""
        ...

    n_iter: int
    probas_: Optional[DataFrame]
    priors_: Optional[Series]
    labels_: Optional[DataFrame]
    errors_: Optional[DataFrame]



