from crowdkit.aggregation.base_aggregator import BaseAggregator
from pandas.core.frame import DataFrame
from pandas.core.series import Series
from typing import Optional
class GoldMajorityVote(BaseAggregator):
    """Majority Vote when exist golden dataset (ground truth) for some tasks

    Calculates the probability of a correct label for each performer based on the golden set
    Based on this, for each task, calculates the sum of the probabilities of each label
    The correct label is the one where the sum of the probabilities is greater

    For Example: You have 10k tasks completed by 3k different performers. And you have 100 tasks where you already
    know ground truth labels. First you can call 'fit' to calc percents of correct labels for each performers.
    And then call 'predict' to calculate labels for you 10k tasks.

    It's necessary that:
    1. All performers must done at least one task from golden dataset.
    2. All performers in dataset that send to 'predict', existed in answers dataset that was sent to 'fit'
    Attributes:
        skills_ (typing.Union[pandas.core.series.Series, NoneType]): Performers' skills
            A pandas.Series index by performers and holding corresponding performer's skill
        probas_ (typing.Union[pandas.core.frame.DataFrame, NoneType]): Tasks' true label probability distributions
            A pandas.DataFrame indexed by `task` such that `result.loc[task, label]`
            is the probability of `task`'s true label to be equal to `label`. Each
            probability is between 0 and 1, all task's probabilities should sum up to 1

        labels_ (typing.Union[pandas.core.frame.DataFrame, NoneType]): Tasks' most likely true labels
            A pandas.Series indexed by `task` such that `labels.loc[task]`
            is the tasks's most likely true label."""

    def __init__(self) -> None:
        """Method generated by attrs for class GoldMajorityVote."""
        ...

    def _apply(self, data: DataFrame) -> 'GoldMajorityVote':
        """Args:
            data (DataFrame): Performers' labeling results
                A pandas.DataFrame containing `task`, `performer` and `label` columns.
        Returns:
            GoldMajorityVote: self"""
        ...

    def fit(self, data: DataFrame, true_labels: Series) -> 'GoldMajorityVote':
        """Args:
            data (DataFrame): Performers' labeling results
                A pandas.DataFrame containing `task`, `performer` and `label` columns.
            true_labels (Series): Tasks' ground truth labels
                A pandas.Series indexed by `task` such that `labels.loc[task]`
                is the tasks's ground truth label.

        Returns:
            GoldMajorityVote: self"""
        ...

    def fit_predict(self, data: DataFrame, true_labels: Series) -> DataFrame:
        """Args:
            data (DataFrame): Performers' labeling results
                A pandas.DataFrame containing `task`, `performer` and `label` columns.
            true_labels (Series): Tasks' ground truth labels
                A pandas.Series indexed by `task` such that `labels.loc[task]`
                is the tasks's ground truth label.

        Returns:
            DataFrame: Tasks' most likely true labels
                A pandas.Series indexed by `task` such that `labels.loc[task]`
                is the tasks's most likely true label."""
        ...

    def fit_predict_proba(self, data: DataFrame, true_labels: Series) -> DataFrame:
        """Args:
            data (DataFrame): Performers' labeling results
                A pandas.DataFrame containing `task`, `performer` and `label` columns.
            true_labels (Series): Tasks' ground truth labels
                A pandas.Series indexed by `task` such that `labels.loc[task]`
                is the tasks's ground truth label.

        Returns:
            DataFrame: Tasks' true label probability distributions
                A pandas.DataFrame indexed by `task` such that `result.loc[task, label]`
                is the probability of `task`'s true label to be equal to `label`. Each
                probability is between 0 and 1, all task's probabilities should sum up to 1"""
        ...

    def predict(self, data: DataFrame) -> DataFrame:
        """Args:
            data (DataFrame): Performers' labeling results
                A pandas.DataFrame containing `task`, `performer` and `label` columns.
        Returns:
            DataFrame: Tasks' most likely true labels
                A pandas.Series indexed by `task` such that `labels.loc[task]`
                is the tasks's most likely true label."""
        ...

    def predict_proba(self, data: DataFrame) -> DataFrame:
        """Args:
            data (DataFrame): Performers' labeling results
                A pandas.DataFrame containing `task`, `performer` and `label` columns.
        Returns:
            DataFrame: Tasks' true label probability distributions
                A pandas.DataFrame indexed by `task` such that `result.loc[task, label]`
                is the probability of `task`'s true label to be equal to `label`. Each
                probability is between 0 and 1, all task's probabilities should sum up to 1"""
        ...

    skills_: Optional[Series]
    probas_: Optional[DataFrame]
    labels_: Optional[DataFrame]
