from crowdkit.aggregation.base_aggregator import BaseAggregator
from numpy import ndarray
from pandas.core.frame import DataFrame
from pandas.core.series import Series
from typing import Tuple, Optional


class MMSR(BaseAggregator):
    """Matrix Mean-Subsequence-Reduced Algorithm
    Qianqian Ma and Alex Olshevsky. 2020.
    Adversarial Crowdsourcing Through Robust Rank-One Matrix Completion
    34th Conference on Neural Information Processing Systems (NeurIPS 2020)
    https://arxiv.org/abs/2010.12181
    Attributes:
        skills_ (typing.Union[pandas.core.series.Series, NoneType]): Performers' skills
            A pandas.Series index by performers and holding corresponding performer's skill
        scores_ (typing.Union[pandas.core.frame.DataFrame, NoneType]): Tasks' true label scores
            A pandas.DataFrame indexed by `task` such that `result.loc[task, label]`
            is the score of `label` for `task`.
        labels_ (typing.Union[pandas.core.frame.DataFrame, NoneType]): Tasks' most likely true labels
            A pandas.Series indexed by `task` such that `labels.loc[task]`
            is the tasks's most likely true label."""

    def __init__(self, n_iter: int = 10000, eps: float = ..., random_state: Optional[int] = 0, observation_matrix: ndarray = ...,
                 covariation_matrix: ndarray = ..., n_common_tasks: ndarray = ..., n_performers: int = 0, n_tasks: int = 0,
                 n_labels: int = 0, labels_mapping: dict = ..., performers_mapping: dict = ..., tasks_mapping: dict = ...) -> None:
        """Method generated by attrs for class MMSR."""
        ...

    def _apply(self, data: DataFrame) -> 'MMSR':
        """Args:
            data (DataFrame): Performers' labeling results
                A pandas.DataFrame containing `task`, `performer` and `label` columns.
        Returns:
            MMSR: self"""
        ...

    def _construnct_covariation_matrix(self, answers: DataFrame) -> Tuple[ndarray]:
        """Args:
            answers (DataFrame): Performers' labeling results
                A pandas.DataFrame containing `task`, `performer` and `label` columns."""
        ...

    def _get_skills_from_array(self, array: ndarray) -> Series:
        """Returns:
        Series: Performers' skills
            A pandas.Series index by performers and holding corresponding performer's skill"""
        ...

    def _m_msr(self) -> None: ...

    @staticmethod
    def _remove_largest_and_smallest_F_value(x, F, a, n_tasks) -> ndarray: ...

    @staticmethod
    def _sign_determination_valid(C: ndarray, s_abs: ndarray) -> ndarray: ...

    def fit(self, data: DataFrame) -> 'MMSR':
        """Args:
            data (DataFrame): Performers' labeling results
                A pandas.DataFrame containing `task`, `performer` and `label` columns.
        Returns:
            MMSR: self"""
        ...

    def fit_predict(self, data: DataFrame) -> DataFrame:
        """Args:
            data (DataFrame): Performers' labeling results
                A pandas.DataFrame containing `task`, `performer` and `label` columns.
        Returns:
            DataFrame: Tasks' most likely true labels
                A pandas.Series indexed by `task` such that `labels.loc[task]`
                is the tasks's most likely true label."""
        ...

    def fit_predict_score(self, data: DataFrame) -> DataFrame:
        """Args:
            data (DataFrame): Performers' labeling results
                A pandas.DataFrame containing `task`, `performer` and `label` columns.
        Returns:
            DataFrame: Tasks' true label scores
                A pandas.DataFrame indexed by `task` such that `result.loc[task, label]`
                is the score of `label` for `task`."""
        ...

    def predict(self, data: DataFrame) -> DataFrame:
        """Args:
            data (DataFrame): Performers' labeling results
                A pandas.DataFrame containing `task`, `performer` and `label` columns.
        Returns:
            DataFrame: Tasks' most likely true labels
                A pandas.Series indexed by `task` such that `labels.loc[task]`
                is the tasks's most likely true label."""
        ...

    def predict_score(self, data: DataFrame) -> DataFrame:
        """Args:
            data (DataFrame): Performers' labeling results
                A pandas.DataFrame containing `task`, `performer` and `label` columns.
        Returns:
            DataFrame: Tasks' true label scores
                A pandas.DataFrame indexed by `task` such that `result.loc[task, label]`
                is the score of `label` for `task`."""
        ...

    n_iter: int
    eps: float
    random_state: Optional[int]
    _observation_matrix: ndarray
    _covariation_matrix: ndarray
    _n_common_tasks: ndarray
    _n_performers: int
    _n_tasks: int
    _n_labels: int
    _labels_mapping: dict
    _performers_mapping: dict
    _tasks_mapping: dict
    skills_: Optional[Series]
    scores_: Optional[DataFrame]
    labels_: Optional[DataFrame]
