from crowdkit.aggregation.base_aggregator import BaseAggregator
from pandas.core.frame import DataFrame
from pandas.core.series import Series
from typing import Optional


class MajorityVote(BaseAggregator):
    """Majority Vote - chooses the correct label for which more performers voted

    Attributes:
        skills_ (typing.Union[pandas.core.series.Series, NoneType]): Performers' skills
            A pandas.Series index by performers and holding corresponding performer's skill
        probas_ (typing.Union[pandas.core.frame.DataFrame, NoneType]): Tasks' true label probability distributions
            A pandas.DataFrame indexed by `task` such that `result.loc[task, label]`
            is the probability of `task`'s true label to be equal to `label`. Each
            probability is between 0 and 1, all task's probabilities should sum up to 1
        labels_ (typing.Union[pandas.core.frame.DataFrame, NoneType]): Tasks' most likely true labels
            A pandas.Series indexed by `task` such that `labels.loc[task]`
            is the tasks's most likely true label."""

    def __init__(self) -> None:
        """Method generated by attrs for class MajorityVote."""
        ...

    def fit(self, data: DataFrame, skills: Series = None) -> 'MajorityVote':
        """Args:
            data (DataFrame): Performers' labeling results
                A pandas.DataFrame containing `task`, `performer` and `label` columns.
            skills (Series): Performers' skills
                A pandas.Series index by performers and holding corresponding performer's skill
        Returns:
            MajorityVote: self"""
        ...

    def fit_predict(self, data: DataFrame, skills: Series = None) -> DataFrame:
        """Args:
            data (DataFrame): Performers' labeling results
                A pandas.DataFrame containing `task`, `performer` and `label` columns.
            skills (Series): Performers' skills
                A pandas.Series index by performers and holding corresponding performer's skill
        Returns:
            DataFrame: Tasks' most likely true labels
                A pandas.Series indexed by `task` such that `labels.loc[task]`
                is the tasks's most likely true label."""
        ...

    def fit_predict_proba(self, data: DataFrame, skills: Series = None) -> DataFrame:
        """Args:
            data (DataFrame): Performers' labeling results
                A pandas.DataFrame containing `task`, `performer` and `label` columns.
            skills (Series): Performers' skills
                A pandas.Series index by performers and holding corresponding performer's skill
        Returns:
            DataFrame: Tasks' true label probability distributions
                A pandas.DataFrame indexed by `task` such that `result.loc[task, label]`
                is the probability of `task`'s true label to be equal to `label`. Each
                probability is between 0 and 1, all task's probabilities should sum up to 1"""
        ...

    skills_: Optional[Series]
    probas_: Optional[DataFrame]
    labels_: Optional[DataFrame]
