from crowdkit.aggregation.base_embedding_aggregator import BaseEmbeddingAggregator
from pandas.core.frame import DataFrame
from pandas.core.series import Series


class RASA(BaseEmbeddingAggregator):
    """Hybrid Reliability and Representation Aware Sequence Aggregation
    Jiyi Li. 2020.
    Crowdsourced Text Sequence Aggregation based on Hybrid Reliability and Representation.
    Proceedings of the 43rd International ACM SIGIR Conference on Research and Development
    in Information Retrieval (SIGIR ’20), July 25–30, 2020, Virtual Event, China. ACM, New York, NY, USA,

    https://doi.org/10.1145/3397271.3401239"""

    def __init__(self, n_iter: int = 100, alpha: float = ...) -> None:
        """Method generated by attrs for class RASA."""
        ...

    @staticmethod
    def _aggregate_embeddings(data: DataFrame, skills: Series, true_embeddings: DataFrame = None) -> DataFrame:
        """Calculates weighted average of embeddings for each task.
        Args:
            data (DataFrame): Performers' outputs with their embeddings
                A pandas.DataFrame containing `task`, `performer`, `output` and `embedding` columns.
            skills (Series): Performers' skills
                A pandas.Series index by performers and holding corresponding performer's skill
            true_embeddings (DataFrame): Tasks' embeddings
                A pandas.DataFrame indexed by `task` with a single column `embedding`.
        Returns:
            DataFrame: Tasks' embeddings
                A pandas.DataFrame indexed by `task` with a single column `embedding`."""
        ...

    def _apply(self, data: DataFrame, true_embeddings: DataFrame = None) -> 'RASA':
        """Args:
            data (DataFrame): Performers' outputs with their embeddings
                A pandas.DataFrame containing `task`, `performer`, `output` and `embedding` columns.
            true_embeddings (DataFrame): Tasks' embeddings
                A pandas.DataFrame indexed by `task` with a single column `embedding`.
        Returns:
            RASA: self"""
        ...

    @staticmethod
    def _cosine_distance(embedding, avg_embedding): ...

    @staticmethod
    def _update_skills(data: DataFrame, aggregated_embeddings: DataFrame, prior_skills: DataFrame) -> Series:
        """Estimates global reliabilities by aggregated embeddings.
        Args:
            data (DataFrame): Performers' outputs with their embeddings
                A pandas.DataFrame containing `task`, `performer`, `output` and `embedding` columns.
            aggregated_embeddings (DataFrame): Tasks' embeddings
                A pandas.DataFrame indexed by `task` with a single column `embedding`.
            prior_skills (DataFrame): Tasks' embeddings
                A pandas.DataFrame indexed by `task` with a single column `embedding`.
        Returns:
            Series: Performers' skills
                A pandas.Series index by performers and holding corresponding performer's skill"""
        ...

    def fit(self, data: DataFrame, true_embeddings: DataFrame = None) -> 'RASA':
        """Args:
            data (DataFrame): Performers' outputs with their embeddings
                A pandas.DataFrame containing `task`, `performer`, `output` and `embedding` columns.
            true_embeddings (DataFrame): Tasks' embeddings
                A pandas.DataFrame indexed by `task` with a single column `embedding`.
        Returns:
            RASA: self"""
        ...

    def fit_predict(self, data: DataFrame, true_embeddings: DataFrame = None) -> DataFrame:
        """Args:
            data (DataFrame): Performers' outputs with their embeddings
                A pandas.DataFrame containing `task`, `performer`, `output` and `embedding` columns.
            true_embeddings (DataFrame): Tasks' embeddings
                A pandas.DataFrame indexed by `task` with a single column `embedding`.
        Returns:
            DataFrame: Tasks' most likely true labels
                A pandas.Series indexed by `task` such that `labels.loc[task]`
                is the tasks's most likely true label."""
        ...

    def fit_predict_scores(self, data: DataFrame, true_embeddings: DataFrame = None) -> DataFrame:
        """Args:
            data (DataFrame): Performers' outputs with their embeddings
                A pandas.DataFrame containing `task`, `performer`, `output` and `embedding` columns.
            true_embeddings (DataFrame): Tasks' embeddings
                A pandas.DataFrame indexed by `task` with a single column `embedding`.
        Returns:
            DataFrame: Tasks' true label probability distributions
                A pandas.DataFrame indexed by `task` such that `result.loc[task, label]`
                is the probability of `task`'s true label to be equal to `label`. Each
                probability is between 0 and 1, all task's probabilities should sum up to 1"""
        ...

    n_iter: int
    alpha: float
