from crowdkit.aggregation.base_aggregator import BaseAggregator
from pandas.core.frame import DataFrame
from pandas.core.series import Series
from typing import Optional


class Wawa(BaseAggregator):
    """Worker Agreement with Aggregate

    Calculates the considers the likelihood of coincidence of the performers opinion with the majority
    Based on this, for each task, calculates the sum of the agreement of each label
    The correct label is the one where the sum of the agreements is greater

    After predicting stored different data frames (details in BaseAggregator):
        tasks_labels: Predicted labels for each task
        probas: Probabilities for each label for task
        performers_skills: Predicted labels for each task
    Attributes:
        skills_ (typing.Union[pandas.core.series.Series, NoneType]): Performers' skills
            A pandas.Series index by performers and holding corresponding performer's skill
        probas_ (typing.Union[pandas.core.frame.DataFrame, NoneType]): Tasks' true label probability distributions
            A pandas.DataFrame indexed by `task` such that `result.loc[task, label]`
            is the probability of `task`'s true label to be equal to `label`. Each
            probability is between 0 and 1, all task's probabilities should sum up to 1

        labels_ (typing.Union[pandas.core.frame.DataFrame, NoneType]): Tasks' most likely true labels
            A pandas.Series indexed by `task` such that `labels.loc[task]`
            is the tasks's most likely true label."""

    def __init__(self) -> None:
        """Method generated by attrs for class Wawa."""
        ...

    def _apply(self, data: DataFrame) -> 'Wawa':
        """Args:
            data (DataFrame): Performers' labeling results
                A pandas.DataFrame containing `task`, `performer` and `label` columns.
        Returns:
            Wawa: self"""
        ...

    def fit(self, data: DataFrame) -> 'Wawa':
        """Args:
            data (DataFrame): Performers' labeling results
                A pandas.DataFrame containing `task`, `performer` and `label` columns.
        Returns:
            Wawa: self"""
        ...

    def fit_predict(self, data: DataFrame) -> DataFrame:
        """Args:
            data (DataFrame): Performers' labeling results
                A pandas.DataFrame containing `task`, `performer` and `label` columns.
        Returns:
            DataFrame: Tasks' most likely true labels
                A pandas.Series indexed by `task` such that `labels.loc[task]`
                is the tasks's most likely true label."""
        ...

    def fit_predict_proba(self, data: DataFrame) -> DataFrame:
        """Args:
            data (DataFrame): Performers' labeling results
                A pandas.DataFrame containing `task`, `performer` and `label` columns.
        Returns:
            DataFrame: Tasks' true label probability distributions
                A pandas.DataFrame indexed by `task` such that `result.loc[task, label]`
                is the probability of `task`'s true label to be equal to `label`. Each
                probability is between 0 and 1, all task's probabilities should sum up to 1"""
        ...

    def predict(self, data: DataFrame) -> DataFrame:
        """Args:
            data (DataFrame): Performers' labeling results
                A pandas.DataFrame containing `task`, `performer` and `label` columns.
        Returns:
            DataFrame: Tasks' most likely true labels
                A pandas.Series indexed by `task` such that `labels.loc[task]`
                is the tasks's most likely true label."""
        ...

    def predict_proba(self, data: DataFrame) -> DataFrame:
        """Args:
            data (DataFrame): Performers' labeling results
                A pandas.DataFrame containing `task`, `performer` and `label` columns.
        Returns:
            DataFrame: Tasks' true label probability distributions
                A pandas.DataFrame indexed by `task` such that `result.loc[task, label]`
                is the probability of `task`'s true label to be equal to `label`. Each
                probability is between 0 and 1, all task's probabilities should sum up to 1"""
        ...

    skills_: Optional[Series]
    probas_: Optional[DataFrame]
    labels_: Optional[DataFrame]
