from crowdkit.aggregation.base_aggregator import BaseAggregator
from pandas.core.frame import DataFrame


class ZeroBasedSkill(BaseAggregator):
    """The Zero-Based Skill aggregation model

    Performs weighted majority voting on tasks. After processing a pool of tasks,
    re-estimates performers' skills according to the correctness of their answers.
    Repeats this process until labels do not change or the number of iterations exceeds.

    It's necessary that all performers in a dataset that send to 'predict' existed in answers
    the dataset that was sent to 'fit'."""

    def __init__(self, n_iter: int = 100, lr_init: float = ..., lr_steps_to_reduce: int = 20, lr_reduce_factor: float = ..., eps: float = ...) -> None:
        """Method generated by attrs for class ZeroBasedSkill."""
        ...

    def _apply(self, data: DataFrame) -> 'ZeroBasedSkill':
        """Args:
            data (DataFrame): Performers' labeling results
                A pandas.DataFrame containing `task`, `performer` and `label` columns.
        Returns:
            ZeroBasedSkill: self"""
        ...

    def _init_skills(self, data: ...) -> ...: ...

    def fit(self, data: DataFrame) -> 'ZeroBasedSkill':
        """Args:
            data (DataFrame): Performers' labeling results
                A pandas.DataFrame containing `task`, `performer` and `label` columns.
        Returns:
            ZeroBasedSkill: self"""
        ...

    def fit_predict(self, data: DataFrame) -> DataFrame:
        """Args:
            data (DataFrame): Performers' labeling results
                A pandas.DataFrame containing `task`, `performer` and `label` columns.
        Returns:
            DataFrame: Tasks' most likely true labels
                A pandas.Series indexed by `task` such that `labels.loc[task]`
                is the tasks's most likely true label."""
        ...

    def fit_predict_proba(self, data: DataFrame) -> DataFrame:
        """Args:
            data (DataFrame): Performers' labeling results
                A pandas.DataFrame containing `task`, `performer` and `label` columns.
        Returns:
            DataFrame: Tasks' true label probability distributions
                A pandas.DataFrame indexed by `task` such that `result.loc[task, label]`
                is the probability of `task`'s true label to be equal to `label`. Each
                probability is between 0 and 1, all task's probabilities should sum up to 1"""
        ...

    def predict(self, data: DataFrame) -> DataFrame:
        """Args:
            data (DataFrame): Performers' labeling results
                A pandas.DataFrame containing `task`, `performer` and `label` columns.
        Returns:
            DataFrame: Tasks' most likely true labels
                A pandas.Series indexed by `task` such that `labels.loc[task]`
                is the tasks's most likely true label."""
        ...

    def predict_proba(self, data: DataFrame) -> DataFrame:
        """Args:
            data (DataFrame): Performers' labeling results
                A pandas.DataFrame containing `task`, `performer` and `label` columns.
        Returns:
            DataFrame: Tasks' true label probability distributions
                A pandas.DataFrame indexed by `task` such that `result.loc[task, label]`
                is the probability of `task`'s true label to be equal to `label`. Each
                probability is between 0 and 1, all task's probabilities should sum up to 1"""
        ...

    n_iter: int
    lr_init: float
    lr_steps_to_reduce: int
    lr_reduce_factor: float
    eps: float
    skills_: ...
    probas_: ...
    labels_: ...
