# -*- coding: utf-8 -*-
# This file is auto-generated, don't edit it. Thanks.
from Tea.model import TeaModel
from typing import List, Dict, Any


class KeywordSuggestInfo(TeaModel):
    def __init__(
        self,
        address: str = None,
        business_area_with_city: 'KeywordSuggestInfo' = None,
        city_code: int = None,
        city_name: str = None,
        display_name: str = None,
        hotel_id: str = None,
        icon: str = None,
        point: str = None,
        price: str = None,
        region: int = None,
        type: int = None,
        type_desc: str = None,
    ):
        self.address = address
        self.business_area_with_city = business_area_with_city
        self.city_code = city_code
        self.city_name = city_name
        self.display_name = display_name
        self.hotel_id = hotel_id
        self.icon = icon
        self.point = point
        self.price = price
        self.region = region
        self.type = type
        self.type_desc = type_desc

    def validate(self):
        if self.business_area_with_city:
            self.business_area_with_city.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.address is not None:
            result['address'] = self.address
        if self.business_area_with_city is not None:
            result['business_area_with_city'] = self.business_area_with_city.to_map()
        if self.city_code is not None:
            result['city_code'] = self.city_code
        if self.city_name is not None:
            result['city_name'] = self.city_name
        if self.display_name is not None:
            result['display_name'] = self.display_name
        if self.hotel_id is not None:
            result['hotel_id'] = self.hotel_id
        if self.icon is not None:
            result['icon'] = self.icon
        if self.point is not None:
            result['point'] = self.point
        if self.price is not None:
            result['price'] = self.price
        if self.region is not None:
            result['region'] = self.region
        if self.type is not None:
            result['type'] = self.type
        if self.type_desc is not None:
            result['type_desc'] = self.type_desc
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('address') is not None:
            self.address = m.get('address')
        if m.get('business_area_with_city') is not None:
            temp_model = KeywordSuggestInfo()
            self.business_area_with_city = temp_model.from_map(m['business_area_with_city'])
        if m.get('city_code') is not None:
            self.city_code = m.get('city_code')
        if m.get('city_name') is not None:
            self.city_name = m.get('city_name')
        if m.get('display_name') is not None:
            self.display_name = m.get('display_name')
        if m.get('hotel_id') is not None:
            self.hotel_id = m.get('hotel_id')
        if m.get('icon') is not None:
            self.icon = m.get('icon')
        if m.get('point') is not None:
            self.point = m.get('point')
        if m.get('price') is not None:
            self.price = m.get('price')
        if m.get('region') is not None:
            self.region = m.get('region')
        if m.get('type') is not None:
            self.type = m.get('type')
        if m.get('type_desc') is not None:
            self.type_desc = m.get('type_desc')
        return self


class ModuleFlightItemListBestPriceItemFlightRuleInfosValue(TeaModel):
    def __init__(
        self,
        refund_change_rule_desc: str = None,
        baggage_desc: str = None,
    ):
        self.refund_change_rule_desc = refund_change_rule_desc
        self.baggage_desc = baggage_desc

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.refund_change_rule_desc is not None:
            result['refund_change_rule_desc'] = self.refund_change_rule_desc
        if self.baggage_desc is not None:
            result['baggage_desc'] = self.baggage_desc
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('refund_change_rule_desc') is not None:
            self.refund_change_rule_desc = m.get('refund_change_rule_desc')
        if m.get('baggage_desc') is not None:
            self.baggage_desc = m.get('baggage_desc')
        return self


class ModuleFlightItemListBestPriceItemShoppingItemMapValueCabinQuantityListSegmentPosition(TeaModel):
    def __init__(
        self,
        journey_index: int = None,
        segment_index: int = None,
    ):
        self.journey_index = journey_index
        self.segment_index = segment_index

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.journey_index is not None:
            result['journey_index'] = self.journey_index
        if self.segment_index is not None:
            result['segment_index'] = self.segment_index
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('journey_index') is not None:
            self.journey_index = m.get('journey_index')
        if m.get('segment_index') is not None:
            self.segment_index = m.get('segment_index')
        return self


class ModuleFlightItemListBestPriceItemShoppingItemMapValueCabinQuantityListCabinInfo(TeaModel):
    def __init__(
        self,
        cabin: str = None,
        cabin_class: str = None,
        cabin_class_name: str = None,
        quantity: str = None,
    ):
        self.cabin = cabin
        self.cabin_class = cabin_class
        self.cabin_class_name = cabin_class_name
        self.quantity = quantity

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.cabin is not None:
            result['cabin'] = self.cabin
        if self.cabin_class is not None:
            result['cabin_class'] = self.cabin_class
        if self.cabin_class_name is not None:
            result['cabin_class_name'] = self.cabin_class_name
        if self.quantity is not None:
            result['quantity'] = self.quantity
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('cabin') is not None:
            self.cabin = m.get('cabin')
        if m.get('cabin_class') is not None:
            self.cabin_class = m.get('cabin_class')
        if m.get('cabin_class_name') is not None:
            self.cabin_class_name = m.get('cabin_class_name')
        if m.get('quantity') is not None:
            self.quantity = m.get('quantity')
        return self


class ModuleFlightItemListBestPriceItemShoppingItemMapValueCabinQuantityList(TeaModel):
    def __init__(
        self,
        segment_position: ModuleFlightItemListBestPriceItemShoppingItemMapValueCabinQuantityListSegmentPosition = None,
        cabin_info: ModuleFlightItemListBestPriceItemShoppingItemMapValueCabinQuantityListCabinInfo = None,
    ):
        self.segment_position = segment_position
        self.cabin_info = cabin_info

    def validate(self):
        if self.segment_position:
            self.segment_position.validate()
        if self.cabin_info:
            self.cabin_info.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.segment_position is not None:
            result['segment_position'] = self.segment_position.to_map()
        if self.cabin_info is not None:
            result['cabin_info'] = self.cabin_info.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('segment_position') is not None:
            temp_model = ModuleFlightItemListBestPriceItemShoppingItemMapValueCabinQuantityListSegmentPosition()
            self.segment_position = temp_model.from_map(m['segment_position'])
        if m.get('cabin_info') is not None:
            temp_model = ModuleFlightItemListBestPriceItemShoppingItemMapValueCabinQuantityListCabinInfo()
            self.cabin_info = temp_model.from_map(m['cabin_info'])
        return self


class ModuleFlightItemListBestPriceItemShoppingItemMapValueSearchPricePriceShowInfo(TeaModel):
    def __init__(
        self,
        discount_info: str = None,
        discount_num: float = None,
        show_ticket_price: bool = None,
    ):
        self.discount_info = discount_info
        self.discount_num = discount_num
        self.show_ticket_price = show_ticket_price

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.discount_info is not None:
            result['discount_info'] = self.discount_info
        if self.discount_num is not None:
            result['discount_num'] = self.discount_num
        if self.show_ticket_price is not None:
            result['show_ticket_price'] = self.show_ticket_price
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('discount_info') is not None:
            self.discount_info = m.get('discount_info')
        if m.get('discount_num') is not None:
            self.discount_num = m.get('discount_num')
        if m.get('show_ticket_price') is not None:
            self.show_ticket_price = m.get('show_ticket_price')
        return self


class ModuleFlightItemListBestPriceItemShoppingItemMapValueSearchPrice(TeaModel):
    def __init__(
        self,
        floor_price: int = None,
        ticket_price: int = None,
        sell_price: int = None,
        original_sell_price: int = None,
        base_total_price: int = None,
        before_control_price: int = None,
        tax: int = None,
        supply_price: int = None,
        basic_cabin_price: int = None,
        build_price: int = None,
        oil_price: int = None,
        first_standard_price: int = None,
        business_standard_price: int = None,
        common_standard_price: int = None,
        inter_ticket_price: int = None,
        subtracted_price: int = None,
        origin_common_price: int = None,
        dynamic_promotion_price: int = None,
        installment_num: int = None,
        installment_price: float = None,
        competition_dynamic_price: int = None,
        competition_promotion_price: int = None,
        min_before_control_price_of_normal: int = None,
        price_show_info: ModuleFlightItemListBestPriceItemShoppingItemMapValueSearchPricePriceShowInfo = None,
    ):
        self.floor_price = floor_price
        self.ticket_price = ticket_price
        self.sell_price = sell_price
        self.original_sell_price = original_sell_price
        self.base_total_price = base_total_price
        self.before_control_price = before_control_price
        self.tax = tax
        self.supply_price = supply_price
        self.basic_cabin_price = basic_cabin_price
        self.build_price = build_price
        self.oil_price = oil_price
        self.first_standard_price = first_standard_price
        self.business_standard_price = business_standard_price
        self.common_standard_price = common_standard_price
        # fdPrice
        self.inter_ticket_price = inter_ticket_price
        self.subtracted_price = subtracted_price
        self.origin_common_price = origin_common_price
        self.dynamic_promotion_price = dynamic_promotion_price
        self.installment_num = installment_num
        self.installment_price = installment_price
        self.competition_dynamic_price = competition_dynamic_price
        self.competition_promotion_price = competition_promotion_price
        self.min_before_control_price_of_normal = min_before_control_price_of_normal
        self.price_show_info = price_show_info

    def validate(self):
        if self.price_show_info:
            self.price_show_info.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.floor_price is not None:
            result['floor_price'] = self.floor_price
        if self.ticket_price is not None:
            result['ticket_price'] = self.ticket_price
        if self.sell_price is not None:
            result['sell_price'] = self.sell_price
        if self.original_sell_price is not None:
            result['original_sell_price'] = self.original_sell_price
        if self.base_total_price is not None:
            result['base_total_price'] = self.base_total_price
        if self.before_control_price is not None:
            result['before_control_price'] = self.before_control_price
        if self.tax is not None:
            result['tax'] = self.tax
        if self.supply_price is not None:
            result['supply_price'] = self.supply_price
        if self.basic_cabin_price is not None:
            result['basic_cabin_price'] = self.basic_cabin_price
        if self.build_price is not None:
            result['build_price'] = self.build_price
        if self.oil_price is not None:
            result['oil_price'] = self.oil_price
        if self.first_standard_price is not None:
            result['first_standard_price'] = self.first_standard_price
        if self.business_standard_price is not None:
            result['business_standard_price'] = self.business_standard_price
        if self.common_standard_price is not None:
            result['common_standard_price'] = self.common_standard_price
        if self.inter_ticket_price is not None:
            result['inter_ticket_price'] = self.inter_ticket_price
        if self.subtracted_price is not None:
            result['subtracted_price'] = self.subtracted_price
        if self.origin_common_price is not None:
            result['origin_common_price'] = self.origin_common_price
        if self.dynamic_promotion_price is not None:
            result['dynamic_promotion_price'] = self.dynamic_promotion_price
        if self.installment_num is not None:
            result['installment_num'] = self.installment_num
        if self.installment_price is not None:
            result['installment_price'] = self.installment_price
        if self.competition_dynamic_price is not None:
            result['competition_dynamic_price'] = self.competition_dynamic_price
        if self.competition_promotion_price is not None:
            result['competition_promotion_price'] = self.competition_promotion_price
        if self.min_before_control_price_of_normal is not None:
            result['min_before_control_price_of_normal'] = self.min_before_control_price_of_normal
        if self.price_show_info is not None:
            result['price_show_info'] = self.price_show_info.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('floor_price') is not None:
            self.floor_price = m.get('floor_price')
        if m.get('ticket_price') is not None:
            self.ticket_price = m.get('ticket_price')
        if m.get('sell_price') is not None:
            self.sell_price = m.get('sell_price')
        if m.get('original_sell_price') is not None:
            self.original_sell_price = m.get('original_sell_price')
        if m.get('base_total_price') is not None:
            self.base_total_price = m.get('base_total_price')
        if m.get('before_control_price') is not None:
            self.before_control_price = m.get('before_control_price')
        if m.get('tax') is not None:
            self.tax = m.get('tax')
        if m.get('supply_price') is not None:
            self.supply_price = m.get('supply_price')
        if m.get('basic_cabin_price') is not None:
            self.basic_cabin_price = m.get('basic_cabin_price')
        if m.get('build_price') is not None:
            self.build_price = m.get('build_price')
        if m.get('oil_price') is not None:
            self.oil_price = m.get('oil_price')
        if m.get('first_standard_price') is not None:
            self.first_standard_price = m.get('first_standard_price')
        if m.get('business_standard_price') is not None:
            self.business_standard_price = m.get('business_standard_price')
        if m.get('common_standard_price') is not None:
            self.common_standard_price = m.get('common_standard_price')
        if m.get('inter_ticket_price') is not None:
            self.inter_ticket_price = m.get('inter_ticket_price')
        if m.get('subtracted_price') is not None:
            self.subtracted_price = m.get('subtracted_price')
        if m.get('origin_common_price') is not None:
            self.origin_common_price = m.get('origin_common_price')
        if m.get('dynamic_promotion_price') is not None:
            self.dynamic_promotion_price = m.get('dynamic_promotion_price')
        if m.get('installment_num') is not None:
            self.installment_num = m.get('installment_num')
        if m.get('installment_price') is not None:
            self.installment_price = m.get('installment_price')
        if m.get('competition_dynamic_price') is not None:
            self.competition_dynamic_price = m.get('competition_dynamic_price')
        if m.get('competition_promotion_price') is not None:
            self.competition_promotion_price = m.get('competition_promotion_price')
        if m.get('min_before_control_price_of_normal') is not None:
            self.min_before_control_price_of_normal = m.get('min_before_control_price_of_normal')
        if m.get('price_show_info') is not None:
            temp_model = ModuleFlightItemListBestPriceItemShoppingItemMapValueSearchPricePriceShowInfo()
            self.price_show_info = temp_model.from_map(m['price_show_info'])
        return self


class ModuleFlightItemListBestPriceItemShoppingItemMapValueSegmentPriceListSegmentPosition(TeaModel):
    def __init__(
        self,
        journey_index: int = None,
        segment_index: int = None,
    ):
        self.journey_index = journey_index
        self.segment_index = segment_index

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.journey_index is not None:
            result['journey_index'] = self.journey_index
        if self.segment_index is not None:
            result['segment_index'] = self.segment_index
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('journey_index') is not None:
            self.journey_index = m.get('journey_index')
        if m.get('segment_index') is not None:
            self.segment_index = m.get('segment_index')
        return self


class ModuleFlightItemListBestPriceItemShoppingItemMapValueSegmentPriceListSearchPrice(TeaModel):
    def __init__(
        self,
        sell_price: int = None,
        ticket_price: int = None,
        tax: int = None,
    ):
        self.sell_price = sell_price
        self.ticket_price = ticket_price
        self.tax = tax

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.sell_price is not None:
            result['sell_price'] = self.sell_price
        if self.ticket_price is not None:
            result['ticket_price'] = self.ticket_price
        if self.tax is not None:
            result['tax'] = self.tax
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('sell_price') is not None:
            self.sell_price = m.get('sell_price')
        if m.get('ticket_price') is not None:
            self.ticket_price = m.get('ticket_price')
        if m.get('tax') is not None:
            self.tax = m.get('tax')
        return self


class ModuleFlightItemListBestPriceItemShoppingItemMapValueSegmentPriceList(TeaModel):
    def __init__(
        self,
        segment_position: ModuleFlightItemListBestPriceItemShoppingItemMapValueSegmentPriceListSegmentPosition = None,
        search_price: ModuleFlightItemListBestPriceItemShoppingItemMapValueSegmentPriceListSearchPrice = None,
    ):
        self.segment_position = segment_position
        self.search_price = search_price

    def validate(self):
        if self.segment_position:
            self.segment_position.validate()
        if self.search_price:
            self.search_price.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.segment_position is not None:
            result['segment_position'] = self.segment_position.to_map()
        if self.search_price is not None:
            result['search_price'] = self.search_price.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('segment_position') is not None:
            temp_model = ModuleFlightItemListBestPriceItemShoppingItemMapValueSegmentPriceListSegmentPosition()
            self.segment_position = temp_model.from_map(m['segment_position'])
        if m.get('search_price') is not None:
            temp_model = ModuleFlightItemListBestPriceItemShoppingItemMapValueSegmentPriceListSearchPrice()
            self.search_price = temp_model.from_map(m['search_price'])
        return self


class ModuleFlightItemListBestPriceItemShoppingItemMapValueCabinQuantityValue(TeaModel):
    def __init__(
        self,
        cabin: str = None,
        cabin_class: str = None,
        cabin_class_name: str = None,
        cabin_class_memo: str = None,
        specification: str = None,
        quantity: str = None,
        link_cabins: List[str] = None,
        reshop_change_cabin: bool = None,
        child_cabin_type: int = None,
        infant_basic_cabin: str = None,
        inner_cabin_class: int = None,
    ):
        self.cabin = cabin
        self.cabin_class = cabin_class
        self.cabin_class_name = cabin_class_name
        self.cabin_class_memo = cabin_class_memo
        self.specification = specification
        self.quantity = quantity
        self.link_cabins = link_cabins
        self.reshop_change_cabin = reshop_change_cabin
        self.child_cabin_type = child_cabin_type
        self.infant_basic_cabin = infant_basic_cabin
        self.inner_cabin_class = inner_cabin_class

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.cabin is not None:
            result['cabin'] = self.cabin
        if self.cabin_class is not None:
            result['cabin_class'] = self.cabin_class
        if self.cabin_class_name is not None:
            result['cabin_class_name'] = self.cabin_class_name
        if self.cabin_class_memo is not None:
            result['cabin_class_memo'] = self.cabin_class_memo
        if self.specification is not None:
            result['specification'] = self.specification
        if self.quantity is not None:
            result['quantity'] = self.quantity
        if self.link_cabins is not None:
            result['link_cabins'] = self.link_cabins
        if self.reshop_change_cabin is not None:
            result['reshop_change_cabin'] = self.reshop_change_cabin
        if self.child_cabin_type is not None:
            result['child_cabin_type'] = self.child_cabin_type
        if self.infant_basic_cabin is not None:
            result['infant_basic_cabin'] = self.infant_basic_cabin
        if self.inner_cabin_class is not None:
            result['inner_cabin_class'] = self.inner_cabin_class
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('cabin') is not None:
            self.cabin = m.get('cabin')
        if m.get('cabin_class') is not None:
            self.cabin_class = m.get('cabin_class')
        if m.get('cabin_class_name') is not None:
            self.cabin_class_name = m.get('cabin_class_name')
        if m.get('cabin_class_memo') is not None:
            self.cabin_class_memo = m.get('cabin_class_memo')
        if m.get('specification') is not None:
            self.specification = m.get('specification')
        if m.get('quantity') is not None:
            self.quantity = m.get('quantity')
        if m.get('link_cabins') is not None:
            self.link_cabins = m.get('link_cabins')
        if m.get('reshop_change_cabin') is not None:
            self.reshop_change_cabin = m.get('reshop_change_cabin')
        if m.get('child_cabin_type') is not None:
            self.child_cabin_type = m.get('child_cabin_type')
        if m.get('infant_basic_cabin') is not None:
            self.infant_basic_cabin = m.get('infant_basic_cabin')
        if m.get('inner_cabin_class') is not None:
            self.inner_cabin_class = m.get('inner_cabin_class')
        return self


class ModuleFlightItemListBestPriceItemShoppingItemMapValueSegmentPriceValuePriceShowInfo(TeaModel):
    def __init__(
        self,
        discount_info: str = None,
        discount_num: float = None,
        show_ticket_price: bool = None,
    ):
        self.discount_info = discount_info
        self.discount_num = discount_num
        self.show_ticket_price = show_ticket_price

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.discount_info is not None:
            result['discount_info'] = self.discount_info
        if self.discount_num is not None:
            result['discount_num'] = self.discount_num
        if self.show_ticket_price is not None:
            result['show_ticket_price'] = self.show_ticket_price
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('discount_info') is not None:
            self.discount_info = m.get('discount_info')
        if m.get('discount_num') is not None:
            self.discount_num = m.get('discount_num')
        if m.get('show_ticket_price') is not None:
            self.show_ticket_price = m.get('show_ticket_price')
        return self


class ModuleFlightItemListBestPriceItemShoppingItemMapValueSegmentPriceValue(TeaModel):
    def __init__(
        self,
        floor_price: int = None,
        ticket_price: int = None,
        sell_price: int = None,
        original_sell_price: int = None,
        base_total_price: int = None,
        before_control_price: int = None,
        tax: int = None,
        supply_price: int = None,
        basic_cabin_price: int = None,
        build_price: int = None,
        oil_price: int = None,
        first_standard_price: int = None,
        business_standard_price: int = None,
        common_standard_price: int = None,
        inter_ticket_price: int = None,
        subtracted_price: int = None,
        origin_common_price: int = None,
        dynamic_promotion_price: int = None,
        installment_num: int = None,
        installment_price: float = None,
        competition_dynamic_price: int = None,
        competition_promotion_price: int = None,
        min_before_control_price_of_normal: int = None,
        price_show_info: ModuleFlightItemListBestPriceItemShoppingItemMapValueSegmentPriceValuePriceShowInfo = None,
    ):
        self.floor_price = floor_price
        self.ticket_price = ticket_price
        self.sell_price = sell_price
        self.original_sell_price = original_sell_price
        self.base_total_price = base_total_price
        self.before_control_price = before_control_price
        self.tax = tax
        self.supply_price = supply_price
        self.basic_cabin_price = basic_cabin_price
        self.build_price = build_price
        self.oil_price = oil_price
        self.first_standard_price = first_standard_price
        self.business_standard_price = business_standard_price
        self.common_standard_price = common_standard_price
        # fdPrice
        self.inter_ticket_price = inter_ticket_price
        self.subtracted_price = subtracted_price
        self.origin_common_price = origin_common_price
        self.dynamic_promotion_price = dynamic_promotion_price
        self.installment_num = installment_num
        self.installment_price = installment_price
        self.competition_dynamic_price = competition_dynamic_price
        self.competition_promotion_price = competition_promotion_price
        self.min_before_control_price_of_normal = min_before_control_price_of_normal
        self.price_show_info = price_show_info

    def validate(self):
        if self.price_show_info:
            self.price_show_info.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.floor_price is not None:
            result['floor_price'] = self.floor_price
        if self.ticket_price is not None:
            result['ticket_price'] = self.ticket_price
        if self.sell_price is not None:
            result['sell_price'] = self.sell_price
        if self.original_sell_price is not None:
            result['original_sell_price'] = self.original_sell_price
        if self.base_total_price is not None:
            result['base_total_price'] = self.base_total_price
        if self.before_control_price is not None:
            result['before_control_price'] = self.before_control_price
        if self.tax is not None:
            result['tax'] = self.tax
        if self.supply_price is not None:
            result['supply_price'] = self.supply_price
        if self.basic_cabin_price is not None:
            result['basic_cabin_price'] = self.basic_cabin_price
        if self.build_price is not None:
            result['build_price'] = self.build_price
        if self.oil_price is not None:
            result['oil_price'] = self.oil_price
        if self.first_standard_price is not None:
            result['first_standard_price'] = self.first_standard_price
        if self.business_standard_price is not None:
            result['business_standard_price'] = self.business_standard_price
        if self.common_standard_price is not None:
            result['common_standard_price'] = self.common_standard_price
        if self.inter_ticket_price is not None:
            result['inter_ticket_price'] = self.inter_ticket_price
        if self.subtracted_price is not None:
            result['subtracted_price'] = self.subtracted_price
        if self.origin_common_price is not None:
            result['origin_common_price'] = self.origin_common_price
        if self.dynamic_promotion_price is not None:
            result['dynamic_promotion_price'] = self.dynamic_promotion_price
        if self.installment_num is not None:
            result['installment_num'] = self.installment_num
        if self.installment_price is not None:
            result['installment_price'] = self.installment_price
        if self.competition_dynamic_price is not None:
            result['competition_dynamic_price'] = self.competition_dynamic_price
        if self.competition_promotion_price is not None:
            result['competition_promotion_price'] = self.competition_promotion_price
        if self.min_before_control_price_of_normal is not None:
            result['min_before_control_price_of_normal'] = self.min_before_control_price_of_normal
        if self.price_show_info is not None:
            result['price_show_info'] = self.price_show_info.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('floor_price') is not None:
            self.floor_price = m.get('floor_price')
        if m.get('ticket_price') is not None:
            self.ticket_price = m.get('ticket_price')
        if m.get('sell_price') is not None:
            self.sell_price = m.get('sell_price')
        if m.get('original_sell_price') is not None:
            self.original_sell_price = m.get('original_sell_price')
        if m.get('base_total_price') is not None:
            self.base_total_price = m.get('base_total_price')
        if m.get('before_control_price') is not None:
            self.before_control_price = m.get('before_control_price')
        if m.get('tax') is not None:
            self.tax = m.get('tax')
        if m.get('supply_price') is not None:
            self.supply_price = m.get('supply_price')
        if m.get('basic_cabin_price') is not None:
            self.basic_cabin_price = m.get('basic_cabin_price')
        if m.get('build_price') is not None:
            self.build_price = m.get('build_price')
        if m.get('oil_price') is not None:
            self.oil_price = m.get('oil_price')
        if m.get('first_standard_price') is not None:
            self.first_standard_price = m.get('first_standard_price')
        if m.get('business_standard_price') is not None:
            self.business_standard_price = m.get('business_standard_price')
        if m.get('common_standard_price') is not None:
            self.common_standard_price = m.get('common_standard_price')
        if m.get('inter_ticket_price') is not None:
            self.inter_ticket_price = m.get('inter_ticket_price')
        if m.get('subtracted_price') is not None:
            self.subtracted_price = m.get('subtracted_price')
        if m.get('origin_common_price') is not None:
            self.origin_common_price = m.get('origin_common_price')
        if m.get('dynamic_promotion_price') is not None:
            self.dynamic_promotion_price = m.get('dynamic_promotion_price')
        if m.get('installment_num') is not None:
            self.installment_num = m.get('installment_num')
        if m.get('installment_price') is not None:
            self.installment_price = m.get('installment_price')
        if m.get('competition_dynamic_price') is not None:
            self.competition_dynamic_price = m.get('competition_dynamic_price')
        if m.get('competition_promotion_price') is not None:
            self.competition_promotion_price = m.get('competition_promotion_price')
        if m.get('min_before_control_price_of_normal') is not None:
            self.min_before_control_price_of_normal = m.get('min_before_control_price_of_normal')
        if m.get('price_show_info') is not None:
            temp_model = ModuleFlightItemListBestPriceItemShoppingItemMapValueSegmentPriceValuePriceShowInfo()
            self.price_show_info = temp_model.from_map(m['price_show_info'])
        return self


class ModuleFlightItemListBestPriceItemShoppingItemMapValue(TeaModel):
    def __init__(
        self,
        cabin_quantity_list: List[ModuleFlightItemListBestPriceItemShoppingItemMapValueCabinQuantityList] = None,
        search_price: ModuleFlightItemListBestPriceItemShoppingItemMapValueSearchPrice = None,
        segment_price_list: List[ModuleFlightItemListBestPriceItemShoppingItemMapValueSegmentPriceList] = None,
        id: str = None,
        cabin_quantity: Dict[str, ModuleFlightItemListBestPriceItemShoppingItemMapValueCabinQuantityValue] = None,
        segment_price: Dict[str, ModuleFlightItemListBestPriceItemShoppingItemMapValueSegmentPriceValue] = None,
    ):
        self.cabin_quantity_list = cabin_quantity_list
        self.search_price = search_price
        self.segment_price_list = segment_price_list
        # id
        self.id = id
        self.cabin_quantity = cabin_quantity
        self.segment_price = segment_price

    def validate(self):
        if self.cabin_quantity_list:
            for k in self.cabin_quantity_list:
                if k:
                    k.validate()
        if self.search_price:
            self.search_price.validate()
        if self.segment_price_list:
            for k in self.segment_price_list:
                if k:
                    k.validate()
        if self.cabin_quantity:
            for v in self.cabin_quantity.values():
                if v:
                    v.validate()
        if self.segment_price:
            for v in self.segment_price.values():
                if v:
                    v.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['cabin_quantity_list'] = []
        if self.cabin_quantity_list is not None:
            for k in self.cabin_quantity_list:
                result['cabin_quantity_list'].append(k.to_map() if k else None)
        if self.search_price is not None:
            result['search_price'] = self.search_price.to_map()
        result['segment_price_list'] = []
        if self.segment_price_list is not None:
            for k in self.segment_price_list:
                result['segment_price_list'].append(k.to_map() if k else None)
        if self.id is not None:
            result['id'] = self.id
        result['cabin_quantity'] = {}
        if self.cabin_quantity is not None:
            for k, v in self.cabin_quantity.items():
                result['cabin_quantity'][k] = v.to_map()
        result['segment_price'] = {}
        if self.segment_price is not None:
            for k, v in self.segment_price.items():
                result['segment_price'][k] = v.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.cabin_quantity_list = []
        if m.get('cabin_quantity_list') is not None:
            for k in m.get('cabin_quantity_list'):
                temp_model = ModuleFlightItemListBestPriceItemShoppingItemMapValueCabinQuantityList()
                self.cabin_quantity_list.append(temp_model.from_map(k))
        if m.get('search_price') is not None:
            temp_model = ModuleFlightItemListBestPriceItemShoppingItemMapValueSearchPrice()
            self.search_price = temp_model.from_map(m['search_price'])
        self.segment_price_list = []
        if m.get('segment_price_list') is not None:
            for k in m.get('segment_price_list'):
                temp_model = ModuleFlightItemListBestPriceItemShoppingItemMapValueSegmentPriceList()
                self.segment_price_list.append(temp_model.from_map(k))
        if m.get('id') is not None:
            self.id = m.get('id')
        self.cabin_quantity = {}
        if m.get('cabin_quantity') is not None:
            for k, v in m.get('cabin_quantity').items():
                temp_model = ModuleFlightItemListBestPriceItemShoppingItemMapValueCabinQuantityValue()
                self.cabin_quantity[k] = temp_model.from_map(v)
        self.segment_price = {}
        if m.get('segment_price') is not None:
            for k, v in m.get('segment_price').items():
                temp_model = ModuleFlightItemListBestPriceItemShoppingItemMapValueSegmentPriceValue()
                self.segment_price[k] = temp_model.from_map(v)
        return self


class ModuleFlightItemListBestPriceItemSubItemPositionMapValue(TeaModel):
    def __init__(
        self,
        journey_index: int = None,
        segment_index: int = None,
    ):
        self.journey_index = journey_index
        self.segment_index = segment_index

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.journey_index is not None:
            result['journey_index'] = self.journey_index
        if self.segment_index is not None:
            result['segment_index'] = self.segment_index
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('journey_index') is not None:
            self.journey_index = m.get('journey_index')
        if m.get('segment_index') is not None:
            self.segment_index = m.get('segment_index')
        return self


class ModuleFlightItemListBestPriceItemSubItemsShoppingItemMapValueSearchPricePriceShowInfo(TeaModel):
    def __init__(
        self,
        discount_info: str = None,
        discount_num: float = None,
        show_ticket_price: bool = None,
    ):
        self.discount_info = discount_info
        self.discount_num = discount_num
        self.show_ticket_price = show_ticket_price

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.discount_info is not None:
            result['discount_info'] = self.discount_info
        if self.discount_num is not None:
            result['discount_num'] = self.discount_num
        if self.show_ticket_price is not None:
            result['show_ticket_price'] = self.show_ticket_price
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('discount_info') is not None:
            self.discount_info = m.get('discount_info')
        if m.get('discount_num') is not None:
            self.discount_num = m.get('discount_num')
        if m.get('show_ticket_price') is not None:
            self.show_ticket_price = m.get('show_ticket_price')
        return self


class ModuleFlightItemListBestPriceItemSubItemsShoppingItemMapValueSearchPrice(TeaModel):
    def __init__(
        self,
        floor_price: int = None,
        ticket_price: int = None,
        sell_price: int = None,
        original_sell_price: int = None,
        base_total_price: int = None,
        before_control_price: int = None,
        tax: int = None,
        supply_price: int = None,
        basic_cabin_price: int = None,
        build_price: int = None,
        oil_price: int = None,
        first_standard_price: int = None,
        business_standard_price: int = None,
        common_standard_price: int = None,
        inter_ticket_price: int = None,
        subtracted_price: int = None,
        origin_common_price: int = None,
        dynamic_promotion_price: int = None,
        installment_num: int = None,
        installment_price: float = None,
        competition_dynamic_price: int = None,
        competition_promotion_price: int = None,
        min_before_control_price_of_normal: int = None,
        price_show_info: ModuleFlightItemListBestPriceItemSubItemsShoppingItemMapValueSearchPricePriceShowInfo = None,
    ):
        self.floor_price = floor_price
        self.ticket_price = ticket_price
        self.sell_price = sell_price
        self.original_sell_price = original_sell_price
        self.base_total_price = base_total_price
        self.before_control_price = before_control_price
        self.tax = tax
        self.supply_price = supply_price
        self.basic_cabin_price = basic_cabin_price
        self.build_price = build_price
        self.oil_price = oil_price
        self.first_standard_price = first_standard_price
        self.business_standard_price = business_standard_price
        self.common_standard_price = common_standard_price
        # fdPrice
        self.inter_ticket_price = inter_ticket_price
        self.subtracted_price = subtracted_price
        self.origin_common_price = origin_common_price
        self.dynamic_promotion_price = dynamic_promotion_price
        self.installment_num = installment_num
        self.installment_price = installment_price
        self.competition_dynamic_price = competition_dynamic_price
        self.competition_promotion_price = competition_promotion_price
        self.min_before_control_price_of_normal = min_before_control_price_of_normal
        self.price_show_info = price_show_info

    def validate(self):
        if self.price_show_info:
            self.price_show_info.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.floor_price is not None:
            result['floor_price'] = self.floor_price
        if self.ticket_price is not None:
            result['ticket_price'] = self.ticket_price
        if self.sell_price is not None:
            result['sell_price'] = self.sell_price
        if self.original_sell_price is not None:
            result['original_sell_price'] = self.original_sell_price
        if self.base_total_price is not None:
            result['base_total_price'] = self.base_total_price
        if self.before_control_price is not None:
            result['before_control_price'] = self.before_control_price
        if self.tax is not None:
            result['tax'] = self.tax
        if self.supply_price is not None:
            result['supply_price'] = self.supply_price
        if self.basic_cabin_price is not None:
            result['basic_cabin_price'] = self.basic_cabin_price
        if self.build_price is not None:
            result['build_price'] = self.build_price
        if self.oil_price is not None:
            result['oil_price'] = self.oil_price
        if self.first_standard_price is not None:
            result['first_standard_price'] = self.first_standard_price
        if self.business_standard_price is not None:
            result['business_standard_price'] = self.business_standard_price
        if self.common_standard_price is not None:
            result['common_standard_price'] = self.common_standard_price
        if self.inter_ticket_price is not None:
            result['inter_ticket_price'] = self.inter_ticket_price
        if self.subtracted_price is not None:
            result['subtracted_price'] = self.subtracted_price
        if self.origin_common_price is not None:
            result['origin_common_price'] = self.origin_common_price
        if self.dynamic_promotion_price is not None:
            result['dynamic_promotion_price'] = self.dynamic_promotion_price
        if self.installment_num is not None:
            result['installment_num'] = self.installment_num
        if self.installment_price is not None:
            result['installment_price'] = self.installment_price
        if self.competition_dynamic_price is not None:
            result['competition_dynamic_price'] = self.competition_dynamic_price
        if self.competition_promotion_price is not None:
            result['competition_promotion_price'] = self.competition_promotion_price
        if self.min_before_control_price_of_normal is not None:
            result['min_before_control_price_of_normal'] = self.min_before_control_price_of_normal
        if self.price_show_info is not None:
            result['price_show_info'] = self.price_show_info.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('floor_price') is not None:
            self.floor_price = m.get('floor_price')
        if m.get('ticket_price') is not None:
            self.ticket_price = m.get('ticket_price')
        if m.get('sell_price') is not None:
            self.sell_price = m.get('sell_price')
        if m.get('original_sell_price') is not None:
            self.original_sell_price = m.get('original_sell_price')
        if m.get('base_total_price') is not None:
            self.base_total_price = m.get('base_total_price')
        if m.get('before_control_price') is not None:
            self.before_control_price = m.get('before_control_price')
        if m.get('tax') is not None:
            self.tax = m.get('tax')
        if m.get('supply_price') is not None:
            self.supply_price = m.get('supply_price')
        if m.get('basic_cabin_price') is not None:
            self.basic_cabin_price = m.get('basic_cabin_price')
        if m.get('build_price') is not None:
            self.build_price = m.get('build_price')
        if m.get('oil_price') is not None:
            self.oil_price = m.get('oil_price')
        if m.get('first_standard_price') is not None:
            self.first_standard_price = m.get('first_standard_price')
        if m.get('business_standard_price') is not None:
            self.business_standard_price = m.get('business_standard_price')
        if m.get('common_standard_price') is not None:
            self.common_standard_price = m.get('common_standard_price')
        if m.get('inter_ticket_price') is not None:
            self.inter_ticket_price = m.get('inter_ticket_price')
        if m.get('subtracted_price') is not None:
            self.subtracted_price = m.get('subtracted_price')
        if m.get('origin_common_price') is not None:
            self.origin_common_price = m.get('origin_common_price')
        if m.get('dynamic_promotion_price') is not None:
            self.dynamic_promotion_price = m.get('dynamic_promotion_price')
        if m.get('installment_num') is not None:
            self.installment_num = m.get('installment_num')
        if m.get('installment_price') is not None:
            self.installment_price = m.get('installment_price')
        if m.get('competition_dynamic_price') is not None:
            self.competition_dynamic_price = m.get('competition_dynamic_price')
        if m.get('competition_promotion_price') is not None:
            self.competition_promotion_price = m.get('competition_promotion_price')
        if m.get('min_before_control_price_of_normal') is not None:
            self.min_before_control_price_of_normal = m.get('min_before_control_price_of_normal')
        if m.get('price_show_info') is not None:
            temp_model = ModuleFlightItemListBestPriceItemSubItemsShoppingItemMapValueSearchPricePriceShowInfo()
            self.price_show_info = temp_model.from_map(m['price_show_info'])
        return self


class ModuleFlightItemListBestPriceItemSubItemsShoppingItemMapValueCabinQuantityValue(TeaModel):
    def __init__(
        self,
        cabin: str = None,
        cabin_class: str = None,
        cabin_class_name: str = None,
        cabin_class_memo: str = None,
        specification: str = None,
        quantity: str = None,
        link_cabins: List[str] = None,
        reshop_change_cabin: bool = None,
        child_cabin_type: int = None,
        infant_basic_cabin: str = None,
        inner_cabin_class: int = None,
    ):
        self.cabin = cabin
        self.cabin_class = cabin_class
        self.cabin_class_name = cabin_class_name
        self.cabin_class_memo = cabin_class_memo
        self.specification = specification
        self.quantity = quantity
        self.link_cabins = link_cabins
        self.reshop_change_cabin = reshop_change_cabin
        self.child_cabin_type = child_cabin_type
        self.infant_basic_cabin = infant_basic_cabin
        self.inner_cabin_class = inner_cabin_class

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.cabin is not None:
            result['cabin'] = self.cabin
        if self.cabin_class is not None:
            result['cabin_class'] = self.cabin_class
        if self.cabin_class_name is not None:
            result['cabin_class_name'] = self.cabin_class_name
        if self.cabin_class_memo is not None:
            result['cabin_class_memo'] = self.cabin_class_memo
        if self.specification is not None:
            result['specification'] = self.specification
        if self.quantity is not None:
            result['quantity'] = self.quantity
        if self.link_cabins is not None:
            result['link_cabins'] = self.link_cabins
        if self.reshop_change_cabin is not None:
            result['reshop_change_cabin'] = self.reshop_change_cabin
        if self.child_cabin_type is not None:
            result['child_cabin_type'] = self.child_cabin_type
        if self.infant_basic_cabin is not None:
            result['infant_basic_cabin'] = self.infant_basic_cabin
        if self.inner_cabin_class is not None:
            result['inner_cabin_class'] = self.inner_cabin_class
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('cabin') is not None:
            self.cabin = m.get('cabin')
        if m.get('cabin_class') is not None:
            self.cabin_class = m.get('cabin_class')
        if m.get('cabin_class_name') is not None:
            self.cabin_class_name = m.get('cabin_class_name')
        if m.get('cabin_class_memo') is not None:
            self.cabin_class_memo = m.get('cabin_class_memo')
        if m.get('specification') is not None:
            self.specification = m.get('specification')
        if m.get('quantity') is not None:
            self.quantity = m.get('quantity')
        if m.get('link_cabins') is not None:
            self.link_cabins = m.get('link_cabins')
        if m.get('reshop_change_cabin') is not None:
            self.reshop_change_cabin = m.get('reshop_change_cabin')
        if m.get('child_cabin_type') is not None:
            self.child_cabin_type = m.get('child_cabin_type')
        if m.get('infant_basic_cabin') is not None:
            self.infant_basic_cabin = m.get('infant_basic_cabin')
        if m.get('inner_cabin_class') is not None:
            self.inner_cabin_class = m.get('inner_cabin_class')
        return self


class ModuleFlightItemListBestPriceItemSubItemsShoppingItemMapValueSegmentPriceValuePriceShowInfo(TeaModel):
    def __init__(
        self,
        discount_info: str = None,
        discount_num: float = None,
        show_ticket_price: bool = None,
    ):
        self.discount_info = discount_info
        self.discount_num = discount_num
        self.show_ticket_price = show_ticket_price

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.discount_info is not None:
            result['discount_info'] = self.discount_info
        if self.discount_num is not None:
            result['discount_num'] = self.discount_num
        if self.show_ticket_price is not None:
            result['show_ticket_price'] = self.show_ticket_price
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('discount_info') is not None:
            self.discount_info = m.get('discount_info')
        if m.get('discount_num') is not None:
            self.discount_num = m.get('discount_num')
        if m.get('show_ticket_price') is not None:
            self.show_ticket_price = m.get('show_ticket_price')
        return self


class ModuleFlightItemListBestPriceItemSubItemsShoppingItemMapValueSegmentPriceValue(TeaModel):
    def __init__(
        self,
        floor_price: int = None,
        ticket_price: int = None,
        sell_price: int = None,
        original_sell_price: int = None,
        base_total_price: int = None,
        before_control_price: int = None,
        tax: int = None,
        supply_price: int = None,
        basic_cabin_price: int = None,
        build_price: int = None,
        oil_price: int = None,
        first_standard_price: int = None,
        business_standard_price: int = None,
        common_standard_price: int = None,
        inter_ticket_price: int = None,
        subtracted_price: int = None,
        origin_common_price: int = None,
        dynamic_promotion_price: int = None,
        installment_num: int = None,
        installment_price: float = None,
        competition_dynamic_price: int = None,
        competition_promotion_price: int = None,
        min_before_control_price_of_normal: int = None,
        price_show_info: ModuleFlightItemListBestPriceItemSubItemsShoppingItemMapValueSegmentPriceValuePriceShowInfo = None,
    ):
        self.floor_price = floor_price
        self.ticket_price = ticket_price
        self.sell_price = sell_price
        self.original_sell_price = original_sell_price
        self.base_total_price = base_total_price
        self.before_control_price = before_control_price
        self.tax = tax
        self.supply_price = supply_price
        self.basic_cabin_price = basic_cabin_price
        self.build_price = build_price
        self.oil_price = oil_price
        self.first_standard_price = first_standard_price
        self.business_standard_price = business_standard_price
        self.common_standard_price = common_standard_price
        # fdPrice
        self.inter_ticket_price = inter_ticket_price
        self.subtracted_price = subtracted_price
        self.origin_common_price = origin_common_price
        self.dynamic_promotion_price = dynamic_promotion_price
        self.installment_num = installment_num
        self.installment_price = installment_price
        self.competition_dynamic_price = competition_dynamic_price
        self.competition_promotion_price = competition_promotion_price
        self.min_before_control_price_of_normal = min_before_control_price_of_normal
        self.price_show_info = price_show_info

    def validate(self):
        if self.price_show_info:
            self.price_show_info.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.floor_price is not None:
            result['floor_price'] = self.floor_price
        if self.ticket_price is not None:
            result['ticket_price'] = self.ticket_price
        if self.sell_price is not None:
            result['sell_price'] = self.sell_price
        if self.original_sell_price is not None:
            result['original_sell_price'] = self.original_sell_price
        if self.base_total_price is not None:
            result['base_total_price'] = self.base_total_price
        if self.before_control_price is not None:
            result['before_control_price'] = self.before_control_price
        if self.tax is not None:
            result['tax'] = self.tax
        if self.supply_price is not None:
            result['supply_price'] = self.supply_price
        if self.basic_cabin_price is not None:
            result['basic_cabin_price'] = self.basic_cabin_price
        if self.build_price is not None:
            result['build_price'] = self.build_price
        if self.oil_price is not None:
            result['oil_price'] = self.oil_price
        if self.first_standard_price is not None:
            result['first_standard_price'] = self.first_standard_price
        if self.business_standard_price is not None:
            result['business_standard_price'] = self.business_standard_price
        if self.common_standard_price is not None:
            result['common_standard_price'] = self.common_standard_price
        if self.inter_ticket_price is not None:
            result['inter_ticket_price'] = self.inter_ticket_price
        if self.subtracted_price is not None:
            result['subtracted_price'] = self.subtracted_price
        if self.origin_common_price is not None:
            result['origin_common_price'] = self.origin_common_price
        if self.dynamic_promotion_price is not None:
            result['dynamic_promotion_price'] = self.dynamic_promotion_price
        if self.installment_num is not None:
            result['installment_num'] = self.installment_num
        if self.installment_price is not None:
            result['installment_price'] = self.installment_price
        if self.competition_dynamic_price is not None:
            result['competition_dynamic_price'] = self.competition_dynamic_price
        if self.competition_promotion_price is not None:
            result['competition_promotion_price'] = self.competition_promotion_price
        if self.min_before_control_price_of_normal is not None:
            result['min_before_control_price_of_normal'] = self.min_before_control_price_of_normal
        if self.price_show_info is not None:
            result['price_show_info'] = self.price_show_info.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('floor_price') is not None:
            self.floor_price = m.get('floor_price')
        if m.get('ticket_price') is not None:
            self.ticket_price = m.get('ticket_price')
        if m.get('sell_price') is not None:
            self.sell_price = m.get('sell_price')
        if m.get('original_sell_price') is not None:
            self.original_sell_price = m.get('original_sell_price')
        if m.get('base_total_price') is not None:
            self.base_total_price = m.get('base_total_price')
        if m.get('before_control_price') is not None:
            self.before_control_price = m.get('before_control_price')
        if m.get('tax') is not None:
            self.tax = m.get('tax')
        if m.get('supply_price') is not None:
            self.supply_price = m.get('supply_price')
        if m.get('basic_cabin_price') is not None:
            self.basic_cabin_price = m.get('basic_cabin_price')
        if m.get('build_price') is not None:
            self.build_price = m.get('build_price')
        if m.get('oil_price') is not None:
            self.oil_price = m.get('oil_price')
        if m.get('first_standard_price') is not None:
            self.first_standard_price = m.get('first_standard_price')
        if m.get('business_standard_price') is not None:
            self.business_standard_price = m.get('business_standard_price')
        if m.get('common_standard_price') is not None:
            self.common_standard_price = m.get('common_standard_price')
        if m.get('inter_ticket_price') is not None:
            self.inter_ticket_price = m.get('inter_ticket_price')
        if m.get('subtracted_price') is not None:
            self.subtracted_price = m.get('subtracted_price')
        if m.get('origin_common_price') is not None:
            self.origin_common_price = m.get('origin_common_price')
        if m.get('dynamic_promotion_price') is not None:
            self.dynamic_promotion_price = m.get('dynamic_promotion_price')
        if m.get('installment_num') is not None:
            self.installment_num = m.get('installment_num')
        if m.get('installment_price') is not None:
            self.installment_price = m.get('installment_price')
        if m.get('competition_dynamic_price') is not None:
            self.competition_dynamic_price = m.get('competition_dynamic_price')
        if m.get('competition_promotion_price') is not None:
            self.competition_promotion_price = m.get('competition_promotion_price')
        if m.get('min_before_control_price_of_normal') is not None:
            self.min_before_control_price_of_normal = m.get('min_before_control_price_of_normal')
        if m.get('price_show_info') is not None:
            temp_model = ModuleFlightItemListBestPriceItemSubItemsShoppingItemMapValueSegmentPriceValuePriceShowInfo()
            self.price_show_info = temp_model.from_map(m['price_show_info'])
        return self


class ModuleFlightItemListBestPriceItemSubItemsShoppingItemMapValue(TeaModel):
    def __init__(
        self,
        id: str = None,
        cabin_quantity: Dict[str, ModuleFlightItemListBestPriceItemSubItemsShoppingItemMapValueCabinQuantityValue] = None,
        search_price: ModuleFlightItemListBestPriceItemSubItemsShoppingItemMapValueSearchPrice = None,
        segment_price: Dict[str, ModuleFlightItemListBestPriceItemSubItemsShoppingItemMapValueSegmentPriceValue] = None,
    ):
        # id
        self.id = id
        self.cabin_quantity = cabin_quantity
        self.search_price = search_price
        self.segment_price = segment_price

    def validate(self):
        if self.cabin_quantity:
            for v in self.cabin_quantity.values():
                if v:
                    v.validate()
        if self.search_price:
            self.search_price.validate()
        if self.segment_price:
            for v in self.segment_price.values():
                if v:
                    v.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.id is not None:
            result['id'] = self.id
        result['cabin_quantity'] = {}
        if self.cabin_quantity is not None:
            for k, v in self.cabin_quantity.items():
                result['cabin_quantity'][k] = v.to_map()
        if self.search_price is not None:
            result['search_price'] = self.search_price.to_map()
        result['segment_price'] = {}
        if self.segment_price is not None:
            for k, v in self.segment_price.items():
                result['segment_price'][k] = v.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('id') is not None:
            self.id = m.get('id')
        self.cabin_quantity = {}
        if m.get('cabin_quantity') is not None:
            for k, v in m.get('cabin_quantity').items():
                temp_model = ModuleFlightItemListBestPriceItemSubItemsShoppingItemMapValueCabinQuantityValue()
                self.cabin_quantity[k] = temp_model.from_map(v)
        if m.get('search_price') is not None:
            temp_model = ModuleFlightItemListBestPriceItemSubItemsShoppingItemMapValueSearchPrice()
            self.search_price = temp_model.from_map(m['search_price'])
        self.segment_price = {}
        if m.get('segment_price') is not None:
            for k, v in m.get('segment_price').items():
                temp_model = ModuleFlightItemListBestPriceItemSubItemsShoppingItemMapValueSegmentPriceValue()
                self.segment_price[k] = temp_model.from_map(v)
        return self


class ModuleFlightItemListItemListFlightRuleInfosValue(TeaModel):
    def __init__(
        self,
        refund_change_rule_desc: str = None,
        baggage_desc: str = None,
    ):
        self.refund_change_rule_desc = refund_change_rule_desc
        self.baggage_desc = baggage_desc

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.refund_change_rule_desc is not None:
            result['refund_change_rule_desc'] = self.refund_change_rule_desc
        if self.baggage_desc is not None:
            result['baggage_desc'] = self.baggage_desc
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('refund_change_rule_desc') is not None:
            self.refund_change_rule_desc = m.get('refund_change_rule_desc')
        if m.get('baggage_desc') is not None:
            self.baggage_desc = m.get('baggage_desc')
        return self


class ModuleFlightItemListItemListShoppingItemMapValueSearchPricePriceShowInfo(TeaModel):
    def __init__(
        self,
        discount_info: str = None,
        discount_num: float = None,
        show_ticket_price: bool = None,
    ):
        self.discount_info = discount_info
        self.discount_num = discount_num
        self.show_ticket_price = show_ticket_price

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.discount_info is not None:
            result['discount_info'] = self.discount_info
        if self.discount_num is not None:
            result['discount_num'] = self.discount_num
        if self.show_ticket_price is not None:
            result['show_ticket_price'] = self.show_ticket_price
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('discount_info') is not None:
            self.discount_info = m.get('discount_info')
        if m.get('discount_num') is not None:
            self.discount_num = m.get('discount_num')
        if m.get('show_ticket_price') is not None:
            self.show_ticket_price = m.get('show_ticket_price')
        return self


class ModuleFlightItemListItemListShoppingItemMapValueSearchPrice(TeaModel):
    def __init__(
        self,
        floor_price: int = None,
        ticket_price: int = None,
        sell_price: int = None,
        original_sell_price: int = None,
        base_total_price: int = None,
        before_control_price: int = None,
        tax: int = None,
        supply_price: int = None,
        basic_cabin_price: int = None,
        build_price: int = None,
        oil_price: int = None,
        first_standard_price: int = None,
        business_standard_price: int = None,
        common_standard_price: int = None,
        inter_ticket_price: int = None,
        subtracted_price: int = None,
        origin_common_price: int = None,
        dynamic_promotion_price: int = None,
        installment_num: int = None,
        installment_price: float = None,
        competition_dynamic_price: int = None,
        competition_promotion_price: int = None,
        min_before_control_price_of_normal: int = None,
        price_show_info: ModuleFlightItemListItemListShoppingItemMapValueSearchPricePriceShowInfo = None,
    ):
        self.floor_price = floor_price
        self.ticket_price = ticket_price
        self.sell_price = sell_price
        self.original_sell_price = original_sell_price
        self.base_total_price = base_total_price
        self.before_control_price = before_control_price
        self.tax = tax
        self.supply_price = supply_price
        self.basic_cabin_price = basic_cabin_price
        self.build_price = build_price
        self.oil_price = oil_price
        self.first_standard_price = first_standard_price
        self.business_standard_price = business_standard_price
        self.common_standard_price = common_standard_price
        # fdPrice
        self.inter_ticket_price = inter_ticket_price
        self.subtracted_price = subtracted_price
        self.origin_common_price = origin_common_price
        self.dynamic_promotion_price = dynamic_promotion_price
        self.installment_num = installment_num
        self.installment_price = installment_price
        self.competition_dynamic_price = competition_dynamic_price
        self.competition_promotion_price = competition_promotion_price
        self.min_before_control_price_of_normal = min_before_control_price_of_normal
        self.price_show_info = price_show_info

    def validate(self):
        if self.price_show_info:
            self.price_show_info.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.floor_price is not None:
            result['floor_price'] = self.floor_price
        if self.ticket_price is not None:
            result['ticket_price'] = self.ticket_price
        if self.sell_price is not None:
            result['sell_price'] = self.sell_price
        if self.original_sell_price is not None:
            result['original_sell_price'] = self.original_sell_price
        if self.base_total_price is not None:
            result['base_total_price'] = self.base_total_price
        if self.before_control_price is not None:
            result['before_control_price'] = self.before_control_price
        if self.tax is not None:
            result['tax'] = self.tax
        if self.supply_price is not None:
            result['supply_price'] = self.supply_price
        if self.basic_cabin_price is not None:
            result['basic_cabin_price'] = self.basic_cabin_price
        if self.build_price is not None:
            result['build_price'] = self.build_price
        if self.oil_price is not None:
            result['oil_price'] = self.oil_price
        if self.first_standard_price is not None:
            result['first_standard_price'] = self.first_standard_price
        if self.business_standard_price is not None:
            result['business_standard_price'] = self.business_standard_price
        if self.common_standard_price is not None:
            result['common_standard_price'] = self.common_standard_price
        if self.inter_ticket_price is not None:
            result['inter_ticket_price'] = self.inter_ticket_price
        if self.subtracted_price is not None:
            result['subtracted_price'] = self.subtracted_price
        if self.origin_common_price is not None:
            result['origin_common_price'] = self.origin_common_price
        if self.dynamic_promotion_price is not None:
            result['dynamic_promotion_price'] = self.dynamic_promotion_price
        if self.installment_num is not None:
            result['installment_num'] = self.installment_num
        if self.installment_price is not None:
            result['installment_price'] = self.installment_price
        if self.competition_dynamic_price is not None:
            result['competition_dynamic_price'] = self.competition_dynamic_price
        if self.competition_promotion_price is not None:
            result['competition_promotion_price'] = self.competition_promotion_price
        if self.min_before_control_price_of_normal is not None:
            result['min_before_control_price_of_normal'] = self.min_before_control_price_of_normal
        if self.price_show_info is not None:
            result['price_show_info'] = self.price_show_info.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('floor_price') is not None:
            self.floor_price = m.get('floor_price')
        if m.get('ticket_price') is not None:
            self.ticket_price = m.get('ticket_price')
        if m.get('sell_price') is not None:
            self.sell_price = m.get('sell_price')
        if m.get('original_sell_price') is not None:
            self.original_sell_price = m.get('original_sell_price')
        if m.get('base_total_price') is not None:
            self.base_total_price = m.get('base_total_price')
        if m.get('before_control_price') is not None:
            self.before_control_price = m.get('before_control_price')
        if m.get('tax') is not None:
            self.tax = m.get('tax')
        if m.get('supply_price') is not None:
            self.supply_price = m.get('supply_price')
        if m.get('basic_cabin_price') is not None:
            self.basic_cabin_price = m.get('basic_cabin_price')
        if m.get('build_price') is not None:
            self.build_price = m.get('build_price')
        if m.get('oil_price') is not None:
            self.oil_price = m.get('oil_price')
        if m.get('first_standard_price') is not None:
            self.first_standard_price = m.get('first_standard_price')
        if m.get('business_standard_price') is not None:
            self.business_standard_price = m.get('business_standard_price')
        if m.get('common_standard_price') is not None:
            self.common_standard_price = m.get('common_standard_price')
        if m.get('inter_ticket_price') is not None:
            self.inter_ticket_price = m.get('inter_ticket_price')
        if m.get('subtracted_price') is not None:
            self.subtracted_price = m.get('subtracted_price')
        if m.get('origin_common_price') is not None:
            self.origin_common_price = m.get('origin_common_price')
        if m.get('dynamic_promotion_price') is not None:
            self.dynamic_promotion_price = m.get('dynamic_promotion_price')
        if m.get('installment_num') is not None:
            self.installment_num = m.get('installment_num')
        if m.get('installment_price') is not None:
            self.installment_price = m.get('installment_price')
        if m.get('competition_dynamic_price') is not None:
            self.competition_dynamic_price = m.get('competition_dynamic_price')
        if m.get('competition_promotion_price') is not None:
            self.competition_promotion_price = m.get('competition_promotion_price')
        if m.get('min_before_control_price_of_normal') is not None:
            self.min_before_control_price_of_normal = m.get('min_before_control_price_of_normal')
        if m.get('price_show_info') is not None:
            temp_model = ModuleFlightItemListItemListShoppingItemMapValueSearchPricePriceShowInfo()
            self.price_show_info = temp_model.from_map(m['price_show_info'])
        return self


class ModuleFlightItemListItemListShoppingItemMapValueCabinQuantityValue(TeaModel):
    def __init__(
        self,
        cabin: str = None,
        cabin_class: str = None,
        cabin_class_name: str = None,
        cabin_class_memo: str = None,
        specification: str = None,
        quantity: str = None,
        link_cabins: List[str] = None,
        reshop_change_cabin: bool = None,
        child_cabin_type: int = None,
        infant_basic_cabin: str = None,
        inner_cabin_class: int = None,
    ):
        self.cabin = cabin
        self.cabin_class = cabin_class
        self.cabin_class_name = cabin_class_name
        self.cabin_class_memo = cabin_class_memo
        self.specification = specification
        self.quantity = quantity
        self.link_cabins = link_cabins
        self.reshop_change_cabin = reshop_change_cabin
        self.child_cabin_type = child_cabin_type
        self.infant_basic_cabin = infant_basic_cabin
        self.inner_cabin_class = inner_cabin_class

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.cabin is not None:
            result['cabin'] = self.cabin
        if self.cabin_class is not None:
            result['cabin_class'] = self.cabin_class
        if self.cabin_class_name is not None:
            result['cabin_class_name'] = self.cabin_class_name
        if self.cabin_class_memo is not None:
            result['cabin_class_memo'] = self.cabin_class_memo
        if self.specification is not None:
            result['specification'] = self.specification
        if self.quantity is not None:
            result['quantity'] = self.quantity
        if self.link_cabins is not None:
            result['link_cabins'] = self.link_cabins
        if self.reshop_change_cabin is not None:
            result['reshop_change_cabin'] = self.reshop_change_cabin
        if self.child_cabin_type is not None:
            result['child_cabin_type'] = self.child_cabin_type
        if self.infant_basic_cabin is not None:
            result['infant_basic_cabin'] = self.infant_basic_cabin
        if self.inner_cabin_class is not None:
            result['inner_cabin_class'] = self.inner_cabin_class
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('cabin') is not None:
            self.cabin = m.get('cabin')
        if m.get('cabin_class') is not None:
            self.cabin_class = m.get('cabin_class')
        if m.get('cabin_class_name') is not None:
            self.cabin_class_name = m.get('cabin_class_name')
        if m.get('cabin_class_memo') is not None:
            self.cabin_class_memo = m.get('cabin_class_memo')
        if m.get('specification') is not None:
            self.specification = m.get('specification')
        if m.get('quantity') is not None:
            self.quantity = m.get('quantity')
        if m.get('link_cabins') is not None:
            self.link_cabins = m.get('link_cabins')
        if m.get('reshop_change_cabin') is not None:
            self.reshop_change_cabin = m.get('reshop_change_cabin')
        if m.get('child_cabin_type') is not None:
            self.child_cabin_type = m.get('child_cabin_type')
        if m.get('infant_basic_cabin') is not None:
            self.infant_basic_cabin = m.get('infant_basic_cabin')
        if m.get('inner_cabin_class') is not None:
            self.inner_cabin_class = m.get('inner_cabin_class')
        return self


class ModuleFlightItemListItemListShoppingItemMapValueSegmentPriceValuePriceShowInfo(TeaModel):
    def __init__(
        self,
        discount_info: str = None,
        discount_num: float = None,
        show_ticket_price: bool = None,
    ):
        self.discount_info = discount_info
        self.discount_num = discount_num
        self.show_ticket_price = show_ticket_price

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.discount_info is not None:
            result['discount_info'] = self.discount_info
        if self.discount_num is not None:
            result['discount_num'] = self.discount_num
        if self.show_ticket_price is not None:
            result['show_ticket_price'] = self.show_ticket_price
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('discount_info') is not None:
            self.discount_info = m.get('discount_info')
        if m.get('discount_num') is not None:
            self.discount_num = m.get('discount_num')
        if m.get('show_ticket_price') is not None:
            self.show_ticket_price = m.get('show_ticket_price')
        return self


class ModuleFlightItemListItemListShoppingItemMapValueSegmentPriceValue(TeaModel):
    def __init__(
        self,
        floor_price: int = None,
        ticket_price: int = None,
        sell_price: int = None,
        original_sell_price: int = None,
        base_total_price: int = None,
        before_control_price: int = None,
        tax: int = None,
        supply_price: int = None,
        basic_cabin_price: int = None,
        build_price: int = None,
        oil_price: int = None,
        first_standard_price: int = None,
        business_standard_price: int = None,
        common_standard_price: int = None,
        inter_ticket_price: int = None,
        subtracted_price: int = None,
        origin_common_price: int = None,
        dynamic_promotion_price: int = None,
        installment_num: int = None,
        installment_price: float = None,
        competition_dynamic_price: int = None,
        competition_promotion_price: int = None,
        min_before_control_price_of_normal: int = None,
        price_show_info: ModuleFlightItemListItemListShoppingItemMapValueSegmentPriceValuePriceShowInfo = None,
    ):
        self.floor_price = floor_price
        self.ticket_price = ticket_price
        self.sell_price = sell_price
        self.original_sell_price = original_sell_price
        self.base_total_price = base_total_price
        self.before_control_price = before_control_price
        self.tax = tax
        self.supply_price = supply_price
        self.basic_cabin_price = basic_cabin_price
        self.build_price = build_price
        self.oil_price = oil_price
        self.first_standard_price = first_standard_price
        self.business_standard_price = business_standard_price
        self.common_standard_price = common_standard_price
        # fdPrice
        self.inter_ticket_price = inter_ticket_price
        self.subtracted_price = subtracted_price
        self.origin_common_price = origin_common_price
        self.dynamic_promotion_price = dynamic_promotion_price
        self.installment_num = installment_num
        self.installment_price = installment_price
        self.competition_dynamic_price = competition_dynamic_price
        self.competition_promotion_price = competition_promotion_price
        self.min_before_control_price_of_normal = min_before_control_price_of_normal
        self.price_show_info = price_show_info

    def validate(self):
        if self.price_show_info:
            self.price_show_info.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.floor_price is not None:
            result['floor_price'] = self.floor_price
        if self.ticket_price is not None:
            result['ticket_price'] = self.ticket_price
        if self.sell_price is not None:
            result['sell_price'] = self.sell_price
        if self.original_sell_price is not None:
            result['original_sell_price'] = self.original_sell_price
        if self.base_total_price is not None:
            result['base_total_price'] = self.base_total_price
        if self.before_control_price is not None:
            result['before_control_price'] = self.before_control_price
        if self.tax is not None:
            result['tax'] = self.tax
        if self.supply_price is not None:
            result['supply_price'] = self.supply_price
        if self.basic_cabin_price is not None:
            result['basic_cabin_price'] = self.basic_cabin_price
        if self.build_price is not None:
            result['build_price'] = self.build_price
        if self.oil_price is not None:
            result['oil_price'] = self.oil_price
        if self.first_standard_price is not None:
            result['first_standard_price'] = self.first_standard_price
        if self.business_standard_price is not None:
            result['business_standard_price'] = self.business_standard_price
        if self.common_standard_price is not None:
            result['common_standard_price'] = self.common_standard_price
        if self.inter_ticket_price is not None:
            result['inter_ticket_price'] = self.inter_ticket_price
        if self.subtracted_price is not None:
            result['subtracted_price'] = self.subtracted_price
        if self.origin_common_price is not None:
            result['origin_common_price'] = self.origin_common_price
        if self.dynamic_promotion_price is not None:
            result['dynamic_promotion_price'] = self.dynamic_promotion_price
        if self.installment_num is not None:
            result['installment_num'] = self.installment_num
        if self.installment_price is not None:
            result['installment_price'] = self.installment_price
        if self.competition_dynamic_price is not None:
            result['competition_dynamic_price'] = self.competition_dynamic_price
        if self.competition_promotion_price is not None:
            result['competition_promotion_price'] = self.competition_promotion_price
        if self.min_before_control_price_of_normal is not None:
            result['min_before_control_price_of_normal'] = self.min_before_control_price_of_normal
        if self.price_show_info is not None:
            result['price_show_info'] = self.price_show_info.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('floor_price') is not None:
            self.floor_price = m.get('floor_price')
        if m.get('ticket_price') is not None:
            self.ticket_price = m.get('ticket_price')
        if m.get('sell_price') is not None:
            self.sell_price = m.get('sell_price')
        if m.get('original_sell_price') is not None:
            self.original_sell_price = m.get('original_sell_price')
        if m.get('base_total_price') is not None:
            self.base_total_price = m.get('base_total_price')
        if m.get('before_control_price') is not None:
            self.before_control_price = m.get('before_control_price')
        if m.get('tax') is not None:
            self.tax = m.get('tax')
        if m.get('supply_price') is not None:
            self.supply_price = m.get('supply_price')
        if m.get('basic_cabin_price') is not None:
            self.basic_cabin_price = m.get('basic_cabin_price')
        if m.get('build_price') is not None:
            self.build_price = m.get('build_price')
        if m.get('oil_price') is not None:
            self.oil_price = m.get('oil_price')
        if m.get('first_standard_price') is not None:
            self.first_standard_price = m.get('first_standard_price')
        if m.get('business_standard_price') is not None:
            self.business_standard_price = m.get('business_standard_price')
        if m.get('common_standard_price') is not None:
            self.common_standard_price = m.get('common_standard_price')
        if m.get('inter_ticket_price') is not None:
            self.inter_ticket_price = m.get('inter_ticket_price')
        if m.get('subtracted_price') is not None:
            self.subtracted_price = m.get('subtracted_price')
        if m.get('origin_common_price') is not None:
            self.origin_common_price = m.get('origin_common_price')
        if m.get('dynamic_promotion_price') is not None:
            self.dynamic_promotion_price = m.get('dynamic_promotion_price')
        if m.get('installment_num') is not None:
            self.installment_num = m.get('installment_num')
        if m.get('installment_price') is not None:
            self.installment_price = m.get('installment_price')
        if m.get('competition_dynamic_price') is not None:
            self.competition_dynamic_price = m.get('competition_dynamic_price')
        if m.get('competition_promotion_price') is not None:
            self.competition_promotion_price = m.get('competition_promotion_price')
        if m.get('min_before_control_price_of_normal') is not None:
            self.min_before_control_price_of_normal = m.get('min_before_control_price_of_normal')
        if m.get('price_show_info') is not None:
            temp_model = ModuleFlightItemListItemListShoppingItemMapValueSegmentPriceValuePriceShowInfo()
            self.price_show_info = temp_model.from_map(m['price_show_info'])
        return self


class ModuleFlightItemListItemListShoppingItemMapValue(TeaModel):
    def __init__(
        self,
        id: str = None,
        cabin_quantity: Dict[str, ModuleFlightItemListItemListShoppingItemMapValueCabinQuantityValue] = None,
        search_price: ModuleFlightItemListItemListShoppingItemMapValueSearchPrice = None,
        segment_price: Dict[str, ModuleFlightItemListItemListShoppingItemMapValueSegmentPriceValue] = None,
    ):
        # id
        self.id = id
        self.cabin_quantity = cabin_quantity
        self.search_price = search_price
        self.segment_price = segment_price

    def validate(self):
        if self.cabin_quantity:
            for v in self.cabin_quantity.values():
                if v:
                    v.validate()
        if self.search_price:
            self.search_price.validate()
        if self.segment_price:
            for v in self.segment_price.values():
                if v:
                    v.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.id is not None:
            result['id'] = self.id
        result['cabin_quantity'] = {}
        if self.cabin_quantity is not None:
            for k, v in self.cabin_quantity.items():
                result['cabin_quantity'][k] = v.to_map()
        if self.search_price is not None:
            result['search_price'] = self.search_price.to_map()
        result['segment_price'] = {}
        if self.segment_price is not None:
            for k, v in self.segment_price.items():
                result['segment_price'][k] = v.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('id') is not None:
            self.id = m.get('id')
        self.cabin_quantity = {}
        if m.get('cabin_quantity') is not None:
            for k, v in m.get('cabin_quantity').items():
                temp_model = ModuleFlightItemListItemListShoppingItemMapValueCabinQuantityValue()
                self.cabin_quantity[k] = temp_model.from_map(v)
        if m.get('search_price') is not None:
            temp_model = ModuleFlightItemListItemListShoppingItemMapValueSearchPrice()
            self.search_price = temp_model.from_map(m['search_price'])
        self.segment_price = {}
        if m.get('segment_price') is not None:
            for k, v in m.get('segment_price').items():
                temp_model = ModuleFlightItemListItemListShoppingItemMapValueSegmentPriceValue()
                self.segment_price[k] = temp_model.from_map(v)
        return self


class ModuleFlightItemListItemListSubItemPositionMapValue(TeaModel):
    def __init__(
        self,
        journey_index: int = None,
        segment_index: int = None,
    ):
        self.journey_index = journey_index
        self.segment_index = segment_index

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.journey_index is not None:
            result['journey_index'] = self.journey_index
        if self.segment_index is not None:
            result['segment_index'] = self.segment_index
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('journey_index') is not None:
            self.journey_index = m.get('journey_index')
        if m.get('segment_index') is not None:
            self.segment_index = m.get('segment_index')
        return self


class ModuleFlightItemListItemListSubItemsShoppingItemMapValueSearchPricePriceShowInfo(TeaModel):
    def __init__(
        self,
        discount_info: str = None,
        discount_num: float = None,
        show_ticket_price: bool = None,
    ):
        self.discount_info = discount_info
        self.discount_num = discount_num
        self.show_ticket_price = show_ticket_price

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.discount_info is not None:
            result['discount_info'] = self.discount_info
        if self.discount_num is not None:
            result['discount_num'] = self.discount_num
        if self.show_ticket_price is not None:
            result['show_ticket_price'] = self.show_ticket_price
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('discount_info') is not None:
            self.discount_info = m.get('discount_info')
        if m.get('discount_num') is not None:
            self.discount_num = m.get('discount_num')
        if m.get('show_ticket_price') is not None:
            self.show_ticket_price = m.get('show_ticket_price')
        return self


class ModuleFlightItemListItemListSubItemsShoppingItemMapValueSearchPrice(TeaModel):
    def __init__(
        self,
        floor_price: int = None,
        ticket_price: int = None,
        sell_price: int = None,
        original_sell_price: int = None,
        base_total_price: int = None,
        before_control_price: int = None,
        tax: int = None,
        supply_price: int = None,
        basic_cabin_price: int = None,
        build_price: int = None,
        oil_price: int = None,
        first_standard_price: int = None,
        business_standard_price: int = None,
        common_standard_price: int = None,
        inter_ticket_price: int = None,
        subtracted_price: int = None,
        origin_common_price: int = None,
        dynamic_promotion_price: int = None,
        installment_num: int = None,
        installment_price: float = None,
        competition_dynamic_price: int = None,
        competition_promotion_price: int = None,
        min_before_control_price_of_normal: int = None,
        price_show_info: ModuleFlightItemListItemListSubItemsShoppingItemMapValueSearchPricePriceShowInfo = None,
    ):
        self.floor_price = floor_price
        self.ticket_price = ticket_price
        self.sell_price = sell_price
        self.original_sell_price = original_sell_price
        self.base_total_price = base_total_price
        self.before_control_price = before_control_price
        self.tax = tax
        self.supply_price = supply_price
        self.basic_cabin_price = basic_cabin_price
        self.build_price = build_price
        self.oil_price = oil_price
        self.first_standard_price = first_standard_price
        self.business_standard_price = business_standard_price
        self.common_standard_price = common_standard_price
        # fdPrice
        self.inter_ticket_price = inter_ticket_price
        self.subtracted_price = subtracted_price
        self.origin_common_price = origin_common_price
        self.dynamic_promotion_price = dynamic_promotion_price
        self.installment_num = installment_num
        self.installment_price = installment_price
        self.competition_dynamic_price = competition_dynamic_price
        self.competition_promotion_price = competition_promotion_price
        self.min_before_control_price_of_normal = min_before_control_price_of_normal
        self.price_show_info = price_show_info

    def validate(self):
        if self.price_show_info:
            self.price_show_info.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.floor_price is not None:
            result['floor_price'] = self.floor_price
        if self.ticket_price is not None:
            result['ticket_price'] = self.ticket_price
        if self.sell_price is not None:
            result['sell_price'] = self.sell_price
        if self.original_sell_price is not None:
            result['original_sell_price'] = self.original_sell_price
        if self.base_total_price is not None:
            result['base_total_price'] = self.base_total_price
        if self.before_control_price is not None:
            result['before_control_price'] = self.before_control_price
        if self.tax is not None:
            result['tax'] = self.tax
        if self.supply_price is not None:
            result['supply_price'] = self.supply_price
        if self.basic_cabin_price is not None:
            result['basic_cabin_price'] = self.basic_cabin_price
        if self.build_price is not None:
            result['build_price'] = self.build_price
        if self.oil_price is not None:
            result['oil_price'] = self.oil_price
        if self.first_standard_price is not None:
            result['first_standard_price'] = self.first_standard_price
        if self.business_standard_price is not None:
            result['business_standard_price'] = self.business_standard_price
        if self.common_standard_price is not None:
            result['common_standard_price'] = self.common_standard_price
        if self.inter_ticket_price is not None:
            result['inter_ticket_price'] = self.inter_ticket_price
        if self.subtracted_price is not None:
            result['subtracted_price'] = self.subtracted_price
        if self.origin_common_price is not None:
            result['origin_common_price'] = self.origin_common_price
        if self.dynamic_promotion_price is not None:
            result['dynamic_promotion_price'] = self.dynamic_promotion_price
        if self.installment_num is not None:
            result['installment_num'] = self.installment_num
        if self.installment_price is not None:
            result['installment_price'] = self.installment_price
        if self.competition_dynamic_price is not None:
            result['competition_dynamic_price'] = self.competition_dynamic_price
        if self.competition_promotion_price is not None:
            result['competition_promotion_price'] = self.competition_promotion_price
        if self.min_before_control_price_of_normal is not None:
            result['min_before_control_price_of_normal'] = self.min_before_control_price_of_normal
        if self.price_show_info is not None:
            result['price_show_info'] = self.price_show_info.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('floor_price') is not None:
            self.floor_price = m.get('floor_price')
        if m.get('ticket_price') is not None:
            self.ticket_price = m.get('ticket_price')
        if m.get('sell_price') is not None:
            self.sell_price = m.get('sell_price')
        if m.get('original_sell_price') is not None:
            self.original_sell_price = m.get('original_sell_price')
        if m.get('base_total_price') is not None:
            self.base_total_price = m.get('base_total_price')
        if m.get('before_control_price') is not None:
            self.before_control_price = m.get('before_control_price')
        if m.get('tax') is not None:
            self.tax = m.get('tax')
        if m.get('supply_price') is not None:
            self.supply_price = m.get('supply_price')
        if m.get('basic_cabin_price') is not None:
            self.basic_cabin_price = m.get('basic_cabin_price')
        if m.get('build_price') is not None:
            self.build_price = m.get('build_price')
        if m.get('oil_price') is not None:
            self.oil_price = m.get('oil_price')
        if m.get('first_standard_price') is not None:
            self.first_standard_price = m.get('first_standard_price')
        if m.get('business_standard_price') is not None:
            self.business_standard_price = m.get('business_standard_price')
        if m.get('common_standard_price') is not None:
            self.common_standard_price = m.get('common_standard_price')
        if m.get('inter_ticket_price') is not None:
            self.inter_ticket_price = m.get('inter_ticket_price')
        if m.get('subtracted_price') is not None:
            self.subtracted_price = m.get('subtracted_price')
        if m.get('origin_common_price') is not None:
            self.origin_common_price = m.get('origin_common_price')
        if m.get('dynamic_promotion_price') is not None:
            self.dynamic_promotion_price = m.get('dynamic_promotion_price')
        if m.get('installment_num') is not None:
            self.installment_num = m.get('installment_num')
        if m.get('installment_price') is not None:
            self.installment_price = m.get('installment_price')
        if m.get('competition_dynamic_price') is not None:
            self.competition_dynamic_price = m.get('competition_dynamic_price')
        if m.get('competition_promotion_price') is not None:
            self.competition_promotion_price = m.get('competition_promotion_price')
        if m.get('min_before_control_price_of_normal') is not None:
            self.min_before_control_price_of_normal = m.get('min_before_control_price_of_normal')
        if m.get('price_show_info') is not None:
            temp_model = ModuleFlightItemListItemListSubItemsShoppingItemMapValueSearchPricePriceShowInfo()
            self.price_show_info = temp_model.from_map(m['price_show_info'])
        return self


class ModuleFlightItemListItemListSubItemsShoppingItemMapValueCabinQuantityValue(TeaModel):
    def __init__(
        self,
        cabin: str = None,
        cabin_class: str = None,
        cabin_class_name: str = None,
        cabin_class_memo: str = None,
        specification: str = None,
        quantity: str = None,
        link_cabins: List[str] = None,
        reshop_change_cabin: bool = None,
        child_cabin_type: int = None,
        infant_basic_cabin: str = None,
        inner_cabin_class: int = None,
    ):
        self.cabin = cabin
        self.cabin_class = cabin_class
        self.cabin_class_name = cabin_class_name
        self.cabin_class_memo = cabin_class_memo
        self.specification = specification
        self.quantity = quantity
        self.link_cabins = link_cabins
        self.reshop_change_cabin = reshop_change_cabin
        self.child_cabin_type = child_cabin_type
        self.infant_basic_cabin = infant_basic_cabin
        self.inner_cabin_class = inner_cabin_class

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.cabin is not None:
            result['cabin'] = self.cabin
        if self.cabin_class is not None:
            result['cabin_class'] = self.cabin_class
        if self.cabin_class_name is not None:
            result['cabin_class_name'] = self.cabin_class_name
        if self.cabin_class_memo is not None:
            result['cabin_class_memo'] = self.cabin_class_memo
        if self.specification is not None:
            result['specification'] = self.specification
        if self.quantity is not None:
            result['quantity'] = self.quantity
        if self.link_cabins is not None:
            result['link_cabins'] = self.link_cabins
        if self.reshop_change_cabin is not None:
            result['reshop_change_cabin'] = self.reshop_change_cabin
        if self.child_cabin_type is not None:
            result['child_cabin_type'] = self.child_cabin_type
        if self.infant_basic_cabin is not None:
            result['infant_basic_cabin'] = self.infant_basic_cabin
        if self.inner_cabin_class is not None:
            result['inner_cabin_class'] = self.inner_cabin_class
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('cabin') is not None:
            self.cabin = m.get('cabin')
        if m.get('cabin_class') is not None:
            self.cabin_class = m.get('cabin_class')
        if m.get('cabin_class_name') is not None:
            self.cabin_class_name = m.get('cabin_class_name')
        if m.get('cabin_class_memo') is not None:
            self.cabin_class_memo = m.get('cabin_class_memo')
        if m.get('specification') is not None:
            self.specification = m.get('specification')
        if m.get('quantity') is not None:
            self.quantity = m.get('quantity')
        if m.get('link_cabins') is not None:
            self.link_cabins = m.get('link_cabins')
        if m.get('reshop_change_cabin') is not None:
            self.reshop_change_cabin = m.get('reshop_change_cabin')
        if m.get('child_cabin_type') is not None:
            self.child_cabin_type = m.get('child_cabin_type')
        if m.get('infant_basic_cabin') is not None:
            self.infant_basic_cabin = m.get('infant_basic_cabin')
        if m.get('inner_cabin_class') is not None:
            self.inner_cabin_class = m.get('inner_cabin_class')
        return self


class ModuleFlightItemListItemListSubItemsShoppingItemMapValueSegmentPriceValuePriceShowInfo(TeaModel):
    def __init__(
        self,
        discount_info: str = None,
        discount_num: float = None,
        show_ticket_price: bool = None,
    ):
        self.discount_info = discount_info
        self.discount_num = discount_num
        self.show_ticket_price = show_ticket_price

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.discount_info is not None:
            result['discount_info'] = self.discount_info
        if self.discount_num is not None:
            result['discount_num'] = self.discount_num
        if self.show_ticket_price is not None:
            result['show_ticket_price'] = self.show_ticket_price
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('discount_info') is not None:
            self.discount_info = m.get('discount_info')
        if m.get('discount_num') is not None:
            self.discount_num = m.get('discount_num')
        if m.get('show_ticket_price') is not None:
            self.show_ticket_price = m.get('show_ticket_price')
        return self


class ModuleFlightItemListItemListSubItemsShoppingItemMapValueSegmentPriceValue(TeaModel):
    def __init__(
        self,
        floor_price: int = None,
        ticket_price: int = None,
        sell_price: int = None,
        original_sell_price: int = None,
        base_total_price: int = None,
        before_control_price: int = None,
        tax: int = None,
        supply_price: int = None,
        basic_cabin_price: int = None,
        build_price: int = None,
        oil_price: int = None,
        first_standard_price: int = None,
        business_standard_price: int = None,
        common_standard_price: int = None,
        inter_ticket_price: int = None,
        subtracted_price: int = None,
        origin_common_price: int = None,
        dynamic_promotion_price: int = None,
        installment_num: int = None,
        installment_price: float = None,
        competition_dynamic_price: int = None,
        competition_promotion_price: int = None,
        min_before_control_price_of_normal: int = None,
        price_show_info: ModuleFlightItemListItemListSubItemsShoppingItemMapValueSegmentPriceValuePriceShowInfo = None,
    ):
        self.floor_price = floor_price
        self.ticket_price = ticket_price
        self.sell_price = sell_price
        self.original_sell_price = original_sell_price
        self.base_total_price = base_total_price
        self.before_control_price = before_control_price
        self.tax = tax
        self.supply_price = supply_price
        self.basic_cabin_price = basic_cabin_price
        self.build_price = build_price
        self.oil_price = oil_price
        self.first_standard_price = first_standard_price
        self.business_standard_price = business_standard_price
        self.common_standard_price = common_standard_price
        # fdPrice
        self.inter_ticket_price = inter_ticket_price
        self.subtracted_price = subtracted_price
        self.origin_common_price = origin_common_price
        self.dynamic_promotion_price = dynamic_promotion_price
        self.installment_num = installment_num
        self.installment_price = installment_price
        self.competition_dynamic_price = competition_dynamic_price
        self.competition_promotion_price = competition_promotion_price
        self.min_before_control_price_of_normal = min_before_control_price_of_normal
        self.price_show_info = price_show_info

    def validate(self):
        if self.price_show_info:
            self.price_show_info.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.floor_price is not None:
            result['floor_price'] = self.floor_price
        if self.ticket_price is not None:
            result['ticket_price'] = self.ticket_price
        if self.sell_price is not None:
            result['sell_price'] = self.sell_price
        if self.original_sell_price is not None:
            result['original_sell_price'] = self.original_sell_price
        if self.base_total_price is not None:
            result['base_total_price'] = self.base_total_price
        if self.before_control_price is not None:
            result['before_control_price'] = self.before_control_price
        if self.tax is not None:
            result['tax'] = self.tax
        if self.supply_price is not None:
            result['supply_price'] = self.supply_price
        if self.basic_cabin_price is not None:
            result['basic_cabin_price'] = self.basic_cabin_price
        if self.build_price is not None:
            result['build_price'] = self.build_price
        if self.oil_price is not None:
            result['oil_price'] = self.oil_price
        if self.first_standard_price is not None:
            result['first_standard_price'] = self.first_standard_price
        if self.business_standard_price is not None:
            result['business_standard_price'] = self.business_standard_price
        if self.common_standard_price is not None:
            result['common_standard_price'] = self.common_standard_price
        if self.inter_ticket_price is not None:
            result['inter_ticket_price'] = self.inter_ticket_price
        if self.subtracted_price is not None:
            result['subtracted_price'] = self.subtracted_price
        if self.origin_common_price is not None:
            result['origin_common_price'] = self.origin_common_price
        if self.dynamic_promotion_price is not None:
            result['dynamic_promotion_price'] = self.dynamic_promotion_price
        if self.installment_num is not None:
            result['installment_num'] = self.installment_num
        if self.installment_price is not None:
            result['installment_price'] = self.installment_price
        if self.competition_dynamic_price is not None:
            result['competition_dynamic_price'] = self.competition_dynamic_price
        if self.competition_promotion_price is not None:
            result['competition_promotion_price'] = self.competition_promotion_price
        if self.min_before_control_price_of_normal is not None:
            result['min_before_control_price_of_normal'] = self.min_before_control_price_of_normal
        if self.price_show_info is not None:
            result['price_show_info'] = self.price_show_info.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('floor_price') is not None:
            self.floor_price = m.get('floor_price')
        if m.get('ticket_price') is not None:
            self.ticket_price = m.get('ticket_price')
        if m.get('sell_price') is not None:
            self.sell_price = m.get('sell_price')
        if m.get('original_sell_price') is not None:
            self.original_sell_price = m.get('original_sell_price')
        if m.get('base_total_price') is not None:
            self.base_total_price = m.get('base_total_price')
        if m.get('before_control_price') is not None:
            self.before_control_price = m.get('before_control_price')
        if m.get('tax') is not None:
            self.tax = m.get('tax')
        if m.get('supply_price') is not None:
            self.supply_price = m.get('supply_price')
        if m.get('basic_cabin_price') is not None:
            self.basic_cabin_price = m.get('basic_cabin_price')
        if m.get('build_price') is not None:
            self.build_price = m.get('build_price')
        if m.get('oil_price') is not None:
            self.oil_price = m.get('oil_price')
        if m.get('first_standard_price') is not None:
            self.first_standard_price = m.get('first_standard_price')
        if m.get('business_standard_price') is not None:
            self.business_standard_price = m.get('business_standard_price')
        if m.get('common_standard_price') is not None:
            self.common_standard_price = m.get('common_standard_price')
        if m.get('inter_ticket_price') is not None:
            self.inter_ticket_price = m.get('inter_ticket_price')
        if m.get('subtracted_price') is not None:
            self.subtracted_price = m.get('subtracted_price')
        if m.get('origin_common_price') is not None:
            self.origin_common_price = m.get('origin_common_price')
        if m.get('dynamic_promotion_price') is not None:
            self.dynamic_promotion_price = m.get('dynamic_promotion_price')
        if m.get('installment_num') is not None:
            self.installment_num = m.get('installment_num')
        if m.get('installment_price') is not None:
            self.installment_price = m.get('installment_price')
        if m.get('competition_dynamic_price') is not None:
            self.competition_dynamic_price = m.get('competition_dynamic_price')
        if m.get('competition_promotion_price') is not None:
            self.competition_promotion_price = m.get('competition_promotion_price')
        if m.get('min_before_control_price_of_normal') is not None:
            self.min_before_control_price_of_normal = m.get('min_before_control_price_of_normal')
        if m.get('price_show_info') is not None:
            temp_model = ModuleFlightItemListItemListSubItemsShoppingItemMapValueSegmentPriceValuePriceShowInfo()
            self.price_show_info = temp_model.from_map(m['price_show_info'])
        return self


class ModuleFlightItemListItemListSubItemsShoppingItemMapValue(TeaModel):
    def __init__(
        self,
        id: str = None,
        cabin_quantity: Dict[str, ModuleFlightItemListItemListSubItemsShoppingItemMapValueCabinQuantityValue] = None,
        search_price: ModuleFlightItemListItemListSubItemsShoppingItemMapValueSearchPrice = None,
        segment_price: Dict[str, ModuleFlightItemListItemListSubItemsShoppingItemMapValueSegmentPriceValue] = None,
    ):
        # id
        self.id = id
        self.cabin_quantity = cabin_quantity
        self.search_price = search_price
        self.segment_price = segment_price

    def validate(self):
        if self.cabin_quantity:
            for v in self.cabin_quantity.values():
                if v:
                    v.validate()
        if self.search_price:
            self.search_price.validate()
        if self.segment_price:
            for v in self.segment_price.values():
                if v:
                    v.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.id is not None:
            result['id'] = self.id
        result['cabin_quantity'] = {}
        if self.cabin_quantity is not None:
            for k, v in self.cabin_quantity.items():
                result['cabin_quantity'][k] = v.to_map()
        if self.search_price is not None:
            result['search_price'] = self.search_price.to_map()
        result['segment_price'] = {}
        if self.segment_price is not None:
            for k, v in self.segment_price.items():
                result['segment_price'][k] = v.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('id') is not None:
            self.id = m.get('id')
        self.cabin_quantity = {}
        if m.get('cabin_quantity') is not None:
            for k, v in m.get('cabin_quantity').items():
                temp_model = ModuleFlightItemListItemListSubItemsShoppingItemMapValueCabinQuantityValue()
                self.cabin_quantity[k] = temp_model.from_map(v)
        if m.get('search_price') is not None:
            temp_model = ModuleFlightItemListItemListSubItemsShoppingItemMapValueSearchPrice()
            self.search_price = temp_model.from_map(m['search_price'])
        self.segment_price = {}
        if m.get('segment_price') is not None:
            for k, v in m.get('segment_price').items():
                temp_model = ModuleFlightItemListItemListSubItemsShoppingItemMapValueSegmentPriceValue()
                self.segment_price[k] = temp_model.from_map(v)
        return self


class ModuleAgentInfosAttributeShowInfoMapValue(TeaModel):
    def __init__(
        self,
        code: str = None,
        name: str = None,
        text: str = None,
    ):
        self.code = code
        self.name = name
        self.text = text

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['code'] = self.code
        if self.name is not None:
            result['name'] = self.name
        if self.text is not None:
            result['text'] = self.text
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('code') is not None:
            self.code = m.get('code')
        if m.get('name') is not None:
            self.name = m.get('name')
        if m.get('text') is not None:
            self.text = m.get('text')
        return self


class ModuleAgentInfoAttributeShowInfoMapValue(TeaModel):
    def __init__(
        self,
        code: str = None,
        name: str = None,
        text: str = None,
    ):
        self.code = code
        self.name = name
        self.text = text

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['code'] = self.code
        if self.name is not None:
            result['name'] = self.name
        if self.text is not None:
            result['text'] = self.text
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('code') is not None:
            self.code = m.get('code')
        if m.get('name') is not None:
            self.name = m.get('name')
        if m.get('text') is not None:
            self.text = m.get('text')
        return self


class ModuleItemListFlightRuleInfosValue(TeaModel):
    def __init__(
        self,
        refund_change_rule_desc: str = None,
        baggage_desc: str = None,
    ):
        self.refund_change_rule_desc = refund_change_rule_desc
        self.baggage_desc = baggage_desc

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.refund_change_rule_desc is not None:
            result['refund_change_rule_desc'] = self.refund_change_rule_desc
        if self.baggage_desc is not None:
            result['baggage_desc'] = self.baggage_desc
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('refund_change_rule_desc') is not None:
            self.refund_change_rule_desc = m.get('refund_change_rule_desc')
        if m.get('baggage_desc') is not None:
            self.baggage_desc = m.get('baggage_desc')
        return self


class ModuleItemListShoppingItemMapValueCabinQuantityListSegmentPosition(TeaModel):
    def __init__(
        self,
        journey_index: int = None,
        segment_index: int = None,
    ):
        self.journey_index = journey_index
        self.segment_index = segment_index

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.journey_index is not None:
            result['journey_index'] = self.journey_index
        if self.segment_index is not None:
            result['segment_index'] = self.segment_index
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('journey_index') is not None:
            self.journey_index = m.get('journey_index')
        if m.get('segment_index') is not None:
            self.segment_index = m.get('segment_index')
        return self


class ModuleItemListShoppingItemMapValueCabinQuantityListCabinInfo(TeaModel):
    def __init__(
        self,
        cabin: str = None,
        cabin_class: str = None,
        cabin_class_name: str = None,
        quantity: str = None,
    ):
        self.cabin = cabin
        self.cabin_class = cabin_class
        self.cabin_class_name = cabin_class_name
        self.quantity = quantity

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.cabin is not None:
            result['cabin'] = self.cabin
        if self.cabin_class is not None:
            result['cabin_class'] = self.cabin_class
        if self.cabin_class_name is not None:
            result['cabin_class_name'] = self.cabin_class_name
        if self.quantity is not None:
            result['quantity'] = self.quantity
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('cabin') is not None:
            self.cabin = m.get('cabin')
        if m.get('cabin_class') is not None:
            self.cabin_class = m.get('cabin_class')
        if m.get('cabin_class_name') is not None:
            self.cabin_class_name = m.get('cabin_class_name')
        if m.get('quantity') is not None:
            self.quantity = m.get('quantity')
        return self


class ModuleItemListShoppingItemMapValueCabinQuantityList(TeaModel):
    def __init__(
        self,
        segment_position: ModuleItemListShoppingItemMapValueCabinQuantityListSegmentPosition = None,
        cabin_info: ModuleItemListShoppingItemMapValueCabinQuantityListCabinInfo = None,
    ):
        self.segment_position = segment_position
        self.cabin_info = cabin_info

    def validate(self):
        if self.segment_position:
            self.segment_position.validate()
        if self.cabin_info:
            self.cabin_info.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.segment_position is not None:
            result['segment_position'] = self.segment_position.to_map()
        if self.cabin_info is not None:
            result['cabin_info'] = self.cabin_info.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('segment_position') is not None:
            temp_model = ModuleItemListShoppingItemMapValueCabinQuantityListSegmentPosition()
            self.segment_position = temp_model.from_map(m['segment_position'])
        if m.get('cabin_info') is not None:
            temp_model = ModuleItemListShoppingItemMapValueCabinQuantityListCabinInfo()
            self.cabin_info = temp_model.from_map(m['cabin_info'])
        return self


class ModuleItemListShoppingItemMapValueSearchPricePriceShowInfo(TeaModel):
    def __init__(
        self,
        discount_info: str = None,
        discount_num: float = None,
        show_ticket_price: bool = None,
    ):
        self.discount_info = discount_info
        self.discount_num = discount_num
        self.show_ticket_price = show_ticket_price

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.discount_info is not None:
            result['discount_info'] = self.discount_info
        if self.discount_num is not None:
            result['discount_num'] = self.discount_num
        if self.show_ticket_price is not None:
            result['show_ticket_price'] = self.show_ticket_price
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('discount_info') is not None:
            self.discount_info = m.get('discount_info')
        if m.get('discount_num') is not None:
            self.discount_num = m.get('discount_num')
        if m.get('show_ticket_price') is not None:
            self.show_ticket_price = m.get('show_ticket_price')
        return self


class ModuleItemListShoppingItemMapValueSearchPrice(TeaModel):
    def __init__(
        self,
        floor_price: int = None,
        ticket_price: int = None,
        sell_price: int = None,
        original_sell_price: int = None,
        base_total_price: int = None,
        before_control_price: int = None,
        tax: int = None,
        supply_price: int = None,
        basic_cabin_price: int = None,
        build_price: int = None,
        oil_price: int = None,
        first_standard_price: int = None,
        business_standard_price: int = None,
        common_standard_price: int = None,
        inter_ticket_price: int = None,
        subtracted_price: int = None,
        origin_common_price: int = None,
        dynamic_promotion_price: int = None,
        installment_num: int = None,
        installment_price: float = None,
        competition_dynamic_price: int = None,
        competition_promotion_price: int = None,
        min_before_control_price_of_normal: int = None,
        price_show_info: ModuleItemListShoppingItemMapValueSearchPricePriceShowInfo = None,
    ):
        self.floor_price = floor_price
        self.ticket_price = ticket_price
        self.sell_price = sell_price
        self.original_sell_price = original_sell_price
        self.base_total_price = base_total_price
        self.before_control_price = before_control_price
        self.tax = tax
        self.supply_price = supply_price
        self.basic_cabin_price = basic_cabin_price
        self.build_price = build_price
        self.oil_price = oil_price
        self.first_standard_price = first_standard_price
        self.business_standard_price = business_standard_price
        self.common_standard_price = common_standard_price
        # fdPrice
        self.inter_ticket_price = inter_ticket_price
        self.subtracted_price = subtracted_price
        self.origin_common_price = origin_common_price
        self.dynamic_promotion_price = dynamic_promotion_price
        self.installment_num = installment_num
        self.installment_price = installment_price
        self.competition_dynamic_price = competition_dynamic_price
        self.competition_promotion_price = competition_promotion_price
        self.min_before_control_price_of_normal = min_before_control_price_of_normal
        self.price_show_info = price_show_info

    def validate(self):
        if self.price_show_info:
            self.price_show_info.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.floor_price is not None:
            result['floor_price'] = self.floor_price
        if self.ticket_price is not None:
            result['ticket_price'] = self.ticket_price
        if self.sell_price is not None:
            result['sell_price'] = self.sell_price
        if self.original_sell_price is not None:
            result['original_sell_price'] = self.original_sell_price
        if self.base_total_price is not None:
            result['base_total_price'] = self.base_total_price
        if self.before_control_price is not None:
            result['before_control_price'] = self.before_control_price
        if self.tax is not None:
            result['tax'] = self.tax
        if self.supply_price is not None:
            result['supply_price'] = self.supply_price
        if self.basic_cabin_price is not None:
            result['basic_cabin_price'] = self.basic_cabin_price
        if self.build_price is not None:
            result['build_price'] = self.build_price
        if self.oil_price is not None:
            result['oil_price'] = self.oil_price
        if self.first_standard_price is not None:
            result['first_standard_price'] = self.first_standard_price
        if self.business_standard_price is not None:
            result['business_standard_price'] = self.business_standard_price
        if self.common_standard_price is not None:
            result['common_standard_price'] = self.common_standard_price
        if self.inter_ticket_price is not None:
            result['inter_ticket_price'] = self.inter_ticket_price
        if self.subtracted_price is not None:
            result['subtracted_price'] = self.subtracted_price
        if self.origin_common_price is not None:
            result['origin_common_price'] = self.origin_common_price
        if self.dynamic_promotion_price is not None:
            result['dynamic_promotion_price'] = self.dynamic_promotion_price
        if self.installment_num is not None:
            result['installment_num'] = self.installment_num
        if self.installment_price is not None:
            result['installment_price'] = self.installment_price
        if self.competition_dynamic_price is not None:
            result['competition_dynamic_price'] = self.competition_dynamic_price
        if self.competition_promotion_price is not None:
            result['competition_promotion_price'] = self.competition_promotion_price
        if self.min_before_control_price_of_normal is not None:
            result['min_before_control_price_of_normal'] = self.min_before_control_price_of_normal
        if self.price_show_info is not None:
            result['price_show_info'] = self.price_show_info.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('floor_price') is not None:
            self.floor_price = m.get('floor_price')
        if m.get('ticket_price') is not None:
            self.ticket_price = m.get('ticket_price')
        if m.get('sell_price') is not None:
            self.sell_price = m.get('sell_price')
        if m.get('original_sell_price') is not None:
            self.original_sell_price = m.get('original_sell_price')
        if m.get('base_total_price') is not None:
            self.base_total_price = m.get('base_total_price')
        if m.get('before_control_price') is not None:
            self.before_control_price = m.get('before_control_price')
        if m.get('tax') is not None:
            self.tax = m.get('tax')
        if m.get('supply_price') is not None:
            self.supply_price = m.get('supply_price')
        if m.get('basic_cabin_price') is not None:
            self.basic_cabin_price = m.get('basic_cabin_price')
        if m.get('build_price') is not None:
            self.build_price = m.get('build_price')
        if m.get('oil_price') is not None:
            self.oil_price = m.get('oil_price')
        if m.get('first_standard_price') is not None:
            self.first_standard_price = m.get('first_standard_price')
        if m.get('business_standard_price') is not None:
            self.business_standard_price = m.get('business_standard_price')
        if m.get('common_standard_price') is not None:
            self.common_standard_price = m.get('common_standard_price')
        if m.get('inter_ticket_price') is not None:
            self.inter_ticket_price = m.get('inter_ticket_price')
        if m.get('subtracted_price') is not None:
            self.subtracted_price = m.get('subtracted_price')
        if m.get('origin_common_price') is not None:
            self.origin_common_price = m.get('origin_common_price')
        if m.get('dynamic_promotion_price') is not None:
            self.dynamic_promotion_price = m.get('dynamic_promotion_price')
        if m.get('installment_num') is not None:
            self.installment_num = m.get('installment_num')
        if m.get('installment_price') is not None:
            self.installment_price = m.get('installment_price')
        if m.get('competition_dynamic_price') is not None:
            self.competition_dynamic_price = m.get('competition_dynamic_price')
        if m.get('competition_promotion_price') is not None:
            self.competition_promotion_price = m.get('competition_promotion_price')
        if m.get('min_before_control_price_of_normal') is not None:
            self.min_before_control_price_of_normal = m.get('min_before_control_price_of_normal')
        if m.get('price_show_info') is not None:
            temp_model = ModuleItemListShoppingItemMapValueSearchPricePriceShowInfo()
            self.price_show_info = temp_model.from_map(m['price_show_info'])
        return self


class ModuleItemListShoppingItemMapValueSegmentPriceListSegmentPosition(TeaModel):
    def __init__(
        self,
        journey_index: int = None,
        segment_index: int = None,
    ):
        self.journey_index = journey_index
        self.segment_index = segment_index

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.journey_index is not None:
            result['journey_index'] = self.journey_index
        if self.segment_index is not None:
            result['segment_index'] = self.segment_index
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('journey_index') is not None:
            self.journey_index = m.get('journey_index')
        if m.get('segment_index') is not None:
            self.segment_index = m.get('segment_index')
        return self


class ModuleItemListShoppingItemMapValueSegmentPriceListSearchPrice(TeaModel):
    def __init__(
        self,
        sell_price: int = None,
        ticket_price: int = None,
        tax: int = None,
    ):
        self.sell_price = sell_price
        self.ticket_price = ticket_price
        self.tax = tax

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.sell_price is not None:
            result['sell_price'] = self.sell_price
        if self.ticket_price is not None:
            result['ticket_price'] = self.ticket_price
        if self.tax is not None:
            result['tax'] = self.tax
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('sell_price') is not None:
            self.sell_price = m.get('sell_price')
        if m.get('ticket_price') is not None:
            self.ticket_price = m.get('ticket_price')
        if m.get('tax') is not None:
            self.tax = m.get('tax')
        return self


class ModuleItemListShoppingItemMapValueSegmentPriceList(TeaModel):
    def __init__(
        self,
        segment_position: ModuleItemListShoppingItemMapValueSegmentPriceListSegmentPosition = None,
        search_price: ModuleItemListShoppingItemMapValueSegmentPriceListSearchPrice = None,
    ):
        self.segment_position = segment_position
        self.search_price = search_price

    def validate(self):
        if self.segment_position:
            self.segment_position.validate()
        if self.search_price:
            self.search_price.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.segment_position is not None:
            result['segment_position'] = self.segment_position.to_map()
        if self.search_price is not None:
            result['search_price'] = self.search_price.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('segment_position') is not None:
            temp_model = ModuleItemListShoppingItemMapValueSegmentPriceListSegmentPosition()
            self.segment_position = temp_model.from_map(m['segment_position'])
        if m.get('search_price') is not None:
            temp_model = ModuleItemListShoppingItemMapValueSegmentPriceListSearchPrice()
            self.search_price = temp_model.from_map(m['search_price'])
        return self


class ModuleItemListShoppingItemMapValueCabinQuantityValue(TeaModel):
    def __init__(
        self,
        cabin: str = None,
        cabin_class: str = None,
        cabin_class_name: str = None,
        cabin_class_memo: str = None,
        specification: str = None,
        quantity: str = None,
        link_cabins: List[str] = None,
        reshop_change_cabin: bool = None,
        child_cabin_type: int = None,
        infant_basic_cabin: str = None,
        inner_cabin_class: int = None,
    ):
        self.cabin = cabin
        self.cabin_class = cabin_class
        self.cabin_class_name = cabin_class_name
        self.cabin_class_memo = cabin_class_memo
        self.specification = specification
        self.quantity = quantity
        self.link_cabins = link_cabins
        self.reshop_change_cabin = reshop_change_cabin
        self.child_cabin_type = child_cabin_type
        self.infant_basic_cabin = infant_basic_cabin
        self.inner_cabin_class = inner_cabin_class

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.cabin is not None:
            result['cabin'] = self.cabin
        if self.cabin_class is not None:
            result['cabin_class'] = self.cabin_class
        if self.cabin_class_name is not None:
            result['cabin_class_name'] = self.cabin_class_name
        if self.cabin_class_memo is not None:
            result['cabin_class_memo'] = self.cabin_class_memo
        if self.specification is not None:
            result['specification'] = self.specification
        if self.quantity is not None:
            result['quantity'] = self.quantity
        if self.link_cabins is not None:
            result['link_cabins'] = self.link_cabins
        if self.reshop_change_cabin is not None:
            result['reshop_change_cabin'] = self.reshop_change_cabin
        if self.child_cabin_type is not None:
            result['child_cabin_type'] = self.child_cabin_type
        if self.infant_basic_cabin is not None:
            result['infant_basic_cabin'] = self.infant_basic_cabin
        if self.inner_cabin_class is not None:
            result['inner_cabin_class'] = self.inner_cabin_class
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('cabin') is not None:
            self.cabin = m.get('cabin')
        if m.get('cabin_class') is not None:
            self.cabin_class = m.get('cabin_class')
        if m.get('cabin_class_name') is not None:
            self.cabin_class_name = m.get('cabin_class_name')
        if m.get('cabin_class_memo') is not None:
            self.cabin_class_memo = m.get('cabin_class_memo')
        if m.get('specification') is not None:
            self.specification = m.get('specification')
        if m.get('quantity') is not None:
            self.quantity = m.get('quantity')
        if m.get('link_cabins') is not None:
            self.link_cabins = m.get('link_cabins')
        if m.get('reshop_change_cabin') is not None:
            self.reshop_change_cabin = m.get('reshop_change_cabin')
        if m.get('child_cabin_type') is not None:
            self.child_cabin_type = m.get('child_cabin_type')
        if m.get('infant_basic_cabin') is not None:
            self.infant_basic_cabin = m.get('infant_basic_cabin')
        if m.get('inner_cabin_class') is not None:
            self.inner_cabin_class = m.get('inner_cabin_class')
        return self


class ModuleItemListShoppingItemMapValueSegmentPriceValuePriceShowInfo(TeaModel):
    def __init__(
        self,
        discount_info: str = None,
        discount_num: float = None,
        show_ticket_price: bool = None,
    ):
        self.discount_info = discount_info
        self.discount_num = discount_num
        self.show_ticket_price = show_ticket_price

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.discount_info is not None:
            result['discount_info'] = self.discount_info
        if self.discount_num is not None:
            result['discount_num'] = self.discount_num
        if self.show_ticket_price is not None:
            result['show_ticket_price'] = self.show_ticket_price
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('discount_info') is not None:
            self.discount_info = m.get('discount_info')
        if m.get('discount_num') is not None:
            self.discount_num = m.get('discount_num')
        if m.get('show_ticket_price') is not None:
            self.show_ticket_price = m.get('show_ticket_price')
        return self


class ModuleItemListShoppingItemMapValueSegmentPriceValue(TeaModel):
    def __init__(
        self,
        floor_price: int = None,
        ticket_price: int = None,
        sell_price: int = None,
        original_sell_price: int = None,
        base_total_price: int = None,
        before_control_price: int = None,
        tax: int = None,
        supply_price: int = None,
        basic_cabin_price: int = None,
        build_price: int = None,
        oil_price: int = None,
        first_standard_price: int = None,
        business_standard_price: int = None,
        common_standard_price: int = None,
        inter_ticket_price: int = None,
        subtracted_price: int = None,
        origin_common_price: int = None,
        dynamic_promotion_price: int = None,
        installment_num: int = None,
        installment_price: float = None,
        competition_dynamic_price: int = None,
        competition_promotion_price: int = None,
        min_before_control_price_of_normal: int = None,
        price_show_info: ModuleItemListShoppingItemMapValueSegmentPriceValuePriceShowInfo = None,
    ):
        self.floor_price = floor_price
        self.ticket_price = ticket_price
        self.sell_price = sell_price
        self.original_sell_price = original_sell_price
        self.base_total_price = base_total_price
        self.before_control_price = before_control_price
        self.tax = tax
        self.supply_price = supply_price
        self.basic_cabin_price = basic_cabin_price
        self.build_price = build_price
        self.oil_price = oil_price
        self.first_standard_price = first_standard_price
        self.business_standard_price = business_standard_price
        self.common_standard_price = common_standard_price
        # fdPrice
        self.inter_ticket_price = inter_ticket_price
        self.subtracted_price = subtracted_price
        self.origin_common_price = origin_common_price
        self.dynamic_promotion_price = dynamic_promotion_price
        self.installment_num = installment_num
        self.installment_price = installment_price
        self.competition_dynamic_price = competition_dynamic_price
        self.competition_promotion_price = competition_promotion_price
        self.min_before_control_price_of_normal = min_before_control_price_of_normal
        self.price_show_info = price_show_info

    def validate(self):
        if self.price_show_info:
            self.price_show_info.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.floor_price is not None:
            result['floor_price'] = self.floor_price
        if self.ticket_price is not None:
            result['ticket_price'] = self.ticket_price
        if self.sell_price is not None:
            result['sell_price'] = self.sell_price
        if self.original_sell_price is not None:
            result['original_sell_price'] = self.original_sell_price
        if self.base_total_price is not None:
            result['base_total_price'] = self.base_total_price
        if self.before_control_price is not None:
            result['before_control_price'] = self.before_control_price
        if self.tax is not None:
            result['tax'] = self.tax
        if self.supply_price is not None:
            result['supply_price'] = self.supply_price
        if self.basic_cabin_price is not None:
            result['basic_cabin_price'] = self.basic_cabin_price
        if self.build_price is not None:
            result['build_price'] = self.build_price
        if self.oil_price is not None:
            result['oil_price'] = self.oil_price
        if self.first_standard_price is not None:
            result['first_standard_price'] = self.first_standard_price
        if self.business_standard_price is not None:
            result['business_standard_price'] = self.business_standard_price
        if self.common_standard_price is not None:
            result['common_standard_price'] = self.common_standard_price
        if self.inter_ticket_price is not None:
            result['inter_ticket_price'] = self.inter_ticket_price
        if self.subtracted_price is not None:
            result['subtracted_price'] = self.subtracted_price
        if self.origin_common_price is not None:
            result['origin_common_price'] = self.origin_common_price
        if self.dynamic_promotion_price is not None:
            result['dynamic_promotion_price'] = self.dynamic_promotion_price
        if self.installment_num is not None:
            result['installment_num'] = self.installment_num
        if self.installment_price is not None:
            result['installment_price'] = self.installment_price
        if self.competition_dynamic_price is not None:
            result['competition_dynamic_price'] = self.competition_dynamic_price
        if self.competition_promotion_price is not None:
            result['competition_promotion_price'] = self.competition_promotion_price
        if self.min_before_control_price_of_normal is not None:
            result['min_before_control_price_of_normal'] = self.min_before_control_price_of_normal
        if self.price_show_info is not None:
            result['price_show_info'] = self.price_show_info.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('floor_price') is not None:
            self.floor_price = m.get('floor_price')
        if m.get('ticket_price') is not None:
            self.ticket_price = m.get('ticket_price')
        if m.get('sell_price') is not None:
            self.sell_price = m.get('sell_price')
        if m.get('original_sell_price') is not None:
            self.original_sell_price = m.get('original_sell_price')
        if m.get('base_total_price') is not None:
            self.base_total_price = m.get('base_total_price')
        if m.get('before_control_price') is not None:
            self.before_control_price = m.get('before_control_price')
        if m.get('tax') is not None:
            self.tax = m.get('tax')
        if m.get('supply_price') is not None:
            self.supply_price = m.get('supply_price')
        if m.get('basic_cabin_price') is not None:
            self.basic_cabin_price = m.get('basic_cabin_price')
        if m.get('build_price') is not None:
            self.build_price = m.get('build_price')
        if m.get('oil_price') is not None:
            self.oil_price = m.get('oil_price')
        if m.get('first_standard_price') is not None:
            self.first_standard_price = m.get('first_standard_price')
        if m.get('business_standard_price') is not None:
            self.business_standard_price = m.get('business_standard_price')
        if m.get('common_standard_price') is not None:
            self.common_standard_price = m.get('common_standard_price')
        if m.get('inter_ticket_price') is not None:
            self.inter_ticket_price = m.get('inter_ticket_price')
        if m.get('subtracted_price') is not None:
            self.subtracted_price = m.get('subtracted_price')
        if m.get('origin_common_price') is not None:
            self.origin_common_price = m.get('origin_common_price')
        if m.get('dynamic_promotion_price') is not None:
            self.dynamic_promotion_price = m.get('dynamic_promotion_price')
        if m.get('installment_num') is not None:
            self.installment_num = m.get('installment_num')
        if m.get('installment_price') is not None:
            self.installment_price = m.get('installment_price')
        if m.get('competition_dynamic_price') is not None:
            self.competition_dynamic_price = m.get('competition_dynamic_price')
        if m.get('competition_promotion_price') is not None:
            self.competition_promotion_price = m.get('competition_promotion_price')
        if m.get('min_before_control_price_of_normal') is not None:
            self.min_before_control_price_of_normal = m.get('min_before_control_price_of_normal')
        if m.get('price_show_info') is not None:
            temp_model = ModuleItemListShoppingItemMapValueSegmentPriceValuePriceShowInfo()
            self.price_show_info = temp_model.from_map(m['price_show_info'])
        return self


class ModuleItemListShoppingItemMapValue(TeaModel):
    def __init__(
        self,
        cabin_quantity_list: List[ModuleItemListShoppingItemMapValueCabinQuantityList] = None,
        search_price: ModuleItemListShoppingItemMapValueSearchPrice = None,
        segment_price_list: List[ModuleItemListShoppingItemMapValueSegmentPriceList] = None,
        id: str = None,
        cabin_quantity: Dict[str, ModuleItemListShoppingItemMapValueCabinQuantityValue] = None,
        segment_price: Dict[str, ModuleItemListShoppingItemMapValueSegmentPriceValue] = None,
    ):
        self.cabin_quantity_list = cabin_quantity_list
        self.search_price = search_price
        self.segment_price_list = segment_price_list
        # id
        self.id = id
        self.cabin_quantity = cabin_quantity
        self.segment_price = segment_price

    def validate(self):
        if self.cabin_quantity_list:
            for k in self.cabin_quantity_list:
                if k:
                    k.validate()
        if self.search_price:
            self.search_price.validate()
        if self.segment_price_list:
            for k in self.segment_price_list:
                if k:
                    k.validate()
        if self.cabin_quantity:
            for v in self.cabin_quantity.values():
                if v:
                    v.validate()
        if self.segment_price:
            for v in self.segment_price.values():
                if v:
                    v.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['cabin_quantity_list'] = []
        if self.cabin_quantity_list is not None:
            for k in self.cabin_quantity_list:
                result['cabin_quantity_list'].append(k.to_map() if k else None)
        if self.search_price is not None:
            result['search_price'] = self.search_price.to_map()
        result['segment_price_list'] = []
        if self.segment_price_list is not None:
            for k in self.segment_price_list:
                result['segment_price_list'].append(k.to_map() if k else None)
        if self.id is not None:
            result['id'] = self.id
        result['cabin_quantity'] = {}
        if self.cabin_quantity is not None:
            for k, v in self.cabin_quantity.items():
                result['cabin_quantity'][k] = v.to_map()
        result['segment_price'] = {}
        if self.segment_price is not None:
            for k, v in self.segment_price.items():
                result['segment_price'][k] = v.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.cabin_quantity_list = []
        if m.get('cabin_quantity_list') is not None:
            for k in m.get('cabin_quantity_list'):
                temp_model = ModuleItemListShoppingItemMapValueCabinQuantityList()
                self.cabin_quantity_list.append(temp_model.from_map(k))
        if m.get('search_price') is not None:
            temp_model = ModuleItemListShoppingItemMapValueSearchPrice()
            self.search_price = temp_model.from_map(m['search_price'])
        self.segment_price_list = []
        if m.get('segment_price_list') is not None:
            for k in m.get('segment_price_list'):
                temp_model = ModuleItemListShoppingItemMapValueSegmentPriceList()
                self.segment_price_list.append(temp_model.from_map(k))
        if m.get('id') is not None:
            self.id = m.get('id')
        self.cabin_quantity = {}
        if m.get('cabin_quantity') is not None:
            for k, v in m.get('cabin_quantity').items():
                temp_model = ModuleItemListShoppingItemMapValueCabinQuantityValue()
                self.cabin_quantity[k] = temp_model.from_map(v)
        self.segment_price = {}
        if m.get('segment_price') is not None:
            for k, v in m.get('segment_price').items():
                temp_model = ModuleItemListShoppingItemMapValueSegmentPriceValue()
                self.segment_price[k] = temp_model.from_map(v)
        return self


class ModuleItemListSubItemPositionMapValue(TeaModel):
    def __init__(
        self,
        journey_index: int = None,
        segment_index: int = None,
    ):
        self.journey_index = journey_index
        self.segment_index = segment_index

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.journey_index is not None:
            result['journey_index'] = self.journey_index
        if self.segment_index is not None:
            result['segment_index'] = self.segment_index
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('journey_index') is not None:
            self.journey_index = m.get('journey_index')
        if m.get('segment_index') is not None:
            self.segment_index = m.get('segment_index')
        return self


class ModuleItemListSubItemsShoppingItemMapValueCabinQuantityListSegmentPosition(TeaModel):
    def __init__(
        self,
        journey_index: int = None,
        segment_index: int = None,
    ):
        self.journey_index = journey_index
        self.segment_index = segment_index

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.journey_index is not None:
            result['journey_index'] = self.journey_index
        if self.segment_index is not None:
            result['segment_index'] = self.segment_index
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('journey_index') is not None:
            self.journey_index = m.get('journey_index')
        if m.get('segment_index') is not None:
            self.segment_index = m.get('segment_index')
        return self


class ModuleItemListSubItemsShoppingItemMapValueCabinQuantityListCabinInfo(TeaModel):
    def __init__(
        self,
        cabin: str = None,
        cabin_class: str = None,
        cabin_class_name: str = None,
        quantity: str = None,
    ):
        self.cabin = cabin
        self.cabin_class = cabin_class
        self.cabin_class_name = cabin_class_name
        self.quantity = quantity

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.cabin is not None:
            result['cabin'] = self.cabin
        if self.cabin_class is not None:
            result['cabin_class'] = self.cabin_class
        if self.cabin_class_name is not None:
            result['cabin_class_name'] = self.cabin_class_name
        if self.quantity is not None:
            result['quantity'] = self.quantity
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('cabin') is not None:
            self.cabin = m.get('cabin')
        if m.get('cabin_class') is not None:
            self.cabin_class = m.get('cabin_class')
        if m.get('cabin_class_name') is not None:
            self.cabin_class_name = m.get('cabin_class_name')
        if m.get('quantity') is not None:
            self.quantity = m.get('quantity')
        return self


class ModuleItemListSubItemsShoppingItemMapValueCabinQuantityList(TeaModel):
    def __init__(
        self,
        segment_position: ModuleItemListSubItemsShoppingItemMapValueCabinQuantityListSegmentPosition = None,
        cabin_info: ModuleItemListSubItemsShoppingItemMapValueCabinQuantityListCabinInfo = None,
    ):
        self.segment_position = segment_position
        self.cabin_info = cabin_info

    def validate(self):
        if self.segment_position:
            self.segment_position.validate()
        if self.cabin_info:
            self.cabin_info.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.segment_position is not None:
            result['segment_position'] = self.segment_position.to_map()
        if self.cabin_info is not None:
            result['cabin_info'] = self.cabin_info.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('segment_position') is not None:
            temp_model = ModuleItemListSubItemsShoppingItemMapValueCabinQuantityListSegmentPosition()
            self.segment_position = temp_model.from_map(m['segment_position'])
        if m.get('cabin_info') is not None:
            temp_model = ModuleItemListSubItemsShoppingItemMapValueCabinQuantityListCabinInfo()
            self.cabin_info = temp_model.from_map(m['cabin_info'])
        return self


class ModuleItemListSubItemsShoppingItemMapValueSearchPricePriceShowInfo(TeaModel):
    def __init__(
        self,
        discount_info: str = None,
        discount_num: float = None,
        show_ticket_price: bool = None,
    ):
        self.discount_info = discount_info
        self.discount_num = discount_num
        self.show_ticket_price = show_ticket_price

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.discount_info is not None:
            result['discount_info'] = self.discount_info
        if self.discount_num is not None:
            result['discount_num'] = self.discount_num
        if self.show_ticket_price is not None:
            result['show_ticket_price'] = self.show_ticket_price
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('discount_info') is not None:
            self.discount_info = m.get('discount_info')
        if m.get('discount_num') is not None:
            self.discount_num = m.get('discount_num')
        if m.get('show_ticket_price') is not None:
            self.show_ticket_price = m.get('show_ticket_price')
        return self


class ModuleItemListSubItemsShoppingItemMapValueSearchPrice(TeaModel):
    def __init__(
        self,
        floor_price: int = None,
        ticket_price: int = None,
        sell_price: int = None,
        original_sell_price: int = None,
        base_total_price: int = None,
        before_control_price: int = None,
        tax: int = None,
        supply_price: int = None,
        basic_cabin_price: int = None,
        build_price: int = None,
        oil_price: int = None,
        first_standard_price: int = None,
        business_standard_price: int = None,
        common_standard_price: int = None,
        inter_ticket_price: int = None,
        subtracted_price: int = None,
        origin_common_price: int = None,
        dynamic_promotion_price: int = None,
        installment_num: int = None,
        installment_price: float = None,
        competition_dynamic_price: int = None,
        competition_promotion_price: int = None,
        min_before_control_price_of_normal: int = None,
        price_show_info: ModuleItemListSubItemsShoppingItemMapValueSearchPricePriceShowInfo = None,
    ):
        self.floor_price = floor_price
        self.ticket_price = ticket_price
        self.sell_price = sell_price
        self.original_sell_price = original_sell_price
        self.base_total_price = base_total_price
        self.before_control_price = before_control_price
        self.tax = tax
        self.supply_price = supply_price
        self.basic_cabin_price = basic_cabin_price
        self.build_price = build_price
        self.oil_price = oil_price
        self.first_standard_price = first_standard_price
        self.business_standard_price = business_standard_price
        self.common_standard_price = common_standard_price
        # fdPrice
        self.inter_ticket_price = inter_ticket_price
        self.subtracted_price = subtracted_price
        self.origin_common_price = origin_common_price
        self.dynamic_promotion_price = dynamic_promotion_price
        self.installment_num = installment_num
        self.installment_price = installment_price
        self.competition_dynamic_price = competition_dynamic_price
        self.competition_promotion_price = competition_promotion_price
        self.min_before_control_price_of_normal = min_before_control_price_of_normal
        self.price_show_info = price_show_info

    def validate(self):
        if self.price_show_info:
            self.price_show_info.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.floor_price is not None:
            result['floor_price'] = self.floor_price
        if self.ticket_price is not None:
            result['ticket_price'] = self.ticket_price
        if self.sell_price is not None:
            result['sell_price'] = self.sell_price
        if self.original_sell_price is not None:
            result['original_sell_price'] = self.original_sell_price
        if self.base_total_price is not None:
            result['base_total_price'] = self.base_total_price
        if self.before_control_price is not None:
            result['before_control_price'] = self.before_control_price
        if self.tax is not None:
            result['tax'] = self.tax
        if self.supply_price is not None:
            result['supply_price'] = self.supply_price
        if self.basic_cabin_price is not None:
            result['basic_cabin_price'] = self.basic_cabin_price
        if self.build_price is not None:
            result['build_price'] = self.build_price
        if self.oil_price is not None:
            result['oil_price'] = self.oil_price
        if self.first_standard_price is not None:
            result['first_standard_price'] = self.first_standard_price
        if self.business_standard_price is not None:
            result['business_standard_price'] = self.business_standard_price
        if self.common_standard_price is not None:
            result['common_standard_price'] = self.common_standard_price
        if self.inter_ticket_price is not None:
            result['inter_ticket_price'] = self.inter_ticket_price
        if self.subtracted_price is not None:
            result['subtracted_price'] = self.subtracted_price
        if self.origin_common_price is not None:
            result['origin_common_price'] = self.origin_common_price
        if self.dynamic_promotion_price is not None:
            result['dynamic_promotion_price'] = self.dynamic_promotion_price
        if self.installment_num is not None:
            result['installment_num'] = self.installment_num
        if self.installment_price is not None:
            result['installment_price'] = self.installment_price
        if self.competition_dynamic_price is not None:
            result['competition_dynamic_price'] = self.competition_dynamic_price
        if self.competition_promotion_price is not None:
            result['competition_promotion_price'] = self.competition_promotion_price
        if self.min_before_control_price_of_normal is not None:
            result['min_before_control_price_of_normal'] = self.min_before_control_price_of_normal
        if self.price_show_info is not None:
            result['price_show_info'] = self.price_show_info.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('floor_price') is not None:
            self.floor_price = m.get('floor_price')
        if m.get('ticket_price') is not None:
            self.ticket_price = m.get('ticket_price')
        if m.get('sell_price') is not None:
            self.sell_price = m.get('sell_price')
        if m.get('original_sell_price') is not None:
            self.original_sell_price = m.get('original_sell_price')
        if m.get('base_total_price') is not None:
            self.base_total_price = m.get('base_total_price')
        if m.get('before_control_price') is not None:
            self.before_control_price = m.get('before_control_price')
        if m.get('tax') is not None:
            self.tax = m.get('tax')
        if m.get('supply_price') is not None:
            self.supply_price = m.get('supply_price')
        if m.get('basic_cabin_price') is not None:
            self.basic_cabin_price = m.get('basic_cabin_price')
        if m.get('build_price') is not None:
            self.build_price = m.get('build_price')
        if m.get('oil_price') is not None:
            self.oil_price = m.get('oil_price')
        if m.get('first_standard_price') is not None:
            self.first_standard_price = m.get('first_standard_price')
        if m.get('business_standard_price') is not None:
            self.business_standard_price = m.get('business_standard_price')
        if m.get('common_standard_price') is not None:
            self.common_standard_price = m.get('common_standard_price')
        if m.get('inter_ticket_price') is not None:
            self.inter_ticket_price = m.get('inter_ticket_price')
        if m.get('subtracted_price') is not None:
            self.subtracted_price = m.get('subtracted_price')
        if m.get('origin_common_price') is not None:
            self.origin_common_price = m.get('origin_common_price')
        if m.get('dynamic_promotion_price') is not None:
            self.dynamic_promotion_price = m.get('dynamic_promotion_price')
        if m.get('installment_num') is not None:
            self.installment_num = m.get('installment_num')
        if m.get('installment_price') is not None:
            self.installment_price = m.get('installment_price')
        if m.get('competition_dynamic_price') is not None:
            self.competition_dynamic_price = m.get('competition_dynamic_price')
        if m.get('competition_promotion_price') is not None:
            self.competition_promotion_price = m.get('competition_promotion_price')
        if m.get('min_before_control_price_of_normal') is not None:
            self.min_before_control_price_of_normal = m.get('min_before_control_price_of_normal')
        if m.get('price_show_info') is not None:
            temp_model = ModuleItemListSubItemsShoppingItemMapValueSearchPricePriceShowInfo()
            self.price_show_info = temp_model.from_map(m['price_show_info'])
        return self


class ModuleItemListSubItemsShoppingItemMapValueSegmentPriceListSegmentPosition(TeaModel):
    def __init__(
        self,
        journey_index: int = None,
        segment_index: int = None,
    ):
        self.journey_index = journey_index
        self.segment_index = segment_index

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.journey_index is not None:
            result['journey_index'] = self.journey_index
        if self.segment_index is not None:
            result['segment_index'] = self.segment_index
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('journey_index') is not None:
            self.journey_index = m.get('journey_index')
        if m.get('segment_index') is not None:
            self.segment_index = m.get('segment_index')
        return self


class ModuleItemListSubItemsShoppingItemMapValueSegmentPriceListSearchPrice(TeaModel):
    def __init__(
        self,
        sell_price: int = None,
        ticket_price: int = None,
        tax: int = None,
    ):
        self.sell_price = sell_price
        self.ticket_price = ticket_price
        self.tax = tax

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.sell_price is not None:
            result['sell_price'] = self.sell_price
        if self.ticket_price is not None:
            result['ticket_price'] = self.ticket_price
        if self.tax is not None:
            result['tax'] = self.tax
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('sell_price') is not None:
            self.sell_price = m.get('sell_price')
        if m.get('ticket_price') is not None:
            self.ticket_price = m.get('ticket_price')
        if m.get('tax') is not None:
            self.tax = m.get('tax')
        return self


class ModuleItemListSubItemsShoppingItemMapValueSegmentPriceList(TeaModel):
    def __init__(
        self,
        segment_position: ModuleItemListSubItemsShoppingItemMapValueSegmentPriceListSegmentPosition = None,
        search_price: ModuleItemListSubItemsShoppingItemMapValueSegmentPriceListSearchPrice = None,
    ):
        self.segment_position = segment_position
        self.search_price = search_price

    def validate(self):
        if self.segment_position:
            self.segment_position.validate()
        if self.search_price:
            self.search_price.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.segment_position is not None:
            result['segment_position'] = self.segment_position.to_map()
        if self.search_price is not None:
            result['search_price'] = self.search_price.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('segment_position') is not None:
            temp_model = ModuleItemListSubItemsShoppingItemMapValueSegmentPriceListSegmentPosition()
            self.segment_position = temp_model.from_map(m['segment_position'])
        if m.get('search_price') is not None:
            temp_model = ModuleItemListSubItemsShoppingItemMapValueSegmentPriceListSearchPrice()
            self.search_price = temp_model.from_map(m['search_price'])
        return self


class ModuleItemListSubItemsShoppingItemMapValueCabinQuantityValue(TeaModel):
    def __init__(
        self,
        cabin: str = None,
        cabin_class: str = None,
        cabin_class_name: str = None,
        cabin_class_memo: str = None,
        specification: str = None,
        quantity: str = None,
        link_cabins: List[str] = None,
        reshop_change_cabin: bool = None,
        child_cabin_type: int = None,
        infant_basic_cabin: str = None,
        inner_cabin_class: int = None,
    ):
        self.cabin = cabin
        self.cabin_class = cabin_class
        self.cabin_class_name = cabin_class_name
        self.cabin_class_memo = cabin_class_memo
        self.specification = specification
        self.quantity = quantity
        self.link_cabins = link_cabins
        self.reshop_change_cabin = reshop_change_cabin
        self.child_cabin_type = child_cabin_type
        self.infant_basic_cabin = infant_basic_cabin
        self.inner_cabin_class = inner_cabin_class

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.cabin is not None:
            result['cabin'] = self.cabin
        if self.cabin_class is not None:
            result['cabin_class'] = self.cabin_class
        if self.cabin_class_name is not None:
            result['cabin_class_name'] = self.cabin_class_name
        if self.cabin_class_memo is not None:
            result['cabin_class_memo'] = self.cabin_class_memo
        if self.specification is not None:
            result['specification'] = self.specification
        if self.quantity is not None:
            result['quantity'] = self.quantity
        if self.link_cabins is not None:
            result['link_cabins'] = self.link_cabins
        if self.reshop_change_cabin is not None:
            result['reshop_change_cabin'] = self.reshop_change_cabin
        if self.child_cabin_type is not None:
            result['child_cabin_type'] = self.child_cabin_type
        if self.infant_basic_cabin is not None:
            result['infant_basic_cabin'] = self.infant_basic_cabin
        if self.inner_cabin_class is not None:
            result['inner_cabin_class'] = self.inner_cabin_class
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('cabin') is not None:
            self.cabin = m.get('cabin')
        if m.get('cabin_class') is not None:
            self.cabin_class = m.get('cabin_class')
        if m.get('cabin_class_name') is not None:
            self.cabin_class_name = m.get('cabin_class_name')
        if m.get('cabin_class_memo') is not None:
            self.cabin_class_memo = m.get('cabin_class_memo')
        if m.get('specification') is not None:
            self.specification = m.get('specification')
        if m.get('quantity') is not None:
            self.quantity = m.get('quantity')
        if m.get('link_cabins') is not None:
            self.link_cabins = m.get('link_cabins')
        if m.get('reshop_change_cabin') is not None:
            self.reshop_change_cabin = m.get('reshop_change_cabin')
        if m.get('child_cabin_type') is not None:
            self.child_cabin_type = m.get('child_cabin_type')
        if m.get('infant_basic_cabin') is not None:
            self.infant_basic_cabin = m.get('infant_basic_cabin')
        if m.get('inner_cabin_class') is not None:
            self.inner_cabin_class = m.get('inner_cabin_class')
        return self


class ModuleItemListSubItemsShoppingItemMapValueSegmentPriceValuePriceShowInfo(TeaModel):
    def __init__(
        self,
        discount_info: str = None,
        discount_num: float = None,
        show_ticket_price: bool = None,
    ):
        self.discount_info = discount_info
        self.discount_num = discount_num
        self.show_ticket_price = show_ticket_price

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.discount_info is not None:
            result['discount_info'] = self.discount_info
        if self.discount_num is not None:
            result['discount_num'] = self.discount_num
        if self.show_ticket_price is not None:
            result['show_ticket_price'] = self.show_ticket_price
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('discount_info') is not None:
            self.discount_info = m.get('discount_info')
        if m.get('discount_num') is not None:
            self.discount_num = m.get('discount_num')
        if m.get('show_ticket_price') is not None:
            self.show_ticket_price = m.get('show_ticket_price')
        return self


class ModuleItemListSubItemsShoppingItemMapValueSegmentPriceValue(TeaModel):
    def __init__(
        self,
        floor_price: int = None,
        ticket_price: int = None,
        sell_price: int = None,
        original_sell_price: int = None,
        base_total_price: int = None,
        before_control_price: int = None,
        tax: int = None,
        supply_price: int = None,
        basic_cabin_price: int = None,
        build_price: int = None,
        oil_price: int = None,
        first_standard_price: int = None,
        business_standard_price: int = None,
        common_standard_price: int = None,
        inter_ticket_price: int = None,
        subtracted_price: int = None,
        origin_common_price: int = None,
        dynamic_promotion_price: int = None,
        installment_num: int = None,
        installment_price: float = None,
        competition_dynamic_price: int = None,
        competition_promotion_price: int = None,
        min_before_control_price_of_normal: int = None,
        price_show_info: ModuleItemListSubItemsShoppingItemMapValueSegmentPriceValuePriceShowInfo = None,
    ):
        self.floor_price = floor_price
        self.ticket_price = ticket_price
        self.sell_price = sell_price
        self.original_sell_price = original_sell_price
        self.base_total_price = base_total_price
        self.before_control_price = before_control_price
        self.tax = tax
        self.supply_price = supply_price
        self.basic_cabin_price = basic_cabin_price
        self.build_price = build_price
        self.oil_price = oil_price
        self.first_standard_price = first_standard_price
        self.business_standard_price = business_standard_price
        self.common_standard_price = common_standard_price
        # fdPrice
        self.inter_ticket_price = inter_ticket_price
        self.subtracted_price = subtracted_price
        self.origin_common_price = origin_common_price
        self.dynamic_promotion_price = dynamic_promotion_price
        self.installment_num = installment_num
        self.installment_price = installment_price
        self.competition_dynamic_price = competition_dynamic_price
        self.competition_promotion_price = competition_promotion_price
        self.min_before_control_price_of_normal = min_before_control_price_of_normal
        self.price_show_info = price_show_info

    def validate(self):
        if self.price_show_info:
            self.price_show_info.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.floor_price is not None:
            result['floor_price'] = self.floor_price
        if self.ticket_price is not None:
            result['ticket_price'] = self.ticket_price
        if self.sell_price is not None:
            result['sell_price'] = self.sell_price
        if self.original_sell_price is not None:
            result['original_sell_price'] = self.original_sell_price
        if self.base_total_price is not None:
            result['base_total_price'] = self.base_total_price
        if self.before_control_price is not None:
            result['before_control_price'] = self.before_control_price
        if self.tax is not None:
            result['tax'] = self.tax
        if self.supply_price is not None:
            result['supply_price'] = self.supply_price
        if self.basic_cabin_price is not None:
            result['basic_cabin_price'] = self.basic_cabin_price
        if self.build_price is not None:
            result['build_price'] = self.build_price
        if self.oil_price is not None:
            result['oil_price'] = self.oil_price
        if self.first_standard_price is not None:
            result['first_standard_price'] = self.first_standard_price
        if self.business_standard_price is not None:
            result['business_standard_price'] = self.business_standard_price
        if self.common_standard_price is not None:
            result['common_standard_price'] = self.common_standard_price
        if self.inter_ticket_price is not None:
            result['inter_ticket_price'] = self.inter_ticket_price
        if self.subtracted_price is not None:
            result['subtracted_price'] = self.subtracted_price
        if self.origin_common_price is not None:
            result['origin_common_price'] = self.origin_common_price
        if self.dynamic_promotion_price is not None:
            result['dynamic_promotion_price'] = self.dynamic_promotion_price
        if self.installment_num is not None:
            result['installment_num'] = self.installment_num
        if self.installment_price is not None:
            result['installment_price'] = self.installment_price
        if self.competition_dynamic_price is not None:
            result['competition_dynamic_price'] = self.competition_dynamic_price
        if self.competition_promotion_price is not None:
            result['competition_promotion_price'] = self.competition_promotion_price
        if self.min_before_control_price_of_normal is not None:
            result['min_before_control_price_of_normal'] = self.min_before_control_price_of_normal
        if self.price_show_info is not None:
            result['price_show_info'] = self.price_show_info.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('floor_price') is not None:
            self.floor_price = m.get('floor_price')
        if m.get('ticket_price') is not None:
            self.ticket_price = m.get('ticket_price')
        if m.get('sell_price') is not None:
            self.sell_price = m.get('sell_price')
        if m.get('original_sell_price') is not None:
            self.original_sell_price = m.get('original_sell_price')
        if m.get('base_total_price') is not None:
            self.base_total_price = m.get('base_total_price')
        if m.get('before_control_price') is not None:
            self.before_control_price = m.get('before_control_price')
        if m.get('tax') is not None:
            self.tax = m.get('tax')
        if m.get('supply_price') is not None:
            self.supply_price = m.get('supply_price')
        if m.get('basic_cabin_price') is not None:
            self.basic_cabin_price = m.get('basic_cabin_price')
        if m.get('build_price') is not None:
            self.build_price = m.get('build_price')
        if m.get('oil_price') is not None:
            self.oil_price = m.get('oil_price')
        if m.get('first_standard_price') is not None:
            self.first_standard_price = m.get('first_standard_price')
        if m.get('business_standard_price') is not None:
            self.business_standard_price = m.get('business_standard_price')
        if m.get('common_standard_price') is not None:
            self.common_standard_price = m.get('common_standard_price')
        if m.get('inter_ticket_price') is not None:
            self.inter_ticket_price = m.get('inter_ticket_price')
        if m.get('subtracted_price') is not None:
            self.subtracted_price = m.get('subtracted_price')
        if m.get('origin_common_price') is not None:
            self.origin_common_price = m.get('origin_common_price')
        if m.get('dynamic_promotion_price') is not None:
            self.dynamic_promotion_price = m.get('dynamic_promotion_price')
        if m.get('installment_num') is not None:
            self.installment_num = m.get('installment_num')
        if m.get('installment_price') is not None:
            self.installment_price = m.get('installment_price')
        if m.get('competition_dynamic_price') is not None:
            self.competition_dynamic_price = m.get('competition_dynamic_price')
        if m.get('competition_promotion_price') is not None:
            self.competition_promotion_price = m.get('competition_promotion_price')
        if m.get('min_before_control_price_of_normal') is not None:
            self.min_before_control_price_of_normal = m.get('min_before_control_price_of_normal')
        if m.get('price_show_info') is not None:
            temp_model = ModuleItemListSubItemsShoppingItemMapValueSegmentPriceValuePriceShowInfo()
            self.price_show_info = temp_model.from_map(m['price_show_info'])
        return self


class ModuleItemListSubItemsShoppingItemMapValue(TeaModel):
    def __init__(
        self,
        cabin_quantity_list: List[ModuleItemListSubItemsShoppingItemMapValueCabinQuantityList] = None,
        search_price: ModuleItemListSubItemsShoppingItemMapValueSearchPrice = None,
        segment_price_list: List[ModuleItemListSubItemsShoppingItemMapValueSegmentPriceList] = None,
        id: str = None,
        cabin_quantity: Dict[str, ModuleItemListSubItemsShoppingItemMapValueCabinQuantityValue] = None,
        segment_price: Dict[str, ModuleItemListSubItemsShoppingItemMapValueSegmentPriceValue] = None,
    ):
        self.cabin_quantity_list = cabin_quantity_list
        self.search_price = search_price
        self.segment_price_list = segment_price_list
        # id
        self.id = id
        self.cabin_quantity = cabin_quantity
        self.segment_price = segment_price

    def validate(self):
        if self.cabin_quantity_list:
            for k in self.cabin_quantity_list:
                if k:
                    k.validate()
        if self.search_price:
            self.search_price.validate()
        if self.segment_price_list:
            for k in self.segment_price_list:
                if k:
                    k.validate()
        if self.cabin_quantity:
            for v in self.cabin_quantity.values():
                if v:
                    v.validate()
        if self.segment_price:
            for v in self.segment_price.values():
                if v:
                    v.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['cabin_quantity_list'] = []
        if self.cabin_quantity_list is not None:
            for k in self.cabin_quantity_list:
                result['cabin_quantity_list'].append(k.to_map() if k else None)
        if self.search_price is not None:
            result['search_price'] = self.search_price.to_map()
        result['segment_price_list'] = []
        if self.segment_price_list is not None:
            for k in self.segment_price_list:
                result['segment_price_list'].append(k.to_map() if k else None)
        if self.id is not None:
            result['id'] = self.id
        result['cabin_quantity'] = {}
        if self.cabin_quantity is not None:
            for k, v in self.cabin_quantity.items():
                result['cabin_quantity'][k] = v.to_map()
        result['segment_price'] = {}
        if self.segment_price is not None:
            for k, v in self.segment_price.items():
                result['segment_price'][k] = v.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.cabin_quantity_list = []
        if m.get('cabin_quantity_list') is not None:
            for k in m.get('cabin_quantity_list'):
                temp_model = ModuleItemListSubItemsShoppingItemMapValueCabinQuantityList()
                self.cabin_quantity_list.append(temp_model.from_map(k))
        if m.get('search_price') is not None:
            temp_model = ModuleItemListSubItemsShoppingItemMapValueSearchPrice()
            self.search_price = temp_model.from_map(m['search_price'])
        self.segment_price_list = []
        if m.get('segment_price_list') is not None:
            for k in m.get('segment_price_list'):
                temp_model = ModuleItemListSubItemsShoppingItemMapValueSegmentPriceList()
                self.segment_price_list.append(temp_model.from_map(k))
        if m.get('id') is not None:
            self.id = m.get('id')
        self.cabin_quantity = {}
        if m.get('cabin_quantity') is not None:
            for k, v in m.get('cabin_quantity').items():
                temp_model = ModuleItemListSubItemsShoppingItemMapValueCabinQuantityValue()
                self.cabin_quantity[k] = temp_model.from_map(v)
        self.segment_price = {}
        if m.get('segment_price') is not None:
            for k, v in m.get('segment_price').items():
                temp_model = ModuleItemListSubItemsShoppingItemMapValueSegmentPriceValue()
                self.segment_price[k] = temp_model.from_map(v)
        return self


class ModuleOrderItemListBaggageRuleOfferBaggageInfoMapValue(TeaModel):
    def __init__(
        self,
        start_city_code: str = None,
        end_city_code: str = None,
        carry_free_pc: int = None,
        carry_bag_weight: int = None,
        carry_bag_size: str = None,
        is_all_carry_bag_weight: bool = None,
        total_pcs: int = None,
        total_weight: int = None,
        carry_unknown: bool = None,
        carry_length: int = None,
        carry_width: int = None,
        carry_height: int = None,
        carry_sum_of_length_width_height: int = None,
        free_pcs: int = None,
        baggage_weight: int = None,
        baggage_unit: str = None,
        baggage_size: str = None,
        all_weight: bool = None,
        length: int = None,
        width: int = None,
        height: int = None,
        sum_of_length_width_height: int = None,
        unknown: bool = None,
        cn_desc: str = None,
        en_desc: str = None,
        attribute: str = None,
        baggage_price: int = None,
        carry_on_baggage_tips: str = None,
    ):
        self.start_city_code = start_city_code
        self.end_city_code = end_city_code
        self.carry_free_pc = carry_free_pc
        self.carry_bag_weight = carry_bag_weight
        self.carry_bag_size = carry_bag_size
        self.is_all_carry_bag_weight = is_all_carry_bag_weight
        self.total_pcs = total_pcs
        self.total_weight = total_weight
        self.carry_unknown = carry_unknown
        self.carry_length = carry_length
        self.carry_width = carry_width
        self.carry_height = carry_height
        self.carry_sum_of_length_width_height = carry_sum_of_length_width_height
        self.free_pcs = free_pcs
        self.baggage_weight = baggage_weight
        self.baggage_unit = baggage_unit
        self.baggage_size = baggage_size
        self.all_weight = all_weight
        self.length = length
        self.width = width
        self.height = height
        self.sum_of_length_width_height = sum_of_length_width_height
        self.unknown = unknown
        self.cn_desc = cn_desc
        self.en_desc = en_desc
        self.attribute = attribute
        self.baggage_price = baggage_price
        self.carry_on_baggage_tips = carry_on_baggage_tips

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.start_city_code is not None:
            result['start_city_code'] = self.start_city_code
        if self.end_city_code is not None:
            result['end_city_code'] = self.end_city_code
        if self.carry_free_pc is not None:
            result['carry_free_pc'] = self.carry_free_pc
        if self.carry_bag_weight is not None:
            result['carry_bag_weight'] = self.carry_bag_weight
        if self.carry_bag_size is not None:
            result['carry_bag_size'] = self.carry_bag_size
        if self.is_all_carry_bag_weight is not None:
            result['is_all_carry_bag_weight'] = self.is_all_carry_bag_weight
        if self.total_pcs is not None:
            result['total_pcs'] = self.total_pcs
        if self.total_weight is not None:
            result['total_weight'] = self.total_weight
        if self.carry_unknown is not None:
            result['carry_unknown'] = self.carry_unknown
        if self.carry_length is not None:
            result['carry_length'] = self.carry_length
        if self.carry_width is not None:
            result['carry_width'] = self.carry_width
        if self.carry_height is not None:
            result['carry_height'] = self.carry_height
        if self.carry_sum_of_length_width_height is not None:
            result['carry_sum_of_length_width_height'] = self.carry_sum_of_length_width_height
        if self.free_pcs is not None:
            result['free_pcs'] = self.free_pcs
        if self.baggage_weight is not None:
            result['baggage_weight'] = self.baggage_weight
        if self.baggage_unit is not None:
            result['baggage_unit'] = self.baggage_unit
        if self.baggage_size is not None:
            result['baggage_size'] = self.baggage_size
        if self.all_weight is not None:
            result['all_weight'] = self.all_weight
        if self.length is not None:
            result['length'] = self.length
        if self.width is not None:
            result['width'] = self.width
        if self.height is not None:
            result['height'] = self.height
        if self.sum_of_length_width_height is not None:
            result['sum_of_length_width_height'] = self.sum_of_length_width_height
        if self.unknown is not None:
            result['unknown'] = self.unknown
        if self.cn_desc is not None:
            result['cn_desc'] = self.cn_desc
        if self.en_desc is not None:
            result['en_desc'] = self.en_desc
        if self.attribute is not None:
            result['attribute'] = self.attribute
        if self.baggage_price is not None:
            result['baggage_price'] = self.baggage_price
        if self.carry_on_baggage_tips is not None:
            result['carry_on_baggage_tips'] = self.carry_on_baggage_tips
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('start_city_code') is not None:
            self.start_city_code = m.get('start_city_code')
        if m.get('end_city_code') is not None:
            self.end_city_code = m.get('end_city_code')
        if m.get('carry_free_pc') is not None:
            self.carry_free_pc = m.get('carry_free_pc')
        if m.get('carry_bag_weight') is not None:
            self.carry_bag_weight = m.get('carry_bag_weight')
        if m.get('carry_bag_size') is not None:
            self.carry_bag_size = m.get('carry_bag_size')
        if m.get('is_all_carry_bag_weight') is not None:
            self.is_all_carry_bag_weight = m.get('is_all_carry_bag_weight')
        if m.get('total_pcs') is not None:
            self.total_pcs = m.get('total_pcs')
        if m.get('total_weight') is not None:
            self.total_weight = m.get('total_weight')
        if m.get('carry_unknown') is not None:
            self.carry_unknown = m.get('carry_unknown')
        if m.get('carry_length') is not None:
            self.carry_length = m.get('carry_length')
        if m.get('carry_width') is not None:
            self.carry_width = m.get('carry_width')
        if m.get('carry_height') is not None:
            self.carry_height = m.get('carry_height')
        if m.get('carry_sum_of_length_width_height') is not None:
            self.carry_sum_of_length_width_height = m.get('carry_sum_of_length_width_height')
        if m.get('free_pcs') is not None:
            self.free_pcs = m.get('free_pcs')
        if m.get('baggage_weight') is not None:
            self.baggage_weight = m.get('baggage_weight')
        if m.get('baggage_unit') is not None:
            self.baggage_unit = m.get('baggage_unit')
        if m.get('baggage_size') is not None:
            self.baggage_size = m.get('baggage_size')
        if m.get('all_weight') is not None:
            self.all_weight = m.get('all_weight')
        if m.get('length') is not None:
            self.length = m.get('length')
        if m.get('width') is not None:
            self.width = m.get('width')
        if m.get('height') is not None:
            self.height = m.get('height')
        if m.get('sum_of_length_width_height') is not None:
            self.sum_of_length_width_height = m.get('sum_of_length_width_height')
        if m.get('unknown') is not None:
            self.unknown = m.get('unknown')
        if m.get('cn_desc') is not None:
            self.cn_desc = m.get('cn_desc')
        if m.get('en_desc') is not None:
            self.en_desc = m.get('en_desc')
        if m.get('attribute') is not None:
            self.attribute = m.get('attribute')
        if m.get('baggage_price') is not None:
            self.baggage_price = m.get('baggage_price')
        if m.get('carry_on_baggage_tips') is not None:
            self.carry_on_baggage_tips = m.get('carry_on_baggage_tips')
        return self


class ModuleOrderItemListRefundChangeRuleOfferPenaltyInfoMapValue(TeaModel):
    def __init__(
        self,
        struct: bool = None,
        cancel_fee_ind: bool = None,
        change_fee_ind: bool = None,
        upgrade_fee_ind: bool = None,
        reissue_ind: bool = None,
        penalty_type_code: int = None,
        penalty_apply_range_code: int = None,
        penalty_charge_type_code: int = None,
        fee: float = None,
        currency: str = None,
        penalty_percent: float = None,
        start_time: int = None,
        end_time: int = None,
        time_unit_code: int = None,
        title: str = None,
        dep_time: str = None,
        segment_number: str = None,
        desc_infos: Dict[str, str] = None,
    ):
        self.struct = struct
        self.cancel_fee_ind = cancel_fee_ind
        self.change_fee_ind = change_fee_ind
        self.upgrade_fee_ind = upgrade_fee_ind
        self.reissue_ind = reissue_ind
        self.penalty_type_code = penalty_type_code
        self.penalty_apply_range_code = penalty_apply_range_code
        self.penalty_charge_type_code = penalty_charge_type_code
        self.fee = fee
        self.currency = currency
        self.penalty_percent = penalty_percent
        self.start_time = start_time
        self.end_time = end_time
        self.time_unit_code = time_unit_code
        self.title = title
        self.dep_time = dep_time
        self.segment_number = segment_number
        self.desc_infos = desc_infos

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.struct is not None:
            result['struct'] = self.struct
        if self.cancel_fee_ind is not None:
            result['cancel_fee_ind'] = self.cancel_fee_ind
        if self.change_fee_ind is not None:
            result['change_fee_ind'] = self.change_fee_ind
        if self.upgrade_fee_ind is not None:
            result['upgrade_fee_ind'] = self.upgrade_fee_ind
        if self.reissue_ind is not None:
            result['reissue_ind'] = self.reissue_ind
        if self.penalty_type_code is not None:
            result['penalty_type_code'] = self.penalty_type_code
        if self.penalty_apply_range_code is not None:
            result['penalty_apply_range_code'] = self.penalty_apply_range_code
        if self.penalty_charge_type_code is not None:
            result['penalty_charge_type_code'] = self.penalty_charge_type_code
        if self.fee is not None:
            result['fee'] = self.fee
        if self.currency is not None:
            result['currency'] = self.currency
        if self.penalty_percent is not None:
            result['penalty_percent'] = self.penalty_percent
        if self.start_time is not None:
            result['start_time'] = self.start_time
        if self.end_time is not None:
            result['end_time'] = self.end_time
        if self.time_unit_code is not None:
            result['time_unit_code'] = self.time_unit_code
        if self.title is not None:
            result['title'] = self.title
        if self.dep_time is not None:
            result['dep_time'] = self.dep_time
        if self.segment_number is not None:
            result['segment_number'] = self.segment_number
        if self.desc_infos is not None:
            result['desc_infos'] = self.desc_infos
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('struct') is not None:
            self.struct = m.get('struct')
        if m.get('cancel_fee_ind') is not None:
            self.cancel_fee_ind = m.get('cancel_fee_ind')
        if m.get('change_fee_ind') is not None:
            self.change_fee_ind = m.get('change_fee_ind')
        if m.get('upgrade_fee_ind') is not None:
            self.upgrade_fee_ind = m.get('upgrade_fee_ind')
        if m.get('reissue_ind') is not None:
            self.reissue_ind = m.get('reissue_ind')
        if m.get('penalty_type_code') is not None:
            self.penalty_type_code = m.get('penalty_type_code')
        if m.get('penalty_apply_range_code') is not None:
            self.penalty_apply_range_code = m.get('penalty_apply_range_code')
        if m.get('penalty_charge_type_code') is not None:
            self.penalty_charge_type_code = m.get('penalty_charge_type_code')
        if m.get('fee') is not None:
            self.fee = m.get('fee')
        if m.get('currency') is not None:
            self.currency = m.get('currency')
        if m.get('penalty_percent') is not None:
            self.penalty_percent = m.get('penalty_percent')
        if m.get('start_time') is not None:
            self.start_time = m.get('start_time')
        if m.get('end_time') is not None:
            self.end_time = m.get('end_time')
        if m.get('time_unit_code') is not None:
            self.time_unit_code = m.get('time_unit_code')
        if m.get('title') is not None:
            self.title = m.get('title')
        if m.get('dep_time') is not None:
            self.dep_time = m.get('dep_time')
        if m.get('segment_number') is not None:
            self.segment_number = m.get('segment_number')
        if m.get('desc_infos') is not None:
            self.desc_infos = m.get('desc_infos')
        return self


class ModuleGroupItemShoppingItemMapValueCabinQuantityListSegmentPosition(TeaModel):
    def __init__(
        self,
        journey_index: int = None,
        segment_index: int = None,
    ):
        self.journey_index = journey_index
        self.segment_index = segment_index

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.journey_index is not None:
            result['journey_index'] = self.journey_index
        if self.segment_index is not None:
            result['segment_index'] = self.segment_index
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('journey_index') is not None:
            self.journey_index = m.get('journey_index')
        if m.get('segment_index') is not None:
            self.segment_index = m.get('segment_index')
        return self


class ModuleGroupItemShoppingItemMapValueCabinQuantityListCabin(TeaModel):
    def __init__(
        self,
        cabin: str = None,
        cabin_class: str = None,
        cabin_class_name: str = None,
        quantity: str = None,
    ):
        self.cabin = cabin
        self.cabin_class = cabin_class
        self.cabin_class_name = cabin_class_name
        self.quantity = quantity

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.cabin is not None:
            result['cabin'] = self.cabin
        if self.cabin_class is not None:
            result['cabin_class'] = self.cabin_class
        if self.cabin_class_name is not None:
            result['cabin_class_name'] = self.cabin_class_name
        if self.quantity is not None:
            result['quantity'] = self.quantity
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('cabin') is not None:
            self.cabin = m.get('cabin')
        if m.get('cabin_class') is not None:
            self.cabin_class = m.get('cabin_class')
        if m.get('cabin_class_name') is not None:
            self.cabin_class_name = m.get('cabin_class_name')
        if m.get('quantity') is not None:
            self.quantity = m.get('quantity')
        return self


class ModuleGroupItemShoppingItemMapValueCabinQuantityList(TeaModel):
    def __init__(
        self,
        segment_position: ModuleGroupItemShoppingItemMapValueCabinQuantityListSegmentPosition = None,
        cabin: ModuleGroupItemShoppingItemMapValueCabinQuantityListCabin = None,
    ):
        self.segment_position = segment_position
        self.cabin = cabin

    def validate(self):
        if self.segment_position:
            self.segment_position.validate()
        if self.cabin:
            self.cabin.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.segment_position is not None:
            result['segment_position'] = self.segment_position.to_map()
        if self.cabin is not None:
            result['cabin'] = self.cabin.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('segment_position') is not None:
            temp_model = ModuleGroupItemShoppingItemMapValueCabinQuantityListSegmentPosition()
            self.segment_position = temp_model.from_map(m['segment_position'])
        if m.get('cabin') is not None:
            temp_model = ModuleGroupItemShoppingItemMapValueCabinQuantityListCabin()
            self.cabin = temp_model.from_map(m['cabin'])
        return self


class ModuleGroupItemShoppingItemMapValueSearchPrice(TeaModel):
    def __init__(
        self,
        ticket_price: int = None,
        sell_price: int = None,
        tax: int = None,
    ):
        self.ticket_price = ticket_price
        self.sell_price = sell_price
        self.tax = tax

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.ticket_price is not None:
            result['ticket_price'] = self.ticket_price
        if self.sell_price is not None:
            result['sell_price'] = self.sell_price
        if self.tax is not None:
            result['tax'] = self.tax
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ticket_price') is not None:
            self.ticket_price = m.get('ticket_price')
        if m.get('sell_price') is not None:
            self.sell_price = m.get('sell_price')
        if m.get('tax') is not None:
            self.tax = m.get('tax')
        return self


class ModuleGroupItemShoppingItemMapValueSegmentPriceListSegmentPosition(TeaModel):
    def __init__(
        self,
        journey_index: int = None,
        segment_index: int = None,
    ):
        self.journey_index = journey_index
        self.segment_index = segment_index

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.journey_index is not None:
            result['journey_index'] = self.journey_index
        if self.segment_index is not None:
            result['segment_index'] = self.segment_index
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('journey_index') is not None:
            self.journey_index = m.get('journey_index')
        if m.get('segment_index') is not None:
            self.segment_index = m.get('segment_index')
        return self


class ModuleGroupItemShoppingItemMapValueSegmentPriceListSearchPrice(TeaModel):
    def __init__(
        self,
        ticket_price: int = None,
        sell_price: int = None,
        tax: int = None,
    ):
        self.ticket_price = ticket_price
        self.sell_price = sell_price
        self.tax = tax

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.ticket_price is not None:
            result['ticket_price'] = self.ticket_price
        if self.sell_price is not None:
            result['sell_price'] = self.sell_price
        if self.tax is not None:
            result['tax'] = self.tax
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ticket_price') is not None:
            self.ticket_price = m.get('ticket_price')
        if m.get('sell_price') is not None:
            self.sell_price = m.get('sell_price')
        if m.get('tax') is not None:
            self.tax = m.get('tax')
        return self


class ModuleGroupItemShoppingItemMapValueSegmentPriceList(TeaModel):
    def __init__(
        self,
        segment_position: ModuleGroupItemShoppingItemMapValueSegmentPriceListSegmentPosition = None,
        search_price: ModuleGroupItemShoppingItemMapValueSegmentPriceListSearchPrice = None,
    ):
        self.segment_position = segment_position
        self.search_price = search_price

    def validate(self):
        if self.segment_position:
            self.segment_position.validate()
        if self.search_price:
            self.search_price.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.segment_position is not None:
            result['segment_position'] = self.segment_position.to_map()
        if self.search_price is not None:
            result['search_price'] = self.search_price.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('segment_position') is not None:
            temp_model = ModuleGroupItemShoppingItemMapValueSegmentPriceListSegmentPosition()
            self.segment_position = temp_model.from_map(m['segment_position'])
        if m.get('search_price') is not None:
            temp_model = ModuleGroupItemShoppingItemMapValueSegmentPriceListSearchPrice()
            self.search_price = temp_model.from_map(m['search_price'])
        return self


class ModuleGroupItemShoppingItemMapValue(TeaModel):
    def __init__(
        self,
        cabin_quantity_list: List[ModuleGroupItemShoppingItemMapValueCabinQuantityList] = None,
        search_price: ModuleGroupItemShoppingItemMapValueSearchPrice = None,
        segment_price_list: List[ModuleGroupItemShoppingItemMapValueSegmentPriceList] = None,
    ):
        self.cabin_quantity_list = cabin_quantity_list
        self.search_price = search_price
        self.segment_price_list = segment_price_list

    def validate(self):
        if self.cabin_quantity_list:
            for k in self.cabin_quantity_list:
                if k:
                    k.validate()
        if self.search_price:
            self.search_price.validate()
        if self.segment_price_list:
            for k in self.segment_price_list:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['cabin_quantity_list'] = []
        if self.cabin_quantity_list is not None:
            for k in self.cabin_quantity_list:
                result['cabin_quantity_list'].append(k.to_map() if k else None)
        if self.search_price is not None:
            result['search_price'] = self.search_price.to_map()
        result['segment_price_list'] = []
        if self.segment_price_list is not None:
            for k in self.segment_price_list:
                result['segment_price_list'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.cabin_quantity_list = []
        if m.get('cabin_quantity_list') is not None:
            for k in m.get('cabin_quantity_list'):
                temp_model = ModuleGroupItemShoppingItemMapValueCabinQuantityList()
                self.cabin_quantity_list.append(temp_model.from_map(k))
        if m.get('search_price') is not None:
            temp_model = ModuleGroupItemShoppingItemMapValueSearchPrice()
            self.search_price = temp_model.from_map(m['search_price'])
        self.segment_price_list = []
        if m.get('segment_price_list') is not None:
            for k in m.get('segment_price_list'):
                temp_model = ModuleGroupItemShoppingItemMapValueSegmentPriceList()
                self.segment_price_list.append(temp_model.from_map(k))
        return self


class ModuleGroupItemSubItemPositionMapValue(TeaModel):
    def __init__(
        self,
        journey_index: int = None,
        segment_index: int = None,
    ):
        self.journey_index = journey_index
        self.segment_index = segment_index

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.journey_index is not None:
            result['journey_index'] = self.journey_index
        if self.segment_index is not None:
            result['segment_index'] = self.segment_index
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('journey_index') is not None:
            self.journey_index = m.get('journey_index')
        if m.get('segment_index') is not None:
            self.segment_index = m.get('segment_index')
        return self


class ModuleGroupItemSubItemsBaggageRuleBaggageInfoMapValue(TeaModel):
    def __init__(
        self,
        carry_freepc: int = None,
        carry_bag_weight: int = None,
        carry_bag_size: str = None,
        is_all_carry_bag_weight: bool = None,
        airline: str = None,
        start_airport: str = None,
        end_airport: str = None,
        start_city_code: str = None,
        end_city_code: str = None,
        free_pcs: int = None,
        baggage_weight: int = None,
        baggage_unit: str = None,
        baggage_size: str = None,
        all_weight: bool = None,
    ):
        self.carry_freepc = carry_freepc
        self.carry_bag_weight = carry_bag_weight
        self.carry_bag_size = carry_bag_size
        self.is_all_carry_bag_weight = is_all_carry_bag_weight
        self.airline = airline
        self.start_airport = start_airport
        self.end_airport = end_airport
        self.start_city_code = start_city_code
        self.end_city_code = end_city_code
        self.free_pcs = free_pcs
        self.baggage_weight = baggage_weight
        self.baggage_unit = baggage_unit
        self.baggage_size = baggage_size
        self.all_weight = all_weight

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.carry_freepc is not None:
            result['carry_freepc'] = self.carry_freepc
        if self.carry_bag_weight is not None:
            result['carry_bag_weight'] = self.carry_bag_weight
        if self.carry_bag_size is not None:
            result['carry_bag_size'] = self.carry_bag_size
        if self.is_all_carry_bag_weight is not None:
            result['is_all_carry_bag_weight'] = self.is_all_carry_bag_weight
        if self.airline is not None:
            result['airline'] = self.airline
        if self.start_airport is not None:
            result['start_airport'] = self.start_airport
        if self.end_airport is not None:
            result['end_airport'] = self.end_airport
        if self.start_city_code is not None:
            result['start_city_code'] = self.start_city_code
        if self.end_city_code is not None:
            result['end_city_code'] = self.end_city_code
        if self.free_pcs is not None:
            result['free_pcs'] = self.free_pcs
        if self.baggage_weight is not None:
            result['baggage_weight'] = self.baggage_weight
        if self.baggage_unit is not None:
            result['baggage_unit'] = self.baggage_unit
        if self.baggage_size is not None:
            result['baggage_size'] = self.baggage_size
        if self.all_weight is not None:
            result['all_weight'] = self.all_weight
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('carry_freepc') is not None:
            self.carry_freepc = m.get('carry_freepc')
        if m.get('carry_bag_weight') is not None:
            self.carry_bag_weight = m.get('carry_bag_weight')
        if m.get('carry_bag_size') is not None:
            self.carry_bag_size = m.get('carry_bag_size')
        if m.get('is_all_carry_bag_weight') is not None:
            self.is_all_carry_bag_weight = m.get('is_all_carry_bag_weight')
        if m.get('airline') is not None:
            self.airline = m.get('airline')
        if m.get('start_airport') is not None:
            self.start_airport = m.get('start_airport')
        if m.get('end_airport') is not None:
            self.end_airport = m.get('end_airport')
        if m.get('start_city_code') is not None:
            self.start_city_code = m.get('start_city_code')
        if m.get('end_city_code') is not None:
            self.end_city_code = m.get('end_city_code')
        if m.get('free_pcs') is not None:
            self.free_pcs = m.get('free_pcs')
        if m.get('baggage_weight') is not None:
            self.baggage_weight = m.get('baggage_weight')
        if m.get('baggage_unit') is not None:
            self.baggage_unit = m.get('baggage_unit')
        if m.get('baggage_size') is not None:
            self.baggage_size = m.get('baggage_size')
        if m.get('all_weight') is not None:
            self.all_weight = m.get('all_weight')
        return self


class ModuleGroupItemSubItemsRefundChangeRuleOfferPenaltyInfoMapValue(TeaModel):
    def __init__(
        self,
        struct: bool = None,
        cancel_fee_ind: bool = None,
        change_fee_ind: bool = None,
        upgrade_fee_ind: bool = None,
        reissue_ind: bool = None,
        penalty_type_code: int = None,
        penalty_apply_range_code: int = None,
        penalty_charge_type_code: int = None,
        fee: float = None,
        currency: str = None,
        penalty_percent: float = None,
        start_time: int = None,
        end_time: int = None,
        time_unit_code: int = None,
    ):
        self.struct = struct
        self.cancel_fee_ind = cancel_fee_ind
        self.change_fee_ind = change_fee_ind
        self.upgrade_fee_ind = upgrade_fee_ind
        self.reissue_ind = reissue_ind
        self.penalty_type_code = penalty_type_code
        self.penalty_apply_range_code = penalty_apply_range_code
        self.penalty_charge_type_code = penalty_charge_type_code
        self.fee = fee
        self.currency = currency
        self.penalty_percent = penalty_percent
        self.start_time = start_time
        self.end_time = end_time
        self.time_unit_code = time_unit_code

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.struct is not None:
            result['struct'] = self.struct
        if self.cancel_fee_ind is not None:
            result['cancel_fee_ind'] = self.cancel_fee_ind
        if self.change_fee_ind is not None:
            result['change_fee_ind'] = self.change_fee_ind
        if self.upgrade_fee_ind is not None:
            result['upgrade_fee_ind'] = self.upgrade_fee_ind
        if self.reissue_ind is not None:
            result['reissue_ind'] = self.reissue_ind
        if self.penalty_type_code is not None:
            result['penalty_type_code'] = self.penalty_type_code
        if self.penalty_apply_range_code is not None:
            result['penalty_apply_range_code'] = self.penalty_apply_range_code
        if self.penalty_charge_type_code is not None:
            result['penalty_charge_type_code'] = self.penalty_charge_type_code
        if self.fee is not None:
            result['fee'] = self.fee
        if self.currency is not None:
            result['currency'] = self.currency
        if self.penalty_percent is not None:
            result['penalty_percent'] = self.penalty_percent
        if self.start_time is not None:
            result['start_time'] = self.start_time
        if self.end_time is not None:
            result['end_time'] = self.end_time
        if self.time_unit_code is not None:
            result['time_unit_code'] = self.time_unit_code
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('struct') is not None:
            self.struct = m.get('struct')
        if m.get('cancel_fee_ind') is not None:
            self.cancel_fee_ind = m.get('cancel_fee_ind')
        if m.get('change_fee_ind') is not None:
            self.change_fee_ind = m.get('change_fee_ind')
        if m.get('upgrade_fee_ind') is not None:
            self.upgrade_fee_ind = m.get('upgrade_fee_ind')
        if m.get('reissue_ind') is not None:
            self.reissue_ind = m.get('reissue_ind')
        if m.get('penalty_type_code') is not None:
            self.penalty_type_code = m.get('penalty_type_code')
        if m.get('penalty_apply_range_code') is not None:
            self.penalty_apply_range_code = m.get('penalty_apply_range_code')
        if m.get('penalty_charge_type_code') is not None:
            self.penalty_charge_type_code = m.get('penalty_charge_type_code')
        if m.get('fee') is not None:
            self.fee = m.get('fee')
        if m.get('currency') is not None:
            self.currency = m.get('currency')
        if m.get('penalty_percent') is not None:
            self.penalty_percent = m.get('penalty_percent')
        if m.get('start_time') is not None:
            self.start_time = m.get('start_time')
        if m.get('end_time') is not None:
            self.end_time = m.get('end_time')
        if m.get('time_unit_code') is not None:
            self.time_unit_code = m.get('time_unit_code')
        return self


class ModuleGroupItemSubItemsShoppingItemMapValueSearchPrice(TeaModel):
    def __init__(
        self,
        ticket_price: int = None,
        sell_price: int = None,
        tax: int = None,
    ):
        self.ticket_price = ticket_price
        self.sell_price = sell_price
        self.tax = tax

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.ticket_price is not None:
            result['ticket_price'] = self.ticket_price
        if self.sell_price is not None:
            result['sell_price'] = self.sell_price
        if self.tax is not None:
            result['tax'] = self.tax
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ticket_price') is not None:
            self.ticket_price = m.get('ticket_price')
        if m.get('sell_price') is not None:
            self.sell_price = m.get('sell_price')
        if m.get('tax') is not None:
            self.tax = m.get('tax')
        return self


class ModuleGroupItemSubItemsShoppingItemMapValue(TeaModel):
    def __init__(
        self,
        search_price: ModuleGroupItemSubItemsShoppingItemMapValueSearchPrice = None,
    ):
        self.search_price = search_price

    def validate(self):
        if self.search_price:
            self.search_price.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.search_price is not None:
            result['search_price'] = self.search_price.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('search_price') is not None:
            temp_model = ModuleGroupItemSubItemsShoppingItemMapValueSearchPrice()
            self.search_price = temp_model.from_map(m['search_price'])
        return self


class ModuleItemListSubItemsBaggageRuleOfferBaggageInfoMapValue(TeaModel):
    def __init__(
        self,
        start_city_code: str = None,
        end_city_code: str = None,
        carry_free_pc: int = None,
        carry_bag_weight: int = None,
        carry_bag_size: str = None,
        is_all_carry_bag_weight: bool = None,
        total_pcs: int = None,
        total_weight: int = None,
        carry_unknown: bool = None,
        carry_length: int = None,
        carry_width: int = None,
        carry_height: int = None,
        carry_sum_of_length_width_height: int = None,
        free_pcs: int = None,
        baggage_weight: int = None,
        baggage_unit: str = None,
        baggage_size: str = None,
        all_weight: bool = None,
        length: int = None,
        width: int = None,
        height: int = None,
        sum_of_length_width_height: int = None,
        unknown: bool = None,
        cn_desc: str = None,
        en_desc: str = None,
        attribute: str = None,
        baggage_price: int = None,
        carry_on_baggage_tips: str = None,
    ):
        self.start_city_code = start_city_code
        self.end_city_code = end_city_code
        self.carry_free_pc = carry_free_pc
        self.carry_bag_weight = carry_bag_weight
        self.carry_bag_size = carry_bag_size
        self.is_all_carry_bag_weight = is_all_carry_bag_weight
        self.total_pcs = total_pcs
        self.total_weight = total_weight
        self.carry_unknown = carry_unknown
        self.carry_length = carry_length
        self.carry_width = carry_width
        self.carry_height = carry_height
        self.carry_sum_of_length_width_height = carry_sum_of_length_width_height
        self.free_pcs = free_pcs
        self.baggage_weight = baggage_weight
        self.baggage_unit = baggage_unit
        self.baggage_size = baggage_size
        self.all_weight = all_weight
        self.length = length
        self.width = width
        self.height = height
        self.sum_of_length_width_height = sum_of_length_width_height
        self.unknown = unknown
        self.cn_desc = cn_desc
        self.en_desc = en_desc
        self.attribute = attribute
        self.baggage_price = baggage_price
        self.carry_on_baggage_tips = carry_on_baggage_tips

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.start_city_code is not None:
            result['start_city_code'] = self.start_city_code
        if self.end_city_code is not None:
            result['end_city_code'] = self.end_city_code
        if self.carry_free_pc is not None:
            result['carry_free_pc'] = self.carry_free_pc
        if self.carry_bag_weight is not None:
            result['carry_bag_weight'] = self.carry_bag_weight
        if self.carry_bag_size is not None:
            result['carry_bag_size'] = self.carry_bag_size
        if self.is_all_carry_bag_weight is not None:
            result['is_all_carry_bag_weight'] = self.is_all_carry_bag_weight
        if self.total_pcs is not None:
            result['total_pcs'] = self.total_pcs
        if self.total_weight is not None:
            result['total_weight'] = self.total_weight
        if self.carry_unknown is not None:
            result['carry_unknown'] = self.carry_unknown
        if self.carry_length is not None:
            result['carry_length'] = self.carry_length
        if self.carry_width is not None:
            result['carry_width'] = self.carry_width
        if self.carry_height is not None:
            result['carry_height'] = self.carry_height
        if self.carry_sum_of_length_width_height is not None:
            result['carry_sum_of_length_width_height'] = self.carry_sum_of_length_width_height
        if self.free_pcs is not None:
            result['free_pcs'] = self.free_pcs
        if self.baggage_weight is not None:
            result['baggage_weight'] = self.baggage_weight
        if self.baggage_unit is not None:
            result['baggage_unit'] = self.baggage_unit
        if self.baggage_size is not None:
            result['baggage_size'] = self.baggage_size
        if self.all_weight is not None:
            result['all_weight'] = self.all_weight
        if self.length is not None:
            result['length'] = self.length
        if self.width is not None:
            result['width'] = self.width
        if self.height is not None:
            result['height'] = self.height
        if self.sum_of_length_width_height is not None:
            result['sum_of_length_width_height'] = self.sum_of_length_width_height
        if self.unknown is not None:
            result['unknown'] = self.unknown
        if self.cn_desc is not None:
            result['cn_desc'] = self.cn_desc
        if self.en_desc is not None:
            result['en_desc'] = self.en_desc
        if self.attribute is not None:
            result['attribute'] = self.attribute
        if self.baggage_price is not None:
            result['baggage_price'] = self.baggage_price
        if self.carry_on_baggage_tips is not None:
            result['carry_on_baggage_tips'] = self.carry_on_baggage_tips
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('start_city_code') is not None:
            self.start_city_code = m.get('start_city_code')
        if m.get('end_city_code') is not None:
            self.end_city_code = m.get('end_city_code')
        if m.get('carry_free_pc') is not None:
            self.carry_free_pc = m.get('carry_free_pc')
        if m.get('carry_bag_weight') is not None:
            self.carry_bag_weight = m.get('carry_bag_weight')
        if m.get('carry_bag_size') is not None:
            self.carry_bag_size = m.get('carry_bag_size')
        if m.get('is_all_carry_bag_weight') is not None:
            self.is_all_carry_bag_weight = m.get('is_all_carry_bag_weight')
        if m.get('total_pcs') is not None:
            self.total_pcs = m.get('total_pcs')
        if m.get('total_weight') is not None:
            self.total_weight = m.get('total_weight')
        if m.get('carry_unknown') is not None:
            self.carry_unknown = m.get('carry_unknown')
        if m.get('carry_length') is not None:
            self.carry_length = m.get('carry_length')
        if m.get('carry_width') is not None:
            self.carry_width = m.get('carry_width')
        if m.get('carry_height') is not None:
            self.carry_height = m.get('carry_height')
        if m.get('carry_sum_of_length_width_height') is not None:
            self.carry_sum_of_length_width_height = m.get('carry_sum_of_length_width_height')
        if m.get('free_pcs') is not None:
            self.free_pcs = m.get('free_pcs')
        if m.get('baggage_weight') is not None:
            self.baggage_weight = m.get('baggage_weight')
        if m.get('baggage_unit') is not None:
            self.baggage_unit = m.get('baggage_unit')
        if m.get('baggage_size') is not None:
            self.baggage_size = m.get('baggage_size')
        if m.get('all_weight') is not None:
            self.all_weight = m.get('all_weight')
        if m.get('length') is not None:
            self.length = m.get('length')
        if m.get('width') is not None:
            self.width = m.get('width')
        if m.get('height') is not None:
            self.height = m.get('height')
        if m.get('sum_of_length_width_height') is not None:
            self.sum_of_length_width_height = m.get('sum_of_length_width_height')
        if m.get('unknown') is not None:
            self.unknown = m.get('unknown')
        if m.get('cn_desc') is not None:
            self.cn_desc = m.get('cn_desc')
        if m.get('en_desc') is not None:
            self.en_desc = m.get('en_desc')
        if m.get('attribute') is not None:
            self.attribute = m.get('attribute')
        if m.get('baggage_price') is not None:
            self.baggage_price = m.get('baggage_price')
        if m.get('carry_on_baggage_tips') is not None:
            self.carry_on_baggage_tips = m.get('carry_on_baggage_tips')
        return self


class ModuleItemListSubItemsRefundChangeRuleOfferPenaltyInfoMapValue(TeaModel):
    def __init__(
        self,
        struct: bool = None,
        cancel_fee_ind: bool = None,
        change_fee_ind: bool = None,
        upgrade_fee_ind: bool = None,
        reissue_ind: bool = None,
        penalty_type_code: int = None,
        penalty_apply_range_code: int = None,
        penalty_charge_type_code: int = None,
        fee: float = None,
        currency: str = None,
        penalty_percent: float = None,
        start_time: int = None,
        end_time: int = None,
        time_unit_code: int = None,
        title: str = None,
        dep_time: str = None,
        segment_number: str = None,
        desc_infos: Dict[str, str] = None,
    ):
        self.struct = struct
        self.cancel_fee_ind = cancel_fee_ind
        self.change_fee_ind = change_fee_ind
        self.upgrade_fee_ind = upgrade_fee_ind
        self.reissue_ind = reissue_ind
        self.penalty_type_code = penalty_type_code
        self.penalty_apply_range_code = penalty_apply_range_code
        self.penalty_charge_type_code = penalty_charge_type_code
        self.fee = fee
        self.currency = currency
        self.penalty_percent = penalty_percent
        self.start_time = start_time
        self.end_time = end_time
        self.time_unit_code = time_unit_code
        self.title = title
        self.dep_time = dep_time
        self.segment_number = segment_number
        self.desc_infos = desc_infos

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.struct is not None:
            result['struct'] = self.struct
        if self.cancel_fee_ind is not None:
            result['cancel_fee_ind'] = self.cancel_fee_ind
        if self.change_fee_ind is not None:
            result['change_fee_ind'] = self.change_fee_ind
        if self.upgrade_fee_ind is not None:
            result['upgrade_fee_ind'] = self.upgrade_fee_ind
        if self.reissue_ind is not None:
            result['reissue_ind'] = self.reissue_ind
        if self.penalty_type_code is not None:
            result['penalty_type_code'] = self.penalty_type_code
        if self.penalty_apply_range_code is not None:
            result['penalty_apply_range_code'] = self.penalty_apply_range_code
        if self.penalty_charge_type_code is not None:
            result['penalty_charge_type_code'] = self.penalty_charge_type_code
        if self.fee is not None:
            result['fee'] = self.fee
        if self.currency is not None:
            result['currency'] = self.currency
        if self.penalty_percent is not None:
            result['penalty_percent'] = self.penalty_percent
        if self.start_time is not None:
            result['start_time'] = self.start_time
        if self.end_time is not None:
            result['end_time'] = self.end_time
        if self.time_unit_code is not None:
            result['time_unit_code'] = self.time_unit_code
        if self.title is not None:
            result['title'] = self.title
        if self.dep_time is not None:
            result['dep_time'] = self.dep_time
        if self.segment_number is not None:
            result['segment_number'] = self.segment_number
        if self.desc_infos is not None:
            result['desc_infos'] = self.desc_infos
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('struct') is not None:
            self.struct = m.get('struct')
        if m.get('cancel_fee_ind') is not None:
            self.cancel_fee_ind = m.get('cancel_fee_ind')
        if m.get('change_fee_ind') is not None:
            self.change_fee_ind = m.get('change_fee_ind')
        if m.get('upgrade_fee_ind') is not None:
            self.upgrade_fee_ind = m.get('upgrade_fee_ind')
        if m.get('reissue_ind') is not None:
            self.reissue_ind = m.get('reissue_ind')
        if m.get('penalty_type_code') is not None:
            self.penalty_type_code = m.get('penalty_type_code')
        if m.get('penalty_apply_range_code') is not None:
            self.penalty_apply_range_code = m.get('penalty_apply_range_code')
        if m.get('penalty_charge_type_code') is not None:
            self.penalty_charge_type_code = m.get('penalty_charge_type_code')
        if m.get('fee') is not None:
            self.fee = m.get('fee')
        if m.get('currency') is not None:
            self.currency = m.get('currency')
        if m.get('penalty_percent') is not None:
            self.penalty_percent = m.get('penalty_percent')
        if m.get('start_time') is not None:
            self.start_time = m.get('start_time')
        if m.get('end_time') is not None:
            self.end_time = m.get('end_time')
        if m.get('time_unit_code') is not None:
            self.time_unit_code = m.get('time_unit_code')
        if m.get('title') is not None:
            self.title = m.get('title')
        if m.get('dep_time') is not None:
            self.dep_time = m.get('dep_time')
        if m.get('segment_number') is not None:
            self.segment_number = m.get('segment_number')
        if m.get('desc_infos') is not None:
            self.desc_infos = m.get('desc_infos')
        return self


class AccessTokenRequest(TeaModel):
    def __init__(
        self,
        app_secret: str = None,
    ):
        # This parameter is required.
        self.app_secret = app_secret

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.app_secret is not None:
            result['app_secret'] = self.app_secret
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('app_secret') is not None:
            self.app_secret = m.get('app_secret')
        return self


class AccessTokenResponseBodyData(TeaModel):
    def __init__(
        self,
        expire: int = None,
        token: str = None,
    ):
        self.expire = expire
        self.token = token

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.expire is not None:
            result['expire'] = self.expire
        if self.token is not None:
            result['token'] = self.token
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('expire') is not None:
            self.expire = m.get('expire')
        if m.get('token') is not None:
            self.token = m.get('token')
        return self


class AccessTokenResponseBodyModule(TeaModel):
    def __init__(
        self,
        expire: int = None,
        start: int = None,
        token: str = None,
    ):
        self.expire = expire
        self.start = start
        self.token = token

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.expire is not None:
            result['expire'] = self.expire
        if self.start is not None:
            result['start'] = self.start
        if self.token is not None:
            result['token'] = self.token
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('expire') is not None:
            self.expire = m.get('expire')
        if m.get('start') is not None:
            self.start = m.get('start')
        if m.get('token') is not None:
            self.token = m.get('token')
        return self


class AccessTokenResponseBody(TeaModel):
    def __init__(
        self,
        code: str = None,
        data: AccessTokenResponseBodyData = None,
        message: str = None,
        module: AccessTokenResponseBodyModule = None,
        request_id: str = None,
        success: bool = None,
        trace_id: str = None,
    ):
        self.code = code
        self.data = data
        self.message = message
        self.module = module
        self.request_id = request_id
        # 成功标识
        self.success = success
        # traceId
        self.trace_id = trace_id

    def validate(self):
        if self.data:
            self.data.validate()
        if self.module:
            self.module.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['code'] = self.code
        if self.data is not None:
            result['data'] = self.data.to_map()
        if self.message is not None:
            result['message'] = self.message
        if self.module is not None:
            result['module'] = self.module.to_map()
        if self.request_id is not None:
            result['requestId'] = self.request_id
        if self.success is not None:
            result['success'] = self.success
        if self.trace_id is not None:
            result['traceId'] = self.trace_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('code') is not None:
            self.code = m.get('code')
        if m.get('data') is not None:
            temp_model = AccessTokenResponseBodyData()
            self.data = temp_model.from_map(m['data'])
        if m.get('message') is not None:
            self.message = m.get('message')
        if m.get('module') is not None:
            temp_model = AccessTokenResponseBodyModule()
            self.module = temp_model.from_map(m['module'])
        if m.get('requestId') is not None:
            self.request_id = m.get('requestId')
        if m.get('success') is not None:
            self.success = m.get('success')
        if m.get('traceId') is not None:
            self.trace_id = m.get('traceId')
        return self


class AccessTokenResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: AccessTokenResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = AccessTokenResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class AddDepartmentHeaders(TeaModel):
    def __init__(
        self,
        common_headers: Dict[str, str] = None,
        x_acs_btrip_corp_token: str = None,
    ):
        self.common_headers = common_headers
        self.x_acs_btrip_corp_token = x_acs_btrip_corp_token

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.common_headers is not None:
            result['commonHeaders'] = self.common_headers
        if self.x_acs_btrip_corp_token is not None:
            result['x-acs-btrip-corp-token'] = self.x_acs_btrip_corp_token
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('commonHeaders') is not None:
            self.common_headers = m.get('commonHeaders')
        if m.get('x-acs-btrip-corp-token') is not None:
            self.x_acs_btrip_corp_token = m.get('x-acs-btrip-corp-token')
        return self


class AddDepartmentRequest(TeaModel):
    def __init__(
        self,
        dept_name: str = None,
        manager_employee_id_list: List[str] = None,
        out_dept_id: str = None,
        out_dept_pid: str = None,
    ):
        # This parameter is required.
        self.dept_name = dept_name
        self.manager_employee_id_list = manager_employee_id_list
        # This parameter is required.
        self.out_dept_id = out_dept_id
        self.out_dept_pid = out_dept_pid

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.dept_name is not None:
            result['dept_name'] = self.dept_name
        if self.manager_employee_id_list is not None:
            result['manager_employee_id_list'] = self.manager_employee_id_list
        if self.out_dept_id is not None:
            result['out_dept_id'] = self.out_dept_id
        if self.out_dept_pid is not None:
            result['out_dept_pid'] = self.out_dept_pid
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('dept_name') is not None:
            self.dept_name = m.get('dept_name')
        if m.get('manager_employee_id_list') is not None:
            self.manager_employee_id_list = m.get('manager_employee_id_list')
        if m.get('out_dept_id') is not None:
            self.out_dept_id = m.get('out_dept_id')
        if m.get('out_dept_pid') is not None:
            self.out_dept_pid = m.get('out_dept_pid')
        return self


class AddDepartmentShrinkRequest(TeaModel):
    def __init__(
        self,
        dept_name: str = None,
        manager_employee_id_list_shrink: str = None,
        out_dept_id: str = None,
        out_dept_pid: str = None,
    ):
        # This parameter is required.
        self.dept_name = dept_name
        self.manager_employee_id_list_shrink = manager_employee_id_list_shrink
        # This parameter is required.
        self.out_dept_id = out_dept_id
        self.out_dept_pid = out_dept_pid

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.dept_name is not None:
            result['dept_name'] = self.dept_name
        if self.manager_employee_id_list_shrink is not None:
            result['manager_employee_id_list'] = self.manager_employee_id_list_shrink
        if self.out_dept_id is not None:
            result['out_dept_id'] = self.out_dept_id
        if self.out_dept_pid is not None:
            result['out_dept_pid'] = self.out_dept_pid
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('dept_name') is not None:
            self.dept_name = m.get('dept_name')
        if m.get('manager_employee_id_list') is not None:
            self.manager_employee_id_list_shrink = m.get('manager_employee_id_list')
        if m.get('out_dept_id') is not None:
            self.out_dept_id = m.get('out_dept_id')
        if m.get('out_dept_pid') is not None:
            self.out_dept_pid = m.get('out_dept_pid')
        return self


class AddDepartmentResponseBody(TeaModel):
    def __init__(
        self,
        code: str = None,
        http_status_code: int = None,
        message: str = None,
        request_id: str = None,
        success: bool = None,
        trace_id: str = None,
    ):
        self.code = code
        self.http_status_code = http_status_code
        self.message = message
        self.request_id = request_id
        self.success = success
        # traceId
        self.trace_id = trace_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['code'] = self.code
        if self.http_status_code is not None:
            result['httpStatusCode'] = self.http_status_code
        if self.message is not None:
            result['message'] = self.message
        if self.request_id is not None:
            result['requestId'] = self.request_id
        if self.success is not None:
            result['success'] = self.success
        if self.trace_id is not None:
            result['traceId'] = self.trace_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('code') is not None:
            self.code = m.get('code')
        if m.get('httpStatusCode') is not None:
            self.http_status_code = m.get('httpStatusCode')
        if m.get('message') is not None:
            self.message = m.get('message')
        if m.get('requestId') is not None:
            self.request_id = m.get('requestId')
        if m.get('success') is not None:
            self.success = m.get('success')
        if m.get('traceId') is not None:
            self.trace_id = m.get('traceId')
        return self


class AddDepartmentResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: AddDepartmentResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = AddDepartmentResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class AddEmployeeHeaders(TeaModel):
    def __init__(
        self,
        common_headers: Dict[str, str] = None,
        x_acs_btrip_corp_token: str = None,
    ):
        self.common_headers = common_headers
        self.x_acs_btrip_corp_token = x_acs_btrip_corp_token

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.common_headers is not None:
            result['commonHeaders'] = self.common_headers
        if self.x_acs_btrip_corp_token is not None:
            result['x-acs-btrip-corp-token'] = self.x_acs_btrip_corp_token
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('commonHeaders') is not None:
            self.common_headers = m.get('commonHeaders')
        if m.get('x-acs-btrip-corp-token') is not None:
            self.x_acs_btrip_corp_token = m.get('x-acs-btrip-corp-token')
        return self


class AddEmployeeRequestBaseLocationList(TeaModel):
    def __init__(
        self,
        code: str = None,
        level: str = None,
    ):
        self.code = code
        self.level = level

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['code'] = self.code
        if self.level is not None:
            result['level'] = self.level
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('code') is not None:
            self.code = m.get('code')
        if m.get('level') is not None:
            self.level = m.get('level')
        return self


class AddEmployeeRequestCertList(TeaModel):
    def __init__(
        self,
        birthday: str = None,
        cert_expired_time: str = None,
        cert_nation: str = None,
        cert_no: str = None,
        cert_type: int = None,
        gender: str = None,
        nationality: str = None,
        phone: str = None,
        real_name: str = None,
        real_name_en: str = None,
    ):
        self.birthday = birthday
        self.cert_expired_time = cert_expired_time
        self.cert_nation = cert_nation
        self.cert_no = cert_no
        self.cert_type = cert_type
        self.gender = gender
        self.nationality = nationality
        self.phone = phone
        self.real_name = real_name
        self.real_name_en = real_name_en

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.birthday is not None:
            result['birthday'] = self.birthday
        if self.cert_expired_time is not None:
            result['cert_expired_time'] = self.cert_expired_time
        if self.cert_nation is not None:
            result['cert_nation'] = self.cert_nation
        if self.cert_no is not None:
            result['cert_no'] = self.cert_no
        if self.cert_type is not None:
            result['cert_type'] = self.cert_type
        if self.gender is not None:
            result['gender'] = self.gender
        if self.nationality is not None:
            result['nationality'] = self.nationality
        if self.phone is not None:
            result['phone'] = self.phone
        if self.real_name is not None:
            result['real_name'] = self.real_name
        if self.real_name_en is not None:
            result['real_name_en'] = self.real_name_en
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('birthday') is not None:
            self.birthday = m.get('birthday')
        if m.get('cert_expired_time') is not None:
            self.cert_expired_time = m.get('cert_expired_time')
        if m.get('cert_nation') is not None:
            self.cert_nation = m.get('cert_nation')
        if m.get('cert_no') is not None:
            self.cert_no = m.get('cert_no')
        if m.get('cert_type') is not None:
            self.cert_type = m.get('cert_type')
        if m.get('gender') is not None:
            self.gender = m.get('gender')
        if m.get('nationality') is not None:
            self.nationality = m.get('nationality')
        if m.get('phone') is not None:
            self.phone = m.get('phone')
        if m.get('real_name') is not None:
            self.real_name = m.get('real_name')
        if m.get('real_name_en') is not None:
            self.real_name_en = m.get('real_name_en')
        return self


class AddEmployeeRequest(TeaModel):
    def __init__(
        self,
        account_email: str = None,
        account_phone: str = None,
        attribute: str = None,
        avatar: str = None,
        base_city_code_list: List[str] = None,
        base_location_list: List[AddEmployeeRequestBaseLocationList] = None,
        birthday: str = None,
        cert_list: List[AddEmployeeRequestCertList] = None,
        custom_role_code_list: List[str] = None,
        email: str = None,
        gender: str = None,
        is_admin: bool = None,
        is_boss: bool = None,
        is_dept_leader: bool = None,
        job_no: str = None,
        manager_user_id: str = None,
        out_dept_id_list: List[str] = None,
        phone: str = None,
        position_level: str = None,
        real_name: str = None,
        real_name_en: str = None,
        union_id: str = None,
        user_id: str = None,
        user_nick: str = None,
    ):
        self.account_email = account_email
        self.account_phone = account_phone
        self.attribute = attribute
        self.avatar = avatar
        self.base_city_code_list = base_city_code_list
        self.base_location_list = base_location_list
        self.birthday = birthday
        self.cert_list = cert_list
        self.custom_role_code_list = custom_role_code_list
        self.email = email
        self.gender = gender
        self.is_admin = is_admin
        self.is_boss = is_boss
        self.is_dept_leader = is_dept_leader
        self.job_no = job_no
        self.manager_user_id = manager_user_id
        self.out_dept_id_list = out_dept_id_list
        self.phone = phone
        self.position_level = position_level
        self.real_name = real_name
        self.real_name_en = real_name_en
        self.union_id = union_id
        # This parameter is required.
        self.user_id = user_id
        # This parameter is required.
        self.user_nick = user_nick

    def validate(self):
        if self.base_location_list:
            for k in self.base_location_list:
                if k:
                    k.validate()
        if self.cert_list:
            for k in self.cert_list:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.account_email is not None:
            result['account_email'] = self.account_email
        if self.account_phone is not None:
            result['account_phone'] = self.account_phone
        if self.attribute is not None:
            result['attribute'] = self.attribute
        if self.avatar is not None:
            result['avatar'] = self.avatar
        if self.base_city_code_list is not None:
            result['base_city_code_list'] = self.base_city_code_list
        result['base_location_list'] = []
        if self.base_location_list is not None:
            for k in self.base_location_list:
                result['base_location_list'].append(k.to_map() if k else None)
        if self.birthday is not None:
            result['birthday'] = self.birthday
        result['cert_list'] = []
        if self.cert_list is not None:
            for k in self.cert_list:
                result['cert_list'].append(k.to_map() if k else None)
        if self.custom_role_code_list is not None:
            result['custom_role_code_list'] = self.custom_role_code_list
        if self.email is not None:
            result['email'] = self.email
        if self.gender is not None:
            result['gender'] = self.gender
        if self.is_admin is not None:
            result['is_admin'] = self.is_admin
        if self.is_boss is not None:
            result['is_boss'] = self.is_boss
        if self.is_dept_leader is not None:
            result['is_dept_leader'] = self.is_dept_leader
        if self.job_no is not None:
            result['job_no'] = self.job_no
        if self.manager_user_id is not None:
            result['manager_user_id'] = self.manager_user_id
        if self.out_dept_id_list is not None:
            result['out_dept_id_list'] = self.out_dept_id_list
        if self.phone is not None:
            result['phone'] = self.phone
        if self.position_level is not None:
            result['position_level'] = self.position_level
        if self.real_name is not None:
            result['real_name'] = self.real_name
        if self.real_name_en is not None:
            result['real_name_en'] = self.real_name_en
        if self.union_id is not None:
            result['union_id'] = self.union_id
        if self.user_id is not None:
            result['user_id'] = self.user_id
        if self.user_nick is not None:
            result['user_nick'] = self.user_nick
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('account_email') is not None:
            self.account_email = m.get('account_email')
        if m.get('account_phone') is not None:
            self.account_phone = m.get('account_phone')
        if m.get('attribute') is not None:
            self.attribute = m.get('attribute')
        if m.get('avatar') is not None:
            self.avatar = m.get('avatar')
        if m.get('base_city_code_list') is not None:
            self.base_city_code_list = m.get('base_city_code_list')
        self.base_location_list = []
        if m.get('base_location_list') is not None:
            for k in m.get('base_location_list'):
                temp_model = AddEmployeeRequestBaseLocationList()
                self.base_location_list.append(temp_model.from_map(k))
        if m.get('birthday') is not None:
            self.birthday = m.get('birthday')
        self.cert_list = []
        if m.get('cert_list') is not None:
            for k in m.get('cert_list'):
                temp_model = AddEmployeeRequestCertList()
                self.cert_list.append(temp_model.from_map(k))
        if m.get('custom_role_code_list') is not None:
            self.custom_role_code_list = m.get('custom_role_code_list')
        if m.get('email') is not None:
            self.email = m.get('email')
        if m.get('gender') is not None:
            self.gender = m.get('gender')
        if m.get('is_admin') is not None:
            self.is_admin = m.get('is_admin')
        if m.get('is_boss') is not None:
            self.is_boss = m.get('is_boss')
        if m.get('is_dept_leader') is not None:
            self.is_dept_leader = m.get('is_dept_leader')
        if m.get('job_no') is not None:
            self.job_no = m.get('job_no')
        if m.get('manager_user_id') is not None:
            self.manager_user_id = m.get('manager_user_id')
        if m.get('out_dept_id_list') is not None:
            self.out_dept_id_list = m.get('out_dept_id_list')
        if m.get('phone') is not None:
            self.phone = m.get('phone')
        if m.get('position_level') is not None:
            self.position_level = m.get('position_level')
        if m.get('real_name') is not None:
            self.real_name = m.get('real_name')
        if m.get('real_name_en') is not None:
            self.real_name_en = m.get('real_name_en')
        if m.get('union_id') is not None:
            self.union_id = m.get('union_id')
        if m.get('user_id') is not None:
            self.user_id = m.get('user_id')
        if m.get('user_nick') is not None:
            self.user_nick = m.get('user_nick')
        return self


class AddEmployeeShrinkRequest(TeaModel):
    def __init__(
        self,
        account_email: str = None,
        account_phone: str = None,
        attribute: str = None,
        avatar: str = None,
        base_city_code_list_shrink: str = None,
        base_location_list_shrink: str = None,
        birthday: str = None,
        cert_list_shrink: str = None,
        custom_role_code_list_shrink: str = None,
        email: str = None,
        gender: str = None,
        is_admin: bool = None,
        is_boss: bool = None,
        is_dept_leader: bool = None,
        job_no: str = None,
        manager_user_id: str = None,
        out_dept_id_list_shrink: str = None,
        phone: str = None,
        position_level: str = None,
        real_name: str = None,
        real_name_en: str = None,
        union_id: str = None,
        user_id: str = None,
        user_nick: str = None,
    ):
        self.account_email = account_email
        self.account_phone = account_phone
        self.attribute = attribute
        self.avatar = avatar
        self.base_city_code_list_shrink = base_city_code_list_shrink
        self.base_location_list_shrink = base_location_list_shrink
        self.birthday = birthday
        self.cert_list_shrink = cert_list_shrink
        self.custom_role_code_list_shrink = custom_role_code_list_shrink
        self.email = email
        self.gender = gender
        self.is_admin = is_admin
        self.is_boss = is_boss
        self.is_dept_leader = is_dept_leader
        self.job_no = job_no
        self.manager_user_id = manager_user_id
        self.out_dept_id_list_shrink = out_dept_id_list_shrink
        self.phone = phone
        self.position_level = position_level
        self.real_name = real_name
        self.real_name_en = real_name_en
        self.union_id = union_id
        # This parameter is required.
        self.user_id = user_id
        # This parameter is required.
        self.user_nick = user_nick

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.account_email is not None:
            result['account_email'] = self.account_email
        if self.account_phone is not None:
            result['account_phone'] = self.account_phone
        if self.attribute is not None:
            result['attribute'] = self.attribute
        if self.avatar is not None:
            result['avatar'] = self.avatar
        if self.base_city_code_list_shrink is not None:
            result['base_city_code_list'] = self.base_city_code_list_shrink
        if self.base_location_list_shrink is not None:
            result['base_location_list'] = self.base_location_list_shrink
        if self.birthday is not None:
            result['birthday'] = self.birthday
        if self.cert_list_shrink is not None:
            result['cert_list'] = self.cert_list_shrink
        if self.custom_role_code_list_shrink is not None:
            result['custom_role_code_list'] = self.custom_role_code_list_shrink
        if self.email is not None:
            result['email'] = self.email
        if self.gender is not None:
            result['gender'] = self.gender
        if self.is_admin is not None:
            result['is_admin'] = self.is_admin
        if self.is_boss is not None:
            result['is_boss'] = self.is_boss
        if self.is_dept_leader is not None:
            result['is_dept_leader'] = self.is_dept_leader
        if self.job_no is not None:
            result['job_no'] = self.job_no
        if self.manager_user_id is not None:
            result['manager_user_id'] = self.manager_user_id
        if self.out_dept_id_list_shrink is not None:
            result['out_dept_id_list'] = self.out_dept_id_list_shrink
        if self.phone is not None:
            result['phone'] = self.phone
        if self.position_level is not None:
            result['position_level'] = self.position_level
        if self.real_name is not None:
            result['real_name'] = self.real_name
        if self.real_name_en is not None:
            result['real_name_en'] = self.real_name_en
        if self.union_id is not None:
            result['union_id'] = self.union_id
        if self.user_id is not None:
            result['user_id'] = self.user_id
        if self.user_nick is not None:
            result['user_nick'] = self.user_nick
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('account_email') is not None:
            self.account_email = m.get('account_email')
        if m.get('account_phone') is not None:
            self.account_phone = m.get('account_phone')
        if m.get('attribute') is not None:
            self.attribute = m.get('attribute')
        if m.get('avatar') is not None:
            self.avatar = m.get('avatar')
        if m.get('base_city_code_list') is not None:
            self.base_city_code_list_shrink = m.get('base_city_code_list')
        if m.get('base_location_list') is not None:
            self.base_location_list_shrink = m.get('base_location_list')
        if m.get('birthday') is not None:
            self.birthday = m.get('birthday')
        if m.get('cert_list') is not None:
            self.cert_list_shrink = m.get('cert_list')
        if m.get('custom_role_code_list') is not None:
            self.custom_role_code_list_shrink = m.get('custom_role_code_list')
        if m.get('email') is not None:
            self.email = m.get('email')
        if m.get('gender') is not None:
            self.gender = m.get('gender')
        if m.get('is_admin') is not None:
            self.is_admin = m.get('is_admin')
        if m.get('is_boss') is not None:
            self.is_boss = m.get('is_boss')
        if m.get('is_dept_leader') is not None:
            self.is_dept_leader = m.get('is_dept_leader')
        if m.get('job_no') is not None:
            self.job_no = m.get('job_no')
        if m.get('manager_user_id') is not None:
            self.manager_user_id = m.get('manager_user_id')
        if m.get('out_dept_id_list') is not None:
            self.out_dept_id_list_shrink = m.get('out_dept_id_list')
        if m.get('phone') is not None:
            self.phone = m.get('phone')
        if m.get('position_level') is not None:
            self.position_level = m.get('position_level')
        if m.get('real_name') is not None:
            self.real_name = m.get('real_name')
        if m.get('real_name_en') is not None:
            self.real_name_en = m.get('real_name_en')
        if m.get('union_id') is not None:
            self.union_id = m.get('union_id')
        if m.get('user_id') is not None:
            self.user_id = m.get('user_id')
        if m.get('user_nick') is not None:
            self.user_nick = m.get('user_nick')
        return self


class AddEmployeeResponseBody(TeaModel):
    def __init__(
        self,
        code: str = None,
        message: str = None,
        request_id: str = None,
        success: bool = None,
        trace_id: str = None,
    ):
        self.code = code
        self.message = message
        self.request_id = request_id
        self.success = success
        # traceId
        self.trace_id = trace_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['code'] = self.code
        if self.message is not None:
            result['message'] = self.message
        if self.request_id is not None:
            result['requestId'] = self.request_id
        if self.success is not None:
            result['success'] = self.success
        if self.trace_id is not None:
            result['traceId'] = self.trace_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('code') is not None:
            self.code = m.get('code')
        if m.get('message') is not None:
            self.message = m.get('message')
        if m.get('requestId') is not None:
            self.request_id = m.get('requestId')
        if m.get('success') is not None:
            self.success = m.get('success')
        if m.get('traceId') is not None:
            self.trace_id = m.get('traceId')
        return self


class AddEmployeeResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: AddEmployeeResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = AddEmployeeResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class AddEmployeesToCustomRoleHeaders(TeaModel):
    def __init__(
        self,
        common_headers: Dict[str, str] = None,
        x_acs_btrip_corp_token: str = None,
    ):
        self.common_headers = common_headers
        self.x_acs_btrip_corp_token = x_acs_btrip_corp_token

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.common_headers is not None:
            result['commonHeaders'] = self.common_headers
        if self.x_acs_btrip_corp_token is not None:
            result['x-acs-btrip-corp-token'] = self.x_acs_btrip_corp_token
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('commonHeaders') is not None:
            self.common_headers = m.get('commonHeaders')
        if m.get('x-acs-btrip-corp-token') is not None:
            self.x_acs_btrip_corp_token = m.get('x-acs-btrip-corp-token')
        return self


class AddEmployeesToCustomRoleRequest(TeaModel):
    def __init__(
        self,
        role_id: str = None,
        user_id_list: List[str] = None,
    ):
        # This parameter is required.
        self.role_id = role_id
        # This parameter is required.
        self.user_id_list = user_id_list

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.role_id is not None:
            result['role_id'] = self.role_id
        if self.user_id_list is not None:
            result['user_id_list'] = self.user_id_list
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('role_id') is not None:
            self.role_id = m.get('role_id')
        if m.get('user_id_list') is not None:
            self.user_id_list = m.get('user_id_list')
        return self


class AddEmployeesToCustomRoleShrinkRequest(TeaModel):
    def __init__(
        self,
        role_id: str = None,
        user_id_list_shrink: str = None,
    ):
        # This parameter is required.
        self.role_id = role_id
        # This parameter is required.
        self.user_id_list_shrink = user_id_list_shrink

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.role_id is not None:
            result['role_id'] = self.role_id
        if self.user_id_list_shrink is not None:
            result['user_id_list'] = self.user_id_list_shrink
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('role_id') is not None:
            self.role_id = m.get('role_id')
        if m.get('user_id_list') is not None:
            self.user_id_list_shrink = m.get('user_id_list')
        return self


class AddEmployeesToCustomRoleResponseBody(TeaModel):
    def __init__(
        self,
        code: str = None,
        http_status_code: int = None,
        message: str = None,
        request_id: str = None,
        success: bool = None,
        trace_id: str = None,
    ):
        self.code = code
        self.http_status_code = http_status_code
        self.message = message
        self.request_id = request_id
        self.success = success
        # traceId
        self.trace_id = trace_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['code'] = self.code
        if self.http_status_code is not None:
            result['httpStatusCode'] = self.http_status_code
        if self.message is not None:
            result['message'] = self.message
        if self.request_id is not None:
            result['requestId'] = self.request_id
        if self.success is not None:
            result['success'] = self.success
        if self.trace_id is not None:
            result['traceId'] = self.trace_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('code') is not None:
            self.code = m.get('code')
        if m.get('httpStatusCode') is not None:
            self.http_status_code = m.get('httpStatusCode')
        if m.get('message') is not None:
            self.message = m.get('message')
        if m.get('requestId') is not None:
            self.request_id = m.get('requestId')
        if m.get('success') is not None:
            self.success = m.get('success')
        if m.get('traceId') is not None:
            self.trace_id = m.get('traceId')
        return self


class AddEmployeesToCustomRoleResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: AddEmployeesToCustomRoleResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = AddEmployeesToCustomRoleResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class AddInvoiceEntityHeaders(TeaModel):
    def __init__(
        self,
        common_headers: Dict[str, str] = None,
        x_acs_btrip_corp_token: str = None,
    ):
        self.common_headers = common_headers
        self.x_acs_btrip_corp_token = x_acs_btrip_corp_token

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.common_headers is not None:
            result['commonHeaders'] = self.common_headers
        if self.x_acs_btrip_corp_token is not None:
            result['x-acs-btrip-corp-token'] = self.x_acs_btrip_corp_token
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('commonHeaders') is not None:
            self.common_headers = m.get('commonHeaders')
        if m.get('x-acs-btrip-corp-token') is not None:
            self.x_acs_btrip_corp_token = m.get('x-acs-btrip-corp-token')
        return self


class AddInvoiceEntityRequestEntities(TeaModel):
    def __init__(
        self,
        entity_id: str = None,
        entity_name: str = None,
        entity_type: str = None,
    ):
        # This parameter is required.
        self.entity_id = entity_id
        # This parameter is required.
        self.entity_name = entity_name
        # This parameter is required.
        self.entity_type = entity_type

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.entity_id is not None:
            result['entity_id'] = self.entity_id
        if self.entity_name is not None:
            result['entity_name'] = self.entity_name
        if self.entity_type is not None:
            result['entity_type'] = self.entity_type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('entity_id') is not None:
            self.entity_id = m.get('entity_id')
        if m.get('entity_name') is not None:
            self.entity_name = m.get('entity_name')
        if m.get('entity_type') is not None:
            self.entity_type = m.get('entity_type')
        return self


class AddInvoiceEntityRequest(TeaModel):
    def __init__(
        self,
        entities: List[AddInvoiceEntityRequestEntities] = None,
        third_part_id: str = None,
    ):
        # This parameter is required.
        self.entities = entities
        # This parameter is required.
        self.third_part_id = third_part_id

    def validate(self):
        if self.entities:
            for k in self.entities:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['entities'] = []
        if self.entities is not None:
            for k in self.entities:
                result['entities'].append(k.to_map() if k else None)
        if self.third_part_id is not None:
            result['third_part_id'] = self.third_part_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.entities = []
        if m.get('entities') is not None:
            for k in m.get('entities'):
                temp_model = AddInvoiceEntityRequestEntities()
                self.entities.append(temp_model.from_map(k))
        if m.get('third_part_id') is not None:
            self.third_part_id = m.get('third_part_id')
        return self


class AddInvoiceEntityShrinkRequest(TeaModel):
    def __init__(
        self,
        entities_shrink: str = None,
        third_part_id: str = None,
    ):
        # This parameter is required.
        self.entities_shrink = entities_shrink
        # This parameter is required.
        self.third_part_id = third_part_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.entities_shrink is not None:
            result['entities'] = self.entities_shrink
        if self.third_part_id is not None:
            result['third_part_id'] = self.third_part_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('entities') is not None:
            self.entities_shrink = m.get('entities')
        if m.get('third_part_id') is not None:
            self.third_part_id = m.get('third_part_id')
        return self


class AddInvoiceEntityResponseBodyModule(TeaModel):
    def __init__(
        self,
        add_num: int = None,
        selected_user_num: int = None,
    ):
        self.add_num = add_num
        self.selected_user_num = selected_user_num

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.add_num is not None:
            result['add_num'] = self.add_num
        if self.selected_user_num is not None:
            result['selected_user_num'] = self.selected_user_num
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('add_num') is not None:
            self.add_num = m.get('add_num')
        if m.get('selected_user_num') is not None:
            self.selected_user_num = m.get('selected_user_num')
        return self


class AddInvoiceEntityResponseBody(TeaModel):
    def __init__(
        self,
        code: str = None,
        message: str = None,
        module: AddInvoiceEntityResponseBodyModule = None,
        request_id: str = None,
        success: bool = None,
        trace_id: str = None,
    ):
        self.code = code
        self.message = message
        self.module = module
        self.request_id = request_id
        self.success = success
        # traceId
        self.trace_id = trace_id

    def validate(self):
        if self.module:
            self.module.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['code'] = self.code
        if self.message is not None:
            result['message'] = self.message
        if self.module is not None:
            result['module'] = self.module.to_map()
        if self.request_id is not None:
            result['requestId'] = self.request_id
        if self.success is not None:
            result['success'] = self.success
        if self.trace_id is not None:
            result['traceId'] = self.trace_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('code') is not None:
            self.code = m.get('code')
        if m.get('message') is not None:
            self.message = m.get('message')
        if m.get('module') is not None:
            temp_model = AddInvoiceEntityResponseBodyModule()
            self.module = temp_model.from_map(m['module'])
        if m.get('requestId') is not None:
            self.request_id = m.get('requestId')
        if m.get('success') is not None:
            self.success = m.get('success')
        if m.get('traceId') is not None:
            self.trace_id = m.get('traceId')
        return self


class AddInvoiceEntityResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: AddInvoiceEntityResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = AddInvoiceEntityResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class AddressGetHeaders(TeaModel):
    def __init__(
        self,
        common_headers: Dict[str, str] = None,
        x_acs_btrip_so_corp_token: str = None,
    ):
        self.common_headers = common_headers
        self.x_acs_btrip_so_corp_token = x_acs_btrip_so_corp_token

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.common_headers is not None:
            result['commonHeaders'] = self.common_headers
        if self.x_acs_btrip_so_corp_token is not None:
            result['x-acs-btrip-so-corp-token'] = self.x_acs_btrip_so_corp_token
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('commonHeaders') is not None:
            self.common_headers = m.get('commonHeaders')
        if m.get('x-acs-btrip-so-corp-token') is not None:
            self.x_acs_btrip_so_corp_token = m.get('x-acs-btrip-so-corp-token')
        return self


class AddressGetRequest(TeaModel):
    def __init__(
        self,
        action_type: int = None,
        arr_city_code: str = None,
        arr_city_name: str = None,
        car_scenes_code: str = None,
        dep_city_code: str = None,
        dep_city_name: str = None,
        dep_date: str = None,
        itinerary_id: str = None,
        middle_page: int = None,
        order_id: str = None,
        phone: str = None,
        session_parameters: str = None,
        sub_corp_id: str = None,
        taobao_callback_url: str = None,
        thirdpart_apply_id: str = None,
        traveler_id: str = None,
        type: int = None,
        use_booking_proxy: int = None,
        user_id: str = None,
    ):
        # This parameter is required.
        self.action_type = action_type
        self.arr_city_code = arr_city_code
        self.arr_city_name = arr_city_name
        self.car_scenes_code = car_scenes_code
        self.dep_city_code = dep_city_code
        self.dep_city_name = dep_city_name
        self.dep_date = dep_date
        self.itinerary_id = itinerary_id
        self.middle_page = middle_page
        self.order_id = order_id
        self.phone = phone
        self.session_parameters = session_parameters
        self.sub_corp_id = sub_corp_id
        self.taobao_callback_url = taobao_callback_url
        self.thirdpart_apply_id = thirdpart_apply_id
        self.traveler_id = traveler_id
        self.type = type
        self.use_booking_proxy = use_booking_proxy
        # This parameter is required.
        self.user_id = user_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.action_type is not None:
            result['action_type'] = self.action_type
        if self.arr_city_code is not None:
            result['arr_city_code'] = self.arr_city_code
        if self.arr_city_name is not None:
            result['arr_city_name'] = self.arr_city_name
        if self.car_scenes_code is not None:
            result['car_scenes_code'] = self.car_scenes_code
        if self.dep_city_code is not None:
            result['dep_city_code'] = self.dep_city_code
        if self.dep_city_name is not None:
            result['dep_city_name'] = self.dep_city_name
        if self.dep_date is not None:
            result['dep_date'] = self.dep_date
        if self.itinerary_id is not None:
            result['itinerary_id'] = self.itinerary_id
        if self.middle_page is not None:
            result['middle_page'] = self.middle_page
        if self.order_id is not None:
            result['order_Id'] = self.order_id
        if self.phone is not None:
            result['phone'] = self.phone
        if self.session_parameters is not None:
            result['session_parameters'] = self.session_parameters
        if self.sub_corp_id is not None:
            result['sub_corp_id'] = self.sub_corp_id
        if self.taobao_callback_url is not None:
            result['taobao_callback_url'] = self.taobao_callback_url
        if self.thirdpart_apply_id is not None:
            result['thirdpart_apply_id'] = self.thirdpart_apply_id
        if self.traveler_id is not None:
            result['traveler_id'] = self.traveler_id
        if self.type is not None:
            result['type'] = self.type
        if self.use_booking_proxy is not None:
            result['use_booking_proxy'] = self.use_booking_proxy
        if self.user_id is not None:
            result['user_id'] = self.user_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('action_type') is not None:
            self.action_type = m.get('action_type')
        if m.get('arr_city_code') is not None:
            self.arr_city_code = m.get('arr_city_code')
        if m.get('arr_city_name') is not None:
            self.arr_city_name = m.get('arr_city_name')
        if m.get('car_scenes_code') is not None:
            self.car_scenes_code = m.get('car_scenes_code')
        if m.get('dep_city_code') is not None:
            self.dep_city_code = m.get('dep_city_code')
        if m.get('dep_city_name') is not None:
            self.dep_city_name = m.get('dep_city_name')
        if m.get('dep_date') is not None:
            self.dep_date = m.get('dep_date')
        if m.get('itinerary_id') is not None:
            self.itinerary_id = m.get('itinerary_id')
        if m.get('middle_page') is not None:
            self.middle_page = m.get('middle_page')
        if m.get('order_Id') is not None:
            self.order_id = m.get('order_Id')
        if m.get('phone') is not None:
            self.phone = m.get('phone')
        if m.get('session_parameters') is not None:
            self.session_parameters = m.get('session_parameters')
        if m.get('sub_corp_id') is not None:
            self.sub_corp_id = m.get('sub_corp_id')
        if m.get('taobao_callback_url') is not None:
            self.taobao_callback_url = m.get('taobao_callback_url')
        if m.get('thirdpart_apply_id') is not None:
            self.thirdpart_apply_id = m.get('thirdpart_apply_id')
        if m.get('traveler_id') is not None:
            self.traveler_id = m.get('traveler_id')
        if m.get('type') is not None:
            self.type = m.get('type')
        if m.get('use_booking_proxy') is not None:
            self.use_booking_proxy = m.get('use_booking_proxy')
        if m.get('user_id') is not None:
            self.user_id = m.get('user_id')
        return self


class AddressGetResponseBodyModule(TeaModel):
    def __init__(
        self,
        url: str = None,
    ):
        self.url = url

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.url is not None:
            result['url'] = self.url
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('url') is not None:
            self.url = m.get('url')
        return self


class AddressGetResponseBody(TeaModel):
    def __init__(
        self,
        code: str = None,
        message: str = None,
        module: AddressGetResponseBodyModule = None,
        request_id: str = None,
        success: bool = None,
        trace_id: str = None,
    ):
        self.code = code
        self.message = message
        self.module = module
        self.request_id = request_id
        self.success = success
        self.trace_id = trace_id

    def validate(self):
        if self.module:
            self.module.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['code'] = self.code
        if self.message is not None:
            result['message'] = self.message
        if self.module is not None:
            result['module'] = self.module.to_map()
        if self.request_id is not None:
            result['requestId'] = self.request_id
        if self.success is not None:
            result['success'] = self.success
        if self.trace_id is not None:
            result['traceId'] = self.trace_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('code') is not None:
            self.code = m.get('code')
        if m.get('message') is not None:
            self.message = m.get('message')
        if m.get('module') is not None:
            temp_model = AddressGetResponseBodyModule()
            self.module = temp_model.from_map(m['module'])
        if m.get('requestId') is not None:
            self.request_id = m.get('requestId')
        if m.get('success') is not None:
            self.success = m.get('success')
        if m.get('traceId') is not None:
            self.trace_id = m.get('traceId')
        return self


class AddressGetResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: AddressGetResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = AddressGetResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class AirportSearchHeaders(TeaModel):
    def __init__(
        self,
        common_headers: Dict[str, str] = None,
        x_acs_btrip_so_corp_token: str = None,
    ):
        self.common_headers = common_headers
        self.x_acs_btrip_so_corp_token = x_acs_btrip_so_corp_token

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.common_headers is not None:
            result['commonHeaders'] = self.common_headers
        if self.x_acs_btrip_so_corp_token is not None:
            result['x-acs-btrip-so-corp-token'] = self.x_acs_btrip_so_corp_token
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('commonHeaders') is not None:
            self.common_headers = m.get('commonHeaders')
        if m.get('x-acs-btrip-so-corp-token') is not None:
            self.x_acs_btrip_so_corp_token = m.get('x-acs-btrip-so-corp-token')
        return self


class AirportSearchRequest(TeaModel):
    def __init__(
        self,
        keyword: str = None,
        type: int = None,
    ):
        # This parameter is required.
        self.keyword = keyword
        self.type = type

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.keyword is not None:
            result['keyword'] = self.keyword
        if self.type is not None:
            result['type'] = self.type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('keyword') is not None:
            self.keyword = m.get('keyword')
        if m.get('type') is not None:
            self.type = m.get('type')
        return self


class AirportSearchResponseBodyModuleCities(TeaModel):
    def __init__(
        self,
        code: str = None,
        distance: int = None,
        name: str = None,
        travel_name: str = None,
    ):
        self.code = code
        self.distance = distance
        self.name = name
        self.travel_name = travel_name

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['code'] = self.code
        if self.distance is not None:
            result['distance'] = self.distance
        if self.name is not None:
            result['name'] = self.name
        if self.travel_name is not None:
            result['travel_name'] = self.travel_name
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('code') is not None:
            self.code = m.get('code')
        if m.get('distance') is not None:
            self.distance = m.get('distance')
        if m.get('name') is not None:
            self.name = m.get('name')
        if m.get('travel_name') is not None:
            self.travel_name = m.get('travel_name')
        return self


class AirportSearchResponseBodyModule(TeaModel):
    def __init__(
        self,
        cities: List[AirportSearchResponseBodyModuleCities] = None,
        nearby: bool = None,
    ):
        self.cities = cities
        self.nearby = nearby

    def validate(self):
        if self.cities:
            for k in self.cities:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['cities'] = []
        if self.cities is not None:
            for k in self.cities:
                result['cities'].append(k.to_map() if k else None)
        if self.nearby is not None:
            result['nearby'] = self.nearby
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.cities = []
        if m.get('cities') is not None:
            for k in m.get('cities'):
                temp_model = AirportSearchResponseBodyModuleCities()
                self.cities.append(temp_model.from_map(k))
        if m.get('nearby') is not None:
            self.nearby = m.get('nearby')
        return self


class AirportSearchResponseBody(TeaModel):
    def __init__(
        self,
        code: str = None,
        message: str = None,
        module: AirportSearchResponseBodyModule = None,
        request_id: str = None,
        success: bool = None,
        trace_id: str = None,
    ):
        self.code = code
        self.message = message
        # module。
        self.module = module
        self.request_id = request_id
        self.success = success
        self.trace_id = trace_id

    def validate(self):
        if self.module:
            self.module.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['code'] = self.code
        if self.message is not None:
            result['message'] = self.message
        if self.module is not None:
            result['module'] = self.module.to_map()
        if self.request_id is not None:
            result['requestId'] = self.request_id
        if self.success is not None:
            result['success'] = self.success
        if self.trace_id is not None:
            result['traceId'] = self.trace_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('code') is not None:
            self.code = m.get('code')
        if m.get('message') is not None:
            self.message = m.get('message')
        if m.get('module') is not None:
            temp_model = AirportSearchResponseBodyModule()
            self.module = temp_model.from_map(m['module'])
        if m.get('requestId') is not None:
            self.request_id = m.get('requestId')
        if m.get('success') is not None:
            self.success = m.get('success')
        if m.get('traceId') is not None:
            self.trace_id = m.get('traceId')
        return self


class AirportSearchResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: AirportSearchResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = AirportSearchResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class AllBaseCityInfoQueryHeaders(TeaModel):
    def __init__(
        self,
        common_headers: Dict[str, str] = None,
        x_acs_btrip_access_token: str = None,
    ):
        self.common_headers = common_headers
        self.x_acs_btrip_access_token = x_acs_btrip_access_token

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.common_headers is not None:
            result['commonHeaders'] = self.common_headers
        if self.x_acs_btrip_access_token is not None:
            result['x-acs-btrip-access-token'] = self.x_acs_btrip_access_token
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('commonHeaders') is not None:
            self.common_headers = m.get('commonHeaders')
        if m.get('x-acs-btrip-access-token') is not None:
            self.x_acs_btrip_access_token = m.get('x-acs-btrip-access-token')
        return self


class AllBaseCityInfoQueryResponseBodyModuleAllCityBaseInfoList(TeaModel):
    def __init__(
        self,
        adcode: str = None,
        city_code: str = None,
        city_level: str = None,
        city_name: str = None,
        cn_name_tree: str = None,
        id: int = None,
        other_name_list: List[str] = None,
    ):
        self.adcode = adcode
        self.city_code = city_code
        self.city_level = city_level
        self.city_name = city_name
        self.cn_name_tree = cn_name_tree
        self.id = id
        self.other_name_list = other_name_list

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.adcode is not None:
            result['adcode'] = self.adcode
        if self.city_code is not None:
            result['city_code'] = self.city_code
        if self.city_level is not None:
            result['city_level'] = self.city_level
        if self.city_name is not None:
            result['city_name'] = self.city_name
        if self.cn_name_tree is not None:
            result['cn_name_tree'] = self.cn_name_tree
        if self.id is not None:
            result['id'] = self.id
        if self.other_name_list is not None:
            result['other_name_list'] = self.other_name_list
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('adcode') is not None:
            self.adcode = m.get('adcode')
        if m.get('city_code') is not None:
            self.city_code = m.get('city_code')
        if m.get('city_level') is not None:
            self.city_level = m.get('city_level')
        if m.get('city_name') is not None:
            self.city_name = m.get('city_name')
        if m.get('cn_name_tree') is not None:
            self.cn_name_tree = m.get('cn_name_tree')
        if m.get('id') is not None:
            self.id = m.get('id')
        if m.get('other_name_list') is not None:
            self.other_name_list = m.get('other_name_list')
        return self


class AllBaseCityInfoQueryResponseBodyModule(TeaModel):
    def __init__(
        self,
        all_city_base_info_list: List[AllBaseCityInfoQueryResponseBodyModuleAllCityBaseInfoList] = None,
    ):
        self.all_city_base_info_list = all_city_base_info_list

    def validate(self):
        if self.all_city_base_info_list:
            for k in self.all_city_base_info_list:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['all_city_base_info_list'] = []
        if self.all_city_base_info_list is not None:
            for k in self.all_city_base_info_list:
                result['all_city_base_info_list'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.all_city_base_info_list = []
        if m.get('all_city_base_info_list') is not None:
            for k in m.get('all_city_base_info_list'):
                temp_model = AllBaseCityInfoQueryResponseBodyModuleAllCityBaseInfoList()
                self.all_city_base_info_list.append(temp_model.from_map(k))
        return self


class AllBaseCityInfoQueryResponseBody(TeaModel):
    def __init__(
        self,
        code: str = None,
        message: str = None,
        module: AllBaseCityInfoQueryResponseBodyModule = None,
        request_id: str = None,
        success: bool = None,
        trace_id: str = None,
    ):
        self.code = code
        self.message = message
        self.module = module
        self.request_id = request_id
        self.success = success
        # traceId
        self.trace_id = trace_id

    def validate(self):
        if self.module:
            self.module.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['code'] = self.code
        if self.message is not None:
            result['message'] = self.message
        if self.module is not None:
            result['module'] = self.module.to_map()
        if self.request_id is not None:
            result['requestId'] = self.request_id
        if self.success is not None:
            result['success'] = self.success
        if self.trace_id is not None:
            result['traceId'] = self.trace_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('code') is not None:
            self.code = m.get('code')
        if m.get('message') is not None:
            self.message = m.get('message')
        if m.get('module') is not None:
            temp_model = AllBaseCityInfoQueryResponseBodyModule()
            self.module = temp_model.from_map(m['module'])
        if m.get('requestId') is not None:
            self.request_id = m.get('requestId')
        if m.get('success') is not None:
            self.success = m.get('success')
        if m.get('traceId') is not None:
            self.trace_id = m.get('traceId')
        return self


class AllBaseCityInfoQueryResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: AllBaseCityInfoQueryResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = AllBaseCityInfoQueryResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class ApplyAddHeaders(TeaModel):
    def __init__(
        self,
        common_headers: Dict[str, str] = None,
        x_acs_btrip_so_corp_token: str = None,
    ):
        self.common_headers = common_headers
        self.x_acs_btrip_so_corp_token = x_acs_btrip_so_corp_token

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.common_headers is not None:
            result['commonHeaders'] = self.common_headers
        if self.x_acs_btrip_so_corp_token is not None:
            result['x-acs-btrip-so-corp-token'] = self.x_acs_btrip_so_corp_token
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('commonHeaders') is not None:
            self.common_headers = m.get('commonHeaders')
        if m.get('x-acs-btrip-so-corp-token') is not None:
            self.x_acs_btrip_so_corp_token = m.get('x-acs-btrip-so-corp-token')
        return self


class ApplyAddRequestCarRule(TeaModel):
    def __init__(
        self,
        scenario_template_id: str = None,
        scenario_template_name: str = None,
    ):
        self.scenario_template_id = scenario_template_id
        self.scenario_template_name = scenario_template_name

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.scenario_template_id is not None:
            result['scenario_template_id'] = self.scenario_template_id
        if self.scenario_template_name is not None:
            result['scenario_template_name'] = self.scenario_template_name
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('scenario_template_id') is not None:
            self.scenario_template_id = m.get('scenario_template_id')
        if m.get('scenario_template_name') is not None:
            self.scenario_template_name = m.get('scenario_template_name')
        return self


class ApplyAddRequestDefaultStandardHotelCitys(TeaModel):
    def __init__(
        self,
        city_code: str = None,
        city_name: str = None,
        fee: int = None,
    ):
        self.city_code = city_code
        self.city_name = city_name
        self.fee = fee

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.city_code is not None:
            result['city_code'] = self.city_code
        if self.city_name is not None:
            result['city_name'] = self.city_name
        if self.fee is not None:
            result['fee'] = self.fee
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('city_code') is not None:
            self.city_code = m.get('city_code')
        if m.get('city_name') is not None:
            self.city_name = m.get('city_name')
        if m.get('fee') is not None:
            self.fee = m.get('fee')
        return self


class ApplyAddRequestDefaultStandardHotelIntlCitys(TeaModel):
    def __init__(
        self,
        city_code: str = None,
        city_name: str = None,
        fee: int = None,
    ):
        self.city_code = city_code
        self.city_name = city_name
        self.fee = fee

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.city_code is not None:
            result['city_code'] = self.city_code
        if self.city_name is not None:
            result['city_name'] = self.city_name
        if self.fee is not None:
            result['fee'] = self.fee
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('city_code') is not None:
            self.city_code = m.get('city_code')
        if m.get('city_name') is not None:
            self.city_name = m.get('city_name')
        if m.get('fee') is not None:
            self.fee = m.get('fee')
        return self


class ApplyAddRequestDefaultStandard(TeaModel):
    def __init__(
        self,
        business_discount: int = None,
        economy_discount: int = None,
        first_discount: int = None,
        flight_cabins: str = None,
        flight_intl_rule_code: int = None,
        flight_rule_code: int = None,
        hotel_citys: List[ApplyAddRequestDefaultStandardHotelCitys] = None,
        hotel_intl_citys: List[ApplyAddRequestDefaultStandardHotelIntlCitys] = None,
        hotel_intl_rule_code: int = None,
        hotel_rule_code: int = None,
        international_flight_cabins: str = None,
        premium_economy_discount: int = None,
        reserve_type: int = None,
        train_rule_code: int = None,
        train_seats: str = None,
    ):
        self.business_discount = business_discount
        self.economy_discount = economy_discount
        self.first_discount = first_discount
        self.flight_cabins = flight_cabins
        self.flight_intl_rule_code = flight_intl_rule_code
        self.flight_rule_code = flight_rule_code
        self.hotel_citys = hotel_citys
        self.hotel_intl_citys = hotel_intl_citys
        self.hotel_intl_rule_code = hotel_intl_rule_code
        self.hotel_rule_code = hotel_rule_code
        self.international_flight_cabins = international_flight_cabins
        self.premium_economy_discount = premium_economy_discount
        self.reserve_type = reserve_type
        self.train_rule_code = train_rule_code
        self.train_seats = train_seats

    def validate(self):
        if self.hotel_citys:
            for k in self.hotel_citys:
                if k:
                    k.validate()
        if self.hotel_intl_citys:
            for k in self.hotel_intl_citys:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.business_discount is not None:
            result['business_discount'] = self.business_discount
        if self.economy_discount is not None:
            result['economy_discount'] = self.economy_discount
        if self.first_discount is not None:
            result['first_discount'] = self.first_discount
        if self.flight_cabins is not None:
            result['flight_cabins'] = self.flight_cabins
        if self.flight_intl_rule_code is not None:
            result['flight_intl_rule_code'] = self.flight_intl_rule_code
        if self.flight_rule_code is not None:
            result['flight_rule_code'] = self.flight_rule_code
        result['hotel_citys'] = []
        if self.hotel_citys is not None:
            for k in self.hotel_citys:
                result['hotel_citys'].append(k.to_map() if k else None)
        result['hotel_intl_citys'] = []
        if self.hotel_intl_citys is not None:
            for k in self.hotel_intl_citys:
                result['hotel_intl_citys'].append(k.to_map() if k else None)
        if self.hotel_intl_rule_code is not None:
            result['hotel_intl_rule_code'] = self.hotel_intl_rule_code
        if self.hotel_rule_code is not None:
            result['hotel_rule_code'] = self.hotel_rule_code
        if self.international_flight_cabins is not None:
            result['international_flight_cabins'] = self.international_flight_cabins
        if self.premium_economy_discount is not None:
            result['premium_economy_discount'] = self.premium_economy_discount
        if self.reserve_type is not None:
            result['reserve_type'] = self.reserve_type
        if self.train_rule_code is not None:
            result['train_rule_code'] = self.train_rule_code
        if self.train_seats is not None:
            result['train_seats'] = self.train_seats
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('business_discount') is not None:
            self.business_discount = m.get('business_discount')
        if m.get('economy_discount') is not None:
            self.economy_discount = m.get('economy_discount')
        if m.get('first_discount') is not None:
            self.first_discount = m.get('first_discount')
        if m.get('flight_cabins') is not None:
            self.flight_cabins = m.get('flight_cabins')
        if m.get('flight_intl_rule_code') is not None:
            self.flight_intl_rule_code = m.get('flight_intl_rule_code')
        if m.get('flight_rule_code') is not None:
            self.flight_rule_code = m.get('flight_rule_code')
        self.hotel_citys = []
        if m.get('hotel_citys') is not None:
            for k in m.get('hotel_citys'):
                temp_model = ApplyAddRequestDefaultStandardHotelCitys()
                self.hotel_citys.append(temp_model.from_map(k))
        self.hotel_intl_citys = []
        if m.get('hotel_intl_citys') is not None:
            for k in m.get('hotel_intl_citys'):
                temp_model = ApplyAddRequestDefaultStandardHotelIntlCitys()
                self.hotel_intl_citys.append(temp_model.from_map(k))
        if m.get('hotel_intl_rule_code') is not None:
            self.hotel_intl_rule_code = m.get('hotel_intl_rule_code')
        if m.get('hotel_rule_code') is not None:
            self.hotel_rule_code = m.get('hotel_rule_code')
        if m.get('international_flight_cabins') is not None:
            self.international_flight_cabins = m.get('international_flight_cabins')
        if m.get('premium_economy_discount') is not None:
            self.premium_economy_discount = m.get('premium_economy_discount')
        if m.get('reserve_type') is not None:
            self.reserve_type = m.get('reserve_type')
        if m.get('train_rule_code') is not None:
            self.train_rule_code = m.get('train_rule_code')
        if m.get('train_seats') is not None:
            self.train_seats = m.get('train_seats')
        return self


class ApplyAddRequestExternalTravelerList(TeaModel):
    def __init__(
        self,
        attribute: str = None,
        cost_center_id: int = None,
        external_user_id: str = None,
        invoice_id: int = None,
        payment_department_id: str = None,
        payment_department_name: str = None,
        project_code: str = None,
        project_title: str = None,
        third_part_invoice_id: str = None,
        thirdpart_cost_center_id: str = None,
        thirdpart_depart_id: str = None,
        user_name: str = None,
        user_name_en: str = None,
    ):
        self.attribute = attribute
        self.cost_center_id = cost_center_id
        self.external_user_id = external_user_id
        self.invoice_id = invoice_id
        self.payment_department_id = payment_department_id
        self.payment_department_name = payment_department_name
        self.project_code = project_code
        self.project_title = project_title
        self.third_part_invoice_id = third_part_invoice_id
        self.thirdpart_cost_center_id = thirdpart_cost_center_id
        self.thirdpart_depart_id = thirdpart_depart_id
        self.user_name = user_name
        self.user_name_en = user_name_en

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.attribute is not None:
            result['attribute'] = self.attribute
        if self.cost_center_id is not None:
            result['cost_center_id'] = self.cost_center_id
        if self.external_user_id is not None:
            result['external_user_id'] = self.external_user_id
        if self.invoice_id is not None:
            result['invoice_id'] = self.invoice_id
        if self.payment_department_id is not None:
            result['payment_department_id'] = self.payment_department_id
        if self.payment_department_name is not None:
            result['payment_department_name'] = self.payment_department_name
        if self.project_code is not None:
            result['project_code'] = self.project_code
        if self.project_title is not None:
            result['project_title'] = self.project_title
        if self.third_part_invoice_id is not None:
            result['third_part_invoice_id'] = self.third_part_invoice_id
        if self.thirdpart_cost_center_id is not None:
            result['thirdpart_cost_center_id'] = self.thirdpart_cost_center_id
        if self.thirdpart_depart_id is not None:
            result['thirdpart_depart_id'] = self.thirdpart_depart_id
        if self.user_name is not None:
            result['user_name'] = self.user_name
        if self.user_name_en is not None:
            result['user_name_en'] = self.user_name_en
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('attribute') is not None:
            self.attribute = m.get('attribute')
        if m.get('cost_center_id') is not None:
            self.cost_center_id = m.get('cost_center_id')
        if m.get('external_user_id') is not None:
            self.external_user_id = m.get('external_user_id')
        if m.get('invoice_id') is not None:
            self.invoice_id = m.get('invoice_id')
        if m.get('payment_department_id') is not None:
            self.payment_department_id = m.get('payment_department_id')
        if m.get('payment_department_name') is not None:
            self.payment_department_name = m.get('payment_department_name')
        if m.get('project_code') is not None:
            self.project_code = m.get('project_code')
        if m.get('project_title') is not None:
            self.project_title = m.get('project_title')
        if m.get('third_part_invoice_id') is not None:
            self.third_part_invoice_id = m.get('third_part_invoice_id')
        if m.get('thirdpart_cost_center_id') is not None:
            self.thirdpart_cost_center_id = m.get('thirdpart_cost_center_id')
        if m.get('thirdpart_depart_id') is not None:
            self.thirdpart_depart_id = m.get('thirdpart_depart_id')
        if m.get('user_name') is not None:
            self.user_name = m.get('user_name')
        if m.get('user_name_en') is not None:
            self.user_name_en = m.get('user_name_en')
        return self


class ApplyAddRequestExternalTravelerStandardHotelCitys(TeaModel):
    def __init__(
        self,
        city_code: str = None,
        city_name: str = None,
        fee: int = None,
    ):
        self.city_code = city_code
        self.city_name = city_name
        self.fee = fee

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.city_code is not None:
            result['city_code'] = self.city_code
        if self.city_name is not None:
            result['city_name'] = self.city_name
        if self.fee is not None:
            result['fee'] = self.fee
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('city_code') is not None:
            self.city_code = m.get('city_code')
        if m.get('city_name') is not None:
            self.city_name = m.get('city_name')
        if m.get('fee') is not None:
            self.fee = m.get('fee')
        return self


class ApplyAddRequestExternalTravelerStandardHotelIntlCitys(TeaModel):
    def __init__(
        self,
        city_code: str = None,
        city_name: str = None,
        fee: int = None,
    ):
        self.city_code = city_code
        self.city_name = city_name
        self.fee = fee

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.city_code is not None:
            result['city_code'] = self.city_code
        if self.city_name is not None:
            result['city_name'] = self.city_name
        if self.fee is not None:
            result['fee'] = self.fee
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('city_code') is not None:
            self.city_code = m.get('city_code')
        if m.get('city_name') is not None:
            self.city_name = m.get('city_name')
        if m.get('fee') is not None:
            self.fee = m.get('fee')
        return self


class ApplyAddRequestExternalTravelerStandard(TeaModel):
    def __init__(
        self,
        business_discount: int = None,
        economy_discount: int = None,
        first_discount: int = None,
        flight_cabins: str = None,
        flight_intl_rule_code: int = None,
        flight_rule_code: int = None,
        hotel_citys: List[ApplyAddRequestExternalTravelerStandardHotelCitys] = None,
        hotel_intl_citys: List[ApplyAddRequestExternalTravelerStandardHotelIntlCitys] = None,
        hotel_intl_rule_code: int = None,
        hotel_rule_code: int = None,
        international_flight_cabins: str = None,
        premium_economy_discount: int = None,
        reserve_type: int = None,
        train_rule_code: int = None,
        train_seats: str = None,
    ):
        self.business_discount = business_discount
        self.economy_discount = economy_discount
        self.first_discount = first_discount
        self.flight_cabins = flight_cabins
        self.flight_intl_rule_code = flight_intl_rule_code
        self.flight_rule_code = flight_rule_code
        self.hotel_citys = hotel_citys
        self.hotel_intl_citys = hotel_intl_citys
        self.hotel_intl_rule_code = hotel_intl_rule_code
        self.hotel_rule_code = hotel_rule_code
        self.international_flight_cabins = international_flight_cabins
        self.premium_economy_discount = premium_economy_discount
        self.reserve_type = reserve_type
        self.train_rule_code = train_rule_code
        self.train_seats = train_seats

    def validate(self):
        if self.hotel_citys:
            for k in self.hotel_citys:
                if k:
                    k.validate()
        if self.hotel_intl_citys:
            for k in self.hotel_intl_citys:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.business_discount is not None:
            result['business_discount'] = self.business_discount
        if self.economy_discount is not None:
            result['economy_discount'] = self.economy_discount
        if self.first_discount is not None:
            result['first_discount'] = self.first_discount
        if self.flight_cabins is not None:
            result['flight_cabins'] = self.flight_cabins
        if self.flight_intl_rule_code is not None:
            result['flight_intl_rule_code'] = self.flight_intl_rule_code
        if self.flight_rule_code is not None:
            result['flight_rule_code'] = self.flight_rule_code
        result['hotel_citys'] = []
        if self.hotel_citys is not None:
            for k in self.hotel_citys:
                result['hotel_citys'].append(k.to_map() if k else None)
        result['hotel_intl_citys'] = []
        if self.hotel_intl_citys is not None:
            for k in self.hotel_intl_citys:
                result['hotel_intl_citys'].append(k.to_map() if k else None)
        if self.hotel_intl_rule_code is not None:
            result['hotel_intl_rule_code'] = self.hotel_intl_rule_code
        if self.hotel_rule_code is not None:
            result['hotel_rule_code'] = self.hotel_rule_code
        if self.international_flight_cabins is not None:
            result['international_flight_cabins'] = self.international_flight_cabins
        if self.premium_economy_discount is not None:
            result['premium_economy_discount'] = self.premium_economy_discount
        if self.reserve_type is not None:
            result['reserve_type'] = self.reserve_type
        if self.train_rule_code is not None:
            result['train_rule_code'] = self.train_rule_code
        if self.train_seats is not None:
            result['train_seats'] = self.train_seats
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('business_discount') is not None:
            self.business_discount = m.get('business_discount')
        if m.get('economy_discount') is not None:
            self.economy_discount = m.get('economy_discount')
        if m.get('first_discount') is not None:
            self.first_discount = m.get('first_discount')
        if m.get('flight_cabins') is not None:
            self.flight_cabins = m.get('flight_cabins')
        if m.get('flight_intl_rule_code') is not None:
            self.flight_intl_rule_code = m.get('flight_intl_rule_code')
        if m.get('flight_rule_code') is not None:
            self.flight_rule_code = m.get('flight_rule_code')
        self.hotel_citys = []
        if m.get('hotel_citys') is not None:
            for k in m.get('hotel_citys'):
                temp_model = ApplyAddRequestExternalTravelerStandardHotelCitys()
                self.hotel_citys.append(temp_model.from_map(k))
        self.hotel_intl_citys = []
        if m.get('hotel_intl_citys') is not None:
            for k in m.get('hotel_intl_citys'):
                temp_model = ApplyAddRequestExternalTravelerStandardHotelIntlCitys()
                self.hotel_intl_citys.append(temp_model.from_map(k))
        if m.get('hotel_intl_rule_code') is not None:
            self.hotel_intl_rule_code = m.get('hotel_intl_rule_code')
        if m.get('hotel_rule_code') is not None:
            self.hotel_rule_code = m.get('hotel_rule_code')
        if m.get('international_flight_cabins') is not None:
            self.international_flight_cabins = m.get('international_flight_cabins')
        if m.get('premium_economy_discount') is not None:
            self.premium_economy_discount = m.get('premium_economy_discount')
        if m.get('reserve_type') is not None:
            self.reserve_type = m.get('reserve_type')
        if m.get('train_rule_code') is not None:
            self.train_rule_code = m.get('train_rule_code')
        if m.get('train_seats') is not None:
            self.train_seats = m.get('train_seats')
        return self


class ApplyAddRequestHotelShare(TeaModel):
    def __init__(
        self,
        param: str = None,
        type: str = None,
    ):
        self.param = param
        self.type = type

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.param is not None:
            result['param'] = self.param
        if self.type is not None:
            result['type'] = self.type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('param') is not None:
            self.param = m.get('param')
        if m.get('type') is not None:
            self.type = m.get('type')
        return self


class ApplyAddRequestItineraryListItineraryTravelStandard(TeaModel):
    def __init__(
        self,
        hotel_available_nights_per_day: int = None,
    ):
        self.hotel_available_nights_per_day = hotel_available_nights_per_day

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.hotel_available_nights_per_day is not None:
            result['hotel_available_nights_per_day'] = self.hotel_available_nights_per_day
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('hotel_available_nights_per_day') is not None:
            self.hotel_available_nights_per_day = m.get('hotel_available_nights_per_day')
        return self


class ApplyAddRequestItineraryList(TeaModel):
    def __init__(
        self,
        arr_city: str = None,
        arr_city_code: str = None,
        arr_date: str = None,
        attribute: str = None,
        cost_center_id: int = None,
        dep_city: str = None,
        dep_city_code: str = None,
        dep_date: str = None,
        invoice_id: int = None,
        itinerary_id: str = None,
        itinerary_travel_standard: ApplyAddRequestItineraryListItineraryTravelStandard = None,
        need_hotel: bool = None,
        need_traffic: bool = None,
        project_code: str = None,
        project_title: str = None,
        province_travel_city_adcodes: List[str] = None,
        third_part_invoice_id: str = None,
        thirdpart_cost_center_id: str = None,
        traffic_type: int = None,
        trip_way: int = None,
    ):
        # This parameter is required.
        self.arr_city = arr_city
        self.arr_city_code = arr_city_code
        # This parameter is required.
        self.arr_date = arr_date
        self.attribute = attribute
        self.cost_center_id = cost_center_id
        # This parameter is required.
        self.dep_city = dep_city
        self.dep_city_code = dep_city_code
        # This parameter is required.
        self.dep_date = dep_date
        self.invoice_id = invoice_id
        # This parameter is required.
        self.itinerary_id = itinerary_id
        self.itinerary_travel_standard = itinerary_travel_standard
        self.need_hotel = need_hotel
        self.need_traffic = need_traffic
        self.project_code = project_code
        self.project_title = project_title
        self.province_travel_city_adcodes = province_travel_city_adcodes
        self.third_part_invoice_id = third_part_invoice_id
        self.thirdpart_cost_center_id = thirdpart_cost_center_id
        # This parameter is required.
        self.traffic_type = traffic_type
        # This parameter is required.
        self.trip_way = trip_way

    def validate(self):
        if self.itinerary_travel_standard:
            self.itinerary_travel_standard.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.arr_city is not None:
            result['arr_city'] = self.arr_city
        if self.arr_city_code is not None:
            result['arr_city_code'] = self.arr_city_code
        if self.arr_date is not None:
            result['arr_date'] = self.arr_date
        if self.attribute is not None:
            result['attribute'] = self.attribute
        if self.cost_center_id is not None:
            result['cost_center_id'] = self.cost_center_id
        if self.dep_city is not None:
            result['dep_city'] = self.dep_city
        if self.dep_city_code is not None:
            result['dep_city_code'] = self.dep_city_code
        if self.dep_date is not None:
            result['dep_date'] = self.dep_date
        if self.invoice_id is not None:
            result['invoice_id'] = self.invoice_id
        if self.itinerary_id is not None:
            result['itinerary_id'] = self.itinerary_id
        if self.itinerary_travel_standard is not None:
            result['itinerary_travel_standard'] = self.itinerary_travel_standard.to_map()
        if self.need_hotel is not None:
            result['need_hotel'] = self.need_hotel
        if self.need_traffic is not None:
            result['need_traffic'] = self.need_traffic
        if self.project_code is not None:
            result['project_code'] = self.project_code
        if self.project_title is not None:
            result['project_title'] = self.project_title
        if self.province_travel_city_adcodes is not None:
            result['province_travel_city_adcodes'] = self.province_travel_city_adcodes
        if self.third_part_invoice_id is not None:
            result['third_part_invoice_id'] = self.third_part_invoice_id
        if self.thirdpart_cost_center_id is not None:
            result['thirdpart_cost_center_id'] = self.thirdpart_cost_center_id
        if self.traffic_type is not None:
            result['traffic_type'] = self.traffic_type
        if self.trip_way is not None:
            result['trip_way'] = self.trip_way
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('arr_city') is not None:
            self.arr_city = m.get('arr_city')
        if m.get('arr_city_code') is not None:
            self.arr_city_code = m.get('arr_city_code')
        if m.get('arr_date') is not None:
            self.arr_date = m.get('arr_date')
        if m.get('attribute') is not None:
            self.attribute = m.get('attribute')
        if m.get('cost_center_id') is not None:
            self.cost_center_id = m.get('cost_center_id')
        if m.get('dep_city') is not None:
            self.dep_city = m.get('dep_city')
        if m.get('dep_city_code') is not None:
            self.dep_city_code = m.get('dep_city_code')
        if m.get('dep_date') is not None:
            self.dep_date = m.get('dep_date')
        if m.get('invoice_id') is not None:
            self.invoice_id = m.get('invoice_id')
        if m.get('itinerary_id') is not None:
            self.itinerary_id = m.get('itinerary_id')
        if m.get('itinerary_travel_standard') is not None:
            temp_model = ApplyAddRequestItineraryListItineraryTravelStandard()
            self.itinerary_travel_standard = temp_model.from_map(m['itinerary_travel_standard'])
        if m.get('need_hotel') is not None:
            self.need_hotel = m.get('need_hotel')
        if m.get('need_traffic') is not None:
            self.need_traffic = m.get('need_traffic')
        if m.get('project_code') is not None:
            self.project_code = m.get('project_code')
        if m.get('project_title') is not None:
            self.project_title = m.get('project_title')
        if m.get('province_travel_city_adcodes') is not None:
            self.province_travel_city_adcodes = m.get('province_travel_city_adcodes')
        if m.get('third_part_invoice_id') is not None:
            self.third_part_invoice_id = m.get('third_part_invoice_id')
        if m.get('thirdpart_cost_center_id') is not None:
            self.thirdpart_cost_center_id = m.get('thirdpart_cost_center_id')
        if m.get('traffic_type') is not None:
            self.traffic_type = m.get('traffic_type')
        if m.get('trip_way') is not None:
            self.trip_way = m.get('trip_way')
        return self


class ApplyAddRequestItinerarySetListItineraryTravelStandard(TeaModel):
    def __init__(
        self,
        hotel_available_nights_per_day: int = None,
    ):
        self.hotel_available_nights_per_day = hotel_available_nights_per_day

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.hotel_available_nights_per_day is not None:
            result['hotel_available_nights_per_day'] = self.hotel_available_nights_per_day
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('hotel_available_nights_per_day') is not None:
            self.hotel_available_nights_per_day = m.get('hotel_available_nights_per_day')
        return self


class ApplyAddRequestItinerarySetList(TeaModel):
    def __init__(
        self,
        arr_date: str = None,
        attribute: str = None,
        city_code_set: str = None,
        city_set: str = None,
        cost_center_id: int = None,
        dep_date: str = None,
        invoice_id: int = None,
        itinerary_id: str = None,
        itinerary_travel_standard: ApplyAddRequestItinerarySetListItineraryTravelStandard = None,
        project_code: str = None,
        project_title: str = None,
        province_travel_city_adcodes: List[str] = None,
        third_part_invoice_id: str = None,
        thirdpart_cost_center_id: str = None,
        traffic_type: int = None,
    ):
        # This parameter is required.
        self.arr_date = arr_date
        self.attribute = attribute
        # This parameter is required.
        self.city_code_set = city_code_set
        # This parameter is required.
        self.city_set = city_set
        self.cost_center_id = cost_center_id
        # This parameter is required.
        self.dep_date = dep_date
        self.invoice_id = invoice_id
        # This parameter is required.
        self.itinerary_id = itinerary_id
        self.itinerary_travel_standard = itinerary_travel_standard
        self.project_code = project_code
        self.project_title = project_title
        self.province_travel_city_adcodes = province_travel_city_adcodes
        self.third_part_invoice_id = third_part_invoice_id
        self.thirdpart_cost_center_id = thirdpart_cost_center_id
        # This parameter is required.
        self.traffic_type = traffic_type

    def validate(self):
        if self.itinerary_travel_standard:
            self.itinerary_travel_standard.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.arr_date is not None:
            result['arr_date'] = self.arr_date
        if self.attribute is not None:
            result['attribute'] = self.attribute
        if self.city_code_set is not None:
            result['city_code_set'] = self.city_code_set
        if self.city_set is not None:
            result['city_set'] = self.city_set
        if self.cost_center_id is not None:
            result['cost_center_id'] = self.cost_center_id
        if self.dep_date is not None:
            result['dep_date'] = self.dep_date
        if self.invoice_id is not None:
            result['invoice_id'] = self.invoice_id
        if self.itinerary_id is not None:
            result['itinerary_id'] = self.itinerary_id
        if self.itinerary_travel_standard is not None:
            result['itinerary_travel_standard'] = self.itinerary_travel_standard.to_map()
        if self.project_code is not None:
            result['project_code'] = self.project_code
        if self.project_title is not None:
            result['project_title'] = self.project_title
        if self.province_travel_city_adcodes is not None:
            result['province_travel_city_adcodes'] = self.province_travel_city_adcodes
        if self.third_part_invoice_id is not None:
            result['third_part_invoice_id'] = self.third_part_invoice_id
        if self.thirdpart_cost_center_id is not None:
            result['thirdpart_cost_center_id'] = self.thirdpart_cost_center_id
        if self.traffic_type is not None:
            result['traffic_type'] = self.traffic_type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('arr_date') is not None:
            self.arr_date = m.get('arr_date')
        if m.get('attribute') is not None:
            self.attribute = m.get('attribute')
        if m.get('city_code_set') is not None:
            self.city_code_set = m.get('city_code_set')
        if m.get('city_set') is not None:
            self.city_set = m.get('city_set')
        if m.get('cost_center_id') is not None:
            self.cost_center_id = m.get('cost_center_id')
        if m.get('dep_date') is not None:
            self.dep_date = m.get('dep_date')
        if m.get('invoice_id') is not None:
            self.invoice_id = m.get('invoice_id')
        if m.get('itinerary_id') is not None:
            self.itinerary_id = m.get('itinerary_id')
        if m.get('itinerary_travel_standard') is not None:
            temp_model = ApplyAddRequestItinerarySetListItineraryTravelStandard()
            self.itinerary_travel_standard = temp_model.from_map(m['itinerary_travel_standard'])
        if m.get('project_code') is not None:
            self.project_code = m.get('project_code')
        if m.get('project_title') is not None:
            self.project_title = m.get('project_title')
        if m.get('province_travel_city_adcodes') is not None:
            self.province_travel_city_adcodes = m.get('province_travel_city_adcodes')
        if m.get('third_part_invoice_id') is not None:
            self.third_part_invoice_id = m.get('third_part_invoice_id')
        if m.get('thirdpart_cost_center_id') is not None:
            self.thirdpart_cost_center_id = m.get('thirdpart_cost_center_id')
        if m.get('traffic_type') is not None:
            self.traffic_type = m.get('traffic_type')
        return self


class ApplyAddRequestTravelerList(TeaModel):
    def __init__(
        self,
        attribute: str = None,
        cost_center_id: int = None,
        invoice_id: int = None,
        payment_department_id: str = None,
        payment_department_name: str = None,
        project_code: str = None,
        project_title: str = None,
        third_part_invoice_id: str = None,
        thirdpart_cost_center_id: str = None,
        thirdpart_depart_id: str = None,
        user_id: str = None,
        user_name: str = None,
    ):
        self.attribute = attribute
        self.cost_center_id = cost_center_id
        self.invoice_id = invoice_id
        self.payment_department_id = payment_department_id
        self.payment_department_name = payment_department_name
        self.project_code = project_code
        self.project_title = project_title
        self.third_part_invoice_id = third_part_invoice_id
        self.thirdpart_cost_center_id = thirdpart_cost_center_id
        self.thirdpart_depart_id = thirdpart_depart_id
        self.user_id = user_id
        self.user_name = user_name

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.attribute is not None:
            result['attribute'] = self.attribute
        if self.cost_center_id is not None:
            result['cost_center_id'] = self.cost_center_id
        if self.invoice_id is not None:
            result['invoice_id'] = self.invoice_id
        if self.payment_department_id is not None:
            result['payment_department_id'] = self.payment_department_id
        if self.payment_department_name is not None:
            result['payment_department_name'] = self.payment_department_name
        if self.project_code is not None:
            result['project_code'] = self.project_code
        if self.project_title is not None:
            result['project_title'] = self.project_title
        if self.third_part_invoice_id is not None:
            result['third_part_invoice_id'] = self.third_part_invoice_id
        if self.thirdpart_cost_center_id is not None:
            result['thirdpart_cost_center_id'] = self.thirdpart_cost_center_id
        if self.thirdpart_depart_id is not None:
            result['thirdpart_depart_id'] = self.thirdpart_depart_id
        if self.user_id is not None:
            result['user_id'] = self.user_id
        if self.user_name is not None:
            result['user_name'] = self.user_name
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('attribute') is not None:
            self.attribute = m.get('attribute')
        if m.get('cost_center_id') is not None:
            self.cost_center_id = m.get('cost_center_id')
        if m.get('invoice_id') is not None:
            self.invoice_id = m.get('invoice_id')
        if m.get('payment_department_id') is not None:
            self.payment_department_id = m.get('payment_department_id')
        if m.get('payment_department_name') is not None:
            self.payment_department_name = m.get('payment_department_name')
        if m.get('project_code') is not None:
            self.project_code = m.get('project_code')
        if m.get('project_title') is not None:
            self.project_title = m.get('project_title')
        if m.get('third_part_invoice_id') is not None:
            self.third_part_invoice_id = m.get('third_part_invoice_id')
        if m.get('thirdpart_cost_center_id') is not None:
            self.thirdpart_cost_center_id = m.get('thirdpart_cost_center_id')
        if m.get('thirdpart_depart_id') is not None:
            self.thirdpart_depart_id = m.get('thirdpart_depart_id')
        if m.get('user_id') is not None:
            self.user_id = m.get('user_id')
        if m.get('user_name') is not None:
            self.user_name = m.get('user_name')
        return self


class ApplyAddRequestTravelerStandardCarCitySet(TeaModel):
    def __init__(
        self,
        city_code: str = None,
        city_name: str = None,
    ):
        # This parameter is required.
        self.city_code = city_code
        # This parameter is required.
        self.city_name = city_name

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.city_code is not None:
            result['city_code'] = self.city_code
        if self.city_name is not None:
            result['city_name'] = self.city_name
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('city_code') is not None:
            self.city_code = m.get('city_code')
        if m.get('city_name') is not None:
            self.city_name = m.get('city_name')
        return self


class ApplyAddRequestTravelerStandardHotelCitys(TeaModel):
    def __init__(
        self,
        city_code: str = None,
        city_name: str = None,
        fee: int = None,
    ):
        self.city_code = city_code
        self.city_name = city_name
        self.fee = fee

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.city_code is not None:
            result['city_code'] = self.city_code
        if self.city_name is not None:
            result['city_name'] = self.city_name
        if self.fee is not None:
            result['fee'] = self.fee
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('city_code') is not None:
            self.city_code = m.get('city_code')
        if m.get('city_name') is not None:
            self.city_name = m.get('city_name')
        if m.get('fee') is not None:
            self.fee = m.get('fee')
        return self


class ApplyAddRequestTravelerStandardHotelIntlCitys(TeaModel):
    def __init__(
        self,
        city_code: str = None,
        city_name: str = None,
        fee: int = None,
    ):
        self.city_code = city_code
        self.city_name = city_name
        self.fee = fee

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.city_code is not None:
            result['city_code'] = self.city_code
        if self.city_name is not None:
            result['city_name'] = self.city_name
        if self.fee is not None:
            result['fee'] = self.fee
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('city_code') is not None:
            self.city_code = m.get('city_code')
        if m.get('city_name') is not None:
            self.city_name = m.get('city_name')
        if m.get('fee') is not None:
            self.fee = m.get('fee')
        return self


class ApplyAddRequestTravelerStandard(TeaModel):
    def __init__(
        self,
        business_discount: int = None,
        car_city_set: List[ApplyAddRequestTravelerStandardCarCitySet] = None,
        economy_discount: int = None,
        first_discount: int = None,
        flight_cabins: str = None,
        flight_intl_rule_code: int = None,
        flight_rule_code: int = None,
        hotel_citys: List[ApplyAddRequestTravelerStandardHotelCitys] = None,
        hotel_intl_citys: List[ApplyAddRequestTravelerStandardHotelIntlCitys] = None,
        hotel_intl_rule_code: int = None,
        hotel_rule_code: int = None,
        international_flight_cabins: str = None,
        premium_economy_discount: int = None,
        reserve_type: int = None,
        train_rule_code: int = None,
        train_seats: str = None,
        user_id: str = None,
    ):
        self.business_discount = business_discount
        self.car_city_set = car_city_set
        self.economy_discount = economy_discount
        self.first_discount = first_discount
        self.flight_cabins = flight_cabins
        self.flight_intl_rule_code = flight_intl_rule_code
        self.flight_rule_code = flight_rule_code
        self.hotel_citys = hotel_citys
        self.hotel_intl_citys = hotel_intl_citys
        self.hotel_intl_rule_code = hotel_intl_rule_code
        self.hotel_rule_code = hotel_rule_code
        self.international_flight_cabins = international_flight_cabins
        self.premium_economy_discount = premium_economy_discount
        self.reserve_type = reserve_type
        self.train_rule_code = train_rule_code
        self.train_seats = train_seats
        self.user_id = user_id

    def validate(self):
        if self.car_city_set:
            for k in self.car_city_set:
                if k:
                    k.validate()
        if self.hotel_citys:
            for k in self.hotel_citys:
                if k:
                    k.validate()
        if self.hotel_intl_citys:
            for k in self.hotel_intl_citys:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.business_discount is not None:
            result['business_discount'] = self.business_discount
        result['car_city_set'] = []
        if self.car_city_set is not None:
            for k in self.car_city_set:
                result['car_city_set'].append(k.to_map() if k else None)
        if self.economy_discount is not None:
            result['economy_discount'] = self.economy_discount
        if self.first_discount is not None:
            result['first_discount'] = self.first_discount
        if self.flight_cabins is not None:
            result['flight_cabins'] = self.flight_cabins
        if self.flight_intl_rule_code is not None:
            result['flight_intl_rule_code'] = self.flight_intl_rule_code
        if self.flight_rule_code is not None:
            result['flight_rule_code'] = self.flight_rule_code
        result['hotel_citys'] = []
        if self.hotel_citys is not None:
            for k in self.hotel_citys:
                result['hotel_citys'].append(k.to_map() if k else None)
        result['hotel_intl_citys'] = []
        if self.hotel_intl_citys is not None:
            for k in self.hotel_intl_citys:
                result['hotel_intl_citys'].append(k.to_map() if k else None)
        if self.hotel_intl_rule_code is not None:
            result['hotel_intl_rule_code'] = self.hotel_intl_rule_code
        if self.hotel_rule_code is not None:
            result['hotel_rule_code'] = self.hotel_rule_code
        if self.international_flight_cabins is not None:
            result['international_flight_cabins'] = self.international_flight_cabins
        if self.premium_economy_discount is not None:
            result['premium_economy_discount'] = self.premium_economy_discount
        if self.reserve_type is not None:
            result['reserve_type'] = self.reserve_type
        if self.train_rule_code is not None:
            result['train_rule_code'] = self.train_rule_code
        if self.train_seats is not None:
            result['train_seats'] = self.train_seats
        if self.user_id is not None:
            result['user_id'] = self.user_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('business_discount') is not None:
            self.business_discount = m.get('business_discount')
        self.car_city_set = []
        if m.get('car_city_set') is not None:
            for k in m.get('car_city_set'):
                temp_model = ApplyAddRequestTravelerStandardCarCitySet()
                self.car_city_set.append(temp_model.from_map(k))
        if m.get('economy_discount') is not None:
            self.economy_discount = m.get('economy_discount')
        if m.get('first_discount') is not None:
            self.first_discount = m.get('first_discount')
        if m.get('flight_cabins') is not None:
            self.flight_cabins = m.get('flight_cabins')
        if m.get('flight_intl_rule_code') is not None:
            self.flight_intl_rule_code = m.get('flight_intl_rule_code')
        if m.get('flight_rule_code') is not None:
            self.flight_rule_code = m.get('flight_rule_code')
        self.hotel_citys = []
        if m.get('hotel_citys') is not None:
            for k in m.get('hotel_citys'):
                temp_model = ApplyAddRequestTravelerStandardHotelCitys()
                self.hotel_citys.append(temp_model.from_map(k))
        self.hotel_intl_citys = []
        if m.get('hotel_intl_citys') is not None:
            for k in m.get('hotel_intl_citys'):
                temp_model = ApplyAddRequestTravelerStandardHotelIntlCitys()
                self.hotel_intl_citys.append(temp_model.from_map(k))
        if m.get('hotel_intl_rule_code') is not None:
            self.hotel_intl_rule_code = m.get('hotel_intl_rule_code')
        if m.get('hotel_rule_code') is not None:
            self.hotel_rule_code = m.get('hotel_rule_code')
        if m.get('international_flight_cabins') is not None:
            self.international_flight_cabins = m.get('international_flight_cabins')
        if m.get('premium_economy_discount') is not None:
            self.premium_economy_discount = m.get('premium_economy_discount')
        if m.get('reserve_type') is not None:
            self.reserve_type = m.get('reserve_type')
        if m.get('train_rule_code') is not None:
            self.train_rule_code = m.get('train_rule_code')
        if m.get('train_seats') is not None:
            self.train_seats = m.get('train_seats')
        if m.get('user_id') is not None:
            self.user_id = m.get('user_id')
        return self


class ApplyAddRequest(TeaModel):
    def __init__(
        self,
        budget: int = None,
        budget_merge: int = None,
        car_rule: ApplyAddRequestCarRule = None,
        corp_name: str = None,
        default_standard: ApplyAddRequestDefaultStandard = None,
        depart_id: str = None,
        depart_name: str = None,
        extend_field: str = None,
        external_traveler_list: List[ApplyAddRequestExternalTravelerList] = None,
        external_traveler_standard: ApplyAddRequestExternalTravelerStandard = None,
        flight_budget: int = None,
        hotel_budget: int = None,
        hotel_share: ApplyAddRequestHotelShare = None,
        international_flight_cabins: str = None,
        intl_flight_budget: int = None,
        intl_hotel_budget: int = None,
        itinerary_list: List[ApplyAddRequestItineraryList] = None,
        itinerary_rule: int = None,
        itinerary_set_list: List[ApplyAddRequestItinerarySetList] = None,
        limit_traveler: int = None,
        meal_budget: int = None,
        payment_department_id: str = None,
        payment_department_name: str = None,
        status: int = None,
        sub_corp_id: str = None,
        thirdpart_apply_id: str = None,
        thirdpart_business_id: str = None,
        thirdpart_depart_id: str = None,
        together_book_rule: int = None,
        train_budget: int = None,
        traveler_list: List[ApplyAddRequestTravelerList] = None,
        traveler_standard: List[ApplyAddRequestTravelerStandard] = None,
        trip_cause: str = None,
        trip_day: int = None,
        trip_title: str = None,
        type: int = None,
        union_no: str = None,
        user_id: str = None,
        user_name: str = None,
        vehicle_budget: int = None,
    ):
        self.budget = budget
        self.budget_merge = budget_merge
        self.car_rule = car_rule
        self.corp_name = corp_name
        self.default_standard = default_standard
        self.depart_id = depart_id
        self.depart_name = depart_name
        # 可将补充描述传入此字段，账单中将会体现此字段的值。可以用于企业的统计和对账
        self.extend_field = extend_field
        self.external_traveler_list = external_traveler_list
        self.external_traveler_standard = external_traveler_standard
        self.flight_budget = flight_budget
        self.hotel_budget = hotel_budget
        self.hotel_share = hotel_share
        self.international_flight_cabins = international_flight_cabins
        self.intl_flight_budget = intl_flight_budget
        self.intl_hotel_budget = intl_hotel_budget
        self.itinerary_list = itinerary_list
        self.itinerary_rule = itinerary_rule
        self.itinerary_set_list = itinerary_set_list
        self.limit_traveler = limit_traveler
        self.meal_budget = meal_budget
        self.payment_department_id = payment_department_id
        self.payment_department_name = payment_department_name
        self.status = status
        self.sub_corp_id = sub_corp_id
        # This parameter is required.
        self.thirdpart_apply_id = thirdpart_apply_id
        self.thirdpart_business_id = thirdpart_business_id
        self.thirdpart_depart_id = thirdpart_depart_id
        self.together_book_rule = together_book_rule
        self.train_budget = train_budget
        self.traveler_list = traveler_list
        self.traveler_standard = traveler_standard
        # This parameter is required.
        self.trip_cause = trip_cause
        self.trip_day = trip_day
        # This parameter is required.
        self.trip_title = trip_title
        self.type = type
        self.union_no = union_no
        # This parameter is required.
        self.user_id = user_id
        self.user_name = user_name
        self.vehicle_budget = vehicle_budget

    def validate(self):
        if self.car_rule:
            self.car_rule.validate()
        if self.default_standard:
            self.default_standard.validate()
        if self.external_traveler_list:
            for k in self.external_traveler_list:
                if k:
                    k.validate()
        if self.external_traveler_standard:
            self.external_traveler_standard.validate()
        if self.hotel_share:
            self.hotel_share.validate()
        if self.itinerary_list:
            for k in self.itinerary_list:
                if k:
                    k.validate()
        if self.itinerary_set_list:
            for k in self.itinerary_set_list:
                if k:
                    k.validate()
        if self.traveler_list:
            for k in self.traveler_list:
                if k:
                    k.validate()
        if self.traveler_standard:
            for k in self.traveler_standard:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.budget is not None:
            result['budget'] = self.budget
        if self.budget_merge is not None:
            result['budget_merge'] = self.budget_merge
        if self.car_rule is not None:
            result['car_rule'] = self.car_rule.to_map()
        if self.corp_name is not None:
            result['corp_name'] = self.corp_name
        if self.default_standard is not None:
            result['default_standard'] = self.default_standard.to_map()
        if self.depart_id is not None:
            result['depart_id'] = self.depart_id
        if self.depart_name is not None:
            result['depart_name'] = self.depart_name
        if self.extend_field is not None:
            result['extend_field'] = self.extend_field
        result['external_traveler_list'] = []
        if self.external_traveler_list is not None:
            for k in self.external_traveler_list:
                result['external_traveler_list'].append(k.to_map() if k else None)
        if self.external_traveler_standard is not None:
            result['external_traveler_standard'] = self.external_traveler_standard.to_map()
        if self.flight_budget is not None:
            result['flight_budget'] = self.flight_budget
        if self.hotel_budget is not None:
            result['hotel_budget'] = self.hotel_budget
        if self.hotel_share is not None:
            result['hotel_share'] = self.hotel_share.to_map()
        if self.international_flight_cabins is not None:
            result['international_flight_cabins'] = self.international_flight_cabins
        if self.intl_flight_budget is not None:
            result['intl_flight_budget'] = self.intl_flight_budget
        if self.intl_hotel_budget is not None:
            result['intl_hotel_budget'] = self.intl_hotel_budget
        result['itinerary_list'] = []
        if self.itinerary_list is not None:
            for k in self.itinerary_list:
                result['itinerary_list'].append(k.to_map() if k else None)
        if self.itinerary_rule is not None:
            result['itinerary_rule'] = self.itinerary_rule
        result['itinerary_set_list'] = []
        if self.itinerary_set_list is not None:
            for k in self.itinerary_set_list:
                result['itinerary_set_list'].append(k.to_map() if k else None)
        if self.limit_traveler is not None:
            result['limit_traveler'] = self.limit_traveler
        if self.meal_budget is not None:
            result['meal_budget'] = self.meal_budget
        if self.payment_department_id is not None:
            result['payment_department_id'] = self.payment_department_id
        if self.payment_department_name is not None:
            result['payment_department_name'] = self.payment_department_name
        if self.status is not None:
            result['status'] = self.status
        if self.sub_corp_id is not None:
            result['sub_corp_id'] = self.sub_corp_id
        if self.thirdpart_apply_id is not None:
            result['thirdpart_apply_id'] = self.thirdpart_apply_id
        if self.thirdpart_business_id is not None:
            result['thirdpart_business_id'] = self.thirdpart_business_id
        if self.thirdpart_depart_id is not None:
            result['thirdpart_depart_id'] = self.thirdpart_depart_id
        if self.together_book_rule is not None:
            result['together_book_rule'] = self.together_book_rule
        if self.train_budget is not None:
            result['train_budget'] = self.train_budget
        result['traveler_list'] = []
        if self.traveler_list is not None:
            for k in self.traveler_list:
                result['traveler_list'].append(k.to_map() if k else None)
        result['traveler_standard'] = []
        if self.traveler_standard is not None:
            for k in self.traveler_standard:
                result['traveler_standard'].append(k.to_map() if k else None)
        if self.trip_cause is not None:
            result['trip_cause'] = self.trip_cause
        if self.trip_day is not None:
            result['trip_day'] = self.trip_day
        if self.trip_title is not None:
            result['trip_title'] = self.trip_title
        if self.type is not None:
            result['type'] = self.type
        if self.union_no is not None:
            result['union_no'] = self.union_no
        if self.user_id is not None:
            result['user_id'] = self.user_id
        if self.user_name is not None:
            result['user_name'] = self.user_name
        if self.vehicle_budget is not None:
            result['vehicle_budget'] = self.vehicle_budget
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('budget') is not None:
            self.budget = m.get('budget')
        if m.get('budget_merge') is not None:
            self.budget_merge = m.get('budget_merge')
        if m.get('car_rule') is not None:
            temp_model = ApplyAddRequestCarRule()
            self.car_rule = temp_model.from_map(m['car_rule'])
        if m.get('corp_name') is not None:
            self.corp_name = m.get('corp_name')
        if m.get('default_standard') is not None:
            temp_model = ApplyAddRequestDefaultStandard()
            self.default_standard = temp_model.from_map(m['default_standard'])
        if m.get('depart_id') is not None:
            self.depart_id = m.get('depart_id')
        if m.get('depart_name') is not None:
            self.depart_name = m.get('depart_name')
        if m.get('extend_field') is not None:
            self.extend_field = m.get('extend_field')
        self.external_traveler_list = []
        if m.get('external_traveler_list') is not None:
            for k in m.get('external_traveler_list'):
                temp_model = ApplyAddRequestExternalTravelerList()
                self.external_traveler_list.append(temp_model.from_map(k))
        if m.get('external_traveler_standard') is not None:
            temp_model = ApplyAddRequestExternalTravelerStandard()
            self.external_traveler_standard = temp_model.from_map(m['external_traveler_standard'])
        if m.get('flight_budget') is not None:
            self.flight_budget = m.get('flight_budget')
        if m.get('hotel_budget') is not None:
            self.hotel_budget = m.get('hotel_budget')
        if m.get('hotel_share') is not None:
            temp_model = ApplyAddRequestHotelShare()
            self.hotel_share = temp_model.from_map(m['hotel_share'])
        if m.get('international_flight_cabins') is not None:
            self.international_flight_cabins = m.get('international_flight_cabins')
        if m.get('intl_flight_budget') is not None:
            self.intl_flight_budget = m.get('intl_flight_budget')
        if m.get('intl_hotel_budget') is not None:
            self.intl_hotel_budget = m.get('intl_hotel_budget')
        self.itinerary_list = []
        if m.get('itinerary_list') is not None:
            for k in m.get('itinerary_list'):
                temp_model = ApplyAddRequestItineraryList()
                self.itinerary_list.append(temp_model.from_map(k))
        if m.get('itinerary_rule') is not None:
            self.itinerary_rule = m.get('itinerary_rule')
        self.itinerary_set_list = []
        if m.get('itinerary_set_list') is not None:
            for k in m.get('itinerary_set_list'):
                temp_model = ApplyAddRequestItinerarySetList()
                self.itinerary_set_list.append(temp_model.from_map(k))
        if m.get('limit_traveler') is not None:
            self.limit_traveler = m.get('limit_traveler')
        if m.get('meal_budget') is not None:
            self.meal_budget = m.get('meal_budget')
        if m.get('payment_department_id') is not None:
            self.payment_department_id = m.get('payment_department_id')
        if m.get('payment_department_name') is not None:
            self.payment_department_name = m.get('payment_department_name')
        if m.get('status') is not None:
            self.status = m.get('status')
        if m.get('sub_corp_id') is not None:
            self.sub_corp_id = m.get('sub_corp_id')
        if m.get('thirdpart_apply_id') is not None:
            self.thirdpart_apply_id = m.get('thirdpart_apply_id')
        if m.get('thirdpart_business_id') is not None:
            self.thirdpart_business_id = m.get('thirdpart_business_id')
        if m.get('thirdpart_depart_id') is not None:
            self.thirdpart_depart_id = m.get('thirdpart_depart_id')
        if m.get('together_book_rule') is not None:
            self.together_book_rule = m.get('together_book_rule')
        if m.get('train_budget') is not None:
            self.train_budget = m.get('train_budget')
        self.traveler_list = []
        if m.get('traveler_list') is not None:
            for k in m.get('traveler_list'):
                temp_model = ApplyAddRequestTravelerList()
                self.traveler_list.append(temp_model.from_map(k))
        self.traveler_standard = []
        if m.get('traveler_standard') is not None:
            for k in m.get('traveler_standard'):
                temp_model = ApplyAddRequestTravelerStandard()
                self.traveler_standard.append(temp_model.from_map(k))
        if m.get('trip_cause') is not None:
            self.trip_cause = m.get('trip_cause')
        if m.get('trip_day') is not None:
            self.trip_day = m.get('trip_day')
        if m.get('trip_title') is not None:
            self.trip_title = m.get('trip_title')
        if m.get('type') is not None:
            self.type = m.get('type')
        if m.get('union_no') is not None:
            self.union_no = m.get('union_no')
        if m.get('user_id') is not None:
            self.user_id = m.get('user_id')
        if m.get('user_name') is not None:
            self.user_name = m.get('user_name')
        if m.get('vehicle_budget') is not None:
            self.vehicle_budget = m.get('vehicle_budget')
        return self


class ApplyAddShrinkRequest(TeaModel):
    def __init__(
        self,
        budget: int = None,
        budget_merge: int = None,
        car_rule_shrink: str = None,
        corp_name: str = None,
        default_standard_shrink: str = None,
        depart_id: str = None,
        depart_name: str = None,
        extend_field: str = None,
        external_traveler_list_shrink: str = None,
        external_traveler_standard_shrink: str = None,
        flight_budget: int = None,
        hotel_budget: int = None,
        hotel_share_shrink: str = None,
        international_flight_cabins: str = None,
        intl_flight_budget: int = None,
        intl_hotel_budget: int = None,
        itinerary_list_shrink: str = None,
        itinerary_rule: int = None,
        itinerary_set_list_shrink: str = None,
        limit_traveler: int = None,
        meal_budget: int = None,
        payment_department_id: str = None,
        payment_department_name: str = None,
        status: int = None,
        sub_corp_id: str = None,
        thirdpart_apply_id: str = None,
        thirdpart_business_id: str = None,
        thirdpart_depart_id: str = None,
        together_book_rule: int = None,
        train_budget: int = None,
        traveler_list_shrink: str = None,
        traveler_standard_shrink: str = None,
        trip_cause: str = None,
        trip_day: int = None,
        trip_title: str = None,
        type: int = None,
        union_no: str = None,
        user_id: str = None,
        user_name: str = None,
        vehicle_budget: int = None,
    ):
        self.budget = budget
        self.budget_merge = budget_merge
        self.car_rule_shrink = car_rule_shrink
        self.corp_name = corp_name
        self.default_standard_shrink = default_standard_shrink
        self.depart_id = depart_id
        self.depart_name = depart_name
        # 可将补充描述传入此字段，账单中将会体现此字段的值。可以用于企业的统计和对账
        self.extend_field = extend_field
        self.external_traveler_list_shrink = external_traveler_list_shrink
        self.external_traveler_standard_shrink = external_traveler_standard_shrink
        self.flight_budget = flight_budget
        self.hotel_budget = hotel_budget
        self.hotel_share_shrink = hotel_share_shrink
        self.international_flight_cabins = international_flight_cabins
        self.intl_flight_budget = intl_flight_budget
        self.intl_hotel_budget = intl_hotel_budget
        self.itinerary_list_shrink = itinerary_list_shrink
        self.itinerary_rule = itinerary_rule
        self.itinerary_set_list_shrink = itinerary_set_list_shrink
        self.limit_traveler = limit_traveler
        self.meal_budget = meal_budget
        self.payment_department_id = payment_department_id
        self.payment_department_name = payment_department_name
        self.status = status
        self.sub_corp_id = sub_corp_id
        # This parameter is required.
        self.thirdpart_apply_id = thirdpart_apply_id
        self.thirdpart_business_id = thirdpart_business_id
        self.thirdpart_depart_id = thirdpart_depart_id
        self.together_book_rule = together_book_rule
        self.train_budget = train_budget
        self.traveler_list_shrink = traveler_list_shrink
        self.traveler_standard_shrink = traveler_standard_shrink
        # This parameter is required.
        self.trip_cause = trip_cause
        self.trip_day = trip_day
        # This parameter is required.
        self.trip_title = trip_title
        self.type = type
        self.union_no = union_no
        # This parameter is required.
        self.user_id = user_id
        self.user_name = user_name
        self.vehicle_budget = vehicle_budget

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.budget is not None:
            result['budget'] = self.budget
        if self.budget_merge is not None:
            result['budget_merge'] = self.budget_merge
        if self.car_rule_shrink is not None:
            result['car_rule'] = self.car_rule_shrink
        if self.corp_name is not None:
            result['corp_name'] = self.corp_name
        if self.default_standard_shrink is not None:
            result['default_standard'] = self.default_standard_shrink
        if self.depart_id is not None:
            result['depart_id'] = self.depart_id
        if self.depart_name is not None:
            result['depart_name'] = self.depart_name
        if self.extend_field is not None:
            result['extend_field'] = self.extend_field
        if self.external_traveler_list_shrink is not None:
            result['external_traveler_list'] = self.external_traveler_list_shrink
        if self.external_traveler_standard_shrink is not None:
            result['external_traveler_standard'] = self.external_traveler_standard_shrink
        if self.flight_budget is not None:
            result['flight_budget'] = self.flight_budget
        if self.hotel_budget is not None:
            result['hotel_budget'] = self.hotel_budget
        if self.hotel_share_shrink is not None:
            result['hotel_share'] = self.hotel_share_shrink
        if self.international_flight_cabins is not None:
            result['international_flight_cabins'] = self.international_flight_cabins
        if self.intl_flight_budget is not None:
            result['intl_flight_budget'] = self.intl_flight_budget
        if self.intl_hotel_budget is not None:
            result['intl_hotel_budget'] = self.intl_hotel_budget
        if self.itinerary_list_shrink is not None:
            result['itinerary_list'] = self.itinerary_list_shrink
        if self.itinerary_rule is not None:
            result['itinerary_rule'] = self.itinerary_rule
        if self.itinerary_set_list_shrink is not None:
            result['itinerary_set_list'] = self.itinerary_set_list_shrink
        if self.limit_traveler is not None:
            result['limit_traveler'] = self.limit_traveler
        if self.meal_budget is not None:
            result['meal_budget'] = self.meal_budget
        if self.payment_department_id is not None:
            result['payment_department_id'] = self.payment_department_id
        if self.payment_department_name is not None:
            result['payment_department_name'] = self.payment_department_name
        if self.status is not None:
            result['status'] = self.status
        if self.sub_corp_id is not None:
            result['sub_corp_id'] = self.sub_corp_id
        if self.thirdpart_apply_id is not None:
            result['thirdpart_apply_id'] = self.thirdpart_apply_id
        if self.thirdpart_business_id is not None:
            result['thirdpart_business_id'] = self.thirdpart_business_id
        if self.thirdpart_depart_id is not None:
            result['thirdpart_depart_id'] = self.thirdpart_depart_id
        if self.together_book_rule is not None:
            result['together_book_rule'] = self.together_book_rule
        if self.train_budget is not None:
            result['train_budget'] = self.train_budget
        if self.traveler_list_shrink is not None:
            result['traveler_list'] = self.traveler_list_shrink
        if self.traveler_standard_shrink is not None:
            result['traveler_standard'] = self.traveler_standard_shrink
        if self.trip_cause is not None:
            result['trip_cause'] = self.trip_cause
        if self.trip_day is not None:
            result['trip_day'] = self.trip_day
        if self.trip_title is not None:
            result['trip_title'] = self.trip_title
        if self.type is not None:
            result['type'] = self.type
        if self.union_no is not None:
            result['union_no'] = self.union_no
        if self.user_id is not None:
            result['user_id'] = self.user_id
        if self.user_name is not None:
            result['user_name'] = self.user_name
        if self.vehicle_budget is not None:
            result['vehicle_budget'] = self.vehicle_budget
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('budget') is not None:
            self.budget = m.get('budget')
        if m.get('budget_merge') is not None:
            self.budget_merge = m.get('budget_merge')
        if m.get('car_rule') is not None:
            self.car_rule_shrink = m.get('car_rule')
        if m.get('corp_name') is not None:
            self.corp_name = m.get('corp_name')
        if m.get('default_standard') is not None:
            self.default_standard_shrink = m.get('default_standard')
        if m.get('depart_id') is not None:
            self.depart_id = m.get('depart_id')
        if m.get('depart_name') is not None:
            self.depart_name = m.get('depart_name')
        if m.get('extend_field') is not None:
            self.extend_field = m.get('extend_field')
        if m.get('external_traveler_list') is not None:
            self.external_traveler_list_shrink = m.get('external_traveler_list')
        if m.get('external_traveler_standard') is not None:
            self.external_traveler_standard_shrink = m.get('external_traveler_standard')
        if m.get('flight_budget') is not None:
            self.flight_budget = m.get('flight_budget')
        if m.get('hotel_budget') is not None:
            self.hotel_budget = m.get('hotel_budget')
        if m.get('hotel_share') is not None:
            self.hotel_share_shrink = m.get('hotel_share')
        if m.get('international_flight_cabins') is not None:
            self.international_flight_cabins = m.get('international_flight_cabins')
        if m.get('intl_flight_budget') is not None:
            self.intl_flight_budget = m.get('intl_flight_budget')
        if m.get('intl_hotel_budget') is not None:
            self.intl_hotel_budget = m.get('intl_hotel_budget')
        if m.get('itinerary_list') is not None:
            self.itinerary_list_shrink = m.get('itinerary_list')
        if m.get('itinerary_rule') is not None:
            self.itinerary_rule = m.get('itinerary_rule')
        if m.get('itinerary_set_list') is not None:
            self.itinerary_set_list_shrink = m.get('itinerary_set_list')
        if m.get('limit_traveler') is not None:
            self.limit_traveler = m.get('limit_traveler')
        if m.get('meal_budget') is not None:
            self.meal_budget = m.get('meal_budget')
        if m.get('payment_department_id') is not None:
            self.payment_department_id = m.get('payment_department_id')
        if m.get('payment_department_name') is not None:
            self.payment_department_name = m.get('payment_department_name')
        if m.get('status') is not None:
            self.status = m.get('status')
        if m.get('sub_corp_id') is not None:
            self.sub_corp_id = m.get('sub_corp_id')
        if m.get('thirdpart_apply_id') is not None:
            self.thirdpart_apply_id = m.get('thirdpart_apply_id')
        if m.get('thirdpart_business_id') is not None:
            self.thirdpart_business_id = m.get('thirdpart_business_id')
        if m.get('thirdpart_depart_id') is not None:
            self.thirdpart_depart_id = m.get('thirdpart_depart_id')
        if m.get('together_book_rule') is not None:
            self.together_book_rule = m.get('together_book_rule')
        if m.get('train_budget') is not None:
            self.train_budget = m.get('train_budget')
        if m.get('traveler_list') is not None:
            self.traveler_list_shrink = m.get('traveler_list')
        if m.get('traveler_standard') is not None:
            self.traveler_standard_shrink = m.get('traveler_standard')
        if m.get('trip_cause') is not None:
            self.trip_cause = m.get('trip_cause')
        if m.get('trip_day') is not None:
            self.trip_day = m.get('trip_day')
        if m.get('trip_title') is not None:
            self.trip_title = m.get('trip_title')
        if m.get('type') is not None:
            self.type = m.get('type')
        if m.get('union_no') is not None:
            self.union_no = m.get('union_no')
        if m.get('user_id') is not None:
            self.user_id = m.get('user_id')
        if m.get('user_name') is not None:
            self.user_name = m.get('user_name')
        if m.get('vehicle_budget') is not None:
            self.vehicle_budget = m.get('vehicle_budget')
        return self


class ApplyAddResponseBodyModule(TeaModel):
    def __init__(
        self,
        apply_id: int = None,
        thirdpart_apply_id: str = None,
        thirdpart_business_id: str = None,
    ):
        self.apply_id = apply_id
        self.thirdpart_apply_id = thirdpart_apply_id
        self.thirdpart_business_id = thirdpart_business_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.apply_id is not None:
            result['apply_id'] = self.apply_id
        if self.thirdpart_apply_id is not None:
            result['thirdpart_apply_id'] = self.thirdpart_apply_id
        if self.thirdpart_business_id is not None:
            result['thirdpart_business_id'] = self.thirdpart_business_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('apply_id') is not None:
            self.apply_id = m.get('apply_id')
        if m.get('thirdpart_apply_id') is not None:
            self.thirdpart_apply_id = m.get('thirdpart_apply_id')
        if m.get('thirdpart_business_id') is not None:
            self.thirdpart_business_id = m.get('thirdpart_business_id')
        return self


class ApplyAddResponseBody(TeaModel):
    def __init__(
        self,
        code: str = None,
        message: str = None,
        module: ApplyAddResponseBodyModule = None,
        request_id: str = None,
        success: bool = None,
        trace_id: str = None,
    ):
        self.code = code
        self.message = message
        # module。
        self.module = module
        self.request_id = request_id
        self.success = success
        self.trace_id = trace_id

    def validate(self):
        if self.module:
            self.module.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['code'] = self.code
        if self.message is not None:
            result['message'] = self.message
        if self.module is not None:
            result['module'] = self.module.to_map()
        if self.request_id is not None:
            result['requestId'] = self.request_id
        if self.success is not None:
            result['success'] = self.success
        if self.trace_id is not None:
            result['traceId'] = self.trace_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('code') is not None:
            self.code = m.get('code')
        if m.get('message') is not None:
            self.message = m.get('message')
        if m.get('module') is not None:
            temp_model = ApplyAddResponseBodyModule()
            self.module = temp_model.from_map(m['module'])
        if m.get('requestId') is not None:
            self.request_id = m.get('requestId')
        if m.get('success') is not None:
            self.success = m.get('success')
        if m.get('traceId') is not None:
            self.trace_id = m.get('traceId')
        return self


class ApplyAddResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: ApplyAddResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = ApplyAddResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class ApplyApproveHeaders(TeaModel):
    def __init__(
        self,
        common_headers: Dict[str, str] = None,
        x_acs_btrip_so_corp_token: str = None,
    ):
        self.common_headers = common_headers
        self.x_acs_btrip_so_corp_token = x_acs_btrip_so_corp_token

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.common_headers is not None:
            result['commonHeaders'] = self.common_headers
        if self.x_acs_btrip_so_corp_token is not None:
            result['x-acs-btrip-so-corp-token'] = self.x_acs_btrip_so_corp_token
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('commonHeaders') is not None:
            self.common_headers = m.get('commonHeaders')
        if m.get('x-acs-btrip-so-corp-token') is not None:
            self.x_acs_btrip_so_corp_token = m.get('x-acs-btrip-so-corp-token')
        return self


class ApplyApproveRequest(TeaModel):
    def __init__(
        self,
        apply_id: str = None,
        note: str = None,
        operate_time: str = None,
        status: int = None,
        sub_corp_id: str = None,
        user_id: str = None,
        user_name: str = None,
    ):
        # This parameter is required.
        self.apply_id = apply_id
        self.note = note
        # This parameter is required.
        self.operate_time = operate_time
        # This parameter is required.
        self.status = status
        self.sub_corp_id = sub_corp_id
        # This parameter is required.
        self.user_id = user_id
        self.user_name = user_name

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.apply_id is not None:
            result['apply_id'] = self.apply_id
        if self.note is not None:
            result['note'] = self.note
        if self.operate_time is not None:
            result['operate_time'] = self.operate_time
        if self.status is not None:
            result['status'] = self.status
        if self.sub_corp_id is not None:
            result['sub_corp_id'] = self.sub_corp_id
        if self.user_id is not None:
            result['user_id'] = self.user_id
        if self.user_name is not None:
            result['user_name'] = self.user_name
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('apply_id') is not None:
            self.apply_id = m.get('apply_id')
        if m.get('note') is not None:
            self.note = m.get('note')
        if m.get('operate_time') is not None:
            self.operate_time = m.get('operate_time')
        if m.get('status') is not None:
            self.status = m.get('status')
        if m.get('sub_corp_id') is not None:
            self.sub_corp_id = m.get('sub_corp_id')
        if m.get('user_id') is not None:
            self.user_id = m.get('user_id')
        if m.get('user_name') is not None:
            self.user_name = m.get('user_name')
        return self


class ApplyApproveResponseBody(TeaModel):
    def __init__(
        self,
        code: str = None,
        message: str = None,
        module: str = None,
        request_id: str = None,
        success: bool = None,
        trace_id: str = None,
    ):
        self.code = code
        self.message = message
        # module。
        self.module = module
        self.request_id = request_id
        self.success = success
        self.trace_id = trace_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['code'] = self.code
        if self.message is not None:
            result['message'] = self.message
        if self.module is not None:
            result['module'] = self.module
        if self.request_id is not None:
            result['requestId'] = self.request_id
        if self.success is not None:
            result['success'] = self.success
        if self.trace_id is not None:
            result['traceId'] = self.trace_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('code') is not None:
            self.code = m.get('code')
        if m.get('message') is not None:
            self.message = m.get('message')
        if m.get('module') is not None:
            self.module = m.get('module')
        if m.get('requestId') is not None:
            self.request_id = m.get('requestId')
        if m.get('success') is not None:
            self.success = m.get('success')
        if m.get('traceId') is not None:
            self.trace_id = m.get('traceId')
        return self


class ApplyApproveResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: ApplyApproveResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = ApplyApproveResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class ApplyExternalNodeStatusUpdateHeaders(TeaModel):
    def __init__(
        self,
        common_headers: Dict[str, str] = None,
        x_acs_btrip_corp_token: str = None,
    ):
        self.common_headers = common_headers
        self.x_acs_btrip_corp_token = x_acs_btrip_corp_token

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.common_headers is not None:
            result['commonHeaders'] = self.common_headers
        if self.x_acs_btrip_corp_token is not None:
            result['x-acs-btrip-corp-token'] = self.x_acs_btrip_corp_token
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('commonHeaders') is not None:
            self.common_headers = m.get('commonHeaders')
        if m.get('x-acs-btrip-corp-token') is not None:
            self.x_acs_btrip_corp_token = m.get('x-acs-btrip-corp-token')
        return self


class ApplyExternalNodeStatusUpdateRequestOperationRecords(TeaModel):
    def __init__(
        self,
        comment: str = None,
        operate_time: str = None,
        operator_name: str = None,
        result: str = None,
        type: str = None,
    ):
        self.comment = comment
        self.operate_time = operate_time
        self.operator_name = operator_name
        self.result = result
        self.type = type

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.comment is not None:
            result['comment'] = self.comment
        if self.operate_time is not None:
            result['operate_time'] = self.operate_time
        if self.operator_name is not None:
            result['operator_name'] = self.operator_name
        if self.result is not None:
            result['result'] = self.result
        if self.type is not None:
            result['type'] = self.type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('comment') is not None:
            self.comment = m.get('comment')
        if m.get('operate_time') is not None:
            self.operate_time = m.get('operate_time')
        if m.get('operator_name') is not None:
            self.operator_name = m.get('operator_name')
        if m.get('result') is not None:
            self.result = m.get('result')
        if m.get('type') is not None:
            self.type = m.get('type')
        return self


class ApplyExternalNodeStatusUpdateRequest(TeaModel):
    def __init__(
        self,
        node_id: str = None,
        operation_records: List[ApplyExternalNodeStatusUpdateRequestOperationRecords] = None,
        process_action_result: str = None,
    ):
        # This parameter is required.
        self.node_id = node_id
        self.operation_records = operation_records
        # This parameter is required.
        self.process_action_result = process_action_result

    def validate(self):
        if self.operation_records:
            for k in self.operation_records:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.node_id is not None:
            result['node_id'] = self.node_id
        result['operation_records'] = []
        if self.operation_records is not None:
            for k in self.operation_records:
                result['operation_records'].append(k.to_map() if k else None)
        if self.process_action_result is not None:
            result['process_action_result'] = self.process_action_result
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('node_id') is not None:
            self.node_id = m.get('node_id')
        self.operation_records = []
        if m.get('operation_records') is not None:
            for k in m.get('operation_records'):
                temp_model = ApplyExternalNodeStatusUpdateRequestOperationRecords()
                self.operation_records.append(temp_model.from_map(k))
        if m.get('process_action_result') is not None:
            self.process_action_result = m.get('process_action_result')
        return self


class ApplyExternalNodeStatusUpdateShrinkRequest(TeaModel):
    def __init__(
        self,
        node_id: str = None,
        operation_records_shrink: str = None,
        process_action_result: str = None,
    ):
        # This parameter is required.
        self.node_id = node_id
        self.operation_records_shrink = operation_records_shrink
        # This parameter is required.
        self.process_action_result = process_action_result

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.node_id is not None:
            result['node_id'] = self.node_id
        if self.operation_records_shrink is not None:
            result['operation_records'] = self.operation_records_shrink
        if self.process_action_result is not None:
            result['process_action_result'] = self.process_action_result
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('node_id') is not None:
            self.node_id = m.get('node_id')
        if m.get('operation_records') is not None:
            self.operation_records_shrink = m.get('operation_records')
        if m.get('process_action_result') is not None:
            self.process_action_result = m.get('process_action_result')
        return self


class ApplyExternalNodeStatusUpdateResponseBody(TeaModel):
    def __init__(
        self,
        code: str = None,
        message: str = None,
        module: bool = None,
        request_id: str = None,
        success: bool = None,
        trace_id: str = None,
    ):
        self.code = code
        self.message = message
        self.module = module
        self.request_id = request_id
        self.success = success
        # traceId
        self.trace_id = trace_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['code'] = self.code
        if self.message is not None:
            result['message'] = self.message
        if self.module is not None:
            result['module'] = self.module
        if self.request_id is not None:
            result['requestId'] = self.request_id
        if self.success is not None:
            result['success'] = self.success
        if self.trace_id is not None:
            result['traceId'] = self.trace_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('code') is not None:
            self.code = m.get('code')
        if m.get('message') is not None:
            self.message = m.get('message')
        if m.get('module') is not None:
            self.module = m.get('module')
        if m.get('requestId') is not None:
            self.request_id = m.get('requestId')
        if m.get('success') is not None:
            self.success = m.get('success')
        if m.get('traceId') is not None:
            self.trace_id = m.get('traceId')
        return self


class ApplyExternalNodeStatusUpdateResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: ApplyExternalNodeStatusUpdateResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = ApplyExternalNodeStatusUpdateResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class ApplyInvoiceTaskHeaders(TeaModel):
    def __init__(
        self,
        common_headers: Dict[str, str] = None,
        x_acs_btrip_so_corp_token: str = None,
    ):
        self.common_headers = common_headers
        self.x_acs_btrip_so_corp_token = x_acs_btrip_so_corp_token

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.common_headers is not None:
            result['commonHeaders'] = self.common_headers
        if self.x_acs_btrip_so_corp_token is not None:
            result['x-acs-btrip-so-corp-token'] = self.x_acs_btrip_so_corp_token
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('commonHeaders') is not None:
            self.common_headers = m.get('commonHeaders')
        if m.get('x-acs-btrip-so-corp-token') is not None:
            self.x_acs_btrip_so_corp_token = m.get('x-acs-btrip-so-corp-token')
        return self


class ApplyInvoiceTaskRequestInvoiceTaskList(TeaModel):
    def __init__(
        self,
        contact: str = None,
        email: str = None,
        flight_invoice_fee: str = None,
        fu_point_invoice_fee: str = None,
        hotel_normal_invoice_fee: str = None,
        hotel_special_invoice_fee: str = None,
        international_flight_invoice_fee: str = None,
        international_hotel_invoice_fee: str = None,
        invoice_third_part_id: str = None,
        invoice_type: int = None,
        mail_address: str = None,
        mail_city: str = None,
        mail_full_address: str = None,
        mail_province: str = None,
        meal_normal_invoice_fee: str = None,
        penalty_fee: str = None,
        remark: str = None,
        service_fee: str = None,
        telephone: str = None,
        train_acceleration_package_invoice_fee: str = None,
        train_invoice_fee: str = None,
        vacation_normal_invoice_fee: str = None,
        vas_mall_special_invoice_fee: str = None,
        vehicle_invoice_fee: str = None,
        vehicle_normal_invoice_fee: str = None,
    ):
        self.contact = contact
        self.email = email
        self.flight_invoice_fee = flight_invoice_fee
        self.fu_point_invoice_fee = fu_point_invoice_fee
        self.hotel_normal_invoice_fee = hotel_normal_invoice_fee
        self.hotel_special_invoice_fee = hotel_special_invoice_fee
        self.international_flight_invoice_fee = international_flight_invoice_fee
        self.international_hotel_invoice_fee = international_hotel_invoice_fee
        # This parameter is required.
        self.invoice_third_part_id = invoice_third_part_id
        self.invoice_type = invoice_type
        self.mail_address = mail_address
        self.mail_city = mail_city
        self.mail_full_address = mail_full_address
        self.mail_province = mail_province
        self.meal_normal_invoice_fee = meal_normal_invoice_fee
        self.penalty_fee = penalty_fee
        self.remark = remark
        self.service_fee = service_fee
        self.telephone = telephone
        self.train_acceleration_package_invoice_fee = train_acceleration_package_invoice_fee
        self.train_invoice_fee = train_invoice_fee
        self.vacation_normal_invoice_fee = vacation_normal_invoice_fee
        self.vas_mall_special_invoice_fee = vas_mall_special_invoice_fee
        self.vehicle_invoice_fee = vehicle_invoice_fee
        self.vehicle_normal_invoice_fee = vehicle_normal_invoice_fee

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.contact is not None:
            result['contact'] = self.contact
        if self.email is not None:
            result['email'] = self.email
        if self.flight_invoice_fee is not None:
            result['flight_invoice_fee'] = self.flight_invoice_fee
        if self.fu_point_invoice_fee is not None:
            result['fu_point_invoice_fee'] = self.fu_point_invoice_fee
        if self.hotel_normal_invoice_fee is not None:
            result['hotel_normal_invoice_fee'] = self.hotel_normal_invoice_fee
        if self.hotel_special_invoice_fee is not None:
            result['hotel_special_invoice_fee'] = self.hotel_special_invoice_fee
        if self.international_flight_invoice_fee is not None:
            result['international_flight_invoice_fee'] = self.international_flight_invoice_fee
        if self.international_hotel_invoice_fee is not None:
            result['international_hotel_invoice_fee'] = self.international_hotel_invoice_fee
        if self.invoice_third_part_id is not None:
            result['invoice_third_part_id'] = self.invoice_third_part_id
        if self.invoice_type is not None:
            result['invoice_type'] = self.invoice_type
        if self.mail_address is not None:
            result['mail_address'] = self.mail_address
        if self.mail_city is not None:
            result['mail_city'] = self.mail_city
        if self.mail_full_address is not None:
            result['mail_full_address'] = self.mail_full_address
        if self.mail_province is not None:
            result['mail_province'] = self.mail_province
        if self.meal_normal_invoice_fee is not None:
            result['meal_normal_invoice_fee'] = self.meal_normal_invoice_fee
        if self.penalty_fee is not None:
            result['penalty_fee'] = self.penalty_fee
        if self.remark is not None:
            result['remark'] = self.remark
        if self.service_fee is not None:
            result['service_fee'] = self.service_fee
        if self.telephone is not None:
            result['telephone'] = self.telephone
        if self.train_acceleration_package_invoice_fee is not None:
            result['train_acceleration_package_invoice_fee'] = self.train_acceleration_package_invoice_fee
        if self.train_invoice_fee is not None:
            result['train_invoice_fee'] = self.train_invoice_fee
        if self.vacation_normal_invoice_fee is not None:
            result['vacation_normal_invoice_fee'] = self.vacation_normal_invoice_fee
        if self.vas_mall_special_invoice_fee is not None:
            result['vas_mall_special_invoice_fee'] = self.vas_mall_special_invoice_fee
        if self.vehicle_invoice_fee is not None:
            result['vehicle_invoice_fee'] = self.vehicle_invoice_fee
        if self.vehicle_normal_invoice_fee is not None:
            result['vehicle_normal_invoice_fee'] = self.vehicle_normal_invoice_fee
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('contact') is not None:
            self.contact = m.get('contact')
        if m.get('email') is not None:
            self.email = m.get('email')
        if m.get('flight_invoice_fee') is not None:
            self.flight_invoice_fee = m.get('flight_invoice_fee')
        if m.get('fu_point_invoice_fee') is not None:
            self.fu_point_invoice_fee = m.get('fu_point_invoice_fee')
        if m.get('hotel_normal_invoice_fee') is not None:
            self.hotel_normal_invoice_fee = m.get('hotel_normal_invoice_fee')
        if m.get('hotel_special_invoice_fee') is not None:
            self.hotel_special_invoice_fee = m.get('hotel_special_invoice_fee')
        if m.get('international_flight_invoice_fee') is not None:
            self.international_flight_invoice_fee = m.get('international_flight_invoice_fee')
        if m.get('international_hotel_invoice_fee') is not None:
            self.international_hotel_invoice_fee = m.get('international_hotel_invoice_fee')
        if m.get('invoice_third_part_id') is not None:
            self.invoice_third_part_id = m.get('invoice_third_part_id')
        if m.get('invoice_type') is not None:
            self.invoice_type = m.get('invoice_type')
        if m.get('mail_address') is not None:
            self.mail_address = m.get('mail_address')
        if m.get('mail_city') is not None:
            self.mail_city = m.get('mail_city')
        if m.get('mail_full_address') is not None:
            self.mail_full_address = m.get('mail_full_address')
        if m.get('mail_province') is not None:
            self.mail_province = m.get('mail_province')
        if m.get('meal_normal_invoice_fee') is not None:
            self.meal_normal_invoice_fee = m.get('meal_normal_invoice_fee')
        if m.get('penalty_fee') is not None:
            self.penalty_fee = m.get('penalty_fee')
        if m.get('remark') is not None:
            self.remark = m.get('remark')
        if m.get('service_fee') is not None:
            self.service_fee = m.get('service_fee')
        if m.get('telephone') is not None:
            self.telephone = m.get('telephone')
        if m.get('train_acceleration_package_invoice_fee') is not None:
            self.train_acceleration_package_invoice_fee = m.get('train_acceleration_package_invoice_fee')
        if m.get('train_invoice_fee') is not None:
            self.train_invoice_fee = m.get('train_invoice_fee')
        if m.get('vacation_normal_invoice_fee') is not None:
            self.vacation_normal_invoice_fee = m.get('vacation_normal_invoice_fee')
        if m.get('vas_mall_special_invoice_fee') is not None:
            self.vas_mall_special_invoice_fee = m.get('vas_mall_special_invoice_fee')
        if m.get('vehicle_invoice_fee') is not None:
            self.vehicle_invoice_fee = m.get('vehicle_invoice_fee')
        if m.get('vehicle_normal_invoice_fee') is not None:
            self.vehicle_normal_invoice_fee = m.get('vehicle_normal_invoice_fee')
        return self


class ApplyInvoiceTaskRequest(TeaModel):
    def __init__(
        self,
        bill_date: str = None,
        invoice_task_list: List[ApplyInvoiceTaskRequestInvoiceTaskList] = None,
    ):
        # This parameter is required.
        self.bill_date = bill_date
        # This parameter is required.
        self.invoice_task_list = invoice_task_list

    def validate(self):
        if self.invoice_task_list:
            for k in self.invoice_task_list:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.bill_date is not None:
            result['bill_date'] = self.bill_date
        result['invoice_task_list'] = []
        if self.invoice_task_list is not None:
            for k in self.invoice_task_list:
                result['invoice_task_list'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('bill_date') is not None:
            self.bill_date = m.get('bill_date')
        self.invoice_task_list = []
        if m.get('invoice_task_list') is not None:
            for k in m.get('invoice_task_list'):
                temp_model = ApplyInvoiceTaskRequestInvoiceTaskList()
                self.invoice_task_list.append(temp_model.from_map(k))
        return self


class ApplyInvoiceTaskShrinkRequest(TeaModel):
    def __init__(
        self,
        bill_date: str = None,
        invoice_task_list_shrink: str = None,
    ):
        # This parameter is required.
        self.bill_date = bill_date
        # This parameter is required.
        self.invoice_task_list_shrink = invoice_task_list_shrink

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.bill_date is not None:
            result['bill_date'] = self.bill_date
        if self.invoice_task_list_shrink is not None:
            result['invoice_task_list'] = self.invoice_task_list_shrink
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('bill_date') is not None:
            self.bill_date = m.get('bill_date')
        if m.get('invoice_task_list') is not None:
            self.invoice_task_list_shrink = m.get('invoice_task_list')
        return self


class ApplyInvoiceTaskResponseBody(TeaModel):
    def __init__(
        self,
        code: str = None,
        message: str = None,
        request_id: str = None,
        success: bool = None,
        trace_id: str = None,
    ):
        self.code = code
        self.message = message
        # requestId
        self.request_id = request_id
        self.success = success
        # traceId
        self.trace_id = trace_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['code'] = self.code
        if self.message is not None:
            result['message'] = self.message
        if self.request_id is not None:
            result['requestId'] = self.request_id
        if self.success is not None:
            result['success'] = self.success
        if self.trace_id is not None:
            result['traceId'] = self.trace_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('code') is not None:
            self.code = m.get('code')
        if m.get('message') is not None:
            self.message = m.get('message')
        if m.get('requestId') is not None:
            self.request_id = m.get('requestId')
        if m.get('success') is not None:
            self.success = m.get('success')
        if m.get('traceId') is not None:
            self.trace_id = m.get('traceId')
        return self


class ApplyInvoiceTaskResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: ApplyInvoiceTaskResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = ApplyInvoiceTaskResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class ApplyListQueryHeaders(TeaModel):
    def __init__(
        self,
        common_headers: Dict[str, str] = None,
        x_acs_btrip_so_corp_token: str = None,
    ):
        self.common_headers = common_headers
        self.x_acs_btrip_so_corp_token = x_acs_btrip_so_corp_token

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.common_headers is not None:
            result['commonHeaders'] = self.common_headers
        if self.x_acs_btrip_so_corp_token is not None:
            result['x-acs-btrip-so-corp-token'] = self.x_acs_btrip_so_corp_token
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('commonHeaders') is not None:
            self.common_headers = m.get('commonHeaders')
        if m.get('x-acs-btrip-so-corp-token') is not None:
            self.x_acs_btrip_so_corp_token = m.get('x-acs-btrip-so-corp-token')
        return self


class ApplyListQueryRequest(TeaModel):
    def __init__(
        self,
        all_apply: bool = None,
        depart_id: str = None,
        end_time: str = None,
        gmt_modified: str = None,
        only_shang_lv_apply: bool = None,
        page: int = None,
        page_size: int = None,
        start_time: str = None,
        sub_corp_id: str = None,
        type: int = None,
        union_no: str = None,
        user_id: str = None,
    ):
        self.all_apply = all_apply
        self.depart_id = depart_id
        self.end_time = end_time
        self.gmt_modified = gmt_modified
        self.only_shang_lv_apply = only_shang_lv_apply
        self.page = page
        self.page_size = page_size
        self.start_time = start_time
        self.sub_corp_id = sub_corp_id
        self.type = type
        self.union_no = union_no
        self.user_id = user_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.all_apply is not None:
            result['all_apply'] = self.all_apply
        if self.depart_id is not None:
            result['depart_id'] = self.depart_id
        if self.end_time is not None:
            result['end_time'] = self.end_time
        if self.gmt_modified is not None:
            result['gmt_modified'] = self.gmt_modified
        if self.only_shang_lv_apply is not None:
            result['only_shang_lv_apply'] = self.only_shang_lv_apply
        if self.page is not None:
            result['page'] = self.page
        if self.page_size is not None:
            result['page_size'] = self.page_size
        if self.start_time is not None:
            result['start_time'] = self.start_time
        if self.sub_corp_id is not None:
            result['sub_corp_id'] = self.sub_corp_id
        if self.type is not None:
            result['type'] = self.type
        if self.union_no is not None:
            result['union_no'] = self.union_no
        if self.user_id is not None:
            result['user_id'] = self.user_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('all_apply') is not None:
            self.all_apply = m.get('all_apply')
        if m.get('depart_id') is not None:
            self.depart_id = m.get('depart_id')
        if m.get('end_time') is not None:
            self.end_time = m.get('end_time')
        if m.get('gmt_modified') is not None:
            self.gmt_modified = m.get('gmt_modified')
        if m.get('only_shang_lv_apply') is not None:
            self.only_shang_lv_apply = m.get('only_shang_lv_apply')
        if m.get('page') is not None:
            self.page = m.get('page')
        if m.get('page_size') is not None:
            self.page_size = m.get('page_size')
        if m.get('start_time') is not None:
            self.start_time = m.get('start_time')
        if m.get('sub_corp_id') is not None:
            self.sub_corp_id = m.get('sub_corp_id')
        if m.get('type') is not None:
            self.type = m.get('type')
        if m.get('union_no') is not None:
            self.union_no = m.get('union_no')
        if m.get('user_id') is not None:
            self.user_id = m.get('user_id')
        return self


class ApplyListQueryResponseBodyModuleListApproverList(TeaModel):
    def __init__(
        self,
        note: str = None,
        operate_time: str = None,
        order: int = None,
        status: int = None,
        status_desc: str = None,
        user_id: str = None,
        user_name: str = None,
    ):
        self.note = note
        self.operate_time = operate_time
        self.order = order
        self.status = status
        self.status_desc = status_desc
        self.user_id = user_id
        self.user_name = user_name

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.note is not None:
            result['note'] = self.note
        if self.operate_time is not None:
            result['operate_time'] = self.operate_time
        if self.order is not None:
            result['order'] = self.order
        if self.status is not None:
            result['status'] = self.status
        if self.status_desc is not None:
            result['status_desc'] = self.status_desc
        if self.user_id is not None:
            result['user_id'] = self.user_id
        if self.user_name is not None:
            result['user_name'] = self.user_name
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('note') is not None:
            self.note = m.get('note')
        if m.get('operate_time') is not None:
            self.operate_time = m.get('operate_time')
        if m.get('order') is not None:
            self.order = m.get('order')
        if m.get('status') is not None:
            self.status = m.get('status')
        if m.get('status_desc') is not None:
            self.status_desc = m.get('status_desc')
        if m.get('user_id') is not None:
            self.user_id = m.get('user_id')
        if m.get('user_name') is not None:
            self.user_name = m.get('user_name')
        return self


class ApplyListQueryResponseBodyModuleListCarRule(TeaModel):
    def __init__(
        self,
        scenario_template_id: str = None,
        scenario_template_name: str = None,
    ):
        self.scenario_template_id = scenario_template_id
        self.scenario_template_name = scenario_template_name

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.scenario_template_id is not None:
            result['scenario_template_id'] = self.scenario_template_id
        if self.scenario_template_name is not None:
            result['scenario_template_name'] = self.scenario_template_name
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('scenario_template_id') is not None:
            self.scenario_template_id = m.get('scenario_template_id')
        if m.get('scenario_template_name') is not None:
            self.scenario_template_name = m.get('scenario_template_name')
        return self


class ApplyListQueryResponseBodyModuleListExternalTravelerList(TeaModel):
    def __init__(
        self,
        attribute: str = None,
        cost_center_name: str = None,
        depart_id: str = None,
        external_user_id: str = None,
        invoice_name: str = None,
        payment_department_name: str = None,
        project_code: str = None,
        project_title: str = None,
        thirdpart_depart_id: str = None,
        user_name: str = None,
    ):
        self.attribute = attribute
        self.cost_center_name = cost_center_name
        self.depart_id = depart_id
        self.external_user_id = external_user_id
        self.invoice_name = invoice_name
        self.payment_department_name = payment_department_name
        self.project_code = project_code
        self.project_title = project_title
        self.thirdpart_depart_id = thirdpart_depart_id
        self.user_name = user_name

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.attribute is not None:
            result['attribute'] = self.attribute
        if self.cost_center_name is not None:
            result['cost_center_name'] = self.cost_center_name
        if self.depart_id is not None:
            result['depart_id'] = self.depart_id
        if self.external_user_id is not None:
            result['external_user_id'] = self.external_user_id
        if self.invoice_name is not None:
            result['invoice_name'] = self.invoice_name
        if self.payment_department_name is not None:
            result['payment_department_name'] = self.payment_department_name
        if self.project_code is not None:
            result['project_code'] = self.project_code
        if self.project_title is not None:
            result['project_title'] = self.project_title
        if self.thirdpart_depart_id is not None:
            result['thirdpart_depart_id'] = self.thirdpart_depart_id
        if self.user_name is not None:
            result['user_name'] = self.user_name
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('attribute') is not None:
            self.attribute = m.get('attribute')
        if m.get('cost_center_name') is not None:
            self.cost_center_name = m.get('cost_center_name')
        if m.get('depart_id') is not None:
            self.depart_id = m.get('depart_id')
        if m.get('external_user_id') is not None:
            self.external_user_id = m.get('external_user_id')
        if m.get('invoice_name') is not None:
            self.invoice_name = m.get('invoice_name')
        if m.get('payment_department_name') is not None:
            self.payment_department_name = m.get('payment_department_name')
        if m.get('project_code') is not None:
            self.project_code = m.get('project_code')
        if m.get('project_title') is not None:
            self.project_title = m.get('project_title')
        if m.get('thirdpart_depart_id') is not None:
            self.thirdpart_depart_id = m.get('thirdpart_depart_id')
        if m.get('user_name') is not None:
            self.user_name = m.get('user_name')
        return self


class ApplyListQueryResponseBodyModuleListItineraryList(TeaModel):
    def __init__(
        self,
        arr_city: str = None,
        arr_date: str = None,
        cost_center_name: str = None,
        dep_city: str = None,
        dep_date: str = None,
        invoice_name: str = None,
        itinerary_id: str = None,
        project_code: str = None,
        project_title: str = None,
        thirdpart_cost_center_id: str = None,
        thirdpart_invoice_id: str = None,
        thirdpart_itinerary_id: str = None,
        traffic_type: int = None,
        trip_way: int = None,
    ):
        self.arr_city = arr_city
        self.arr_date = arr_date
        self.cost_center_name = cost_center_name
        self.dep_city = dep_city
        self.dep_date = dep_date
        self.invoice_name = invoice_name
        self.itinerary_id = itinerary_id
        self.project_code = project_code
        self.project_title = project_title
        self.thirdpart_cost_center_id = thirdpart_cost_center_id
        self.thirdpart_invoice_id = thirdpart_invoice_id
        self.thirdpart_itinerary_id = thirdpart_itinerary_id
        self.traffic_type = traffic_type
        self.trip_way = trip_way

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.arr_city is not None:
            result['arr_city'] = self.arr_city
        if self.arr_date is not None:
            result['arr_date'] = self.arr_date
        if self.cost_center_name is not None:
            result['cost_center_name'] = self.cost_center_name
        if self.dep_city is not None:
            result['dep_city'] = self.dep_city
        if self.dep_date is not None:
            result['dep_date'] = self.dep_date
        if self.invoice_name is not None:
            result['invoice_name'] = self.invoice_name
        if self.itinerary_id is not None:
            result['itinerary_id'] = self.itinerary_id
        if self.project_code is not None:
            result['project_code'] = self.project_code
        if self.project_title is not None:
            result['project_title'] = self.project_title
        if self.thirdpart_cost_center_id is not None:
            result['thirdpart_cost_center_id'] = self.thirdpart_cost_center_id
        if self.thirdpart_invoice_id is not None:
            result['thirdpart_invoice_id'] = self.thirdpart_invoice_id
        if self.thirdpart_itinerary_id is not None:
            result['thirdpart_itinerary_id'] = self.thirdpart_itinerary_id
        if self.traffic_type is not None:
            result['traffic_type'] = self.traffic_type
        if self.trip_way is not None:
            result['trip_way'] = self.trip_way
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('arr_city') is not None:
            self.arr_city = m.get('arr_city')
        if m.get('arr_date') is not None:
            self.arr_date = m.get('arr_date')
        if m.get('cost_center_name') is not None:
            self.cost_center_name = m.get('cost_center_name')
        if m.get('dep_city') is not None:
            self.dep_city = m.get('dep_city')
        if m.get('dep_date') is not None:
            self.dep_date = m.get('dep_date')
        if m.get('invoice_name') is not None:
            self.invoice_name = m.get('invoice_name')
        if m.get('itinerary_id') is not None:
            self.itinerary_id = m.get('itinerary_id')
        if m.get('project_code') is not None:
            self.project_code = m.get('project_code')
        if m.get('project_title') is not None:
            self.project_title = m.get('project_title')
        if m.get('thirdpart_cost_center_id') is not None:
            self.thirdpart_cost_center_id = m.get('thirdpart_cost_center_id')
        if m.get('thirdpart_invoice_id') is not None:
            self.thirdpart_invoice_id = m.get('thirdpart_invoice_id')
        if m.get('thirdpart_itinerary_id') is not None:
            self.thirdpart_itinerary_id = m.get('thirdpart_itinerary_id')
        if m.get('traffic_type') is not None:
            self.traffic_type = m.get('traffic_type')
        if m.get('trip_way') is not None:
            self.trip_way = m.get('trip_way')
        return self


class ApplyListQueryResponseBodyModuleListItinerarySetList(TeaModel):
    def __init__(
        self,
        arr_date: str = None,
        city_code_set: str = None,
        city_set: str = None,
        cost_center_name: str = None,
        dep_date: str = None,
        invoice_name: str = None,
        itinerary_id: str = None,
        project_code: str = None,
        project_title: str = None,
        thirdpart_cost_center_id: str = None,
        thirdpart_invoice_id: str = None,
        thirdpart_itinerary_id: str = None,
        traffic_type: int = None,
    ):
        self.arr_date = arr_date
        self.city_code_set = city_code_set
        self.city_set = city_set
        self.cost_center_name = cost_center_name
        self.dep_date = dep_date
        self.invoice_name = invoice_name
        self.itinerary_id = itinerary_id
        self.project_code = project_code
        self.project_title = project_title
        self.thirdpart_cost_center_id = thirdpart_cost_center_id
        self.thirdpart_invoice_id = thirdpart_invoice_id
        self.thirdpart_itinerary_id = thirdpart_itinerary_id
        self.traffic_type = traffic_type

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.arr_date is not None:
            result['arr_date'] = self.arr_date
        if self.city_code_set is not None:
            result['city_code_set'] = self.city_code_set
        if self.city_set is not None:
            result['city_set'] = self.city_set
        if self.cost_center_name is not None:
            result['cost_center_name'] = self.cost_center_name
        if self.dep_date is not None:
            result['dep_date'] = self.dep_date
        if self.invoice_name is not None:
            result['invoice_name'] = self.invoice_name
        if self.itinerary_id is not None:
            result['itinerary_id'] = self.itinerary_id
        if self.project_code is not None:
            result['project_code'] = self.project_code
        if self.project_title is not None:
            result['project_title'] = self.project_title
        if self.thirdpart_cost_center_id is not None:
            result['thirdpart_cost_center_id'] = self.thirdpart_cost_center_id
        if self.thirdpart_invoice_id is not None:
            result['thirdpart_invoice_id'] = self.thirdpart_invoice_id
        if self.thirdpart_itinerary_id is not None:
            result['thirdpart_itinerary_id'] = self.thirdpart_itinerary_id
        if self.traffic_type is not None:
            result['traffic_type'] = self.traffic_type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('arr_date') is not None:
            self.arr_date = m.get('arr_date')
        if m.get('city_code_set') is not None:
            self.city_code_set = m.get('city_code_set')
        if m.get('city_set') is not None:
            self.city_set = m.get('city_set')
        if m.get('cost_center_name') is not None:
            self.cost_center_name = m.get('cost_center_name')
        if m.get('dep_date') is not None:
            self.dep_date = m.get('dep_date')
        if m.get('invoice_name') is not None:
            self.invoice_name = m.get('invoice_name')
        if m.get('itinerary_id') is not None:
            self.itinerary_id = m.get('itinerary_id')
        if m.get('project_code') is not None:
            self.project_code = m.get('project_code')
        if m.get('project_title') is not None:
            self.project_title = m.get('project_title')
        if m.get('thirdpart_cost_center_id') is not None:
            self.thirdpart_cost_center_id = m.get('thirdpart_cost_center_id')
        if m.get('thirdpart_invoice_id') is not None:
            self.thirdpart_invoice_id = m.get('thirdpart_invoice_id')
        if m.get('thirdpart_itinerary_id') is not None:
            self.thirdpart_itinerary_id = m.get('thirdpart_itinerary_id')
        if m.get('traffic_type') is not None:
            self.traffic_type = m.get('traffic_type')
        return self


class ApplyListQueryResponseBodyModuleListTravelerListCarCitySet(TeaModel):
    def __init__(
        self,
        city_code: str = None,
        city_name: str = None,
    ):
        self.city_code = city_code
        self.city_name = city_name

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.city_code is not None:
            result['city_code'] = self.city_code
        if self.city_name is not None:
            result['city_name'] = self.city_name
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('city_code') is not None:
            self.city_code = m.get('city_code')
        if m.get('city_name') is not None:
            self.city_name = m.get('city_name')
        return self


class ApplyListQueryResponseBodyModuleListTravelerList(TeaModel):
    def __init__(
        self,
        attribute: str = None,
        car_city_set: List[ApplyListQueryResponseBodyModuleListTravelerListCarCitySet] = None,
        cost_center_name: str = None,
        depart_id: str = None,
        invoice_name: str = None,
        job_no: str = None,
        payment_department_name: str = None,
        project_code: str = None,
        project_title: str = None,
        thirdpart_depart_id: str = None,
        user_id: str = None,
        user_name: str = None,
    ):
        self.attribute = attribute
        self.car_city_set = car_city_set
        self.cost_center_name = cost_center_name
        self.depart_id = depart_id
        self.invoice_name = invoice_name
        self.job_no = job_no
        self.payment_department_name = payment_department_name
        self.project_code = project_code
        self.project_title = project_title
        self.thirdpart_depart_id = thirdpart_depart_id
        self.user_id = user_id
        self.user_name = user_name

    def validate(self):
        if self.car_city_set:
            for k in self.car_city_set:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.attribute is not None:
            result['attribute'] = self.attribute
        result['car_city_set'] = []
        if self.car_city_set is not None:
            for k in self.car_city_set:
                result['car_city_set'].append(k.to_map() if k else None)
        if self.cost_center_name is not None:
            result['cost_center_name'] = self.cost_center_name
        if self.depart_id is not None:
            result['depart_id'] = self.depart_id
        if self.invoice_name is not None:
            result['invoice_name'] = self.invoice_name
        if self.job_no is not None:
            result['job_no'] = self.job_no
        if self.payment_department_name is not None:
            result['payment_department_name'] = self.payment_department_name
        if self.project_code is not None:
            result['project_code'] = self.project_code
        if self.project_title is not None:
            result['project_title'] = self.project_title
        if self.thirdpart_depart_id is not None:
            result['thirdpart_depart_id'] = self.thirdpart_depart_id
        if self.user_id is not None:
            result['user_id'] = self.user_id
        if self.user_name is not None:
            result['user_name'] = self.user_name
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('attribute') is not None:
            self.attribute = m.get('attribute')
        self.car_city_set = []
        if m.get('car_city_set') is not None:
            for k in m.get('car_city_set'):
                temp_model = ApplyListQueryResponseBodyModuleListTravelerListCarCitySet()
                self.car_city_set.append(temp_model.from_map(k))
        if m.get('cost_center_name') is not None:
            self.cost_center_name = m.get('cost_center_name')
        if m.get('depart_id') is not None:
            self.depart_id = m.get('depart_id')
        if m.get('invoice_name') is not None:
            self.invoice_name = m.get('invoice_name')
        if m.get('job_no') is not None:
            self.job_no = m.get('job_no')
        if m.get('payment_department_name') is not None:
            self.payment_department_name = m.get('payment_department_name')
        if m.get('project_code') is not None:
            self.project_code = m.get('project_code')
        if m.get('project_title') is not None:
            self.project_title = m.get('project_title')
        if m.get('thirdpart_depart_id') is not None:
            self.thirdpart_depart_id = m.get('thirdpart_depart_id')
        if m.get('user_id') is not None:
            self.user_id = m.get('user_id')
        if m.get('user_name') is not None:
            self.user_name = m.get('user_name')
        return self


class ApplyListQueryResponseBodyModuleList(TeaModel):
    def __init__(
        self,
        apply_show_id: str = None,
        approver_list: List[ApplyListQueryResponseBodyModuleListApproverList] = None,
        car_rule: ApplyListQueryResponseBodyModuleListCarRule = None,
        corp_id: str = None,
        corp_name: str = None,
        depart_id: str = None,
        depart_name: str = None,
        external_traveler_list: List[ApplyListQueryResponseBodyModuleListExternalTravelerList] = None,
        flow_code: str = None,
        gmt_create: str = None,
        gmt_modified: str = None,
        id: int = None,
        itinerary_list: List[ApplyListQueryResponseBodyModuleListItineraryList] = None,
        itinerary_rule: int = None,
        itinerary_set_list: List[ApplyListQueryResponseBodyModuleListItinerarySetList] = None,
        job_no: str = None,
        payment_department_id: str = None,
        payment_department_name: str = None,
        status: int = None,
        status_desc: str = None,
        thirdpart_business_id: str = None,
        thirdpart_id: str = None,
        traveler_list: List[ApplyListQueryResponseBodyModuleListTravelerList] = None,
        trip_cause: str = None,
        trip_day: int = None,
        trip_title: str = None,
        type: int = None,
        union_no: str = None,
        user_id: str = None,
        user_name: str = None,
    ):
        self.apply_show_id = apply_show_id
        self.approver_list = approver_list
        self.car_rule = car_rule
        self.corp_id = corp_id
        self.corp_name = corp_name
        self.depart_id = depart_id
        self.depart_name = depart_name
        self.external_traveler_list = external_traveler_list
        self.flow_code = flow_code
        self.gmt_create = gmt_create
        self.gmt_modified = gmt_modified
        self.id = id
        self.itinerary_list = itinerary_list
        self.itinerary_rule = itinerary_rule
        self.itinerary_set_list = itinerary_set_list
        self.job_no = job_no
        self.payment_department_id = payment_department_id
        self.payment_department_name = payment_department_name
        self.status = status
        self.status_desc = status_desc
        self.thirdpart_business_id = thirdpart_business_id
        self.thirdpart_id = thirdpart_id
        self.traveler_list = traveler_list
        self.trip_cause = trip_cause
        self.trip_day = trip_day
        self.trip_title = trip_title
        self.type = type
        self.union_no = union_no
        self.user_id = user_id
        self.user_name = user_name

    def validate(self):
        if self.approver_list:
            for k in self.approver_list:
                if k:
                    k.validate()
        if self.car_rule:
            self.car_rule.validate()
        if self.external_traveler_list:
            for k in self.external_traveler_list:
                if k:
                    k.validate()
        if self.itinerary_list:
            for k in self.itinerary_list:
                if k:
                    k.validate()
        if self.itinerary_set_list:
            for k in self.itinerary_set_list:
                if k:
                    k.validate()
        if self.traveler_list:
            for k in self.traveler_list:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.apply_show_id is not None:
            result['apply_show_id'] = self.apply_show_id
        result['approver_list'] = []
        if self.approver_list is not None:
            for k in self.approver_list:
                result['approver_list'].append(k.to_map() if k else None)
        if self.car_rule is not None:
            result['car_rule'] = self.car_rule.to_map()
        if self.corp_id is not None:
            result['corp_id'] = self.corp_id
        if self.corp_name is not None:
            result['corp_name'] = self.corp_name
        if self.depart_id is not None:
            result['depart_id'] = self.depart_id
        if self.depart_name is not None:
            result['depart_name'] = self.depart_name
        result['external_traveler_list'] = []
        if self.external_traveler_list is not None:
            for k in self.external_traveler_list:
                result['external_traveler_list'].append(k.to_map() if k else None)
        if self.flow_code is not None:
            result['flow_code'] = self.flow_code
        if self.gmt_create is not None:
            result['gmt_create'] = self.gmt_create
        if self.gmt_modified is not None:
            result['gmt_modified'] = self.gmt_modified
        if self.id is not None:
            result['id'] = self.id
        result['itinerary_list'] = []
        if self.itinerary_list is not None:
            for k in self.itinerary_list:
                result['itinerary_list'].append(k.to_map() if k else None)
        if self.itinerary_rule is not None:
            result['itinerary_rule'] = self.itinerary_rule
        result['itinerary_set_list'] = []
        if self.itinerary_set_list is not None:
            for k in self.itinerary_set_list:
                result['itinerary_set_list'].append(k.to_map() if k else None)
        if self.job_no is not None:
            result['job_no'] = self.job_no
        if self.payment_department_id is not None:
            result['payment_department_id'] = self.payment_department_id
        if self.payment_department_name is not None:
            result['payment_department_name'] = self.payment_department_name
        if self.status is not None:
            result['status'] = self.status
        if self.status_desc is not None:
            result['status_desc'] = self.status_desc
        if self.thirdpart_business_id is not None:
            result['thirdpart_business_id'] = self.thirdpart_business_id
        if self.thirdpart_id is not None:
            result['thirdpart_id'] = self.thirdpart_id
        result['traveler_list'] = []
        if self.traveler_list is not None:
            for k in self.traveler_list:
                result['traveler_list'].append(k.to_map() if k else None)
        if self.trip_cause is not None:
            result['trip_cause'] = self.trip_cause
        if self.trip_day is not None:
            result['trip_day'] = self.trip_day
        if self.trip_title is not None:
            result['trip_title'] = self.trip_title
        if self.type is not None:
            result['type'] = self.type
        if self.union_no is not None:
            result['union_no'] = self.union_no
        if self.user_id is not None:
            result['user_id'] = self.user_id
        if self.user_name is not None:
            result['user_name'] = self.user_name
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('apply_show_id') is not None:
            self.apply_show_id = m.get('apply_show_id')
        self.approver_list = []
        if m.get('approver_list') is not None:
            for k in m.get('approver_list'):
                temp_model = ApplyListQueryResponseBodyModuleListApproverList()
                self.approver_list.append(temp_model.from_map(k))
        if m.get('car_rule') is not None:
            temp_model = ApplyListQueryResponseBodyModuleListCarRule()
            self.car_rule = temp_model.from_map(m['car_rule'])
        if m.get('corp_id') is not None:
            self.corp_id = m.get('corp_id')
        if m.get('corp_name') is not None:
            self.corp_name = m.get('corp_name')
        if m.get('depart_id') is not None:
            self.depart_id = m.get('depart_id')
        if m.get('depart_name') is not None:
            self.depart_name = m.get('depart_name')
        self.external_traveler_list = []
        if m.get('external_traveler_list') is not None:
            for k in m.get('external_traveler_list'):
                temp_model = ApplyListQueryResponseBodyModuleListExternalTravelerList()
                self.external_traveler_list.append(temp_model.from_map(k))
        if m.get('flow_code') is not None:
            self.flow_code = m.get('flow_code')
        if m.get('gmt_create') is not None:
            self.gmt_create = m.get('gmt_create')
        if m.get('gmt_modified') is not None:
            self.gmt_modified = m.get('gmt_modified')
        if m.get('id') is not None:
            self.id = m.get('id')
        self.itinerary_list = []
        if m.get('itinerary_list') is not None:
            for k in m.get('itinerary_list'):
                temp_model = ApplyListQueryResponseBodyModuleListItineraryList()
                self.itinerary_list.append(temp_model.from_map(k))
        if m.get('itinerary_rule') is not None:
            self.itinerary_rule = m.get('itinerary_rule')
        self.itinerary_set_list = []
        if m.get('itinerary_set_list') is not None:
            for k in m.get('itinerary_set_list'):
                temp_model = ApplyListQueryResponseBodyModuleListItinerarySetList()
                self.itinerary_set_list.append(temp_model.from_map(k))
        if m.get('job_no') is not None:
            self.job_no = m.get('job_no')
        if m.get('payment_department_id') is not None:
            self.payment_department_id = m.get('payment_department_id')
        if m.get('payment_department_name') is not None:
            self.payment_department_name = m.get('payment_department_name')
        if m.get('status') is not None:
            self.status = m.get('status')
        if m.get('status_desc') is not None:
            self.status_desc = m.get('status_desc')
        if m.get('thirdpart_business_id') is not None:
            self.thirdpart_business_id = m.get('thirdpart_business_id')
        if m.get('thirdpart_id') is not None:
            self.thirdpart_id = m.get('thirdpart_id')
        self.traveler_list = []
        if m.get('traveler_list') is not None:
            for k in m.get('traveler_list'):
                temp_model = ApplyListQueryResponseBodyModuleListTravelerList()
                self.traveler_list.append(temp_model.from_map(k))
        if m.get('trip_cause') is not None:
            self.trip_cause = m.get('trip_cause')
        if m.get('trip_day') is not None:
            self.trip_day = m.get('trip_day')
        if m.get('trip_title') is not None:
            self.trip_title = m.get('trip_title')
        if m.get('type') is not None:
            self.type = m.get('type')
        if m.get('union_no') is not None:
            self.union_no = m.get('union_no')
        if m.get('user_id') is not None:
            self.user_id = m.get('user_id')
        if m.get('user_name') is not None:
            self.user_name = m.get('user_name')
        return self


class ApplyListQueryResponseBody(TeaModel):
    def __init__(
        self,
        code: str = None,
        message: str = None,
        module_list: List[ApplyListQueryResponseBodyModuleList] = None,
        request_id: str = None,
        success: bool = None,
        trace_id: str = None,
    ):
        self.code = code
        self.message = message
        self.module_list = module_list
        self.request_id = request_id
        self.success = success
        self.trace_id = trace_id

    def validate(self):
        if self.module_list:
            for k in self.module_list:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['code'] = self.code
        if self.message is not None:
            result['message'] = self.message
        result['module_list'] = []
        if self.module_list is not None:
            for k in self.module_list:
                result['module_list'].append(k.to_map() if k else None)
        if self.request_id is not None:
            result['requestId'] = self.request_id
        if self.success is not None:
            result['success'] = self.success
        if self.trace_id is not None:
            result['traceId'] = self.trace_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('code') is not None:
            self.code = m.get('code')
        if m.get('message') is not None:
            self.message = m.get('message')
        self.module_list = []
        if m.get('module_list') is not None:
            for k in m.get('module_list'):
                temp_model = ApplyListQueryResponseBodyModuleList()
                self.module_list.append(temp_model.from_map(k))
        if m.get('requestId') is not None:
            self.request_id = m.get('requestId')
        if m.get('success') is not None:
            self.success = m.get('success')
        if m.get('traceId') is not None:
            self.trace_id = m.get('traceId')
        return self


class ApplyListQueryResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: ApplyListQueryResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = ApplyListQueryResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class ApplyModifyHeaders(TeaModel):
    def __init__(
        self,
        common_headers: Dict[str, str] = None,
        x_acs_btrip_so_corp_token: str = None,
    ):
        self.common_headers = common_headers
        self.x_acs_btrip_so_corp_token = x_acs_btrip_so_corp_token

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.common_headers is not None:
            result['commonHeaders'] = self.common_headers
        if self.x_acs_btrip_so_corp_token is not None:
            result['x-acs-btrip-so-corp-token'] = self.x_acs_btrip_so_corp_token
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('commonHeaders') is not None:
            self.common_headers = m.get('commonHeaders')
        if m.get('x-acs-btrip-so-corp-token') is not None:
            self.x_acs_btrip_so_corp_token = m.get('x-acs-btrip-so-corp-token')
        return self


class ApplyModifyRequestCarRule(TeaModel):
    def __init__(
        self,
        scenario_template_id: str = None,
        scenario_template_name: str = None,
    ):
        self.scenario_template_id = scenario_template_id
        self.scenario_template_name = scenario_template_name

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.scenario_template_id is not None:
            result['scenario_template_id'] = self.scenario_template_id
        if self.scenario_template_name is not None:
            result['scenario_template_name'] = self.scenario_template_name
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('scenario_template_id') is not None:
            self.scenario_template_id = m.get('scenario_template_id')
        if m.get('scenario_template_name') is not None:
            self.scenario_template_name = m.get('scenario_template_name')
        return self


class ApplyModifyRequestDefaultStandardHotelCitys(TeaModel):
    def __init__(
        self,
        city_code: str = None,
        city_name: str = None,
        fee: int = None,
    ):
        self.city_code = city_code
        self.city_name = city_name
        self.fee = fee

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.city_code is not None:
            result['city_code'] = self.city_code
        if self.city_name is not None:
            result['city_name'] = self.city_name
        if self.fee is not None:
            result['fee'] = self.fee
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('city_code') is not None:
            self.city_code = m.get('city_code')
        if m.get('city_name') is not None:
            self.city_name = m.get('city_name')
        if m.get('fee') is not None:
            self.fee = m.get('fee')
        return self


class ApplyModifyRequestDefaultStandardHotelIntlCitys(TeaModel):
    def __init__(
        self,
        city_code: str = None,
        city_name: str = None,
        fee: int = None,
    ):
        self.city_code = city_code
        self.city_name = city_name
        self.fee = fee

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.city_code is not None:
            result['city_code'] = self.city_code
        if self.city_name is not None:
            result['city_name'] = self.city_name
        if self.fee is not None:
            result['fee'] = self.fee
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('city_code') is not None:
            self.city_code = m.get('city_code')
        if m.get('city_name') is not None:
            self.city_name = m.get('city_name')
        if m.get('fee') is not None:
            self.fee = m.get('fee')
        return self


class ApplyModifyRequestDefaultStandard(TeaModel):
    def __init__(
        self,
        business_discount: int = None,
        economy_discount: int = None,
        first_discount: int = None,
        flight_cabins: str = None,
        flight_intl_rule_code: int = None,
        flight_rule_code: int = None,
        hotel_citys: List[ApplyModifyRequestDefaultStandardHotelCitys] = None,
        hotel_intl_citys: List[ApplyModifyRequestDefaultStandardHotelIntlCitys] = None,
        hotel_intl_rule_code: int = None,
        hotel_rule_code: int = None,
        premium_economy_discount: int = None,
        reserve_type: int = None,
        train_rule_code: int = None,
        train_seats: str = None,
    ):
        self.business_discount = business_discount
        self.economy_discount = economy_discount
        self.first_discount = first_discount
        self.flight_cabins = flight_cabins
        self.flight_intl_rule_code = flight_intl_rule_code
        self.flight_rule_code = flight_rule_code
        self.hotel_citys = hotel_citys
        self.hotel_intl_citys = hotel_intl_citys
        self.hotel_intl_rule_code = hotel_intl_rule_code
        self.hotel_rule_code = hotel_rule_code
        self.premium_economy_discount = premium_economy_discount
        self.reserve_type = reserve_type
        self.train_rule_code = train_rule_code
        self.train_seats = train_seats

    def validate(self):
        if self.hotel_citys:
            for k in self.hotel_citys:
                if k:
                    k.validate()
        if self.hotel_intl_citys:
            for k in self.hotel_intl_citys:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.business_discount is not None:
            result['business_discount'] = self.business_discount
        if self.economy_discount is not None:
            result['economy_discount'] = self.economy_discount
        if self.first_discount is not None:
            result['first_discount'] = self.first_discount
        if self.flight_cabins is not None:
            result['flight_cabins'] = self.flight_cabins
        if self.flight_intl_rule_code is not None:
            result['flight_intl_rule_code'] = self.flight_intl_rule_code
        if self.flight_rule_code is not None:
            result['flight_rule_code'] = self.flight_rule_code
        result['hotel_citys'] = []
        if self.hotel_citys is not None:
            for k in self.hotel_citys:
                result['hotel_citys'].append(k.to_map() if k else None)
        result['hotel_intl_citys'] = []
        if self.hotel_intl_citys is not None:
            for k in self.hotel_intl_citys:
                result['hotel_intl_citys'].append(k.to_map() if k else None)
        if self.hotel_intl_rule_code is not None:
            result['hotel_intl_rule_code'] = self.hotel_intl_rule_code
        if self.hotel_rule_code is not None:
            result['hotel_rule_code'] = self.hotel_rule_code
        if self.premium_economy_discount is not None:
            result['premium_economy_discount'] = self.premium_economy_discount
        if self.reserve_type is not None:
            result['reserve_type'] = self.reserve_type
        if self.train_rule_code is not None:
            result['train_rule_code'] = self.train_rule_code
        if self.train_seats is not None:
            result['train_seats'] = self.train_seats
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('business_discount') is not None:
            self.business_discount = m.get('business_discount')
        if m.get('economy_discount') is not None:
            self.economy_discount = m.get('economy_discount')
        if m.get('first_discount') is not None:
            self.first_discount = m.get('first_discount')
        if m.get('flight_cabins') is not None:
            self.flight_cabins = m.get('flight_cabins')
        if m.get('flight_intl_rule_code') is not None:
            self.flight_intl_rule_code = m.get('flight_intl_rule_code')
        if m.get('flight_rule_code') is not None:
            self.flight_rule_code = m.get('flight_rule_code')
        self.hotel_citys = []
        if m.get('hotel_citys') is not None:
            for k in m.get('hotel_citys'):
                temp_model = ApplyModifyRequestDefaultStandardHotelCitys()
                self.hotel_citys.append(temp_model.from_map(k))
        self.hotel_intl_citys = []
        if m.get('hotel_intl_citys') is not None:
            for k in m.get('hotel_intl_citys'):
                temp_model = ApplyModifyRequestDefaultStandardHotelIntlCitys()
                self.hotel_intl_citys.append(temp_model.from_map(k))
        if m.get('hotel_intl_rule_code') is not None:
            self.hotel_intl_rule_code = m.get('hotel_intl_rule_code')
        if m.get('hotel_rule_code') is not None:
            self.hotel_rule_code = m.get('hotel_rule_code')
        if m.get('premium_economy_discount') is not None:
            self.premium_economy_discount = m.get('premium_economy_discount')
        if m.get('reserve_type') is not None:
            self.reserve_type = m.get('reserve_type')
        if m.get('train_rule_code') is not None:
            self.train_rule_code = m.get('train_rule_code')
        if m.get('train_seats') is not None:
            self.train_seats = m.get('train_seats')
        return self


class ApplyModifyRequestExternalTravelerList(TeaModel):
    def __init__(
        self,
        attribute: str = None,
        cost_center_id: int = None,
        external_user_id: str = None,
        invoice_id: int = None,
        payment_department_id: str = None,
        payment_department_name: str = None,
        project_code: str = None,
        project_title: str = None,
        third_part_invoice_id: str = None,
        thirdpart_cost_center_id: str = None,
        thirdpart_depart_id: str = None,
        user_name: str = None,
        user_name_en: str = None,
    ):
        self.attribute = attribute
        self.cost_center_id = cost_center_id
        self.external_user_id = external_user_id
        self.invoice_id = invoice_id
        self.payment_department_id = payment_department_id
        self.payment_department_name = payment_department_name
        self.project_code = project_code
        self.project_title = project_title
        self.third_part_invoice_id = third_part_invoice_id
        self.thirdpart_cost_center_id = thirdpart_cost_center_id
        self.thirdpart_depart_id = thirdpart_depart_id
        self.user_name = user_name
        self.user_name_en = user_name_en

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.attribute is not None:
            result['attribute'] = self.attribute
        if self.cost_center_id is not None:
            result['cost_center_id'] = self.cost_center_id
        if self.external_user_id is not None:
            result['external_user_id'] = self.external_user_id
        if self.invoice_id is not None:
            result['invoice_id'] = self.invoice_id
        if self.payment_department_id is not None:
            result['payment_department_id'] = self.payment_department_id
        if self.payment_department_name is not None:
            result['payment_department_name'] = self.payment_department_name
        if self.project_code is not None:
            result['project_code'] = self.project_code
        if self.project_title is not None:
            result['project_title'] = self.project_title
        if self.third_part_invoice_id is not None:
            result['third_part_invoice_id'] = self.third_part_invoice_id
        if self.thirdpart_cost_center_id is not None:
            result['thirdpart_cost_center_id'] = self.thirdpart_cost_center_id
        if self.thirdpart_depart_id is not None:
            result['thirdpart_depart_id'] = self.thirdpart_depart_id
        if self.user_name is not None:
            result['user_name'] = self.user_name
        if self.user_name_en is not None:
            result['user_name_en'] = self.user_name_en
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('attribute') is not None:
            self.attribute = m.get('attribute')
        if m.get('cost_center_id') is not None:
            self.cost_center_id = m.get('cost_center_id')
        if m.get('external_user_id') is not None:
            self.external_user_id = m.get('external_user_id')
        if m.get('invoice_id') is not None:
            self.invoice_id = m.get('invoice_id')
        if m.get('payment_department_id') is not None:
            self.payment_department_id = m.get('payment_department_id')
        if m.get('payment_department_name') is not None:
            self.payment_department_name = m.get('payment_department_name')
        if m.get('project_code') is not None:
            self.project_code = m.get('project_code')
        if m.get('project_title') is not None:
            self.project_title = m.get('project_title')
        if m.get('third_part_invoice_id') is not None:
            self.third_part_invoice_id = m.get('third_part_invoice_id')
        if m.get('thirdpart_cost_center_id') is not None:
            self.thirdpart_cost_center_id = m.get('thirdpart_cost_center_id')
        if m.get('thirdpart_depart_id') is not None:
            self.thirdpart_depart_id = m.get('thirdpart_depart_id')
        if m.get('user_name') is not None:
            self.user_name = m.get('user_name')
        if m.get('user_name_en') is not None:
            self.user_name_en = m.get('user_name_en')
        return self


class ApplyModifyRequestExternalTravelerStandardHotelCitys(TeaModel):
    def __init__(
        self,
        city_code: str = None,
        city_name: str = None,
        fee: int = None,
    ):
        self.city_code = city_code
        self.city_name = city_name
        self.fee = fee

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.city_code is not None:
            result['city_code'] = self.city_code
        if self.city_name is not None:
            result['city_name'] = self.city_name
        if self.fee is not None:
            result['fee'] = self.fee
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('city_code') is not None:
            self.city_code = m.get('city_code')
        if m.get('city_name') is not None:
            self.city_name = m.get('city_name')
        if m.get('fee') is not None:
            self.fee = m.get('fee')
        return self


class ApplyModifyRequestExternalTravelerStandardHotelIntlCitys(TeaModel):
    def __init__(
        self,
        city_code: str = None,
        city_name: str = None,
        fee: int = None,
    ):
        self.city_code = city_code
        self.city_name = city_name
        self.fee = fee

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.city_code is not None:
            result['city_code'] = self.city_code
        if self.city_name is not None:
            result['city_name'] = self.city_name
        if self.fee is not None:
            result['fee'] = self.fee
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('city_code') is not None:
            self.city_code = m.get('city_code')
        if m.get('city_name') is not None:
            self.city_name = m.get('city_name')
        if m.get('fee') is not None:
            self.fee = m.get('fee')
        return self


class ApplyModifyRequestExternalTravelerStandard(TeaModel):
    def __init__(
        self,
        business_discount: int = None,
        economy_discount: int = None,
        first_discount: int = None,
        flight_cabins: str = None,
        flight_intl_rule_code: int = None,
        flight_rule_code: int = None,
        hotel_citys: List[ApplyModifyRequestExternalTravelerStandardHotelCitys] = None,
        hotel_intl_citys: List[ApplyModifyRequestExternalTravelerStandardHotelIntlCitys] = None,
        hotel_intl_rule_code: int = None,
        hotel_rule_code: int = None,
        premium_economy_discount: int = None,
        reserve_type: int = None,
        train_rule_code: int = None,
        train_seats: str = None,
    ):
        self.business_discount = business_discount
        self.economy_discount = economy_discount
        self.first_discount = first_discount
        self.flight_cabins = flight_cabins
        self.flight_intl_rule_code = flight_intl_rule_code
        self.flight_rule_code = flight_rule_code
        self.hotel_citys = hotel_citys
        self.hotel_intl_citys = hotel_intl_citys
        self.hotel_intl_rule_code = hotel_intl_rule_code
        self.hotel_rule_code = hotel_rule_code
        # 超级经济舱折扣。1到10的整数
        self.premium_economy_discount = premium_economy_discount
        self.reserve_type = reserve_type
        self.train_rule_code = train_rule_code
        self.train_seats = train_seats

    def validate(self):
        if self.hotel_citys:
            for k in self.hotel_citys:
                if k:
                    k.validate()
        if self.hotel_intl_citys:
            for k in self.hotel_intl_citys:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.business_discount is not None:
            result['business_discount'] = self.business_discount
        if self.economy_discount is not None:
            result['economy_discount'] = self.economy_discount
        if self.first_discount is not None:
            result['first_discount'] = self.first_discount
        if self.flight_cabins is not None:
            result['flight_cabins'] = self.flight_cabins
        if self.flight_intl_rule_code is not None:
            result['flight_intl_rule_code'] = self.flight_intl_rule_code
        if self.flight_rule_code is not None:
            result['flight_rule_code'] = self.flight_rule_code
        result['hotel_citys'] = []
        if self.hotel_citys is not None:
            for k in self.hotel_citys:
                result['hotel_citys'].append(k.to_map() if k else None)
        result['hotel_intl_citys'] = []
        if self.hotel_intl_citys is not None:
            for k in self.hotel_intl_citys:
                result['hotel_intl_citys'].append(k.to_map() if k else None)
        if self.hotel_intl_rule_code is not None:
            result['hotel_intl_rule_code'] = self.hotel_intl_rule_code
        if self.hotel_rule_code is not None:
            result['hotel_rule_code'] = self.hotel_rule_code
        if self.premium_economy_discount is not None:
            result['premium_economy_discount'] = self.premium_economy_discount
        if self.reserve_type is not None:
            result['reserve_type'] = self.reserve_type
        if self.train_rule_code is not None:
            result['train_rule_code'] = self.train_rule_code
        if self.train_seats is not None:
            result['train_seats'] = self.train_seats
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('business_discount') is not None:
            self.business_discount = m.get('business_discount')
        if m.get('economy_discount') is not None:
            self.economy_discount = m.get('economy_discount')
        if m.get('first_discount') is not None:
            self.first_discount = m.get('first_discount')
        if m.get('flight_cabins') is not None:
            self.flight_cabins = m.get('flight_cabins')
        if m.get('flight_intl_rule_code') is not None:
            self.flight_intl_rule_code = m.get('flight_intl_rule_code')
        if m.get('flight_rule_code') is not None:
            self.flight_rule_code = m.get('flight_rule_code')
        self.hotel_citys = []
        if m.get('hotel_citys') is not None:
            for k in m.get('hotel_citys'):
                temp_model = ApplyModifyRequestExternalTravelerStandardHotelCitys()
                self.hotel_citys.append(temp_model.from_map(k))
        self.hotel_intl_citys = []
        if m.get('hotel_intl_citys') is not None:
            for k in m.get('hotel_intl_citys'):
                temp_model = ApplyModifyRequestExternalTravelerStandardHotelIntlCitys()
                self.hotel_intl_citys.append(temp_model.from_map(k))
        if m.get('hotel_intl_rule_code') is not None:
            self.hotel_intl_rule_code = m.get('hotel_intl_rule_code')
        if m.get('hotel_rule_code') is not None:
            self.hotel_rule_code = m.get('hotel_rule_code')
        if m.get('premium_economy_discount') is not None:
            self.premium_economy_discount = m.get('premium_economy_discount')
        if m.get('reserve_type') is not None:
            self.reserve_type = m.get('reserve_type')
        if m.get('train_rule_code') is not None:
            self.train_rule_code = m.get('train_rule_code')
        if m.get('train_seats') is not None:
            self.train_seats = m.get('train_seats')
        return self


class ApplyModifyRequestHotelShare(TeaModel):
    def __init__(
        self,
        param: str = None,
        type: str = None,
    ):
        self.param = param
        self.type = type

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.param is not None:
            result['param'] = self.param
        if self.type is not None:
            result['type'] = self.type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('param') is not None:
            self.param = m.get('param')
        if m.get('type') is not None:
            self.type = m.get('type')
        return self


class ApplyModifyRequestItineraryListItineraryTravelStandard(TeaModel):
    def __init__(
        self,
        hotel_available_nights_per_day: int = None,
    ):
        self.hotel_available_nights_per_day = hotel_available_nights_per_day

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.hotel_available_nights_per_day is not None:
            result['hotel_available_nights_per_day'] = self.hotel_available_nights_per_day
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('hotel_available_nights_per_day') is not None:
            self.hotel_available_nights_per_day = m.get('hotel_available_nights_per_day')
        return self


class ApplyModifyRequestItineraryList(TeaModel):
    def __init__(
        self,
        arr_city: str = None,
        arr_city_code: str = None,
        arr_date: str = None,
        attribute: str = None,
        cost_center_id: int = None,
        dep_city: str = None,
        dep_city_code: str = None,
        dep_date: str = None,
        invoice_id: int = None,
        itinerary_id: str = None,
        itinerary_travel_standard: ApplyModifyRequestItineraryListItineraryTravelStandard = None,
        need_hotel: bool = None,
        need_traffic: bool = None,
        project_code: str = None,
        project_title: str = None,
        province_travel_city_adcodes: List[str] = None,
        third_part_invoice_id: str = None,
        thirdpart_cost_center_id: str = None,
        traffic_type: int = None,
        trip_way: int = None,
    ):
        # This parameter is required.
        self.arr_city = arr_city
        self.arr_city_code = arr_city_code
        # This parameter is required.
        self.arr_date = arr_date
        self.attribute = attribute
        self.cost_center_id = cost_center_id
        # This parameter is required.
        self.dep_city = dep_city
        self.dep_city_code = dep_city_code
        # This parameter is required.
        self.dep_date = dep_date
        self.invoice_id = invoice_id
        # This parameter is required.
        self.itinerary_id = itinerary_id
        self.itinerary_travel_standard = itinerary_travel_standard
        self.need_hotel = need_hotel
        self.need_traffic = need_traffic
        self.project_code = project_code
        self.project_title = project_title
        self.province_travel_city_adcodes = province_travel_city_adcodes
        self.third_part_invoice_id = third_part_invoice_id
        self.thirdpart_cost_center_id = thirdpart_cost_center_id
        # This parameter is required.
        self.traffic_type = traffic_type
        # This parameter is required.
        self.trip_way = trip_way

    def validate(self):
        if self.itinerary_travel_standard:
            self.itinerary_travel_standard.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.arr_city is not None:
            result['arr_city'] = self.arr_city
        if self.arr_city_code is not None:
            result['arr_city_code'] = self.arr_city_code
        if self.arr_date is not None:
            result['arr_date'] = self.arr_date
        if self.attribute is not None:
            result['attribute'] = self.attribute
        if self.cost_center_id is not None:
            result['cost_center_id'] = self.cost_center_id
        if self.dep_city is not None:
            result['dep_city'] = self.dep_city
        if self.dep_city_code is not None:
            result['dep_city_code'] = self.dep_city_code
        if self.dep_date is not None:
            result['dep_date'] = self.dep_date
        if self.invoice_id is not None:
            result['invoice_id'] = self.invoice_id
        if self.itinerary_id is not None:
            result['itinerary_id'] = self.itinerary_id
        if self.itinerary_travel_standard is not None:
            result['itinerary_travel_standard'] = self.itinerary_travel_standard.to_map()
        if self.need_hotel is not None:
            result['need_hotel'] = self.need_hotel
        if self.need_traffic is not None:
            result['need_traffic'] = self.need_traffic
        if self.project_code is not None:
            result['project_code'] = self.project_code
        if self.project_title is not None:
            result['project_title'] = self.project_title
        if self.province_travel_city_adcodes is not None:
            result['province_travel_city_adcodes'] = self.province_travel_city_adcodes
        if self.third_part_invoice_id is not None:
            result['third_part_invoice_id'] = self.third_part_invoice_id
        if self.thirdpart_cost_center_id is not None:
            result['thirdpart_cost_center_id'] = self.thirdpart_cost_center_id
        if self.traffic_type is not None:
            result['traffic_type'] = self.traffic_type
        if self.trip_way is not None:
            result['trip_way'] = self.trip_way
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('arr_city') is not None:
            self.arr_city = m.get('arr_city')
        if m.get('arr_city_code') is not None:
            self.arr_city_code = m.get('arr_city_code')
        if m.get('arr_date') is not None:
            self.arr_date = m.get('arr_date')
        if m.get('attribute') is not None:
            self.attribute = m.get('attribute')
        if m.get('cost_center_id') is not None:
            self.cost_center_id = m.get('cost_center_id')
        if m.get('dep_city') is not None:
            self.dep_city = m.get('dep_city')
        if m.get('dep_city_code') is not None:
            self.dep_city_code = m.get('dep_city_code')
        if m.get('dep_date') is not None:
            self.dep_date = m.get('dep_date')
        if m.get('invoice_id') is not None:
            self.invoice_id = m.get('invoice_id')
        if m.get('itinerary_id') is not None:
            self.itinerary_id = m.get('itinerary_id')
        if m.get('itinerary_travel_standard') is not None:
            temp_model = ApplyModifyRequestItineraryListItineraryTravelStandard()
            self.itinerary_travel_standard = temp_model.from_map(m['itinerary_travel_standard'])
        if m.get('need_hotel') is not None:
            self.need_hotel = m.get('need_hotel')
        if m.get('need_traffic') is not None:
            self.need_traffic = m.get('need_traffic')
        if m.get('project_code') is not None:
            self.project_code = m.get('project_code')
        if m.get('project_title') is not None:
            self.project_title = m.get('project_title')
        if m.get('province_travel_city_adcodes') is not None:
            self.province_travel_city_adcodes = m.get('province_travel_city_adcodes')
        if m.get('third_part_invoice_id') is not None:
            self.third_part_invoice_id = m.get('third_part_invoice_id')
        if m.get('thirdpart_cost_center_id') is not None:
            self.thirdpart_cost_center_id = m.get('thirdpart_cost_center_id')
        if m.get('traffic_type') is not None:
            self.traffic_type = m.get('traffic_type')
        if m.get('trip_way') is not None:
            self.trip_way = m.get('trip_way')
        return self


class ApplyModifyRequestItinerarySetListItineraryTravelStandard(TeaModel):
    def __init__(
        self,
        hotel_available_nights_per_day: int = None,
    ):
        self.hotel_available_nights_per_day = hotel_available_nights_per_day

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.hotel_available_nights_per_day is not None:
            result['hotel_available_nights_per_day'] = self.hotel_available_nights_per_day
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('hotel_available_nights_per_day') is not None:
            self.hotel_available_nights_per_day = m.get('hotel_available_nights_per_day')
        return self


class ApplyModifyRequestItinerarySetList(TeaModel):
    def __init__(
        self,
        arr_date: str = None,
        attribute: str = None,
        city_code_set: str = None,
        city_set: str = None,
        cost_center_id: int = None,
        dep_date: str = None,
        invoice_id: int = None,
        itinerary_id: str = None,
        itinerary_travel_standard: ApplyModifyRequestItinerarySetListItineraryTravelStandard = None,
        project_code: str = None,
        project_title: str = None,
        province_travel_city_adcodes: List[str] = None,
        third_part_invoice_id: str = None,
        thirdpart_cost_center_id: str = None,
        traffic_type: int = None,
    ):
        self.arr_date = arr_date
        self.attribute = attribute
        self.city_code_set = city_code_set
        self.city_set = city_set
        self.cost_center_id = cost_center_id
        self.dep_date = dep_date
        self.invoice_id = invoice_id
        self.itinerary_id = itinerary_id
        self.itinerary_travel_standard = itinerary_travel_standard
        self.project_code = project_code
        self.project_title = project_title
        self.province_travel_city_adcodes = province_travel_city_adcodes
        self.third_part_invoice_id = third_part_invoice_id
        self.thirdpart_cost_center_id = thirdpart_cost_center_id
        self.traffic_type = traffic_type

    def validate(self):
        if self.itinerary_travel_standard:
            self.itinerary_travel_standard.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.arr_date is not None:
            result['arr_date'] = self.arr_date
        if self.attribute is not None:
            result['attribute'] = self.attribute
        if self.city_code_set is not None:
            result['city_code_set'] = self.city_code_set
        if self.city_set is not None:
            result['city_set'] = self.city_set
        if self.cost_center_id is not None:
            result['cost_center_id'] = self.cost_center_id
        if self.dep_date is not None:
            result['dep_date'] = self.dep_date
        if self.invoice_id is not None:
            result['invoice_id'] = self.invoice_id
        if self.itinerary_id is not None:
            result['itinerary_id'] = self.itinerary_id
        if self.itinerary_travel_standard is not None:
            result['itinerary_travel_standard'] = self.itinerary_travel_standard.to_map()
        if self.project_code is not None:
            result['project_code'] = self.project_code
        if self.project_title is not None:
            result['project_title'] = self.project_title
        if self.province_travel_city_adcodes is not None:
            result['province_travel_city_adcodes'] = self.province_travel_city_adcodes
        if self.third_part_invoice_id is not None:
            result['third_part_invoice_id'] = self.third_part_invoice_id
        if self.thirdpart_cost_center_id is not None:
            result['thirdpart_cost_center_id'] = self.thirdpart_cost_center_id
        if self.traffic_type is not None:
            result['traffic_type'] = self.traffic_type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('arr_date') is not None:
            self.arr_date = m.get('arr_date')
        if m.get('attribute') is not None:
            self.attribute = m.get('attribute')
        if m.get('city_code_set') is not None:
            self.city_code_set = m.get('city_code_set')
        if m.get('city_set') is not None:
            self.city_set = m.get('city_set')
        if m.get('cost_center_id') is not None:
            self.cost_center_id = m.get('cost_center_id')
        if m.get('dep_date') is not None:
            self.dep_date = m.get('dep_date')
        if m.get('invoice_id') is not None:
            self.invoice_id = m.get('invoice_id')
        if m.get('itinerary_id') is not None:
            self.itinerary_id = m.get('itinerary_id')
        if m.get('itinerary_travel_standard') is not None:
            temp_model = ApplyModifyRequestItinerarySetListItineraryTravelStandard()
            self.itinerary_travel_standard = temp_model.from_map(m['itinerary_travel_standard'])
        if m.get('project_code') is not None:
            self.project_code = m.get('project_code')
        if m.get('project_title') is not None:
            self.project_title = m.get('project_title')
        if m.get('province_travel_city_adcodes') is not None:
            self.province_travel_city_adcodes = m.get('province_travel_city_adcodes')
        if m.get('third_part_invoice_id') is not None:
            self.third_part_invoice_id = m.get('third_part_invoice_id')
        if m.get('thirdpart_cost_center_id') is not None:
            self.thirdpart_cost_center_id = m.get('thirdpart_cost_center_id')
        if m.get('traffic_type') is not None:
            self.traffic_type = m.get('traffic_type')
        return self


class ApplyModifyRequestTravelerList(TeaModel):
    def __init__(
        self,
        attribute: str = None,
        cost_center_id: int = None,
        invoice_id: int = None,
        payment_department_id: str = None,
        payment_department_name: str = None,
        project_code: str = None,
        project_title: str = None,
        third_part_invoice_id: str = None,
        thirdpart_cost_center_id: str = None,
        thirdpart_depart_id: str = None,
        user_id: str = None,
        user_name: str = None,
    ):
        self.attribute = attribute
        self.cost_center_id = cost_center_id
        self.invoice_id = invoice_id
        self.payment_department_id = payment_department_id
        self.payment_department_name = payment_department_name
        self.project_code = project_code
        self.project_title = project_title
        self.third_part_invoice_id = third_part_invoice_id
        self.thirdpart_cost_center_id = thirdpart_cost_center_id
        self.thirdpart_depart_id = thirdpart_depart_id
        self.user_id = user_id
        self.user_name = user_name

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.attribute is not None:
            result['attribute'] = self.attribute
        if self.cost_center_id is not None:
            result['cost_center_id'] = self.cost_center_id
        if self.invoice_id is not None:
            result['invoice_id'] = self.invoice_id
        if self.payment_department_id is not None:
            result['payment_department_id'] = self.payment_department_id
        if self.payment_department_name is not None:
            result['payment_department_name'] = self.payment_department_name
        if self.project_code is not None:
            result['project_code'] = self.project_code
        if self.project_title is not None:
            result['project_title'] = self.project_title
        if self.third_part_invoice_id is not None:
            result['third_part_invoice_id'] = self.third_part_invoice_id
        if self.thirdpart_cost_center_id is not None:
            result['thirdpart_cost_center_id'] = self.thirdpart_cost_center_id
        if self.thirdpart_depart_id is not None:
            result['thirdpart_depart_id'] = self.thirdpart_depart_id
        if self.user_id is not None:
            result['user_id'] = self.user_id
        if self.user_name is not None:
            result['user_name'] = self.user_name
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('attribute') is not None:
            self.attribute = m.get('attribute')
        if m.get('cost_center_id') is not None:
            self.cost_center_id = m.get('cost_center_id')
        if m.get('invoice_id') is not None:
            self.invoice_id = m.get('invoice_id')
        if m.get('payment_department_id') is not None:
            self.payment_department_id = m.get('payment_department_id')
        if m.get('payment_department_name') is not None:
            self.payment_department_name = m.get('payment_department_name')
        if m.get('project_code') is not None:
            self.project_code = m.get('project_code')
        if m.get('project_title') is not None:
            self.project_title = m.get('project_title')
        if m.get('third_part_invoice_id') is not None:
            self.third_part_invoice_id = m.get('third_part_invoice_id')
        if m.get('thirdpart_cost_center_id') is not None:
            self.thirdpart_cost_center_id = m.get('thirdpart_cost_center_id')
        if m.get('thirdpart_depart_id') is not None:
            self.thirdpart_depart_id = m.get('thirdpart_depart_id')
        if m.get('user_id') is not None:
            self.user_id = m.get('user_id')
        if m.get('user_name') is not None:
            self.user_name = m.get('user_name')
        return self


class ApplyModifyRequestTravelerStandardCarCitySet(TeaModel):
    def __init__(
        self,
        city_code: str = None,
        city_name: str = None,
    ):
        # This parameter is required.
        self.city_code = city_code
        # This parameter is required.
        self.city_name = city_name

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.city_code is not None:
            result['city_code'] = self.city_code
        if self.city_name is not None:
            result['city_name'] = self.city_name
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('city_code') is not None:
            self.city_code = m.get('city_code')
        if m.get('city_name') is not None:
            self.city_name = m.get('city_name')
        return self


class ApplyModifyRequestTravelerStandardHotelCitys(TeaModel):
    def __init__(
        self,
        city_code: str = None,
        city_name: str = None,
        fee: int = None,
    ):
        self.city_code = city_code
        self.city_name = city_name
        self.fee = fee

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.city_code is not None:
            result['city_code'] = self.city_code
        if self.city_name is not None:
            result['city_name'] = self.city_name
        if self.fee is not None:
            result['fee'] = self.fee
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('city_code') is not None:
            self.city_code = m.get('city_code')
        if m.get('city_name') is not None:
            self.city_name = m.get('city_name')
        if m.get('fee') is not None:
            self.fee = m.get('fee')
        return self


class ApplyModifyRequestTravelerStandardHotelIntlCitys(TeaModel):
    def __init__(
        self,
        city_code: str = None,
        city_name: str = None,
        fee: int = None,
    ):
        self.city_code = city_code
        self.city_name = city_name
        self.fee = fee

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.city_code is not None:
            result['city_code'] = self.city_code
        if self.city_name is not None:
            result['city_name'] = self.city_name
        if self.fee is not None:
            result['fee'] = self.fee
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('city_code') is not None:
            self.city_code = m.get('city_code')
        if m.get('city_name') is not None:
            self.city_name = m.get('city_name')
        if m.get('fee') is not None:
            self.fee = m.get('fee')
        return self


class ApplyModifyRequestTravelerStandard(TeaModel):
    def __init__(
        self,
        business_discount: int = None,
        car_city_set: List[ApplyModifyRequestTravelerStandardCarCitySet] = None,
        economy_discount: int = None,
        first_discount: int = None,
        flight_cabins: str = None,
        flight_intl_rule_code: int = None,
        flight_rule_code: int = None,
        hotel_citys: List[ApplyModifyRequestTravelerStandardHotelCitys] = None,
        hotel_intl_citys: List[ApplyModifyRequestTravelerStandardHotelIntlCitys] = None,
        hotel_intl_rule_code: int = None,
        hotel_rule_code: int = None,
        premium_economy_discount: int = None,
        reserve_type: int = None,
        train_rule_code: int = None,
        train_seats: str = None,
        user_id: str = None,
    ):
        self.business_discount = business_discount
        self.car_city_set = car_city_set
        self.economy_discount = economy_discount
        self.first_discount = first_discount
        self.flight_cabins = flight_cabins
        self.flight_intl_rule_code = flight_intl_rule_code
        self.flight_rule_code = flight_rule_code
        self.hotel_citys = hotel_citys
        self.hotel_intl_citys = hotel_intl_citys
        self.hotel_intl_rule_code = hotel_intl_rule_code
        self.hotel_rule_code = hotel_rule_code
        # 超级经济舱折扣。1到10的整数
        self.premium_economy_discount = premium_economy_discount
        self.reserve_type = reserve_type
        self.train_rule_code = train_rule_code
        self.train_seats = train_seats
        self.user_id = user_id

    def validate(self):
        if self.car_city_set:
            for k in self.car_city_set:
                if k:
                    k.validate()
        if self.hotel_citys:
            for k in self.hotel_citys:
                if k:
                    k.validate()
        if self.hotel_intl_citys:
            for k in self.hotel_intl_citys:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.business_discount is not None:
            result['business_discount'] = self.business_discount
        result['car_city_set'] = []
        if self.car_city_set is not None:
            for k in self.car_city_set:
                result['car_city_set'].append(k.to_map() if k else None)
        if self.economy_discount is not None:
            result['economy_discount'] = self.economy_discount
        if self.first_discount is not None:
            result['first_discount'] = self.first_discount
        if self.flight_cabins is not None:
            result['flight_cabins'] = self.flight_cabins
        if self.flight_intl_rule_code is not None:
            result['flight_intl_rule_code'] = self.flight_intl_rule_code
        if self.flight_rule_code is not None:
            result['flight_rule_code'] = self.flight_rule_code
        result['hotel_citys'] = []
        if self.hotel_citys is not None:
            for k in self.hotel_citys:
                result['hotel_citys'].append(k.to_map() if k else None)
        result['hotel_intl_citys'] = []
        if self.hotel_intl_citys is not None:
            for k in self.hotel_intl_citys:
                result['hotel_intl_citys'].append(k.to_map() if k else None)
        if self.hotel_intl_rule_code is not None:
            result['hotel_intl_rule_code'] = self.hotel_intl_rule_code
        if self.hotel_rule_code is not None:
            result['hotel_rule_code'] = self.hotel_rule_code
        if self.premium_economy_discount is not None:
            result['premium_economy_discount'] = self.premium_economy_discount
        if self.reserve_type is not None:
            result['reserve_type'] = self.reserve_type
        if self.train_rule_code is not None:
            result['train_rule_code'] = self.train_rule_code
        if self.train_seats is not None:
            result['train_seats'] = self.train_seats
        if self.user_id is not None:
            result['user_id'] = self.user_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('business_discount') is not None:
            self.business_discount = m.get('business_discount')
        self.car_city_set = []
        if m.get('car_city_set') is not None:
            for k in m.get('car_city_set'):
                temp_model = ApplyModifyRequestTravelerStandardCarCitySet()
                self.car_city_set.append(temp_model.from_map(k))
        if m.get('economy_discount') is not None:
            self.economy_discount = m.get('economy_discount')
        if m.get('first_discount') is not None:
            self.first_discount = m.get('first_discount')
        if m.get('flight_cabins') is not None:
            self.flight_cabins = m.get('flight_cabins')
        if m.get('flight_intl_rule_code') is not None:
            self.flight_intl_rule_code = m.get('flight_intl_rule_code')
        if m.get('flight_rule_code') is not None:
            self.flight_rule_code = m.get('flight_rule_code')
        self.hotel_citys = []
        if m.get('hotel_citys') is not None:
            for k in m.get('hotel_citys'):
                temp_model = ApplyModifyRequestTravelerStandardHotelCitys()
                self.hotel_citys.append(temp_model.from_map(k))
        self.hotel_intl_citys = []
        if m.get('hotel_intl_citys') is not None:
            for k in m.get('hotel_intl_citys'):
                temp_model = ApplyModifyRequestTravelerStandardHotelIntlCitys()
                self.hotel_intl_citys.append(temp_model.from_map(k))
        if m.get('hotel_intl_rule_code') is not None:
            self.hotel_intl_rule_code = m.get('hotel_intl_rule_code')
        if m.get('hotel_rule_code') is not None:
            self.hotel_rule_code = m.get('hotel_rule_code')
        if m.get('premium_economy_discount') is not None:
            self.premium_economy_discount = m.get('premium_economy_discount')
        if m.get('reserve_type') is not None:
            self.reserve_type = m.get('reserve_type')
        if m.get('train_rule_code') is not None:
            self.train_rule_code = m.get('train_rule_code')
        if m.get('train_seats') is not None:
            self.train_seats = m.get('train_seats')
        if m.get('user_id') is not None:
            self.user_id = m.get('user_id')
        return self


class ApplyModifyRequest(TeaModel):
    def __init__(
        self,
        budget: int = None,
        budget_merge: int = None,
        car_rule: ApplyModifyRequestCarRule = None,
        corp_name: str = None,
        default_standard: ApplyModifyRequestDefaultStandard = None,
        depart_id: str = None,
        depart_name: str = None,
        extend_field: str = None,
        external_traveler_list: List[ApplyModifyRequestExternalTravelerList] = None,
        external_traveler_standard: ApplyModifyRequestExternalTravelerStandard = None,
        flight_budget: int = None,
        hotel_budget: int = None,
        hotel_share: ApplyModifyRequestHotelShare = None,
        intl_flight_budget: int = None,
        intl_hotel_budget: int = None,
        itinerary_list: List[ApplyModifyRequestItineraryList] = None,
        itinerary_rule: int = None,
        itinerary_set_list: List[ApplyModifyRequestItinerarySetList] = None,
        limit_traveler: int = None,
        meal_budget: int = None,
        payment_department_id: str = None,
        payment_department_name: str = None,
        status: int = None,
        sub_corp_id: str = None,
        thirdpart_apply_id: str = None,
        thirdpart_business_id: str = None,
        thirdpart_depart_id: str = None,
        together_book_rule: int = None,
        train_budget: int = None,
        traveler_list: List[ApplyModifyRequestTravelerList] = None,
        traveler_standard: List[ApplyModifyRequestTravelerStandard] = None,
        trip_cause: str = None,
        trip_day: int = None,
        trip_title: str = None,
        union_no: str = None,
        user_id: str = None,
        user_name: str = None,
        vehicle_budget: int = None,
    ):
        self.budget = budget
        self.budget_merge = budget_merge
        self.car_rule = car_rule
        self.corp_name = corp_name
        self.default_standard = default_standard
        self.depart_id = depart_id
        self.depart_name = depart_name
        # 可将补充描述传入此字段，账单中将会体现此字段的值。可以用于企业的统计和对账
        self.extend_field = extend_field
        self.external_traveler_list = external_traveler_list
        self.external_traveler_standard = external_traveler_standard
        self.flight_budget = flight_budget
        self.hotel_budget = hotel_budget
        self.hotel_share = hotel_share
        self.intl_flight_budget = intl_flight_budget
        self.intl_hotel_budget = intl_hotel_budget
        self.itinerary_list = itinerary_list
        self.itinerary_rule = itinerary_rule
        self.itinerary_set_list = itinerary_set_list
        self.limit_traveler = limit_traveler
        self.meal_budget = meal_budget
        self.payment_department_id = payment_department_id
        self.payment_department_name = payment_department_name
        self.status = status
        # 子企业Id
        self.sub_corp_id = sub_corp_id
        # This parameter is required.
        self.thirdpart_apply_id = thirdpart_apply_id
        self.thirdpart_business_id = thirdpart_business_id
        self.thirdpart_depart_id = thirdpart_depart_id
        self.together_book_rule = together_book_rule
        self.train_budget = train_budget
        self.traveler_list = traveler_list
        self.traveler_standard = traveler_standard
        # This parameter is required.
        self.trip_cause = trip_cause
        self.trip_day = trip_day
        # This parameter is required.
        self.trip_title = trip_title
        self.union_no = union_no
        # This parameter is required.
        self.user_id = user_id
        self.user_name = user_name
        self.vehicle_budget = vehicle_budget

    def validate(self):
        if self.car_rule:
            self.car_rule.validate()
        if self.default_standard:
            self.default_standard.validate()
        if self.external_traveler_list:
            for k in self.external_traveler_list:
                if k:
                    k.validate()
        if self.external_traveler_standard:
            self.external_traveler_standard.validate()
        if self.hotel_share:
            self.hotel_share.validate()
        if self.itinerary_list:
            for k in self.itinerary_list:
                if k:
                    k.validate()
        if self.itinerary_set_list:
            for k in self.itinerary_set_list:
                if k:
                    k.validate()
        if self.traveler_list:
            for k in self.traveler_list:
                if k:
                    k.validate()
        if self.traveler_standard:
            for k in self.traveler_standard:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.budget is not None:
            result['budget'] = self.budget
        if self.budget_merge is not None:
            result['budget_merge'] = self.budget_merge
        if self.car_rule is not None:
            result['car_rule'] = self.car_rule.to_map()
        if self.corp_name is not None:
            result['corp_name'] = self.corp_name
        if self.default_standard is not None:
            result['default_standard'] = self.default_standard.to_map()
        if self.depart_id is not None:
            result['depart_id'] = self.depart_id
        if self.depart_name is not None:
            result['depart_name'] = self.depart_name
        if self.extend_field is not None:
            result['extend_field'] = self.extend_field
        result['external_traveler_list'] = []
        if self.external_traveler_list is not None:
            for k in self.external_traveler_list:
                result['external_traveler_list'].append(k.to_map() if k else None)
        if self.external_traveler_standard is not None:
            result['external_traveler_standard'] = self.external_traveler_standard.to_map()
        if self.flight_budget is not None:
            result['flight_budget'] = self.flight_budget
        if self.hotel_budget is not None:
            result['hotel_budget'] = self.hotel_budget
        if self.hotel_share is not None:
            result['hotel_share'] = self.hotel_share.to_map()
        if self.intl_flight_budget is not None:
            result['intl_flight_budget'] = self.intl_flight_budget
        if self.intl_hotel_budget is not None:
            result['intl_hotel_budget'] = self.intl_hotel_budget
        result['itinerary_list'] = []
        if self.itinerary_list is not None:
            for k in self.itinerary_list:
                result['itinerary_list'].append(k.to_map() if k else None)
        if self.itinerary_rule is not None:
            result['itinerary_rule'] = self.itinerary_rule
        result['itinerary_set_list'] = []
        if self.itinerary_set_list is not None:
            for k in self.itinerary_set_list:
                result['itinerary_set_list'].append(k.to_map() if k else None)
        if self.limit_traveler is not None:
            result['limit_traveler'] = self.limit_traveler
        if self.meal_budget is not None:
            result['meal_budget'] = self.meal_budget
        if self.payment_department_id is not None:
            result['payment_department_id'] = self.payment_department_id
        if self.payment_department_name is not None:
            result['payment_department_name'] = self.payment_department_name
        if self.status is not None:
            result['status'] = self.status
        if self.sub_corp_id is not None:
            result['sub_corp_id'] = self.sub_corp_id
        if self.thirdpart_apply_id is not None:
            result['thirdpart_apply_id'] = self.thirdpart_apply_id
        if self.thirdpart_business_id is not None:
            result['thirdpart_business_id'] = self.thirdpart_business_id
        if self.thirdpart_depart_id is not None:
            result['thirdpart_depart_id'] = self.thirdpart_depart_id
        if self.together_book_rule is not None:
            result['together_book_rule'] = self.together_book_rule
        if self.train_budget is not None:
            result['train_budget'] = self.train_budget
        result['traveler_list'] = []
        if self.traveler_list is not None:
            for k in self.traveler_list:
                result['traveler_list'].append(k.to_map() if k else None)
        result['traveler_standard'] = []
        if self.traveler_standard is not None:
            for k in self.traveler_standard:
                result['traveler_standard'].append(k.to_map() if k else None)
        if self.trip_cause is not None:
            result['trip_cause'] = self.trip_cause
        if self.trip_day is not None:
            result['trip_day'] = self.trip_day
        if self.trip_title is not None:
            result['trip_title'] = self.trip_title
        if self.union_no is not None:
            result['union_no'] = self.union_no
        if self.user_id is not None:
            result['user_id'] = self.user_id
        if self.user_name is not None:
            result['user_name'] = self.user_name
        if self.vehicle_budget is not None:
            result['vehicle_budget'] = self.vehicle_budget
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('budget') is not None:
            self.budget = m.get('budget')
        if m.get('budget_merge') is not None:
            self.budget_merge = m.get('budget_merge')
        if m.get('car_rule') is not None:
            temp_model = ApplyModifyRequestCarRule()
            self.car_rule = temp_model.from_map(m['car_rule'])
        if m.get('corp_name') is not None:
            self.corp_name = m.get('corp_name')
        if m.get('default_standard') is not None:
            temp_model = ApplyModifyRequestDefaultStandard()
            self.default_standard = temp_model.from_map(m['default_standard'])
        if m.get('depart_id') is not None:
            self.depart_id = m.get('depart_id')
        if m.get('depart_name') is not None:
            self.depart_name = m.get('depart_name')
        if m.get('extend_field') is not None:
            self.extend_field = m.get('extend_field')
        self.external_traveler_list = []
        if m.get('external_traveler_list') is not None:
            for k in m.get('external_traveler_list'):
                temp_model = ApplyModifyRequestExternalTravelerList()
                self.external_traveler_list.append(temp_model.from_map(k))
        if m.get('external_traveler_standard') is not None:
            temp_model = ApplyModifyRequestExternalTravelerStandard()
            self.external_traveler_standard = temp_model.from_map(m['external_traveler_standard'])
        if m.get('flight_budget') is not None:
            self.flight_budget = m.get('flight_budget')
        if m.get('hotel_budget') is not None:
            self.hotel_budget = m.get('hotel_budget')
        if m.get('hotel_share') is not None:
            temp_model = ApplyModifyRequestHotelShare()
            self.hotel_share = temp_model.from_map(m['hotel_share'])
        if m.get('intl_flight_budget') is not None:
            self.intl_flight_budget = m.get('intl_flight_budget')
        if m.get('intl_hotel_budget') is not None:
            self.intl_hotel_budget = m.get('intl_hotel_budget')
        self.itinerary_list = []
        if m.get('itinerary_list') is not None:
            for k in m.get('itinerary_list'):
                temp_model = ApplyModifyRequestItineraryList()
                self.itinerary_list.append(temp_model.from_map(k))
        if m.get('itinerary_rule') is not None:
            self.itinerary_rule = m.get('itinerary_rule')
        self.itinerary_set_list = []
        if m.get('itinerary_set_list') is not None:
            for k in m.get('itinerary_set_list'):
                temp_model = ApplyModifyRequestItinerarySetList()
                self.itinerary_set_list.append(temp_model.from_map(k))
        if m.get('limit_traveler') is not None:
            self.limit_traveler = m.get('limit_traveler')
        if m.get('meal_budget') is not None:
            self.meal_budget = m.get('meal_budget')
        if m.get('payment_department_id') is not None:
            self.payment_department_id = m.get('payment_department_id')
        if m.get('payment_department_name') is not None:
            self.payment_department_name = m.get('payment_department_name')
        if m.get('status') is not None:
            self.status = m.get('status')
        if m.get('sub_corp_id') is not None:
            self.sub_corp_id = m.get('sub_corp_id')
        if m.get('thirdpart_apply_id') is not None:
            self.thirdpart_apply_id = m.get('thirdpart_apply_id')
        if m.get('thirdpart_business_id') is not None:
            self.thirdpart_business_id = m.get('thirdpart_business_id')
        if m.get('thirdpart_depart_id') is not None:
            self.thirdpart_depart_id = m.get('thirdpart_depart_id')
        if m.get('together_book_rule') is not None:
            self.together_book_rule = m.get('together_book_rule')
        if m.get('train_budget') is not None:
            self.train_budget = m.get('train_budget')
        self.traveler_list = []
        if m.get('traveler_list') is not None:
            for k in m.get('traveler_list'):
                temp_model = ApplyModifyRequestTravelerList()
                self.traveler_list.append(temp_model.from_map(k))
        self.traveler_standard = []
        if m.get('traveler_standard') is not None:
            for k in m.get('traveler_standard'):
                temp_model = ApplyModifyRequestTravelerStandard()
                self.traveler_standard.append(temp_model.from_map(k))
        if m.get('trip_cause') is not None:
            self.trip_cause = m.get('trip_cause')
        if m.get('trip_day') is not None:
            self.trip_day = m.get('trip_day')
        if m.get('trip_title') is not None:
            self.trip_title = m.get('trip_title')
        if m.get('union_no') is not None:
            self.union_no = m.get('union_no')
        if m.get('user_id') is not None:
            self.user_id = m.get('user_id')
        if m.get('user_name') is not None:
            self.user_name = m.get('user_name')
        if m.get('vehicle_budget') is not None:
            self.vehicle_budget = m.get('vehicle_budget')
        return self


class ApplyModifyShrinkRequest(TeaModel):
    def __init__(
        self,
        budget: int = None,
        budget_merge: int = None,
        car_rule_shrink: str = None,
        corp_name: str = None,
        default_standard_shrink: str = None,
        depart_id: str = None,
        depart_name: str = None,
        extend_field: str = None,
        external_traveler_list_shrink: str = None,
        external_traveler_standard_shrink: str = None,
        flight_budget: int = None,
        hotel_budget: int = None,
        hotel_share_shrink: str = None,
        intl_flight_budget: int = None,
        intl_hotel_budget: int = None,
        itinerary_list_shrink: str = None,
        itinerary_rule: int = None,
        itinerary_set_list_shrink: str = None,
        limit_traveler: int = None,
        meal_budget: int = None,
        payment_department_id: str = None,
        payment_department_name: str = None,
        status: int = None,
        sub_corp_id: str = None,
        thirdpart_apply_id: str = None,
        thirdpart_business_id: str = None,
        thirdpart_depart_id: str = None,
        together_book_rule: int = None,
        train_budget: int = None,
        traveler_list_shrink: str = None,
        traveler_standard_shrink: str = None,
        trip_cause: str = None,
        trip_day: int = None,
        trip_title: str = None,
        union_no: str = None,
        user_id: str = None,
        user_name: str = None,
        vehicle_budget: int = None,
    ):
        self.budget = budget
        self.budget_merge = budget_merge
        self.car_rule_shrink = car_rule_shrink
        self.corp_name = corp_name
        self.default_standard_shrink = default_standard_shrink
        self.depart_id = depart_id
        self.depart_name = depart_name
        # 可将补充描述传入此字段，账单中将会体现此字段的值。可以用于企业的统计和对账
        self.extend_field = extend_field
        self.external_traveler_list_shrink = external_traveler_list_shrink
        self.external_traveler_standard_shrink = external_traveler_standard_shrink
        self.flight_budget = flight_budget
        self.hotel_budget = hotel_budget
        self.hotel_share_shrink = hotel_share_shrink
        self.intl_flight_budget = intl_flight_budget
        self.intl_hotel_budget = intl_hotel_budget
        self.itinerary_list_shrink = itinerary_list_shrink
        self.itinerary_rule = itinerary_rule
        self.itinerary_set_list_shrink = itinerary_set_list_shrink
        self.limit_traveler = limit_traveler
        self.meal_budget = meal_budget
        self.payment_department_id = payment_department_id
        self.payment_department_name = payment_department_name
        self.status = status
        # 子企业Id
        self.sub_corp_id = sub_corp_id
        # This parameter is required.
        self.thirdpart_apply_id = thirdpart_apply_id
        self.thirdpart_business_id = thirdpart_business_id
        self.thirdpart_depart_id = thirdpart_depart_id
        self.together_book_rule = together_book_rule
        self.train_budget = train_budget
        self.traveler_list_shrink = traveler_list_shrink
        self.traveler_standard_shrink = traveler_standard_shrink
        # This parameter is required.
        self.trip_cause = trip_cause
        self.trip_day = trip_day
        # This parameter is required.
        self.trip_title = trip_title
        self.union_no = union_no
        # This parameter is required.
        self.user_id = user_id
        self.user_name = user_name
        self.vehicle_budget = vehicle_budget

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.budget is not None:
            result['budget'] = self.budget
        if self.budget_merge is not None:
            result['budget_merge'] = self.budget_merge
        if self.car_rule_shrink is not None:
            result['car_rule'] = self.car_rule_shrink
        if self.corp_name is not None:
            result['corp_name'] = self.corp_name
        if self.default_standard_shrink is not None:
            result['default_standard'] = self.default_standard_shrink
        if self.depart_id is not None:
            result['depart_id'] = self.depart_id
        if self.depart_name is not None:
            result['depart_name'] = self.depart_name
        if self.extend_field is not None:
            result['extend_field'] = self.extend_field
        if self.external_traveler_list_shrink is not None:
            result['external_traveler_list'] = self.external_traveler_list_shrink
        if self.external_traveler_standard_shrink is not None:
            result['external_traveler_standard'] = self.external_traveler_standard_shrink
        if self.flight_budget is not None:
            result['flight_budget'] = self.flight_budget
        if self.hotel_budget is not None:
            result['hotel_budget'] = self.hotel_budget
        if self.hotel_share_shrink is not None:
            result['hotel_share'] = self.hotel_share_shrink
        if self.intl_flight_budget is not None:
            result['intl_flight_budget'] = self.intl_flight_budget
        if self.intl_hotel_budget is not None:
            result['intl_hotel_budget'] = self.intl_hotel_budget
        if self.itinerary_list_shrink is not None:
            result['itinerary_list'] = self.itinerary_list_shrink
        if self.itinerary_rule is not None:
            result['itinerary_rule'] = self.itinerary_rule
        if self.itinerary_set_list_shrink is not None:
            result['itinerary_set_list'] = self.itinerary_set_list_shrink
        if self.limit_traveler is not None:
            result['limit_traveler'] = self.limit_traveler
        if self.meal_budget is not None:
            result['meal_budget'] = self.meal_budget
        if self.payment_department_id is not None:
            result['payment_department_id'] = self.payment_department_id
        if self.payment_department_name is not None:
            result['payment_department_name'] = self.payment_department_name
        if self.status is not None:
            result['status'] = self.status
        if self.sub_corp_id is not None:
            result['sub_corp_id'] = self.sub_corp_id
        if self.thirdpart_apply_id is not None:
            result['thirdpart_apply_id'] = self.thirdpart_apply_id
        if self.thirdpart_business_id is not None:
            result['thirdpart_business_id'] = self.thirdpart_business_id
        if self.thirdpart_depart_id is not None:
            result['thirdpart_depart_id'] = self.thirdpart_depart_id
        if self.together_book_rule is not None:
            result['together_book_rule'] = self.together_book_rule
        if self.train_budget is not None:
            result['train_budget'] = self.train_budget
        if self.traveler_list_shrink is not None:
            result['traveler_list'] = self.traveler_list_shrink
        if self.traveler_standard_shrink is not None:
            result['traveler_standard'] = self.traveler_standard_shrink
        if self.trip_cause is not None:
            result['trip_cause'] = self.trip_cause
        if self.trip_day is not None:
            result['trip_day'] = self.trip_day
        if self.trip_title is not None:
            result['trip_title'] = self.trip_title
        if self.union_no is not None:
            result['union_no'] = self.union_no
        if self.user_id is not None:
            result['user_id'] = self.user_id
        if self.user_name is not None:
            result['user_name'] = self.user_name
        if self.vehicle_budget is not None:
            result['vehicle_budget'] = self.vehicle_budget
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('budget') is not None:
            self.budget = m.get('budget')
        if m.get('budget_merge') is not None:
            self.budget_merge = m.get('budget_merge')
        if m.get('car_rule') is not None:
            self.car_rule_shrink = m.get('car_rule')
        if m.get('corp_name') is not None:
            self.corp_name = m.get('corp_name')
        if m.get('default_standard') is not None:
            self.default_standard_shrink = m.get('default_standard')
        if m.get('depart_id') is not None:
            self.depart_id = m.get('depart_id')
        if m.get('depart_name') is not None:
            self.depart_name = m.get('depart_name')
        if m.get('extend_field') is not None:
            self.extend_field = m.get('extend_field')
        if m.get('external_traveler_list') is not None:
            self.external_traveler_list_shrink = m.get('external_traveler_list')
        if m.get('external_traveler_standard') is not None:
            self.external_traveler_standard_shrink = m.get('external_traveler_standard')
        if m.get('flight_budget') is not None:
            self.flight_budget = m.get('flight_budget')
        if m.get('hotel_budget') is not None:
            self.hotel_budget = m.get('hotel_budget')
        if m.get('hotel_share') is not None:
            self.hotel_share_shrink = m.get('hotel_share')
        if m.get('intl_flight_budget') is not None:
            self.intl_flight_budget = m.get('intl_flight_budget')
        if m.get('intl_hotel_budget') is not None:
            self.intl_hotel_budget = m.get('intl_hotel_budget')
        if m.get('itinerary_list') is not None:
            self.itinerary_list_shrink = m.get('itinerary_list')
        if m.get('itinerary_rule') is not None:
            self.itinerary_rule = m.get('itinerary_rule')
        if m.get('itinerary_set_list') is not None:
            self.itinerary_set_list_shrink = m.get('itinerary_set_list')
        if m.get('limit_traveler') is not None:
            self.limit_traveler = m.get('limit_traveler')
        if m.get('meal_budget') is not None:
            self.meal_budget = m.get('meal_budget')
        if m.get('payment_department_id') is not None:
            self.payment_department_id = m.get('payment_department_id')
        if m.get('payment_department_name') is not None:
            self.payment_department_name = m.get('payment_department_name')
        if m.get('status') is not None:
            self.status = m.get('status')
        if m.get('sub_corp_id') is not None:
            self.sub_corp_id = m.get('sub_corp_id')
        if m.get('thirdpart_apply_id') is not None:
            self.thirdpart_apply_id = m.get('thirdpart_apply_id')
        if m.get('thirdpart_business_id') is not None:
            self.thirdpart_business_id = m.get('thirdpart_business_id')
        if m.get('thirdpart_depart_id') is not None:
            self.thirdpart_depart_id = m.get('thirdpart_depart_id')
        if m.get('together_book_rule') is not None:
            self.together_book_rule = m.get('together_book_rule')
        if m.get('train_budget') is not None:
            self.train_budget = m.get('train_budget')
        if m.get('traveler_list') is not None:
            self.traveler_list_shrink = m.get('traveler_list')
        if m.get('traveler_standard') is not None:
            self.traveler_standard_shrink = m.get('traveler_standard')
        if m.get('trip_cause') is not None:
            self.trip_cause = m.get('trip_cause')
        if m.get('trip_day') is not None:
            self.trip_day = m.get('trip_day')
        if m.get('trip_title') is not None:
            self.trip_title = m.get('trip_title')
        if m.get('union_no') is not None:
            self.union_no = m.get('union_no')
        if m.get('user_id') is not None:
            self.user_id = m.get('user_id')
        if m.get('user_name') is not None:
            self.user_name = m.get('user_name')
        if m.get('vehicle_budget') is not None:
            self.vehicle_budget = m.get('vehicle_budget')
        return self


class ApplyModifyResponseBodyModule(TeaModel):
    def __init__(
        self,
        apply_id: int = None,
        thirdpart_apply_id: str = None,
        thirdpart_business_id: str = None,
    ):
        self.apply_id = apply_id
        self.thirdpart_apply_id = thirdpart_apply_id
        self.thirdpart_business_id = thirdpart_business_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.apply_id is not None:
            result['apply_id'] = self.apply_id
        if self.thirdpart_apply_id is not None:
            result['thirdpart_apply_id'] = self.thirdpart_apply_id
        if self.thirdpart_business_id is not None:
            result['thirdpart_business_id'] = self.thirdpart_business_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('apply_id') is not None:
            self.apply_id = m.get('apply_id')
        if m.get('thirdpart_apply_id') is not None:
            self.thirdpart_apply_id = m.get('thirdpart_apply_id')
        if m.get('thirdpart_business_id') is not None:
            self.thirdpart_business_id = m.get('thirdpart_business_id')
        return self


class ApplyModifyResponseBody(TeaModel):
    def __init__(
        self,
        code: str = None,
        message: str = None,
        module: ApplyModifyResponseBodyModule = None,
        request_id: str = None,
        success: bool = None,
        trace_id: str = None,
    ):
        self.code = code
        self.message = message
        # module。
        self.module = module
        self.request_id = request_id
        self.success = success
        self.trace_id = trace_id

    def validate(self):
        if self.module:
            self.module.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['code'] = self.code
        if self.message is not None:
            result['message'] = self.message
        if self.module is not None:
            result['module'] = self.module.to_map()
        if self.request_id is not None:
            result['requestId'] = self.request_id
        if self.success is not None:
            result['success'] = self.success
        if self.trace_id is not None:
            result['traceId'] = self.trace_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('code') is not None:
            self.code = m.get('code')
        if m.get('message') is not None:
            self.message = m.get('message')
        if m.get('module') is not None:
            temp_model = ApplyModifyResponseBodyModule()
            self.module = temp_model.from_map(m['module'])
        if m.get('requestId') is not None:
            self.request_id = m.get('requestId')
        if m.get('success') is not None:
            self.success = m.get('success')
        if m.get('traceId') is not None:
            self.trace_id = m.get('traceId')
        return self


class ApplyModifyResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: ApplyModifyResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = ApplyModifyResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class ApplyQueryHeaders(TeaModel):
    def __init__(
        self,
        common_headers: Dict[str, str] = None,
        x_acs_btrip_so_corp_token: str = None,
    ):
        self.common_headers = common_headers
        self.x_acs_btrip_so_corp_token = x_acs_btrip_so_corp_token

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.common_headers is not None:
            result['commonHeaders'] = self.common_headers
        if self.x_acs_btrip_so_corp_token is not None:
            result['x-acs-btrip-so-corp-token'] = self.x_acs_btrip_so_corp_token
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('commonHeaders') is not None:
            self.common_headers = m.get('commonHeaders')
        if m.get('x-acs-btrip-so-corp-token') is not None:
            self.x_acs_btrip_so_corp_token = m.get('x-acs-btrip-so-corp-token')
        return self


class ApplyQueryRequest(TeaModel):
    def __init__(
        self,
        apply_id: int = None,
        apply_show_id: str = None,
        sub_corp_id: str = None,
        thirdpart_apply_id: str = None,
        type: int = None,
    ):
        self.apply_id = apply_id
        self.apply_show_id = apply_show_id
        self.sub_corp_id = sub_corp_id
        self.thirdpart_apply_id = thirdpart_apply_id
        self.type = type

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.apply_id is not None:
            result['apply_id'] = self.apply_id
        if self.apply_show_id is not None:
            result['apply_show_id'] = self.apply_show_id
        if self.sub_corp_id is not None:
            result['sub_corp_id'] = self.sub_corp_id
        if self.thirdpart_apply_id is not None:
            result['thirdpart_apply_id'] = self.thirdpart_apply_id
        if self.type is not None:
            result['type'] = self.type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('apply_id') is not None:
            self.apply_id = m.get('apply_id')
        if m.get('apply_show_id') is not None:
            self.apply_show_id = m.get('apply_show_id')
        if m.get('sub_corp_id') is not None:
            self.sub_corp_id = m.get('sub_corp_id')
        if m.get('thirdpart_apply_id') is not None:
            self.thirdpart_apply_id = m.get('thirdpart_apply_id')
        if m.get('type') is not None:
            self.type = m.get('type')
        return self


class ApplyQueryResponseBodyModuleApproverList(TeaModel):
    def __init__(
        self,
        note: str = None,
        operate_time: str = None,
        order: int = None,
        status: int = None,
        status_desc: str = None,
        user_id: str = None,
        user_name: str = None,
    ):
        self.note = note
        self.operate_time = operate_time
        self.order = order
        self.status = status
        self.status_desc = status_desc
        self.user_id = user_id
        self.user_name = user_name

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.note is not None:
            result['note'] = self.note
        if self.operate_time is not None:
            result['operate_time'] = self.operate_time
        if self.order is not None:
            result['order'] = self.order
        if self.status is not None:
            result['status'] = self.status
        if self.status_desc is not None:
            result['status_desc'] = self.status_desc
        if self.user_id is not None:
            result['user_id'] = self.user_id
        if self.user_name is not None:
            result['user_name'] = self.user_name
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('note') is not None:
            self.note = m.get('note')
        if m.get('operate_time') is not None:
            self.operate_time = m.get('operate_time')
        if m.get('order') is not None:
            self.order = m.get('order')
        if m.get('status') is not None:
            self.status = m.get('status')
        if m.get('status_desc') is not None:
            self.status_desc = m.get('status_desc')
        if m.get('user_id') is not None:
            self.user_id = m.get('user_id')
        if m.get('user_name') is not None:
            self.user_name = m.get('user_name')
        return self


class ApplyQueryResponseBodyModuleCarRule(TeaModel):
    def __init__(
        self,
        scenario_template_id: str = None,
        scenario_template_name: str = None,
    ):
        self.scenario_template_id = scenario_template_id
        self.scenario_template_name = scenario_template_name

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.scenario_template_id is not None:
            result['scenario_template_id'] = self.scenario_template_id
        if self.scenario_template_name is not None:
            result['scenario_template_name'] = self.scenario_template_name
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('scenario_template_id') is not None:
            self.scenario_template_id = m.get('scenario_template_id')
        if m.get('scenario_template_name') is not None:
            self.scenario_template_name = m.get('scenario_template_name')
        return self


class ApplyQueryResponseBodyModuleExternalTravelerListHotelCitys(TeaModel):
    def __init__(
        self,
        city_code: str = None,
        city_name: str = None,
        fee: int = None,
    ):
        self.city_code = city_code
        self.city_name = city_name
        self.fee = fee

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.city_code is not None:
            result['city_code'] = self.city_code
        if self.city_name is not None:
            result['city_name'] = self.city_name
        if self.fee is not None:
            result['fee'] = self.fee
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('city_code') is not None:
            self.city_code = m.get('city_code')
        if m.get('city_name') is not None:
            self.city_name = m.get('city_name')
        if m.get('fee') is not None:
            self.fee = m.get('fee')
        return self


class ApplyQueryResponseBodyModuleExternalTravelerListHotelIntlCitys(TeaModel):
    def __init__(
        self,
        city_code: str = None,
        city_name: str = None,
        fee: int = None,
    ):
        self.city_code = city_code
        self.city_name = city_name
        self.fee = fee

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.city_code is not None:
            result['city_code'] = self.city_code
        if self.city_name is not None:
            result['city_name'] = self.city_name
        if self.fee is not None:
            result['fee'] = self.fee
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('city_code') is not None:
            self.city_code = m.get('city_code')
        if m.get('city_name') is not None:
            self.city_name = m.get('city_name')
        if m.get('fee') is not None:
            self.fee = m.get('fee')
        return self


class ApplyQueryResponseBodyModuleExternalTravelerList(TeaModel):
    def __init__(
        self,
        attribute: str = None,
        business_discount: int = None,
        cost_center_name: str = None,
        depart_id: str = None,
        economy_discount: int = None,
        external_user_id: str = None,
        first_discount: int = None,
        flight_cabins: str = None,
        flight_intl_rule_code: int = None,
        flight_rule_code: int = None,
        hotel_citys: List[ApplyQueryResponseBodyModuleExternalTravelerListHotelCitys] = None,
        hotel_intl_citys: List[ApplyQueryResponseBodyModuleExternalTravelerListHotelIntlCitys] = None,
        hotel_intl_rule_code: int = None,
        hotel_rule_code: int = None,
        invoice_name: str = None,
        payment_department_id: str = None,
        payment_department_name: str = None,
        premium_economy_discount: int = None,
        project_code: str = None,
        project_title: str = None,
        reserve_type: int = None,
        third_part_invoice_id: str = None,
        thirdpart_cost_center_id: str = None,
        thirdpart_depart_id: str = None,
        train_rule_code: int = None,
        train_seats: str = None,
        user_name: str = None,
    ):
        self.attribute = attribute
        self.business_discount = business_discount
        self.cost_center_name = cost_center_name
        self.depart_id = depart_id
        self.economy_discount = economy_discount
        self.external_user_id = external_user_id
        self.first_discount = first_discount
        self.flight_cabins = flight_cabins
        self.flight_intl_rule_code = flight_intl_rule_code
        self.flight_rule_code = flight_rule_code
        self.hotel_citys = hotel_citys
        self.hotel_intl_citys = hotel_intl_citys
        self.hotel_intl_rule_code = hotel_intl_rule_code
        self.hotel_rule_code = hotel_rule_code
        self.invoice_name = invoice_name
        self.payment_department_id = payment_department_id
        self.payment_department_name = payment_department_name
        self.premium_economy_discount = premium_economy_discount
        self.project_code = project_code
        self.project_title = project_title
        self.reserve_type = reserve_type
        self.third_part_invoice_id = third_part_invoice_id
        self.thirdpart_cost_center_id = thirdpart_cost_center_id
        self.thirdpart_depart_id = thirdpart_depart_id
        self.train_rule_code = train_rule_code
        self.train_seats = train_seats
        self.user_name = user_name

    def validate(self):
        if self.hotel_citys:
            for k in self.hotel_citys:
                if k:
                    k.validate()
        if self.hotel_intl_citys:
            for k in self.hotel_intl_citys:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.attribute is not None:
            result['attribute'] = self.attribute
        if self.business_discount is not None:
            result['business_discount'] = self.business_discount
        if self.cost_center_name is not None:
            result['cost_center_name'] = self.cost_center_name
        if self.depart_id is not None:
            result['depart_id'] = self.depart_id
        if self.economy_discount is not None:
            result['economy_discount'] = self.economy_discount
        if self.external_user_id is not None:
            result['external_user_id'] = self.external_user_id
        if self.first_discount is not None:
            result['first_discount'] = self.first_discount
        if self.flight_cabins is not None:
            result['flight_cabins'] = self.flight_cabins
        if self.flight_intl_rule_code is not None:
            result['flight_intl_rule_code'] = self.flight_intl_rule_code
        if self.flight_rule_code is not None:
            result['flight_rule_code'] = self.flight_rule_code
        result['hotel_citys'] = []
        if self.hotel_citys is not None:
            for k in self.hotel_citys:
                result['hotel_citys'].append(k.to_map() if k else None)
        result['hotel_intl_citys'] = []
        if self.hotel_intl_citys is not None:
            for k in self.hotel_intl_citys:
                result['hotel_intl_citys'].append(k.to_map() if k else None)
        if self.hotel_intl_rule_code is not None:
            result['hotel_intl_rule_code'] = self.hotel_intl_rule_code
        if self.hotel_rule_code is not None:
            result['hotel_rule_code'] = self.hotel_rule_code
        if self.invoice_name is not None:
            result['invoice_name'] = self.invoice_name
        if self.payment_department_id is not None:
            result['payment_department_id'] = self.payment_department_id
        if self.payment_department_name is not None:
            result['payment_department_name'] = self.payment_department_name
        if self.premium_economy_discount is not None:
            result['premium_economy_discount'] = self.premium_economy_discount
        if self.project_code is not None:
            result['project_code'] = self.project_code
        if self.project_title is not None:
            result['project_title'] = self.project_title
        if self.reserve_type is not None:
            result['reserve_type'] = self.reserve_type
        if self.third_part_invoice_id is not None:
            result['third_part_invoice_id'] = self.third_part_invoice_id
        if self.thirdpart_cost_center_id is not None:
            result['thirdpart_cost_center_id'] = self.thirdpart_cost_center_id
        if self.thirdpart_depart_id is not None:
            result['thirdpart_depart_id'] = self.thirdpart_depart_id
        if self.train_rule_code is not None:
            result['train_rule_code'] = self.train_rule_code
        if self.train_seats is not None:
            result['train_seats'] = self.train_seats
        if self.user_name is not None:
            result['user_name'] = self.user_name
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('attribute') is not None:
            self.attribute = m.get('attribute')
        if m.get('business_discount') is not None:
            self.business_discount = m.get('business_discount')
        if m.get('cost_center_name') is not None:
            self.cost_center_name = m.get('cost_center_name')
        if m.get('depart_id') is not None:
            self.depart_id = m.get('depart_id')
        if m.get('economy_discount') is not None:
            self.economy_discount = m.get('economy_discount')
        if m.get('external_user_id') is not None:
            self.external_user_id = m.get('external_user_id')
        if m.get('first_discount') is not None:
            self.first_discount = m.get('first_discount')
        if m.get('flight_cabins') is not None:
            self.flight_cabins = m.get('flight_cabins')
        if m.get('flight_intl_rule_code') is not None:
            self.flight_intl_rule_code = m.get('flight_intl_rule_code')
        if m.get('flight_rule_code') is not None:
            self.flight_rule_code = m.get('flight_rule_code')
        self.hotel_citys = []
        if m.get('hotel_citys') is not None:
            for k in m.get('hotel_citys'):
                temp_model = ApplyQueryResponseBodyModuleExternalTravelerListHotelCitys()
                self.hotel_citys.append(temp_model.from_map(k))
        self.hotel_intl_citys = []
        if m.get('hotel_intl_citys') is not None:
            for k in m.get('hotel_intl_citys'):
                temp_model = ApplyQueryResponseBodyModuleExternalTravelerListHotelIntlCitys()
                self.hotel_intl_citys.append(temp_model.from_map(k))
        if m.get('hotel_intl_rule_code') is not None:
            self.hotel_intl_rule_code = m.get('hotel_intl_rule_code')
        if m.get('hotel_rule_code') is not None:
            self.hotel_rule_code = m.get('hotel_rule_code')
        if m.get('invoice_name') is not None:
            self.invoice_name = m.get('invoice_name')
        if m.get('payment_department_id') is not None:
            self.payment_department_id = m.get('payment_department_id')
        if m.get('payment_department_name') is not None:
            self.payment_department_name = m.get('payment_department_name')
        if m.get('premium_economy_discount') is not None:
            self.premium_economy_discount = m.get('premium_economy_discount')
        if m.get('project_code') is not None:
            self.project_code = m.get('project_code')
        if m.get('project_title') is not None:
            self.project_title = m.get('project_title')
        if m.get('reserve_type') is not None:
            self.reserve_type = m.get('reserve_type')
        if m.get('third_part_invoice_id') is not None:
            self.third_part_invoice_id = m.get('third_part_invoice_id')
        if m.get('thirdpart_cost_center_id') is not None:
            self.thirdpart_cost_center_id = m.get('thirdpart_cost_center_id')
        if m.get('thirdpart_depart_id') is not None:
            self.thirdpart_depart_id = m.get('thirdpart_depart_id')
        if m.get('train_rule_code') is not None:
            self.train_rule_code = m.get('train_rule_code')
        if m.get('train_seats') is not None:
            self.train_seats = m.get('train_seats')
        if m.get('user_name') is not None:
            self.user_name = m.get('user_name')
        return self


class ApplyQueryResponseBodyModuleHotelShare(TeaModel):
    def __init__(
        self,
        param: str = None,
        type: str = None,
    ):
        self.param = param
        self.type = type

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.param is not None:
            result['param'] = self.param
        if self.type is not None:
            result['type'] = self.type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('param') is not None:
            self.param = m.get('param')
        if m.get('type') is not None:
            self.type = m.get('type')
        return self


class ApplyQueryResponseBodyModuleItineraryListItineraryTravelStandard(TeaModel):
    def __init__(
        self,
        hotel_available_nights_per_day: int = None,
    ):
        self.hotel_available_nights_per_day = hotel_available_nights_per_day

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.hotel_available_nights_per_day is not None:
            result['hotel_available_nights_per_day'] = self.hotel_available_nights_per_day
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('hotel_available_nights_per_day') is not None:
            self.hotel_available_nights_per_day = m.get('hotel_available_nights_per_day')
        return self


class ApplyQueryResponseBodyModuleItineraryList(TeaModel):
    def __init__(
        self,
        arr_city: str = None,
        arr_city_code: str = None,
        arr_date: str = None,
        attribute: str = None,
        cost_center_name: str = None,
        dep_city: str = None,
        dep_city_code: str = None,
        dep_date: str = None,
        invoice_name: str = None,
        itinerary_id: str = None,
        itinerary_travel_standard: ApplyQueryResponseBodyModuleItineraryListItineraryTravelStandard = None,
        project_code: str = None,
        project_title: str = None,
        thirdpart_cost_center_id: str = None,
        thirdpart_invoice_id: str = None,
        thirdpart_itinerary_id: str = None,
        traffic_type: int = None,
        trip_way: int = None,
    ):
        self.arr_city = arr_city
        self.arr_city_code = arr_city_code
        self.arr_date = arr_date
        self.attribute = attribute
        self.cost_center_name = cost_center_name
        self.dep_city = dep_city
        self.dep_city_code = dep_city_code
        self.dep_date = dep_date
        self.invoice_name = invoice_name
        self.itinerary_id = itinerary_id
        self.itinerary_travel_standard = itinerary_travel_standard
        self.project_code = project_code
        self.project_title = project_title
        self.thirdpart_cost_center_id = thirdpart_cost_center_id
        self.thirdpart_invoice_id = thirdpart_invoice_id
        self.thirdpart_itinerary_id = thirdpart_itinerary_id
        self.traffic_type = traffic_type
        self.trip_way = trip_way

    def validate(self):
        if self.itinerary_travel_standard:
            self.itinerary_travel_standard.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.arr_city is not None:
            result['arr_city'] = self.arr_city
        if self.arr_city_code is not None:
            result['arr_city_code'] = self.arr_city_code
        if self.arr_date is not None:
            result['arr_date'] = self.arr_date
        if self.attribute is not None:
            result['attribute'] = self.attribute
        if self.cost_center_name is not None:
            result['cost_center_name'] = self.cost_center_name
        if self.dep_city is not None:
            result['dep_city'] = self.dep_city
        if self.dep_city_code is not None:
            result['dep_city_code'] = self.dep_city_code
        if self.dep_date is not None:
            result['dep_date'] = self.dep_date
        if self.invoice_name is not None:
            result['invoice_name'] = self.invoice_name
        if self.itinerary_id is not None:
            result['itinerary_id'] = self.itinerary_id
        if self.itinerary_travel_standard is not None:
            result['itinerary_travel_standard'] = self.itinerary_travel_standard.to_map()
        if self.project_code is not None:
            result['project_code'] = self.project_code
        if self.project_title is not None:
            result['project_title'] = self.project_title
        if self.thirdpart_cost_center_id is not None:
            result['thirdpart_cost_center_id'] = self.thirdpart_cost_center_id
        if self.thirdpart_invoice_id is not None:
            result['thirdpart_invoice_id'] = self.thirdpart_invoice_id
        if self.thirdpart_itinerary_id is not None:
            result['thirdpart_itinerary_id'] = self.thirdpart_itinerary_id
        if self.traffic_type is not None:
            result['traffic_type'] = self.traffic_type
        if self.trip_way is not None:
            result['trip_way'] = self.trip_way
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('arr_city') is not None:
            self.arr_city = m.get('arr_city')
        if m.get('arr_city_code') is not None:
            self.arr_city_code = m.get('arr_city_code')
        if m.get('arr_date') is not None:
            self.arr_date = m.get('arr_date')
        if m.get('attribute') is not None:
            self.attribute = m.get('attribute')
        if m.get('cost_center_name') is not None:
            self.cost_center_name = m.get('cost_center_name')
        if m.get('dep_city') is not None:
            self.dep_city = m.get('dep_city')
        if m.get('dep_city_code') is not None:
            self.dep_city_code = m.get('dep_city_code')
        if m.get('dep_date') is not None:
            self.dep_date = m.get('dep_date')
        if m.get('invoice_name') is not None:
            self.invoice_name = m.get('invoice_name')
        if m.get('itinerary_id') is not None:
            self.itinerary_id = m.get('itinerary_id')
        if m.get('itinerary_travel_standard') is not None:
            temp_model = ApplyQueryResponseBodyModuleItineraryListItineraryTravelStandard()
            self.itinerary_travel_standard = temp_model.from_map(m['itinerary_travel_standard'])
        if m.get('project_code') is not None:
            self.project_code = m.get('project_code')
        if m.get('project_title') is not None:
            self.project_title = m.get('project_title')
        if m.get('thirdpart_cost_center_id') is not None:
            self.thirdpart_cost_center_id = m.get('thirdpart_cost_center_id')
        if m.get('thirdpart_invoice_id') is not None:
            self.thirdpart_invoice_id = m.get('thirdpart_invoice_id')
        if m.get('thirdpart_itinerary_id') is not None:
            self.thirdpart_itinerary_id = m.get('thirdpart_itinerary_id')
        if m.get('traffic_type') is not None:
            self.traffic_type = m.get('traffic_type')
        if m.get('trip_way') is not None:
            self.trip_way = m.get('trip_way')
        return self


class ApplyQueryResponseBodyModuleItinerarySetListItineraryTravelStandard(TeaModel):
    def __init__(
        self,
        hotel_available_nights_per_day: int = None,
    ):
        self.hotel_available_nights_per_day = hotel_available_nights_per_day

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.hotel_available_nights_per_day is not None:
            result['hotel_available_nights_per_day'] = self.hotel_available_nights_per_day
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('hotel_available_nights_per_day') is not None:
            self.hotel_available_nights_per_day = m.get('hotel_available_nights_per_day')
        return self


class ApplyQueryResponseBodyModuleItinerarySetList(TeaModel):
    def __init__(
        self,
        arr_date: str = None,
        attribute: str = None,
        city_code_set: str = None,
        city_set: str = None,
        cost_center_name: str = None,
        dep_date: str = None,
        invoice_name: str = None,
        itinerary_id: str = None,
        itinerary_travel_standard: ApplyQueryResponseBodyModuleItinerarySetListItineraryTravelStandard = None,
        project_code: str = None,
        project_title: str = None,
        thirdpart_cost_center_id: str = None,
        thirdpart_invoice_id: str = None,
        thirdpart_itinerary_id: str = None,
        traffic_type: int = None,
    ):
        self.arr_date = arr_date
        self.attribute = attribute
        self.city_code_set = city_code_set
        self.city_set = city_set
        self.cost_center_name = cost_center_name
        self.dep_date = dep_date
        self.invoice_name = invoice_name
        self.itinerary_id = itinerary_id
        self.itinerary_travel_standard = itinerary_travel_standard
        self.project_code = project_code
        self.project_title = project_title
        self.thirdpart_cost_center_id = thirdpart_cost_center_id
        self.thirdpart_invoice_id = thirdpart_invoice_id
        self.thirdpart_itinerary_id = thirdpart_itinerary_id
        self.traffic_type = traffic_type

    def validate(self):
        if self.itinerary_travel_standard:
            self.itinerary_travel_standard.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.arr_date is not None:
            result['arr_date'] = self.arr_date
        if self.attribute is not None:
            result['attribute'] = self.attribute
        if self.city_code_set is not None:
            result['city_code_set'] = self.city_code_set
        if self.city_set is not None:
            result['city_set'] = self.city_set
        if self.cost_center_name is not None:
            result['cost_center_name'] = self.cost_center_name
        if self.dep_date is not None:
            result['dep_date'] = self.dep_date
        if self.invoice_name is not None:
            result['invoice_name'] = self.invoice_name
        if self.itinerary_id is not None:
            result['itinerary_id'] = self.itinerary_id
        if self.itinerary_travel_standard is not None:
            result['itinerary_travel_standard'] = self.itinerary_travel_standard.to_map()
        if self.project_code is not None:
            result['project_code'] = self.project_code
        if self.project_title is not None:
            result['project_title'] = self.project_title
        if self.thirdpart_cost_center_id is not None:
            result['thirdpart_cost_center_id'] = self.thirdpart_cost_center_id
        if self.thirdpart_invoice_id is not None:
            result['thirdpart_invoice_id'] = self.thirdpart_invoice_id
        if self.thirdpart_itinerary_id is not None:
            result['thirdpart_itinerary_id'] = self.thirdpart_itinerary_id
        if self.traffic_type is not None:
            result['traffic_type'] = self.traffic_type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('arr_date') is not None:
            self.arr_date = m.get('arr_date')
        if m.get('attribute') is not None:
            self.attribute = m.get('attribute')
        if m.get('city_code_set') is not None:
            self.city_code_set = m.get('city_code_set')
        if m.get('city_set') is not None:
            self.city_set = m.get('city_set')
        if m.get('cost_center_name') is not None:
            self.cost_center_name = m.get('cost_center_name')
        if m.get('dep_date') is not None:
            self.dep_date = m.get('dep_date')
        if m.get('invoice_name') is not None:
            self.invoice_name = m.get('invoice_name')
        if m.get('itinerary_id') is not None:
            self.itinerary_id = m.get('itinerary_id')
        if m.get('itinerary_travel_standard') is not None:
            temp_model = ApplyQueryResponseBodyModuleItinerarySetListItineraryTravelStandard()
            self.itinerary_travel_standard = temp_model.from_map(m['itinerary_travel_standard'])
        if m.get('project_code') is not None:
            self.project_code = m.get('project_code')
        if m.get('project_title') is not None:
            self.project_title = m.get('project_title')
        if m.get('thirdpart_cost_center_id') is not None:
            self.thirdpart_cost_center_id = m.get('thirdpart_cost_center_id')
        if m.get('thirdpart_invoice_id') is not None:
            self.thirdpart_invoice_id = m.get('thirdpart_invoice_id')
        if m.get('thirdpart_itinerary_id') is not None:
            self.thirdpart_itinerary_id = m.get('thirdpart_itinerary_id')
        if m.get('traffic_type') is not None:
            self.traffic_type = m.get('traffic_type')
        return self


class ApplyQueryResponseBodyModuleTravelerListCarCitySet(TeaModel):
    def __init__(
        self,
        city_code: str = None,
        city_name: str = None,
    ):
        self.city_code = city_code
        self.city_name = city_name

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.city_code is not None:
            result['city_code'] = self.city_code
        if self.city_name is not None:
            result['city_name'] = self.city_name
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('city_code') is not None:
            self.city_code = m.get('city_code')
        if m.get('city_name') is not None:
            self.city_name = m.get('city_name')
        return self


class ApplyQueryResponseBodyModuleTravelerListHotelCitys(TeaModel):
    def __init__(
        self,
        city_code: str = None,
        city_name: str = None,
        fee: int = None,
    ):
        self.city_code = city_code
        self.city_name = city_name
        self.fee = fee

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.city_code is not None:
            result['city_code'] = self.city_code
        if self.city_name is not None:
            result['city_name'] = self.city_name
        if self.fee is not None:
            result['fee'] = self.fee
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('city_code') is not None:
            self.city_code = m.get('city_code')
        if m.get('city_name') is not None:
            self.city_name = m.get('city_name')
        if m.get('fee') is not None:
            self.fee = m.get('fee')
        return self


class ApplyQueryResponseBodyModuleTravelerListHotelIntlCitys(TeaModel):
    def __init__(
        self,
        city_code: str = None,
        city_name: str = None,
        fee: int = None,
    ):
        self.city_code = city_code
        self.city_name = city_name
        self.fee = fee

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.city_code is not None:
            result['city_code'] = self.city_code
        if self.city_name is not None:
            result['city_name'] = self.city_name
        if self.fee is not None:
            result['fee'] = self.fee
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('city_code') is not None:
            self.city_code = m.get('city_code')
        if m.get('city_name') is not None:
            self.city_name = m.get('city_name')
        if m.get('fee') is not None:
            self.fee = m.get('fee')
        return self


class ApplyQueryResponseBodyModuleTravelerList(TeaModel):
    def __init__(
        self,
        attribute: str = None,
        business_discount: int = None,
        car_city_set: List[ApplyQueryResponseBodyModuleTravelerListCarCitySet] = None,
        cost_center_name: str = None,
        depart_id: str = None,
        economy_discount: int = None,
        first_discount: int = None,
        flight_cabins: str = None,
        flight_intl_rule_code: int = None,
        flight_rule_code: int = None,
        hotel_citys: List[ApplyQueryResponseBodyModuleTravelerListHotelCitys] = None,
        hotel_intl_citys: List[ApplyQueryResponseBodyModuleTravelerListHotelIntlCitys] = None,
        hotel_intl_rule_code: int = None,
        hotel_rule_code: int = None,
        invoice_name: str = None,
        payment_department_id: str = None,
        payment_department_name: str = None,
        premium_economy_discount: int = None,
        project_code: str = None,
        project_title: str = None,
        reserve_type: int = None,
        third_part_invoice_id: str = None,
        thirdpart_cost_center_id: str = None,
        thirdpart_depart_id: str = None,
        train_rule_code: int = None,
        train_seats: str = None,
        user_id: str = None,
        user_name: str = None,
    ):
        self.attribute = attribute
        self.business_discount = business_discount
        self.car_city_set = car_city_set
        self.cost_center_name = cost_center_name
        self.depart_id = depart_id
        self.economy_discount = economy_discount
        self.first_discount = first_discount
        self.flight_cabins = flight_cabins
        self.flight_intl_rule_code = flight_intl_rule_code
        self.flight_rule_code = flight_rule_code
        self.hotel_citys = hotel_citys
        self.hotel_intl_citys = hotel_intl_citys
        self.hotel_intl_rule_code = hotel_intl_rule_code
        self.hotel_rule_code = hotel_rule_code
        self.invoice_name = invoice_name
        self.payment_department_id = payment_department_id
        self.payment_department_name = payment_department_name
        self.premium_economy_discount = premium_economy_discount
        self.project_code = project_code
        self.project_title = project_title
        self.reserve_type = reserve_type
        self.third_part_invoice_id = third_part_invoice_id
        self.thirdpart_cost_center_id = thirdpart_cost_center_id
        self.thirdpart_depart_id = thirdpart_depart_id
        self.train_rule_code = train_rule_code
        self.train_seats = train_seats
        self.user_id = user_id
        self.user_name = user_name

    def validate(self):
        if self.car_city_set:
            for k in self.car_city_set:
                if k:
                    k.validate()
        if self.hotel_citys:
            for k in self.hotel_citys:
                if k:
                    k.validate()
        if self.hotel_intl_citys:
            for k in self.hotel_intl_citys:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.attribute is not None:
            result['attribute'] = self.attribute
        if self.business_discount is not None:
            result['business_discount'] = self.business_discount
        result['car_city_set'] = []
        if self.car_city_set is not None:
            for k in self.car_city_set:
                result['car_city_set'].append(k.to_map() if k else None)
        if self.cost_center_name is not None:
            result['cost_center_name'] = self.cost_center_name
        if self.depart_id is not None:
            result['depart_id'] = self.depart_id
        if self.economy_discount is not None:
            result['economy_discount'] = self.economy_discount
        if self.first_discount is not None:
            result['first_discount'] = self.first_discount
        if self.flight_cabins is not None:
            result['flight_cabins'] = self.flight_cabins
        if self.flight_intl_rule_code is not None:
            result['flight_intl_rule_code'] = self.flight_intl_rule_code
        if self.flight_rule_code is not None:
            result['flight_rule_code'] = self.flight_rule_code
        result['hotel_citys'] = []
        if self.hotel_citys is not None:
            for k in self.hotel_citys:
                result['hotel_citys'].append(k.to_map() if k else None)
        result['hotel_intl_citys'] = []
        if self.hotel_intl_citys is not None:
            for k in self.hotel_intl_citys:
                result['hotel_intl_citys'].append(k.to_map() if k else None)
        if self.hotel_intl_rule_code is not None:
            result['hotel_intl_rule_code'] = self.hotel_intl_rule_code
        if self.hotel_rule_code is not None:
            result['hotel_rule_code'] = self.hotel_rule_code
        if self.invoice_name is not None:
            result['invoice_name'] = self.invoice_name
        if self.payment_department_id is not None:
            result['payment_department_id'] = self.payment_department_id
        if self.payment_department_name is not None:
            result['payment_department_name'] = self.payment_department_name
        if self.premium_economy_discount is not None:
            result['premium_economy_discount'] = self.premium_economy_discount
        if self.project_code is not None:
            result['project_code'] = self.project_code
        if self.project_title is not None:
            result['project_title'] = self.project_title
        if self.reserve_type is not None:
            result['reserve_type'] = self.reserve_type
        if self.third_part_invoice_id is not None:
            result['third_part_invoice_id'] = self.third_part_invoice_id
        if self.thirdpart_cost_center_id is not None:
            result['thirdpart_cost_center_id'] = self.thirdpart_cost_center_id
        if self.thirdpart_depart_id is not None:
            result['thirdpart_depart_id'] = self.thirdpart_depart_id
        if self.train_rule_code is not None:
            result['train_rule_code'] = self.train_rule_code
        if self.train_seats is not None:
            result['train_seats'] = self.train_seats
        if self.user_id is not None:
            result['user_id'] = self.user_id
        if self.user_name is not None:
            result['user_name'] = self.user_name
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('attribute') is not None:
            self.attribute = m.get('attribute')
        if m.get('business_discount') is not None:
            self.business_discount = m.get('business_discount')
        self.car_city_set = []
        if m.get('car_city_set') is not None:
            for k in m.get('car_city_set'):
                temp_model = ApplyQueryResponseBodyModuleTravelerListCarCitySet()
                self.car_city_set.append(temp_model.from_map(k))
        if m.get('cost_center_name') is not None:
            self.cost_center_name = m.get('cost_center_name')
        if m.get('depart_id') is not None:
            self.depart_id = m.get('depart_id')
        if m.get('economy_discount') is not None:
            self.economy_discount = m.get('economy_discount')
        if m.get('first_discount') is not None:
            self.first_discount = m.get('first_discount')
        if m.get('flight_cabins') is not None:
            self.flight_cabins = m.get('flight_cabins')
        if m.get('flight_intl_rule_code') is not None:
            self.flight_intl_rule_code = m.get('flight_intl_rule_code')
        if m.get('flight_rule_code') is not None:
            self.flight_rule_code = m.get('flight_rule_code')
        self.hotel_citys = []
        if m.get('hotel_citys') is not None:
            for k in m.get('hotel_citys'):
                temp_model = ApplyQueryResponseBodyModuleTravelerListHotelCitys()
                self.hotel_citys.append(temp_model.from_map(k))
        self.hotel_intl_citys = []
        if m.get('hotel_intl_citys') is not None:
            for k in m.get('hotel_intl_citys'):
                temp_model = ApplyQueryResponseBodyModuleTravelerListHotelIntlCitys()
                self.hotel_intl_citys.append(temp_model.from_map(k))
        if m.get('hotel_intl_rule_code') is not None:
            self.hotel_intl_rule_code = m.get('hotel_intl_rule_code')
        if m.get('hotel_rule_code') is not None:
            self.hotel_rule_code = m.get('hotel_rule_code')
        if m.get('invoice_name') is not None:
            self.invoice_name = m.get('invoice_name')
        if m.get('payment_department_id') is not None:
            self.payment_department_id = m.get('payment_department_id')
        if m.get('payment_department_name') is not None:
            self.payment_department_name = m.get('payment_department_name')
        if m.get('premium_economy_discount') is not None:
            self.premium_economy_discount = m.get('premium_economy_discount')
        if m.get('project_code') is not None:
            self.project_code = m.get('project_code')
        if m.get('project_title') is not None:
            self.project_title = m.get('project_title')
        if m.get('reserve_type') is not None:
            self.reserve_type = m.get('reserve_type')
        if m.get('third_part_invoice_id') is not None:
            self.third_part_invoice_id = m.get('third_part_invoice_id')
        if m.get('thirdpart_cost_center_id') is not None:
            self.thirdpart_cost_center_id = m.get('thirdpart_cost_center_id')
        if m.get('thirdpart_depart_id') is not None:
            self.thirdpart_depart_id = m.get('thirdpart_depart_id')
        if m.get('train_rule_code') is not None:
            self.train_rule_code = m.get('train_rule_code')
        if m.get('train_seats') is not None:
            self.train_seats = m.get('train_seats')
        if m.get('user_id') is not None:
            self.user_id = m.get('user_id')
        if m.get('user_name') is not None:
            self.user_name = m.get('user_name')
        return self


class ApplyQueryResponseBodyModule(TeaModel):
    def __init__(
        self,
        apply_show_id: str = None,
        approver_list: List[ApplyQueryResponseBodyModuleApproverList] = None,
        budget: int = None,
        budget_merge: int = None,
        car_rule: ApplyQueryResponseBodyModuleCarRule = None,
        corp_id: str = None,
        corp_name: str = None,
        depart_id: str = None,
        depart_name: str = None,
        extend_field: str = None,
        external_traveler_list: List[ApplyQueryResponseBodyModuleExternalTravelerList] = None,
        flight_budget: int = None,
        gmt_create: str = None,
        gmt_modified: str = None,
        hotel_budget: int = None,
        hotel_share: ApplyQueryResponseBodyModuleHotelShare = None,
        id: int = None,
        intl_flight_budget: int = None,
        intl_hotel_budget: int = None,
        itinerary_list: List[ApplyQueryResponseBodyModuleItineraryList] = None,
        itinerary_rule: int = None,
        itinerary_set_list: List[ApplyQueryResponseBodyModuleItinerarySetList] = None,
        limit_traveler: int = None,
        meal_budget: int = None,
        payment_department_id: str = None,
        payment_department_name: str = None,
        status: int = None,
        status_desc: str = None,
        thirdpart_business_id: str = None,
        thirdpart_id: str = None,
        together_book_rule: int = None,
        train_budget: int = None,
        traveler_list: List[ApplyQueryResponseBodyModuleTravelerList] = None,
        trip_cause: str = None,
        trip_day: int = None,
        trip_title: str = None,
        type: int = None,
        union_no: str = None,
        user_id: str = None,
        user_name: str = None,
        vehicle_budget: int = None,
    ):
        self.apply_show_id = apply_show_id
        self.approver_list = approver_list
        self.budget = budget
        self.budget_merge = budget_merge
        self.car_rule = car_rule
        self.corp_id = corp_id
        self.corp_name = corp_name
        self.depart_id = depart_id
        self.depart_name = depart_name
        # 补充描述，账单中将会体现此字段的值。可以用于企业的统计和对账
        self.extend_field = extend_field
        self.external_traveler_list = external_traveler_list
        self.flight_budget = flight_budget
        self.gmt_create = gmt_create
        self.gmt_modified = gmt_modified
        self.hotel_budget = hotel_budget
        self.hotel_share = hotel_share
        self.id = id
        self.intl_flight_budget = intl_flight_budget
        self.intl_hotel_budget = intl_hotel_budget
        self.itinerary_list = itinerary_list
        self.itinerary_rule = itinerary_rule
        self.itinerary_set_list = itinerary_set_list
        self.limit_traveler = limit_traveler
        self.meal_budget = meal_budget
        self.payment_department_id = payment_department_id
        self.payment_department_name = payment_department_name
        self.status = status
        self.status_desc = status_desc
        self.thirdpart_business_id = thirdpart_business_id
        self.thirdpart_id = thirdpart_id
        self.together_book_rule = together_book_rule
        self.train_budget = train_budget
        self.traveler_list = traveler_list
        self.trip_cause = trip_cause
        self.trip_day = trip_day
        self.trip_title = trip_title
        self.type = type
        self.union_no = union_no
        self.user_id = user_id
        self.user_name = user_name
        self.vehicle_budget = vehicle_budget

    def validate(self):
        if self.approver_list:
            for k in self.approver_list:
                if k:
                    k.validate()
        if self.car_rule:
            self.car_rule.validate()
        if self.external_traveler_list:
            for k in self.external_traveler_list:
                if k:
                    k.validate()
        if self.hotel_share:
            self.hotel_share.validate()
        if self.itinerary_list:
            for k in self.itinerary_list:
                if k:
                    k.validate()
        if self.itinerary_set_list:
            for k in self.itinerary_set_list:
                if k:
                    k.validate()
        if self.traveler_list:
            for k in self.traveler_list:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.apply_show_id is not None:
            result['apply_show_id'] = self.apply_show_id
        result['approver_list'] = []
        if self.approver_list is not None:
            for k in self.approver_list:
                result['approver_list'].append(k.to_map() if k else None)
        if self.budget is not None:
            result['budget'] = self.budget
        if self.budget_merge is not None:
            result['budget_merge'] = self.budget_merge
        if self.car_rule is not None:
            result['car_rule'] = self.car_rule.to_map()
        if self.corp_id is not None:
            result['corp_id'] = self.corp_id
        if self.corp_name is not None:
            result['corp_name'] = self.corp_name
        if self.depart_id is not None:
            result['depart_id'] = self.depart_id
        if self.depart_name is not None:
            result['depart_name'] = self.depart_name
        if self.extend_field is not None:
            result['extend_field'] = self.extend_field
        result['external_traveler_list'] = []
        if self.external_traveler_list is not None:
            for k in self.external_traveler_list:
                result['external_traveler_list'].append(k.to_map() if k else None)
        if self.flight_budget is not None:
            result['flight_budget'] = self.flight_budget
        if self.gmt_create is not None:
            result['gmt_create'] = self.gmt_create
        if self.gmt_modified is not None:
            result['gmt_modified'] = self.gmt_modified
        if self.hotel_budget is not None:
            result['hotel_budget'] = self.hotel_budget
        if self.hotel_share is not None:
            result['hotel_share'] = self.hotel_share.to_map()
        if self.id is not None:
            result['id'] = self.id
        if self.intl_flight_budget is not None:
            result['intl_flight_budget'] = self.intl_flight_budget
        if self.intl_hotel_budget is not None:
            result['intl_hotel_budget'] = self.intl_hotel_budget
        result['itinerary_list'] = []
        if self.itinerary_list is not None:
            for k in self.itinerary_list:
                result['itinerary_list'].append(k.to_map() if k else None)
        if self.itinerary_rule is not None:
            result['itinerary_rule'] = self.itinerary_rule
        result['itinerary_set_list'] = []
        if self.itinerary_set_list is not None:
            for k in self.itinerary_set_list:
                result['itinerary_set_list'].append(k.to_map() if k else None)
        if self.limit_traveler is not None:
            result['limit_traveler'] = self.limit_traveler
        if self.meal_budget is not None:
            result['meal_budget'] = self.meal_budget
        if self.payment_department_id is not None:
            result['payment_department_id'] = self.payment_department_id
        if self.payment_department_name is not None:
            result['payment_department_name'] = self.payment_department_name
        if self.status is not None:
            result['status'] = self.status
        if self.status_desc is not None:
            result['status_desc'] = self.status_desc
        if self.thirdpart_business_id is not None:
            result['thirdpart_business_id'] = self.thirdpart_business_id
        if self.thirdpart_id is not None:
            result['thirdpart_id'] = self.thirdpart_id
        if self.together_book_rule is not None:
            result['together_book_rule'] = self.together_book_rule
        if self.train_budget is not None:
            result['train_budget'] = self.train_budget
        result['traveler_list'] = []
        if self.traveler_list is not None:
            for k in self.traveler_list:
                result['traveler_list'].append(k.to_map() if k else None)
        if self.trip_cause is not None:
            result['trip_cause'] = self.trip_cause
        if self.trip_day is not None:
            result['trip_day'] = self.trip_day
        if self.trip_title is not None:
            result['trip_title'] = self.trip_title
        if self.type is not None:
            result['type'] = self.type
        if self.union_no is not None:
            result['union_no'] = self.union_no
        if self.user_id is not None:
            result['user_id'] = self.user_id
        if self.user_name is not None:
            result['user_name'] = self.user_name
        if self.vehicle_budget is not None:
            result['vehicle_budget'] = self.vehicle_budget
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('apply_show_id') is not None:
            self.apply_show_id = m.get('apply_show_id')
        self.approver_list = []
        if m.get('approver_list') is not None:
            for k in m.get('approver_list'):
                temp_model = ApplyQueryResponseBodyModuleApproverList()
                self.approver_list.append(temp_model.from_map(k))
        if m.get('budget') is not None:
            self.budget = m.get('budget')
        if m.get('budget_merge') is not None:
            self.budget_merge = m.get('budget_merge')
        if m.get('car_rule') is not None:
            temp_model = ApplyQueryResponseBodyModuleCarRule()
            self.car_rule = temp_model.from_map(m['car_rule'])
        if m.get('corp_id') is not None:
            self.corp_id = m.get('corp_id')
        if m.get('corp_name') is not None:
            self.corp_name = m.get('corp_name')
        if m.get('depart_id') is not None:
            self.depart_id = m.get('depart_id')
        if m.get('depart_name') is not None:
            self.depart_name = m.get('depart_name')
        if m.get('extend_field') is not None:
            self.extend_field = m.get('extend_field')
        self.external_traveler_list = []
        if m.get('external_traveler_list') is not None:
            for k in m.get('external_traveler_list'):
                temp_model = ApplyQueryResponseBodyModuleExternalTravelerList()
                self.external_traveler_list.append(temp_model.from_map(k))
        if m.get('flight_budget') is not None:
            self.flight_budget = m.get('flight_budget')
        if m.get('gmt_create') is not None:
            self.gmt_create = m.get('gmt_create')
        if m.get('gmt_modified') is not None:
            self.gmt_modified = m.get('gmt_modified')
        if m.get('hotel_budget') is not None:
            self.hotel_budget = m.get('hotel_budget')
        if m.get('hotel_share') is not None:
            temp_model = ApplyQueryResponseBodyModuleHotelShare()
            self.hotel_share = temp_model.from_map(m['hotel_share'])
        if m.get('id') is not None:
            self.id = m.get('id')
        if m.get('intl_flight_budget') is not None:
            self.intl_flight_budget = m.get('intl_flight_budget')
        if m.get('intl_hotel_budget') is not None:
            self.intl_hotel_budget = m.get('intl_hotel_budget')
        self.itinerary_list = []
        if m.get('itinerary_list') is not None:
            for k in m.get('itinerary_list'):
                temp_model = ApplyQueryResponseBodyModuleItineraryList()
                self.itinerary_list.append(temp_model.from_map(k))
        if m.get('itinerary_rule') is not None:
            self.itinerary_rule = m.get('itinerary_rule')
        self.itinerary_set_list = []
        if m.get('itinerary_set_list') is not None:
            for k in m.get('itinerary_set_list'):
                temp_model = ApplyQueryResponseBodyModuleItinerarySetList()
                self.itinerary_set_list.append(temp_model.from_map(k))
        if m.get('limit_traveler') is not None:
            self.limit_traveler = m.get('limit_traveler')
        if m.get('meal_budget') is not None:
            self.meal_budget = m.get('meal_budget')
        if m.get('payment_department_id') is not None:
            self.payment_department_id = m.get('payment_department_id')
        if m.get('payment_department_name') is not None:
            self.payment_department_name = m.get('payment_department_name')
        if m.get('status') is not None:
            self.status = m.get('status')
        if m.get('status_desc') is not None:
            self.status_desc = m.get('status_desc')
        if m.get('thirdpart_business_id') is not None:
            self.thirdpart_business_id = m.get('thirdpart_business_id')
        if m.get('thirdpart_id') is not None:
            self.thirdpart_id = m.get('thirdpart_id')
        if m.get('together_book_rule') is not None:
            self.together_book_rule = m.get('together_book_rule')
        if m.get('train_budget') is not None:
            self.train_budget = m.get('train_budget')
        self.traveler_list = []
        if m.get('traveler_list') is not None:
            for k in m.get('traveler_list'):
                temp_model = ApplyQueryResponseBodyModuleTravelerList()
                self.traveler_list.append(temp_model.from_map(k))
        if m.get('trip_cause') is not None:
            self.trip_cause = m.get('trip_cause')
        if m.get('trip_day') is not None:
            self.trip_day = m.get('trip_day')
        if m.get('trip_title') is not None:
            self.trip_title = m.get('trip_title')
        if m.get('type') is not None:
            self.type = m.get('type')
        if m.get('union_no') is not None:
            self.union_no = m.get('union_no')
        if m.get('user_id') is not None:
            self.user_id = m.get('user_id')
        if m.get('user_name') is not None:
            self.user_name = m.get('user_name')
        if m.get('vehicle_budget') is not None:
            self.vehicle_budget = m.get('vehicle_budget')
        return self


class ApplyQueryResponseBody(TeaModel):
    def __init__(
        self,
        code: str = None,
        message: str = None,
        module: ApplyQueryResponseBodyModule = None,
        request_id: str = None,
        success: bool = None,
        trace_id: str = None,
    ):
        self.code = code
        self.message = message
        self.module = module
        self.request_id = request_id
        self.success = success
        self.trace_id = trace_id

    def validate(self):
        if self.module:
            self.module.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['code'] = self.code
        if self.message is not None:
            result['message'] = self.message
        if self.module is not None:
            result['module'] = self.module.to_map()
        if self.request_id is not None:
            result['requestId'] = self.request_id
        if self.success is not None:
            result['success'] = self.success
        if self.trace_id is not None:
            result['traceId'] = self.trace_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('code') is not None:
            self.code = m.get('code')
        if m.get('message') is not None:
            self.message = m.get('message')
        if m.get('module') is not None:
            temp_model = ApplyQueryResponseBodyModule()
            self.module = temp_model.from_map(m['module'])
        if m.get('requestId') is not None:
            self.request_id = m.get('requestId')
        if m.get('success') is not None:
            self.success = m.get('success')
        if m.get('traceId') is not None:
            self.trace_id = m.get('traceId')
        return self


class ApplyQueryResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: ApplyQueryResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = ApplyQueryResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class ApplyTripTaskExecuteHeaders(TeaModel):
    def __init__(
        self,
        common_headers: Dict[str, str] = None,
        x_acs_btrip_so_corp_token: str = None,
    ):
        self.common_headers = common_headers
        self.x_acs_btrip_so_corp_token = x_acs_btrip_so_corp_token

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.common_headers is not None:
            result['commonHeaders'] = self.common_headers
        if self.x_acs_btrip_so_corp_token is not None:
            result['x-acs-btrip-so-corp-token'] = self.x_acs_btrip_so_corp_token
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('commonHeaders') is not None:
            self.common_headers = m.get('commonHeaders')
        if m.get('x-acs-btrip-so-corp-token') is not None:
            self.x_acs_btrip_so_corp_token = m.get('x-acs-btrip-so-corp-token')
        return self


class ApplyTripTaskExecuteRequest(TeaModel):
    def __init__(
        self,
        action_from: str = None,
        comment: str = None,
        task_action: str = None,
        task_id: int = None,
        user_id: str = None,
        user_name: str = None,
    ):
        # This parameter is required.
        self.action_from = action_from
        self.comment = comment
        # This parameter is required.
        self.task_action = task_action
        # This parameter is required.
        self.task_id = task_id
        # This parameter is required.
        self.user_id = user_id
        self.user_name = user_name

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.action_from is not None:
            result['action_from'] = self.action_from
        if self.comment is not None:
            result['comment'] = self.comment
        if self.task_action is not None:
            result['task_action'] = self.task_action
        if self.task_id is not None:
            result['task_id'] = self.task_id
        if self.user_id is not None:
            result['user_id'] = self.user_id
        if self.user_name is not None:
            result['user_name'] = self.user_name
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('action_from') is not None:
            self.action_from = m.get('action_from')
        if m.get('comment') is not None:
            self.comment = m.get('comment')
        if m.get('task_action') is not None:
            self.task_action = m.get('task_action')
        if m.get('task_id') is not None:
            self.task_id = m.get('task_id')
        if m.get('user_id') is not None:
            self.user_id = m.get('user_id')
        if m.get('user_name') is not None:
            self.user_name = m.get('user_name')
        return self


class ApplyTripTaskExecuteResponseBody(TeaModel):
    def __init__(
        self,
        code: str = None,
        message: str = None,
        module: bool = None,
        request_id: str = None,
        success: bool = None,
        trace_id: str = None,
    ):
        self.code = code
        self.message = message
        self.module = module
        self.request_id = request_id
        self.success = success
        # traceId
        self.trace_id = trace_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['code'] = self.code
        if self.message is not None:
            result['message'] = self.message
        if self.module is not None:
            result['module'] = self.module
        if self.request_id is not None:
            result['requestId'] = self.request_id
        if self.success is not None:
            result['success'] = self.success
        if self.trace_id is not None:
            result['traceId'] = self.trace_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('code') is not None:
            self.code = m.get('code')
        if m.get('message') is not None:
            self.message = m.get('message')
        if m.get('module') is not None:
            self.module = m.get('module')
        if m.get('requestId') is not None:
            self.request_id = m.get('requestId')
        if m.get('success') is not None:
            self.success = m.get('success')
        if m.get('traceId') is not None:
            self.trace_id = m.get('traceId')
        return self


class ApplyTripTaskExecuteResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: ApplyTripTaskExecuteResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = ApplyTripTaskExecuteResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class BaseCityInfoSearchHeaders(TeaModel):
    def __init__(
        self,
        common_headers: Dict[str, str] = None,
        x_acs_btrip_access_token: str = None,
    ):
        self.common_headers = common_headers
        self.x_acs_btrip_access_token = x_acs_btrip_access_token

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.common_headers is not None:
            result['commonHeaders'] = self.common_headers
        if self.x_acs_btrip_access_token is not None:
            result['x-acs-btrip-access-token'] = self.x_acs_btrip_access_token
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('commonHeaders') is not None:
            self.common_headers = m.get('commonHeaders')
        if m.get('x-acs-btrip-access-token') is not None:
            self.x_acs_btrip_access_token = m.get('x-acs-btrip-access-token')
        return self


class BaseCityInfoSearchRequest(TeaModel):
    def __init__(
        self,
        keyword: str = None,
        region: str = None,
    ):
        # This parameter is required.
        self.keyword = keyword
        # This parameter is required.
        self.region = region

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.keyword is not None:
            result['keyword'] = self.keyword
        if self.region is not None:
            result['region'] = self.region
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('keyword') is not None:
            self.keyword = m.get('keyword')
        if m.get('region') is not None:
            self.region = m.get('region')
        return self


class BaseCityInfoSearchResponseBodyModule(TeaModel):
    def __init__(
        self,
        code: str = None,
        name: str = None,
        name_tree: str = None,
        region: str = None,
    ):
        self.code = code
        self.name = name
        self.name_tree = name_tree
        self.region = region

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['code'] = self.code
        if self.name is not None:
            result['name'] = self.name
        if self.name_tree is not None:
            result['nameTree'] = self.name_tree
        if self.region is not None:
            result['region'] = self.region
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('code') is not None:
            self.code = m.get('code')
        if m.get('name') is not None:
            self.name = m.get('name')
        if m.get('nameTree') is not None:
            self.name_tree = m.get('nameTree')
        if m.get('region') is not None:
            self.region = m.get('region')
        return self


class BaseCityInfoSearchResponseBody(TeaModel):
    def __init__(
        self,
        code: str = None,
        message: str = None,
        module: List[BaseCityInfoSearchResponseBodyModule] = None,
        request_id: str = None,
        success: bool = None,
        trace_id: str = None,
    ):
        self.code = code
        self.message = message
        self.module = module
        self.request_id = request_id
        self.success = success
        # traceId
        self.trace_id = trace_id

    def validate(self):
        if self.module:
            for k in self.module:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['code'] = self.code
        if self.message is not None:
            result['message'] = self.message
        result['module'] = []
        if self.module is not None:
            for k in self.module:
                result['module'].append(k.to_map() if k else None)
        if self.request_id is not None:
            result['requestId'] = self.request_id
        if self.success is not None:
            result['success'] = self.success
        if self.trace_id is not None:
            result['traceId'] = self.trace_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('code') is not None:
            self.code = m.get('code')
        if m.get('message') is not None:
            self.message = m.get('message')
        self.module = []
        if m.get('module') is not None:
            for k in m.get('module'):
                temp_model = BaseCityInfoSearchResponseBodyModule()
                self.module.append(temp_model.from_map(k))
        if m.get('requestId') is not None:
            self.request_id = m.get('requestId')
        if m.get('success') is not None:
            self.success = m.get('success')
        if m.get('traceId') is not None:
            self.trace_id = m.get('traceId')
        return self


class BaseCityInfoSearchResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: BaseCityInfoSearchResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = BaseCityInfoSearchResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class BtripBillInfoAdjustHeaders(TeaModel):
    def __init__(
        self,
        common_headers: Dict[str, str] = None,
        x_acs_btrip_corp_token: str = None,
    ):
        self.common_headers = common_headers
        self.x_acs_btrip_corp_token = x_acs_btrip_corp_token

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.common_headers is not None:
            result['commonHeaders'] = self.common_headers
        if self.x_acs_btrip_corp_token is not None:
            result['x-acs-btrip-corp-token'] = self.x_acs_btrip_corp_token
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('commonHeaders') is not None:
            self.common_headers = m.get('commonHeaders')
        if m.get('x-acs-btrip-corp-token') is not None:
            self.x_acs_btrip_corp_token = m.get('x-acs-btrip-corp-token')
        return self


class BtripBillInfoAdjustRequest(TeaModel):
    def __init__(
        self,
        primary_id: int = None,
        third_part_cost_center_id: str = None,
        third_part_department_id: str = None,
        third_part_invoice_id: str = None,
        third_part_project_id: str = None,
        user_id: str = None,
    ):
        # This parameter is required.
        self.primary_id = primary_id
        self.third_part_cost_center_id = third_part_cost_center_id
        self.third_part_department_id = third_part_department_id
        self.third_part_invoice_id = third_part_invoice_id
        self.third_part_project_id = third_part_project_id
        self.user_id = user_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.primary_id is not None:
            result['primary_id'] = self.primary_id
        if self.third_part_cost_center_id is not None:
            result['third_part_cost_center_id'] = self.third_part_cost_center_id
        if self.third_part_department_id is not None:
            result['third_part_department_id'] = self.third_part_department_id
        if self.third_part_invoice_id is not None:
            result['third_part_invoice_id'] = self.third_part_invoice_id
        if self.third_part_project_id is not None:
            result['third_part_project_id'] = self.third_part_project_id
        if self.user_id is not None:
            result['user_id'] = self.user_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('primary_id') is not None:
            self.primary_id = m.get('primary_id')
        if m.get('third_part_cost_center_id') is not None:
            self.third_part_cost_center_id = m.get('third_part_cost_center_id')
        if m.get('third_part_department_id') is not None:
            self.third_part_department_id = m.get('third_part_department_id')
        if m.get('third_part_invoice_id') is not None:
            self.third_part_invoice_id = m.get('third_part_invoice_id')
        if m.get('third_part_project_id') is not None:
            self.third_part_project_id = m.get('third_part_project_id')
        if m.get('user_id') is not None:
            self.user_id = m.get('user_id')
        return self


class BtripBillInfoAdjustResponseBody(TeaModel):
    def __init__(
        self,
        code: str = None,
        message: str = None,
        request_id: str = None,
        success: bool = None,
        trace_id: str = None,
    ):
        self.code = code
        self.message = message
        self.request_id = request_id
        self.success = success
        self.trace_id = trace_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['code'] = self.code
        if self.message is not None:
            result['message'] = self.message
        if self.request_id is not None:
            result['requestId'] = self.request_id
        if self.success is not None:
            result['success'] = self.success
        if self.trace_id is not None:
            result['traceId'] = self.trace_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('code') is not None:
            self.code = m.get('code')
        if m.get('message') is not None:
            self.message = m.get('message')
        if m.get('requestId') is not None:
            self.request_id = m.get('requestId')
        if m.get('success') is not None:
            self.success = m.get('success')
        if m.get('traceId') is not None:
            self.trace_id = m.get('traceId')
        return self


class BtripBillInfoAdjustResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: BtripBillInfoAdjustResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = BtripBillInfoAdjustResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CarApplyAddHeaders(TeaModel):
    def __init__(
        self,
        common_headers: Dict[str, str] = None,
        x_acs_btrip_so_corp_token: str = None,
    ):
        self.common_headers = common_headers
        self.x_acs_btrip_so_corp_token = x_acs_btrip_so_corp_token

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.common_headers is not None:
            result['commonHeaders'] = self.common_headers
        if self.x_acs_btrip_so_corp_token is not None:
            result['x-acs-btrip-so-corp-token'] = self.x_acs_btrip_so_corp_token
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('commonHeaders') is not None:
            self.common_headers = m.get('commonHeaders')
        if m.get('x-acs-btrip-so-corp-token') is not None:
            self.x_acs_btrip_so_corp_token = m.get('x-acs-btrip-so-corp-token')
        return self


class CarApplyAddRequestTravelerStandardCarCitySet(TeaModel):
    def __init__(
        self,
        city_code: str = None,
        city_name: str = None,
    ):
        # This parameter is required.
        self.city_code = city_code
        # This parameter is required.
        self.city_name = city_name

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.city_code is not None:
            result['city_code'] = self.city_code
        if self.city_name is not None:
            result['city_name'] = self.city_name
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('city_code') is not None:
            self.city_code = m.get('city_code')
        if m.get('city_name') is not None:
            self.city_name = m.get('city_name')
        return self


class CarApplyAddRequestTravelerStandard(TeaModel):
    def __init__(
        self,
        car_city_set: List[CarApplyAddRequestTravelerStandardCarCitySet] = None,
        user_id: str = None,
    ):
        self.car_city_set = car_city_set
        # This parameter is required.
        self.user_id = user_id

    def validate(self):
        if self.car_city_set:
            for k in self.car_city_set:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['car_city_set'] = []
        if self.car_city_set is not None:
            for k in self.car_city_set:
                result['car_city_set'].append(k.to_map() if k else None)
        if self.user_id is not None:
            result['user_id'] = self.user_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.car_city_set = []
        if m.get('car_city_set') is not None:
            for k in m.get('car_city_set'):
                temp_model = CarApplyAddRequestTravelerStandardCarCitySet()
                self.car_city_set.append(temp_model.from_map(k))
        if m.get('user_id') is not None:
            self.user_id = m.get('user_id')
        return self


class CarApplyAddRequest(TeaModel):
    def __init__(
        self,
        cause: str = None,
        city: str = None,
        city_code_set: str = None,
        date: str = None,
        finished_date: str = None,
        project_code: str = None,
        project_name: str = None,
        status: int = None,
        third_part_apply_id: str = None,
        third_part_cost_center_id: str = None,
        third_part_invoice_id: str = None,
        times_total: int = None,
        times_type: int = None,
        times_used: int = None,
        title: str = None,
        traveler_standard: List[CarApplyAddRequestTravelerStandard] = None,
        user_id: str = None,
    ):
        # This parameter is required.
        self.cause = cause
        # This parameter is required.
        self.city = city
        self.city_code_set = city_code_set
        # This parameter is required.
        self.date = date
        self.finished_date = finished_date
        self.project_code = project_code
        self.project_name = project_name
        # This parameter is required.
        self.status = status
        # This parameter is required.
        self.third_part_apply_id = third_part_apply_id
        self.third_part_cost_center_id = third_part_cost_center_id
        self.third_part_invoice_id = third_part_invoice_id
        # This parameter is required.
        self.times_total = times_total
        # This parameter is required.
        self.times_type = times_type
        # This parameter is required.
        self.times_used = times_used
        # This parameter is required.
        self.title = title
        self.traveler_standard = traveler_standard
        # This parameter is required.
        self.user_id = user_id

    def validate(self):
        if self.traveler_standard:
            for k in self.traveler_standard:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.cause is not None:
            result['cause'] = self.cause
        if self.city is not None:
            result['city'] = self.city
        if self.city_code_set is not None:
            result['city_code_set'] = self.city_code_set
        if self.date is not None:
            result['date'] = self.date
        if self.finished_date is not None:
            result['finished_date'] = self.finished_date
        if self.project_code is not None:
            result['project_code'] = self.project_code
        if self.project_name is not None:
            result['project_name'] = self.project_name
        if self.status is not None:
            result['status'] = self.status
        if self.third_part_apply_id is not None:
            result['third_part_apply_id'] = self.third_part_apply_id
        if self.third_part_cost_center_id is not None:
            result['third_part_cost_center_id'] = self.third_part_cost_center_id
        if self.third_part_invoice_id is not None:
            result['third_part_invoice_id'] = self.third_part_invoice_id
        if self.times_total is not None:
            result['times_total'] = self.times_total
        if self.times_type is not None:
            result['times_type'] = self.times_type
        if self.times_used is not None:
            result['times_used'] = self.times_used
        if self.title is not None:
            result['title'] = self.title
        result['traveler_standard'] = []
        if self.traveler_standard is not None:
            for k in self.traveler_standard:
                result['traveler_standard'].append(k.to_map() if k else None)
        if self.user_id is not None:
            result['user_id'] = self.user_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('cause') is not None:
            self.cause = m.get('cause')
        if m.get('city') is not None:
            self.city = m.get('city')
        if m.get('city_code_set') is not None:
            self.city_code_set = m.get('city_code_set')
        if m.get('date') is not None:
            self.date = m.get('date')
        if m.get('finished_date') is not None:
            self.finished_date = m.get('finished_date')
        if m.get('project_code') is not None:
            self.project_code = m.get('project_code')
        if m.get('project_name') is not None:
            self.project_name = m.get('project_name')
        if m.get('status') is not None:
            self.status = m.get('status')
        if m.get('third_part_apply_id') is not None:
            self.third_part_apply_id = m.get('third_part_apply_id')
        if m.get('third_part_cost_center_id') is not None:
            self.third_part_cost_center_id = m.get('third_part_cost_center_id')
        if m.get('third_part_invoice_id') is not None:
            self.third_part_invoice_id = m.get('third_part_invoice_id')
        if m.get('times_total') is not None:
            self.times_total = m.get('times_total')
        if m.get('times_type') is not None:
            self.times_type = m.get('times_type')
        if m.get('times_used') is not None:
            self.times_used = m.get('times_used')
        if m.get('title') is not None:
            self.title = m.get('title')
        self.traveler_standard = []
        if m.get('traveler_standard') is not None:
            for k in m.get('traveler_standard'):
                temp_model = CarApplyAddRequestTravelerStandard()
                self.traveler_standard.append(temp_model.from_map(k))
        if m.get('user_id') is not None:
            self.user_id = m.get('user_id')
        return self


class CarApplyAddShrinkRequest(TeaModel):
    def __init__(
        self,
        cause: str = None,
        city: str = None,
        city_code_set: str = None,
        date: str = None,
        finished_date: str = None,
        project_code: str = None,
        project_name: str = None,
        status: int = None,
        third_part_apply_id: str = None,
        third_part_cost_center_id: str = None,
        third_part_invoice_id: str = None,
        times_total: int = None,
        times_type: int = None,
        times_used: int = None,
        title: str = None,
        traveler_standard_shrink: str = None,
        user_id: str = None,
    ):
        # This parameter is required.
        self.cause = cause
        # This parameter is required.
        self.city = city
        self.city_code_set = city_code_set
        # This parameter is required.
        self.date = date
        self.finished_date = finished_date
        self.project_code = project_code
        self.project_name = project_name
        # This parameter is required.
        self.status = status
        # This parameter is required.
        self.third_part_apply_id = third_part_apply_id
        self.third_part_cost_center_id = third_part_cost_center_id
        self.third_part_invoice_id = third_part_invoice_id
        # This parameter is required.
        self.times_total = times_total
        # This parameter is required.
        self.times_type = times_type
        # This parameter is required.
        self.times_used = times_used
        # This parameter is required.
        self.title = title
        self.traveler_standard_shrink = traveler_standard_shrink
        # This parameter is required.
        self.user_id = user_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.cause is not None:
            result['cause'] = self.cause
        if self.city is not None:
            result['city'] = self.city
        if self.city_code_set is not None:
            result['city_code_set'] = self.city_code_set
        if self.date is not None:
            result['date'] = self.date
        if self.finished_date is not None:
            result['finished_date'] = self.finished_date
        if self.project_code is not None:
            result['project_code'] = self.project_code
        if self.project_name is not None:
            result['project_name'] = self.project_name
        if self.status is not None:
            result['status'] = self.status
        if self.third_part_apply_id is not None:
            result['third_part_apply_id'] = self.third_part_apply_id
        if self.third_part_cost_center_id is not None:
            result['third_part_cost_center_id'] = self.third_part_cost_center_id
        if self.third_part_invoice_id is not None:
            result['third_part_invoice_id'] = self.third_part_invoice_id
        if self.times_total is not None:
            result['times_total'] = self.times_total
        if self.times_type is not None:
            result['times_type'] = self.times_type
        if self.times_used is not None:
            result['times_used'] = self.times_used
        if self.title is not None:
            result['title'] = self.title
        if self.traveler_standard_shrink is not None:
            result['traveler_standard'] = self.traveler_standard_shrink
        if self.user_id is not None:
            result['user_id'] = self.user_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('cause') is not None:
            self.cause = m.get('cause')
        if m.get('city') is not None:
            self.city = m.get('city')
        if m.get('city_code_set') is not None:
            self.city_code_set = m.get('city_code_set')
        if m.get('date') is not None:
            self.date = m.get('date')
        if m.get('finished_date') is not None:
            self.finished_date = m.get('finished_date')
        if m.get('project_code') is not None:
            self.project_code = m.get('project_code')
        if m.get('project_name') is not None:
            self.project_name = m.get('project_name')
        if m.get('status') is not None:
            self.status = m.get('status')
        if m.get('third_part_apply_id') is not None:
            self.third_part_apply_id = m.get('third_part_apply_id')
        if m.get('third_part_cost_center_id') is not None:
            self.third_part_cost_center_id = m.get('third_part_cost_center_id')
        if m.get('third_part_invoice_id') is not None:
            self.third_part_invoice_id = m.get('third_part_invoice_id')
        if m.get('times_total') is not None:
            self.times_total = m.get('times_total')
        if m.get('times_type') is not None:
            self.times_type = m.get('times_type')
        if m.get('times_used') is not None:
            self.times_used = m.get('times_used')
        if m.get('title') is not None:
            self.title = m.get('title')
        if m.get('traveler_standard') is not None:
            self.traveler_standard_shrink = m.get('traveler_standard')
        if m.get('user_id') is not None:
            self.user_id = m.get('user_id')
        return self


class CarApplyAddResponseBody(TeaModel):
    def __init__(
        self,
        code: str = None,
        message: str = None,
        module: int = None,
        request_id: str = None,
        success: bool = None,
        trace_id: str = None,
    ):
        self.code = code
        self.message = message
        self.module = module
        self.request_id = request_id
        self.success = success
        self.trace_id = trace_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['code'] = self.code
        if self.message is not None:
            result['message'] = self.message
        if self.module is not None:
            result['module'] = self.module
        if self.request_id is not None:
            result['requestId'] = self.request_id
        if self.success is not None:
            result['success'] = self.success
        if self.trace_id is not None:
            result['traceId'] = self.trace_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('code') is not None:
            self.code = m.get('code')
        if m.get('message') is not None:
            self.message = m.get('message')
        if m.get('module') is not None:
            self.module = m.get('module')
        if m.get('requestId') is not None:
            self.request_id = m.get('requestId')
        if m.get('success') is not None:
            self.success = m.get('success')
        if m.get('traceId') is not None:
            self.trace_id = m.get('traceId')
        return self


class CarApplyAddResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: CarApplyAddResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = CarApplyAddResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CarApplyModifyHeaders(TeaModel):
    def __init__(
        self,
        common_headers: Dict[str, str] = None,
        x_acs_btrip_so_corp_token: str = None,
    ):
        self.common_headers = common_headers
        self.x_acs_btrip_so_corp_token = x_acs_btrip_so_corp_token

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.common_headers is not None:
            result['commonHeaders'] = self.common_headers
        if self.x_acs_btrip_so_corp_token is not None:
            result['x-acs-btrip-so-corp-token'] = self.x_acs_btrip_so_corp_token
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('commonHeaders') is not None:
            self.common_headers = m.get('commonHeaders')
        if m.get('x-acs-btrip-so-corp-token') is not None:
            self.x_acs_btrip_so_corp_token = m.get('x-acs-btrip-so-corp-token')
        return self


class CarApplyModifyRequest(TeaModel):
    def __init__(
        self,
        operate_time: str = None,
        remark: str = None,
        status: int = None,
        third_part_apply_id: str = None,
        user_id: str = None,
    ):
        self.operate_time = operate_time
        self.remark = remark
        # This parameter is required.
        self.status = status
        # This parameter is required.
        self.third_part_apply_id = third_part_apply_id
        # This parameter is required.
        self.user_id = user_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.operate_time is not None:
            result['operate_time'] = self.operate_time
        if self.remark is not None:
            result['remark'] = self.remark
        if self.status is not None:
            result['status'] = self.status
        if self.third_part_apply_id is not None:
            result['third_part_apply_id'] = self.third_part_apply_id
        if self.user_id is not None:
            result['user_id'] = self.user_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('operate_time') is not None:
            self.operate_time = m.get('operate_time')
        if m.get('remark') is not None:
            self.remark = m.get('remark')
        if m.get('status') is not None:
            self.status = m.get('status')
        if m.get('third_part_apply_id') is not None:
            self.third_part_apply_id = m.get('third_part_apply_id')
        if m.get('user_id') is not None:
            self.user_id = m.get('user_id')
        return self


class CarApplyModifyResponseBody(TeaModel):
    def __init__(
        self,
        code: str = None,
        message: str = None,
        module: bool = None,
        request_id: str = None,
        success: bool = None,
        trace_id: str = None,
    ):
        self.code = code
        self.message = message
        # module。
        self.module = module
        self.request_id = request_id
        self.success = success
        self.trace_id = trace_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['code'] = self.code
        if self.message is not None:
            result['message'] = self.message
        if self.module is not None:
            result['module'] = self.module
        if self.request_id is not None:
            result['requestId'] = self.request_id
        if self.success is not None:
            result['success'] = self.success
        if self.trace_id is not None:
            result['traceId'] = self.trace_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('code') is not None:
            self.code = m.get('code')
        if m.get('message') is not None:
            self.message = m.get('message')
        if m.get('module') is not None:
            self.module = m.get('module')
        if m.get('requestId') is not None:
            self.request_id = m.get('requestId')
        if m.get('success') is not None:
            self.success = m.get('success')
        if m.get('traceId') is not None:
            self.trace_id = m.get('traceId')
        return self


class CarApplyModifyResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: CarApplyModifyResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = CarApplyModifyResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CarApplyQueryHeaders(TeaModel):
    def __init__(
        self,
        common_headers: Dict[str, str] = None,
        x_acs_btrip_so_corp_token: str = None,
    ):
        self.common_headers = common_headers
        self.x_acs_btrip_so_corp_token = x_acs_btrip_so_corp_token

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.common_headers is not None:
            result['commonHeaders'] = self.common_headers
        if self.x_acs_btrip_so_corp_token is not None:
            result['x-acs-btrip-so-corp-token'] = self.x_acs_btrip_so_corp_token
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('commonHeaders') is not None:
            self.common_headers = m.get('commonHeaders')
        if m.get('x-acs-btrip-so-corp-token') is not None:
            self.x_acs_btrip_so_corp_token = m.get('x-acs-btrip-so-corp-token')
        return self


class CarApplyQueryRequest(TeaModel):
    def __init__(
        self,
        created_end_at: str = None,
        created_start_at: str = None,
        page_number: int = None,
        page_size: int = None,
        third_part_apply_id: str = None,
        user_id: str = None,
    ):
        self.created_end_at = created_end_at
        self.created_start_at = created_start_at
        self.page_number = page_number
        self.page_size = page_size
        self.third_part_apply_id = third_part_apply_id
        self.user_id = user_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.created_end_at is not None:
            result['created_end_at'] = self.created_end_at
        if self.created_start_at is not None:
            result['created_start_at'] = self.created_start_at
        if self.page_number is not None:
            result['page_number'] = self.page_number
        if self.page_size is not None:
            result['page_size'] = self.page_size
        if self.third_part_apply_id is not None:
            result['third_part_apply_id'] = self.third_part_apply_id
        if self.user_id is not None:
            result['user_id'] = self.user_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('created_end_at') is not None:
            self.created_end_at = m.get('created_end_at')
        if m.get('created_start_at') is not None:
            self.created_start_at = m.get('created_start_at')
        if m.get('page_number') is not None:
            self.page_number = m.get('page_number')
        if m.get('page_size') is not None:
            self.page_size = m.get('page_size')
        if m.get('third_part_apply_id') is not None:
            self.third_part_apply_id = m.get('third_part_apply_id')
        if m.get('user_id') is not None:
            self.user_id = m.get('user_id')
        return self


class CarApplyQueryResponseBodyApplyListApproverList(TeaModel):
    def __init__(
        self,
        note: str = None,
        operate_time: str = None,
        order: int = None,
        status: int = None,
        status_desc: str = None,
        user_id: str = None,
        user_name: str = None,
    ):
        self.note = note
        self.operate_time = operate_time
        self.order = order
        self.status = status
        self.status_desc = status_desc
        self.user_id = user_id
        self.user_name = user_name

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.note is not None:
            result['note'] = self.note
        if self.operate_time is not None:
            result['operate_time'] = self.operate_time
        if self.order is not None:
            result['order'] = self.order
        if self.status is not None:
            result['status'] = self.status
        if self.status_desc is not None:
            result['status_desc'] = self.status_desc
        if self.user_id is not None:
            result['user_id'] = self.user_id
        if self.user_name is not None:
            result['user_name'] = self.user_name
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('note') is not None:
            self.note = m.get('note')
        if m.get('operate_time') is not None:
            self.operate_time = m.get('operate_time')
        if m.get('order') is not None:
            self.order = m.get('order')
        if m.get('status') is not None:
            self.status = m.get('status')
        if m.get('status_desc') is not None:
            self.status_desc = m.get('status_desc')
        if m.get('user_id') is not None:
            self.user_id = m.get('user_id')
        if m.get('user_name') is not None:
            self.user_name = m.get('user_name')
        return self


class CarApplyQueryResponseBodyApplyListItineraryList(TeaModel):
    def __init__(
        self,
        arr_city: str = None,
        arr_city_code: str = None,
        arr_date: str = None,
        cost_center_id: int = None,
        cost_center_name: str = None,
        dep_city: str = None,
        dep_city_code: str = None,
        dep_date: str = None,
        invoice_id: int = None,
        invoice_name: str = None,
        itinerary_id: str = None,
        project_code: str = None,
        project_title: str = None,
        traffic_type: int = None,
    ):
        self.arr_city = arr_city
        self.arr_city_code = arr_city_code
        self.arr_date = arr_date
        self.cost_center_id = cost_center_id
        self.cost_center_name = cost_center_name
        self.dep_city = dep_city
        self.dep_city_code = dep_city_code
        self.dep_date = dep_date
        self.invoice_id = invoice_id
        self.invoice_name = invoice_name
        self.itinerary_id = itinerary_id
        self.project_code = project_code
        self.project_title = project_title
        self.traffic_type = traffic_type

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.arr_city is not None:
            result['arr_city'] = self.arr_city
        if self.arr_city_code is not None:
            result['arr_city_code'] = self.arr_city_code
        if self.arr_date is not None:
            result['arr_date'] = self.arr_date
        if self.cost_center_id is not None:
            result['cost_center_id'] = self.cost_center_id
        if self.cost_center_name is not None:
            result['cost_center_name'] = self.cost_center_name
        if self.dep_city is not None:
            result['dep_city'] = self.dep_city
        if self.dep_city_code is not None:
            result['dep_city_code'] = self.dep_city_code
        if self.dep_date is not None:
            result['dep_date'] = self.dep_date
        if self.invoice_id is not None:
            result['invoice_id'] = self.invoice_id
        if self.invoice_name is not None:
            result['invoice_name'] = self.invoice_name
        if self.itinerary_id is not None:
            result['itinerary_id'] = self.itinerary_id
        if self.project_code is not None:
            result['project_code'] = self.project_code
        if self.project_title is not None:
            result['project_title'] = self.project_title
        if self.traffic_type is not None:
            result['traffic_type'] = self.traffic_type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('arr_city') is not None:
            self.arr_city = m.get('arr_city')
        if m.get('arr_city_code') is not None:
            self.arr_city_code = m.get('arr_city_code')
        if m.get('arr_date') is not None:
            self.arr_date = m.get('arr_date')
        if m.get('cost_center_id') is not None:
            self.cost_center_id = m.get('cost_center_id')
        if m.get('cost_center_name') is not None:
            self.cost_center_name = m.get('cost_center_name')
        if m.get('dep_city') is not None:
            self.dep_city = m.get('dep_city')
        if m.get('dep_city_code') is not None:
            self.dep_city_code = m.get('dep_city_code')
        if m.get('dep_date') is not None:
            self.dep_date = m.get('dep_date')
        if m.get('invoice_id') is not None:
            self.invoice_id = m.get('invoice_id')
        if m.get('invoice_name') is not None:
            self.invoice_name = m.get('invoice_name')
        if m.get('itinerary_id') is not None:
            self.itinerary_id = m.get('itinerary_id')
        if m.get('project_code') is not None:
            self.project_code = m.get('project_code')
        if m.get('project_title') is not None:
            self.project_title = m.get('project_title')
        if m.get('traffic_type') is not None:
            self.traffic_type = m.get('traffic_type')
        return self


class CarApplyQueryResponseBodyApplyListTravelerStandardCarCitySet(TeaModel):
    def __init__(
        self,
        city_code: str = None,
        city_name: str = None,
    ):
        self.city_code = city_code
        self.city_name = city_name

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.city_code is not None:
            result['city_code'] = self.city_code
        if self.city_name is not None:
            result['city_name'] = self.city_name
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('city_code') is not None:
            self.city_code = m.get('city_code')
        if m.get('city_name') is not None:
            self.city_name = m.get('city_name')
        return self


class CarApplyQueryResponseBodyApplyListTravelerStandard(TeaModel):
    def __init__(
        self,
        car_city_set: List[CarApplyQueryResponseBodyApplyListTravelerStandardCarCitySet] = None,
        user_id: str = None,
    ):
        self.car_city_set = car_city_set
        self.user_id = user_id

    def validate(self):
        if self.car_city_set:
            for k in self.car_city_set:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['car_city_set'] = []
        if self.car_city_set is not None:
            for k in self.car_city_set:
                result['car_city_set'].append(k.to_map() if k else None)
        if self.user_id is not None:
            result['user_id'] = self.user_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.car_city_set = []
        if m.get('car_city_set') is not None:
            for k in m.get('car_city_set'):
                temp_model = CarApplyQueryResponseBodyApplyListTravelerStandardCarCitySet()
                self.car_city_set.append(temp_model.from_map(k))
        if m.get('user_id') is not None:
            self.user_id = m.get('user_id')
        return self


class CarApplyQueryResponseBodyApplyList(TeaModel):
    def __init__(
        self,
        approver_list: List[CarApplyQueryResponseBodyApplyListApproverList] = None,
        business_type: str = None,
        depart_id: str = None,
        depart_name: str = None,
        gmt_create: str = None,
        gmt_modified: str = None,
        itinerary_list: List[CarApplyQueryResponseBodyApplyListItineraryList] = None,
        order_id: int = None,
        related_third_apply_id: str = None,
        status: int = None,
        status_desc: str = None,
        thirdpart_id: str = None,
        traveler_standard: List[CarApplyQueryResponseBodyApplyListTravelerStandard] = None,
        trip_cause: str = None,
        trip_title: str = None,
        user_id: str = None,
        user_name: str = None,
    ):
        self.approver_list = approver_list
        self.business_type = business_type
        self.depart_id = depart_id
        self.depart_name = depart_name
        self.gmt_create = gmt_create
        self.gmt_modified = gmt_modified
        self.itinerary_list = itinerary_list
        self.order_id = order_id
        self.related_third_apply_id = related_third_apply_id
        self.status = status
        self.status_desc = status_desc
        self.thirdpart_id = thirdpart_id
        self.traveler_standard = traveler_standard
        self.trip_cause = trip_cause
        self.trip_title = trip_title
        self.user_id = user_id
        self.user_name = user_name

    def validate(self):
        if self.approver_list:
            for k in self.approver_list:
                if k:
                    k.validate()
        if self.itinerary_list:
            for k in self.itinerary_list:
                if k:
                    k.validate()
        if self.traveler_standard:
            for k in self.traveler_standard:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['approver_list'] = []
        if self.approver_list is not None:
            for k in self.approver_list:
                result['approver_list'].append(k.to_map() if k else None)
        if self.business_type is not None:
            result['business_type'] = self.business_type
        if self.depart_id is not None:
            result['depart_id'] = self.depart_id
        if self.depart_name is not None:
            result['depart_name'] = self.depart_name
        if self.gmt_create is not None:
            result['gmt_create'] = self.gmt_create
        if self.gmt_modified is not None:
            result['gmt_modified'] = self.gmt_modified
        result['itinerary_list'] = []
        if self.itinerary_list is not None:
            for k in self.itinerary_list:
                result['itinerary_list'].append(k.to_map() if k else None)
        if self.order_id is not None:
            result['order_id'] = self.order_id
        if self.related_third_apply_id is not None:
            result['related_third_apply_id'] = self.related_third_apply_id
        if self.status is not None:
            result['status'] = self.status
        if self.status_desc is not None:
            result['status_desc'] = self.status_desc
        if self.thirdpart_id is not None:
            result['thirdpart_id'] = self.thirdpart_id
        result['traveler_standard'] = []
        if self.traveler_standard is not None:
            for k in self.traveler_standard:
                result['traveler_standard'].append(k.to_map() if k else None)
        if self.trip_cause is not None:
            result['trip_cause'] = self.trip_cause
        if self.trip_title is not None:
            result['trip_title'] = self.trip_title
        if self.user_id is not None:
            result['user_id'] = self.user_id
        if self.user_name is not None:
            result['user_name'] = self.user_name
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.approver_list = []
        if m.get('approver_list') is not None:
            for k in m.get('approver_list'):
                temp_model = CarApplyQueryResponseBodyApplyListApproverList()
                self.approver_list.append(temp_model.from_map(k))
        if m.get('business_type') is not None:
            self.business_type = m.get('business_type')
        if m.get('depart_id') is not None:
            self.depart_id = m.get('depart_id')
        if m.get('depart_name') is not None:
            self.depart_name = m.get('depart_name')
        if m.get('gmt_create') is not None:
            self.gmt_create = m.get('gmt_create')
        if m.get('gmt_modified') is not None:
            self.gmt_modified = m.get('gmt_modified')
        self.itinerary_list = []
        if m.get('itinerary_list') is not None:
            for k in m.get('itinerary_list'):
                temp_model = CarApplyQueryResponseBodyApplyListItineraryList()
                self.itinerary_list.append(temp_model.from_map(k))
        if m.get('order_id') is not None:
            self.order_id = m.get('order_id')
        if m.get('related_third_apply_id') is not None:
            self.related_third_apply_id = m.get('related_third_apply_id')
        if m.get('status') is not None:
            self.status = m.get('status')
        if m.get('status_desc') is not None:
            self.status_desc = m.get('status_desc')
        if m.get('thirdpart_id') is not None:
            self.thirdpart_id = m.get('thirdpart_id')
        self.traveler_standard = []
        if m.get('traveler_standard') is not None:
            for k in m.get('traveler_standard'):
                temp_model = CarApplyQueryResponseBodyApplyListTravelerStandard()
                self.traveler_standard.append(temp_model.from_map(k))
        if m.get('trip_cause') is not None:
            self.trip_cause = m.get('trip_cause')
        if m.get('trip_title') is not None:
            self.trip_title = m.get('trip_title')
        if m.get('user_id') is not None:
            self.user_id = m.get('user_id')
        if m.get('user_name') is not None:
            self.user_name = m.get('user_name')
        return self


class CarApplyQueryResponseBody(TeaModel):
    def __init__(
        self,
        apply_list: List[CarApplyQueryResponseBodyApplyList] = None,
        code: str = None,
        message: str = None,
        request_id: str = None,
        success: bool = None,
        total: int = None,
        trace_id: str = None,
    ):
        self.apply_list = apply_list
        self.code = code
        self.message = message
        self.request_id = request_id
        self.success = success
        self.total = total
        self.trace_id = trace_id

    def validate(self):
        if self.apply_list:
            for k in self.apply_list:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['apply_list'] = []
        if self.apply_list is not None:
            for k in self.apply_list:
                result['apply_list'].append(k.to_map() if k else None)
        if self.code is not None:
            result['code'] = self.code
        if self.message is not None:
            result['message'] = self.message
        if self.request_id is not None:
            result['requestId'] = self.request_id
        if self.success is not None:
            result['success'] = self.success
        if self.total is not None:
            result['total'] = self.total
        if self.trace_id is not None:
            result['traceId'] = self.trace_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.apply_list = []
        if m.get('apply_list') is not None:
            for k in m.get('apply_list'):
                temp_model = CarApplyQueryResponseBodyApplyList()
                self.apply_list.append(temp_model.from_map(k))
        if m.get('code') is not None:
            self.code = m.get('code')
        if m.get('message') is not None:
            self.message = m.get('message')
        if m.get('requestId') is not None:
            self.request_id = m.get('requestId')
        if m.get('success') is not None:
            self.success = m.get('success')
        if m.get('total') is not None:
            self.total = m.get('total')
        if m.get('traceId') is not None:
            self.trace_id = m.get('traceId')
        return self


class CarApplyQueryResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: CarApplyQueryResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = CarApplyQueryResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CarBillSettlementQueryHeaders(TeaModel):
    def __init__(
        self,
        common_headers: Dict[str, str] = None,
        x_acs_btrip_so_corp_token: str = None,
    ):
        self.common_headers = common_headers
        self.x_acs_btrip_so_corp_token = x_acs_btrip_so_corp_token

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.common_headers is not None:
            result['commonHeaders'] = self.common_headers
        if self.x_acs_btrip_so_corp_token is not None:
            result['x-acs-btrip-so-corp-token'] = self.x_acs_btrip_so_corp_token
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('commonHeaders') is not None:
            self.common_headers = m.get('commonHeaders')
        if m.get('x-acs-btrip-so-corp-token') is not None:
            self.x_acs_btrip_so_corp_token = m.get('x-acs-btrip-so-corp-token')
        return self


class CarBillSettlementQueryRequest(TeaModel):
    def __init__(
        self,
        bill_batch: str = None,
        order_id: int = None,
        page_no: int = None,
        page_size: int = None,
        period_end: str = None,
        period_start: str = None,
        scroll_id: str = None,
        scroll_mod: bool = None,
    ):
        self.bill_batch = bill_batch
        self.order_id = order_id
        # This parameter is required.
        self.page_no = page_no
        # This parameter is required.
        self.page_size = page_size
        self.period_end = period_end
        self.period_start = period_start
        self.scroll_id = scroll_id
        self.scroll_mod = scroll_mod

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.bill_batch is not None:
            result['bill_batch'] = self.bill_batch
        if self.order_id is not None:
            result['order_id'] = self.order_id
        if self.page_no is not None:
            result['page_no'] = self.page_no
        if self.page_size is not None:
            result['page_size'] = self.page_size
        if self.period_end is not None:
            result['period_end'] = self.period_end
        if self.period_start is not None:
            result['period_start'] = self.period_start
        if self.scroll_id is not None:
            result['scroll_id'] = self.scroll_id
        if self.scroll_mod is not None:
            result['scroll_mod'] = self.scroll_mod
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('bill_batch') is not None:
            self.bill_batch = m.get('bill_batch')
        if m.get('order_id') is not None:
            self.order_id = m.get('order_id')
        if m.get('page_no') is not None:
            self.page_no = m.get('page_no')
        if m.get('page_size') is not None:
            self.page_size = m.get('page_size')
        if m.get('period_end') is not None:
            self.period_end = m.get('period_end')
        if m.get('period_start') is not None:
            self.period_start = m.get('period_start')
        if m.get('scroll_id') is not None:
            self.scroll_id = m.get('scroll_id')
        if m.get('scroll_mod') is not None:
            self.scroll_mod = m.get('scroll_mod')
        return self


class CarBillSettlementQueryResponseBodyModuleDataList(TeaModel):
    def __init__(
        self,
        adjust_time: str = None,
        alipay_trade_no: str = None,
        apply_arr_city_code: str = None,
        apply_arr_city_name: str = None,
        apply_dep_city_code: str = None,
        apply_dep_city_name: str = None,
        apply_extend_field: str = None,
        apply_id: str = None,
        approver_email: str = None,
        approver_id: str = None,
        approver_name: str = None,
        arr_city: str = None,
        arr_city_code: str = None,
        arr_date: str = None,
        arr_location: str = None,
        arr_time: str = None,
        base_location: str = None,
        bill_record_time: str = None,
        billing_entity: str = None,
        book_model: str = None,
        book_time: str = None,
        booker_id: str = None,
        booker_job_no: str = None,
        booker_name: str = None,
        business_category: str = None,
        capital_direction: str = None,
        car_level: str = None,
        cascade_department: str = None,
        category_desc: str = None,
        cost_center: str = None,
        cost_center_number: str = None,
        cost_department: str = None,
        coupon: float = None,
        coupon_price: float = None,
        custom_content: str = None,
        deductible_tax: float = None,
        dep_city_code: str = None,
        department: str = None,
        department_id: str = None,
        dept_city: str = None,
        dept_date: str = None,
        dept_location: str = None,
        dept_time: str = None,
        driver_add_detail: str = None,
        driver_add_fee: float = None,
        estimate_drive_distance: str = None,
        estimate_price: float = None,
        fee_type: str = None,
        fee_type_desc: str = None,
        foreigners_tag: str = None,
        index: str = None,
        invoice_title: str = None,
        level_name: str = None,
        location: str = None,
        mapping_company_code: str = None,
        memo: str = None,
        order_id: str = None,
        order_price: float = None,
        over_apply_id: str = None,
        payment_department_id: str = None,
        payment_department_name: str = None,
        person_settle_fee: float = None,
        position: str = None,
        position_level: str = None,
        primary_id: int = None,
        processor_oa_code: str = None,
        project_code: str = None,
        project_name: str = None,
        protocol_discount_fee: float = None,
        provider_name: str = None,
        real_drive_distance: str = None,
        real_from_addr: str = None,
        real_to_addr: str = None,
        remark: str = None,
        scene_id: str = None,
        scene_name: str = None,
        service_fee: float = None,
        settle_type_desc: str = None,
        settlement_fee: float = None,
        settlement_grant_fee: float = None,
        settlement_time: str = None,
        settlement_type: str = None,
        sio: str = None,
        special_order: str = None,
        special_reason: str = None,
        status: int = None,
        status_desc: str = None,
        sub_order_id: str = None,
        supplement_apply_id: str = None,
        tax_rate: str = None,
        third_itinerary_id: str = None,
        time_type: str = None,
        trade_action_desc: str = None,
        traveler_email: str = None,
        traveler_id: str = None,
        traveler_job_no: str = None,
        traveler_member_type: str = None,
        traveler_member_type_name: str = None,
        traveler_name: str = None,
        user_confirm_desc: str = None,
        vehicle_scene_id: str = None,
        vehicle_scene_name: str = None,
        voucher_type: int = None,
        voucher_type_desc: str = None,
    ):
        self.adjust_time = adjust_time
        self.alipay_trade_no = alipay_trade_no
        self.apply_arr_city_code = apply_arr_city_code
        self.apply_arr_city_name = apply_arr_city_name
        self.apply_dep_city_code = apply_dep_city_code
        self.apply_dep_city_name = apply_dep_city_name
        # 审批扩展自定义字段
        self.apply_extend_field = apply_extend_field
        self.apply_id = apply_id
        self.approver_email = approver_email
        self.approver_id = approver_id
        self.approver_name = approver_name
        self.arr_city = arr_city
        self.arr_city_code = arr_city_code
        self.arr_date = arr_date
        self.arr_location = arr_location
        self.arr_time = arr_time
        self.base_location = base_location
        self.bill_record_time = bill_record_time
        self.billing_entity = billing_entity
        self.book_model = book_model
        self.book_time = book_time
        self.booker_id = booker_id
        self.booker_job_no = booker_job_no
        self.booker_name = booker_name
        self.business_category = business_category
        self.capital_direction = capital_direction
        self.car_level = car_level
        self.cascade_department = cascade_department
        self.category_desc = category_desc
        self.cost_center = cost_center
        self.cost_center_number = cost_center_number
        self.cost_department = cost_department
        self.coupon = coupon
        self.coupon_price = coupon_price
        self.custom_content = custom_content
        self.deductible_tax = deductible_tax
        self.dep_city_code = dep_city_code
        self.department = department
        self.department_id = department_id
        self.dept_city = dept_city
        self.dept_date = dept_date
        self.dept_location = dept_location
        self.dept_time = dept_time
        self.driver_add_detail = driver_add_detail
        self.driver_add_fee = driver_add_fee
        self.estimate_drive_distance = estimate_drive_distance
        self.estimate_price = estimate_price
        self.fee_type = fee_type
        self.fee_type_desc = fee_type_desc
        self.foreigners_tag = foreigners_tag
        self.index = index
        self.invoice_title = invoice_title
        self.level_name = level_name
        self.location = location
        self.mapping_company_code = mapping_company_code
        self.memo = memo
        self.order_id = order_id
        self.order_price = order_price
        self.over_apply_id = over_apply_id
        self.payment_department_id = payment_department_id
        self.payment_department_name = payment_department_name
        self.person_settle_fee = person_settle_fee
        self.position = position
        self.position_level = position_level
        self.primary_id = primary_id
        self.processor_oa_code = processor_oa_code
        self.project_code = project_code
        self.project_name = project_name
        self.protocol_discount_fee = protocol_discount_fee
        self.provider_name = provider_name
        self.real_drive_distance = real_drive_distance
        self.real_from_addr = real_from_addr
        self.real_to_addr = real_to_addr
        self.remark = remark
        self.scene_id = scene_id
        self.scene_name = scene_name
        self.service_fee = service_fee
        self.settle_type_desc = settle_type_desc
        self.settlement_fee = settlement_fee
        self.settlement_grant_fee = settlement_grant_fee
        self.settlement_time = settlement_time
        self.settlement_type = settlement_type
        self.sio = sio
        self.special_order = special_order
        self.special_reason = special_reason
        self.status = status
        self.status_desc = status_desc
        self.sub_order_id = sub_order_id
        self.supplement_apply_id = supplement_apply_id
        # 税率
        self.tax_rate = tax_rate
        self.third_itinerary_id = third_itinerary_id
        self.time_type = time_type
        self.trade_action_desc = trade_action_desc
        self.traveler_email = traveler_email
        self.traveler_id = traveler_id
        self.traveler_job_no = traveler_job_no
        self.traveler_member_type = traveler_member_type
        self.traveler_member_type_name = traveler_member_type_name
        self.traveler_name = traveler_name
        self.user_confirm_desc = user_confirm_desc
        self.vehicle_scene_id = vehicle_scene_id
        self.vehicle_scene_name = vehicle_scene_name
        self.voucher_type = voucher_type
        self.voucher_type_desc = voucher_type_desc

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.adjust_time is not None:
            result['adjust_time'] = self.adjust_time
        if self.alipay_trade_no is not None:
            result['alipay_trade_no'] = self.alipay_trade_no
        if self.apply_arr_city_code is not None:
            result['apply_arr_city_code'] = self.apply_arr_city_code
        if self.apply_arr_city_name is not None:
            result['apply_arr_city_name'] = self.apply_arr_city_name
        if self.apply_dep_city_code is not None:
            result['apply_dep_city_code'] = self.apply_dep_city_code
        if self.apply_dep_city_name is not None:
            result['apply_dep_city_name'] = self.apply_dep_city_name
        if self.apply_extend_field is not None:
            result['apply_extend_field'] = self.apply_extend_field
        if self.apply_id is not None:
            result['apply_id'] = self.apply_id
        if self.approver_email is not None:
            result['approver_email'] = self.approver_email
        if self.approver_id is not None:
            result['approver_id'] = self.approver_id
        if self.approver_name is not None:
            result['approver_name'] = self.approver_name
        if self.arr_city is not None:
            result['arr_city'] = self.arr_city
        if self.arr_city_code is not None:
            result['arr_city_code'] = self.arr_city_code
        if self.arr_date is not None:
            result['arr_date'] = self.arr_date
        if self.arr_location is not None:
            result['arr_location'] = self.arr_location
        if self.arr_time is not None:
            result['arr_time'] = self.arr_time
        if self.base_location is not None:
            result['base_location'] = self.base_location
        if self.bill_record_time is not None:
            result['bill_record_time'] = self.bill_record_time
        if self.billing_entity is not None:
            result['billing_entity'] = self.billing_entity
        if self.book_model is not None:
            result['book_model'] = self.book_model
        if self.book_time is not None:
            result['book_time'] = self.book_time
        if self.booker_id is not None:
            result['booker_id'] = self.booker_id
        if self.booker_job_no is not None:
            result['booker_job_no'] = self.booker_job_no
        if self.booker_name is not None:
            result['booker_name'] = self.booker_name
        if self.business_category is not None:
            result['business_category'] = self.business_category
        if self.capital_direction is not None:
            result['capital_direction'] = self.capital_direction
        if self.car_level is not None:
            result['car_level'] = self.car_level
        if self.cascade_department is not None:
            result['cascade_department'] = self.cascade_department
        if self.category_desc is not None:
            result['category_desc'] = self.category_desc
        if self.cost_center is not None:
            result['cost_center'] = self.cost_center
        if self.cost_center_number is not None:
            result['cost_center_number'] = self.cost_center_number
        if self.cost_department is not None:
            result['cost_department'] = self.cost_department
        if self.coupon is not None:
            result['coupon'] = self.coupon
        if self.coupon_price is not None:
            result['coupon_price'] = self.coupon_price
        if self.custom_content is not None:
            result['custom_content'] = self.custom_content
        if self.deductible_tax is not None:
            result['deductible_tax'] = self.deductible_tax
        if self.dep_city_code is not None:
            result['dep_city_code'] = self.dep_city_code
        if self.department is not None:
            result['department'] = self.department
        if self.department_id is not None:
            result['department_id'] = self.department_id
        if self.dept_city is not None:
            result['dept_city'] = self.dept_city
        if self.dept_date is not None:
            result['dept_date'] = self.dept_date
        if self.dept_location is not None:
            result['dept_location'] = self.dept_location
        if self.dept_time is not None:
            result['dept_time'] = self.dept_time
        if self.driver_add_detail is not None:
            result['driver_add_detail'] = self.driver_add_detail
        if self.driver_add_fee is not None:
            result['driver_add_fee'] = self.driver_add_fee
        if self.estimate_drive_distance is not None:
            result['estimate_drive_distance'] = self.estimate_drive_distance
        if self.estimate_price is not None:
            result['estimate_price'] = self.estimate_price
        if self.fee_type is not None:
            result['fee_type'] = self.fee_type
        if self.fee_type_desc is not None:
            result['fee_type_desc'] = self.fee_type_desc
        if self.foreigners_tag is not None:
            result['foreigners_tag'] = self.foreigners_tag
        if self.index is not None:
            result['index'] = self.index
        if self.invoice_title is not None:
            result['invoice_title'] = self.invoice_title
        if self.level_name is not None:
            result['level_name'] = self.level_name
        if self.location is not None:
            result['location'] = self.location
        if self.mapping_company_code is not None:
            result['mapping_company_code'] = self.mapping_company_code
        if self.memo is not None:
            result['memo'] = self.memo
        if self.order_id is not None:
            result['order_id'] = self.order_id
        if self.order_price is not None:
            result['order_price'] = self.order_price
        if self.over_apply_id is not None:
            result['over_apply_id'] = self.over_apply_id
        if self.payment_department_id is not None:
            result['payment_department_id'] = self.payment_department_id
        if self.payment_department_name is not None:
            result['payment_department_name'] = self.payment_department_name
        if self.person_settle_fee is not None:
            result['person_settle_fee'] = self.person_settle_fee
        if self.position is not None:
            result['position'] = self.position
        if self.position_level is not None:
            result['position_level'] = self.position_level
        if self.primary_id is not None:
            result['primary_id'] = self.primary_id
        if self.processor_oa_code is not None:
            result['processor_oa_code'] = self.processor_oa_code
        if self.project_code is not None:
            result['project_code'] = self.project_code
        if self.project_name is not None:
            result['project_name'] = self.project_name
        if self.protocol_discount_fee is not None:
            result['protocol_discount_fee'] = self.protocol_discount_fee
        if self.provider_name is not None:
            result['provider_name'] = self.provider_name
        if self.real_drive_distance is not None:
            result['real_drive_distance'] = self.real_drive_distance
        if self.real_from_addr is not None:
            result['real_from_addr'] = self.real_from_addr
        if self.real_to_addr is not None:
            result['real_to_addr'] = self.real_to_addr
        if self.remark is not None:
            result['remark'] = self.remark
        if self.scene_id is not None:
            result['scene_id'] = self.scene_id
        if self.scene_name is not None:
            result['scene_name'] = self.scene_name
        if self.service_fee is not None:
            result['service_fee'] = self.service_fee
        if self.settle_type_desc is not None:
            result['settle_type_desc'] = self.settle_type_desc
        if self.settlement_fee is not None:
            result['settlement_fee'] = self.settlement_fee
        if self.settlement_grant_fee is not None:
            result['settlement_grant_fee'] = self.settlement_grant_fee
        if self.settlement_time is not None:
            result['settlement_time'] = self.settlement_time
        if self.settlement_type is not None:
            result['settlement_type'] = self.settlement_type
        if self.sio is not None:
            result['sio'] = self.sio
        if self.special_order is not None:
            result['special_order'] = self.special_order
        if self.special_reason is not None:
            result['special_reason'] = self.special_reason
        if self.status is not None:
            result['status'] = self.status
        if self.status_desc is not None:
            result['status_desc'] = self.status_desc
        if self.sub_order_id is not None:
            result['sub_order_id'] = self.sub_order_id
        if self.supplement_apply_id is not None:
            result['supplement_apply_id'] = self.supplement_apply_id
        if self.tax_rate is not None:
            result['tax_rate'] = self.tax_rate
        if self.third_itinerary_id is not None:
            result['third_itinerary_id'] = self.third_itinerary_id
        if self.time_type is not None:
            result['time_type'] = self.time_type
        if self.trade_action_desc is not None:
            result['trade_action_desc'] = self.trade_action_desc
        if self.traveler_email is not None:
            result['traveler_email'] = self.traveler_email
        if self.traveler_id is not None:
            result['traveler_id'] = self.traveler_id
        if self.traveler_job_no is not None:
            result['traveler_job_no'] = self.traveler_job_no
        if self.traveler_member_type is not None:
            result['traveler_member_type'] = self.traveler_member_type
        if self.traveler_member_type_name is not None:
            result['traveler_member_type_name'] = self.traveler_member_type_name
        if self.traveler_name is not None:
            result['traveler_name'] = self.traveler_name
        if self.user_confirm_desc is not None:
            result['user_confirm_desc'] = self.user_confirm_desc
        if self.vehicle_scene_id is not None:
            result['vehicle_scene_id'] = self.vehicle_scene_id
        if self.vehicle_scene_name is not None:
            result['vehicle_scene_name'] = self.vehicle_scene_name
        if self.voucher_type is not None:
            result['voucher_type'] = self.voucher_type
        if self.voucher_type_desc is not None:
            result['voucher_type_desc'] = self.voucher_type_desc
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('adjust_time') is not None:
            self.adjust_time = m.get('adjust_time')
        if m.get('alipay_trade_no') is not None:
            self.alipay_trade_no = m.get('alipay_trade_no')
        if m.get('apply_arr_city_code') is not None:
            self.apply_arr_city_code = m.get('apply_arr_city_code')
        if m.get('apply_arr_city_name') is not None:
            self.apply_arr_city_name = m.get('apply_arr_city_name')
        if m.get('apply_dep_city_code') is not None:
            self.apply_dep_city_code = m.get('apply_dep_city_code')
        if m.get('apply_dep_city_name') is not None:
            self.apply_dep_city_name = m.get('apply_dep_city_name')
        if m.get('apply_extend_field') is not None:
            self.apply_extend_field = m.get('apply_extend_field')
        if m.get('apply_id') is not None:
            self.apply_id = m.get('apply_id')
        if m.get('approver_email') is not None:
            self.approver_email = m.get('approver_email')
        if m.get('approver_id') is not None:
            self.approver_id = m.get('approver_id')
        if m.get('approver_name') is not None:
            self.approver_name = m.get('approver_name')
        if m.get('arr_city') is not None:
            self.arr_city = m.get('arr_city')
        if m.get('arr_city_code') is not None:
            self.arr_city_code = m.get('arr_city_code')
        if m.get('arr_date') is not None:
            self.arr_date = m.get('arr_date')
        if m.get('arr_location') is not None:
            self.arr_location = m.get('arr_location')
        if m.get('arr_time') is not None:
            self.arr_time = m.get('arr_time')
        if m.get('base_location') is not None:
            self.base_location = m.get('base_location')
        if m.get('bill_record_time') is not None:
            self.bill_record_time = m.get('bill_record_time')
        if m.get('billing_entity') is not None:
            self.billing_entity = m.get('billing_entity')
        if m.get('book_model') is not None:
            self.book_model = m.get('book_model')
        if m.get('book_time') is not None:
            self.book_time = m.get('book_time')
        if m.get('booker_id') is not None:
            self.booker_id = m.get('booker_id')
        if m.get('booker_job_no') is not None:
            self.booker_job_no = m.get('booker_job_no')
        if m.get('booker_name') is not None:
            self.booker_name = m.get('booker_name')
        if m.get('business_category') is not None:
            self.business_category = m.get('business_category')
        if m.get('capital_direction') is not None:
            self.capital_direction = m.get('capital_direction')
        if m.get('car_level') is not None:
            self.car_level = m.get('car_level')
        if m.get('cascade_department') is not None:
            self.cascade_department = m.get('cascade_department')
        if m.get('category_desc') is not None:
            self.category_desc = m.get('category_desc')
        if m.get('cost_center') is not None:
            self.cost_center = m.get('cost_center')
        if m.get('cost_center_number') is not None:
            self.cost_center_number = m.get('cost_center_number')
        if m.get('cost_department') is not None:
            self.cost_department = m.get('cost_department')
        if m.get('coupon') is not None:
            self.coupon = m.get('coupon')
        if m.get('coupon_price') is not None:
            self.coupon_price = m.get('coupon_price')
        if m.get('custom_content') is not None:
            self.custom_content = m.get('custom_content')
        if m.get('deductible_tax') is not None:
            self.deductible_tax = m.get('deductible_tax')
        if m.get('dep_city_code') is not None:
            self.dep_city_code = m.get('dep_city_code')
        if m.get('department') is not None:
            self.department = m.get('department')
        if m.get('department_id') is not None:
            self.department_id = m.get('department_id')
        if m.get('dept_city') is not None:
            self.dept_city = m.get('dept_city')
        if m.get('dept_date') is not None:
            self.dept_date = m.get('dept_date')
        if m.get('dept_location') is not None:
            self.dept_location = m.get('dept_location')
        if m.get('dept_time') is not None:
            self.dept_time = m.get('dept_time')
        if m.get('driver_add_detail') is not None:
            self.driver_add_detail = m.get('driver_add_detail')
        if m.get('driver_add_fee') is not None:
            self.driver_add_fee = m.get('driver_add_fee')
        if m.get('estimate_drive_distance') is not None:
            self.estimate_drive_distance = m.get('estimate_drive_distance')
        if m.get('estimate_price') is not None:
            self.estimate_price = m.get('estimate_price')
        if m.get('fee_type') is not None:
            self.fee_type = m.get('fee_type')
        if m.get('fee_type_desc') is not None:
            self.fee_type_desc = m.get('fee_type_desc')
        if m.get('foreigners_tag') is not None:
            self.foreigners_tag = m.get('foreigners_tag')
        if m.get('index') is not None:
            self.index = m.get('index')
        if m.get('invoice_title') is not None:
            self.invoice_title = m.get('invoice_title')
        if m.get('level_name') is not None:
            self.level_name = m.get('level_name')
        if m.get('location') is not None:
            self.location = m.get('location')
        if m.get('mapping_company_code') is not None:
            self.mapping_company_code = m.get('mapping_company_code')
        if m.get('memo') is not None:
            self.memo = m.get('memo')
        if m.get('order_id') is not None:
            self.order_id = m.get('order_id')
        if m.get('order_price') is not None:
            self.order_price = m.get('order_price')
        if m.get('over_apply_id') is not None:
            self.over_apply_id = m.get('over_apply_id')
        if m.get('payment_department_id') is not None:
            self.payment_department_id = m.get('payment_department_id')
        if m.get('payment_department_name') is not None:
            self.payment_department_name = m.get('payment_department_name')
        if m.get('person_settle_fee') is not None:
            self.person_settle_fee = m.get('person_settle_fee')
        if m.get('position') is not None:
            self.position = m.get('position')
        if m.get('position_level') is not None:
            self.position_level = m.get('position_level')
        if m.get('primary_id') is not None:
            self.primary_id = m.get('primary_id')
        if m.get('processor_oa_code') is not None:
            self.processor_oa_code = m.get('processor_oa_code')
        if m.get('project_code') is not None:
            self.project_code = m.get('project_code')
        if m.get('project_name') is not None:
            self.project_name = m.get('project_name')
        if m.get('protocol_discount_fee') is not None:
            self.protocol_discount_fee = m.get('protocol_discount_fee')
        if m.get('provider_name') is not None:
            self.provider_name = m.get('provider_name')
        if m.get('real_drive_distance') is not None:
            self.real_drive_distance = m.get('real_drive_distance')
        if m.get('real_from_addr') is not None:
            self.real_from_addr = m.get('real_from_addr')
        if m.get('real_to_addr') is not None:
            self.real_to_addr = m.get('real_to_addr')
        if m.get('remark') is not None:
            self.remark = m.get('remark')
        if m.get('scene_id') is not None:
            self.scene_id = m.get('scene_id')
        if m.get('scene_name') is not None:
            self.scene_name = m.get('scene_name')
        if m.get('service_fee') is not None:
            self.service_fee = m.get('service_fee')
        if m.get('settle_type_desc') is not None:
            self.settle_type_desc = m.get('settle_type_desc')
        if m.get('settlement_fee') is not None:
            self.settlement_fee = m.get('settlement_fee')
        if m.get('settlement_grant_fee') is not None:
            self.settlement_grant_fee = m.get('settlement_grant_fee')
        if m.get('settlement_time') is not None:
            self.settlement_time = m.get('settlement_time')
        if m.get('settlement_type') is not None:
            self.settlement_type = m.get('settlement_type')
        if m.get('sio') is not None:
            self.sio = m.get('sio')
        if m.get('special_order') is not None:
            self.special_order = m.get('special_order')
        if m.get('special_reason') is not None:
            self.special_reason = m.get('special_reason')
        if m.get('status') is not None:
            self.status = m.get('status')
        if m.get('status_desc') is not None:
            self.status_desc = m.get('status_desc')
        if m.get('sub_order_id') is not None:
            self.sub_order_id = m.get('sub_order_id')
        if m.get('supplement_apply_id') is not None:
            self.supplement_apply_id = m.get('supplement_apply_id')
        if m.get('tax_rate') is not None:
            self.tax_rate = m.get('tax_rate')
        if m.get('third_itinerary_id') is not None:
            self.third_itinerary_id = m.get('third_itinerary_id')
        if m.get('time_type') is not None:
            self.time_type = m.get('time_type')
        if m.get('trade_action_desc') is not None:
            self.trade_action_desc = m.get('trade_action_desc')
        if m.get('traveler_email') is not None:
            self.traveler_email = m.get('traveler_email')
        if m.get('traveler_id') is not None:
            self.traveler_id = m.get('traveler_id')
        if m.get('traveler_job_no') is not None:
            self.traveler_job_no = m.get('traveler_job_no')
        if m.get('traveler_member_type') is not None:
            self.traveler_member_type = m.get('traveler_member_type')
        if m.get('traveler_member_type_name') is not None:
            self.traveler_member_type_name = m.get('traveler_member_type_name')
        if m.get('traveler_name') is not None:
            self.traveler_name = m.get('traveler_name')
        if m.get('user_confirm_desc') is not None:
            self.user_confirm_desc = m.get('user_confirm_desc')
        if m.get('vehicle_scene_id') is not None:
            self.vehicle_scene_id = m.get('vehicle_scene_id')
        if m.get('vehicle_scene_name') is not None:
            self.vehicle_scene_name = m.get('vehicle_scene_name')
        if m.get('voucher_type') is not None:
            self.voucher_type = m.get('voucher_type')
        if m.get('voucher_type_desc') is not None:
            self.voucher_type_desc = m.get('voucher_type_desc')
        return self


class CarBillSettlementQueryResponseBodyModule(TeaModel):
    def __init__(
        self,
        category: int = None,
        corp_id: str = None,
        data_list: List[CarBillSettlementQueryResponseBodyModuleDataList] = None,
        period_end: str = None,
        period_start: str = None,
        scroll_id: str = None,
        total_num: int = None,
    ):
        self.category = category
        self.corp_id = corp_id
        self.data_list = data_list
        self.period_end = period_end
        self.period_start = period_start
        self.scroll_id = scroll_id
        self.total_num = total_num

    def validate(self):
        if self.data_list:
            for k in self.data_list:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.category is not None:
            result['category'] = self.category
        if self.corp_id is not None:
            result['corp_id'] = self.corp_id
        result['data_list'] = []
        if self.data_list is not None:
            for k in self.data_list:
                result['data_list'].append(k.to_map() if k else None)
        if self.period_end is not None:
            result['period_end'] = self.period_end
        if self.period_start is not None:
            result['period_start'] = self.period_start
        if self.scroll_id is not None:
            result['scroll_id'] = self.scroll_id
        if self.total_num is not None:
            result['total_num'] = self.total_num
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('category') is not None:
            self.category = m.get('category')
        if m.get('corp_id') is not None:
            self.corp_id = m.get('corp_id')
        self.data_list = []
        if m.get('data_list') is not None:
            for k in m.get('data_list'):
                temp_model = CarBillSettlementQueryResponseBodyModuleDataList()
                self.data_list.append(temp_model.from_map(k))
        if m.get('period_end') is not None:
            self.period_end = m.get('period_end')
        if m.get('period_start') is not None:
            self.period_start = m.get('period_start')
        if m.get('scroll_id') is not None:
            self.scroll_id = m.get('scroll_id')
        if m.get('total_num') is not None:
            self.total_num = m.get('total_num')
        return self


class CarBillSettlementQueryResponseBody(TeaModel):
    def __init__(
        self,
        code: str = None,
        message: str = None,
        module: CarBillSettlementQueryResponseBodyModule = None,
        request_id: str = None,
        success: bool = None,
        trace_id: str = None,
    ):
        self.code = code
        self.message = message
        self.module = module
        self.request_id = request_id
        self.success = success
        self.trace_id = trace_id

    def validate(self):
        if self.module:
            self.module.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['code'] = self.code
        if self.message is not None:
            result['message'] = self.message
        if self.module is not None:
            result['module'] = self.module.to_map()
        if self.request_id is not None:
            result['requestId'] = self.request_id
        if self.success is not None:
            result['success'] = self.success
        if self.trace_id is not None:
            result['traceId'] = self.trace_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('code') is not None:
            self.code = m.get('code')
        if m.get('message') is not None:
            self.message = m.get('message')
        if m.get('module') is not None:
            temp_model = CarBillSettlementQueryResponseBodyModule()
            self.module = temp_model.from_map(m['module'])
        if m.get('requestId') is not None:
            self.request_id = m.get('requestId')
        if m.get('success') is not None:
            self.success = m.get('success')
        if m.get('traceId') is not None:
            self.trace_id = m.get('traceId')
        return self


class CarBillSettlementQueryResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: CarBillSettlementQueryResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = CarBillSettlementQueryResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CarOrderListQueryHeaders(TeaModel):
    def __init__(
        self,
        common_headers: Dict[str, str] = None,
        x_acs_btrip_so_corp_token: str = None,
    ):
        self.common_headers = common_headers
        self.x_acs_btrip_so_corp_token = x_acs_btrip_so_corp_token

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.common_headers is not None:
            result['commonHeaders'] = self.common_headers
        if self.x_acs_btrip_so_corp_token is not None:
            result['x-acs-btrip-so-corp-token'] = self.x_acs_btrip_so_corp_token
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('commonHeaders') is not None:
            self.common_headers = m.get('commonHeaders')
        if m.get('x-acs-btrip-so-corp-token') is not None:
            self.x_acs_btrip_so_corp_token = m.get('x-acs-btrip-so-corp-token')
        return self


class CarOrderListQueryRequest(TeaModel):
    def __init__(
        self,
        all_apply: bool = None,
        apply_id: int = None,
        depart_id: str = None,
        end_time: str = None,
        page: int = None,
        page_size: int = None,
        start_time: str = None,
        thirdpart_apply_id: str = None,
        update_end_time: str = None,
        update_start_time: str = None,
        user_id: str = None,
    ):
        self.all_apply = all_apply
        self.apply_id = apply_id
        self.depart_id = depart_id
        self.end_time = end_time
        self.page = page
        self.page_size = page_size
        self.start_time = start_time
        self.thirdpart_apply_id = thirdpart_apply_id
        self.update_end_time = update_end_time
        self.update_start_time = update_start_time
        self.user_id = user_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.all_apply is not None:
            result['all_apply'] = self.all_apply
        if self.apply_id is not None:
            result['apply_id'] = self.apply_id
        if self.depart_id is not None:
            result['depart_id'] = self.depart_id
        if self.end_time is not None:
            result['end_time'] = self.end_time
        if self.page is not None:
            result['page'] = self.page
        if self.page_size is not None:
            result['page_size'] = self.page_size
        if self.start_time is not None:
            result['start_time'] = self.start_time
        if self.thirdpart_apply_id is not None:
            result['thirdpart_apply_id'] = self.thirdpart_apply_id
        if self.update_end_time is not None:
            result['update_end_time'] = self.update_end_time
        if self.update_start_time is not None:
            result['update_start_time'] = self.update_start_time
        if self.user_id is not None:
            result['user_id'] = self.user_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('all_apply') is not None:
            self.all_apply = m.get('all_apply')
        if m.get('apply_id') is not None:
            self.apply_id = m.get('apply_id')
        if m.get('depart_id') is not None:
            self.depart_id = m.get('depart_id')
        if m.get('end_time') is not None:
            self.end_time = m.get('end_time')
        if m.get('page') is not None:
            self.page = m.get('page')
        if m.get('page_size') is not None:
            self.page_size = m.get('page_size')
        if m.get('start_time') is not None:
            self.start_time = m.get('start_time')
        if m.get('thirdpart_apply_id') is not None:
            self.thirdpart_apply_id = m.get('thirdpart_apply_id')
        if m.get('update_end_time') is not None:
            self.update_end_time = m.get('update_end_time')
        if m.get('update_start_time') is not None:
            self.update_start_time = m.get('update_start_time')
        if m.get('user_id') is not None:
            self.user_id = m.get('user_id')
        return self


class CarOrderListQueryResponseBodyModulePriceInfoList(TeaModel):
    def __init__(
        self,
        category_code: int = None,
        category_type: int = None,
        gmt_create: str = None,
        passenger_name: str = None,
        pay_type: int = None,
        person_price: float = None,
        price: float = None,
        trade_id: str = None,
        type: int = None,
    ):
        self.category_code = category_code
        self.category_type = category_type
        self.gmt_create = gmt_create
        self.passenger_name = passenger_name
        self.pay_type = pay_type
        self.person_price = person_price
        self.price = price
        self.trade_id = trade_id
        self.type = type

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.category_code is not None:
            result['category_code'] = self.category_code
        if self.category_type is not None:
            result['category_type'] = self.category_type
        if self.gmt_create is not None:
            result['gmt_create'] = self.gmt_create
        if self.passenger_name is not None:
            result['passenger_name'] = self.passenger_name
        if self.pay_type is not None:
            result['pay_type'] = self.pay_type
        if self.person_price is not None:
            result['person_price'] = self.person_price
        if self.price is not None:
            result['price'] = self.price
        if self.trade_id is not None:
            result['trade_id'] = self.trade_id
        if self.type is not None:
            result['type'] = self.type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('category_code') is not None:
            self.category_code = m.get('category_code')
        if m.get('category_type') is not None:
            self.category_type = m.get('category_type')
        if m.get('gmt_create') is not None:
            self.gmt_create = m.get('gmt_create')
        if m.get('passenger_name') is not None:
            self.passenger_name = m.get('passenger_name')
        if m.get('pay_type') is not None:
            self.pay_type = m.get('pay_type')
        if m.get('person_price') is not None:
            self.person_price = m.get('person_price')
        if m.get('price') is not None:
            self.price = m.get('price')
        if m.get('trade_id') is not None:
            self.trade_id = m.get('trade_id')
        if m.get('type') is not None:
            self.type = m.get('type')
        return self


class CarOrderListQueryResponseBodyModuleUserAffiliateList(TeaModel):
    def __init__(
        self,
        user_id: str = None,
        user_name: str = None,
    ):
        self.user_id = user_id
        self.user_name = user_name

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.user_id is not None:
            result['user_id'] = self.user_id
        if self.user_name is not None:
            result['user_name'] = self.user_name
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('user_id') is not None:
            self.user_id = m.get('user_id')
        if m.get('user_name') is not None:
            self.user_name = m.get('user_name')
        return self


class CarOrderListQueryResponseBodyModule(TeaModel):
    def __init__(
        self,
        apply_id: int = None,
        apply_show_id: str = None,
        btrip_title: str = None,
        business_category: str = None,
        cancel_time: str = None,
        car_info: str = None,
        car_level: int = None,
        corp_id: str = None,
        corp_name: str = None,
        cost_center_id: int = None,
        cost_center_name: str = None,
        cost_center_number: str = None,
        dept_id: int = None,
        dept_name: str = None,
        driver_confirm_time: str = None,
        estimate_price: float = None,
        from_address: str = None,
        from_city_ad_code: str = None,
        from_city_name: str = None,
        gmt_create: str = None,
        gmt_modified: str = None,
        id: int = None,
        invoice_id: int = None,
        invoice_title: str = None,
        is_special: bool = None,
        memo: str = None,
        order_id: str = None,
        order_status: int = None,
        passenger_name: str = None,
        pay_time: str = None,
        price_info_list: List[CarOrderListQueryResponseBodyModulePriceInfoList] = None,
        project_code: str = None,
        project_id: int = None,
        project_title: str = None,
        provider: int = None,
        publish_time: str = None,
        real_from_address: str = None,
        real_from_city_ad_code: str = None,
        real_from_city_name: str = None,
        real_to_address: str = None,
        real_to_city_ad_code: str = None,
        real_to_city_name: str = None,
        service_type: int = None,
        special_types: List[str] = None,
        taken_time: str = None,
        thirdpart_apply_id: str = None,
        thirdpart_business_id: str = None,
        thirdpart_itinerary_id: str = None,
        to_address: str = None,
        to_city_ad_code: str = None,
        to_city_name: str = None,
        travel_distance: float = None,
        user_affiliate_list: List[CarOrderListQueryResponseBodyModuleUserAffiliateList] = None,
        user_confirm: int = None,
        user_id: str = None,
        user_name: str = None,
    ):
        self.apply_id = apply_id
        self.apply_show_id = apply_show_id
        self.btrip_title = btrip_title
        self.business_category = business_category
        self.cancel_time = cancel_time
        self.car_info = car_info
        self.car_level = car_level
        self.corp_id = corp_id
        self.corp_name = corp_name
        self.cost_center_id = cost_center_id
        self.cost_center_name = cost_center_name
        self.cost_center_number = cost_center_number
        self.dept_id = dept_id
        self.dept_name = dept_name
        self.driver_confirm_time = driver_confirm_time
        self.estimate_price = estimate_price
        self.from_address = from_address
        self.from_city_ad_code = from_city_ad_code
        self.from_city_name = from_city_name
        self.gmt_create = gmt_create
        self.gmt_modified = gmt_modified
        self.id = id
        self.invoice_id = invoice_id
        self.invoice_title = invoice_title
        self.is_special = is_special
        self.memo = memo
        self.order_id = order_id
        self.order_status = order_status
        self.passenger_name = passenger_name
        self.pay_time = pay_time
        self.price_info_list = price_info_list
        self.project_code = project_code
        self.project_id = project_id
        self.project_title = project_title
        self.provider = provider
        self.publish_time = publish_time
        self.real_from_address = real_from_address
        self.real_from_city_ad_code = real_from_city_ad_code
        self.real_from_city_name = real_from_city_name
        self.real_to_address = real_to_address
        self.real_to_city_ad_code = real_to_city_ad_code
        self.real_to_city_name = real_to_city_name
        self.service_type = service_type
        self.special_types = special_types
        self.taken_time = taken_time
        self.thirdpart_apply_id = thirdpart_apply_id
        self.thirdpart_business_id = thirdpart_business_id
        self.thirdpart_itinerary_id = thirdpart_itinerary_id
        self.to_address = to_address
        self.to_city_ad_code = to_city_ad_code
        self.to_city_name = to_city_name
        self.travel_distance = travel_distance
        self.user_affiliate_list = user_affiliate_list
        self.user_confirm = user_confirm
        self.user_id = user_id
        self.user_name = user_name

    def validate(self):
        if self.price_info_list:
            for k in self.price_info_list:
                if k:
                    k.validate()
        if self.user_affiliate_list:
            for k in self.user_affiliate_list:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.apply_id is not None:
            result['apply_id'] = self.apply_id
        if self.apply_show_id is not None:
            result['apply_show_id'] = self.apply_show_id
        if self.btrip_title is not None:
            result['btrip_title'] = self.btrip_title
        if self.business_category is not None:
            result['business_category'] = self.business_category
        if self.cancel_time is not None:
            result['cancel_time'] = self.cancel_time
        if self.car_info is not None:
            result['car_info'] = self.car_info
        if self.car_level is not None:
            result['car_level'] = self.car_level
        if self.corp_id is not None:
            result['corp_id'] = self.corp_id
        if self.corp_name is not None:
            result['corp_name'] = self.corp_name
        if self.cost_center_id is not None:
            result['cost_center_id'] = self.cost_center_id
        if self.cost_center_name is not None:
            result['cost_center_name'] = self.cost_center_name
        if self.cost_center_number is not None:
            result['cost_center_number'] = self.cost_center_number
        if self.dept_id is not None:
            result['dept_id'] = self.dept_id
        if self.dept_name is not None:
            result['dept_name'] = self.dept_name
        if self.driver_confirm_time is not None:
            result['driver_confirm_time'] = self.driver_confirm_time
        if self.estimate_price is not None:
            result['estimate_price'] = self.estimate_price
        if self.from_address is not None:
            result['from_address'] = self.from_address
        if self.from_city_ad_code is not None:
            result['from_city_ad_code'] = self.from_city_ad_code
        if self.from_city_name is not None:
            result['from_city_name'] = self.from_city_name
        if self.gmt_create is not None:
            result['gmt_create'] = self.gmt_create
        if self.gmt_modified is not None:
            result['gmt_modified'] = self.gmt_modified
        if self.id is not None:
            result['id'] = self.id
        if self.invoice_id is not None:
            result['invoice_id'] = self.invoice_id
        if self.invoice_title is not None:
            result['invoice_title'] = self.invoice_title
        if self.is_special is not None:
            result['is_special'] = self.is_special
        if self.memo is not None:
            result['memo'] = self.memo
        if self.order_id is not None:
            result['order_id'] = self.order_id
        if self.order_status is not None:
            result['order_status'] = self.order_status
        if self.passenger_name is not None:
            result['passenger_name'] = self.passenger_name
        if self.pay_time is not None:
            result['pay_time'] = self.pay_time
        result['price_info_list'] = []
        if self.price_info_list is not None:
            for k in self.price_info_list:
                result['price_info_list'].append(k.to_map() if k else None)
        if self.project_code is not None:
            result['project_code'] = self.project_code
        if self.project_id is not None:
            result['project_id'] = self.project_id
        if self.project_title is not None:
            result['project_title'] = self.project_title
        if self.provider is not None:
            result['provider'] = self.provider
        if self.publish_time is not None:
            result['publish_time'] = self.publish_time
        if self.real_from_address is not None:
            result['real_from_address'] = self.real_from_address
        if self.real_from_city_ad_code is not None:
            result['real_from_city_ad_code'] = self.real_from_city_ad_code
        if self.real_from_city_name is not None:
            result['real_from_city_name'] = self.real_from_city_name
        if self.real_to_address is not None:
            result['real_to_address'] = self.real_to_address
        if self.real_to_city_ad_code is not None:
            result['real_to_city_ad_code'] = self.real_to_city_ad_code
        if self.real_to_city_name is not None:
            result['real_to_city_name'] = self.real_to_city_name
        if self.service_type is not None:
            result['service_type'] = self.service_type
        if self.special_types is not None:
            result['special_types'] = self.special_types
        if self.taken_time is not None:
            result['taken_time'] = self.taken_time
        if self.thirdpart_apply_id is not None:
            result['thirdpart_apply_id'] = self.thirdpart_apply_id
        if self.thirdpart_business_id is not None:
            result['thirdpart_business_id'] = self.thirdpart_business_id
        if self.thirdpart_itinerary_id is not None:
            result['thirdpart_itinerary_id'] = self.thirdpart_itinerary_id
        if self.to_address is not None:
            result['to_address'] = self.to_address
        if self.to_city_ad_code is not None:
            result['to_city_ad_code'] = self.to_city_ad_code
        if self.to_city_name is not None:
            result['to_city_name'] = self.to_city_name
        if self.travel_distance is not None:
            result['travel_distance'] = self.travel_distance
        result['user_affiliate_list'] = []
        if self.user_affiliate_list is not None:
            for k in self.user_affiliate_list:
                result['user_affiliate_list'].append(k.to_map() if k else None)
        if self.user_confirm is not None:
            result['user_confirm'] = self.user_confirm
        if self.user_id is not None:
            result['user_id'] = self.user_id
        if self.user_name is not None:
            result['user_name'] = self.user_name
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('apply_id') is not None:
            self.apply_id = m.get('apply_id')
        if m.get('apply_show_id') is not None:
            self.apply_show_id = m.get('apply_show_id')
        if m.get('btrip_title') is not None:
            self.btrip_title = m.get('btrip_title')
        if m.get('business_category') is not None:
            self.business_category = m.get('business_category')
        if m.get('cancel_time') is not None:
            self.cancel_time = m.get('cancel_time')
        if m.get('car_info') is not None:
            self.car_info = m.get('car_info')
        if m.get('car_level') is not None:
            self.car_level = m.get('car_level')
        if m.get('corp_id') is not None:
            self.corp_id = m.get('corp_id')
        if m.get('corp_name') is not None:
            self.corp_name = m.get('corp_name')
        if m.get('cost_center_id') is not None:
            self.cost_center_id = m.get('cost_center_id')
        if m.get('cost_center_name') is not None:
            self.cost_center_name = m.get('cost_center_name')
        if m.get('cost_center_number') is not None:
            self.cost_center_number = m.get('cost_center_number')
        if m.get('dept_id') is not None:
            self.dept_id = m.get('dept_id')
        if m.get('dept_name') is not None:
            self.dept_name = m.get('dept_name')
        if m.get('driver_confirm_time') is not None:
            self.driver_confirm_time = m.get('driver_confirm_time')
        if m.get('estimate_price') is not None:
            self.estimate_price = m.get('estimate_price')
        if m.get('from_address') is not None:
            self.from_address = m.get('from_address')
        if m.get('from_city_ad_code') is not None:
            self.from_city_ad_code = m.get('from_city_ad_code')
        if m.get('from_city_name') is not None:
            self.from_city_name = m.get('from_city_name')
        if m.get('gmt_create') is not None:
            self.gmt_create = m.get('gmt_create')
        if m.get('gmt_modified') is not None:
            self.gmt_modified = m.get('gmt_modified')
        if m.get('id') is not None:
            self.id = m.get('id')
        if m.get('invoice_id') is not None:
            self.invoice_id = m.get('invoice_id')
        if m.get('invoice_title') is not None:
            self.invoice_title = m.get('invoice_title')
        if m.get('is_special') is not None:
            self.is_special = m.get('is_special')
        if m.get('memo') is not None:
            self.memo = m.get('memo')
        if m.get('order_id') is not None:
            self.order_id = m.get('order_id')
        if m.get('order_status') is not None:
            self.order_status = m.get('order_status')
        if m.get('passenger_name') is not None:
            self.passenger_name = m.get('passenger_name')
        if m.get('pay_time') is not None:
            self.pay_time = m.get('pay_time')
        self.price_info_list = []
        if m.get('price_info_list') is not None:
            for k in m.get('price_info_list'):
                temp_model = CarOrderListQueryResponseBodyModulePriceInfoList()
                self.price_info_list.append(temp_model.from_map(k))
        if m.get('project_code') is not None:
            self.project_code = m.get('project_code')
        if m.get('project_id') is not None:
            self.project_id = m.get('project_id')
        if m.get('project_title') is not None:
            self.project_title = m.get('project_title')
        if m.get('provider') is not None:
            self.provider = m.get('provider')
        if m.get('publish_time') is not None:
            self.publish_time = m.get('publish_time')
        if m.get('real_from_address') is not None:
            self.real_from_address = m.get('real_from_address')
        if m.get('real_from_city_ad_code') is not None:
            self.real_from_city_ad_code = m.get('real_from_city_ad_code')
        if m.get('real_from_city_name') is not None:
            self.real_from_city_name = m.get('real_from_city_name')
        if m.get('real_to_address') is not None:
            self.real_to_address = m.get('real_to_address')
        if m.get('real_to_city_ad_code') is not None:
            self.real_to_city_ad_code = m.get('real_to_city_ad_code')
        if m.get('real_to_city_name') is not None:
            self.real_to_city_name = m.get('real_to_city_name')
        if m.get('service_type') is not None:
            self.service_type = m.get('service_type')
        if m.get('special_types') is not None:
            self.special_types = m.get('special_types')
        if m.get('taken_time') is not None:
            self.taken_time = m.get('taken_time')
        if m.get('thirdpart_apply_id') is not None:
            self.thirdpart_apply_id = m.get('thirdpart_apply_id')
        if m.get('thirdpart_business_id') is not None:
            self.thirdpart_business_id = m.get('thirdpart_business_id')
        if m.get('thirdpart_itinerary_id') is not None:
            self.thirdpart_itinerary_id = m.get('thirdpart_itinerary_id')
        if m.get('to_address') is not None:
            self.to_address = m.get('to_address')
        if m.get('to_city_ad_code') is not None:
            self.to_city_ad_code = m.get('to_city_ad_code')
        if m.get('to_city_name') is not None:
            self.to_city_name = m.get('to_city_name')
        if m.get('travel_distance') is not None:
            self.travel_distance = m.get('travel_distance')
        self.user_affiliate_list = []
        if m.get('user_affiliate_list') is not None:
            for k in m.get('user_affiliate_list'):
                temp_model = CarOrderListQueryResponseBodyModuleUserAffiliateList()
                self.user_affiliate_list.append(temp_model.from_map(k))
        if m.get('user_confirm') is not None:
            self.user_confirm = m.get('user_confirm')
        if m.get('user_id') is not None:
            self.user_id = m.get('user_id')
        if m.get('user_name') is not None:
            self.user_name = m.get('user_name')
        return self


class CarOrderListQueryResponseBodyPageInfo(TeaModel):
    def __init__(
        self,
        page: int = None,
        page_size: int = None,
        total_number: int = None,
    ):
        self.page = page
        self.page_size = page_size
        self.total_number = total_number

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.page is not None:
            result['page'] = self.page
        if self.page_size is not None:
            result['page_size'] = self.page_size
        if self.total_number is not None:
            result['total_number'] = self.total_number
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('page') is not None:
            self.page = m.get('page')
        if m.get('page_size') is not None:
            self.page_size = m.get('page_size')
        if m.get('total_number') is not None:
            self.total_number = m.get('total_number')
        return self


class CarOrderListQueryResponseBody(TeaModel):
    def __init__(
        self,
        code: str = None,
        message: str = None,
        module: List[CarOrderListQueryResponseBodyModule] = None,
        page_info: CarOrderListQueryResponseBodyPageInfo = None,
        request_id: str = None,
        success: bool = None,
        trace_id: str = None,
    ):
        self.code = code
        self.message = message
        self.module = module
        self.page_info = page_info
        self.request_id = request_id
        self.success = success
        # traceId
        self.trace_id = trace_id

    def validate(self):
        if self.module:
            for k in self.module:
                if k:
                    k.validate()
        if self.page_info:
            self.page_info.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['code'] = self.code
        if self.message is not None:
            result['message'] = self.message
        result['module'] = []
        if self.module is not None:
            for k in self.module:
                result['module'].append(k.to_map() if k else None)
        if self.page_info is not None:
            result['page_info'] = self.page_info.to_map()
        if self.request_id is not None:
            result['requestId'] = self.request_id
        if self.success is not None:
            result['success'] = self.success
        if self.trace_id is not None:
            result['traceId'] = self.trace_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('code') is not None:
            self.code = m.get('code')
        if m.get('message') is not None:
            self.message = m.get('message')
        self.module = []
        if m.get('module') is not None:
            for k in m.get('module'):
                temp_model = CarOrderListQueryResponseBodyModule()
                self.module.append(temp_model.from_map(k))
        if m.get('page_info') is not None:
            temp_model = CarOrderListQueryResponseBodyPageInfo()
            self.page_info = temp_model.from_map(m['page_info'])
        if m.get('requestId') is not None:
            self.request_id = m.get('requestId')
        if m.get('success') is not None:
            self.success = m.get('success')
        if m.get('traceId') is not None:
            self.trace_id = m.get('traceId')
        return self


class CarOrderListQueryResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: CarOrderListQueryResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = CarOrderListQueryResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CarOrderQueryHeaders(TeaModel):
    def __init__(
        self,
        common_headers: Dict[str, str] = None,
        x_acs_btrip_so_corp_token: str = None,
    ):
        self.common_headers = common_headers
        self.x_acs_btrip_so_corp_token = x_acs_btrip_so_corp_token

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.common_headers is not None:
            result['commonHeaders'] = self.common_headers
        if self.x_acs_btrip_so_corp_token is not None:
            result['x-acs-btrip-so-corp-token'] = self.x_acs_btrip_so_corp_token
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('commonHeaders') is not None:
            self.common_headers = m.get('commonHeaders')
        if m.get('x-acs-btrip-so-corp-token') is not None:
            self.x_acs_btrip_so_corp_token = m.get('x-acs-btrip-so-corp-token')
        return self


class CarOrderQueryRequest(TeaModel):
    def __init__(
        self,
        order_id: int = None,
        sub_order_id: int = None,
    ):
        self.order_id = order_id
        self.sub_order_id = sub_order_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.order_id is not None:
            result['order_id'] = self.order_id
        if self.sub_order_id is not None:
            result['sub_order_id'] = self.sub_order_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('order_id') is not None:
            self.order_id = m.get('order_id')
        if m.get('sub_order_id') is not None:
            self.sub_order_id = m.get('sub_order_id')
        return self


class CarOrderQueryResponseBodyModuleCarInfoWayPoints(TeaModel):
    def __init__(
        self,
        address: str = None,
        index: str = None,
        latitude: str = None,
        longitude: str = None,
    ):
        self.address = address
        self.index = index
        self.latitude = latitude
        self.longitude = longitude

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.address is not None:
            result['address'] = self.address
        if self.index is not None:
            result['index'] = self.index
        if self.latitude is not None:
            result['latitude'] = self.latitude
        if self.longitude is not None:
            result['longitude'] = self.longitude
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('address') is not None:
            self.address = m.get('address')
        if m.get('index') is not None:
            self.index = m.get('index')
        if m.get('latitude') is not None:
            self.latitude = m.get('latitude')
        if m.get('longitude') is not None:
            self.longitude = m.get('longitude')
        return self


class CarOrderQueryResponseBodyModuleCarInfo(TeaModel):
    def __init__(
        self,
        business_category: str = None,
        cancel_time: int = None,
        car_info: str = None,
        car_level: int = None,
        driver_card: str = None,
        driver_confirm_time: int = None,
        driver_name: str = None,
        estimate_price: int = None,
        from_address: str = None,
        from_city_ad_code: str = None,
        from_city_name: str = None,
        is_special: bool = None,
        memo: str = None,
        pay_time: int = None,
        publish_time: int = None,
        real_from_address: str = None,
        real_from_city_ad_code: str = None,
        real_from_city_name: str = None,
        real_to_address: str = None,
        real_to_city_ad_code: str = None,
        real_to_city_name: str = None,
        service_type: int = None,
        special_types: str = None,
        taken_time: int = None,
        to_address: str = None,
        to_city_ad_code: str = None,
        to_city_name: str = None,
        travel_distance: str = None,
        way_points: List[CarOrderQueryResponseBodyModuleCarInfoWayPoints] = None,
    ):
        self.business_category = business_category
        self.cancel_time = cancel_time
        self.car_info = car_info
        self.car_level = car_level
        self.driver_card = driver_card
        self.driver_confirm_time = driver_confirm_time
        self.driver_name = driver_name
        self.estimate_price = estimate_price
        self.from_address = from_address
        self.from_city_ad_code = from_city_ad_code
        self.from_city_name = from_city_name
        self.is_special = is_special
        self.memo = memo
        self.pay_time = pay_time
        self.publish_time = publish_time
        self.real_from_address = real_from_address
        self.real_from_city_ad_code = real_from_city_ad_code
        self.real_from_city_name = real_from_city_name
        self.real_to_address = real_to_address
        self.real_to_city_ad_code = real_to_city_ad_code
        self.real_to_city_name = real_to_city_name
        self.service_type = service_type
        self.special_types = special_types
        self.taken_time = taken_time
        self.to_address = to_address
        self.to_city_ad_code = to_city_ad_code
        self.to_city_name = to_city_name
        self.travel_distance = travel_distance
        self.way_points = way_points

    def validate(self):
        if self.way_points:
            for k in self.way_points:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.business_category is not None:
            result['business_category'] = self.business_category
        if self.cancel_time is not None:
            result['cancel_time'] = self.cancel_time
        if self.car_info is not None:
            result['car_info'] = self.car_info
        if self.car_level is not None:
            result['car_level'] = self.car_level
        if self.driver_card is not None:
            result['driver_card'] = self.driver_card
        if self.driver_confirm_time is not None:
            result['driver_confirm_time'] = self.driver_confirm_time
        if self.driver_name is not None:
            result['driver_name'] = self.driver_name
        if self.estimate_price is not None:
            result['estimate_price'] = self.estimate_price
        if self.from_address is not None:
            result['from_address'] = self.from_address
        if self.from_city_ad_code is not None:
            result['from_city_ad_code'] = self.from_city_ad_code
        if self.from_city_name is not None:
            result['from_city_name'] = self.from_city_name
        if self.is_special is not None:
            result['is_special'] = self.is_special
        if self.memo is not None:
            result['memo'] = self.memo
        if self.pay_time is not None:
            result['pay_time'] = self.pay_time
        if self.publish_time is not None:
            result['publish_time'] = self.publish_time
        if self.real_from_address is not None:
            result['real_from_address'] = self.real_from_address
        if self.real_from_city_ad_code is not None:
            result['real_from_city_ad_code'] = self.real_from_city_ad_code
        if self.real_from_city_name is not None:
            result['real_from_city_name'] = self.real_from_city_name
        if self.real_to_address is not None:
            result['real_to_address'] = self.real_to_address
        if self.real_to_city_ad_code is not None:
            result['real_to_city_ad_code'] = self.real_to_city_ad_code
        if self.real_to_city_name is not None:
            result['real_to_city_name'] = self.real_to_city_name
        if self.service_type is not None:
            result['service_type'] = self.service_type
        if self.special_types is not None:
            result['special_types'] = self.special_types
        if self.taken_time is not None:
            result['taken_time'] = self.taken_time
        if self.to_address is not None:
            result['to_address'] = self.to_address
        if self.to_city_ad_code is not None:
            result['to_city_ad_code'] = self.to_city_ad_code
        if self.to_city_name is not None:
            result['to_city_name'] = self.to_city_name
        if self.travel_distance is not None:
            result['travel_distance'] = self.travel_distance
        result['way_points'] = []
        if self.way_points is not None:
            for k in self.way_points:
                result['way_points'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('business_category') is not None:
            self.business_category = m.get('business_category')
        if m.get('cancel_time') is not None:
            self.cancel_time = m.get('cancel_time')
        if m.get('car_info') is not None:
            self.car_info = m.get('car_info')
        if m.get('car_level') is not None:
            self.car_level = m.get('car_level')
        if m.get('driver_card') is not None:
            self.driver_card = m.get('driver_card')
        if m.get('driver_confirm_time') is not None:
            self.driver_confirm_time = m.get('driver_confirm_time')
        if m.get('driver_name') is not None:
            self.driver_name = m.get('driver_name')
        if m.get('estimate_price') is not None:
            self.estimate_price = m.get('estimate_price')
        if m.get('from_address') is not None:
            self.from_address = m.get('from_address')
        if m.get('from_city_ad_code') is not None:
            self.from_city_ad_code = m.get('from_city_ad_code')
        if m.get('from_city_name') is not None:
            self.from_city_name = m.get('from_city_name')
        if m.get('is_special') is not None:
            self.is_special = m.get('is_special')
        if m.get('memo') is not None:
            self.memo = m.get('memo')
        if m.get('pay_time') is not None:
            self.pay_time = m.get('pay_time')
        if m.get('publish_time') is not None:
            self.publish_time = m.get('publish_time')
        if m.get('real_from_address') is not None:
            self.real_from_address = m.get('real_from_address')
        if m.get('real_from_city_ad_code') is not None:
            self.real_from_city_ad_code = m.get('real_from_city_ad_code')
        if m.get('real_from_city_name') is not None:
            self.real_from_city_name = m.get('real_from_city_name')
        if m.get('real_to_address') is not None:
            self.real_to_address = m.get('real_to_address')
        if m.get('real_to_city_ad_code') is not None:
            self.real_to_city_ad_code = m.get('real_to_city_ad_code')
        if m.get('real_to_city_name') is not None:
            self.real_to_city_name = m.get('real_to_city_name')
        if m.get('service_type') is not None:
            self.service_type = m.get('service_type')
        if m.get('special_types') is not None:
            self.special_types = m.get('special_types')
        if m.get('taken_time') is not None:
            self.taken_time = m.get('taken_time')
        if m.get('to_address') is not None:
            self.to_address = m.get('to_address')
        if m.get('to_city_ad_code') is not None:
            self.to_city_ad_code = m.get('to_city_ad_code')
        if m.get('to_city_name') is not None:
            self.to_city_name = m.get('to_city_name')
        if m.get('travel_distance') is not None:
            self.travel_distance = m.get('travel_distance')
        self.way_points = []
        if m.get('way_points') is not None:
            for k in m.get('way_points'):
                temp_model = CarOrderQueryResponseBodyModuleCarInfoWayPoints()
                self.way_points.append(temp_model.from_map(k))
        return self


class CarOrderQueryResponseBodyModuleInvoiceInfo(TeaModel):
    def __init__(
        self,
        id: int = None,
        title: str = None,
    ):
        self.id = id
        self.title = title

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.id is not None:
            result['id'] = self.id
        if self.title is not None:
            result['title'] = self.title
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('id') is not None:
            self.id = m.get('id')
        if m.get('title') is not None:
            self.title = m.get('title')
        return self


class CarOrderQueryResponseBodyModuleOrderBaseInfo(TeaModel):
    def __init__(
        self,
        apply_id: str = None,
        btrip_cause: str = None,
        btrip_title: str = None,
        corp_id: str = None,
        corp_name: str = None,
        depart_id: str = None,
        depart_name: str = None,
        gmt_create: int = None,
        gmt_modified: int = None,
        itinerary_id: str = None,
        order_id: int = None,
        order_status: int = None,
        sub_order_id: int = None,
        third_depart_id: str = None,
        thirdpart_apply_id: str = None,
        thirdpart_business_id: str = None,
        thirdpart_itinerary_id: str = None,
        user_id: str = None,
        user_name: str = None,
    ):
        self.apply_id = apply_id
        self.btrip_cause = btrip_cause
        self.btrip_title = btrip_title
        self.corp_id = corp_id
        self.corp_name = corp_name
        self.depart_id = depart_id
        self.depart_name = depart_name
        self.gmt_create = gmt_create
        self.gmt_modified = gmt_modified
        self.itinerary_id = itinerary_id
        self.order_id = order_id
        self.order_status = order_status
        self.sub_order_id = sub_order_id
        self.third_depart_id = third_depart_id
        self.thirdpart_apply_id = thirdpart_apply_id
        self.thirdpart_business_id = thirdpart_business_id
        self.thirdpart_itinerary_id = thirdpart_itinerary_id
        self.user_id = user_id
        self.user_name = user_name

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.apply_id is not None:
            result['apply_id'] = self.apply_id
        if self.btrip_cause is not None:
            result['btrip_cause'] = self.btrip_cause
        if self.btrip_title is not None:
            result['btrip_title'] = self.btrip_title
        if self.corp_id is not None:
            result['corp_id'] = self.corp_id
        if self.corp_name is not None:
            result['corp_name'] = self.corp_name
        if self.depart_id is not None:
            result['depart_id'] = self.depart_id
        if self.depart_name is not None:
            result['depart_name'] = self.depart_name
        if self.gmt_create is not None:
            result['gmt_create'] = self.gmt_create
        if self.gmt_modified is not None:
            result['gmt_modified'] = self.gmt_modified
        if self.itinerary_id is not None:
            result['itinerary_id'] = self.itinerary_id
        if self.order_id is not None:
            result['order_id'] = self.order_id
        if self.order_status is not None:
            result['order_status'] = self.order_status
        if self.sub_order_id is not None:
            result['sub_order_id'] = self.sub_order_id
        if self.third_depart_id is not None:
            result['third_depart_id'] = self.third_depart_id
        if self.thirdpart_apply_id is not None:
            result['thirdpart_apply_id'] = self.thirdpart_apply_id
        if self.thirdpart_business_id is not None:
            result['thirdpart_business_id'] = self.thirdpart_business_id
        if self.thirdpart_itinerary_id is not None:
            result['thirdpart_itinerary_id'] = self.thirdpart_itinerary_id
        if self.user_id is not None:
            result['user_id'] = self.user_id
        if self.user_name is not None:
            result['user_name'] = self.user_name
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('apply_id') is not None:
            self.apply_id = m.get('apply_id')
        if m.get('btrip_cause') is not None:
            self.btrip_cause = m.get('btrip_cause')
        if m.get('btrip_title') is not None:
            self.btrip_title = m.get('btrip_title')
        if m.get('corp_id') is not None:
            self.corp_id = m.get('corp_id')
        if m.get('corp_name') is not None:
            self.corp_name = m.get('corp_name')
        if m.get('depart_id') is not None:
            self.depart_id = m.get('depart_id')
        if m.get('depart_name') is not None:
            self.depart_name = m.get('depart_name')
        if m.get('gmt_create') is not None:
            self.gmt_create = m.get('gmt_create')
        if m.get('gmt_modified') is not None:
            self.gmt_modified = m.get('gmt_modified')
        if m.get('itinerary_id') is not None:
            self.itinerary_id = m.get('itinerary_id')
        if m.get('order_id') is not None:
            self.order_id = m.get('order_id')
        if m.get('order_status') is not None:
            self.order_status = m.get('order_status')
        if m.get('sub_order_id') is not None:
            self.sub_order_id = m.get('sub_order_id')
        if m.get('third_depart_id') is not None:
            self.third_depart_id = m.get('third_depart_id')
        if m.get('thirdpart_apply_id') is not None:
            self.thirdpart_apply_id = m.get('thirdpart_apply_id')
        if m.get('thirdpart_business_id') is not None:
            self.thirdpart_business_id = m.get('thirdpart_business_id')
        if m.get('thirdpart_itinerary_id') is not None:
            self.thirdpart_itinerary_id = m.get('thirdpart_itinerary_id')
        if m.get('user_id') is not None:
            self.user_id = m.get('user_id')
        if m.get('user_name') is not None:
            self.user_name = m.get('user_name')
        return self


class CarOrderQueryResponseBodyModulePassengerList(TeaModel):
    def __init__(
        self,
        cost_center_id: int = None,
        cost_center_name: str = None,
        cost_center_number: str = None,
        project_code: str = None,
        project_id: int = None,
        project_title: str = None,
        thirdpart_cost_center_id: str = None,
        thirdpart_project_id: str = None,
        user_id: str = None,
        user_name: str = None,
        user_type: int = None,
    ):
        self.cost_center_id = cost_center_id
        self.cost_center_name = cost_center_name
        self.cost_center_number = cost_center_number
        self.project_code = project_code
        self.project_id = project_id
        self.project_title = project_title
        self.thirdpart_cost_center_id = thirdpart_cost_center_id
        self.thirdpart_project_id = thirdpart_project_id
        self.user_id = user_id
        self.user_name = user_name
        self.user_type = user_type

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.cost_center_id is not None:
            result['cost_center_id'] = self.cost_center_id
        if self.cost_center_name is not None:
            result['cost_center_name'] = self.cost_center_name
        if self.cost_center_number is not None:
            result['cost_center_number'] = self.cost_center_number
        if self.project_code is not None:
            result['project_code'] = self.project_code
        if self.project_id is not None:
            result['project_id'] = self.project_id
        if self.project_title is not None:
            result['project_title'] = self.project_title
        if self.thirdpart_cost_center_id is not None:
            result['thirdpart_cost_center_id'] = self.thirdpart_cost_center_id
        if self.thirdpart_project_id is not None:
            result['thirdpart_project_id'] = self.thirdpart_project_id
        if self.user_id is not None:
            result['user_id'] = self.user_id
        if self.user_name is not None:
            result['user_name'] = self.user_name
        if self.user_type is not None:
            result['user_type'] = self.user_type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('cost_center_id') is not None:
            self.cost_center_id = m.get('cost_center_id')
        if m.get('cost_center_name') is not None:
            self.cost_center_name = m.get('cost_center_name')
        if m.get('cost_center_number') is not None:
            self.cost_center_number = m.get('cost_center_number')
        if m.get('project_code') is not None:
            self.project_code = m.get('project_code')
        if m.get('project_id') is not None:
            self.project_id = m.get('project_id')
        if m.get('project_title') is not None:
            self.project_title = m.get('project_title')
        if m.get('thirdpart_cost_center_id') is not None:
            self.thirdpart_cost_center_id = m.get('thirdpart_cost_center_id')
        if m.get('thirdpart_project_id') is not None:
            self.thirdpart_project_id = m.get('thirdpart_project_id')
        if m.get('user_id') is not None:
            self.user_id = m.get('user_id')
        if m.get('user_name') is not None:
            self.user_name = m.get('user_name')
        if m.get('user_type') is not None:
            self.user_type = m.get('user_type')
        return self


class CarOrderQueryResponseBodyModulePriceInfoList(TeaModel):
    def __init__(
        self,
        category_code: int = None,
        gmt_create: int = None,
        pay_type: int = None,
        person_price: int = None,
        price: int = None,
        trade_id: str = None,
        type: int = None,
    ):
        self.category_code = category_code
        self.gmt_create = gmt_create
        self.pay_type = pay_type
        self.person_price = person_price
        self.price = price
        self.trade_id = trade_id
        self.type = type

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.category_code is not None:
            result['category_code'] = self.category_code
        if self.gmt_create is not None:
            result['gmt_create'] = self.gmt_create
        if self.pay_type is not None:
            result['pay_type'] = self.pay_type
        if self.person_price is not None:
            result['person_price'] = self.person_price
        if self.price is not None:
            result['price'] = self.price
        if self.trade_id is not None:
            result['trade_id'] = self.trade_id
        if self.type is not None:
            result['type'] = self.type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('category_code') is not None:
            self.category_code = m.get('category_code')
        if m.get('gmt_create') is not None:
            self.gmt_create = m.get('gmt_create')
        if m.get('pay_type') is not None:
            self.pay_type = m.get('pay_type')
        if m.get('person_price') is not None:
            self.person_price = m.get('person_price')
        if m.get('price') is not None:
            self.price = m.get('price')
        if m.get('trade_id') is not None:
            self.trade_id = m.get('trade_id')
        if m.get('type') is not None:
            self.type = m.get('type')
        return self


class CarOrderQueryResponseBodyModule(TeaModel):
    def __init__(
        self,
        car_info: CarOrderQueryResponseBodyModuleCarInfo = None,
        invoice_info: CarOrderQueryResponseBodyModuleInvoiceInfo = None,
        order_base_info: CarOrderQueryResponseBodyModuleOrderBaseInfo = None,
        passenger_list: List[CarOrderQueryResponseBodyModulePassengerList] = None,
        price_info_list: List[CarOrderQueryResponseBodyModulePriceInfoList] = None,
    ):
        self.car_info = car_info
        self.invoice_info = invoice_info
        self.order_base_info = order_base_info
        self.passenger_list = passenger_list
        self.price_info_list = price_info_list

    def validate(self):
        if self.car_info:
            self.car_info.validate()
        if self.invoice_info:
            self.invoice_info.validate()
        if self.order_base_info:
            self.order_base_info.validate()
        if self.passenger_list:
            for k in self.passenger_list:
                if k:
                    k.validate()
        if self.price_info_list:
            for k in self.price_info_list:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.car_info is not None:
            result['car_info'] = self.car_info.to_map()
        if self.invoice_info is not None:
            result['invoice_info'] = self.invoice_info.to_map()
        if self.order_base_info is not None:
            result['order_base_info'] = self.order_base_info.to_map()
        result['passenger_list'] = []
        if self.passenger_list is not None:
            for k in self.passenger_list:
                result['passenger_list'].append(k.to_map() if k else None)
        result['price_info_list'] = []
        if self.price_info_list is not None:
            for k in self.price_info_list:
                result['price_info_list'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('car_info') is not None:
            temp_model = CarOrderQueryResponseBodyModuleCarInfo()
            self.car_info = temp_model.from_map(m['car_info'])
        if m.get('invoice_info') is not None:
            temp_model = CarOrderQueryResponseBodyModuleInvoiceInfo()
            self.invoice_info = temp_model.from_map(m['invoice_info'])
        if m.get('order_base_info') is not None:
            temp_model = CarOrderQueryResponseBodyModuleOrderBaseInfo()
            self.order_base_info = temp_model.from_map(m['order_base_info'])
        self.passenger_list = []
        if m.get('passenger_list') is not None:
            for k in m.get('passenger_list'):
                temp_model = CarOrderQueryResponseBodyModulePassengerList()
                self.passenger_list.append(temp_model.from_map(k))
        self.price_info_list = []
        if m.get('price_info_list') is not None:
            for k in m.get('price_info_list'):
                temp_model = CarOrderQueryResponseBodyModulePriceInfoList()
                self.price_info_list.append(temp_model.from_map(k))
        return self


class CarOrderQueryResponseBody(TeaModel):
    def __init__(
        self,
        code: str = None,
        message: str = None,
        module: CarOrderQueryResponseBodyModule = None,
        request_id: str = None,
        success: bool = None,
        trace_id: str = None,
    ):
        self.code = code
        self.message = message
        self.module = module
        # requestId
        self.request_id = request_id
        self.success = success
        # traceId
        self.trace_id = trace_id

    def validate(self):
        if self.module:
            self.module.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['code'] = self.code
        if self.message is not None:
            result['message'] = self.message
        if self.module is not None:
            result['module'] = self.module.to_map()
        if self.request_id is not None:
            result['requestId'] = self.request_id
        if self.success is not None:
            result['success'] = self.success
        if self.trace_id is not None:
            result['traceId'] = self.trace_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('code') is not None:
            self.code = m.get('code')
        if m.get('message') is not None:
            self.message = m.get('message')
        if m.get('module') is not None:
            temp_model = CarOrderQueryResponseBodyModule()
            self.module = temp_model.from_map(m['module'])
        if m.get('requestId') is not None:
            self.request_id = m.get('requestId')
        if m.get('success') is not None:
            self.success = m.get('success')
        if m.get('traceId') is not None:
            self.trace_id = m.get('traceId')
        return self


class CarOrderQueryResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: CarOrderQueryResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = CarOrderQueryResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CarSceneQueryHeaders(TeaModel):
    def __init__(
        self,
        common_headers: Dict[str, str] = None,
        x_acs_btrip_corp_token: str = None,
    ):
        self.common_headers = common_headers
        self.x_acs_btrip_corp_token = x_acs_btrip_corp_token

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.common_headers is not None:
            result['commonHeaders'] = self.common_headers
        if self.x_acs_btrip_corp_token is not None:
            result['x-acs-btrip-corp-token'] = self.x_acs_btrip_corp_token
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('commonHeaders') is not None:
            self.common_headers = m.get('commonHeaders')
        if m.get('x-acs-btrip-corp-token') is not None:
            self.x_acs_btrip_corp_token = m.get('x-acs-btrip-corp-token')
        return self


class CarSceneQueryResponseBodyModule(TeaModel):
    def __init__(
        self,
        scenario_template_id: str = None,
        scenario_template_name: str = None,
        state: str = None,
    ):
        self.scenario_template_id = scenario_template_id
        self.scenario_template_name = scenario_template_name
        self.state = state

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.scenario_template_id is not None:
            result['scenarioTemplateId'] = self.scenario_template_id
        if self.scenario_template_name is not None:
            result['scenarioTemplateName'] = self.scenario_template_name
        if self.state is not None:
            result['state'] = self.state
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('scenarioTemplateId') is not None:
            self.scenario_template_id = m.get('scenarioTemplateId')
        if m.get('scenarioTemplateName') is not None:
            self.scenario_template_name = m.get('scenarioTemplateName')
        if m.get('state') is not None:
            self.state = m.get('state')
        return self


class CarSceneQueryResponseBody(TeaModel):
    def __init__(
        self,
        code: str = None,
        message: str = None,
        module: List[CarSceneQueryResponseBodyModule] = None,
        request_id: str = None,
        success: bool = None,
        trace_id: str = None,
    ):
        self.code = code
        self.message = message
        self.module = module
        self.request_id = request_id
        self.success = success
        # traceId
        self.trace_id = trace_id

    def validate(self):
        if self.module:
            for k in self.module:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['code'] = self.code
        if self.message is not None:
            result['message'] = self.message
        result['module'] = []
        if self.module is not None:
            for k in self.module:
                result['module'].append(k.to_map() if k else None)
        if self.request_id is not None:
            result['requestId'] = self.request_id
        if self.success is not None:
            result['success'] = self.success
        if self.trace_id is not None:
            result['traceId'] = self.trace_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('code') is not None:
            self.code = m.get('code')
        if m.get('message') is not None:
            self.message = m.get('message')
        self.module = []
        if m.get('module') is not None:
            for k in m.get('module'):
                temp_model = CarSceneQueryResponseBodyModule()
                self.module.append(temp_model.from_map(k))
        if m.get('requestId') is not None:
            self.request_id = m.get('requestId')
        if m.get('success') is not None:
            self.success = m.get('success')
        if m.get('traceId') is not None:
            self.trace_id = m.get('traceId')
        return self


class CarSceneQueryResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: CarSceneQueryResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = CarSceneQueryResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class ChannelCorpCreateHeaders(TeaModel):
    def __init__(
        self,
        common_headers: Dict[str, str] = None,
        x_acs_btrip_corp_token: str = None,
    ):
        self.common_headers = common_headers
        self.x_acs_btrip_corp_token = x_acs_btrip_corp_token

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.common_headers is not None:
            result['commonHeaders'] = self.common_headers
        if self.x_acs_btrip_corp_token is not None:
            result['x-acs-btrip-corp-token'] = self.x_acs_btrip_corp_token
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('commonHeaders') is not None:
            self.common_headers = m.get('commonHeaders')
        if m.get('x-acs-btrip-corp-token') is not None:
            self.x_acs_btrip_corp_token = m.get('x-acs-btrip-corp-token')
        return self


class ChannelCorpCreateRequest(TeaModel):
    def __init__(
        self,
        administrator_name: str = None,
        administrator_phone: str = None,
        city: str = None,
        corp_name: str = None,
        province: str = None,
        scope: int = None,
        third_corp_id: str = None,
        user_id: str = None,
    ):
        # This parameter is required.
        self.administrator_name = administrator_name
        # This parameter is required.
        self.administrator_phone = administrator_phone
        self.city = city
        # This parameter is required.
        self.corp_name = corp_name
        self.province = province
        self.scope = scope
        # This parameter is required.
        self.third_corp_id = third_corp_id
        self.user_id = user_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.administrator_name is not None:
            result['administrator_name'] = self.administrator_name
        if self.administrator_phone is not None:
            result['administrator_phone'] = self.administrator_phone
        if self.city is not None:
            result['city'] = self.city
        if self.corp_name is not None:
            result['corp_name'] = self.corp_name
        if self.province is not None:
            result['province'] = self.province
        if self.scope is not None:
            result['scope'] = self.scope
        if self.third_corp_id is not None:
            result['third_corp_id'] = self.third_corp_id
        if self.user_id is not None:
            result['user_id'] = self.user_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('administrator_name') is not None:
            self.administrator_name = m.get('administrator_name')
        if m.get('administrator_phone') is not None:
            self.administrator_phone = m.get('administrator_phone')
        if m.get('city') is not None:
            self.city = m.get('city')
        if m.get('corp_name') is not None:
            self.corp_name = m.get('corp_name')
        if m.get('province') is not None:
            self.province = m.get('province')
        if m.get('scope') is not None:
            self.scope = m.get('scope')
        if m.get('third_corp_id') is not None:
            self.third_corp_id = m.get('third_corp_id')
        if m.get('user_id') is not None:
            self.user_id = m.get('user_id')
        return self


class ChannelCorpCreateResponseBodyModule(TeaModel):
    def __init__(
        self,
        administrator_name: str = None,
        administrator_phone: str = None,
        corp_id: str = None,
        corp_name: str = None,
        open_agent_id: str = None,
        user_id: str = None,
    ):
        self.administrator_name = administrator_name
        self.administrator_phone = administrator_phone
        self.corp_id = corp_id
        self.corp_name = corp_name
        self.open_agent_id = open_agent_id
        self.user_id = user_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.administrator_name is not None:
            result['administrator_name'] = self.administrator_name
        if self.administrator_phone is not None:
            result['administrator_phone'] = self.administrator_phone
        if self.corp_id is not None:
            result['corp_id'] = self.corp_id
        if self.corp_name is not None:
            result['corp_name'] = self.corp_name
        if self.open_agent_id is not None:
            result['open_agent_id'] = self.open_agent_id
        if self.user_id is not None:
            result['user_id'] = self.user_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('administrator_name') is not None:
            self.administrator_name = m.get('administrator_name')
        if m.get('administrator_phone') is not None:
            self.administrator_phone = m.get('administrator_phone')
        if m.get('corp_id') is not None:
            self.corp_id = m.get('corp_id')
        if m.get('corp_name') is not None:
            self.corp_name = m.get('corp_name')
        if m.get('open_agent_id') is not None:
            self.open_agent_id = m.get('open_agent_id')
        if m.get('user_id') is not None:
            self.user_id = m.get('user_id')
        return self


class ChannelCorpCreateResponseBody(TeaModel):
    def __init__(
        self,
        code: str = None,
        message: str = None,
        module: ChannelCorpCreateResponseBodyModule = None,
        request_id: str = None,
        success: bool = None,
        trace_id: str = None,
    ):
        self.code = code
        self.message = message
        self.module = module
        self.request_id = request_id
        self.success = success
        self.trace_id = trace_id

    def validate(self):
        if self.module:
            self.module.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['code'] = self.code
        if self.message is not None:
            result['message'] = self.message
        if self.module is not None:
            result['module'] = self.module.to_map()
        if self.request_id is not None:
            result['requestId'] = self.request_id
        if self.success is not None:
            result['success'] = self.success
        if self.trace_id is not None:
            result['traceId'] = self.trace_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('code') is not None:
            self.code = m.get('code')
        if m.get('message') is not None:
            self.message = m.get('message')
        if m.get('module') is not None:
            temp_model = ChannelCorpCreateResponseBodyModule()
            self.module = temp_model.from_map(m['module'])
        if m.get('requestId') is not None:
            self.request_id = m.get('requestId')
        if m.get('success') is not None:
            self.success = m.get('success')
        if m.get('traceId') is not None:
            self.trace_id = m.get('traceId')
        return self


class ChannelCorpCreateResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: ChannelCorpCreateResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = ChannelCorpCreateResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CitySearchHeaders(TeaModel):
    def __init__(
        self,
        common_headers: Dict[str, str] = None,
        x_acs_btrip_so_corp_token: str = None,
    ):
        self.common_headers = common_headers
        self.x_acs_btrip_so_corp_token = x_acs_btrip_so_corp_token

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.common_headers is not None:
            result['commonHeaders'] = self.common_headers
        if self.x_acs_btrip_so_corp_token is not None:
            result['x-acs-btrip-so-corp-token'] = self.x_acs_btrip_so_corp_token
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('commonHeaders') is not None:
            self.common_headers = m.get('commonHeaders')
        if m.get('x-acs-btrip-so-corp-token') is not None:
            self.x_acs_btrip_so_corp_token = m.get('x-acs-btrip-so-corp-token')
        return self


class CitySearchRequest(TeaModel):
    def __init__(
        self,
        keyword: str = None,
    ):
        # This parameter is required.
        self.keyword = keyword

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.keyword is not None:
            result['keyword'] = self.keyword
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('keyword') is not None:
            self.keyword = m.get('keyword')
        return self


class CitySearchResponseBodyModuleCities(TeaModel):
    def __init__(
        self,
        code: str = None,
        name: str = None,
        region: int = None,
    ):
        self.code = code
        self.name = name
        self.region = region

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['code'] = self.code
        if self.name is not None:
            result['name'] = self.name
        if self.region is not None:
            result['region'] = self.region
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('code') is not None:
            self.code = m.get('code')
        if m.get('name') is not None:
            self.name = m.get('name')
        if m.get('region') is not None:
            self.region = m.get('region')
        return self


class CitySearchResponseBodyModule(TeaModel):
    def __init__(
        self,
        cities: List[CitySearchResponseBodyModuleCities] = None,
    ):
        self.cities = cities

    def validate(self):
        if self.cities:
            for k in self.cities:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['cities'] = []
        if self.cities is not None:
            for k in self.cities:
                result['cities'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.cities = []
        if m.get('cities') is not None:
            for k in m.get('cities'):
                temp_model = CitySearchResponseBodyModuleCities()
                self.cities.append(temp_model.from_map(k))
        return self


class CitySearchResponseBody(TeaModel):
    def __init__(
        self,
        code: str = None,
        message: str = None,
        module: CitySearchResponseBodyModule = None,
        request_id: str = None,
        success: bool = None,
        trace_id: str = None,
    ):
        self.code = code
        self.message = message
        # module
        self.module = module
        self.request_id = request_id
        self.success = success
        self.trace_id = trace_id

    def validate(self):
        if self.module:
            self.module.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['code'] = self.code
        if self.message is not None:
            result['message'] = self.message
        if self.module is not None:
            result['module'] = self.module.to_map()
        if self.request_id is not None:
            result['requestId'] = self.request_id
        if self.success is not None:
            result['success'] = self.success
        if self.trace_id is not None:
            result['traceId'] = self.trace_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('code') is not None:
            self.code = m.get('code')
        if m.get('message') is not None:
            self.message = m.get('message')
        if m.get('module') is not None:
            temp_model = CitySearchResponseBodyModule()
            self.module = temp_model.from_map(m['module'])
        if m.get('requestId') is not None:
            self.request_id = m.get('requestId')
        if m.get('success') is not None:
            self.success = m.get('success')
        if m.get('traceId') is not None:
            self.trace_id = m.get('traceId')
        return self


class CitySearchResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: CitySearchResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = CitySearchResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CommonApplyQueryHeaders(TeaModel):
    def __init__(
        self,
        common_headers: Dict[str, str] = None,
        x_acs_btrip_so_corp_token: str = None,
    ):
        self.common_headers = common_headers
        self.x_acs_btrip_so_corp_token = x_acs_btrip_so_corp_token

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.common_headers is not None:
            result['commonHeaders'] = self.common_headers
        if self.x_acs_btrip_so_corp_token is not None:
            result['x-acs-btrip-so-corp-token'] = self.x_acs_btrip_so_corp_token
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('commonHeaders') is not None:
            self.common_headers = m.get('commonHeaders')
        if m.get('x-acs-btrip-so-corp-token') is not None:
            self.x_acs_btrip_so_corp_token = m.get('x-acs-btrip-so-corp-token')
        return self


class CommonApplyQueryRequest(TeaModel):
    def __init__(
        self,
        apply_id: int = None,
        biz_category: int = None,
        business_instance_id: str = None,
        user_id: str = None,
    ):
        self.apply_id = apply_id
        # This parameter is required.
        self.biz_category = biz_category
        self.business_instance_id = business_instance_id
        self.user_id = user_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.apply_id is not None:
            result['apply_id'] = self.apply_id
        if self.biz_category is not None:
            result['biz_category'] = self.biz_category
        if self.business_instance_id is not None:
            result['business_instance_id'] = self.business_instance_id
        if self.user_id is not None:
            result['user_id'] = self.user_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('apply_id') is not None:
            self.apply_id = m.get('apply_id')
        if m.get('biz_category') is not None:
            self.biz_category = m.get('biz_category')
        if m.get('business_instance_id') is not None:
            self.business_instance_id = m.get('business_instance_id')
        if m.get('user_id') is not None:
            self.user_id = m.get('user_id')
        return self


class CommonApplyQueryResponseBodyModule(TeaModel):
    def __init__(
        self,
        apply_id: int = None,
        biz_category: int = None,
        cause: str = None,
        corp_id: str = None,
        extend_value: str = None,
        gmt_create: str = None,
        status: int = None,
        thirdpart_corp_id: str = None,
        thirdpart_id: str = None,
        trip_cause: str = None,
        user_id: str = None,
        user_name: str = None,
    ):
        self.apply_id = apply_id
        self.biz_category = biz_category
        self.cause = cause
        self.corp_id = corp_id
        self.extend_value = extend_value
        self.gmt_create = gmt_create
        self.status = status
        self.thirdpart_corp_id = thirdpart_corp_id
        self.thirdpart_id = thirdpart_id
        self.trip_cause = trip_cause
        self.user_id = user_id
        self.user_name = user_name

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.apply_id is not None:
            result['apply_id'] = self.apply_id
        if self.biz_category is not None:
            result['biz_category'] = self.biz_category
        if self.cause is not None:
            result['cause'] = self.cause
        if self.corp_id is not None:
            result['corp_id'] = self.corp_id
        if self.extend_value is not None:
            result['extend_value'] = self.extend_value
        if self.gmt_create is not None:
            result['gmt_create'] = self.gmt_create
        if self.status is not None:
            result['status'] = self.status
        if self.thirdpart_corp_id is not None:
            result['thirdpart_corp_id'] = self.thirdpart_corp_id
        if self.thirdpart_id is not None:
            result['thirdpart_id'] = self.thirdpart_id
        if self.trip_cause is not None:
            result['trip_cause'] = self.trip_cause
        if self.user_id is not None:
            result['user_id'] = self.user_id
        if self.user_name is not None:
            result['user_name'] = self.user_name
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('apply_id') is not None:
            self.apply_id = m.get('apply_id')
        if m.get('biz_category') is not None:
            self.biz_category = m.get('biz_category')
        if m.get('cause') is not None:
            self.cause = m.get('cause')
        if m.get('corp_id') is not None:
            self.corp_id = m.get('corp_id')
        if m.get('extend_value') is not None:
            self.extend_value = m.get('extend_value')
        if m.get('gmt_create') is not None:
            self.gmt_create = m.get('gmt_create')
        if m.get('status') is not None:
            self.status = m.get('status')
        if m.get('thirdpart_corp_id') is not None:
            self.thirdpart_corp_id = m.get('thirdpart_corp_id')
        if m.get('thirdpart_id') is not None:
            self.thirdpart_id = m.get('thirdpart_id')
        if m.get('trip_cause') is not None:
            self.trip_cause = m.get('trip_cause')
        if m.get('user_id') is not None:
            self.user_id = m.get('user_id')
        if m.get('user_name') is not None:
            self.user_name = m.get('user_name')
        return self


class CommonApplyQueryResponseBody(TeaModel):
    def __init__(
        self,
        code: str = None,
        message: str = None,
        module: CommonApplyQueryResponseBodyModule = None,
        request_id: str = None,
        success: bool = None,
        trace_id: str = None,
    ):
        self.code = code
        self.message = message
        self.module = module
        self.request_id = request_id
        self.success = success
        self.trace_id = trace_id

    def validate(self):
        if self.module:
            self.module.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['code'] = self.code
        if self.message is not None:
            result['message'] = self.message
        if self.module is not None:
            result['module'] = self.module.to_map()
        if self.request_id is not None:
            result['requestId'] = self.request_id
        if self.success is not None:
            result['success'] = self.success
        if self.trace_id is not None:
            result['traceId'] = self.trace_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('code') is not None:
            self.code = m.get('code')
        if m.get('message') is not None:
            self.message = m.get('message')
        if m.get('module') is not None:
            temp_model = CommonApplyQueryResponseBodyModule()
            self.module = temp_model.from_map(m['module'])
        if m.get('requestId') is not None:
            self.request_id = m.get('requestId')
        if m.get('success') is not None:
            self.success = m.get('success')
        if m.get('traceId') is not None:
            self.trace_id = m.get('traceId')
        return self


class CommonApplyQueryResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: CommonApplyQueryResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = CommonApplyQueryResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CommonApplySyncHeaders(TeaModel):
    def __init__(
        self,
        common_headers: Dict[str, str] = None,
        x_acs_btrip_so_corp_token: str = None,
    ):
        self.common_headers = common_headers
        self.x_acs_btrip_so_corp_token = x_acs_btrip_so_corp_token

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.common_headers is not None:
            result['commonHeaders'] = self.common_headers
        if self.x_acs_btrip_so_corp_token is not None:
            result['x-acs-btrip-so-corp-token'] = self.x_acs_btrip_so_corp_token
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('commonHeaders') is not None:
            self.common_headers = m.get('commonHeaders')
        if m.get('x-acs-btrip-so-corp-token') is not None:
            self.x_acs_btrip_so_corp_token = m.get('x-acs-btrip-so-corp-token')
        return self


class CommonApplySyncRequest(TeaModel):
    def __init__(
        self,
        apply_id: int = None,
        biz_category: int = None,
        remark: str = None,
        status: int = None,
        thirdparty_flow_id: str = None,
        user_id: str = None,
    ):
        # This parameter is required.
        self.apply_id = apply_id
        self.biz_category = biz_category
        self.remark = remark
        # This parameter is required.
        self.status = status
        self.thirdparty_flow_id = thirdparty_flow_id
        # This parameter is required.
        self.user_id = user_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.apply_id is not None:
            result['apply_id'] = self.apply_id
        if self.biz_category is not None:
            result['biz_category'] = self.biz_category
        if self.remark is not None:
            result['remark'] = self.remark
        if self.status is not None:
            result['status'] = self.status
        if self.thirdparty_flow_id is not None:
            result['thirdparty_flow_id'] = self.thirdparty_flow_id
        if self.user_id is not None:
            result['user_id'] = self.user_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('apply_id') is not None:
            self.apply_id = m.get('apply_id')
        if m.get('biz_category') is not None:
            self.biz_category = m.get('biz_category')
        if m.get('remark') is not None:
            self.remark = m.get('remark')
        if m.get('status') is not None:
            self.status = m.get('status')
        if m.get('thirdparty_flow_id') is not None:
            self.thirdparty_flow_id = m.get('thirdparty_flow_id')
        if m.get('user_id') is not None:
            self.user_id = m.get('user_id')
        return self


class CommonApplySyncResponseBody(TeaModel):
    def __init__(
        self,
        code: str = None,
        message: str = None,
        module: bool = None,
        request_id: str = None,
        success: bool = None,
        trace_id: str = None,
    ):
        self.code = code
        self.message = message
        # module。
        self.module = module
        self.request_id = request_id
        self.success = success
        self.trace_id = trace_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['code'] = self.code
        if self.message is not None:
            result['message'] = self.message
        if self.module is not None:
            result['module'] = self.module
        if self.request_id is not None:
            result['requestId'] = self.request_id
        if self.success is not None:
            result['success'] = self.success
        if self.trace_id is not None:
            result['traceId'] = self.trace_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('code') is not None:
            self.code = m.get('code')
        if m.get('message') is not None:
            self.message = m.get('message')
        if m.get('module') is not None:
            self.module = m.get('module')
        if m.get('requestId') is not None:
            self.request_id = m.get('requestId')
        if m.get('success') is not None:
            self.success = m.get('success')
        if m.get('traceId') is not None:
            self.trace_id = m.get('traceId')
        return self


class CommonApplySyncResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: CommonApplySyncResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = CommonApplySyncResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CooperatorFlightBillSettlementQueryHeaders(TeaModel):
    def __init__(
        self,
        common_headers: Dict[str, str] = None,
        x_acs_btrip_corp_token: str = None,
    ):
        self.common_headers = common_headers
        self.x_acs_btrip_corp_token = x_acs_btrip_corp_token

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.common_headers is not None:
            result['commonHeaders'] = self.common_headers
        if self.x_acs_btrip_corp_token is not None:
            result['x-acs-btrip-corp-token'] = self.x_acs_btrip_corp_token
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('commonHeaders') is not None:
            self.common_headers = m.get('commonHeaders')
        if m.get('x-acs-btrip-corp-token') is not None:
            self.x_acs_btrip_corp_token = m.get('x-acs-btrip-corp-token')
        return self


class CooperatorFlightBillSettlementQueryRequest(TeaModel):
    def __init__(
        self,
        bill_batch: str = None,
        cooperator_id: str = None,
        order_id: int = None,
        page_no: int = None,
        page_size: int = None,
        period_end: str = None,
        period_start: str = None,
        scroll_id: str = None,
        scroll_mod: bool = None,
    ):
        self.bill_batch = bill_batch
        self.cooperator_id = cooperator_id
        self.order_id = order_id
        # This parameter is required.
        self.page_no = page_no
        # This parameter is required.
        self.page_size = page_size
        self.period_end = period_end
        self.period_start = period_start
        self.scroll_id = scroll_id
        self.scroll_mod = scroll_mod

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.bill_batch is not None:
            result['bill_batch'] = self.bill_batch
        if self.cooperator_id is not None:
            result['cooperator_id'] = self.cooperator_id
        if self.order_id is not None:
            result['order_id'] = self.order_id
        if self.page_no is not None:
            result['page_no'] = self.page_no
        if self.page_size is not None:
            result['page_size'] = self.page_size
        if self.period_end is not None:
            result['period_end'] = self.period_end
        if self.period_start is not None:
            result['period_start'] = self.period_start
        if self.scroll_id is not None:
            result['scroll_id'] = self.scroll_id
        if self.scroll_mod is not None:
            result['scroll_mod'] = self.scroll_mod
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('bill_batch') is not None:
            self.bill_batch = m.get('bill_batch')
        if m.get('cooperator_id') is not None:
            self.cooperator_id = m.get('cooperator_id')
        if m.get('order_id') is not None:
            self.order_id = m.get('order_id')
        if m.get('page_no') is not None:
            self.page_no = m.get('page_no')
        if m.get('page_size') is not None:
            self.page_size = m.get('page_size')
        if m.get('period_end') is not None:
            self.period_end = m.get('period_end')
        if m.get('period_start') is not None:
            self.period_start = m.get('period_start')
        if m.get('scroll_id') is not None:
            self.scroll_id = m.get('scroll_id')
        if m.get('scroll_mod') is not None:
            self.scroll_mod = m.get('scroll_mod')
        return self


class CooperatorFlightBillSettlementQueryResponseBodyModuleItems(TeaModel):
    def __init__(
        self,
        adjust_time: str = None,
        advance_day: int = None,
        airline_corp_code: str = None,
        airline_corp_name: str = None,
        alipay_id: str = None,
        alipay_trade_no: str = None,
        apply_arr_city_code: str = None,
        apply_arr_city_name: str = None,
        apply_dep_city_code: str = None,
        apply_dep_city_name: str = None,
        apply_extend_field: str = None,
        apply_id: str = None,
        approver_email: str = None,
        approver_id: str = None,
        approver_name: str = None,
        arr_airport_code: str = None,
        arr_city: str = None,
        arr_city_code: str = None,
        arr_date: str = None,
        arr_station: str = None,
        arr_time: str = None,
        base_location: str = None,
        bill_record_time: str = None,
        book_channel: str = None,
        book_mode: str = None,
        book_time: str = None,
        booker_id: str = None,
        booker_job_no: str = None,
        booker_name: str = None,
        btrip_coupon_fee: float = None,
        build_fee: float = None,
        business_trip_result: str = None,
        cabin: str = None,
        cabin_class: str = None,
        cabin_class_code: str = None,
        capital_direction: str = None,
        cascade_department: str = None,
        category_desc: str = None,
        change_fee: float = None,
        change_result: str = None,
        cooperator_bill_code: str = None,
        cooperator_name: str = None,
        cooperator_order_id: str = None,
        corp_pay_order_fee: float = None,
        corp_settle_price: float = None,
        cost_center: str = None,
        cost_center_number: str = None,
        cost_department: str = None,
        coupon: float = None,
        custom_content: str = None,
        dep_airport_code: str = None,
        dep_city_code: str = None,
        department: str = None,
        department_id: str = None,
        dept_city: str = None,
        dept_date: str = None,
        dept_station: str = None,
        dept_time: str = None,
        discount: str = None,
        exceed_reason: str = None,
        fee_type: str = None,
        fee_type_desc: str = None,
        flight_no: str = None,
        flight_trip_type: str = None,
        foreigners_tag: str = None,
        index: str = None,
        ins_order_id: str = None,
        insurance_fee: float = None,
        insurance_number: str = None,
        invoice_title: str = None,
        item_type: str = None,
        itinerary_num: str = None,
        itinerary_price: float = None,
        location: str = None,
        mapping_company_code: str = None,
        mileage: int = None,
        most_difference_dept_time: str = None,
        most_difference_discount: str = None,
        most_difference_flight_no: str = None,
        most_difference_price: float = None,
        most_difference_reason: str = None,
        most_price: float = None,
        negotiation_coupon_fee: float = None,
        oil_fee: float = None,
        order_id: str = None,
        order_status_desc: str = None,
        order_ticket_no: str = None,
        over_apply_id: str = None,
        payment_department_id: str = None,
        payment_department_name: str = None,
        person_settle_price: float = None,
        position: str = None,
        position_level: str = None,
        pre_book_tip: str = None,
        primary_id: int = None,
        processor_oa_code: str = None,
        project_code: str = None,
        project_name: str = None,
        refund_fee: float = None,
        refund_result: str = None,
        refund_upgrade_cost: float = None,
        remark: str = None,
        repeat_refund: str = None,
        seal_price: float = None,
        service_fee: float = None,
        settle_type_desc: str = None,
        settlement_fee: float = None,
        settlement_grant_fee: float = None,
        settlement_time: str = None,
        settlement_type: str = None,
        sio: str = None,
        status: int = None,
        status_desc: str = None,
        sub_order_id: str = None,
        tax_rate: str = None,
        third_invoice_id: str = None,
        third_itinerary_id: str = None,
        ticket_id: str = None,
        trade: str = None,
        trade_action_desc: str = None,
        traveler_email: str = None,
        traveler_id: str = None,
        traveler_job_no: str = None,
        traveler_member_type: str = None,
        traveler_member_type_name: str = None,
        traveler_name: str = None,
        upgrade_cost: float = None,
        voucher_type: int = None,
        voucher_type_desc: str = None,
        voyage_name: str = None,
    ):
        self.adjust_time = adjust_time
        self.advance_day = advance_day
        self.airline_corp_code = airline_corp_code
        self.airline_corp_name = airline_corp_name
        self.alipay_id = alipay_id
        self.alipay_trade_no = alipay_trade_no
        self.apply_arr_city_code = apply_arr_city_code
        self.apply_arr_city_name = apply_arr_city_name
        self.apply_dep_city_code = apply_dep_city_code
        self.apply_dep_city_name = apply_dep_city_name
        self.apply_extend_field = apply_extend_field
        self.apply_id = apply_id
        self.approver_email = approver_email
        self.approver_id = approver_id
        self.approver_name = approver_name
        self.arr_airport_code = arr_airport_code
        self.arr_city = arr_city
        self.arr_city_code = arr_city_code
        self.arr_date = arr_date
        self.arr_station = arr_station
        self.arr_time = arr_time
        self.base_location = base_location
        self.bill_record_time = bill_record_time
        self.book_channel = book_channel
        self.book_mode = book_mode
        self.book_time = book_time
        self.booker_id = booker_id
        self.booker_job_no = booker_job_no
        self.booker_name = booker_name
        self.btrip_coupon_fee = btrip_coupon_fee
        self.build_fee = build_fee
        self.business_trip_result = business_trip_result
        self.cabin = cabin
        self.cabin_class = cabin_class
        self.cabin_class_code = cabin_class_code
        self.capital_direction = capital_direction
        self.cascade_department = cascade_department
        self.category_desc = category_desc
        self.change_fee = change_fee
        self.change_result = change_result
        self.cooperator_bill_code = cooperator_bill_code
        self.cooperator_name = cooperator_name
        self.cooperator_order_id = cooperator_order_id
        self.corp_pay_order_fee = corp_pay_order_fee
        self.corp_settle_price = corp_settle_price
        self.cost_center = cost_center
        self.cost_center_number = cost_center_number
        self.cost_department = cost_department
        self.coupon = coupon
        self.custom_content = custom_content
        self.dep_airport_code = dep_airport_code
        self.dep_city_code = dep_city_code
        self.department = department
        self.department_id = department_id
        self.dept_city = dept_city
        self.dept_date = dept_date
        self.dept_station = dept_station
        self.dept_time = dept_time
        self.discount = discount
        self.exceed_reason = exceed_reason
        self.fee_type = fee_type
        self.fee_type_desc = fee_type_desc
        self.flight_no = flight_no
        self.flight_trip_type = flight_trip_type
        self.foreigners_tag = foreigners_tag
        self.index = index
        self.ins_order_id = ins_order_id
        self.insurance_fee = insurance_fee
        self.insurance_number = insurance_number
        self.invoice_title = invoice_title
        self.item_type = item_type
        self.itinerary_num = itinerary_num
        self.itinerary_price = itinerary_price
        self.location = location
        self.mapping_company_code = mapping_company_code
        self.mileage = mileage
        self.most_difference_dept_time = most_difference_dept_time
        self.most_difference_discount = most_difference_discount
        self.most_difference_flight_no = most_difference_flight_no
        self.most_difference_price = most_difference_price
        self.most_difference_reason = most_difference_reason
        self.most_price = most_price
        self.negotiation_coupon_fee = negotiation_coupon_fee
        self.oil_fee = oil_fee
        self.order_id = order_id
        self.order_status_desc = order_status_desc
        self.order_ticket_no = order_ticket_no
        self.over_apply_id = over_apply_id
        self.payment_department_id = payment_department_id
        self.payment_department_name = payment_department_name
        self.person_settle_price = person_settle_price
        self.position = position
        self.position_level = position_level
        self.pre_book_tip = pre_book_tip
        self.primary_id = primary_id
        self.processor_oa_code = processor_oa_code
        self.project_code = project_code
        self.project_name = project_name
        self.refund_fee = refund_fee
        self.refund_result = refund_result
        self.refund_upgrade_cost = refund_upgrade_cost
        self.remark = remark
        self.repeat_refund = repeat_refund
        self.seal_price = seal_price
        self.service_fee = service_fee
        self.settle_type_desc = settle_type_desc
        self.settlement_fee = settlement_fee
        self.settlement_grant_fee = settlement_grant_fee
        self.settlement_time = settlement_time
        self.settlement_type = settlement_type
        self.sio = sio
        self.status = status
        self.status_desc = status_desc
        self.sub_order_id = sub_order_id
        self.tax_rate = tax_rate
        self.third_invoice_id = third_invoice_id
        self.third_itinerary_id = third_itinerary_id
        self.ticket_id = ticket_id
        self.trade = trade
        self.trade_action_desc = trade_action_desc
        self.traveler_email = traveler_email
        self.traveler_id = traveler_id
        self.traveler_job_no = traveler_job_no
        self.traveler_member_type = traveler_member_type
        self.traveler_member_type_name = traveler_member_type_name
        self.traveler_name = traveler_name
        self.upgrade_cost = upgrade_cost
        self.voucher_type = voucher_type
        self.voucher_type_desc = voucher_type_desc
        self.voyage_name = voyage_name

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.adjust_time is not None:
            result['adjust_time'] = self.adjust_time
        if self.advance_day is not None:
            result['advance_day'] = self.advance_day
        if self.airline_corp_code is not None:
            result['airline_corp_code'] = self.airline_corp_code
        if self.airline_corp_name is not None:
            result['airline_corp_name'] = self.airline_corp_name
        if self.alipay_id is not None:
            result['alipay_id'] = self.alipay_id
        if self.alipay_trade_no is not None:
            result['alipay_trade_no'] = self.alipay_trade_no
        if self.apply_arr_city_code is not None:
            result['apply_arr_city_code'] = self.apply_arr_city_code
        if self.apply_arr_city_name is not None:
            result['apply_arr_city_name'] = self.apply_arr_city_name
        if self.apply_dep_city_code is not None:
            result['apply_dep_city_code'] = self.apply_dep_city_code
        if self.apply_dep_city_name is not None:
            result['apply_dep_city_name'] = self.apply_dep_city_name
        if self.apply_extend_field is not None:
            result['apply_extend_field'] = self.apply_extend_field
        if self.apply_id is not None:
            result['apply_id'] = self.apply_id
        if self.approver_email is not None:
            result['approver_email'] = self.approver_email
        if self.approver_id is not None:
            result['approver_id'] = self.approver_id
        if self.approver_name is not None:
            result['approver_name'] = self.approver_name
        if self.arr_airport_code is not None:
            result['arr_airport_code'] = self.arr_airport_code
        if self.arr_city is not None:
            result['arr_city'] = self.arr_city
        if self.arr_city_code is not None:
            result['arr_city_code'] = self.arr_city_code
        if self.arr_date is not None:
            result['arr_date'] = self.arr_date
        if self.arr_station is not None:
            result['arr_station'] = self.arr_station
        if self.arr_time is not None:
            result['arr_time'] = self.arr_time
        if self.base_location is not None:
            result['base_location'] = self.base_location
        if self.bill_record_time is not None:
            result['bill_record_time'] = self.bill_record_time
        if self.book_channel is not None:
            result['book_channel'] = self.book_channel
        if self.book_mode is not None:
            result['book_mode'] = self.book_mode
        if self.book_time is not None:
            result['book_time'] = self.book_time
        if self.booker_id is not None:
            result['booker_id'] = self.booker_id
        if self.booker_job_no is not None:
            result['booker_job_no'] = self.booker_job_no
        if self.booker_name is not None:
            result['booker_name'] = self.booker_name
        if self.btrip_coupon_fee is not None:
            result['btrip_coupon_fee'] = self.btrip_coupon_fee
        if self.build_fee is not None:
            result['build_fee'] = self.build_fee
        if self.business_trip_result is not None:
            result['business_trip_result'] = self.business_trip_result
        if self.cabin is not None:
            result['cabin'] = self.cabin
        if self.cabin_class is not None:
            result['cabin_class'] = self.cabin_class
        if self.cabin_class_code is not None:
            result['cabin_class_code'] = self.cabin_class_code
        if self.capital_direction is not None:
            result['capital_direction'] = self.capital_direction
        if self.cascade_department is not None:
            result['cascade_department'] = self.cascade_department
        if self.category_desc is not None:
            result['category_desc'] = self.category_desc
        if self.change_fee is not None:
            result['change_fee'] = self.change_fee
        if self.change_result is not None:
            result['change_result'] = self.change_result
        if self.cooperator_bill_code is not None:
            result['cooperator_bill_code'] = self.cooperator_bill_code
        if self.cooperator_name is not None:
            result['cooperator_name'] = self.cooperator_name
        if self.cooperator_order_id is not None:
            result['cooperator_order_id'] = self.cooperator_order_id
        if self.corp_pay_order_fee is not None:
            result['corp_pay_order_fee'] = self.corp_pay_order_fee
        if self.corp_settle_price is not None:
            result['corp_settle_price'] = self.corp_settle_price
        if self.cost_center is not None:
            result['cost_center'] = self.cost_center
        if self.cost_center_number is not None:
            result['cost_center_number'] = self.cost_center_number
        if self.cost_department is not None:
            result['cost_department'] = self.cost_department
        if self.coupon is not None:
            result['coupon'] = self.coupon
        if self.custom_content is not None:
            result['custom_content'] = self.custom_content
        if self.dep_airport_code is not None:
            result['dep_airport_code'] = self.dep_airport_code
        if self.dep_city_code is not None:
            result['dep_city_code'] = self.dep_city_code
        if self.department is not None:
            result['department'] = self.department
        if self.department_id is not None:
            result['department_id'] = self.department_id
        if self.dept_city is not None:
            result['dept_city'] = self.dept_city
        if self.dept_date is not None:
            result['dept_date'] = self.dept_date
        if self.dept_station is not None:
            result['dept_station'] = self.dept_station
        if self.dept_time is not None:
            result['dept_time'] = self.dept_time
        if self.discount is not None:
            result['discount'] = self.discount
        if self.exceed_reason is not None:
            result['exceed_reason'] = self.exceed_reason
        if self.fee_type is not None:
            result['fee_type'] = self.fee_type
        if self.fee_type_desc is not None:
            result['fee_type_desc'] = self.fee_type_desc
        if self.flight_no is not None:
            result['flight_no'] = self.flight_no
        if self.flight_trip_type is not None:
            result['flight_trip_type'] = self.flight_trip_type
        if self.foreigners_tag is not None:
            result['foreigners_tag'] = self.foreigners_tag
        if self.index is not None:
            result['index'] = self.index
        if self.ins_order_id is not None:
            result['ins_order_id'] = self.ins_order_id
        if self.insurance_fee is not None:
            result['insurance_fee'] = self.insurance_fee
        if self.insurance_number is not None:
            result['insurance_number'] = self.insurance_number
        if self.invoice_title is not None:
            result['invoice_title'] = self.invoice_title
        if self.item_type is not None:
            result['item_type'] = self.item_type
        if self.itinerary_num is not None:
            result['itinerary_num'] = self.itinerary_num
        if self.itinerary_price is not None:
            result['itinerary_price'] = self.itinerary_price
        if self.location is not None:
            result['location'] = self.location
        if self.mapping_company_code is not None:
            result['mapping_company_code'] = self.mapping_company_code
        if self.mileage is not None:
            result['mileage'] = self.mileage
        if self.most_difference_dept_time is not None:
            result['most_difference_dept_time'] = self.most_difference_dept_time
        if self.most_difference_discount is not None:
            result['most_difference_discount'] = self.most_difference_discount
        if self.most_difference_flight_no is not None:
            result['most_difference_flight_no'] = self.most_difference_flight_no
        if self.most_difference_price is not None:
            result['most_difference_price'] = self.most_difference_price
        if self.most_difference_reason is not None:
            result['most_difference_reason'] = self.most_difference_reason
        if self.most_price is not None:
            result['most_price'] = self.most_price
        if self.negotiation_coupon_fee is not None:
            result['negotiation_coupon_fee'] = self.negotiation_coupon_fee
        if self.oil_fee is not None:
            result['oil_fee'] = self.oil_fee
        if self.order_id is not None:
            result['order_id'] = self.order_id
        if self.order_status_desc is not None:
            result['order_status_desc'] = self.order_status_desc
        if self.order_ticket_no is not None:
            result['order_ticket_no'] = self.order_ticket_no
        if self.over_apply_id is not None:
            result['over_apply_id'] = self.over_apply_id
        if self.payment_department_id is not None:
            result['payment_department_id'] = self.payment_department_id
        if self.payment_department_name is not None:
            result['payment_department_name'] = self.payment_department_name
        if self.person_settle_price is not None:
            result['person_settle_price'] = self.person_settle_price
        if self.position is not None:
            result['position'] = self.position
        if self.position_level is not None:
            result['position_level'] = self.position_level
        if self.pre_book_tip is not None:
            result['pre_book_tip'] = self.pre_book_tip
        if self.primary_id is not None:
            result['primary_id'] = self.primary_id
        if self.processor_oa_code is not None:
            result['processor_oa_code'] = self.processor_oa_code
        if self.project_code is not None:
            result['project_code'] = self.project_code
        if self.project_name is not None:
            result['project_name'] = self.project_name
        if self.refund_fee is not None:
            result['refund_fee'] = self.refund_fee
        if self.refund_result is not None:
            result['refund_result'] = self.refund_result
        if self.refund_upgrade_cost is not None:
            result['refund_upgrade_cost'] = self.refund_upgrade_cost
        if self.remark is not None:
            result['remark'] = self.remark
        if self.repeat_refund is not None:
            result['repeat_refund'] = self.repeat_refund
        if self.seal_price is not None:
            result['seal_price'] = self.seal_price
        if self.service_fee is not None:
            result['service_fee'] = self.service_fee
        if self.settle_type_desc is not None:
            result['settle_type_desc'] = self.settle_type_desc
        if self.settlement_fee is not None:
            result['settlement_fee'] = self.settlement_fee
        if self.settlement_grant_fee is not None:
            result['settlement_grant_fee'] = self.settlement_grant_fee
        if self.settlement_time is not None:
            result['settlement_time'] = self.settlement_time
        if self.settlement_type is not None:
            result['settlement_type'] = self.settlement_type
        if self.sio is not None:
            result['sio'] = self.sio
        if self.status is not None:
            result['status'] = self.status
        if self.status_desc is not None:
            result['status_desc'] = self.status_desc
        if self.sub_order_id is not None:
            result['sub_order_id'] = self.sub_order_id
        if self.tax_rate is not None:
            result['tax_rate'] = self.tax_rate
        if self.third_invoice_id is not None:
            result['third_invoice_id'] = self.third_invoice_id
        if self.third_itinerary_id is not None:
            result['third_itinerary_id'] = self.third_itinerary_id
        if self.ticket_id is not None:
            result['ticket_id'] = self.ticket_id
        if self.trade is not None:
            result['trade'] = self.trade
        if self.trade_action_desc is not None:
            result['trade_action_desc'] = self.trade_action_desc
        if self.traveler_email is not None:
            result['traveler_email'] = self.traveler_email
        if self.traveler_id is not None:
            result['traveler_id'] = self.traveler_id
        if self.traveler_job_no is not None:
            result['traveler_job_no'] = self.traveler_job_no
        if self.traveler_member_type is not None:
            result['traveler_member_type'] = self.traveler_member_type
        if self.traveler_member_type_name is not None:
            result['traveler_member_type_name'] = self.traveler_member_type_name
        if self.traveler_name is not None:
            result['traveler_name'] = self.traveler_name
        if self.upgrade_cost is not None:
            result['upgrade_cost'] = self.upgrade_cost
        if self.voucher_type is not None:
            result['voucher_type'] = self.voucher_type
        if self.voucher_type_desc is not None:
            result['voucher_type_desc'] = self.voucher_type_desc
        if self.voyage_name is not None:
            result['voyage_name'] = self.voyage_name
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('adjust_time') is not None:
            self.adjust_time = m.get('adjust_time')
        if m.get('advance_day') is not None:
            self.advance_day = m.get('advance_day')
        if m.get('airline_corp_code') is not None:
            self.airline_corp_code = m.get('airline_corp_code')
        if m.get('airline_corp_name') is not None:
            self.airline_corp_name = m.get('airline_corp_name')
        if m.get('alipay_id') is not None:
            self.alipay_id = m.get('alipay_id')
        if m.get('alipay_trade_no') is not None:
            self.alipay_trade_no = m.get('alipay_trade_no')
        if m.get('apply_arr_city_code') is not None:
            self.apply_arr_city_code = m.get('apply_arr_city_code')
        if m.get('apply_arr_city_name') is not None:
            self.apply_arr_city_name = m.get('apply_arr_city_name')
        if m.get('apply_dep_city_code') is not None:
            self.apply_dep_city_code = m.get('apply_dep_city_code')
        if m.get('apply_dep_city_name') is not None:
            self.apply_dep_city_name = m.get('apply_dep_city_name')
        if m.get('apply_extend_field') is not None:
            self.apply_extend_field = m.get('apply_extend_field')
        if m.get('apply_id') is not None:
            self.apply_id = m.get('apply_id')
        if m.get('approver_email') is not None:
            self.approver_email = m.get('approver_email')
        if m.get('approver_id') is not None:
            self.approver_id = m.get('approver_id')
        if m.get('approver_name') is not None:
            self.approver_name = m.get('approver_name')
        if m.get('arr_airport_code') is not None:
            self.arr_airport_code = m.get('arr_airport_code')
        if m.get('arr_city') is not None:
            self.arr_city = m.get('arr_city')
        if m.get('arr_city_code') is not None:
            self.arr_city_code = m.get('arr_city_code')
        if m.get('arr_date') is not None:
            self.arr_date = m.get('arr_date')
        if m.get('arr_station') is not None:
            self.arr_station = m.get('arr_station')
        if m.get('arr_time') is not None:
            self.arr_time = m.get('arr_time')
        if m.get('base_location') is not None:
            self.base_location = m.get('base_location')
        if m.get('bill_record_time') is not None:
            self.bill_record_time = m.get('bill_record_time')
        if m.get('book_channel') is not None:
            self.book_channel = m.get('book_channel')
        if m.get('book_mode') is not None:
            self.book_mode = m.get('book_mode')
        if m.get('book_time') is not None:
            self.book_time = m.get('book_time')
        if m.get('booker_id') is not None:
            self.booker_id = m.get('booker_id')
        if m.get('booker_job_no') is not None:
            self.booker_job_no = m.get('booker_job_no')
        if m.get('booker_name') is not None:
            self.booker_name = m.get('booker_name')
        if m.get('btrip_coupon_fee') is not None:
            self.btrip_coupon_fee = m.get('btrip_coupon_fee')
        if m.get('build_fee') is not None:
            self.build_fee = m.get('build_fee')
        if m.get('business_trip_result') is not None:
            self.business_trip_result = m.get('business_trip_result')
        if m.get('cabin') is not None:
            self.cabin = m.get('cabin')
        if m.get('cabin_class') is not None:
            self.cabin_class = m.get('cabin_class')
        if m.get('cabin_class_code') is not None:
            self.cabin_class_code = m.get('cabin_class_code')
        if m.get('capital_direction') is not None:
            self.capital_direction = m.get('capital_direction')
        if m.get('cascade_department') is not None:
            self.cascade_department = m.get('cascade_department')
        if m.get('category_desc') is not None:
            self.category_desc = m.get('category_desc')
        if m.get('change_fee') is not None:
            self.change_fee = m.get('change_fee')
        if m.get('change_result') is not None:
            self.change_result = m.get('change_result')
        if m.get('cooperator_bill_code') is not None:
            self.cooperator_bill_code = m.get('cooperator_bill_code')
        if m.get('cooperator_name') is not None:
            self.cooperator_name = m.get('cooperator_name')
        if m.get('cooperator_order_id') is not None:
            self.cooperator_order_id = m.get('cooperator_order_id')
        if m.get('corp_pay_order_fee') is not None:
            self.corp_pay_order_fee = m.get('corp_pay_order_fee')
        if m.get('corp_settle_price') is not None:
            self.corp_settle_price = m.get('corp_settle_price')
        if m.get('cost_center') is not None:
            self.cost_center = m.get('cost_center')
        if m.get('cost_center_number') is not None:
            self.cost_center_number = m.get('cost_center_number')
        if m.get('cost_department') is not None:
            self.cost_department = m.get('cost_department')
        if m.get('coupon') is not None:
            self.coupon = m.get('coupon')
        if m.get('custom_content') is not None:
            self.custom_content = m.get('custom_content')
        if m.get('dep_airport_code') is not None:
            self.dep_airport_code = m.get('dep_airport_code')
        if m.get('dep_city_code') is not None:
            self.dep_city_code = m.get('dep_city_code')
        if m.get('department') is not None:
            self.department = m.get('department')
        if m.get('department_id') is not None:
            self.department_id = m.get('department_id')
        if m.get('dept_city') is not None:
            self.dept_city = m.get('dept_city')
        if m.get('dept_date') is not None:
            self.dept_date = m.get('dept_date')
        if m.get('dept_station') is not None:
            self.dept_station = m.get('dept_station')
        if m.get('dept_time') is not None:
            self.dept_time = m.get('dept_time')
        if m.get('discount') is not None:
            self.discount = m.get('discount')
        if m.get('exceed_reason') is not None:
            self.exceed_reason = m.get('exceed_reason')
        if m.get('fee_type') is not None:
            self.fee_type = m.get('fee_type')
        if m.get('fee_type_desc') is not None:
            self.fee_type_desc = m.get('fee_type_desc')
        if m.get('flight_no') is not None:
            self.flight_no = m.get('flight_no')
        if m.get('flight_trip_type') is not None:
            self.flight_trip_type = m.get('flight_trip_type')
        if m.get('foreigners_tag') is not None:
            self.foreigners_tag = m.get('foreigners_tag')
        if m.get('index') is not None:
            self.index = m.get('index')
        if m.get('ins_order_id') is not None:
            self.ins_order_id = m.get('ins_order_id')
        if m.get('insurance_fee') is not None:
            self.insurance_fee = m.get('insurance_fee')
        if m.get('insurance_number') is not None:
            self.insurance_number = m.get('insurance_number')
        if m.get('invoice_title') is not None:
            self.invoice_title = m.get('invoice_title')
        if m.get('item_type') is not None:
            self.item_type = m.get('item_type')
        if m.get('itinerary_num') is not None:
            self.itinerary_num = m.get('itinerary_num')
        if m.get('itinerary_price') is not None:
            self.itinerary_price = m.get('itinerary_price')
        if m.get('location') is not None:
            self.location = m.get('location')
        if m.get('mapping_company_code') is not None:
            self.mapping_company_code = m.get('mapping_company_code')
        if m.get('mileage') is not None:
            self.mileage = m.get('mileage')
        if m.get('most_difference_dept_time') is not None:
            self.most_difference_dept_time = m.get('most_difference_dept_time')
        if m.get('most_difference_discount') is not None:
            self.most_difference_discount = m.get('most_difference_discount')
        if m.get('most_difference_flight_no') is not None:
            self.most_difference_flight_no = m.get('most_difference_flight_no')
        if m.get('most_difference_price') is not None:
            self.most_difference_price = m.get('most_difference_price')
        if m.get('most_difference_reason') is not None:
            self.most_difference_reason = m.get('most_difference_reason')
        if m.get('most_price') is not None:
            self.most_price = m.get('most_price')
        if m.get('negotiation_coupon_fee') is not None:
            self.negotiation_coupon_fee = m.get('negotiation_coupon_fee')
        if m.get('oil_fee') is not None:
            self.oil_fee = m.get('oil_fee')
        if m.get('order_id') is not None:
            self.order_id = m.get('order_id')
        if m.get('order_status_desc') is not None:
            self.order_status_desc = m.get('order_status_desc')
        if m.get('order_ticket_no') is not None:
            self.order_ticket_no = m.get('order_ticket_no')
        if m.get('over_apply_id') is not None:
            self.over_apply_id = m.get('over_apply_id')
        if m.get('payment_department_id') is not None:
            self.payment_department_id = m.get('payment_department_id')
        if m.get('payment_department_name') is not None:
            self.payment_department_name = m.get('payment_department_name')
        if m.get('person_settle_price') is not None:
            self.person_settle_price = m.get('person_settle_price')
        if m.get('position') is not None:
            self.position = m.get('position')
        if m.get('position_level') is not None:
            self.position_level = m.get('position_level')
        if m.get('pre_book_tip') is not None:
            self.pre_book_tip = m.get('pre_book_tip')
        if m.get('primary_id') is not None:
            self.primary_id = m.get('primary_id')
        if m.get('processor_oa_code') is not None:
            self.processor_oa_code = m.get('processor_oa_code')
        if m.get('project_code') is not None:
            self.project_code = m.get('project_code')
        if m.get('project_name') is not None:
            self.project_name = m.get('project_name')
        if m.get('refund_fee') is not None:
            self.refund_fee = m.get('refund_fee')
        if m.get('refund_result') is not None:
            self.refund_result = m.get('refund_result')
        if m.get('refund_upgrade_cost') is not None:
            self.refund_upgrade_cost = m.get('refund_upgrade_cost')
        if m.get('remark') is not None:
            self.remark = m.get('remark')
        if m.get('repeat_refund') is not None:
            self.repeat_refund = m.get('repeat_refund')
        if m.get('seal_price') is not None:
            self.seal_price = m.get('seal_price')
        if m.get('service_fee') is not None:
            self.service_fee = m.get('service_fee')
        if m.get('settle_type_desc') is not None:
            self.settle_type_desc = m.get('settle_type_desc')
        if m.get('settlement_fee') is not None:
            self.settlement_fee = m.get('settlement_fee')
        if m.get('settlement_grant_fee') is not None:
            self.settlement_grant_fee = m.get('settlement_grant_fee')
        if m.get('settlement_time') is not None:
            self.settlement_time = m.get('settlement_time')
        if m.get('settlement_type') is not None:
            self.settlement_type = m.get('settlement_type')
        if m.get('sio') is not None:
            self.sio = m.get('sio')
        if m.get('status') is not None:
            self.status = m.get('status')
        if m.get('status_desc') is not None:
            self.status_desc = m.get('status_desc')
        if m.get('sub_order_id') is not None:
            self.sub_order_id = m.get('sub_order_id')
        if m.get('tax_rate') is not None:
            self.tax_rate = m.get('tax_rate')
        if m.get('third_invoice_id') is not None:
            self.third_invoice_id = m.get('third_invoice_id')
        if m.get('third_itinerary_id') is not None:
            self.third_itinerary_id = m.get('third_itinerary_id')
        if m.get('ticket_id') is not None:
            self.ticket_id = m.get('ticket_id')
        if m.get('trade') is not None:
            self.trade = m.get('trade')
        if m.get('trade_action_desc') is not None:
            self.trade_action_desc = m.get('trade_action_desc')
        if m.get('traveler_email') is not None:
            self.traveler_email = m.get('traveler_email')
        if m.get('traveler_id') is not None:
            self.traveler_id = m.get('traveler_id')
        if m.get('traveler_job_no') is not None:
            self.traveler_job_no = m.get('traveler_job_no')
        if m.get('traveler_member_type') is not None:
            self.traveler_member_type = m.get('traveler_member_type')
        if m.get('traveler_member_type_name') is not None:
            self.traveler_member_type_name = m.get('traveler_member_type_name')
        if m.get('traveler_name') is not None:
            self.traveler_name = m.get('traveler_name')
        if m.get('upgrade_cost') is not None:
            self.upgrade_cost = m.get('upgrade_cost')
        if m.get('voucher_type') is not None:
            self.voucher_type = m.get('voucher_type')
        if m.get('voucher_type_desc') is not None:
            self.voucher_type_desc = m.get('voucher_type_desc')
        if m.get('voyage_name') is not None:
            self.voyage_name = m.get('voyage_name')
        return self


class CooperatorFlightBillSettlementQueryResponseBodyModule(TeaModel):
    def __init__(
        self,
        category: int = None,
        corp_id: str = None,
        items: List[CooperatorFlightBillSettlementQueryResponseBodyModuleItems] = None,
        period_end: str = None,
        period_start: str = None,
        scroll_id: str = None,
        total_size: int = None,
    ):
        self.category = category
        self.corp_id = corp_id
        self.items = items
        self.period_end = period_end
        self.period_start = period_start
        self.scroll_id = scroll_id
        self.total_size = total_size

    def validate(self):
        if self.items:
            for k in self.items:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.category is not None:
            result['category'] = self.category
        if self.corp_id is not None:
            result['corp_id'] = self.corp_id
        result['items'] = []
        if self.items is not None:
            for k in self.items:
                result['items'].append(k.to_map() if k else None)
        if self.period_end is not None:
            result['period_end'] = self.period_end
        if self.period_start is not None:
            result['period_start'] = self.period_start
        if self.scroll_id is not None:
            result['scroll_id'] = self.scroll_id
        if self.total_size is not None:
            result['total_size'] = self.total_size
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('category') is not None:
            self.category = m.get('category')
        if m.get('corp_id') is not None:
            self.corp_id = m.get('corp_id')
        self.items = []
        if m.get('items') is not None:
            for k in m.get('items'):
                temp_model = CooperatorFlightBillSettlementQueryResponseBodyModuleItems()
                self.items.append(temp_model.from_map(k))
        if m.get('period_end') is not None:
            self.period_end = m.get('period_end')
        if m.get('period_start') is not None:
            self.period_start = m.get('period_start')
        if m.get('scroll_id') is not None:
            self.scroll_id = m.get('scroll_id')
        if m.get('total_size') is not None:
            self.total_size = m.get('total_size')
        return self


class CooperatorFlightBillSettlementQueryResponseBody(TeaModel):
    def __init__(
        self,
        code: str = None,
        message: str = None,
        module: CooperatorFlightBillSettlementQueryResponseBodyModule = None,
        request_id: str = None,
        success: bool = None,
        trace_id: str = None,
    ):
        self.code = code
        self.message = message
        self.module = module
        self.request_id = request_id
        self.success = success
        # trace_id
        self.trace_id = trace_id

    def validate(self):
        if self.module:
            self.module.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['code'] = self.code
        if self.message is not None:
            result['message'] = self.message
        if self.module is not None:
            result['module'] = self.module.to_map()
        if self.request_id is not None:
            result['requestId'] = self.request_id
        if self.success is not None:
            result['success'] = self.success
        if self.trace_id is not None:
            result['traceId'] = self.trace_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('code') is not None:
            self.code = m.get('code')
        if m.get('message') is not None:
            self.message = m.get('message')
        if m.get('module') is not None:
            temp_model = CooperatorFlightBillSettlementQueryResponseBodyModule()
            self.module = temp_model.from_map(m['module'])
        if m.get('requestId') is not None:
            self.request_id = m.get('requestId')
        if m.get('success') is not None:
            self.success = m.get('success')
        if m.get('traceId') is not None:
            self.trace_id = m.get('traceId')
        return self


class CooperatorFlightBillSettlementQueryResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: CooperatorFlightBillSettlementQueryResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = CooperatorFlightBillSettlementQueryResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CooperatorHotelBillSettlementQueryHeaders(TeaModel):
    def __init__(
        self,
        common_headers: Dict[str, str] = None,
        x_acs_btrip_corp_token: str = None,
    ):
        self.common_headers = common_headers
        self.x_acs_btrip_corp_token = x_acs_btrip_corp_token

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.common_headers is not None:
            result['commonHeaders'] = self.common_headers
        if self.x_acs_btrip_corp_token is not None:
            result['x-acs-btrip-corp-token'] = self.x_acs_btrip_corp_token
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('commonHeaders') is not None:
            self.common_headers = m.get('commonHeaders')
        if m.get('x-acs-btrip-corp-token') is not None:
            self.x_acs_btrip_corp_token = m.get('x-acs-btrip-corp-token')
        return self


class CooperatorHotelBillSettlementQueryRequest(TeaModel):
    def __init__(
        self,
        bill_batch: str = None,
        cooperator_id: str = None,
        order_id: int = None,
        page_no: int = None,
        page_size: int = None,
        period_end: str = None,
        period_start: str = None,
        scroll_id: str = None,
        scroll_mod: bool = None,
    ):
        self.bill_batch = bill_batch
        self.cooperator_id = cooperator_id
        self.order_id = order_id
        # This parameter is required.
        self.page_no = page_no
        # This parameter is required.
        self.page_size = page_size
        self.period_end = period_end
        self.period_start = period_start
        self.scroll_id = scroll_id
        self.scroll_mod = scroll_mod

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.bill_batch is not None:
            result['bill_batch'] = self.bill_batch
        if self.cooperator_id is not None:
            result['cooperator_id'] = self.cooperator_id
        if self.order_id is not None:
            result['order_id'] = self.order_id
        if self.page_no is not None:
            result['page_no'] = self.page_no
        if self.page_size is not None:
            result['page_size'] = self.page_size
        if self.period_end is not None:
            result['period_end'] = self.period_end
        if self.period_start is not None:
            result['period_start'] = self.period_start
        if self.scroll_id is not None:
            result['scroll_id'] = self.scroll_id
        if self.scroll_mod is not None:
            result['scroll_mod'] = self.scroll_mod
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('bill_batch') is not None:
            self.bill_batch = m.get('bill_batch')
        if m.get('cooperator_id') is not None:
            self.cooperator_id = m.get('cooperator_id')
        if m.get('order_id') is not None:
            self.order_id = m.get('order_id')
        if m.get('page_no') is not None:
            self.page_no = m.get('page_no')
        if m.get('page_size') is not None:
            self.page_size = m.get('page_size')
        if m.get('period_end') is not None:
            self.period_end = m.get('period_end')
        if m.get('period_start') is not None:
            self.period_start = m.get('period_start')
        if m.get('scroll_id') is not None:
            self.scroll_id = m.get('scroll_id')
        if m.get('scroll_mod') is not None:
            self.scroll_mod = m.get('scroll_mod')
        return self


class CooperatorHotelBillSettlementQueryResponseBodyModuleItems(TeaModel):
    def __init__(
        self,
        adjust_time: str = None,
        alipay_trade_no: str = None,
        apply_arr_city_code: str = None,
        apply_arr_city_name: str = None,
        apply_dep_city_code: str = None,
        apply_dep_city_name: str = None,
        apply_extend_field: str = None,
        apply_id: str = None,
        approver_email: str = None,
        approver_id: str = None,
        approver_name: str = None,
        average_nights: float = None,
        base_location: str = None,
        bill_record_time: str = None,
        book_channel: str = None,
        book_mode: str = None,
        book_reason: str = None,
        book_time: str = None,
        booker_id: str = None,
        booker_job_no: str = None,
        booker_name: str = None,
        brand_group: str = None,
        brand_name: str = None,
        business_trip_result: str = None,
        capital_direction: str = None,
        cascade_department: str = None,
        category_desc: str = None,
        check_in_date: str = None,
        checkout_date: str = None,
        city: str = None,
        city_code: str = None,
        city_county: str = None,
        city_county_code: int = None,
        cooperator_bill_code: str = None,
        cooperator_name: str = None,
        cooperator_order_id: str = None,
        corp_refund_fee: float = None,
        corp_total_fee: float = None,
        cost_center: str = None,
        cost_center_number: str = None,
        cost_department: str = None,
        custom_content: str = None,
        department: str = None,
        department_id: str = None,
        exceed_reason: str = None,
        fee_type: str = None,
        fee_type_desc: str = None,
        fees: float = None,
        fines: float = None,
        foreigners_tag: str = None,
        fu_point_fee: float = None,
        hotel_name: str = None,
        index: str = None,
        invoice_title: str = None,
        is_early_departure: str = None,
        is_negotiation: str = None,
        is_share_str: str = None,
        location: str = None,
        mapping_company_code: str = None,
        nights: int = None,
        order_id: str = None,
        order_price: float = None,
        order_status_desc: str = None,
        order_type: str = None,
        over_apply_id: str = None,
        payment_department_id: str = None,
        payment_department_name: str = None,
        person_refund_fee: float = None,
        person_settle_price: float = None,
        position: str = None,
        position_level: str = None,
        primary_id: int = None,
        processor_oa_code: str = None,
        project_code: str = None,
        project_name: str = None,
        promotion_fee: float = None,
        remark: str = None,
        reserve_rule: int = None,
        room_no: str = None,
        room_number: int = None,
        room_price: float = None,
        room_type: str = None,
        service_fee: float = None,
        settle_type_desc: str = None,
        settlement_fee: float = None,
        settlement_grant_fee: float = None,
        settlement_time: str = None,
        settlement_type: str = None,
        sio: str = None,
        star: str = None,
        status: int = None,
        status_desc: str = None,
        sub_order_id: str = None,
        tax_rate: str = None,
        third_invoice_id: str = None,
        third_itinerary_id: str = None,
        total_nights: int = None,
        trade_action_desc: str = None,
        traveler_email: str = None,
        traveler_id: str = None,
        traveler_job_no: str = None,
        traveler_member_type: str = None,
        traveler_member_type_name: str = None,
        traveler_name: str = None,
        voucher_type: int = None,
        voucher_type_desc: str = None,
    ):
        self.adjust_time = adjust_time
        self.alipay_trade_no = alipay_trade_no
        self.apply_arr_city_code = apply_arr_city_code
        self.apply_arr_city_name = apply_arr_city_name
        self.apply_dep_city_code = apply_dep_city_code
        self.apply_dep_city_name = apply_dep_city_name
        self.apply_extend_field = apply_extend_field
        self.apply_id = apply_id
        self.approver_email = approver_email
        self.approver_id = approver_id
        self.approver_name = approver_name
        self.average_nights = average_nights
        self.base_location = base_location
        self.bill_record_time = bill_record_time
        self.book_channel = book_channel
        self.book_mode = book_mode
        self.book_reason = book_reason
        self.book_time = book_time
        self.booker_id = booker_id
        self.booker_job_no = booker_job_no
        self.booker_name = booker_name
        self.brand_group = brand_group
        self.brand_name = brand_name
        self.business_trip_result = business_trip_result
        self.capital_direction = capital_direction
        self.cascade_department = cascade_department
        self.category_desc = category_desc
        self.check_in_date = check_in_date
        self.checkout_date = checkout_date
        self.city = city
        self.city_code = city_code
        self.city_county = city_county
        self.city_county_code = city_county_code
        self.cooperator_bill_code = cooperator_bill_code
        self.cooperator_name = cooperator_name
        self.cooperator_order_id = cooperator_order_id
        self.corp_refund_fee = corp_refund_fee
        self.corp_total_fee = corp_total_fee
        self.cost_center = cost_center
        self.cost_center_number = cost_center_number
        self.cost_department = cost_department
        self.custom_content = custom_content
        self.department = department
        self.department_id = department_id
        self.exceed_reason = exceed_reason
        self.fee_type = fee_type
        self.fee_type_desc = fee_type_desc
        self.fees = fees
        self.fines = fines
        self.foreigners_tag = foreigners_tag
        self.fu_point_fee = fu_point_fee
        self.hotel_name = hotel_name
        self.index = index
        self.invoice_title = invoice_title
        self.is_early_departure = is_early_departure
        self.is_negotiation = is_negotiation
        self.is_share_str = is_share_str
        self.location = location
        self.mapping_company_code = mapping_company_code
        self.nights = nights
        self.order_id = order_id
        self.order_price = order_price
        self.order_status_desc = order_status_desc
        self.order_type = order_type
        self.over_apply_id = over_apply_id
        self.payment_department_id = payment_department_id
        self.payment_department_name = payment_department_name
        self.person_refund_fee = person_refund_fee
        self.person_settle_price = person_settle_price
        self.position = position
        self.position_level = position_level
        self.primary_id = primary_id
        self.processor_oa_code = processor_oa_code
        self.project_code = project_code
        self.project_name = project_name
        self.promotion_fee = promotion_fee
        self.remark = remark
        self.reserve_rule = reserve_rule
        self.room_no = room_no
        self.room_number = room_number
        self.room_price = room_price
        self.room_type = room_type
        self.service_fee = service_fee
        self.settle_type_desc = settle_type_desc
        self.settlement_fee = settlement_fee
        self.settlement_grant_fee = settlement_grant_fee
        self.settlement_time = settlement_time
        self.settlement_type = settlement_type
        self.sio = sio
        self.star = star
        self.status = status
        self.status_desc = status_desc
        self.sub_order_id = sub_order_id
        self.tax_rate = tax_rate
        self.third_invoice_id = third_invoice_id
        self.third_itinerary_id = third_itinerary_id
        self.total_nights = total_nights
        self.trade_action_desc = trade_action_desc
        self.traveler_email = traveler_email
        self.traveler_id = traveler_id
        self.traveler_job_no = traveler_job_no
        self.traveler_member_type = traveler_member_type
        self.traveler_member_type_name = traveler_member_type_name
        self.traveler_name = traveler_name
        self.voucher_type = voucher_type
        self.voucher_type_desc = voucher_type_desc

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.adjust_time is not None:
            result['adjust_time'] = self.adjust_time
        if self.alipay_trade_no is not None:
            result['alipay_trade_no'] = self.alipay_trade_no
        if self.apply_arr_city_code is not None:
            result['apply_arr_city_code'] = self.apply_arr_city_code
        if self.apply_arr_city_name is not None:
            result['apply_arr_city_name'] = self.apply_arr_city_name
        if self.apply_dep_city_code is not None:
            result['apply_dep_city_code'] = self.apply_dep_city_code
        if self.apply_dep_city_name is not None:
            result['apply_dep_city_name'] = self.apply_dep_city_name
        if self.apply_extend_field is not None:
            result['apply_extend_field'] = self.apply_extend_field
        if self.apply_id is not None:
            result['apply_id'] = self.apply_id
        if self.approver_email is not None:
            result['approver_email'] = self.approver_email
        if self.approver_id is not None:
            result['approver_id'] = self.approver_id
        if self.approver_name is not None:
            result['approver_name'] = self.approver_name
        if self.average_nights is not None:
            result['average_nights'] = self.average_nights
        if self.base_location is not None:
            result['base_location'] = self.base_location
        if self.bill_record_time is not None:
            result['bill_record_time'] = self.bill_record_time
        if self.book_channel is not None:
            result['book_channel'] = self.book_channel
        if self.book_mode is not None:
            result['book_mode'] = self.book_mode
        if self.book_reason is not None:
            result['book_reason'] = self.book_reason
        if self.book_time is not None:
            result['book_time'] = self.book_time
        if self.booker_id is not None:
            result['booker_id'] = self.booker_id
        if self.booker_job_no is not None:
            result['booker_job_no'] = self.booker_job_no
        if self.booker_name is not None:
            result['booker_name'] = self.booker_name
        if self.brand_group is not None:
            result['brand_group'] = self.brand_group
        if self.brand_name is not None:
            result['brand_name'] = self.brand_name
        if self.business_trip_result is not None:
            result['business_trip_result'] = self.business_trip_result
        if self.capital_direction is not None:
            result['capital_direction'] = self.capital_direction
        if self.cascade_department is not None:
            result['cascade_department'] = self.cascade_department
        if self.category_desc is not None:
            result['category_desc'] = self.category_desc
        if self.check_in_date is not None:
            result['check_in_date'] = self.check_in_date
        if self.checkout_date is not None:
            result['checkout_date'] = self.checkout_date
        if self.city is not None:
            result['city'] = self.city
        if self.city_code is not None:
            result['city_code'] = self.city_code
        if self.city_county is not None:
            result['city_county'] = self.city_county
        if self.city_county_code is not None:
            result['city_county_code'] = self.city_county_code
        if self.cooperator_bill_code is not None:
            result['cooperator_bill_code'] = self.cooperator_bill_code
        if self.cooperator_name is not None:
            result['cooperator_name'] = self.cooperator_name
        if self.cooperator_order_id is not None:
            result['cooperator_order_id'] = self.cooperator_order_id
        if self.corp_refund_fee is not None:
            result['corp_refund_fee'] = self.corp_refund_fee
        if self.corp_total_fee is not None:
            result['corp_total_fee'] = self.corp_total_fee
        if self.cost_center is not None:
            result['cost_center'] = self.cost_center
        if self.cost_center_number is not None:
            result['cost_center_number'] = self.cost_center_number
        if self.cost_department is not None:
            result['cost_department'] = self.cost_department
        if self.custom_content is not None:
            result['custom_content'] = self.custom_content
        if self.department is not None:
            result['department'] = self.department
        if self.department_id is not None:
            result['department_id'] = self.department_id
        if self.exceed_reason is not None:
            result['exceed_reason'] = self.exceed_reason
        if self.fee_type is not None:
            result['fee_type'] = self.fee_type
        if self.fee_type_desc is not None:
            result['fee_type_desc'] = self.fee_type_desc
        if self.fees is not None:
            result['fees'] = self.fees
        if self.fines is not None:
            result['fines'] = self.fines
        if self.foreigners_tag is not None:
            result['foreigners_tag'] = self.foreigners_tag
        if self.fu_point_fee is not None:
            result['fu_point_fee'] = self.fu_point_fee
        if self.hotel_name is not None:
            result['hotel_name'] = self.hotel_name
        if self.index is not None:
            result['index'] = self.index
        if self.invoice_title is not None:
            result['invoice_title'] = self.invoice_title
        if self.is_early_departure is not None:
            result['is_early_departure'] = self.is_early_departure
        if self.is_negotiation is not None:
            result['is_negotiation'] = self.is_negotiation
        if self.is_share_str is not None:
            result['is_share_str'] = self.is_share_str
        if self.location is not None:
            result['location'] = self.location
        if self.mapping_company_code is not None:
            result['mapping_company_code'] = self.mapping_company_code
        if self.nights is not None:
            result['nights'] = self.nights
        if self.order_id is not None:
            result['order_id'] = self.order_id
        if self.order_price is not None:
            result['order_price'] = self.order_price
        if self.order_status_desc is not None:
            result['order_status_desc'] = self.order_status_desc
        if self.order_type is not None:
            result['order_type'] = self.order_type
        if self.over_apply_id is not None:
            result['over_apply_id'] = self.over_apply_id
        if self.payment_department_id is not None:
            result['payment_department_id'] = self.payment_department_id
        if self.payment_department_name is not None:
            result['payment_department_name'] = self.payment_department_name
        if self.person_refund_fee is not None:
            result['person_refund_fee'] = self.person_refund_fee
        if self.person_settle_price is not None:
            result['person_settle_price'] = self.person_settle_price
        if self.position is not None:
            result['position'] = self.position
        if self.position_level is not None:
            result['position_level'] = self.position_level
        if self.primary_id is not None:
            result['primary_id'] = self.primary_id
        if self.processor_oa_code is not None:
            result['processor_oa_code'] = self.processor_oa_code
        if self.project_code is not None:
            result['project_code'] = self.project_code
        if self.project_name is not None:
            result['project_name'] = self.project_name
        if self.promotion_fee is not None:
            result['promotion_fee'] = self.promotion_fee
        if self.remark is not None:
            result['remark'] = self.remark
        if self.reserve_rule is not None:
            result['reserve_rule'] = self.reserve_rule
        if self.room_no is not None:
            result['room_no'] = self.room_no
        if self.room_number is not None:
            result['room_number'] = self.room_number
        if self.room_price is not None:
            result['room_price'] = self.room_price
        if self.room_type is not None:
            result['room_type'] = self.room_type
        if self.service_fee is not None:
            result['service_fee'] = self.service_fee
        if self.settle_type_desc is not None:
            result['settle_type_desc'] = self.settle_type_desc
        if self.settlement_fee is not None:
            result['settlement_fee'] = self.settlement_fee
        if self.settlement_grant_fee is not None:
            result['settlement_grant_fee'] = self.settlement_grant_fee
        if self.settlement_time is not None:
            result['settlement_time'] = self.settlement_time
        if self.settlement_type is not None:
            result['settlement_type'] = self.settlement_type
        if self.sio is not None:
            result['sio'] = self.sio
        if self.star is not None:
            result['star'] = self.star
        if self.status is not None:
            result['status'] = self.status
        if self.status_desc is not None:
            result['status_desc'] = self.status_desc
        if self.sub_order_id is not None:
            result['sub_order_id'] = self.sub_order_id
        if self.tax_rate is not None:
            result['tax_rate'] = self.tax_rate
        if self.third_invoice_id is not None:
            result['third_invoice_id'] = self.third_invoice_id
        if self.third_itinerary_id is not None:
            result['third_itinerary_id'] = self.third_itinerary_id
        if self.total_nights is not None:
            result['total_nights'] = self.total_nights
        if self.trade_action_desc is not None:
            result['trade_action_desc'] = self.trade_action_desc
        if self.traveler_email is not None:
            result['traveler_email'] = self.traveler_email
        if self.traveler_id is not None:
            result['traveler_id'] = self.traveler_id
        if self.traveler_job_no is not None:
            result['traveler_job_no'] = self.traveler_job_no
        if self.traveler_member_type is not None:
            result['traveler_member_type'] = self.traveler_member_type
        if self.traveler_member_type_name is not None:
            result['traveler_member_type_name'] = self.traveler_member_type_name
        if self.traveler_name is not None:
            result['traveler_name'] = self.traveler_name
        if self.voucher_type is not None:
            result['voucher_type'] = self.voucher_type
        if self.voucher_type_desc is not None:
            result['voucher_type_desc'] = self.voucher_type_desc
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('adjust_time') is not None:
            self.adjust_time = m.get('adjust_time')
        if m.get('alipay_trade_no') is not None:
            self.alipay_trade_no = m.get('alipay_trade_no')
        if m.get('apply_arr_city_code') is not None:
            self.apply_arr_city_code = m.get('apply_arr_city_code')
        if m.get('apply_arr_city_name') is not None:
            self.apply_arr_city_name = m.get('apply_arr_city_name')
        if m.get('apply_dep_city_code') is not None:
            self.apply_dep_city_code = m.get('apply_dep_city_code')
        if m.get('apply_dep_city_name') is not None:
            self.apply_dep_city_name = m.get('apply_dep_city_name')
        if m.get('apply_extend_field') is not None:
            self.apply_extend_field = m.get('apply_extend_field')
        if m.get('apply_id') is not None:
            self.apply_id = m.get('apply_id')
        if m.get('approver_email') is not None:
            self.approver_email = m.get('approver_email')
        if m.get('approver_id') is not None:
            self.approver_id = m.get('approver_id')
        if m.get('approver_name') is not None:
            self.approver_name = m.get('approver_name')
        if m.get('average_nights') is not None:
            self.average_nights = m.get('average_nights')
        if m.get('base_location') is not None:
            self.base_location = m.get('base_location')
        if m.get('bill_record_time') is not None:
            self.bill_record_time = m.get('bill_record_time')
        if m.get('book_channel') is not None:
            self.book_channel = m.get('book_channel')
        if m.get('book_mode') is not None:
            self.book_mode = m.get('book_mode')
        if m.get('book_reason') is not None:
            self.book_reason = m.get('book_reason')
        if m.get('book_time') is not None:
            self.book_time = m.get('book_time')
        if m.get('booker_id') is not None:
            self.booker_id = m.get('booker_id')
        if m.get('booker_job_no') is not None:
            self.booker_job_no = m.get('booker_job_no')
        if m.get('booker_name') is not None:
            self.booker_name = m.get('booker_name')
        if m.get('brand_group') is not None:
            self.brand_group = m.get('brand_group')
        if m.get('brand_name') is not None:
            self.brand_name = m.get('brand_name')
        if m.get('business_trip_result') is not None:
            self.business_trip_result = m.get('business_trip_result')
        if m.get('capital_direction') is not None:
            self.capital_direction = m.get('capital_direction')
        if m.get('cascade_department') is not None:
            self.cascade_department = m.get('cascade_department')
        if m.get('category_desc') is not None:
            self.category_desc = m.get('category_desc')
        if m.get('check_in_date') is not None:
            self.check_in_date = m.get('check_in_date')
        if m.get('checkout_date') is not None:
            self.checkout_date = m.get('checkout_date')
        if m.get('city') is not None:
            self.city = m.get('city')
        if m.get('city_code') is not None:
            self.city_code = m.get('city_code')
        if m.get('city_county') is not None:
            self.city_county = m.get('city_county')
        if m.get('city_county_code') is not None:
            self.city_county_code = m.get('city_county_code')
        if m.get('cooperator_bill_code') is not None:
            self.cooperator_bill_code = m.get('cooperator_bill_code')
        if m.get('cooperator_name') is not None:
            self.cooperator_name = m.get('cooperator_name')
        if m.get('cooperator_order_id') is not None:
            self.cooperator_order_id = m.get('cooperator_order_id')
        if m.get('corp_refund_fee') is not None:
            self.corp_refund_fee = m.get('corp_refund_fee')
        if m.get('corp_total_fee') is not None:
            self.corp_total_fee = m.get('corp_total_fee')
        if m.get('cost_center') is not None:
            self.cost_center = m.get('cost_center')
        if m.get('cost_center_number') is not None:
            self.cost_center_number = m.get('cost_center_number')
        if m.get('cost_department') is not None:
            self.cost_department = m.get('cost_department')
        if m.get('custom_content') is not None:
            self.custom_content = m.get('custom_content')
        if m.get('department') is not None:
            self.department = m.get('department')
        if m.get('department_id') is not None:
            self.department_id = m.get('department_id')
        if m.get('exceed_reason') is not None:
            self.exceed_reason = m.get('exceed_reason')
        if m.get('fee_type') is not None:
            self.fee_type = m.get('fee_type')
        if m.get('fee_type_desc') is not None:
            self.fee_type_desc = m.get('fee_type_desc')
        if m.get('fees') is not None:
            self.fees = m.get('fees')
        if m.get('fines') is not None:
            self.fines = m.get('fines')
        if m.get('foreigners_tag') is not None:
            self.foreigners_tag = m.get('foreigners_tag')
        if m.get('fu_point_fee') is not None:
            self.fu_point_fee = m.get('fu_point_fee')
        if m.get('hotel_name') is not None:
            self.hotel_name = m.get('hotel_name')
        if m.get('index') is not None:
            self.index = m.get('index')
        if m.get('invoice_title') is not None:
            self.invoice_title = m.get('invoice_title')
        if m.get('is_early_departure') is not None:
            self.is_early_departure = m.get('is_early_departure')
        if m.get('is_negotiation') is not None:
            self.is_negotiation = m.get('is_negotiation')
        if m.get('is_share_str') is not None:
            self.is_share_str = m.get('is_share_str')
        if m.get('location') is not None:
            self.location = m.get('location')
        if m.get('mapping_company_code') is not None:
            self.mapping_company_code = m.get('mapping_company_code')
        if m.get('nights') is not None:
            self.nights = m.get('nights')
        if m.get('order_id') is not None:
            self.order_id = m.get('order_id')
        if m.get('order_price') is not None:
            self.order_price = m.get('order_price')
        if m.get('order_status_desc') is not None:
            self.order_status_desc = m.get('order_status_desc')
        if m.get('order_type') is not None:
            self.order_type = m.get('order_type')
        if m.get('over_apply_id') is not None:
            self.over_apply_id = m.get('over_apply_id')
        if m.get('payment_department_id') is not None:
            self.payment_department_id = m.get('payment_department_id')
        if m.get('payment_department_name') is not None:
            self.payment_department_name = m.get('payment_department_name')
        if m.get('person_refund_fee') is not None:
            self.person_refund_fee = m.get('person_refund_fee')
        if m.get('person_settle_price') is not None:
            self.person_settle_price = m.get('person_settle_price')
        if m.get('position') is not None:
            self.position = m.get('position')
        if m.get('position_level') is not None:
            self.position_level = m.get('position_level')
        if m.get('primary_id') is not None:
            self.primary_id = m.get('primary_id')
        if m.get('processor_oa_code') is not None:
            self.processor_oa_code = m.get('processor_oa_code')
        if m.get('project_code') is not None:
            self.project_code = m.get('project_code')
        if m.get('project_name') is not None:
            self.project_name = m.get('project_name')
        if m.get('promotion_fee') is not None:
            self.promotion_fee = m.get('promotion_fee')
        if m.get('remark') is not None:
            self.remark = m.get('remark')
        if m.get('reserve_rule') is not None:
            self.reserve_rule = m.get('reserve_rule')
        if m.get('room_no') is not None:
            self.room_no = m.get('room_no')
        if m.get('room_number') is not None:
            self.room_number = m.get('room_number')
        if m.get('room_price') is not None:
            self.room_price = m.get('room_price')
        if m.get('room_type') is not None:
            self.room_type = m.get('room_type')
        if m.get('service_fee') is not None:
            self.service_fee = m.get('service_fee')
        if m.get('settle_type_desc') is not None:
            self.settle_type_desc = m.get('settle_type_desc')
        if m.get('settlement_fee') is not None:
            self.settlement_fee = m.get('settlement_fee')
        if m.get('settlement_grant_fee') is not None:
            self.settlement_grant_fee = m.get('settlement_grant_fee')
        if m.get('settlement_time') is not None:
            self.settlement_time = m.get('settlement_time')
        if m.get('settlement_type') is not None:
            self.settlement_type = m.get('settlement_type')
        if m.get('sio') is not None:
            self.sio = m.get('sio')
        if m.get('star') is not None:
            self.star = m.get('star')
        if m.get('status') is not None:
            self.status = m.get('status')
        if m.get('status_desc') is not None:
            self.status_desc = m.get('status_desc')
        if m.get('sub_order_id') is not None:
            self.sub_order_id = m.get('sub_order_id')
        if m.get('tax_rate') is not None:
            self.tax_rate = m.get('tax_rate')
        if m.get('third_invoice_id') is not None:
            self.third_invoice_id = m.get('third_invoice_id')
        if m.get('third_itinerary_id') is not None:
            self.third_itinerary_id = m.get('third_itinerary_id')
        if m.get('total_nights') is not None:
            self.total_nights = m.get('total_nights')
        if m.get('trade_action_desc') is not None:
            self.trade_action_desc = m.get('trade_action_desc')
        if m.get('traveler_email') is not None:
            self.traveler_email = m.get('traveler_email')
        if m.get('traveler_id') is not None:
            self.traveler_id = m.get('traveler_id')
        if m.get('traveler_job_no') is not None:
            self.traveler_job_no = m.get('traveler_job_no')
        if m.get('traveler_member_type') is not None:
            self.traveler_member_type = m.get('traveler_member_type')
        if m.get('traveler_member_type_name') is not None:
            self.traveler_member_type_name = m.get('traveler_member_type_name')
        if m.get('traveler_name') is not None:
            self.traveler_name = m.get('traveler_name')
        if m.get('voucher_type') is not None:
            self.voucher_type = m.get('voucher_type')
        if m.get('voucher_type_desc') is not None:
            self.voucher_type_desc = m.get('voucher_type_desc')
        return self


class CooperatorHotelBillSettlementQueryResponseBodyModule(TeaModel):
    def __init__(
        self,
        category: int = None,
        corp_id: str = None,
        items: List[CooperatorHotelBillSettlementQueryResponseBodyModuleItems] = None,
        period_end: str = None,
        period_start: str = None,
        scroll_id: str = None,
        total_size: int = None,
    ):
        self.category = category
        self.corp_id = corp_id
        self.items = items
        self.period_end = period_end
        self.period_start = period_start
        self.scroll_id = scroll_id
        self.total_size = total_size

    def validate(self):
        if self.items:
            for k in self.items:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.category is not None:
            result['category'] = self.category
        if self.corp_id is not None:
            result['corp_id'] = self.corp_id
        result['items'] = []
        if self.items is not None:
            for k in self.items:
                result['items'].append(k.to_map() if k else None)
        if self.period_end is not None:
            result['period_end'] = self.period_end
        if self.period_start is not None:
            result['period_start'] = self.period_start
        if self.scroll_id is not None:
            result['scroll_id'] = self.scroll_id
        if self.total_size is not None:
            result['total_size'] = self.total_size
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('category') is not None:
            self.category = m.get('category')
        if m.get('corp_id') is not None:
            self.corp_id = m.get('corp_id')
        self.items = []
        if m.get('items') is not None:
            for k in m.get('items'):
                temp_model = CooperatorHotelBillSettlementQueryResponseBodyModuleItems()
                self.items.append(temp_model.from_map(k))
        if m.get('period_end') is not None:
            self.period_end = m.get('period_end')
        if m.get('period_start') is not None:
            self.period_start = m.get('period_start')
        if m.get('scroll_id') is not None:
            self.scroll_id = m.get('scroll_id')
        if m.get('total_size') is not None:
            self.total_size = m.get('total_size')
        return self


class CooperatorHotelBillSettlementQueryResponseBody(TeaModel):
    def __init__(
        self,
        code: str = None,
        message: str = None,
        module: CooperatorHotelBillSettlementQueryResponseBodyModule = None,
        request_id: str = None,
        success: bool = None,
        trace_id: str = None,
    ):
        self.code = code
        self.message = message
        self.module = module
        # requestId
        self.request_id = request_id
        self.success = success
        # traceId
        self.trace_id = trace_id

    def validate(self):
        if self.module:
            self.module.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['code'] = self.code
        if self.message is not None:
            result['message'] = self.message
        if self.module is not None:
            result['module'] = self.module.to_map()
        if self.request_id is not None:
            result['requestId'] = self.request_id
        if self.success is not None:
            result['success'] = self.success
        if self.trace_id is not None:
            result['traceId'] = self.trace_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('code') is not None:
            self.code = m.get('code')
        if m.get('message') is not None:
            self.message = m.get('message')
        if m.get('module') is not None:
            temp_model = CooperatorHotelBillSettlementQueryResponseBodyModule()
            self.module = temp_model.from_map(m['module'])
        if m.get('requestId') is not None:
            self.request_id = m.get('requestId')
        if m.get('success') is not None:
            self.success = m.get('success')
        if m.get('traceId') is not None:
            self.trace_id = m.get('traceId')
        return self


class CooperatorHotelBillSettlementQueryResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: CooperatorHotelBillSettlementQueryResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = CooperatorHotelBillSettlementQueryResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CooperatorHotelEventPushHeaders(TeaModel):
    def __init__(
        self,
        common_headers: Dict[str, str] = None,
        x_acs_btrip_corp_token: str = None,
    ):
        self.common_headers = common_headers
        self.x_acs_btrip_corp_token = x_acs_btrip_corp_token

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.common_headers is not None:
            result['commonHeaders'] = self.common_headers
        if self.x_acs_btrip_corp_token is not None:
            result['x-acs-btrip-corp-token'] = self.x_acs_btrip_corp_token
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('commonHeaders') is not None:
            self.common_headers = m.get('commonHeaders')
        if m.get('x-acs-btrip-corp-token') is not None:
            self.x_acs_btrip_corp_token = m.get('x-acs-btrip-corp-token')
        return self


class CooperatorHotelEventPushRequest(TeaModel):
    def __init__(
        self,
        change_order_status: int = None,
        change_order_status_desc: str = None,
        cooperator_order_id: str = None,
        event: str = None,
        event_desc: str = None,
        event_time: str = None,
        order_id: str = None,
    ):
        self.change_order_status = change_order_status
        self.change_order_status_desc = change_order_status_desc
        # This parameter is required.
        self.cooperator_order_id = cooperator_order_id
        # This parameter is required.
        self.event = event
        self.event_desc = event_desc
        # This parameter is required.
        self.event_time = event_time
        # This parameter is required.
        self.order_id = order_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.change_order_status is not None:
            result['change_order_status'] = self.change_order_status
        if self.change_order_status_desc is not None:
            result['change_order_status_desc'] = self.change_order_status_desc
        if self.cooperator_order_id is not None:
            result['cooperator_order_id'] = self.cooperator_order_id
        if self.event is not None:
            result['event'] = self.event
        if self.event_desc is not None:
            result['event_desc'] = self.event_desc
        if self.event_time is not None:
            result['event_time'] = self.event_time
        if self.order_id is not None:
            result['order_id'] = self.order_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('change_order_status') is not None:
            self.change_order_status = m.get('change_order_status')
        if m.get('change_order_status_desc') is not None:
            self.change_order_status_desc = m.get('change_order_status_desc')
        if m.get('cooperator_order_id') is not None:
            self.cooperator_order_id = m.get('cooperator_order_id')
        if m.get('event') is not None:
            self.event = m.get('event')
        if m.get('event_desc') is not None:
            self.event_desc = m.get('event_desc')
        if m.get('event_time') is not None:
            self.event_time = m.get('event_time')
        if m.get('order_id') is not None:
            self.order_id = m.get('order_id')
        return self


class CooperatorHotelEventPushResponseBody(TeaModel):
    def __init__(
        self,
        code: str = None,
        message: str = None,
        module: bool = None,
        request_id: str = None,
        success: bool = None,
    ):
        self.code = code
        self.message = message
        self.module = module
        self.request_id = request_id
        self.success = success

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['code'] = self.code
        if self.message is not None:
            result['message'] = self.message
        if self.module is not None:
            result['module'] = self.module
        if self.request_id is not None:
            result['requestId'] = self.request_id
        if self.success is not None:
            result['success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('code') is not None:
            self.code = m.get('code')
        if m.get('message') is not None:
            self.message = m.get('message')
        if m.get('module') is not None:
            self.module = m.get('module')
        if m.get('requestId') is not None:
            self.request_id = m.get('requestId')
        if m.get('success') is not None:
            self.success = m.get('success')
        return self


class CooperatorHotelEventPushResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: CooperatorHotelEventPushResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = CooperatorHotelEventPushResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CooperatorSyncPayStatusHeaders(TeaModel):
    def __init__(
        self,
        common_headers: Dict[str, str] = None,
        x_acs_btrip_corp_token: str = None,
    ):
        self.common_headers = common_headers
        self.x_acs_btrip_corp_token = x_acs_btrip_corp_token

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.common_headers is not None:
            result['commonHeaders'] = self.common_headers
        if self.x_acs_btrip_corp_token is not None:
            result['x-acs-btrip-corp-token'] = self.x_acs_btrip_corp_token
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('commonHeaders') is not None:
            self.common_headers = m.get('commonHeaders')
        if m.get('x-acs-btrip-corp-token') is not None:
            self.x_acs_btrip_corp_token = m.get('x-acs-btrip-corp-token')
        return self


class CooperatorSyncPayStatusRequest(TeaModel):
    def __init__(
        self,
        cooperator_order_id: str = None,
        cooperator_pay_no: str = None,
        order_id: str = None,
        pay_status: str = None,
        pay_time: int = None,
    ):
        # This parameter is required.
        self.cooperator_order_id = cooperator_order_id
        # This parameter is required.
        self.cooperator_pay_no = cooperator_pay_no
        # This parameter is required.
        self.order_id = order_id
        # This parameter is required.
        self.pay_status = pay_status
        # This parameter is required.
        self.pay_time = pay_time

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.cooperator_order_id is not None:
            result['cooperator_order_id'] = self.cooperator_order_id
        if self.cooperator_pay_no is not None:
            result['cooperator_pay_no'] = self.cooperator_pay_no
        if self.order_id is not None:
            result['order_id'] = self.order_id
        if self.pay_status is not None:
            result['pay_status'] = self.pay_status
        if self.pay_time is not None:
            result['pay_time'] = self.pay_time
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('cooperator_order_id') is not None:
            self.cooperator_order_id = m.get('cooperator_order_id')
        if m.get('cooperator_pay_no') is not None:
            self.cooperator_pay_no = m.get('cooperator_pay_no')
        if m.get('order_id') is not None:
            self.order_id = m.get('order_id')
        if m.get('pay_status') is not None:
            self.pay_status = m.get('pay_status')
        if m.get('pay_time') is not None:
            self.pay_time = m.get('pay_time')
        return self


class CooperatorSyncPayStatusResponseBody(TeaModel):
    def __init__(
        self,
        code: str = None,
        message: str = None,
        request_id: str = None,
        success: bool = None,
    ):
        self.code = code
        self.message = message
        self.request_id = request_id
        self.success = success

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['code'] = self.code
        if self.message is not None:
            result['message'] = self.message
        if self.request_id is not None:
            result['requestId'] = self.request_id
        if self.success is not None:
            result['success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('code') is not None:
            self.code = m.get('code')
        if m.get('message') is not None:
            self.message = m.get('message')
        if m.get('requestId') is not None:
            self.request_id = m.get('requestId')
        if m.get('success') is not None:
            self.success = m.get('success')
        return self


class CooperatorSyncPayStatusResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: CooperatorSyncPayStatusResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = CooperatorSyncPayStatusResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CorpAuthLinkInfoQueryResponseBodyModuleLinkCorps(TeaModel):
    def __init__(
        self,
        corp_name: str = None,
        open_corp_id: str = None,
        true_corp_id: str = None,
    ):
        self.corp_name = corp_name
        self.open_corp_id = open_corp_id
        self.true_corp_id = true_corp_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.corp_name is not None:
            result['corp_name'] = self.corp_name
        if self.open_corp_id is not None:
            result['open_corp_id'] = self.open_corp_id
        if self.true_corp_id is not None:
            result['true_corp_id'] = self.true_corp_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('corp_name') is not None:
            self.corp_name = m.get('corp_name')
        if m.get('open_corp_id') is not None:
            self.open_corp_id = m.get('open_corp_id')
        if m.get('true_corp_id') is not None:
            self.true_corp_id = m.get('true_corp_id')
        return self


class CorpAuthLinkInfoQueryResponseBodyModuleOrgCorp(TeaModel):
    def __init__(
        self,
        corp_name: str = None,
        open_corp_id: str = None,
        true_corp_id: str = None,
    ):
        self.corp_name = corp_name
        self.open_corp_id = open_corp_id
        self.true_corp_id = true_corp_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.corp_name is not None:
            result['corp_name'] = self.corp_name
        if self.open_corp_id is not None:
            result['open_corp_id'] = self.open_corp_id
        if self.true_corp_id is not None:
            result['true_corp_id'] = self.true_corp_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('corp_name') is not None:
            self.corp_name = m.get('corp_name')
        if m.get('open_corp_id') is not None:
            self.open_corp_id = m.get('open_corp_id')
        if m.get('true_corp_id') is not None:
            self.true_corp_id = m.get('true_corp_id')
        return self


class CorpAuthLinkInfoQueryResponseBodyModule(TeaModel):
    def __init__(
        self,
        link_corps: List[CorpAuthLinkInfoQueryResponseBodyModuleLinkCorps] = None,
        org_corp: CorpAuthLinkInfoQueryResponseBodyModuleOrgCorp = None,
    ):
        self.link_corps = link_corps
        self.org_corp = org_corp

    def validate(self):
        if self.link_corps:
            for k in self.link_corps:
                if k:
                    k.validate()
        if self.org_corp:
            self.org_corp.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['link_corps'] = []
        if self.link_corps is not None:
            for k in self.link_corps:
                result['link_corps'].append(k.to_map() if k else None)
        if self.org_corp is not None:
            result['org_corp'] = self.org_corp.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.link_corps = []
        if m.get('link_corps') is not None:
            for k in m.get('link_corps'):
                temp_model = CorpAuthLinkInfoQueryResponseBodyModuleLinkCorps()
                self.link_corps.append(temp_model.from_map(k))
        if m.get('org_corp') is not None:
            temp_model = CorpAuthLinkInfoQueryResponseBodyModuleOrgCorp()
            self.org_corp = temp_model.from_map(m['org_corp'])
        return self


class CorpAuthLinkInfoQueryResponseBody(TeaModel):
    def __init__(
        self,
        code: str = None,
        message: str = None,
        module: CorpAuthLinkInfoQueryResponseBodyModule = None,
        request_id: str = None,
        trace_id: str = None,
    ):
        self.code = code
        self.message = message
        self.module = module
        self.request_id = request_id
        self.trace_id = trace_id

    def validate(self):
        if self.module:
            self.module.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['code'] = self.code
        if self.message is not None:
            result['message'] = self.message
        if self.module is not None:
            result['module'] = self.module.to_map()
        if self.request_id is not None:
            result['requestId'] = self.request_id
        if self.trace_id is not None:
            result['traceId'] = self.trace_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('code') is not None:
            self.code = m.get('code')
        if m.get('message') is not None:
            self.message = m.get('message')
        if m.get('module') is not None:
            temp_model = CorpAuthLinkInfoQueryResponseBodyModule()
            self.module = temp_model.from_map(m['module'])
        if m.get('requestId') is not None:
            self.request_id = m.get('requestId')
        if m.get('traceId') is not None:
            self.trace_id = m.get('traceId')
        return self


class CorpAuthLinkInfoQueryResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: CorpAuthLinkInfoQueryResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = CorpAuthLinkInfoQueryResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CorpTokenHeaders(TeaModel):
    def __init__(
        self,
        common_headers: Dict[str, str] = None,
        x_acs_btrip_access_token: str = None,
    ):
        self.common_headers = common_headers
        self.x_acs_btrip_access_token = x_acs_btrip_access_token

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.common_headers is not None:
            result['commonHeaders'] = self.common_headers
        if self.x_acs_btrip_access_token is not None:
            result['x-acs-btrip-access-token'] = self.x_acs_btrip_access_token
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('commonHeaders') is not None:
            self.common_headers = m.get('commonHeaders')
        if m.get('x-acs-btrip-access-token') is not None:
            self.x_acs_btrip_access_token = m.get('x-acs-btrip-access-token')
        return self


class CorpTokenRequest(TeaModel):
    def __init__(
        self,
        app_secret: str = None,
        corp_id: str = None,
        type: int = None,
    ):
        self.app_secret = app_secret
        # This parameter is required.
        self.corp_id = corp_id
        # This parameter is required.
        self.type = type

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.app_secret is not None:
            result['app_secret'] = self.app_secret
        if self.corp_id is not None:
            result['corp_id'] = self.corp_id
        if self.type is not None:
            result['type'] = self.type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('app_secret') is not None:
            self.app_secret = m.get('app_secret')
        if m.get('corp_id') is not None:
            self.corp_id = m.get('corp_id')
        if m.get('type') is not None:
            self.type = m.get('type')
        return self


class CorpTokenResponseBodyData(TeaModel):
    def __init__(
        self,
        expire: int = None,
        token: str = None,
    ):
        self.expire = expire
        self.token = token

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.expire is not None:
            result['expire'] = self.expire
        if self.token is not None:
            result['token'] = self.token
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('expire') is not None:
            self.expire = m.get('expire')
        if m.get('token') is not None:
            self.token = m.get('token')
        return self


class CorpTokenResponseBodyModule(TeaModel):
    def __init__(
        self,
        expire: int = None,
        start: int = None,
        token: str = None,
    ):
        self.expire = expire
        self.start = start
        self.token = token

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.expire is not None:
            result['expire'] = self.expire
        if self.start is not None:
            result['start'] = self.start
        if self.token is not None:
            result['token'] = self.token
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('expire') is not None:
            self.expire = m.get('expire')
        if m.get('start') is not None:
            self.start = m.get('start')
        if m.get('token') is not None:
            self.token = m.get('token')
        return self


class CorpTokenResponseBody(TeaModel):
    def __init__(
        self,
        code: str = None,
        data: CorpTokenResponseBodyData = None,
        message: str = None,
        module: CorpTokenResponseBodyModule = None,
        request_id: str = None,
        success: bool = None,
        trace_id: str = None,
    ):
        self.code = code
        self.data = data
        self.message = message
        self.module = module
        self.request_id = request_id
        # 是否成功
        self.success = success
        # traceId
        self.trace_id = trace_id

    def validate(self):
        if self.data:
            self.data.validate()
        if self.module:
            self.module.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['code'] = self.code
        if self.data is not None:
            result['data'] = self.data.to_map()
        if self.message is not None:
            result['message'] = self.message
        if self.module is not None:
            result['module'] = self.module.to_map()
        if self.request_id is not None:
            result['requestId'] = self.request_id
        if self.success is not None:
            result['success'] = self.success
        if self.trace_id is not None:
            result['traceId'] = self.trace_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('code') is not None:
            self.code = m.get('code')
        if m.get('data') is not None:
            temp_model = CorpTokenResponseBodyData()
            self.data = temp_model.from_map(m['data'])
        if m.get('message') is not None:
            self.message = m.get('message')
        if m.get('module') is not None:
            temp_model = CorpTokenResponseBodyModule()
            self.module = temp_model.from_map(m['module'])
        if m.get('requestId') is not None:
            self.request_id = m.get('requestId')
        if m.get('success') is not None:
            self.success = m.get('success')
        if m.get('traceId') is not None:
            self.trace_id = m.get('traceId')
        return self


class CorpTokenResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: CorpTokenResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = CorpTokenResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CostCenterDeleteHeaders(TeaModel):
    def __init__(
        self,
        common_headers: Dict[str, str] = None,
        x_acs_btrip_so_corp_token: str = None,
    ):
        self.common_headers = common_headers
        self.x_acs_btrip_so_corp_token = x_acs_btrip_so_corp_token

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.common_headers is not None:
            result['commonHeaders'] = self.common_headers
        if self.x_acs_btrip_so_corp_token is not None:
            result['x-acs-btrip-so-corp-token'] = self.x_acs_btrip_so_corp_token
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('commonHeaders') is not None:
            self.common_headers = m.get('commonHeaders')
        if m.get('x-acs-btrip-so-corp-token') is not None:
            self.x_acs_btrip_so_corp_token = m.get('x-acs-btrip-so-corp-token')
        return self


class CostCenterDeleteRequest(TeaModel):
    def __init__(
        self,
        thirdpart_id: str = None,
    ):
        # This parameter is required.
        self.thirdpart_id = thirdpart_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.thirdpart_id is not None:
            result['thirdpart_id'] = self.thirdpart_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('thirdpart_id') is not None:
            self.thirdpart_id = m.get('thirdpart_id')
        return self


class CostCenterDeleteResponseBody(TeaModel):
    def __init__(
        self,
        code: str = None,
        message: str = None,
        request_id: str = None,
        success: bool = None,
        trace_id: str = None,
    ):
        self.code = code
        self.message = message
        self.request_id = request_id
        self.success = success
        # traceId
        self.trace_id = trace_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['code'] = self.code
        if self.message is not None:
            result['message'] = self.message
        if self.request_id is not None:
            result['requestId'] = self.request_id
        if self.success is not None:
            result['success'] = self.success
        if self.trace_id is not None:
            result['traceId'] = self.trace_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('code') is not None:
            self.code = m.get('code')
        if m.get('message') is not None:
            self.message = m.get('message')
        if m.get('requestId') is not None:
            self.request_id = m.get('requestId')
        if m.get('success') is not None:
            self.success = m.get('success')
        if m.get('traceId') is not None:
            self.trace_id = m.get('traceId')
        return self


class CostCenterDeleteResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: CostCenterDeleteResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = CostCenterDeleteResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CostCenterModifyHeaders(TeaModel):
    def __init__(
        self,
        common_headers: Dict[str, str] = None,
        x_acs_btrip_so_corp_token: str = None,
    ):
        self.common_headers = common_headers
        self.x_acs_btrip_so_corp_token = x_acs_btrip_so_corp_token

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.common_headers is not None:
            result['commonHeaders'] = self.common_headers
        if self.x_acs_btrip_so_corp_token is not None:
            result['x-acs-btrip-so-corp-token'] = self.x_acs_btrip_so_corp_token
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('commonHeaders') is not None:
            self.common_headers = m.get('commonHeaders')
        if m.get('x-acs-btrip-so-corp-token') is not None:
            self.x_acs_btrip_so_corp_token = m.get('x-acs-btrip-so-corp-token')
        return self


class CostCenterModifyRequest(TeaModel):
    def __init__(
        self,
        alipay_no: str = None,
        disable: int = None,
        number: str = None,
        scope: int = None,
        thirdpart_id: str = None,
        title: str = None,
    ):
        self.alipay_no = alipay_no
        self.disable = disable
        self.number = number
        # This parameter is required.
        self.scope = scope
        # This parameter is required.
        self.thirdpart_id = thirdpart_id
        # This parameter is required.
        self.title = title

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.alipay_no is not None:
            result['alipay_no'] = self.alipay_no
        if self.disable is not None:
            result['disable'] = self.disable
        if self.number is not None:
            result['number'] = self.number
        if self.scope is not None:
            result['scope'] = self.scope
        if self.thirdpart_id is not None:
            result['thirdpart_id'] = self.thirdpart_id
        if self.title is not None:
            result['title'] = self.title
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('alipay_no') is not None:
            self.alipay_no = m.get('alipay_no')
        if m.get('disable') is not None:
            self.disable = m.get('disable')
        if m.get('number') is not None:
            self.number = m.get('number')
        if m.get('scope') is not None:
            self.scope = m.get('scope')
        if m.get('thirdpart_id') is not None:
            self.thirdpart_id = m.get('thirdpart_id')
        if m.get('title') is not None:
            self.title = m.get('title')
        return self


class CostCenterModifyResponseBody(TeaModel):
    def __init__(
        self,
        code: str = None,
        message: str = None,
        request_id: str = None,
        success: bool = None,
        trace_id: str = None,
    ):
        self.code = code
        self.message = message
        self.request_id = request_id
        self.success = success
        self.trace_id = trace_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['code'] = self.code
        if self.message is not None:
            result['message'] = self.message
        if self.request_id is not None:
            result['requestId'] = self.request_id
        if self.success is not None:
            result['success'] = self.success
        if self.trace_id is not None:
            result['traceId'] = self.trace_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('code') is not None:
            self.code = m.get('code')
        if m.get('message') is not None:
            self.message = m.get('message')
        if m.get('requestId') is not None:
            self.request_id = m.get('requestId')
        if m.get('success') is not None:
            self.success = m.get('success')
        if m.get('traceId') is not None:
            self.trace_id = m.get('traceId')
        return self


class CostCenterModifyResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: CostCenterModifyResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = CostCenterModifyResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CostCenterQueryHeaders(TeaModel):
    def __init__(
        self,
        common_headers: Dict[str, str] = None,
        x_acs_btrip_so_corp_token: str = None,
    ):
        self.common_headers = common_headers
        self.x_acs_btrip_so_corp_token = x_acs_btrip_so_corp_token

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.common_headers is not None:
            result['commonHeaders'] = self.common_headers
        if self.x_acs_btrip_so_corp_token is not None:
            result['x-acs-btrip-so-corp-token'] = self.x_acs_btrip_so_corp_token
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('commonHeaders') is not None:
            self.common_headers = m.get('commonHeaders')
        if m.get('x-acs-btrip-so-corp-token') is not None:
            self.x_acs_btrip_so_corp_token = m.get('x-acs-btrip-so-corp-token')
        return self


class CostCenterQueryRequest(TeaModel):
    def __init__(
        self,
        disable: int = None,
        need_org_entity: bool = None,
        thirdpart_id: str = None,
        title: str = None,
        user_id: str = None,
    ):
        self.disable = disable
        self.need_org_entity = need_org_entity
        self.thirdpart_id = thirdpart_id
        self.title = title
        self.user_id = user_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.disable is not None:
            result['disable'] = self.disable
        if self.need_org_entity is not None:
            result['need_org_entity'] = self.need_org_entity
        if self.thirdpart_id is not None:
            result['thirdpart_id'] = self.thirdpart_id
        if self.title is not None:
            result['title'] = self.title
        if self.user_id is not None:
            result['user_id'] = self.user_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('disable') is not None:
            self.disable = m.get('disable')
        if m.get('need_org_entity') is not None:
            self.need_org_entity = m.get('need_org_entity')
        if m.get('thirdpart_id') is not None:
            self.thirdpart_id = m.get('thirdpart_id')
        if m.get('title') is not None:
            self.title = m.get('title')
        if m.get('user_id') is not None:
            self.user_id = m.get('user_id')
        return self


class CostCenterQueryResponseBodyModuleEntityDOS(TeaModel):
    def __init__(
        self,
        corp_id: str = None,
        entity_id: str = None,
        entity_type: str = None,
        name: str = None,
        user_num: int = None,
    ):
        self.corp_id = corp_id
        self.entity_id = entity_id
        self.entity_type = entity_type
        self.name = name
        self.user_num = user_num

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.corp_id is not None:
            result['corp_id'] = self.corp_id
        if self.entity_id is not None:
            result['entity_id'] = self.entity_id
        if self.entity_type is not None:
            result['entity_type'] = self.entity_type
        if self.name is not None:
            result['name'] = self.name
        if self.user_num is not None:
            result['user_num'] = self.user_num
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('corp_id') is not None:
            self.corp_id = m.get('corp_id')
        if m.get('entity_id') is not None:
            self.entity_id = m.get('entity_id')
        if m.get('entity_type') is not None:
            self.entity_type = m.get('entity_type')
        if m.get('name') is not None:
            self.name = m.get('name')
        if m.get('user_num') is not None:
            self.user_num = m.get('user_num')
        return self


class CostCenterQueryResponseBodyModule(TeaModel):
    def __init__(
        self,
        alipay_no: str = None,
        corp_id: str = None,
        disable: int = None,
        entity_dos: List[CostCenterQueryResponseBodyModuleEntityDOS] = None,
        id: int = None,
        number: str = None,
        rule_code: int = None,
        scope: int = None,
        thirdpart_id: str = None,
        title: str = None,
    ):
        self.alipay_no = alipay_no
        self.corp_id = corp_id
        self.disable = disable
        self.entity_dos = entity_dos
        self.id = id
        self.number = number
        # rule code
        self.rule_code = rule_code
        self.scope = scope
        self.thirdpart_id = thirdpart_id
        self.title = title

    def validate(self):
        if self.entity_dos:
            for k in self.entity_dos:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.alipay_no is not None:
            result['alipay_no'] = self.alipay_no
        if self.corp_id is not None:
            result['corp_id'] = self.corp_id
        if self.disable is not None:
            result['disable'] = self.disable
        result['entity_d_o_s'] = []
        if self.entity_dos is not None:
            for k in self.entity_dos:
                result['entity_d_o_s'].append(k.to_map() if k else None)
        if self.id is not None:
            result['id'] = self.id
        if self.number is not None:
            result['number'] = self.number
        if self.rule_code is not None:
            result['rule_code'] = self.rule_code
        if self.scope is not None:
            result['scope'] = self.scope
        if self.thirdpart_id is not None:
            result['thirdpart_id'] = self.thirdpart_id
        if self.title is not None:
            result['title'] = self.title
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('alipay_no') is not None:
            self.alipay_no = m.get('alipay_no')
        if m.get('corp_id') is not None:
            self.corp_id = m.get('corp_id')
        if m.get('disable') is not None:
            self.disable = m.get('disable')
        self.entity_dos = []
        if m.get('entity_d_o_s') is not None:
            for k in m.get('entity_d_o_s'):
                temp_model = CostCenterQueryResponseBodyModuleEntityDOS()
                self.entity_dos.append(temp_model.from_map(k))
        if m.get('id') is not None:
            self.id = m.get('id')
        if m.get('number') is not None:
            self.number = m.get('number')
        if m.get('rule_code') is not None:
            self.rule_code = m.get('rule_code')
        if m.get('scope') is not None:
            self.scope = m.get('scope')
        if m.get('thirdpart_id') is not None:
            self.thirdpart_id = m.get('thirdpart_id')
        if m.get('title') is not None:
            self.title = m.get('title')
        return self


class CostCenterQueryResponseBody(TeaModel):
    def __init__(
        self,
        code: str = None,
        message: str = None,
        module: List[CostCenterQueryResponseBodyModule] = None,
        more_page: bool = None,
        request_id: str = None,
        success: bool = None,
        trace_id: str = None,
    ):
        self.code = code
        self.message = message
        self.module = module
        self.more_page = more_page
        self.request_id = request_id
        self.success = success
        # traceId
        self.trace_id = trace_id

    def validate(self):
        if self.module:
            for k in self.module:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['code'] = self.code
        if self.message is not None:
            result['message'] = self.message
        result['module'] = []
        if self.module is not None:
            for k in self.module:
                result['module'].append(k.to_map() if k else None)
        if self.more_page is not None:
            result['more_page'] = self.more_page
        if self.request_id is not None:
            result['requestId'] = self.request_id
        if self.success is not None:
            result['success'] = self.success
        if self.trace_id is not None:
            result['traceId'] = self.trace_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('code') is not None:
            self.code = m.get('code')
        if m.get('message') is not None:
            self.message = m.get('message')
        self.module = []
        if m.get('module') is not None:
            for k in m.get('module'):
                temp_model = CostCenterQueryResponseBodyModule()
                self.module.append(temp_model.from_map(k))
        if m.get('more_page') is not None:
            self.more_page = m.get('more_page')
        if m.get('requestId') is not None:
            self.request_id = m.get('requestId')
        if m.get('success') is not None:
            self.success = m.get('success')
        if m.get('traceId') is not None:
            self.trace_id = m.get('traceId')
        return self


class CostCenterQueryResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: CostCenterQueryResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = CostCenterQueryResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CostCenterSaveHeaders(TeaModel):
    def __init__(
        self,
        common_headers: Dict[str, str] = None,
        x_acs_btrip_so_corp_token: str = None,
    ):
        self.common_headers = common_headers
        self.x_acs_btrip_so_corp_token = x_acs_btrip_so_corp_token

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.common_headers is not None:
            result['commonHeaders'] = self.common_headers
        if self.x_acs_btrip_so_corp_token is not None:
            result['x-acs-btrip-so-corp-token'] = self.x_acs_btrip_so_corp_token
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('commonHeaders') is not None:
            self.common_headers = m.get('commonHeaders')
        if m.get('x-acs-btrip-so-corp-token') is not None:
            self.x_acs_btrip_so_corp_token = m.get('x-acs-btrip-so-corp-token')
        return self


class CostCenterSaveRequest(TeaModel):
    def __init__(
        self,
        alipay_no: str = None,
        disable: int = None,
        number: str = None,
        scope: int = None,
        thirdpart_id: str = None,
        title: str = None,
    ):
        self.alipay_no = alipay_no
        self.disable = disable
        self.number = number
        # This parameter is required.
        self.scope = scope
        # This parameter is required.
        self.thirdpart_id = thirdpart_id
        # This parameter is required.
        self.title = title

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.alipay_no is not None:
            result['alipay_no'] = self.alipay_no
        if self.disable is not None:
            result['disable'] = self.disable
        if self.number is not None:
            result['number'] = self.number
        if self.scope is not None:
            result['scope'] = self.scope
        if self.thirdpart_id is not None:
            result['thirdpart_id'] = self.thirdpart_id
        if self.title is not None:
            result['title'] = self.title
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('alipay_no') is not None:
            self.alipay_no = m.get('alipay_no')
        if m.get('disable') is not None:
            self.disable = m.get('disable')
        if m.get('number') is not None:
            self.number = m.get('number')
        if m.get('scope') is not None:
            self.scope = m.get('scope')
        if m.get('thirdpart_id') is not None:
            self.thirdpart_id = m.get('thirdpart_id')
        if m.get('title') is not None:
            self.title = m.get('title')
        return self


class CostCenterSaveResponseBodyModule(TeaModel):
    def __init__(
        self,
        id: int = None,
    ):
        self.id = id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.id is not None:
            result['id'] = self.id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('id') is not None:
            self.id = m.get('id')
        return self


class CostCenterSaveResponseBody(TeaModel):
    def __init__(
        self,
        code: str = None,
        message: str = None,
        module: CostCenterSaveResponseBodyModule = None,
        request_id: str = None,
        success: bool = None,
        trace_id: str = None,
    ):
        self.code = code
        self.message = message
        self.module = module
        self.request_id = request_id
        self.success = success
        # traceId
        self.trace_id = trace_id

    def validate(self):
        if self.module:
            self.module.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['code'] = self.code
        if self.message is not None:
            result['message'] = self.message
        if self.module is not None:
            result['module'] = self.module.to_map()
        if self.request_id is not None:
            result['requestId'] = self.request_id
        if self.success is not None:
            result['success'] = self.success
        if self.trace_id is not None:
            result['traceId'] = self.trace_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('code') is not None:
            self.code = m.get('code')
        if m.get('message') is not None:
            self.message = m.get('message')
        if m.get('module') is not None:
            temp_model = CostCenterSaveResponseBodyModule()
            self.module = temp_model.from_map(m['module'])
        if m.get('requestId') is not None:
            self.request_id = m.get('requestId')
        if m.get('success') is not None:
            self.success = m.get('success')
        if m.get('traceId') is not None:
            self.trace_id = m.get('traceId')
        return self


class CostCenterSaveResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: CostCenterSaveResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = CostCenterSaveResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateCustomRoleHeaders(TeaModel):
    def __init__(
        self,
        common_headers: Dict[str, str] = None,
        x_acs_btrip_corp_token: str = None,
    ):
        self.common_headers = common_headers
        self.x_acs_btrip_corp_token = x_acs_btrip_corp_token

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.common_headers is not None:
            result['commonHeaders'] = self.common_headers
        if self.x_acs_btrip_corp_token is not None:
            result['x-acs-btrip-corp-token'] = self.x_acs_btrip_corp_token
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('commonHeaders') is not None:
            self.common_headers = m.get('commonHeaders')
        if m.get('x-acs-btrip-corp-token') is not None:
            self.x_acs_btrip_corp_token = m.get('x-acs-btrip-corp-token')
        return self


class CreateCustomRoleRequest(TeaModel):
    def __init__(
        self,
        role_id: str = None,
        role_name: str = None,
    ):
        # This parameter is required.
        self.role_id = role_id
        # This parameter is required.
        self.role_name = role_name

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.role_id is not None:
            result['role_id'] = self.role_id
        if self.role_name is not None:
            result['role_name'] = self.role_name
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('role_id') is not None:
            self.role_id = m.get('role_id')
        if m.get('role_name') is not None:
            self.role_name = m.get('role_name')
        return self


class CreateCustomRoleResponseBody(TeaModel):
    def __init__(
        self,
        code: str = None,
        http_status_code: int = None,
        message: str = None,
        request_id: str = None,
        success: bool = None,
        trace_id: str = None,
    ):
        self.code = code
        self.http_status_code = http_status_code
        self.message = message
        self.request_id = request_id
        self.success = success
        # traceId
        self.trace_id = trace_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['code'] = self.code
        if self.http_status_code is not None:
            result['httpStatusCode'] = self.http_status_code
        if self.message is not None:
            result['message'] = self.message
        if self.request_id is not None:
            result['requestId'] = self.request_id
        if self.success is not None:
            result['success'] = self.success
        if self.trace_id is not None:
            result['traceId'] = self.trace_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('code') is not None:
            self.code = m.get('code')
        if m.get('httpStatusCode') is not None:
            self.http_status_code = m.get('httpStatusCode')
        if m.get('message') is not None:
            self.message = m.get('message')
        if m.get('requestId') is not None:
            self.request_id = m.get('requestId')
        if m.get('success') is not None:
            self.success = m.get('success')
        if m.get('traceId') is not None:
            self.trace_id = m.get('traceId')
        return self


class CreateCustomRoleResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: CreateCustomRoleResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = CreateCustomRoleResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateSubCorpHeaders(TeaModel):
    def __init__(
        self,
        common_headers: Dict[str, str] = None,
        x_acs_btrip_corp_token: str = None,
    ):
        self.common_headers = common_headers
        self.x_acs_btrip_corp_token = x_acs_btrip_corp_token

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.common_headers is not None:
            result['commonHeaders'] = self.common_headers
        if self.x_acs_btrip_corp_token is not None:
            result['x-acs-btrip-corp-token'] = self.x_acs_btrip_corp_token
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('commonHeaders') is not None:
            self.common_headers = m.get('commonHeaders')
        if m.get('x-acs-btrip-corp-token') is not None:
            self.x_acs_btrip_corp_token = m.get('x-acs-btrip-corp-token')
        return self


class CreateSubCorpRequest(TeaModel):
    def __init__(
        self,
        outer_corp_id: str = None,
        outer_corp_name: str = None,
        user_id: str = None,
    ):
        # This parameter is required.
        self.outer_corp_id = outer_corp_id
        # This parameter is required.
        self.outer_corp_name = outer_corp_name
        # This parameter is required.
        self.user_id = user_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.outer_corp_id is not None:
            result['outer_corp_id'] = self.outer_corp_id
        if self.outer_corp_name is not None:
            result['outer_corp_name'] = self.outer_corp_name
        if self.user_id is not None:
            result['user_id'] = self.user_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('outer_corp_id') is not None:
            self.outer_corp_id = m.get('outer_corp_id')
        if m.get('outer_corp_name') is not None:
            self.outer_corp_name = m.get('outer_corp_name')
        if m.get('user_id') is not None:
            self.user_id = m.get('user_id')
        return self


class CreateSubCorpResponseBodyModule(TeaModel):
    def __init__(
        self,
        sub_corp_id: str = None,
    ):
        self.sub_corp_id = sub_corp_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.sub_corp_id is not None:
            result['sub_corp_id'] = self.sub_corp_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('sub_corp_id') is not None:
            self.sub_corp_id = m.get('sub_corp_id')
        return self


class CreateSubCorpResponseBody(TeaModel):
    def __init__(
        self,
        code: str = None,
        message: str = None,
        module: CreateSubCorpResponseBodyModule = None,
        request_id: str = None,
        success: bool = None,
        trace_id: str = None,
    ):
        self.code = code
        self.message = message
        self.module = module
        self.request_id = request_id
        self.success = success
        self.trace_id = trace_id

    def validate(self):
        if self.module:
            self.module.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['code'] = self.code
        if self.message is not None:
            result['message'] = self.message
        if self.module is not None:
            result['module'] = self.module.to_map()
        if self.request_id is not None:
            result['requestId'] = self.request_id
        if self.success is not None:
            result['success'] = self.success
        if self.trace_id is not None:
            result['traceId'] = self.trace_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('code') is not None:
            self.code = m.get('code')
        if m.get('message') is not None:
            self.message = m.get('message')
        if m.get('module') is not None:
            temp_model = CreateSubCorpResponseBodyModule()
            self.module = temp_model.from_map(m['module'])
        if m.get('requestId') is not None:
            self.request_id = m.get('requestId')
        if m.get('success') is not None:
            self.success = m.get('success')
        if m.get('traceId') is not None:
            self.trace_id = m.get('traceId')
        return self


class CreateSubCorpResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: CreateSubCorpResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = CreateSubCorpResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteCustomRoleHeaders(TeaModel):
    def __init__(
        self,
        common_headers: Dict[str, str] = None,
        x_acs_btrip_corp_token: str = None,
    ):
        self.common_headers = common_headers
        self.x_acs_btrip_corp_token = x_acs_btrip_corp_token

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.common_headers is not None:
            result['commonHeaders'] = self.common_headers
        if self.x_acs_btrip_corp_token is not None:
            result['x-acs-btrip-corp-token'] = self.x_acs_btrip_corp_token
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('commonHeaders') is not None:
            self.common_headers = m.get('commonHeaders')
        if m.get('x-acs-btrip-corp-token') is not None:
            self.x_acs_btrip_corp_token = m.get('x-acs-btrip-corp-token')
        return self


class DeleteCustomRoleRequest(TeaModel):
    def __init__(
        self,
        role_id: str = None,
    ):
        # This parameter is required.
        self.role_id = role_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.role_id is not None:
            result['role_id'] = self.role_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('role_id') is not None:
            self.role_id = m.get('role_id')
        return self


class DeleteCustomRoleResponseBody(TeaModel):
    def __init__(
        self,
        code: str = None,
        http_status_code: int = None,
        message: str = None,
        request_id: str = None,
        success: bool = None,
        trace_id: str = None,
    ):
        self.code = code
        self.http_status_code = http_status_code
        self.message = message
        self.request_id = request_id
        self.success = success
        # traceId
        self.trace_id = trace_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['code'] = self.code
        if self.http_status_code is not None:
            result['httpStatusCode'] = self.http_status_code
        if self.message is not None:
            result['message'] = self.message
        if self.request_id is not None:
            result['requestId'] = self.request_id
        if self.success is not None:
            result['success'] = self.success
        if self.trace_id is not None:
            result['traceId'] = self.trace_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('code') is not None:
            self.code = m.get('code')
        if m.get('httpStatusCode') is not None:
            self.http_status_code = m.get('httpStatusCode')
        if m.get('message') is not None:
            self.message = m.get('message')
        if m.get('requestId') is not None:
            self.request_id = m.get('requestId')
        if m.get('success') is not None:
            self.success = m.get('success')
        if m.get('traceId') is not None:
            self.trace_id = m.get('traceId')
        return self


class DeleteCustomRoleResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DeleteCustomRoleResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DeleteCustomRoleResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteDepartmentHeaders(TeaModel):
    def __init__(
        self,
        common_headers: Dict[str, str] = None,
        x_acs_btrip_corp_token: str = None,
    ):
        self.common_headers = common_headers
        self.x_acs_btrip_corp_token = x_acs_btrip_corp_token

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.common_headers is not None:
            result['commonHeaders'] = self.common_headers
        if self.x_acs_btrip_corp_token is not None:
            result['x-acs-btrip-corp-token'] = self.x_acs_btrip_corp_token
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('commonHeaders') is not None:
            self.common_headers = m.get('commonHeaders')
        if m.get('x-acs-btrip-corp-token') is not None:
            self.x_acs_btrip_corp_token = m.get('x-acs-btrip-corp-token')
        return self


class DeleteDepartmentRequest(TeaModel):
    def __init__(
        self,
        out_dept_id: str = None,
    ):
        # This parameter is required.
        self.out_dept_id = out_dept_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.out_dept_id is not None:
            result['out_dept_id'] = self.out_dept_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('out_dept_id') is not None:
            self.out_dept_id = m.get('out_dept_id')
        return self


class DeleteDepartmentResponseBody(TeaModel):
    def __init__(
        self,
        code: str = None,
        message: str = None,
        request_id: str = None,
        success: bool = None,
        trace_id: str = None,
    ):
        self.code = code
        self.message = message
        self.request_id = request_id
        self.success = success
        # traceId
        self.trace_id = trace_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['code'] = self.code
        if self.message is not None:
            result['message'] = self.message
        if self.request_id is not None:
            result['requestId'] = self.request_id
        if self.success is not None:
            result['success'] = self.success
        if self.trace_id is not None:
            result['traceId'] = self.trace_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('code') is not None:
            self.code = m.get('code')
        if m.get('message') is not None:
            self.message = m.get('message')
        if m.get('requestId') is not None:
            self.request_id = m.get('requestId')
        if m.get('success') is not None:
            self.success = m.get('success')
        if m.get('traceId') is not None:
            self.trace_id = m.get('traceId')
        return self


class DeleteDepartmentResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DeleteDepartmentResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DeleteDepartmentResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteEmployeesFromCustomRoleHeaders(TeaModel):
    def __init__(
        self,
        common_headers: Dict[str, str] = None,
        x_acs_btrip_corp_token: str = None,
    ):
        self.common_headers = common_headers
        self.x_acs_btrip_corp_token = x_acs_btrip_corp_token

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.common_headers is not None:
            result['commonHeaders'] = self.common_headers
        if self.x_acs_btrip_corp_token is not None:
            result['x-acs-btrip-corp-token'] = self.x_acs_btrip_corp_token
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('commonHeaders') is not None:
            self.common_headers = m.get('commonHeaders')
        if m.get('x-acs-btrip-corp-token') is not None:
            self.x_acs_btrip_corp_token = m.get('x-acs-btrip-corp-token')
        return self


class DeleteEmployeesFromCustomRoleRequest(TeaModel):
    def __init__(
        self,
        role_id: str = None,
        user_id_list: List[str] = None,
    ):
        # This parameter is required.
        self.role_id = role_id
        # This parameter is required.
        self.user_id_list = user_id_list

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.role_id is not None:
            result['role_id'] = self.role_id
        if self.user_id_list is not None:
            result['user_id_list'] = self.user_id_list
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('role_id') is not None:
            self.role_id = m.get('role_id')
        if m.get('user_id_list') is not None:
            self.user_id_list = m.get('user_id_list')
        return self


class DeleteEmployeesFromCustomRoleShrinkRequest(TeaModel):
    def __init__(
        self,
        role_id: str = None,
        user_id_list_shrink: str = None,
    ):
        # This parameter is required.
        self.role_id = role_id
        # This parameter is required.
        self.user_id_list_shrink = user_id_list_shrink

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.role_id is not None:
            result['role_id'] = self.role_id
        if self.user_id_list_shrink is not None:
            result['user_id_list'] = self.user_id_list_shrink
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('role_id') is not None:
            self.role_id = m.get('role_id')
        if m.get('user_id_list') is not None:
            self.user_id_list_shrink = m.get('user_id_list')
        return self


class DeleteEmployeesFromCustomRoleResponseBody(TeaModel):
    def __init__(
        self,
        code: str = None,
        http_status_code: int = None,
        message: str = None,
        request_id: str = None,
        success: bool = None,
        trace_id: str = None,
    ):
        self.code = code
        self.http_status_code = http_status_code
        self.message = message
        self.request_id = request_id
        self.success = success
        # traceId
        self.trace_id = trace_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['code'] = self.code
        if self.http_status_code is not None:
            result['httpStatusCode'] = self.http_status_code
        if self.message is not None:
            result['message'] = self.message
        if self.request_id is not None:
            result['requestId'] = self.request_id
        if self.success is not None:
            result['success'] = self.success
        if self.trace_id is not None:
            result['traceId'] = self.trace_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('code') is not None:
            self.code = m.get('code')
        if m.get('httpStatusCode') is not None:
            self.http_status_code = m.get('httpStatusCode')
        if m.get('message') is not None:
            self.message = m.get('message')
        if m.get('requestId') is not None:
            self.request_id = m.get('requestId')
        if m.get('success') is not None:
            self.success = m.get('success')
        if m.get('traceId') is not None:
            self.trace_id = m.get('traceId')
        return self


class DeleteEmployeesFromCustomRoleResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DeleteEmployeesFromCustomRoleResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DeleteEmployeesFromCustomRoleResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteInvoiceEntityHeaders(TeaModel):
    def __init__(
        self,
        common_headers: Dict[str, str] = None,
        x_acs_btrip_corp_token: str = None,
    ):
        self.common_headers = common_headers
        self.x_acs_btrip_corp_token = x_acs_btrip_corp_token

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.common_headers is not None:
            result['commonHeaders'] = self.common_headers
        if self.x_acs_btrip_corp_token is not None:
            result['x-acs-btrip-corp-token'] = self.x_acs_btrip_corp_token
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('commonHeaders') is not None:
            self.common_headers = m.get('commonHeaders')
        if m.get('x-acs-btrip-corp-token') is not None:
            self.x_acs_btrip_corp_token = m.get('x-acs-btrip-corp-token')
        return self


class DeleteInvoiceEntityRequestEntities(TeaModel):
    def __init__(
        self,
        entity_id: str = None,
        entity_type: str = None,
    ):
        self.entity_id = entity_id
        self.entity_type = entity_type

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.entity_id is not None:
            result['entity_id'] = self.entity_id
        if self.entity_type is not None:
            result['entity_type'] = self.entity_type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('entity_id') is not None:
            self.entity_id = m.get('entity_id')
        if m.get('entity_type') is not None:
            self.entity_type = m.get('entity_type')
        return self


class DeleteInvoiceEntityRequest(TeaModel):
    def __init__(
        self,
        del_all: bool = None,
        entities: List[DeleteInvoiceEntityRequestEntities] = None,
        third_part_id: str = None,
    ):
        self.del_all = del_all
        self.entities = entities
        # This parameter is required.
        self.third_part_id = third_part_id

    def validate(self):
        if self.entities:
            for k in self.entities:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.del_all is not None:
            result['del_all'] = self.del_all
        result['entities'] = []
        if self.entities is not None:
            for k in self.entities:
                result['entities'].append(k.to_map() if k else None)
        if self.third_part_id is not None:
            result['third_part_id'] = self.third_part_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('del_all') is not None:
            self.del_all = m.get('del_all')
        self.entities = []
        if m.get('entities') is not None:
            for k in m.get('entities'):
                temp_model = DeleteInvoiceEntityRequestEntities()
                self.entities.append(temp_model.from_map(k))
        if m.get('third_part_id') is not None:
            self.third_part_id = m.get('third_part_id')
        return self


class DeleteInvoiceEntityShrinkRequest(TeaModel):
    def __init__(
        self,
        del_all: bool = None,
        entities_shrink: str = None,
        third_part_id: str = None,
    ):
        self.del_all = del_all
        self.entities_shrink = entities_shrink
        # This parameter is required.
        self.third_part_id = third_part_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.del_all is not None:
            result['del_all'] = self.del_all
        if self.entities_shrink is not None:
            result['entities'] = self.entities_shrink
        if self.third_part_id is not None:
            result['third_part_id'] = self.third_part_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('del_all') is not None:
            self.del_all = m.get('del_all')
        if m.get('entities') is not None:
            self.entities_shrink = m.get('entities')
        if m.get('third_part_id') is not None:
            self.third_part_id = m.get('third_part_id')
        return self


class DeleteInvoiceEntityResponseBodyModule(TeaModel):
    def __init__(
        self,
        remove_num: int = None,
        selected_user_num: int = None,
    ):
        self.remove_num = remove_num
        self.selected_user_num = selected_user_num

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.remove_num is not None:
            result['remove_num'] = self.remove_num
        if self.selected_user_num is not None:
            result['selected_user_num'] = self.selected_user_num
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('remove_num') is not None:
            self.remove_num = m.get('remove_num')
        if m.get('selected_user_num') is not None:
            self.selected_user_num = m.get('selected_user_num')
        return self


class DeleteInvoiceEntityResponseBody(TeaModel):
    def __init__(
        self,
        code: str = None,
        message: str = None,
        module: DeleteInvoiceEntityResponseBodyModule = None,
        request_id: str = None,
        success: bool = None,
        trace_id: str = None,
    ):
        self.code = code
        self.message = message
        self.module = module
        self.request_id = request_id
        self.success = success
        # traceId
        self.trace_id = trace_id

    def validate(self):
        if self.module:
            self.module.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['code'] = self.code
        if self.message is not None:
            result['message'] = self.message
        if self.module is not None:
            result['module'] = self.module.to_map()
        if self.request_id is not None:
            result['requestId'] = self.request_id
        if self.success is not None:
            result['success'] = self.success
        if self.trace_id is not None:
            result['traceId'] = self.trace_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('code') is not None:
            self.code = m.get('code')
        if m.get('message') is not None:
            self.message = m.get('message')
        if m.get('module') is not None:
            temp_model = DeleteInvoiceEntityResponseBodyModule()
            self.module = temp_model.from_map(m['module'])
        if m.get('requestId') is not None:
            self.request_id = m.get('requestId')
        if m.get('success') is not None:
            self.success = m.get('success')
        if m.get('traceId') is not None:
            self.trace_id = m.get('traceId')
        return self


class DeleteInvoiceEntityResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DeleteInvoiceEntityResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DeleteInvoiceEntityResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DepartmentSaveHeaders(TeaModel):
    def __init__(
        self,
        common_headers: Dict[str, str] = None,
        x_acs_btrip_so_corp_token: str = None,
    ):
        self.common_headers = common_headers
        self.x_acs_btrip_so_corp_token = x_acs_btrip_so_corp_token

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.common_headers is not None:
            result['commonHeaders'] = self.common_headers
        if self.x_acs_btrip_so_corp_token is not None:
            result['x-acs-btrip-so-corp-token'] = self.x_acs_btrip_so_corp_token
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('commonHeaders') is not None:
            self.common_headers = m.get('commonHeaders')
        if m.get('x-acs-btrip-so-corp-token') is not None:
            self.x_acs_btrip_so_corp_token = m.get('x-acs-btrip-so-corp-token')
        return self


class DepartmentSaveRequestDepartList(TeaModel):
    def __init__(
        self,
        depart_id: int = None,
        depart_name: str = None,
        depart_pid: int = None,
        manager_ids: str = None,
        status: int = None,
        third_depart_id: str = None,
        third_depart_pid: str = None,
    ):
        self.depart_id = depart_id
        # This parameter is required.
        self.depart_name = depart_name
        self.depart_pid = depart_pid
        self.manager_ids = manager_ids
        self.status = status
        self.third_depart_id = third_depart_id
        self.third_depart_pid = third_depart_pid

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.depart_id is not None:
            result['depart_id'] = self.depart_id
        if self.depart_name is not None:
            result['depart_name'] = self.depart_name
        if self.depart_pid is not None:
            result['depart_pid'] = self.depart_pid
        if self.manager_ids is not None:
            result['manager_ids'] = self.manager_ids
        if self.status is not None:
            result['status'] = self.status
        if self.third_depart_id is not None:
            result['third_depart_id'] = self.third_depart_id
        if self.third_depart_pid is not None:
            result['third_depart_pid'] = self.third_depart_pid
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('depart_id') is not None:
            self.depart_id = m.get('depart_id')
        if m.get('depart_name') is not None:
            self.depart_name = m.get('depart_name')
        if m.get('depart_pid') is not None:
            self.depart_pid = m.get('depart_pid')
        if m.get('manager_ids') is not None:
            self.manager_ids = m.get('manager_ids')
        if m.get('status') is not None:
            self.status = m.get('status')
        if m.get('third_depart_id') is not None:
            self.third_depart_id = m.get('third_depart_id')
        if m.get('third_depart_pid') is not None:
            self.third_depart_pid = m.get('third_depart_pid')
        return self


class DepartmentSaveRequest(TeaModel):
    def __init__(
        self,
        depart_list: List[DepartmentSaveRequestDepartList] = None,
    ):
        self.depart_list = depart_list

    def validate(self):
        if self.depart_list:
            for k in self.depart_list:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['depart_list'] = []
        if self.depart_list is not None:
            for k in self.depart_list:
                result['depart_list'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.depart_list = []
        if m.get('depart_list') is not None:
            for k in m.get('depart_list'):
                temp_model = DepartmentSaveRequestDepartList()
                self.depart_list.append(temp_model.from_map(k))
        return self


class DepartmentSaveShrinkRequest(TeaModel):
    def __init__(
        self,
        depart_list_shrink: str = None,
    ):
        self.depart_list_shrink = depart_list_shrink

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.depart_list_shrink is not None:
            result['depart_list'] = self.depart_list_shrink
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('depart_list') is not None:
            self.depart_list_shrink = m.get('depart_list')
        return self


class DepartmentSaveResponseBody(TeaModel):
    def __init__(
        self,
        code: str = None,
        message: str = None,
        module: str = None,
        request_id: str = None,
        success: bool = None,
        trace_id: str = None,
    ):
        self.code = code
        self.message = message
        self.module = module
        self.request_id = request_id
        self.success = success
        # traceId
        self.trace_id = trace_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['code'] = self.code
        if self.message is not None:
            result['message'] = self.message
        if self.module is not None:
            result['module'] = self.module
        if self.request_id is not None:
            result['requestId'] = self.request_id
        if self.success is not None:
            result['success'] = self.success
        if self.trace_id is not None:
            result['traceId'] = self.trace_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('code') is not None:
            self.code = m.get('code')
        if m.get('message') is not None:
            self.message = m.get('message')
        if m.get('module') is not None:
            self.module = m.get('module')
        if m.get('requestId') is not None:
            self.request_id = m.get('requestId')
        if m.get('success') is not None:
            self.success = m.get('success')
        if m.get('traceId') is not None:
            self.trace_id = m.get('traceId')
        return self


class DepartmentSaveResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DepartmentSaveResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DepartmentSaveResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class ElectronicItineraryBatchApplyHeaders(TeaModel):
    def __init__(
        self,
        common_headers: Dict[str, str] = None,
        x_acs_btrip_so_corp_token: str = None,
    ):
        self.common_headers = common_headers
        self.x_acs_btrip_so_corp_token = x_acs_btrip_so_corp_token

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.common_headers is not None:
            result['commonHeaders'] = self.common_headers
        if self.x_acs_btrip_so_corp_token is not None:
            result['x-acs-btrip-so-corp-token'] = self.x_acs_btrip_so_corp_token
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('commonHeaders') is not None:
            self.common_headers = m.get('commonHeaders')
        if m.get('x-acs-btrip-so-corp-token') is not None:
            self.x_acs_btrip_so_corp_token = m.get('x-acs-btrip-so-corp-token')
        return self


class ElectronicItineraryBatchApplyRequestApplyItineraryList(TeaModel):
    def __init__(
        self,
        purchaser_name: str = None,
        purchaser_tax_no: str = None,
        purchaser_type: int = None,
        ticket_no: str = None,
    ):
        self.purchaser_name = purchaser_name
        self.purchaser_tax_no = purchaser_tax_no
        # This parameter is required.
        self.purchaser_type = purchaser_type
        # This parameter is required.
        self.ticket_no = ticket_no

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.purchaser_name is not None:
            result['purchaser_name'] = self.purchaser_name
        if self.purchaser_tax_no is not None:
            result['purchaser_tax_no'] = self.purchaser_tax_no
        if self.purchaser_type is not None:
            result['purchaser_type'] = self.purchaser_type
        if self.ticket_no is not None:
            result['ticket_no'] = self.ticket_no
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('purchaser_name') is not None:
            self.purchaser_name = m.get('purchaser_name')
        if m.get('purchaser_tax_no') is not None:
            self.purchaser_tax_no = m.get('purchaser_tax_no')
        if m.get('purchaser_type') is not None:
            self.purchaser_type = m.get('purchaser_type')
        if m.get('ticket_no') is not None:
            self.ticket_no = m.get('ticket_no')
        return self


class ElectronicItineraryBatchApplyRequest(TeaModel):
    def __init__(
        self,
        apply_itinerary_list: List[ElectronicItineraryBatchApplyRequestApplyItineraryList] = None,
        can_reprint: bool = None,
    ):
        # This parameter is required.
        self.apply_itinerary_list = apply_itinerary_list
        self.can_reprint = can_reprint

    def validate(self):
        if self.apply_itinerary_list:
            for k in self.apply_itinerary_list:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['apply_itinerary_list'] = []
        if self.apply_itinerary_list is not None:
            for k in self.apply_itinerary_list:
                result['apply_itinerary_list'].append(k.to_map() if k else None)
        if self.can_reprint is not None:
            result['can_reprint'] = self.can_reprint
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.apply_itinerary_list = []
        if m.get('apply_itinerary_list') is not None:
            for k in m.get('apply_itinerary_list'):
                temp_model = ElectronicItineraryBatchApplyRequestApplyItineraryList()
                self.apply_itinerary_list.append(temp_model.from_map(k))
        if m.get('can_reprint') is not None:
            self.can_reprint = m.get('can_reprint')
        return self


class ElectronicItineraryBatchApplyShrinkRequest(TeaModel):
    def __init__(
        self,
        apply_itinerary_list_shrink: str = None,
        can_reprint: bool = None,
    ):
        # This parameter is required.
        self.apply_itinerary_list_shrink = apply_itinerary_list_shrink
        self.can_reprint = can_reprint

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.apply_itinerary_list_shrink is not None:
            result['apply_itinerary_list'] = self.apply_itinerary_list_shrink
        if self.can_reprint is not None:
            result['can_reprint'] = self.can_reprint
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('apply_itinerary_list') is not None:
            self.apply_itinerary_list_shrink = m.get('apply_itinerary_list')
        if m.get('can_reprint') is not None:
            self.can_reprint = m.get('can_reprint')
        return self


class ElectronicItineraryBatchApplyResponseBodyModuleApplyFailedTicketList(TeaModel):
    def __init__(
        self,
        failed_code: int = None,
        failed_reason: str = None,
        ticket_no: str = None,
    ):
        self.failed_code = failed_code
        self.failed_reason = failed_reason
        self.ticket_no = ticket_no

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.failed_code is not None:
            result['failed_code'] = self.failed_code
        if self.failed_reason is not None:
            result['failed_reason'] = self.failed_reason
        if self.ticket_no is not None:
            result['ticket_no'] = self.ticket_no
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('failed_code') is not None:
            self.failed_code = m.get('failed_code')
        if m.get('failed_reason') is not None:
            self.failed_reason = m.get('failed_reason')
        if m.get('ticket_no') is not None:
            self.ticket_no = m.get('ticket_no')
        return self


class ElectronicItineraryBatchApplyResponseBodyModule(TeaModel):
    def __init__(
        self,
        apply_failed_ticket_list: List[ElectronicItineraryBatchApplyResponseBodyModuleApplyFailedTicketList] = None,
        batch_no: str = None,
    ):
        self.apply_failed_ticket_list = apply_failed_ticket_list
        self.batch_no = batch_no

    def validate(self):
        if self.apply_failed_ticket_list:
            for k in self.apply_failed_ticket_list:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['apply_failed_ticket_list'] = []
        if self.apply_failed_ticket_list is not None:
            for k in self.apply_failed_ticket_list:
                result['apply_failed_ticket_list'].append(k.to_map() if k else None)
        if self.batch_no is not None:
            result['batch_no'] = self.batch_no
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.apply_failed_ticket_list = []
        if m.get('apply_failed_ticket_list') is not None:
            for k in m.get('apply_failed_ticket_list'):
                temp_model = ElectronicItineraryBatchApplyResponseBodyModuleApplyFailedTicketList()
                self.apply_failed_ticket_list.append(temp_model.from_map(k))
        if m.get('batch_no') is not None:
            self.batch_no = m.get('batch_no')
        return self


class ElectronicItineraryBatchApplyResponseBody(TeaModel):
    def __init__(
        self,
        code: int = None,
        message: str = None,
        module: ElectronicItineraryBatchApplyResponseBodyModule = None,
        request_id: str = None,
        success: bool = None,
        trace_id: str = None,
    ):
        self.code = code
        self.message = message
        self.module = module
        # requestId
        self.request_id = request_id
        self.success = success
        # traceId
        self.trace_id = trace_id

    def validate(self):
        if self.module:
            self.module.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['code'] = self.code
        if self.message is not None:
            result['message'] = self.message
        if self.module is not None:
            result['module'] = self.module.to_map()
        if self.request_id is not None:
            result['requestId'] = self.request_id
        if self.success is not None:
            result['success'] = self.success
        if self.trace_id is not None:
            result['traceId'] = self.trace_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('code') is not None:
            self.code = m.get('code')
        if m.get('message') is not None:
            self.message = m.get('message')
        if m.get('module') is not None:
            temp_model = ElectronicItineraryBatchApplyResponseBodyModule()
            self.module = temp_model.from_map(m['module'])
        if m.get('requestId') is not None:
            self.request_id = m.get('requestId')
        if m.get('success') is not None:
            self.success = m.get('success')
        if m.get('traceId') is not None:
            self.trace_id = m.get('traceId')
        return self


class ElectronicItineraryBatchApplyResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: ElectronicItineraryBatchApplyResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = ElectronicItineraryBatchApplyResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class ElectronicItineraryGetApplyResultHeaders(TeaModel):
    def __init__(
        self,
        common_headers: Dict[str, str] = None,
        x_acs_btrip_so_corp_token: str = None,
    ):
        self.common_headers = common_headers
        self.x_acs_btrip_so_corp_token = x_acs_btrip_so_corp_token

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.common_headers is not None:
            result['commonHeaders'] = self.common_headers
        if self.x_acs_btrip_so_corp_token is not None:
            result['x-acs-btrip-so-corp-token'] = self.x_acs_btrip_so_corp_token
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('commonHeaders') is not None:
            self.common_headers = m.get('co