# encoding: utf-8

from __future__ import unicode_literals

import json
import tempfile

import pytest

from dagster import seven
from dagster.utils import script_relative_path


def test_is_ascii():
    assert seven.is_ascii('Hello!')
    assert not seven.is_ascii('您好！')


def test_import_module_from_path():
    foo_module = seven.import_module_from_path('foo_module', script_relative_path('foo_module.py'))
    assert foo_module.FOO == 7


def test_json_decode_error():
    with pytest.raises(seven.json.JSONDecodeError):
        json.loads(',dsfjd')


def test_json_dump():
    with tempfile.TemporaryFile('w+') as fd:
        seven.json.dump({'foo': 'bar', 'a': 'b'}, fd)
        fd.seek(0)
        assert fd.read() == '{"a": "b", "foo": "bar"}'


def test_json_dumps():
    assert seven.json.dumps({'foo': 'bar', 'a': 'b'}) == '{"a": "b", "foo": "bar"}'


def test_tempdir():
    assert not seven.temp_dir.get_system_temp_directory().startswith('/var')
