# RELAX: Representation Learning Explainability

</p>
<p align="center">
  <img width="800" src="https://github.com/Wickstrom/RELAX/blob/main/relax-ramework.png">
</p>

..... currently under major reconstruction .....

This repository contains code for RELAX, a framework for representation learning explainability. RELAX is based on perturbation-based explainability and work by measuring the change in the representation space as parts of the input are masked out.

When should you use RELAX? If your output is a vector representation and you have no label information.

More information can be found in the paper: <b>Representation Learning Explainability </b><a href="https://link.springer.com/article/10.1007/s11263-023-01773-2#citeas">(Wickstrøm et al., 2023)</a>, <a href="https://arxiv.org/abs/2112.10161">(Wickstrøm et al., 2022)</a>

You can see RELAX used in practice in medical image retrieval in the paper: <b>A clinically motivated self-supervised approach for content-based image retrieval of CT liver images </b> <a href="https://www.sciencedirect.com/science/article/pii/S0895611123000575">(Wickstrøm et al., 2023)</a>, <a href="https://arxiv.org/abs/2207.04812">(Wickstrøm et al., 2022)</a>

## Installation

RELAX can be installed using pip as follows:

```setup
pip install relax-xai
```

## Citation

If you find RELAX interesting and use it in your research, use the following Bibtex annotation to cite:

```bibtex
@article{wickstrom2023relax,
  author  = {Wickstr\o{}m, Kristoffer K. and Trosten, Daniel J. and L\o{}kse, Sigurd and Boubekki, Ahc\`{e}ne and Mikalsen, Karl \o{}yvind and Kampffmeyer, Michael C. and Jenssen, Robert},
  title   = {RELAX: Representation Learning Explainability},
  journal = {International Journal of Computer Vision},
  year    = {2023},
  volume  = {131},
  number  = {6},
  pages   = {1584–1610},
  url     = {https://doi.org/10.1007/s11263-023-01773-2}
}
```
