# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = [
    'GetSchemaResult',
    'AwaitableGetSchemaResult',
    'get_schema',
    'get_schema_output',
]

@pulumi.output_type
class GetSchemaResult:
    """
    A collection of values returned by getSchema.
    """
    def __init__(__self__, credentials=None, format=None, hard_delete=None, id=None, metadata=None, recreate_on_update=None, rest_endpoint=None, ruleset=None, schema=None, schema_identifier=None, schema_references=None, schema_registry_cluster=None, skip_validation_during_plan=None, subject_name=None, version=None):
        if credentials and not isinstance(credentials, dict):
            raise TypeError("Expected argument 'credentials' to be a dict")
        pulumi.set(__self__, "credentials", credentials)
        if format and not isinstance(format, str):
            raise TypeError("Expected argument 'format' to be a str")
        pulumi.set(__self__, "format", format)
        if hard_delete and not isinstance(hard_delete, bool):
            raise TypeError("Expected argument 'hard_delete' to be a bool")
        pulumi.set(__self__, "hard_delete", hard_delete)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if metadata and not isinstance(metadata, dict):
            raise TypeError("Expected argument 'metadata' to be a dict")
        pulumi.set(__self__, "metadata", metadata)
        if recreate_on_update and not isinstance(recreate_on_update, bool):
            raise TypeError("Expected argument 'recreate_on_update' to be a bool")
        pulumi.set(__self__, "recreate_on_update", recreate_on_update)
        if rest_endpoint and not isinstance(rest_endpoint, str):
            raise TypeError("Expected argument 'rest_endpoint' to be a str")
        pulumi.set(__self__, "rest_endpoint", rest_endpoint)
        if ruleset and not isinstance(ruleset, dict):
            raise TypeError("Expected argument 'ruleset' to be a dict")
        pulumi.set(__self__, "ruleset", ruleset)
        if schema and not isinstance(schema, str):
            raise TypeError("Expected argument 'schema' to be a str")
        pulumi.set(__self__, "schema", schema)
        if schema_identifier and not isinstance(schema_identifier, int):
            raise TypeError("Expected argument 'schema_identifier' to be a int")
        pulumi.set(__self__, "schema_identifier", schema_identifier)
        if schema_references and not isinstance(schema_references, list):
            raise TypeError("Expected argument 'schema_references' to be a list")
        pulumi.set(__self__, "schema_references", schema_references)
        if schema_registry_cluster and not isinstance(schema_registry_cluster, dict):
            raise TypeError("Expected argument 'schema_registry_cluster' to be a dict")
        pulumi.set(__self__, "schema_registry_cluster", schema_registry_cluster)
        if skip_validation_during_plan and not isinstance(skip_validation_during_plan, bool):
            raise TypeError("Expected argument 'skip_validation_during_plan' to be a bool")
        pulumi.set(__self__, "skip_validation_during_plan", skip_validation_during_plan)
        if subject_name and not isinstance(subject_name, str):
            raise TypeError("Expected argument 'subject_name' to be a str")
        pulumi.set(__self__, "subject_name", subject_name)
        if version and not isinstance(version, int):
            raise TypeError("Expected argument 'version' to be a int")
        pulumi.set(__self__, "version", version)

    @_builtins.property
    @pulumi.getter
    def credentials(self) -> Optional['outputs.GetSchemaCredentialsResult']:
        return pulumi.get(self, "credentials")

    @_builtins.property
    @pulumi.getter
    def format(self) -> _builtins.str:
        """
        (Required String) The format of the schema. Accepted values are: `AVRO`, `PROTOBUF`, and `JSON`.
        """
        return pulumi.get(self, "format")

    @_builtins.property
    @pulumi.getter(name="hardDelete")
    def hard_delete(self) -> _builtins.bool:
        return pulumi.get(self, "hard_delete")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter
    def metadata(self) -> 'outputs.GetSchemaMetadataResult':
        """
        (Optional Block) See [here](https://docs.confluent.io/platform/7.5/schema-registry/fundamentals/data-contracts.html) for more details. Supports the following:
        """
        return pulumi.get(self, "metadata")

    @_builtins.property
    @pulumi.getter(name="recreateOnUpdate")
    def recreate_on_update(self) -> _builtins.bool:
        return pulumi.get(self, "recreate_on_update")

    @_builtins.property
    @pulumi.getter(name="restEndpoint")
    def rest_endpoint(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "rest_endpoint")

    @_builtins.property
    @pulumi.getter
    def ruleset(self) -> Optional['outputs.GetSchemaRulesetResult']:
        """
        (Optional Block) The list of schema rules. See [Data Contracts for Schema Registry](https://docs.confluent.io/platform/7.5/schema-registry/fundamentals/data-contracts.html#rules) for more details. For example, these rules can enforce that a field that contains sensitive information must be encrypted, or that a message containing an invalid age must be sent to a dead letter queue.
        """
        return pulumi.get(self, "ruleset")

    @_builtins.property
    @pulumi.getter
    def schema(self) -> _builtins.str:
        """
        (Required String) The schema string, for example, `file("./schema_version_1.avsc")`.
        """
        return pulumi.get(self, "schema")

    @_builtins.property
    @pulumi.getter(name="schemaIdentifier")
    def schema_identifier(self) -> _builtins.int:
        return pulumi.get(self, "schema_identifier")

    @_builtins.property
    @pulumi.getter(name="schemaReferences")
    def schema_references(self) -> Sequence['outputs.GetSchemaSchemaReferenceResult']:
        """
        (Optional List) The list of referenced schemas (see [Schema References](https://docs.confluent.io/platform/current/schema-registry/serdes-develop/index.html#schema-references) for more details):
        """
        return pulumi.get(self, "schema_references")

    @_builtins.property
    @pulumi.getter(name="schemaRegistryCluster")
    def schema_registry_cluster(self) -> Optional['outputs.GetSchemaSchemaRegistryClusterResult']:
        return pulumi.get(self, "schema_registry_cluster")

    @_builtins.property
    @pulumi.getter(name="skipValidationDuringPlan")
    def skip_validation_during_plan(self) -> _builtins.bool:
        return pulumi.get(self, "skip_validation_during_plan")

    @_builtins.property
    @pulumi.getter(name="subjectName")
    def subject_name(self) -> _builtins.str:
        """
        (Required String) The name for the reference. (For Avro Schema, the reference name is the fully qualified schema name, for JSON Schema it is a URL, and for Protobuf Schema, it is the name of another Protobuf file.)
        """
        return pulumi.get(self, "subject_name")

    @_builtins.property
    @pulumi.getter
    def version(self) -> _builtins.int:
        """
        (Required Integer) The version of the Schema, for example, `4`.
        """
        return pulumi.get(self, "version")


class AwaitableGetSchemaResult(GetSchemaResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetSchemaResult(
            credentials=self.credentials,
            format=self.format,
            hard_delete=self.hard_delete,
            id=self.id,
            metadata=self.metadata,
            recreate_on_update=self.recreate_on_update,
            rest_endpoint=self.rest_endpoint,
            ruleset=self.ruleset,
            schema=self.schema,
            schema_identifier=self.schema_identifier,
            schema_references=self.schema_references,
            schema_registry_cluster=self.schema_registry_cluster,
            skip_validation_during_plan=self.skip_validation_during_plan,
            subject_name=self.subject_name,
            version=self.version)


def get_schema(credentials: Optional[Union['GetSchemaCredentialsArgs', 'GetSchemaCredentialsArgsDict']] = None,
               metadata: Optional[Union['GetSchemaMetadataArgs', 'GetSchemaMetadataArgsDict']] = None,
               rest_endpoint: Optional[_builtins.str] = None,
               ruleset: Optional[Union['GetSchemaRulesetArgs', 'GetSchemaRulesetArgsDict']] = None,
               schema_identifier: Optional[_builtins.int] = None,
               schema_registry_cluster: Optional[Union['GetSchemaSchemaRegistryClusterArgs', 'GetSchemaSchemaRegistryClusterArgsDict']] = None,
               subject_name: Optional[_builtins.str] = None,
               opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetSchemaResult:
    """
    [![General Availability](https://img.shields.io/badge/Lifecycle%20Stage-General%20Availability-%2345c6e8)](https://docs.confluent.io/cloud/current/api.html#section/Versioning/API-Lifecycle-Policy)

    `Schema` describes a Schema data source.

    ## Example Usage

    ### Option #1: Manage multiple Schema Registry clusters in the same Pulumi Stack

    ```python
    import pulumi
    import pulumi_confluentcloud as confluentcloud

    purchase_v1 = confluentcloud.get_schema(schema_registry_cluster={
            "id": essentials["id"],
        },
        rest_endpoint=essentials["restEndpoint"],
        subject_name="proto-purchase-value",
        schema_identifier=10001,
        credentials={
            "key": "<Schema Registry API Key for data.confluent_schema_registry_cluster.essentials>",
            "secret": "<Schema Registry API Secret for data.confluent_schema_registry_cluster.essentials>",
        })
    pulumi.export("schema", purchase_v1.schema)
    ```

    ### Option #2: Manage a single Schema Registry cluster in the same Pulumi Stack

    ```python
    import pulumi
    import pulumi_confluentcloud as confluentcloud

    purchase_v1 = confluentcloud.get_schema(subject_name="proto-purchase-value",
        schema_identifier=10001)
    pulumi.export("schema", purchase_v1.schema)
    ```


    :param Union['GetSchemaMetadataArgs', 'GetSchemaMetadataArgsDict'] metadata: (Optional Block) See [here](https://docs.confluent.io/platform/7.5/schema-registry/fundamentals/data-contracts.html) for more details. Supports the following:
    :param _builtins.str rest_endpoint: The REST endpoint of the Schema Registry cluster, for example, `https://psrc-00000.us-central1.gcp.confluent.cloud:443`).
    :param Union['GetSchemaRulesetArgs', 'GetSchemaRulesetArgsDict'] ruleset: (Optional Block) The list of schema rules. See [Data Contracts for Schema Registry](https://docs.confluent.io/platform/7.5/schema-registry/fundamentals/data-contracts.html#rules) for more details. For example, these rules can enforce that a field that contains sensitive information must be encrypted, or that a message containing an invalid age must be sent to a dead letter queue.
    :param _builtins.int schema_identifier: The globally unique ID of the Schema, for example, `100003`. If the same schema is registered under a different subject, the same identifier will be returned. However, the `version` of the schema may be different under different subjects.
           
           > **Note:** A Schema Registry API key consists of a key and a secret. Schema Registry API keys are required to interact with Schema Registry clusters in Confluent Cloud. Each Schema Registry API key is valid for one specific Schema Registry cluster.
    :param _builtins.str subject_name: The name of the subject (in other words, the namespace), representing the subject under which the schema will be registered, for example, `test-subject`. Schemas evolve safely, following a compatibility mode defined, under a subject name.
    """
    __args__ = dict()
    __args__['credentials'] = credentials
    __args__['metadata'] = metadata
    __args__['restEndpoint'] = rest_endpoint
    __args__['ruleset'] = ruleset
    __args__['schemaIdentifier'] = schema_identifier
    __args__['schemaRegistryCluster'] = schema_registry_cluster
    __args__['subjectName'] = subject_name
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('confluentcloud:index/getSchema:getSchema', __args__, opts=opts, typ=GetSchemaResult).value

    return AwaitableGetSchemaResult(
        credentials=pulumi.get(__ret__, 'credentials'),
        format=pulumi.get(__ret__, 'format'),
        hard_delete=pulumi.get(__ret__, 'hard_delete'),
        id=pulumi.get(__ret__, 'id'),
        metadata=pulumi.get(__ret__, 'metadata'),
        recreate_on_update=pulumi.get(__ret__, 'recreate_on_update'),
        rest_endpoint=pulumi.get(__ret__, 'rest_endpoint'),
        ruleset=pulumi.get(__ret__, 'ruleset'),
        schema=pulumi.get(__ret__, 'schema'),
        schema_identifier=pulumi.get(__ret__, 'schema_identifier'),
        schema_references=pulumi.get(__ret__, 'schema_references'),
        schema_registry_cluster=pulumi.get(__ret__, 'schema_registry_cluster'),
        skip_validation_during_plan=pulumi.get(__ret__, 'skip_validation_during_plan'),
        subject_name=pulumi.get(__ret__, 'subject_name'),
        version=pulumi.get(__ret__, 'version'))
def get_schema_output(credentials: Optional[pulumi.Input[Optional[Union['GetSchemaCredentialsArgs', 'GetSchemaCredentialsArgsDict']]]] = None,
                      metadata: Optional[pulumi.Input[Optional[Union['GetSchemaMetadataArgs', 'GetSchemaMetadataArgsDict']]]] = None,
                      rest_endpoint: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                      ruleset: Optional[pulumi.Input[Optional[Union['GetSchemaRulesetArgs', 'GetSchemaRulesetArgsDict']]]] = None,
                      schema_identifier: Optional[pulumi.Input[_builtins.int]] = None,
                      schema_registry_cluster: Optional[pulumi.Input[Optional[Union['GetSchemaSchemaRegistryClusterArgs', 'GetSchemaSchemaRegistryClusterArgsDict']]]] = None,
                      subject_name: Optional[pulumi.Input[_builtins.str]] = None,
                      opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetSchemaResult]:
    """
    [![General Availability](https://img.shields.io/badge/Lifecycle%20Stage-General%20Availability-%2345c6e8)](https://docs.confluent.io/cloud/current/api.html#section/Versioning/API-Lifecycle-Policy)

    `Schema` describes a Schema data source.

    ## Example Usage

    ### Option #1: Manage multiple Schema Registry clusters in the same Pulumi Stack

    ```python
    import pulumi
    import pulumi_confluentcloud as confluentcloud

    purchase_v1 = confluentcloud.get_schema(schema_registry_cluster={
            "id": essentials["id"],
        },
        rest_endpoint=essentials["restEndpoint"],
        subject_name="proto-purchase-value",
        schema_identifier=10001,
        credentials={
            "key": "<Schema Registry API Key for data.confluent_schema_registry_cluster.essentials>",
            "secret": "<Schema Registry API Secret for data.confluent_schema_registry_cluster.essentials>",
        })
    pulumi.export("schema", purchase_v1.schema)
    ```

    ### Option #2: Manage a single Schema Registry cluster in the same Pulumi Stack

    ```python
    import pulumi
    import pulumi_confluentcloud as confluentcloud

    purchase_v1 = confluentcloud.get_schema(subject_name="proto-purchase-value",
        schema_identifier=10001)
    pulumi.export("schema", purchase_v1.schema)
    ```


    :param Union['GetSchemaMetadataArgs', 'GetSchemaMetadataArgsDict'] metadata: (Optional Block) See [here](https://docs.confluent.io/platform/7.5/schema-registry/fundamentals/data-contracts.html) for more details. Supports the following:
    :param _builtins.str rest_endpoint: The REST endpoint of the Schema Registry cluster, for example, `https://psrc-00000.us-central1.gcp.confluent.cloud:443`).
    :param Union['GetSchemaRulesetArgs', 'GetSchemaRulesetArgsDict'] ruleset: (Optional Block) The list of schema rules. See [Data Contracts for Schema Registry](https://docs.confluent.io/platform/7.5/schema-registry/fundamentals/data-contracts.html#rules) for more details. For example, these rules can enforce that a field that contains sensitive information must be encrypted, or that a message containing an invalid age must be sent to a dead letter queue.
    :param _builtins.int schema_identifier: The globally unique ID of the Schema, for example, `100003`. If the same schema is registered under a different subject, the same identifier will be returned. However, the `version` of the schema may be different under different subjects.
           
           > **Note:** A Schema Registry API key consists of a key and a secret. Schema Registry API keys are required to interact with Schema Registry clusters in Confluent Cloud. Each Schema Registry API key is valid for one specific Schema Registry cluster.
    :param _builtins.str subject_name: The name of the subject (in other words, the namespace), representing the subject under which the schema will be registered, for example, `test-subject`. Schemas evolve safely, following a compatibility mode defined, under a subject name.
    """
    __args__ = dict()
    __args__['credentials'] = credentials
    __args__['metadata'] = metadata
    __args__['restEndpoint'] = rest_endpoint
    __args__['ruleset'] = ruleset
    __args__['schemaIdentifier'] = schema_identifier
    __args__['schemaRegistryCluster'] = schema_registry_cluster
    __args__['subjectName'] = subject_name
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('confluentcloud:index/getSchema:getSchema', __args__, opts=opts, typ=GetSchemaResult)
    return __ret__.apply(lambda __response__: GetSchemaResult(
        credentials=pulumi.get(__response__, 'credentials'),
        format=pulumi.get(__response__, 'format'),
        hard_delete=pulumi.get(__response__, 'hard_delete'),
        id=pulumi.get(__response__, 'id'),
        metadata=pulumi.get(__response__, 'metadata'),
        recreate_on_update=pulumi.get(__response__, 'recreate_on_update'),
        rest_endpoint=pulumi.get(__response__, 'rest_endpoint'),
        ruleset=pulumi.get(__response__, 'ruleset'),
        schema=pulumi.get(__response__, 'schema'),
        schema_identifier=pulumi.get(__response__, 'schema_identifier'),
        schema_references=pulumi.get(__response__, 'schema_references'),
        schema_registry_cluster=pulumi.get(__response__, 'schema_registry_cluster'),
        skip_validation_during_plan=pulumi.get(__response__, 'skip_validation_during_plan'),
        subject_name=pulumi.get(__response__, 'subject_name'),
        version=pulumi.get(__response__, 'version')))
