# pluggy-sdk
Pluggy's main API to review data and execute connectors

This Python package is automatically generated by the [OpenAPI Generator](https://openapi-generator.tech) project:

- API version: 1.0.0
- Package version: 1.0.0.post49
- Generator version: 7.14.0
- Build package: org.openapitools.codegen.languages.PythonClientCodegen
For more information, please visit [https://pluggy.ai](https://pluggy.ai)

## Requirements.

Python 3.9+

## Installation & Usage
### pip install

If the python package is hosted on a repository, you can install directly using:

```sh
pip install git+https://github.com/GIT_USER_ID/GIT_REPO_ID.git
```
(you may need to run `pip` with root permission: `sudo pip install git+https://github.com/GIT_USER_ID/GIT_REPO_ID.git`)

Then import the package:
```python
import pluggy_sdk
```

### Setuptools

Install via [Setuptools](http://pypi.python.org/pypi/setuptools).

```sh
python setup.py install --user
```
(or `sudo python setup.py install` to install the package for all users)

Then import the package:
```python
import pluggy_sdk
```

### Tests

Execute `pytest` to run the tests.

## Getting Started

Please follow the [installation procedure](#installation--usage) and then run the following:

```python

import pluggy_sdk
from pluggy_sdk.rest import ApiException
from pprint import pprint

# Defining the host is optional and defaults to https://api.pluggy.ai
# See configuration.py for a list of all supported configuration parameters.
configuration = pluggy_sdk.Configuration(
    host = "https://api.pluggy.ai"
)

# The client must configure the authentication and authorization parameters
# in accordance with the API server security policy.
# Examples for each auth method are provided below, use the example that
# satisfies your auth use case.

# Configure API key authorization: default
configuration.api_key['default'] = os.environ["API_KEY"]

# Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
# configuration.api_key_prefix['default'] = 'Bearer'


# Enter a context with an instance of the API client
with pluggy_sdk.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = pluggy_sdk.AccountApi(api_client)
    item_id = 'd0f8a8c0-e8e3-11e9-b210-d663bd873d93' # str | Item primary identifier
    type = 'BANK' # str | Parameter to filter between bank accounts and credit accounts (optional)

    try:
        # List
        api_response = api_instance.accounts_list(item_id, type=type)
        print("The response of AccountApi->accounts_list:\n")
        pprint(api_response)
    except ApiException as e:
        print("Exception when calling AccountApi->accounts_list: %s\n" % e)

```

## Documentation for API Endpoints

All URIs are relative to *https://api.pluggy.ai*

Class | Method | HTTP request | Description
------------ | ------------- | ------------- | -------------
*AccountApi* | [**accounts_list**](docs/AccountApi.md#accounts_list) | **GET** /accounts | List
*AccountApi* | [**accounts_retrieve**](docs/AccountApi.md#accounts_retrieve) | **GET** /accounts/{id} | Retrieve
*AuthApi* | [**auth_create**](docs/AuthApi.md#auth_create) | **POST** /auth | Create API Key
*AuthApi* | [**connect_token_create**](docs/AuthApi.md#connect_token_create) | **POST** /connect_token | Create Connect Token
*AutomaticPIXApi* | [**cancel_automatic_pix_schedule**](docs/AutomaticPIXApi.md#cancel_automatic_pix_schedule) | **POST** /payments/requests/{id}/automatic-pix/schedules/{scheduleId}/cancel | Cancel an Automatic PIX schedule
*AutomaticPIXApi* | [**payment_request_cancel_automatic_pix_consent**](docs/AutomaticPIXApi.md#payment_request_cancel_automatic_pix_consent) | **POST** /payments/requests/{id}/automatic-pix/cancel | Cancel an automatic PIX consent
*AutomaticPIXApi* | [**payment_request_create_automatic_pix**](docs/AutomaticPIXApi.md#payment_request_create_automatic_pix) | **POST** /payments/requests/automatic-pix | Create Automatic PIX payment request
*AutomaticPIXApi* | [**payment_request_create_automatic_pix_schedule**](docs/AutomaticPIXApi.md#payment_request_create_automatic_pix_schedule) | **POST** /payments/requests/{id}/automatic-pix/schedule | Schedule Automatic PIX payment
*AutomaticPIXApi* | [**payment_request_get_automatic_pix_schedule**](docs/AutomaticPIXApi.md#payment_request_get_automatic_pix_schedule) | **GET** /payments/requests/{requestId}/automatic-pix/schedules/{paymentId} | Get an automatic PIX scheduled payment
*AutomaticPIXApi* | [**payment_request_get_automatic_pix_schedules**](docs/AutomaticPIXApi.md#payment_request_get_automatic_pix_schedules) | **GET** /payments/requests/{id}/automatic-pix/schedules | List Automatic PIX scheduled payments
*AutomaticPIXApi* | [**retry_automatic_pix_schedule**](docs/AutomaticPIXApi.md#retry_automatic_pix_schedule) | **POST** /payments/requests/{id}/automatic-pix/schedules/{scheduleId}/retry | Retry an Automatic PIX schedule
*BillApi* | [**bills_list**](docs/BillApi.md#bills_list) | **GET** /bills | List
*BillApi* | [**bills_retrieve**](docs/BillApi.md#bills_retrieve) | **GET** /bills/{id} | Retrieve
*BoletoManagementApi* | [**boleto_cancel**](docs/BoletoManagementApi.md#boleto_cancel) | **POST** /boletos/{id}/cancel | Cancel Boleto
*BoletoManagementApi* | [**boleto_connection_create**](docs/BoletoManagementApi.md#boleto_connection_create) | **POST** /boleto-connections | Connect boleto credentials
*BoletoManagementApi* | [**boleto_connection_create_from_item**](docs/BoletoManagementApi.md#boleto_connection_create_from_item) | **POST** /boleto-connections/from-item | Create boleto connection from Item
*BoletoManagementApi* | [**boleto_create**](docs/BoletoManagementApi.md#boleto_create) | **POST** /boletos | Issue Boleto
*BoletoManagementApi* | [**boleto_get**](docs/BoletoManagementApi.md#boleto_get) | **GET** /boletos/{id} | Get Boleto
*CategoryApi* | [**categories_list**](docs/CategoryApi.md#categories_list) | **GET** /categories | List
*CategoryApi* | [**categories_retrieve**](docs/CategoryApi.md#categories_retrieve) | **GET** /categories/{id} | Retrieve
*CategoryApi* | [**client_category_rules_create**](docs/CategoryApi.md#client_category_rules_create) | **POST** /categories/rules | Create Category Rule
*CategoryApi* | [**client_category_rules_list**](docs/CategoryApi.md#client_category_rules_list) | **GET** /categories/rules | List Category Rules
*ConnectorApi* | [**connector_retrieve**](docs/ConnectorApi.md#connector_retrieve) | **GET** /connectors/{id} | Retrieve
*ConnectorApi* | [**connectors_list**](docs/ConnectorApi.md#connectors_list) | **GET** /connectors | List
*ConnectorApi* | [**connectors_validate**](docs/ConnectorApi.md#connectors_validate) | **POST** /connectors/{id}/validate | Validate
*ConsentApi* | [**consent_retrieve**](docs/ConsentApi.md#consent_retrieve) | **GET** /consents/{id} | Retrieve
*ConsentApi* | [**consents_list**](docs/ConsentApi.md#consents_list) | **GET** /consents | List
*IdentityApi* | [**identity_find_by_item**](docs/IdentityApi.md#identity_find_by_item) | **GET** /identity | Find by item
*IdentityApi* | [**identity_retrieve**](docs/IdentityApi.md#identity_retrieve) | **GET** /identity/{id} | Retrieve
*InvestmentApi* | [**investment_transactions_list**](docs/InvestmentApi.md#investment_transactions_list) | **GET** /investments/{id}/transactions | List investment transactions
*InvestmentApi* | [**investments_list**](docs/InvestmentApi.md#investments_list) | **GET** /investments | List
*InvestmentApi* | [**investments_retrieve**](docs/InvestmentApi.md#investments_retrieve) | **GET** /investments/{id} | Retrieve
*ItemsApi* | [**items_create**](docs/ItemsApi.md#items_create) | **POST** /items | Create
*ItemsApi* | [**items_delete**](docs/ItemsApi.md#items_delete) | **DELETE** /items/{id} | Delete
*ItemsApi* | [**items_disable_autosync**](docs/ItemsApi.md#items_disable_autosync) | **PATCH** /items/{id}/disable-auto-sync | Disable item auto sync
*ItemsApi* | [**items_retrieve**](docs/ItemsApi.md#items_retrieve) | **GET** /items/{id} | Retrieve
*ItemsApi* | [**items_send_mfa**](docs/ItemsApi.md#items_send_mfa) | **POST** /items/{id}/mfa | Send MFA
*ItemsApi* | [**items_update**](docs/ItemsApi.md#items_update) | **PATCH** /items/{id} | Update
*LoanApi* | [**loans_list**](docs/LoanApi.md#loans_list) | **GET** /loans | List
*LoanApi* | [**loans_retrieve**](docs/LoanApi.md#loans_retrieve) | **GET** /loans/{id} | Retrieve
*PaymentCustomerApi* | [**payment_customer_create**](docs/PaymentCustomerApi.md#payment_customer_create) | **POST** /payments/customers | Create
*PaymentCustomerApi* | [**payment_customer_delete**](docs/PaymentCustomerApi.md#payment_customer_delete) | **DELETE** /payments/customers/{id} | Delete
*PaymentCustomerApi* | [**payment_customer_retrieve**](docs/PaymentCustomerApi.md#payment_customer_retrieve) | **GET** /payments/customers/{id} | Retrieve
*PaymentCustomerApi* | [**payment_customer_update**](docs/PaymentCustomerApi.md#payment_customer_update) | **PATCH** /payments/customers/{id} | Update
*PaymentCustomerApi* | [**payment_customers_list**](docs/PaymentCustomerApi.md#payment_customers_list) | **GET** /payments/customers | List
*PaymentIntentApi* | [**payment_intent_create**](docs/PaymentIntentApi.md#payment_intent_create) | **POST** /payments/intents | Create
*PaymentIntentApi* | [**payment_intent_retrieve**](docs/PaymentIntentApi.md#payment_intent_retrieve) | **GET** /payments/intents/{id} | Retrieve
*PaymentIntentApi* | [**payment_intents_list**](docs/PaymentIntentApi.md#payment_intents_list) | **GET** /payments/intents | List
*PaymentRecipientApi* | [**payment_recipient_create**](docs/PaymentRecipientApi.md#payment_recipient_create) | **POST** /payments/recipients | Create
*PaymentRecipientApi* | [**payment_recipient_delete**](docs/PaymentRecipientApi.md#payment_recipient_delete) | **DELETE** /payments/recipients/{id} | Delete
*PaymentRecipientApi* | [**payment_recipient_institutions_retrieve**](docs/PaymentRecipientApi.md#payment_recipient_institutions_retrieve) | **GET** /payments/recipients/institutions/{id} | Retrieve Institution
*PaymentRecipientApi* | [**payment_recipient_retrieve**](docs/PaymentRecipientApi.md#payment_recipient_retrieve) | **GET** /payments/recipients/{id} | Retrieve
*PaymentRecipientApi* | [**payment_recipient_update**](docs/PaymentRecipientApi.md#payment_recipient_update) | **PATCH** /payments/recipients/{id} | Update
*PaymentRecipientApi* | [**payment_recipients_institution_list**](docs/PaymentRecipientApi.md#payment_recipients_institution_list) | **GET** /payments/recipients/institutions | List Institutions
*PaymentRecipientApi* | [**payment_recipients_list**](docs/PaymentRecipientApi.md#payment_recipients_list) | **GET** /payments/recipients | List
*PaymentRequestApi* | [**payment_request_create**](docs/PaymentRequestApi.md#payment_request_create) | **POST** /payments/requests | Create
*PaymentRequestApi* | [**payment_request_create_pix_qr**](docs/PaymentRequestApi.md#payment_request_create_pix_qr) | **POST** /payments/requests/pix-qr | Create PIX QR payment request
*PaymentRequestApi* | [**payment_request_delete**](docs/PaymentRequestApi.md#payment_request_delete) | **DELETE** /payments/requests/{id} | Delete
*PaymentRequestApi* | [**payment_request_retrieve**](docs/PaymentRequestApi.md#payment_request_retrieve) | **GET** /payments/requests/{id} | Retrieve
*PaymentRequestApi* | [**payment_request_update**](docs/PaymentRequestApi.md#payment_request_update) | **PATCH** /payments/requests/{id} | Update
*PaymentRequestApi* | [**payment_requests_list**](docs/PaymentRequestApi.md#payment_requests_list) | **GET** /payments/requests | List
*PaymentScheduleApi* | [**payment_schedules_cancel**](docs/PaymentScheduleApi.md#payment_schedules_cancel) | **POST** /payments/requests/{id}/schedules/cancel | Cancel Payment Schedule Authorization
*PaymentScheduleApi* | [**payment_schedules_cancel_specific**](docs/PaymentScheduleApi.md#payment_schedules_cancel_specific) | **POST** /payments/requests/{id}/schedules/{scheduleId}/cancel | Cancel Payment Schedule
*PaymentScheduleApi* | [**payment_schedules_list**](docs/PaymentScheduleApi.md#payment_schedules_list) | **GET** /payments/requests/{id}/schedules | List Schedules
*SmartTransferApi* | [**smart_tranfers_preauthorizations_list**](docs/SmartTransferApi.md#smart_tranfers_preauthorizations_list) | **GET** /smart-transfers/preauthorizations | List preauthorizations
*SmartTransferApi* | [**smart_transfer_payment_create**](docs/SmartTransferApi.md#smart_transfer_payment_create) | **POST** /smart-transfers/payments | Create payment
*SmartTransferApi* | [**smart_transfer_paymentretrieve**](docs/SmartTransferApi.md#smart_transfer_paymentretrieve) | **GET** /smart-transfers/payments/{id} | Retrieve payment
*SmartTransferApi* | [**smart_transfer_preauthorization_create**](docs/SmartTransferApi.md#smart_transfer_preauthorization_create) | **POST** /smart-transfers/preauthorizations | Create preauthorization
*SmartTransferApi* | [**smart_transfer_preauthorization_retrieve**](docs/SmartTransferApi.md#smart_transfer_preauthorization_retrieve) | **GET** /smart-transfers/preauthorizations/{id} | Retrieve preauthorization
*TransactionApi* | [**transactions_list**](docs/TransactionApi.md#transactions_list) | **GET** /transactions | List
*TransactionApi* | [**transactions_retrieve**](docs/TransactionApi.md#transactions_retrieve) | **GET** /transactions/{id} | Retrieve
*TransactionApi* | [**transactions_update**](docs/TransactionApi.md#transactions_update) | **PATCH** /transactions/{id} | Update
*WebhookApi* | [**webhooks_create**](docs/WebhookApi.md#webhooks_create) | **POST** /webhooks | Create
*WebhookApi* | [**webhooks_delete**](docs/WebhookApi.md#webhooks_delete) | **DELETE** /webhooks/{id} | Delete
*WebhookApi* | [**webhooks_list**](docs/WebhookApi.md#webhooks_list) | **GET** /webhooks | List
*WebhookApi* | [**webhooks_retrieve**](docs/WebhookApi.md#webhooks_retrieve) | **GET** /webhooks/{id} | Retrieve
*WebhookApi* | [**webhooks_update**](docs/WebhookApi.md#webhooks_update) | **PATCH** /webhooks/{id} | Update


## Documentation For Models

 - [Account](docs/Account.md)
 - [AccountsList200Response](docs/AccountsList200Response.md)
 - [AdditionalCard](docs/AdditionalCard.md)
 - [Address](docs/Address.md)
 - [AuthRequest](docs/AuthRequest.md)
 - [AuthResponse](docs/AuthResponse.md)
 - [AutomaticPixFirstPayment](docs/AutomaticPixFirstPayment.md)
 - [AutomaticPixPayment](docs/AutomaticPixPayment.md)
 - [BankData](docs/BankData.md)
 - [Bill](docs/Bill.md)
 - [BillFinanceCharge](docs/BillFinanceCharge.md)
 - [BillsList200Response](docs/BillsList200Response.md)
 - [Boleto](docs/Boleto.md)
 - [BoletoConnection](docs/BoletoConnection.md)
 - [BoletoPayer](docs/BoletoPayer.md)
 - [BoletoRecipient](docs/BoletoRecipient.md)
 - [CUSTOM](docs/CUSTOM.md)
 - [Category](docs/Category.md)
 - [ClientCategoryRule](docs/ClientCategoryRule.md)
 - [Company](docs/Company.md)
 - [ConnectTokenRequest](docs/ConnectTokenRequest.md)
 - [ConnectTokenResponse](docs/ConnectTokenResponse.md)
 - [Connector](docs/Connector.md)
 - [ConnectorCredential](docs/ConnectorCredential.md)
 - [ConnectorHealth](docs/ConnectorHealth.md)
 - [ConnectorHealthDetails](docs/ConnectorHealthDetails.md)
 - [ConnectorListResponse](docs/ConnectorListResponse.md)
 - [ConnectorUserAction](docs/ConnectorUserAction.md)
 - [Consent](docs/Consent.md)
 - [CreateAutomaticPixPaymentRequest](docs/CreateAutomaticPixPaymentRequest.md)
 - [CreateBoleto](docs/CreateBoleto.md)
 - [CreateBoletoBoleto](docs/CreateBoletoBoleto.md)
 - [CreateBoletoBoletoFine](docs/CreateBoletoBoletoFine.md)
 - [CreateBoletoBoletoInterest](docs/CreateBoletoBoletoInterest.md)
 - [CreateBoletoBoletoPayer](docs/CreateBoletoBoletoPayer.md)
 - [CreateBoletoConnection](docs/CreateBoletoConnection.md)
 - [CreateBoletoConnectionFromItem](docs/CreateBoletoConnectionFromItem.md)
 - [CreateClientCategoryRule](docs/CreateClientCategoryRule.md)
 - [CreateItem](docs/CreateItem.md)
 - [CreateItemParameters](docs/CreateItemParameters.md)
 - [CreateOrUpdatePaymentCustomer](docs/CreateOrUpdatePaymentCustomer.md)
 - [CreatePaymentCustomerRequestBody](docs/CreatePaymentCustomerRequestBody.md)
 - [CreatePaymentIntent](docs/CreatePaymentIntent.md)
 - [CreatePaymentRecipient](docs/CreatePaymentRecipient.md)
 - [CreatePaymentRequest](docs/CreatePaymentRequest.md)
 - [CreatePaymentRequestSchedule](docs/CreatePaymentRequestSchedule.md)
 - [CreatePixQrPaymentRequest](docs/CreatePixQrPaymentRequest.md)
 - [CreateSmartTransferPayment](docs/CreateSmartTransferPayment.md)
 - [CreateSmartTransferPreauthorization](docs/CreateSmartTransferPreauthorization.md)
 - [CreateWebhook](docs/CreateWebhook.md)
 - [CredentialSelectOption](docs/CredentialSelectOption.md)
 - [CreditCardMetadata](docs/CreditCardMetadata.md)
 - [CreditData](docs/CreditData.md)
 - [DAILY](docs/DAILY.md)
 - [DisaggregatedCreditLimit](docs/DisaggregatedCreditLimit.md)
 - [Document](docs/Document.md)
 - [Email](docs/Email.md)
 - [GlobalErrorResponse](docs/GlobalErrorResponse.md)
 - [ICountResponse](docs/ICountResponse.md)
 - [IdentityRelation](docs/IdentityRelation.md)
 - [IdentityResponse](docs/IdentityResponse.md)
 - [IdentityResponseFinancialRelationships](docs/IdentityResponseFinancialRelationships.md)
 - [IdentityResponseFinancialRelationshipsAccountsInner](docs/IdentityResponseFinancialRelationshipsAccountsInner.md)
 - [IdentityResponseFinancialRelationshipsProcuratorsInner](docs/IdentityResponseFinancialRelationshipsProcuratorsInner.md)
 - [IdentityResponseQualifications](docs/IdentityResponseQualifications.md)
 - [IdentityResponseQualificationsInformedIncome](docs/IdentityResponseQualificationsInformedIncome.md)
 - [IdentityResponseQualificationsInformedPatrimony](docs/IdentityResponseQualificationsInformedPatrimony.md)
 - [Investment](docs/Investment.md)
 - [InvestmentExpenses](docs/InvestmentExpenses.md)
 - [InvestmentMetadata](docs/InvestmentMetadata.md)
 - [InvestmentTransaction](docs/InvestmentTransaction.md)
 - [InvestmentsList200Response](docs/InvestmentsList200Response.md)
 - [IssuedBoleto](docs/IssuedBoleto.md)
 - [IssuedBoletoFine](docs/IssuedBoletoFine.md)
 - [IssuedBoletoInterest](docs/IssuedBoletoInterest.md)
 - [IssuedBoletoPayer](docs/IssuedBoletoPayer.md)
 - [Item](docs/Item.md)
 - [ItemCreationErrorResponse](docs/ItemCreationErrorResponse.md)
 - [ItemError](docs/ItemError.md)
 - [ItemOptions](docs/ItemOptions.md)
 - [Loan](docs/Loan.md)
 - [LoanContractedFee](docs/LoanContractedFee.md)
 - [LoanContractedFinanceCharge](docs/LoanContractedFinanceCharge.md)
 - [LoanInstallmentBalloonPayment](docs/LoanInstallmentBalloonPayment.md)
 - [LoanInstallmentBalloonPaymentAmount](docs/LoanInstallmentBalloonPaymentAmount.md)
 - [LoanInstallments](docs/LoanInstallments.md)
 - [LoanInterestRate](docs/LoanInterestRate.md)
 - [LoanPaymentRelease](docs/LoanPaymentRelease.md)
 - [LoanPaymentReleaseOverParcel](docs/LoanPaymentReleaseOverParcel.md)
 - [LoanPaymentReleaseOverParcelCharge](docs/LoanPaymentReleaseOverParcelCharge.md)
 - [LoanPaymentReleaseOverParcelFee](docs/LoanPaymentReleaseOverParcelFee.md)
 - [LoanPayments](docs/LoanPayments.md)
 - [LoanWarranty](docs/LoanWarranty.md)
 - [LoansList200Response](docs/LoansList200Response.md)
 - [MONTHLY](docs/MONTHLY.md)
 - [Merchant](docs/Merchant.md)
 - [NotAuthenticatedResponse](docs/NotAuthenticatedResponse.md)
 - [PageResponseCategoryRules](docs/PageResponseCategoryRules.md)
 - [PageResponseConsents](docs/PageResponseConsents.md)
 - [PageResponseInvestmentTransactions](docs/PageResponseInvestmentTransactions.md)
 - [PageResponseTransactions](docs/PageResponseTransactions.md)
 - [ParameterValidationError](docs/ParameterValidationError.md)
 - [ParameterValidationResponse](docs/ParameterValidationResponse.md)
 - [PaymentCustomer](docs/PaymentCustomer.md)
 - [PaymentCustomersList200Response](docs/PaymentCustomersList200Response.md)
 - [PaymentData](docs/PaymentData.md)
 - [PaymentDataBoletoMetadata](docs/PaymentDataBoletoMetadata.md)
 - [PaymentDataParticipant](docs/PaymentDataParticipant.md)
 - [PaymentInstitution](docs/PaymentInstitution.md)
 - [PaymentIntent](docs/PaymentIntent.md)
 - [PaymentIntentAutomaticPix](docs/PaymentIntentAutomaticPix.md)
 - [PaymentIntentErrorDetail](docs/PaymentIntentErrorDetail.md)
 - [PaymentIntentParameter](docs/PaymentIntentParameter.md)
 - [PaymentIntentsList200Response](docs/PaymentIntentsList200Response.md)
 - [PaymentRecipient](docs/PaymentRecipient.md)
 - [PaymentRecipientAccount](docs/PaymentRecipientAccount.md)
 - [PaymentRecipientsInstitutionList200Response](docs/PaymentRecipientsInstitutionList200Response.md)
 - [PaymentRecipientsList200Response](docs/PaymentRecipientsList200Response.md)
 - [PaymentRequest](docs/PaymentRequest.md)
 - [PaymentRequestCallbackUrls](docs/PaymentRequestCallbackUrls.md)
 - [PaymentRequestErrorDetail](docs/PaymentRequestErrorDetail.md)
 - [PaymentRequestGetAutomaticPixSchedules200Response](docs/PaymentRequestGetAutomaticPixSchedules200Response.md)
 - [PaymentRequestSchedule](docs/PaymentRequestSchedule.md)
 - [PaymentRequestsList200Response](docs/PaymentRequestsList200Response.md)
 - [PaymentSchedulesList200Response](docs/PaymentSchedulesList200Response.md)
 - [PhoneNumber](docs/PhoneNumber.md)
 - [PixData](docs/PixData.md)
 - [RetryAutomaticPixPaymentRequest](docs/RetryAutomaticPixPaymentRequest.md)
 - [SINGLE](docs/SINGLE.md)
 - [ScheduleAutomaticPixPaymentRequest](docs/ScheduleAutomaticPixPaymentRequest.md)
 - [SchedulePayment](docs/SchedulePayment.md)
 - [SchedulePaymentErrorDetail](docs/SchedulePaymentErrorDetail.md)
 - [SmartTranfersPreauthorizationsList200Response](docs/SmartTranfersPreauthorizationsList200Response.md)
 - [SmartTransferCallbackUrls](docs/SmartTransferCallbackUrls.md)
 - [SmartTransferPayment](docs/SmartTransferPayment.md)
 - [SmartTransferPreauthorization](docs/SmartTransferPreauthorization.md)
 - [SmartTransferPreauthorizationParameter](docs/SmartTransferPreauthorizationParameter.md)
 - [StatusDetail](docs/StatusDetail.md)
 - [StatusDetailProduct](docs/StatusDetailProduct.md)
 - [StatusDetailProductWarning](docs/StatusDetailProductWarning.md)
 - [Transaction](docs/Transaction.md)
 - [UpdateItem](docs/UpdateItem.md)
 - [UpdateItemParameters](docs/UpdateItemParameters.md)
 - [UpdatePaymentRecipient](docs/UpdatePaymentRecipient.md)
 - [UpdatePaymentRequest](docs/UpdatePaymentRequest.md)
 - [UpdateTransaction](docs/UpdateTransaction.md)
 - [WEEKLY](docs/WEEKLY.md)
 - [Webhook](docs/Webhook.md)
 - [WebhookCreationErrorResponse](docs/WebhookCreationErrorResponse.md)
 - [WebhooksList200Response](docs/WebhooksList200Response.md)


<a id="documentation-for-authorization"></a>
## Documentation For Authorization


Authentication schemes defined for the API:
<a id="default"></a>
### default

- **Type**: API key
- **API key parameter name**: X-API-KEY
- **Location**: HTTP header


## Author

hello@pluggy.ai


