# coding: utf-8

"""
    Pluggy API

    Pluggy's main API to review data and execute connectors

    The version of the OpenAPI document: 1.0.0
    Contact: hello@pluggy.ai
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictStr, field_validator
from typing import Any, ClassVar, Dict, List, Optional
from pluggy_sdk.models.acquirer_anticipation_data import AcquirerAnticipationData
from pluggy_sdk.models.acquirer_receivable_data import AcquirerReceivableData
from pluggy_sdk.models.acquirer_sale_data import AcquirerSaleData
from typing import Optional, Set
from typing_extensions import Self

class AcquirerData(BaseModel):
    """
    Data of a transaction specific to institutions of type PAYMENT_ACCOUNT (acquiring banks)
    """ # noqa: E501
    type: StrictStr = Field(description="The type of acquiring bank transaction")
    sale_data: Optional[AcquirerSaleData] = Field(default=None, alias="saleData")
    receivable_data: Optional[AcquirerReceivableData] = Field(default=None, alias="receivableData")
    anticipation_data: Optional[AcquirerAnticipationData] = Field(default=None, alias="anticipationData")
    __properties: ClassVar[List[str]] = ["type", "saleData", "receivableData", "anticipationData"]

    @field_validator('type')
    def type_validate_enum(cls, value):
        """Validates the enum"""
        if value not in set(['SALE', 'RECEIVABLE', 'ANTICIPATION', 'CHARGEBACK']):
            raise ValueError("must be one of enum values ('SALE', 'RECEIVABLE', 'ANTICIPATION', 'CHARGEBACK')")
        return value

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of AcquirerData from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of sale_data
        if self.sale_data:
            _dict['saleData'] = self.sale_data.to_dict()
        # override the default output from pydantic by calling `to_dict()` of receivable_data
        if self.receivable_data:
            _dict['receivableData'] = self.receivable_data.to_dict()
        # override the default output from pydantic by calling `to_dict()` of anticipation_data
        if self.anticipation_data:
            _dict['anticipationData'] = self.anticipation_data.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of AcquirerData from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "type": obj.get("type"),
            "saleData": AcquirerSaleData.from_dict(obj["saleData"]) if obj.get("saleData") is not None else None,
            "receivableData": AcquirerReceivableData.from_dict(obj["receivableData"]) if obj.get("receivableData") is not None else None,
            "anticipationData": AcquirerAnticipationData.from_dict(obj["anticipationData"]) if obj.get("anticipationData") is not None else None
        })
        return _obj


