# coding: utf-8

"""
    Pluggy API

    Pluggy's main API to review data and execute connectors

    The version of the OpenAPI document: 1.0.0
    Contact: hello@pluggy.ai
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictFloat, StrictInt, StrictStr, field_validator
from typing import Any, ClassVar, Dict, List, Optional, Union
from pluggy_sdk.models.connector_credential import ConnectorCredential
from pluggy_sdk.models.connector_health import ConnectorHealth
from typing import Optional, Set
from typing_extensions import Self

class Connector(BaseModel):
    """
    Connector object
    """ # noqa: E501
    id: Union[StrictFloat, StrictInt] = Field(description="Primary identifier")
    name: Optional[StrictStr] = Field(default=None, description="Name of the institution")
    institution_url: Optional[StrictStr] = Field(default=None, description="Homepage of the institution", alias="institutionUrl")
    image_url: Optional[StrictStr] = Field(default=None, description="Image of the logo hosted by Pluggy", alias="imageUrl")
    primary_color: Optional[StrictStr] = Field(default=None, description="Primary color", alias="primaryColor")
    type: Optional[StrictStr] = Field(default=None, description="Type of institution")
    country: Optional[StrictStr] = Field(default=None, description="Country located")
    credentials: Optional[List[ConnectorCredential]] = Field(default=None, description="Parameters required to start the connection")
    has_mfa: Optional[StrictBool] = Field(default=None, description="Does the connector require an MFA to execute?", alias="hasMFA")
    products: Optional[List[StrictStr]] = Field(default=None, description="Products supported by the connector")
    oauth: Optional[StrictBool] = Field(default=None, description="If 'true', the connector requires an Oauth flow to execute")
    oauth_url: Optional[StrictStr] = Field(default=None, description="URL to perform Oauth flow if needed", alias="oauthUrl")
    reset_password_url: Optional[StrictStr] = Field(default=None, description="URL to the financial institution to reset the password", alias="resetPasswordUrl")
    health: Optional[ConnectorHealth] = None
    is_open_finance: Optional[StrictBool] = Field(default=None, description="Indicates if the connector uses the regulated Open Finance APIs", alias="isOpenFinance")
    supports_payment_initiation: Optional[StrictBool] = Field(default=None, description="Indicates if the connector supports the payment initiation API", alias="supportsPaymentInitiation")
    supports_scheduled_payments: Optional[StrictBool] = Field(default=None, description="Indicates if the connector supports scheduled payments", alias="supportsScheduledPayments")
    supports_smart_transfers: Optional[StrictBool] = Field(default=None, description="Indicates if the connector supports smart transfers", alias="supportsSmartTransfers")
    supports_boleto_management: Optional[StrictBool] = Field(default=None, description="Indicates if the connector supports boleto management", alias="supportsBoletoManagement")
    created_at: Optional[datetime] = Field(default=None, description="Date of creation", alias="createdAt")
    updated_at: Optional[datetime] = Field(default=None, description="Date of last modification", alias="updatedAt")
    __properties: ClassVar[List[str]] = ["id", "name", "institutionUrl", "imageUrl", "primaryColor", "type", "country", "credentials", "hasMFA", "products", "oauth", "oauthUrl", "resetPasswordUrl", "health", "isOpenFinance", "supportsPaymentInitiation", "supportsScheduledPayments", "supportsSmartTransfers", "supportsBoletoManagement", "createdAt", "updatedAt"]

    @field_validator('products')
    def products_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        for i in value:
            if i not in set(['ACCOUNTS', 'CREDIT_CARDS', 'TRANSACTIONS', 'PAYMENT_DATA', 'INVESTMENTS', 'INVESTMENTS_TRANSACTIONS', 'IDENTITY', 'BROKERAGE_NOTE', 'MOVE_SECURITY', 'LOANS']):
                raise ValueError("each list item must be one of ('ACCOUNTS', 'CREDIT_CARDS', 'TRANSACTIONS', 'PAYMENT_DATA', 'INVESTMENTS', 'INVESTMENTS_TRANSACTIONS', 'IDENTITY', 'BROKERAGE_NOTE', 'MOVE_SECURITY', 'LOANS')")
        return value

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of Connector from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of each item in credentials (list)
        _items = []
        if self.credentials:
            for _item_credentials in self.credentials:
                if _item_credentials:
                    _items.append(_item_credentials.to_dict())
            _dict['credentials'] = _items
        # override the default output from pydantic by calling `to_dict()` of health
        if self.health:
            _dict['health'] = self.health.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of Connector from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "id": obj.get("id"),
            "name": obj.get("name"),
            "institutionUrl": obj.get("institutionUrl"),
            "imageUrl": obj.get("imageUrl"),
            "primaryColor": obj.get("primaryColor"),
            "type": obj.get("type"),
            "country": obj.get("country"),
            "credentials": [ConnectorCredential.from_dict(_item) for _item in obj["credentials"]] if obj.get("credentials") is not None else None,
            "hasMFA": obj.get("hasMFA"),
            "products": obj.get("products"),
            "oauth": obj.get("oauth"),
            "oauthUrl": obj.get("oauthUrl"),
            "resetPasswordUrl": obj.get("resetPasswordUrl"),
            "health": ConnectorHealth.from_dict(obj["health"]) if obj.get("health") is not None else None,
            "isOpenFinance": obj.get("isOpenFinance"),
            "supportsPaymentInitiation": obj.get("supportsPaymentInitiation"),
            "supportsScheduledPayments": obj.get("supportsScheduledPayments"),
            "supportsSmartTransfers": obj.get("supportsSmartTransfers"),
            "supportsBoletoManagement": obj.get("supportsBoletoManagement"),
            "createdAt": obj.get("createdAt"),
            "updatedAt": obj.get("updatedAt")
        })
        return _obj


