# coding: utf-8

"""
    Pluggy API

    Pluggy's main API to review data and execute connectors

    The version of the OpenAPI document: 1.0.0
    Contact: hello@pluggy.ai
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from pydantic import BaseModel, ConfigDict, Field
from typing import Any, ClassVar, Dict, List, Optional, Union
from typing_extensions import Annotated
from pluggy_sdk.models.create_boleto_boleto_fine import CreateBoletoBoletoFine
from pluggy_sdk.models.create_boleto_boleto_interest import CreateBoletoBoletoInterest
from pluggy_sdk.models.create_boleto_boleto_payer import CreateBoletoBoletoPayer
from typing import Optional, Set
from typing_extensions import Self

class CreateBoletoBoleto(BaseModel):
    """
    CreateBoletoBoleto
    """ # noqa: E501
    seu_numero: Annotated[str, Field(strict=True, max_length=10)] = Field(description="Your identifier for this boleto", alias="seuNumero")
    amount: Union[Annotated[float, Field(strict=True, ge=2.5)], Annotated[int, Field(strict=True, ge=3)]] = Field(description="Boleto amount")
    due_date: datetime = Field(description="Due date for the boleto. Must be today or in the future.", alias="dueDate")
    payer: CreateBoletoBoletoPayer
    fine: Optional[CreateBoletoBoletoFine] = None
    interest: Optional[CreateBoletoBoletoInterest] = None
    __properties: ClassVar[List[str]] = ["seuNumero", "amount", "dueDate", "payer", "fine", "interest"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of CreateBoletoBoleto from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of payer
        if self.payer:
            _dict['payer'] = self.payer.to_dict()
        # override the default output from pydantic by calling `to_dict()` of fine
        if self.fine:
            _dict['fine'] = self.fine.to_dict()
        # override the default output from pydantic by calling `to_dict()` of interest
        if self.interest:
            _dict['interest'] = self.interest.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of CreateBoletoBoleto from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "seuNumero": obj.get("seuNumero"),
            "amount": obj.get("amount"),
            "dueDate": obj.get("dueDate"),
            "payer": CreateBoletoBoletoPayer.from_dict(obj["payer"]) if obj.get("payer") is not None else None,
            "fine": CreateBoletoBoletoFine.from_dict(obj["fine"]) if obj.get("fine") is not None else None,
            "interest": CreateBoletoBoletoInterest.from_dict(obj["interest"]) if obj.get("interest") is not None else None
        })
        return _obj


