# coding: utf-8

"""
    Pluggy API

    Pluggy's main API to review data and execute connectors

    The version of the OpenAPI document: 1.0.0
    Contact: hello@pluggy.ai
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictFloat, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Optional, Union
from typing import Optional, Set
from typing_extensions import Self

class DisaggregatedCreditLimit(BaseModel):
    """
    Disaggregated credit card limit
    """ # noqa: E501
    credit_line_limit_type: StrictStr = Field(description="Limit type (LIMITE_CREDITO_TOTAL or LIMITE_CREDITO_MODALIDADE_OPERACAO)", alias="creditLineLimitType")
    consolidation_type: StrictStr = Field(description="Indicates if the limit is consolidated or individual", alias="consolidationType")
    identification_number: StrictStr = Field(description="Identification number of the additional credit card", alias="identificationNumber")
    is_limit_flexible: StrictBool = Field(description="Indicates if the limit is flexible", alias="isLimitFlexible")
    used_amount: Union[StrictFloat, StrictInt] = Field(description="Used amount of the additional credit card", alias="usedAmount")
    used_amount_currency_code: StrictStr = Field(description="Used amount currency code (for example, BRL)", alias="usedAmountCurrencyCode")
    line_name: Optional[StrictStr] = Field(default=None, description="Name of the line (for example, 'Limite de Crédito')", alias="lineName")
    line_name_additional_info: Optional[StrictStr] = Field(default=None, description="Additional information about the line name", alias="lineNameAdditionalInfo")
    limit_amount: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, description="Limit amount of the additional credit card", alias="limitAmount")
    limit_amount_currency_code: Optional[StrictStr] = Field(default=None, description="Limit amount currency code (for example, BRL)", alias="limitAmountCurrencyCode")
    available_amount: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, description="Available amount of the additional credit card", alias="availableAmount")
    available_amount_currency_code: Optional[StrictStr] = Field(default=None, description="Available amount currency code (for example, BRL)", alias="availableAmountCurrencyCode")
    __properties: ClassVar[List[str]] = ["creditLineLimitType", "consolidationType", "identificationNumber", "isLimitFlexible", "usedAmount", "usedAmountCurrencyCode", "lineName", "lineNameAdditionalInfo", "limitAmount", "limitAmountCurrencyCode", "availableAmount", "availableAmountCurrencyCode"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of DisaggregatedCreditLimit from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of DisaggregatedCreditLimit from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "creditLineLimitType": obj.get("creditLineLimitType"),
            "consolidationType": obj.get("consolidationType"),
            "identificationNumber": obj.get("identificationNumber"),
            "isLimitFlexible": obj.get("isLimitFlexible"),
            "usedAmount": obj.get("usedAmount"),
            "usedAmountCurrencyCode": obj.get("usedAmountCurrencyCode"),
            "lineName": obj.get("lineName"),
            "lineNameAdditionalInfo": obj.get("lineNameAdditionalInfo"),
            "limitAmount": obj.get("limitAmount"),
            "limitAmountCurrencyCode": obj.get("limitAmountCurrencyCode"),
            "availableAmount": obj.get("availableAmount"),
            "availableAmountCurrencyCode": obj.get("availableAmountCurrencyCode")
        })
        return _obj


