# coding: utf-8

"""
    Pluggy API

    Pluggy's main API to review data and execute connectors

    The version of the OpenAPI document: 1.0.0
    Contact: hello@pluggy.ai
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from pydantic import BaseModel, ConfigDict, Field, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from pluggy_sdk.models.identity_response_financial_relationships_accounts_inner import IdentityResponseFinancialRelationshipsAccountsInner
from pluggy_sdk.models.identity_response_financial_relationships_procurators_inner import IdentityResponseFinancialRelationshipsProcuratorsInner
from typing import Optional, Set
from typing_extensions import Self

class IdentityResponseFinancialRelationships(BaseModel):
    """
    Information that allows institutions to assess, evaluate, characterize, and classify the client with the purpose of understanding their risk profile and their economic-financial capacity
    """ # noqa: E501
    start_date: datetime = Field(description="Date when the relationship with the institution started", alias="startDate")
    products_services_type: List[StrictStr] = Field(description="List of products and services that the client consumes", alias="productsServicesType")
    procurators: List[IdentityResponseFinancialRelationshipsProcuratorsInner] = Field(description="List of procurators of the client")
    accounts: Optional[List[IdentityResponseFinancialRelationshipsAccountsInner]] = Field(default=None, description="List of accounts of the client")
    __properties: ClassVar[List[str]] = ["startDate", "productsServicesType", "procurators", "accounts"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of IdentityResponseFinancialRelationships from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of each item in procurators (list)
        _items = []
        if self.procurators:
            for _item_procurators in self.procurators:
                if _item_procurators:
                    _items.append(_item_procurators.to_dict())
            _dict['procurators'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in accounts (list)
        _items = []
        if self.accounts:
            for _item_accounts in self.accounts:
                if _item_accounts:
                    _items.append(_item_accounts.to_dict())
            _dict['accounts'] = _items
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of IdentityResponseFinancialRelationships from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "startDate": obj.get("startDate"),
            "productsServicesType": obj.get("productsServicesType"),
            "procurators": [IdentityResponseFinancialRelationshipsProcuratorsInner.from_dict(_item) for _item in obj["procurators"]] if obj.get("procurators") is not None else None,
            "accounts": [IdentityResponseFinancialRelationshipsAccountsInner.from_dict(_item) for _item in obj["accounts"]] if obj.get("accounts") is not None else None
        })
        return _obj


