# coding: utf-8

"""
    Pluggy API

    Pluggy's main API to review data and execute connectors

    The version of the OpenAPI document: 1.0.0
    Contact: hello@pluggy.ai
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictStr, field_validator
from typing import Any, ClassVar, Dict, List, Optional
from pluggy_sdk.models.identity_response_qualifications_informed_income import IdentityResponseQualificationsInformedIncome
from pluggy_sdk.models.identity_response_qualifications_informed_patrimony import IdentityResponseQualificationsInformedPatrimony
from typing import Optional, Set
from typing_extensions import Self

class IdentityResponseQualifications(BaseModel):
    """
    Information that allows understanding since when the consulted person has been a client of the institution, as well as an indicator of the products and services they currently consume and their representatives
    """ # noqa: E501
    company_cnpj: StrictStr = Field(description="CNPJ of the company", alias="companyCnpj")
    occupation_code: Optional[StrictStr] = Field(default=None, description="Occupation code", alias="occupationCode")
    informed_income: Optional[IdentityResponseQualificationsInformedIncome] = Field(default=None, alias="informedIncome")
    informed_patrimony: Optional[IdentityResponseQualificationsInformedPatrimony] = Field(default=None, alias="informedPatrimony")
    __properties: ClassVar[List[str]] = ["companyCnpj", "occupationCode", "informedIncome", "informedPatrimony"]

    @field_validator('occupation_code')
    def occupation_code_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in set(['RECEITA_FEDERAL', 'CBO', 'OUTRO']):
            raise ValueError("must be one of enum values ('RECEITA_FEDERAL', 'CBO', 'OUTRO')")
        return value

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of IdentityResponseQualifications from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of informed_income
        if self.informed_income:
            _dict['informedIncome'] = self.informed_income.to_dict()
        # override the default output from pydantic by calling `to_dict()` of informed_patrimony
        if self.informed_patrimony:
            _dict['informedPatrimony'] = self.informed_patrimony.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of IdentityResponseQualifications from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "companyCnpj": obj.get("companyCnpj"),
            "occupationCode": obj.get("occupationCode"),
            "informedIncome": IdentityResponseQualificationsInformedIncome.from_dict(obj["informedIncome"]) if obj.get("informedIncome") is not None else None,
            "informedPatrimony": IdentityResponseQualificationsInformedPatrimony.from_dict(obj["informedPatrimony"]) if obj.get("informedPatrimony") is not None else None
        })
        return _obj


