# coding: utf-8

"""
    Pluggy API

    Pluggy's main API to review data and execute connectors

    The version of the OpenAPI document: 1.0.0
    Contact: hello@pluggy.ai
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from pydantic import BaseModel, ConfigDict, Field, StrictFloat, StrictInt, StrictStr, field_validator
from typing import Any, ClassVar, Dict, List, Optional, Union
from pluggy_sdk.models.investment_expenses import InvestmentExpenses
from typing import Optional, Set
from typing_extensions import Self

class InvestmentTransaction(BaseModel):
    """
    Movement of the investment
    """ # noqa: E501
    id: StrictStr = Field(description="Primary investment transaction identifier")
    type: StrictStr = Field(description="Type of transactions")
    movement_type: Optional[StrictStr] = Field(default=None, description="Type of movement of the transaction", alias="movementType")
    quantity: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, description="Quantity of the transaction")
    value: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, description="Value on the transaction's Date")
    amount: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, description="Gross amount of the operation. May be null only if type is TRANSFER")
    agreed_rate: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, description="Agreed rate for treasury applications", alias="agreedRate")
    var_date: datetime = Field(description="Date when the transaction was made", alias="date")
    trade_date: Optional[datetime] = Field(default=None, description="Date when the transaction was confirmed", alias="tradeDate")
    expenses: Optional[InvestmentExpenses] = None
    __properties: ClassVar[List[str]] = ["id", "type", "movementType", "quantity", "value", "amount", "agreedRate", "date", "tradeDate", "expenses"]

    @field_validator('type')
    def type_validate_enum(cls, value):
        """Validates the enum"""
        if value not in set(['BUY', 'SELL', 'TAX', 'TRANSFER', 'INTEREST', 'AMORTIZATION']):
            raise ValueError("must be one of enum values ('BUY', 'SELL', 'TAX', 'TRANSFER', 'INTEREST', 'AMORTIZATION')")
        return value

    @field_validator('movement_type')
    def movement_type_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in set(['CREDIT', 'DEBIT']):
            raise ValueError("must be one of enum values ('CREDIT', 'DEBIT')")
        return value

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of InvestmentTransaction from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of expenses
        if self.expenses:
            _dict['expenses'] = self.expenses.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of InvestmentTransaction from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "id": obj.get("id"),
            "type": obj.get("type"),
            "movementType": obj.get("movementType"),
            "quantity": obj.get("quantity"),
            "value": obj.get("value"),
            "amount": obj.get("amount"),
            "agreedRate": obj.get("agreedRate"),
            "date": obj.get("date"),
            "tradeDate": obj.get("tradeDate"),
            "expenses": InvestmentExpenses.from_dict(obj["expenses"]) if obj.get("expenses") is not None else None
        })
        return _obj


