# coding: utf-8

"""
    Pluggy API

    Pluggy's main API to review data and execute connectors

    The version of the OpenAPI document: 1.0.0
    Contact: hello@pluggy.ai
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictFloat, StrictInt, StrictStr, field_validator
from typing import Any, ClassVar, Dict, List, Optional, Union
from typing import Optional, Set
from typing_extensions import Self

class IssuedBoletoPayer(BaseModel):
    """
    IssuedBoletoPayer
    """ # noqa: E501
    tax_number: StrictStr = Field(description="Payer tax number (CPF/CNPJ)", alias="taxNumber")
    person_type: Optional[StrictStr] = Field(default=None, description="Type of person (individual or business)", alias="personType")
    name: StrictStr = Field(description="Payer name")
    address_street: Optional[StrictStr] = Field(default=None, description="Payer street address", alias="addressStreet")
    address_number: Optional[StrictStr] = Field(default=None, description="Payer address number", alias="addressNumber")
    address_complement: Optional[StrictStr] = Field(default=None, description="Additional address information", alias="addressComplement")
    address_neighborhood: Optional[StrictStr] = Field(default=None, description="Payer neighborhood", alias="addressNeighborhood")
    address_city: Optional[StrictStr] = Field(default=None, description="Payer city", alias="addressCity")
    address_state: StrictStr = Field(description="Payer state", alias="addressState")
    address_zip_code: StrictStr = Field(description="Payer ZIP code", alias="addressZipCode")
    email: Optional[StrictStr] = Field(default=None, description="Payer email")
    ddd: Optional[StrictStr] = Field(default=None, description="Payer area code")
    phone_number: Optional[StrictStr] = Field(default=None, description="Payer phone number", alias="phoneNumber")
    amount_paid: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, description="Amount paid or null if it hasn't been paid yet", alias="amountPaid")
    payment_origin: Optional[StrictStr] = Field(default=None, description="Payment origin for the boleto", alias="paymentOrigin")
    __properties: ClassVar[List[str]] = ["taxNumber", "personType", "name", "addressStreet", "addressNumber", "addressComplement", "addressNeighborhood", "addressCity", "addressState", "addressZipCode", "email", "ddd", "phoneNumber", "amountPaid", "paymentOrigin"]

    @field_validator('payment_origin')
    def payment_origin_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in set(['PIX', 'BOLETO']):
            raise ValueError("must be one of enum values ('PIX', 'BOLETO')")
        return value

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of IssuedBoletoPayer from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of IssuedBoletoPayer from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "taxNumber": obj.get("taxNumber"),
            "personType": obj.get("personType"),
            "name": obj.get("name"),
            "addressStreet": obj.get("addressStreet"),
            "addressNumber": obj.get("addressNumber"),
            "addressComplement": obj.get("addressComplement"),
            "addressNeighborhood": obj.get("addressNeighborhood"),
            "addressCity": obj.get("addressCity"),
            "addressState": obj.get("addressState"),
            "addressZipCode": obj.get("addressZipCode"),
            "email": obj.get("email"),
            "ddd": obj.get("ddd"),
            "phoneNumber": obj.get("phoneNumber"),
            "amountPaid": obj.get("amountPaid"),
            "paymentOrigin": obj.get("paymentOrigin")
        })
        return _obj


