# coding: utf-8

"""
    Pluggy API

    Pluggy's main API to review data and execute connectors

    The version of the OpenAPI document: 1.0.0
    Contact: hello@pluggy.ai
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictFloat, StrictInt, StrictStr, field_validator
from typing import Any, ClassVar, Dict, List, Optional, Union
from typing import Optional, Set
from typing_extensions import Self

class LoanInterestRate(BaseModel):
    """
    Object that brings the set of information necessary to demonstrate the composition of the remunerative interest rates of the Credit Type
    """ # noqa: E501
    tax_type: Optional[StrictStr] = Field(default=None, description="Tax type", alias="taxType")
    interest_rate_type: Optional[StrictStr] = Field(default=None, description="Interest rate type", alias="interestRateType")
    tax_periodicity: Optional[StrictStr] = Field(default=None, description="Tax periodicity", alias="taxPeriodicity")
    calculation: Optional[StrictStr] = Field(default=None, description="Calculation basis")
    referential_rate_indexer_type: Optional[StrictStr] = Field(default=None, description="Types of benchmark rates or indexers (https://openbanking-brasil.github.io/openapi/swagger-apis/loans/?urls.primaryName=2.0.1#model-EnumContractReferentialRateIndexerType)", alias="referentialRateIndexerType")
    referential_rate_indexer_sub_type: Optional[StrictStr] = Field(default=None, description="Subtypes of benchmark rates or indexers (https://openbanking-brasil.github.io/openapi/swagger-apis/loans/?urls.primaryName=2.0.1#model-EnumContractReferentialRateIndexerSubType)", alias="referentialRateIndexerSubType")
    referential_rate_indexer_additional_info: Optional[StrictStr] = Field(default=None, description="Free field to complement the information regarding the Type of reference rate or indexer", alias="referentialRateIndexerAdditionalInfo")
    pre_fixed_rate: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, description="Pre-fixed rate applied under the credit modality contract. 1 = 100%", alias="preFixedRate")
    post_fixed_rate: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, description="Post-fixed rate applied under the credit modality contract. 1 = 100%", alias="postFixedRate")
    additional_info: Optional[StrictStr] = Field(default=None, description="Text with additional information on the composition of agreed interest rates", alias="additionalInfo")
    __properties: ClassVar[List[str]] = ["taxType", "interestRateType", "taxPeriodicity", "calculation", "referentialRateIndexerType", "referentialRateIndexerSubType", "referentialRateIndexerAdditionalInfo", "preFixedRate", "postFixedRate", "additionalInfo"]

    @field_validator('tax_type')
    def tax_type_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in set(['NOMINAL', 'EFFECTIVE']):
            raise ValueError("must be one of enum values ('NOMINAL', 'EFFECTIVE')")
        return value

    @field_validator('interest_rate_type')
    def interest_rate_type_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in set(['SIMPLE', 'COMPOUND']):
            raise ValueError("must be one of enum values ('SIMPLE', 'COMPOUND')")
        return value

    @field_validator('tax_periodicity')
    def tax_periodicity_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in set(['MONTHLY', 'YEARLY']):
            raise ValueError("must be one of enum values ('MONTHLY', 'YEARLY')")
        return value

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of LoanInterestRate from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of LoanInterestRate from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "taxType": obj.get("taxType"),
            "interestRateType": obj.get("interestRateType"),
            "taxPeriodicity": obj.get("taxPeriodicity"),
            "calculation": obj.get("calculation"),
            "referentialRateIndexerType": obj.get("referentialRateIndexerType"),
            "referentialRateIndexerSubType": obj.get("referentialRateIndexerSubType"),
            "referentialRateIndexerAdditionalInfo": obj.get("referentialRateIndexerAdditionalInfo"),
            "preFixedRate": obj.get("preFixedRate"),
            "postFixedRate": obj.get("postFixedRate"),
            "additionalInfo": obj.get("additionalInfo")
        })
        return _obj


