# coding: utf-8

"""
    Pluggy API

    Pluggy's main API to review data and execute connectors

    The version of the OpenAPI document: 1.0.0
    Contact: hello@pluggy.ai
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictFloat, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Optional, Union
from pluggy_sdk.models.percentage_over_index import PercentageOverIndex
from typing import Optional, Set
from typing_extensions import Self

class MonthlyPortfolio(BaseModel):
    """
    Response with overview of the distribution and yield of all the assets the user has month by month
    """ # noqa: E501
    balance: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, description="Current balance from total portfolio of assets")
    yield_percentage: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, description="Percentage yield compared to the previous month", alias="yieldPercentage")
    yield_amount: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, description="Amount yield over the period", alias="yieldAmount")
    var_date: Optional[StrictStr] = Field(default=None, description="First day of the month retrieved", alias="date")
    yield_percentage_over_index: Optional[PercentageOverIndex] = Field(default=None, alias="yieldPercentageOverIndex")
    __properties: ClassVar[List[str]] = ["balance", "yieldPercentage", "yieldAmount", "date", "yieldPercentageOverIndex"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of MonthlyPortfolio from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of yield_percentage_over_index
        if self.yield_percentage_over_index:
            _dict['yieldPercentageOverIndex'] = self.yield_percentage_over_index.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of MonthlyPortfolio from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "balance": obj.get("balance"),
            "yieldPercentage": obj.get("yieldPercentage"),
            "yieldAmount": obj.get("yieldAmount"),
            "date": obj.get("date"),
            "yieldPercentageOverIndex": PercentageOverIndex.from_dict(obj["yieldPercentageOverIndex"]) if obj.get("yieldPercentageOverIndex") is not None else None
        })
        return _obj


