# coding: utf-8

"""
    Pluggy API

    Pluggy's main API to review data and execute connectors

    The version of the OpenAPI document: 1.0.0
    Contact: hello@pluggy.ai
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from pluggy_sdk.models.payment_data_boleto_metadata import PaymentDataBoletoMetadata
from pluggy_sdk.models.payment_data_participant import PaymentDataParticipant
from typing import Optional, Set
from typing_extensions import Self

class PaymentData(BaseModel):
    """
    Payment or Transfer participant's data
    """ # noqa: E501
    payer: Optional[PaymentDataParticipant] = None
    receiver: Optional[PaymentDataParticipant] = None
    reason: Optional[StrictStr] = Field(default=None, description="User's motive submitted while making the transfer")
    reference_number: Optional[StrictStr] = Field(default=None, description="Reference number for the transfer/payment", alias="referenceNumber")
    receiver_reference_id: Optional[StrictStr] = Field(default=None, description="String submitted by the receiver associated with the payment when generating the payment request.", alias="receiverReferenceId")
    payment_method: Optional[StrictStr] = Field(default=None, description="Type of transfer. TED, DOC, PIX, TEV or BOLETO", alias="paymentMethod")
    boleto_metadata: Optional[PaymentDataBoletoMetadata] = Field(default=None, alias="boletoMetadata")
    __properties: ClassVar[List[str]] = ["payer", "receiver", "reason", "referenceNumber", "receiverReferenceId", "paymentMethod", "boletoMetadata"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of PaymentData from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of payer
        if self.payer:
            _dict['payer'] = self.payer.to_dict()
        # override the default output from pydantic by calling `to_dict()` of receiver
        if self.receiver:
            _dict['receiver'] = self.receiver.to_dict()
        # override the default output from pydantic by calling `to_dict()` of boleto_metadata
        if self.boleto_metadata:
            _dict['boletoMetadata'] = self.boleto_metadata.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of PaymentData from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "payer": PaymentDataParticipant.from_dict(obj["payer"]) if obj.get("payer") is not None else None,
            "receiver": PaymentDataParticipant.from_dict(obj["receiver"]) if obj.get("receiver") is not None else None,
            "reason": obj.get("reason"),
            "referenceNumber": obj.get("referenceNumber"),
            "receiverReferenceId": obj.get("receiverReferenceId"),
            "paymentMethod": obj.get("paymentMethod"),
            "boletoMetadata": PaymentDataBoletoMetadata.from_dict(obj["boletoMetadata"]) if obj.get("boletoMetadata") is not None else None
        })
        return _obj


