# coding: utf-8

"""
    Pluggy API

    Pluggy's main API to review data and execute connectors

    The version of the OpenAPI document: 1.0.0
    Contact: hello@pluggy.ai
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictFloat, StrictInt, StrictStr, field_validator
from typing import Any, ClassVar, Dict, List, Optional, Union
from pluggy_sdk.models.automatic_pix_first_payment import AutomaticPixFirstPayment
from typing import Optional, Set
from typing_extensions import Self

class PaymentIntentAutomaticPix(BaseModel):
    """
    Automatic PIX data
    """ # noqa: E501
    fixed_amount: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, description="Fixed charge amount; if filled in, it represents consent for payments of fixed amounts, not subject to change during the validity of the consent. If it's sent, minimumVariableAmount and maximumVariableAmount cannot be provided.", alias="fixedAmount")
    minimum_variable_amount: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, description="Minimum amount allowed per charge; if filled in, it represents consent for payments of variable amounts. If it's sent, fixedAmount cannot be provided.", alias="minimumVariableAmount")
    maximum_variable_amount: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, description="Maximum amount allowed per charge; if filled in, it represents consent for payments of variable amounts. If it's sent, fixedAmount cannot be provided.", alias="maximumVariableAmount")
    start_date: datetime = Field(description="Represents the expected date for the first occurrence of a payment associated with the recurrence.", alias="startDate")
    expires_at: Optional[datetime] = Field(default=None, description="Expiration date for the automatic pix authorization", alias="expiresAt")
    is_retry_accepted: Optional[StrictBool] = Field(default=None, description="Indicates whether the receiving customer is allowed to make payment attempts, according to the rules established in the Pix arrangement.", alias="isRetryAccepted")
    first_payment: Optional[AutomaticPixFirstPayment] = Field(default=None, alias="firstPayment")
    interval: StrictStr = Field(description="Defines the permitted frequency for carrying out transactions.")
    __properties: ClassVar[List[str]] = ["fixedAmount", "minimumVariableAmount", "maximumVariableAmount", "startDate", "expiresAt", "isRetryAccepted", "firstPayment", "interval"]

    @field_validator('interval')
    def interval_validate_enum(cls, value):
        """Validates the enum"""
        if value not in set(['WEEKLY', 'MONTHLY', 'QUARTERLY', 'SEMESTER', 'YEARLY']):
            raise ValueError("must be one of enum values ('WEEKLY', 'MONTHLY', 'QUARTERLY', 'SEMESTER', 'YEARLY')")
        return value

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of PaymentIntentAutomaticPix from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of first_payment
        if self.first_payment:
            _dict['firstPayment'] = self.first_payment.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of PaymentIntentAutomaticPix from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "fixedAmount": obj.get("fixedAmount"),
            "minimumVariableAmount": obj.get("minimumVariableAmount"),
            "maximumVariableAmount": obj.get("maximumVariableAmount"),
            "startDate": obj.get("startDate"),
            "expiresAt": obj.get("expiresAt"),
            "isRetryAccepted": obj.get("isRetryAccepted"),
            "firstPayment": AutomaticPixFirstPayment.from_dict(obj["firstPayment"]) if obj.get("firstPayment") is not None else None,
            "interval": obj.get("interval")
        })
        return _obj


