# coding: utf-8

"""
    Pluggy API

    Pluggy's main API to review data and execute connectors

    The version of the OpenAPI document: 1.0.0
    Contact: hello@pluggy.ai
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from pydantic import BaseModel, ConfigDict, Field, StrictFloat, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Optional, Union
from pluggy_sdk.models.boleto import Boleto
from pluggy_sdk.models.payment_receipt_person import PaymentReceiptPerson
from typing import Optional, Set
from typing_extensions import Self

class PaymentReceipt(BaseModel):
    """
    Response with information related to a payment receipt
    """ # noqa: E501
    id: StrictStr = Field(description="Primary identifier")
    payment_request_id: StrictStr = Field(description="Payment request identifier", alias="paymentRequestId")
    expires_at: datetime = Field(description="Date when the payment receipt expires", alias="expiresAt")
    receipt_url: StrictStr = Field(description="URL to download the payment receipt", alias="receiptUrl")
    creditor: PaymentReceiptPerson = Field(description="Creditor bank account information")
    debtor: PaymentReceiptPerson = Field(description="Debtor bank account information")
    amount: Union[StrictFloat, StrictInt] = Field(description="Payment amount")
    description: Optional[StrictStr] = Field(default=None, description="Payment description")
    reference_id: StrictStr = Field(description="Payment reference identifier", alias="referenceId")
    var_date: Optional[datetime] = Field(default=None, description="Date when the payment was made", alias="date")
    boleto: Optional[Boleto] = None
    __properties: ClassVar[List[str]] = ["id", "paymentRequestId", "expiresAt", "receiptUrl", "creditor", "debtor", "amount", "description", "referenceId", "date", "boleto"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of PaymentReceipt from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of creditor
        if self.creditor:
            _dict['creditor'] = self.creditor.to_dict()
        # override the default output from pydantic by calling `to_dict()` of debtor
        if self.debtor:
            _dict['debtor'] = self.debtor.to_dict()
        # override the default output from pydantic by calling `to_dict()` of boleto
        if self.boleto:
            _dict['boleto'] = self.boleto.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of PaymentReceipt from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "id": obj.get("id"),
            "paymentRequestId": obj.get("paymentRequestId"),
            "expiresAt": obj.get("expiresAt"),
            "receiptUrl": obj.get("receiptUrl"),
            "creditor": PaymentReceiptPerson.from_dict(obj["creditor"]) if obj.get("creditor") is not None else None,
            "debtor": PaymentReceiptPerson.from_dict(obj["debtor"]) if obj.get("debtor") is not None else None,
            "amount": obj.get("amount"),
            "description": obj.get("description"),
            "referenceId": obj.get("referenceId"),
            "date": obj.get("date"),
            "boleto": Boleto.from_dict(obj["boleto"]) if obj.get("boleto") is not None else None
        })
        return _obj


