# coding: utf-8

"""
    Pluggy API

    Pluggy's main API to review data and execute connectors

    The version of the OpenAPI document: 1.0.0
    Contact: hello@pluggy.ai
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from pydantic import BaseModel, ConfigDict, Field, StrictFloat, StrictInt, StrictStr, field_validator
from typing import Any, ClassVar, Dict, List, Optional, Union
from pluggy_sdk.models.boleto import Boleto
from pluggy_sdk.models.payment_intent_automatic_pix import PaymentIntentAutomaticPix
from pluggy_sdk.models.payment_request_callback_urls import PaymentRequestCallbackUrls
from pluggy_sdk.models.payment_request_error_detail import PaymentRequestErrorDetail
from pluggy_sdk.models.payment_request_schedule import PaymentRequestSchedule
from typing import Optional, Set
from typing_extensions import Self

class PaymentRequest(BaseModel):
    """
    Response with information related to a payment request
    """ # noqa: E501
    id: StrictStr = Field(description="Primary identifier")
    amount: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, description="Requested amount. For automatic pix it won't be returned")
    fees: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, description="Fees charged for the payment request. This includes both Pluggy's fees and any customer-specific fees. Fees are calculated based on the payment method (PIX or Boleto) and the client's pricing configuration. For sandbox accounts, fees are set to 0.")
    description: Optional[StrictStr] = Field(default=None, description="Payment description")
    status: StrictStr = Field(description="Payment request status")
    client_payment_id: Optional[StrictStr] = Field(default=None, description="Client payment identifier", alias="clientPaymentId")
    created_at: datetime = Field(description="Date when the payment request was created", alias="createdAt")
    updated_at: datetime = Field(description="Date when the payment request was updated", alias="updatedAt")
    callback_urls: Optional[PaymentRequestCallbackUrls] = Field(default=None, alias="callbackUrls")
    recipient_id: Optional[StrictStr] = Field(default=None, description="Payment receiver identifier", alias="recipientId")
    payment_url: StrictStr = Field(description="URL to begin the payment intent creation flow for this payment request", alias="paymentUrl")
    pix_qr_code: Optional[StrictStr] = Field(default=None, description="Pix QR code generated by the payment receiver", alias="pixQrCode")
    boleto: Optional[Boleto] = None
    automatic_pix: Optional[PaymentIntentAutomaticPix] = Field(default=None, alias="automaticPix")
    schedule: Optional[PaymentRequestSchedule] = None
    error_detail: Optional[PaymentRequestErrorDetail] = Field(default=None, alias="errorDetail")
    __properties: ClassVar[List[str]] = ["id", "amount", "fees", "description", "status", "clientPaymentId", "createdAt", "updatedAt", "callbackUrls", "recipientId", "paymentUrl", "pixQrCode", "boleto", "automaticPix", "schedule", "errorDetail"]

    @field_validator('status')
    def status_validate_enum(cls, value):
        """Validates the enum"""
        if value not in set(['CREATED', 'IN_PROGRESS', 'COMPLETED', 'SCHEDULED', 'WAITING_PAYER_AUTHORIZATION', 'ERROR', 'REFUND_IN_PROGRESS', 'REFUNDED', 'REFUND_ERROR', 'CANCELED']):
            raise ValueError("must be one of enum values ('CREATED', 'IN_PROGRESS', 'COMPLETED', 'SCHEDULED', 'WAITING_PAYER_AUTHORIZATION', 'ERROR', 'REFUND_IN_PROGRESS', 'REFUNDED', 'REFUND_ERROR', 'CANCELED')")
        return value

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of PaymentRequest from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of callback_urls
        if self.callback_urls:
            _dict['callbackUrls'] = self.callback_urls.to_dict()
        # override the default output from pydantic by calling `to_dict()` of boleto
        if self.boleto:
            _dict['boleto'] = self.boleto.to_dict()
        # override the default output from pydantic by calling `to_dict()` of automatic_pix
        if self.automatic_pix:
            _dict['automaticPix'] = self.automatic_pix.to_dict()
        # override the default output from pydantic by calling `to_dict()` of schedule
        if self.schedule:
            _dict['schedule'] = self.schedule.to_dict()
        # override the default output from pydantic by calling `to_dict()` of error_detail
        if self.error_detail:
            _dict['errorDetail'] = self.error_detail.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of PaymentRequest from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "id": obj.get("id"),
            "amount": obj.get("amount"),
            "fees": obj.get("fees"),
            "description": obj.get("description"),
            "status": obj.get("status"),
            "clientPaymentId": obj.get("clientPaymentId"),
            "createdAt": obj.get("createdAt"),
            "updatedAt": obj.get("updatedAt"),
            "callbackUrls": PaymentRequestCallbackUrls.from_dict(obj["callbackUrls"]) if obj.get("callbackUrls") is not None else None,
            "recipientId": obj.get("recipientId"),
            "paymentUrl": obj.get("paymentUrl"),
            "pixQrCode": obj.get("pixQrCode"),
            "boleto": Boleto.from_dict(obj["boleto"]) if obj.get("boleto") is not None else None,
            "automaticPix": PaymentIntentAutomaticPix.from_dict(obj["automaticPix"]) if obj.get("automaticPix") is not None else None,
            "schedule": PaymentRequestSchedule.from_dict(obj["schedule"]) if obj.get("schedule") is not None else None,
            "errorDetail": PaymentRequestErrorDetail.from_dict(obj["errorDetail"]) if obj.get("errorDetail") is not None else None
        })
        return _obj


