# coding: utf-8

"""
    Pluggy API

    Pluggy's main API to review data and execute connectors

    The version of the OpenAPI document: 1.0.0
    Contact: hello@pluggy.ai
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import json
import pprint
from pydantic import BaseModel, ConfigDict, Field, StrictStr, ValidationError, field_validator
from typing import Any, List, Optional
from pluggy_sdk.models.custom import CUSTOM
from pluggy_sdk.models.daily import DAILY
from pluggy_sdk.models.monthly import MONTHLY
from pluggy_sdk.models.single import SINGLE
from pluggy_sdk.models.weekly import WEEKLY
from pydantic import StrictStr, Field
from typing import Union, List, Set, Optional, Dict
from typing_extensions import Literal, Self

PAYMENTREQUESTSCHEDULE_ONE_OF_SCHEMAS = ["CUSTOM", "DAILY", "MONTHLY", "SINGLE", "WEEKLY"]

class PaymentRequestSchedule(BaseModel):
    """
    PaymentRequestSchedule
    """
    # data type: SINGLE
    oneof_schema_1_validator: Optional[SINGLE] = None
    # data type: DAILY
    oneof_schema_2_validator: Optional[DAILY] = None
    # data type: WEEKLY
    oneof_schema_3_validator: Optional[WEEKLY] = None
    # data type: MONTHLY
    oneof_schema_4_validator: Optional[MONTHLY] = None
    # data type: CUSTOM
    oneof_schema_5_validator: Optional[CUSTOM] = None
    actual_instance: Optional[Union[CUSTOM, DAILY, MONTHLY, SINGLE, WEEKLY]] = None
    one_of_schemas: Set[str] = { "CUSTOM", "DAILY", "MONTHLY", "SINGLE", "WEEKLY" }

    model_config = ConfigDict(
        validate_assignment=True,
        protected_namespaces=(),
    )


    discriminator_value_class_map: Dict[str, str] = {
    }

    def __init__(self, *args, **kwargs) -> None:
        if args:
            if len(args) > 1:
                raise ValueError("If a position argument is used, only 1 is allowed to set `actual_instance`")
            if kwargs:
                raise ValueError("If a position argument is used, keyword arguments cannot be used.")
            super().__init__(actual_instance=args[0])
        else:
            super().__init__(**kwargs)

    @field_validator('actual_instance')
    def actual_instance_must_validate_oneof(cls, v):
        instance = PaymentRequestSchedule.model_construct()
        error_messages = []
        match = 0
        # validate data type: SINGLE
        if not isinstance(v, SINGLE):
            error_messages.append(f"Error! Input type `{type(v)}` is not `SINGLE`")
        else:
            match += 1
        # validate data type: DAILY
        if not isinstance(v, DAILY):
            error_messages.append(f"Error! Input type `{type(v)}` is not `DAILY`")
        else:
            match += 1
        # validate data type: WEEKLY
        if not isinstance(v, WEEKLY):
            error_messages.append(f"Error! Input type `{type(v)}` is not `WEEKLY`")
        else:
            match += 1
        # validate data type: MONTHLY
        if not isinstance(v, MONTHLY):
            error_messages.append(f"Error! Input type `{type(v)}` is not `MONTHLY`")
        else:
            match += 1
        # validate data type: CUSTOM
        if not isinstance(v, CUSTOM):
            error_messages.append(f"Error! Input type `{type(v)}` is not `CUSTOM`")
        else:
            match += 1
        if match > 1:
            # more than 1 match
            raise ValueError("Multiple matches found when setting `actual_instance` in PaymentRequestSchedule with oneOf schemas: CUSTOM, DAILY, MONTHLY, SINGLE, WEEKLY. Details: " + ", ".join(error_messages))
        elif match == 0:
            # no match
            raise ValueError("No match found when setting `actual_instance` in PaymentRequestSchedule with oneOf schemas: CUSTOM, DAILY, MONTHLY, SINGLE, WEEKLY. Details: " + ", ".join(error_messages))
        else:
            return v

    @classmethod
    def from_dict(cls, obj: Union[str, Dict[str, Any]]) -> Self:
        return cls.from_json(json.dumps(obj))

    @classmethod
    def from_json(cls, json_str: str) -> Self:
        """Returns the object represented by the json string"""
        instance = cls.model_construct()
        error_messages = []
        match = 0

        # deserialize data into SINGLE
        try:
            instance.actual_instance = SINGLE.from_json(json_str)
            match += 1
        except (ValidationError, ValueError) as e:
            error_messages.append(str(e))
        # deserialize data into DAILY
        try:
            instance.actual_instance = DAILY.from_json(json_str)
            match += 1
        except (ValidationError, ValueError) as e:
            error_messages.append(str(e))
        # deserialize data into WEEKLY
        try:
            instance.actual_instance = WEEKLY.from_json(json_str)
            match += 1
        except (ValidationError, ValueError) as e:
            error_messages.append(str(e))
        # deserialize data into MONTHLY
        try:
            instance.actual_instance = MONTHLY.from_json(json_str)
            match += 1
        except (ValidationError, ValueError) as e:
            error_messages.append(str(e))
        # deserialize data into CUSTOM
        try:
            instance.actual_instance = CUSTOM.from_json(json_str)
            match += 1
        except (ValidationError, ValueError) as e:
            error_messages.append(str(e))

        if match > 1:
            # more than 1 match
            raise ValueError("Multiple matches found when deserializing the JSON string into PaymentRequestSchedule with oneOf schemas: CUSTOM, DAILY, MONTHLY, SINGLE, WEEKLY. Details: " + ", ".join(error_messages))
        elif match == 0:
            # no match
            raise ValueError("No match found when deserializing the JSON string into PaymentRequestSchedule with oneOf schemas: CUSTOM, DAILY, MONTHLY, SINGLE, WEEKLY. Details: " + ", ".join(error_messages))
        else:
            return instance

    def to_json(self) -> str:
        """Returns the JSON representation of the actual instance"""
        if self.actual_instance is None:
            return "null"

        if hasattr(self.actual_instance, "to_json") and callable(self.actual_instance.to_json):
            return self.actual_instance.to_json()
        else:
            return json.dumps(self.actual_instance)

    def to_dict(self) -> Optional[Union[Dict[str, Any], CUSTOM, DAILY, MONTHLY, SINGLE, WEEKLY]]:
        """Returns the dict representation of the actual instance"""
        if self.actual_instance is None:
            return None

        if hasattr(self.actual_instance, "to_dict") and callable(self.actual_instance.to_dict):
            return self.actual_instance.to_dict()
        else:
            # primitive type
            return self.actual_instance

    def to_str(self) -> str:
        """Returns the string representation of the actual instance"""
        return pprint.pformat(self.model_dump())


