# coding: utf-8

"""
    Pluggy API

    Pluggy's main API to review data and execute connectors

    The version of the OpenAPI document: 1.0.0
    Contact: hello@pluggy.ai
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from pydantic import BaseModel, ConfigDict, Field, StrictFloat, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Optional, Union
from pluggy_sdk.models.payroll_loan_response_client import PayrollLoanResponseClient
from typing import Optional, Set
from typing_extensions import Self

class PayrollLoanResponse(BaseModel):
    """
    Response with information related to a payload loan
    """ # noqa: E501
    id: StrictStr = Field(description="Primary identifier")
    item_id: StrictStr = Field(description="Identifier of the item linked to the loan", alias="itemId")
    contract_code: Optional[StrictStr] = Field(default=None, description="Contract code given by the contracting institution", alias="contractCode")
    cnpj_original_contract_creditor: Optional[StrictStr] = Field(default=None, description="CNPJ of the original creditor of the contract", alias="cnpjOriginalContractCreditor")
    nominal_interest_rate: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, description="Nominal interest rate", alias="nominalInterestRate")
    efective_interest_rate: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, description="Effective interest rate", alias="efectiveInterestRate")
    cet_annual_rate: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, description="CET annual rate", alias="cetAnnualRate")
    cet_month_rate: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, description="CET monthly rate", alias="cetMonthRate")
    currency_code: StrictStr = Field(description="Code referencing the currency of the loan", alias="currencyCode")
    amortization_regime: StrictStr = Field(description="Amortization regime", alias="amortizationRegime")
    installments_quantity: Union[StrictFloat, StrictInt] = Field(description="Number of installments", alias="installmentsQuantity")
    installments_value: Union[StrictFloat, StrictInt] = Field(description="Installment value", alias="installmentsValue")
    due_date_first_installment: datetime = Field(description="Due date of the first installment", alias="dueDateFirstInstallment")
    due_date_last_installment: datetime = Field(description="Due date of the last installment", alias="dueDateLastInstallment")
    cnpj_correspondent_banking: Optional[StrictStr] = Field(default=None, description="CNPJ of the correspondent banking", alias="cnpjCorrespondentBanking")
    operation_hiring_date: datetime = Field(description="Operation hiring date", alias="operationHiringDate")
    client: PayrollLoanResponseClient
    __properties: ClassVar[List[str]] = ["id", "itemId", "contractCode", "cnpjOriginalContractCreditor", "nominalInterestRate", "efectiveInterestRate", "cetAnnualRate", "cetMonthRate", "currencyCode", "amortizationRegime", "installmentsQuantity", "installmentsValue", "dueDateFirstInstallment", "dueDateLastInstallment", "cnpjCorrespondentBanking", "operationHiringDate", "client"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of PayrollLoanResponse from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of client
        if self.client:
            _dict['client'] = self.client.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of PayrollLoanResponse from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "id": obj.get("id"),
            "itemId": obj.get("itemId"),
            "contractCode": obj.get("contractCode"),
            "cnpjOriginalContractCreditor": obj.get("cnpjOriginalContractCreditor"),
            "nominalInterestRate": obj.get("nominalInterestRate"),
            "efectiveInterestRate": obj.get("efectiveInterestRate"),
            "cetAnnualRate": obj.get("cetAnnualRate"),
            "cetMonthRate": obj.get("cetMonthRate"),
            "currencyCode": obj.get("currencyCode"),
            "amortizationRegime": obj.get("amortizationRegime"),
            "installmentsQuantity": obj.get("installmentsQuantity"),
            "installmentsValue": obj.get("installmentsValue"),
            "dueDateFirstInstallment": obj.get("dueDateFirstInstallment"),
            "dueDateLastInstallment": obj.get("dueDateLastInstallment"),
            "cnpjCorrespondentBanking": obj.get("cnpjCorrespondentBanking"),
            "operationHiringDate": obj.get("operationHiringDate"),
            "client": PayrollLoanResponseClient.from_dict(obj["client"]) if obj.get("client") is not None else None
        })
        return _obj


