# coding: utf-8

"""
    Pluggy API

    Pluggy's main API to review data and execute connectors

    The version of the OpenAPI document: 1.0.0
    Contact: hello@pluggy.ai
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from datetime import date
from pydantic import BaseModel, ConfigDict, Field, StrictStr, field_validator
from typing import Any, ClassVar, Dict, List, Optional
from pluggy_sdk.models.schedule_payment_error_detail import SchedulePaymentErrorDetail
from typing import Optional, Set
from typing_extensions import Self

class SchedulePayment(BaseModel):
    """
    Information of a schedule payment
    """ # noqa: E501
    id: StrictStr
    description: StrictStr = Field(description="Scheduled payment description")
    status: StrictStr = Field(description="Scheduled payment status")
    scheduled_date: date = Field(description="Date when the payment is scheduled", alias="scheduledDate")
    end_to_end_id: Optional[StrictStr] = Field(default=None, description="Identifier for the payment, used to link the scheduled payment with the corresponding payment received", alias="endToEndId")
    error_detail: Optional[SchedulePaymentErrorDetail] = Field(default=None, alias="errorDetail")
    __properties: ClassVar[List[str]] = ["id", "description", "status", "scheduledDate", "endToEndId", "errorDetail"]

    @field_validator('status')
    def status_validate_enum(cls, value):
        """Validates the enum"""
        if value not in set(['SCHEDULED', 'COMPLETED', 'ERROR']):
            raise ValueError("must be one of enum values ('SCHEDULED', 'COMPLETED', 'ERROR')")
        return value

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of SchedulePayment from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of error_detail
        if self.error_detail:
            _dict['errorDetail'] = self.error_detail.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of SchedulePayment from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "id": obj.get("id"),
            "description": obj.get("description"),
            "status": obj.get("status"),
            "scheduledDate": obj.get("scheduledDate"),
            "endToEndId": obj.get("endToEndId"),
            "errorDetail": SchedulePaymentErrorDetail.from_dict(obj["errorDetail"]) if obj.get("errorDetail") is not None else None
        })
        return _obj


