# coding: utf-8

"""
    Pluggy API

    Pluggy's main API to review data and execute connectors

    The version of the OpenAPI document: 1.0.0
    Contact: hello@pluggy.ai
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from pydantic import BaseModel, ConfigDict, Field, StrictStr, field_validator
from typing import Any, ClassVar, Dict, List, Optional
from pluggy_sdk.models.connector import Connector
from pluggy_sdk.models.payment_recipient import PaymentRecipient
from pluggy_sdk.models.smart_transfer_callback_urls import SmartTransferCallbackUrls
from typing import Optional, Set
from typing_extensions import Self

class SmartTransferPreauthorization(BaseModel):
    """
    Smart transfer preauthorization
    """ # noqa: E501
    id: StrictStr = Field(description="Preauthorization primary identifier")
    status: StrictStr = Field(description="Preauthorization status")
    consent_url: Optional[StrictStr] = Field(default=None, description="Url to give the consent in the institution", alias="consentUrl")
    client_preauthorization_id: Optional[StrictStr] = Field(default=None, description="Client preauthorization identifier", alias="clientPreauthorizationId")
    callback_urls: Optional[SmartTransferCallbackUrls] = Field(default=None, alias="callbackUrls")
    recipients: List[PaymentRecipient]
    connector: Connector
    created_at: datetime = Field(description="Date when the preauthorization was created", alias="createdAt")
    updated_at: datetime = Field(description="Date when the preauthorization was updated", alias="updatedAt")
    __properties: ClassVar[List[str]] = ["id", "status", "consentUrl", "clientPreauthorizationId", "callbackUrls", "recipients", "connector", "createdAt", "updatedAt"]

    @field_validator('status')
    def status_validate_enum(cls, value):
        """Validates the enum"""
        if value not in set(['CREATED', 'COMPLETED', 'REVOKED', 'REJECTED', 'ERROR']):
            raise ValueError("must be one of enum values ('CREATED', 'COMPLETED', 'REVOKED', 'REJECTED', 'ERROR')")
        return value

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of SmartTransferPreauthorization from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of callback_urls
        if self.callback_urls:
            _dict['callbackUrls'] = self.callback_urls.to_dict()
        # override the default output from pydantic by calling `to_dict()` of each item in recipients (list)
        _items = []
        if self.recipients:
            for _item_recipients in self.recipients:
                if _item_recipients:
                    _items.append(_item_recipients.to_dict())
            _dict['recipients'] = _items
        # override the default output from pydantic by calling `to_dict()` of connector
        if self.connector:
            _dict['connector'] = self.connector.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of SmartTransferPreauthorization from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "id": obj.get("id"),
            "status": obj.get("status"),
            "consentUrl": obj.get("consentUrl"),
            "clientPreauthorizationId": obj.get("clientPreauthorizationId"),
            "callbackUrls": SmartTransferCallbackUrls.from_dict(obj["callbackUrls"]) if obj.get("callbackUrls") is not None else None,
            "recipients": [PaymentRecipient.from_dict(_item) for _item in obj["recipients"]] if obj.get("recipients") is not None else None,
            "connector": Connector.from_dict(obj["connector"]) if obj.get("connector") is not None else None,
            "createdAt": obj.get("createdAt"),
            "updatedAt": obj.get("updatedAt")
        })
        return _obj


