# coding: utf-8

"""
    Pluggy API

    Pluggy's main API to review data and execute connectors

    The version of the OpenAPI document: 1.0.0
    Contact: hello@pluggy.ai
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field
from typing import Any, ClassVar, Dict, List, Optional
from pluggy_sdk.models.status_detail_product import StatusDetailProduct
from typing import Optional, Set
from typing_extensions import Self

class StatusDetail(BaseModel):
    """
    Detailed status of the item. This field will be present when the status is PARTIAL_SUCCESS or when a product in the item has warnings
    """ # noqa: E501
    accounts: Optional[StatusDetailProduct] = None
    credit_cards: Optional[StatusDetailProduct] = Field(default=None, alias="creditCards")
    transactions: Optional[StatusDetailProduct] = None
    investments: Optional[StatusDetailProduct] = None
    identity: Optional[StatusDetailProduct] = None
    investments_transactions: Optional[StatusDetailProduct] = Field(default=None, alias="investmentsTransactions")
    payment_data: Optional[StatusDetailProduct] = Field(default=None, alias="paymentData")
    loans: Optional[StatusDetailProduct] = None
    __properties: ClassVar[List[str]] = ["accounts", "creditCards", "transactions", "investments", "identity", "investmentsTransactions", "paymentData", "loans"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of StatusDetail from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of accounts
        if self.accounts:
            _dict['accounts'] = self.accounts.to_dict()
        # override the default output from pydantic by calling `to_dict()` of credit_cards
        if self.credit_cards:
            _dict['creditCards'] = self.credit_cards.to_dict()
        # override the default output from pydantic by calling `to_dict()` of transactions
        if self.transactions:
            _dict['transactions'] = self.transactions.to_dict()
        # override the default output from pydantic by calling `to_dict()` of investments
        if self.investments:
            _dict['investments'] = self.investments.to_dict()
        # override the default output from pydantic by calling `to_dict()` of identity
        if self.identity:
            _dict['identity'] = self.identity.to_dict()
        # override the default output from pydantic by calling `to_dict()` of investments_transactions
        if self.investments_transactions:
            _dict['investmentsTransactions'] = self.investments_transactions.to_dict()
        # override the default output from pydantic by calling `to_dict()` of payment_data
        if self.payment_data:
            _dict['paymentData'] = self.payment_data.to_dict()
        # override the default output from pydantic by calling `to_dict()` of loans
        if self.loans:
            _dict['loans'] = self.loans.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of StatusDetail from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "accounts": StatusDetailProduct.from_dict(obj["accounts"]) if obj.get("accounts") is not None else None,
            "creditCards": StatusDetailProduct.from_dict(obj["creditCards"]) if obj.get("creditCards") is not None else None,
            "transactions": StatusDetailProduct.from_dict(obj["transactions"]) if obj.get("transactions") is not None else None,
            "investments": StatusDetailProduct.from_dict(obj["investments"]) if obj.get("investments") is not None else None,
            "identity": StatusDetailProduct.from_dict(obj["identity"]) if obj.get("identity") is not None else None,
            "investmentsTransactions": StatusDetailProduct.from_dict(obj["investmentsTransactions"]) if obj.get("investmentsTransactions") is not None else None,
            "paymentData": StatusDetailProduct.from_dict(obj["paymentData"]) if obj.get("paymentData") is not None else None,
            "loans": StatusDetailProduct.from_dict(obj["loans"]) if obj.get("loans") is not None else None
        })
        return _obj


